var ct = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var portRes = win.portRes;
var isR1C03 = false;
var isR3C03 = false;
var thisneversion = win.winobj.neversion;
var versionArr = thisneversion.split(".");
if( versionArr[2] == "01" && versionArr[3] >= "30" )
{
	isR1C03 = true;
}
if( (versionArr[2] + "." + versionArr[3]) >= "03.40" && (versionArr[2] + "." + versionArr[3]) <= "05.10")
{
	isR3C03 = true;
}
var INVALID_SLOT = 0xFFFF;

var isSupportPirEditFlag = isSupportPirEdit();

function isSupportPirEdit()
{
	return SpecialAttrMgr.isNESupport(neid, "TE_FUNC_CFG_TUNNEL", "TE_ATTR_SUPPORT_TUNNEL_PIR_EDIT");
}

function init()
{
    initTable();
    initText();
    fillBoard("outboard");
    changeBoard("outboard", "inboard", "outport", "inport");
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["positivevalue"], RESOURCE["negativevalue"]);
    $("tbdiv").appendChild(ct.getTable());
    
    var atom1 = new Atom("text");
    checkText(atom1.element, "1", "65535");
    ct.addAttrRow("tunnelid", RESOURCE["tunnelid"], atom1);
    
    atom1 = new Atom("text");
    checkTextData(atom1.element, 64);
    ct.addAttrRow("tunnelname", RESOURCE["tunnelname"], atom1);
    
    atom1 = new Atom("select");
    atom1.addOption(RESOURCE["ingress"], 1);
    atom1.addOption(RESOURCE["transit"], 2);
    atom1.addOption(RESOURCE["egress"], 3);
    atom1.element.onchange = changeNodeType;
    ct.addAttrRow("nodetype", RESOURCE["nodetype"], atom1);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.addOption(RESOURCE["bidirectional"], 1);
    ct.addAttrRow("direction", RESOURCE["direction"], atom1);
    
    atom1 = new Atom("combobox");
    ct.addAttrRow("bandwidth", RESOURCE["cir"], atom1);
    
    atom1.element.parent.initComboBox(getDataArr(), "dm0", 17, true);
    atom1.element.parent.txtview.onkeypress = keypressHandler;
    atom1.element.parent.txtview.onkeyup = keyupHandler;
    atom1.element.parent.txtview.onblur = onblurHandler;
    atom1.element.parent.txtview.style.imeMode = "disabled";
    atom1.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    atom1 = new Atom("combobox");
    ct.addAttrRow("pir", RESOURCE["pir"], atom1);
    
    atom1.element.parent.initComboBox(getDataArr(), "dm0", 17, true);
    atom1.element.parent.txtview.onkeypress = keypressHandler;
    atom1.element.parent.txtview.onkeyup = keyupHandler;
    atom1.element.parent.txtview.onblur = onblurHandler;
    atom1.element.parent.txtview.style.imeMode = "disabled";
    atom1.element.parent.txtview.onpaste = function()
    {
        return false;
    };
    
    if(!isSupportPirEditFlag)
    {
    	atom1.element.parent.selview.disabled = true;
        atom1.element.parent.txtview.disabled = true;
    	addOptionToSelect(atom1.element.parent.selview, new Option("-", "-"));
    	atom1.element.parent.setSelectedIndex(18);
    }
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    ct.addAttrRow("cbs", RESOURCE["cbs"], atom1);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    ct.addAttrRow("pbs", RESOURCE["pbs"], atom1);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.element.onchange = function()
    {
        changeBoard("inboard", "outboard", "inport", "outport");
    };
    ct.addAttrRow("inboard", RESOURCE["inboard"], atom1);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    ct.addAttrRow("inport", RESOURCE["inport"], atom1);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    checkText(atom1.element, "16", "1048575");
    ct.addAttrRow("positiveinlabel", RESOURCE["positiveinlabel"], atom1);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    checkText(atom1.element, "16", "1048575");
    ct.addAttrRow("negativeoutlabel", RESOURCE["negativeoutlabel"], atom1);
    
    atom1 = new Atom("select");
    atom1.element.onchange = function()
    {
        changeBoard("outboard", "inboard", "outport", "inport");
    };
    ct.addAttrRow("outboard", RESOURCE["outboard"], atom1);
    
    atom1 = new Atom("select");
    ct.addAttrRow("outport", RESOURCE["outport"], atom1);
    
    atom1 = new Atom("text");
    checkText(atom1.element, "16", "1048575");
    ct.addAttrRow("positiveoutlabel", RESOURCE["positiveoutlabel"], atom1);
    
    atom1 = new Atom("text");
    checkText(atom1.element, "16", "1048575");
    ct.addAttrRow("negativeinlabel", RESOURCE["negativeinlabel"], atom1);
    
    atom1 = new Atom("text");
    validateIp(atom1.element);
    ct.addAttrRow("positivenexthopaddr", RESOURCE["positivenexthopaddr"], atom1);
    
    atom1 = new Atom("text");
    atom1.setValue("-");
    validateIp(atom1.element);
    atom1.element.disabled = true;
    ct.addAttrRow("negativenexthopaddr", RESOURCE["negativenexthopaddr"], atom1);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    validateNode(atom1.element, false, "snknode");
    ct.addAttrRow("srcnode", RESOURCE["srcnode"], atom1);
    
    atom1 = new Atom("text");
    validateNode(atom1.element, false, "srcnode");
    ct.addAttrRow("snknode", RESOURCE["snknode"], atom1);
    
    atom1 = new Atom("select");
    atom1.element.onchange = function()
    {
        tunneltypeChanged();
    };
    atom1.addOption(RESOURCE["elsp"], 0);
	var notSupport = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_CFG_PTN_MPLSTUNNEL_P2P","TUNNEL_ATTR_NOTSUPPORT_LLSP");
    if (!isR1C03 && !isR3C03 && !notSupport) 
	{
		atom1.addOption(RESOURCE["llsp"], 1);
	}
    ct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom1);
    
    atom1 = new Atom("select");
    atom1.addOption(RESOURCE["exp0"], 0);
    atom1.addOption(RESOURCE["exp1"], 1);
    atom1.addOption(RESOURCE["exp2"], 2);
    atom1.addOption(RESOURCE["exp3"], 3);
    atom1.addOption(RESOURCE["exp4"], 4);
    atom1.addOption(RESOURCE["exp5"], 5);
    atom1.addOption(RESOURCE["exp6"], 6);
    atom1.addOption(RESOURCE["exp7"], 7);
    atom1.addOption(RESOURCE["exp255"], 255);
    atom1.element.options.selectedIndex = 8;
    ct.addAttrRow("exp", RESOURCE["exp"], atom1);
    
    atom1 = new Atom("select");
    if(isAfterRTN900R5C01())
    {
        atom1.addOption(RESOURCE["lspmode_2"], 2);
    } else {
        atom1.element.disabled = true;
        atom1.addOption("-", "-");
    }
    ct.addAttrRow("lspmode", RESOURCE["lspmode"], atom1);
    
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
    ct.addAttrRow("mtu", "MTU", atom1);
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
	atom1.addOption("-", "-");
	ct.addAttrRow("cos", "CoS", atom1);
}


function tunneltypeChanged()
{
	 switch (parseInt(ct.getAtom("tunneltype", 0).element.value))
	 {
	 	 case 0:
	 	 {
	 	 	 var atom1 = ct.getAtom("cos", 0);
	 	 	 atom1.element.options.length = 0;
	 	 	 atom1.addOption("-", "-");
	 	 	 atom1.element.disabled = true;
             break;
	 	 }
	 	 
	 	 case 1:
	 	 {
	 	 	 atom1 = ct.getAtom("cos", 0);
	 	 	 atom1.element.options.length = 0;
	 	 	 atom1.addOption("BE", "1");
	 	 	 atom1.addOption("AF1", "2");
	 	 	 atom1.addOption("AF2", "3");
	 	 	 atom1.addOption("AF3", "4");
	 	 	 atom1.addOption("AF4", "5");
	 	 	 atom1.addOption("EF", "6");
	 	 	 atom1.addOption("CS6", "7");
	 	 	 atom1.addOption("CS7", "8");
	 	 	 atom1.element.disabled = false;
             break;
	 	 }
	 }
}

function initText()
{
    
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    $("copybtn").value = RESOURCE["copybutton"];
}


function setComboboxStyle(index)
{
    var elem = ct.getAtom("bandwidth", index).element.parent;
    var wdt = elem.view.parentNode.offsetWidth - 2;
    var clip = "rect(1px," + (wdt - 1) + "px,19px," + (wdt - 18) + "px)";
    
    elem.txtview.style.width = wdt;
    elem.selview.style.width = wdt;
    elem.selview.style.clip = clip;
    
    var elempir = ct.getAtom("pir", index).element.parent;
    var wdtpir = elempir.view.parentNode.offsetWidth - 2;
    var clippir = "rect(1px," + (wdtpir - 1) + "px,19px," + (wdtpir - 18) + "px)";
    
    elempir.txtview.style.width = wdtpir;
    elempir.selview.style.width = wdtpir;
    elempir.selview.style.clip = clippir;
}

function changeNodeType()
{
    var atom = null;
    var tmpAtom = null;
    var selView = null;
    var sIndex = -1;
    var option = null;
    switch (parseInt(this.value))
    {
        case NODE_TYPE_INGRESS:
            atom = ct.getAtom("bandwidth");
            selView = atom.element.parent.selview;
            if (selView.disabled) 
            {
                selView.disabled = false;
                atom.element.parent.txtview.disabled = false;
                
                selView.options.length -= 1;
                atom.element.parent.setSelectedIndex(17);
            }
            
            if(isSupportPirEditFlag)
            {
	            atom = ct.getAtom("pir");
	            selView = atom.element.parent.selview;
	            if (selView.disabled) 
	            {
	                selView.disabled = false;
	                atom.element.parent.txtview.disabled = false;
	                
	                selView.options.length -= 1;
	                atom.element.parent.setSelectedIndex(17);
	            }
            }
            else
            {
                atom = ct.getAtom("pir");
                selView = atom.element.parent.selview;
                if (!selView.disabled) 
                {
                    selView.disabled = true;
                    atom.element.parent.txtview.disabled = true;
                    
                    addOptionToSelect(selView, new Option("-", "-"));
                    atom.element.parent.setSelectedIndex(18);
                }
            }
            
            atom = ct.getAtom("inboard");
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("inport");
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("positiveinlabel");
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("negativeoutlabel");
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("outboard");
            fillBoard("outboard");
            changeBoard("outboard", "inboard", "outport", "inport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("positiveoutlabel");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("negativeinlabel");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("positivenexthopaddr");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("negativenexthopaddr");
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("srcnode");
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("snknode");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("exp");
            if (atom.element.disabled) 
            {
            	atom.element.disabled = false;
            	atom.element.options.length = 0;
                atom.addOption(RESOURCE["exp0"], 0);
   			    atom.addOption(RESOURCE["exp1"], 1);
                atom.addOption(RESOURCE["exp2"], 2);
                atom.addOption(RESOURCE["exp3"], 3);
                atom.addOption(RESOURCE["exp4"], 4);
                atom.addOption(RESOURCE["exp5"], 5);
                atom.addOption(RESOURCE["exp6"], 6);
                atom.addOption(RESOURCE["exp7"], 7);
                atom.addOption(RESOURCE["exp255"], 255);
                atom.element.options.selectedIndex = 8;
            }
            
            atom = ct.getAtom("lspmode");
   	    atom.element.options.length = 0;
   	    if(isAfterRTN900R5C01())
            {
                atom.addOption(RESOURCE["lspmode_2"], 2);
                atom.element.disabled = false;
            } else {
   	        atom.addOption("-", 0);
   	        atom.element.disabled = true;
   	    }
            atom.element.options.selectedIndex = atom.element.options.length - 1;
            
            break;
            
        case NODE_TYPE_TRANSIT:
            atom = ct.getAtom("bandwidth");
            selView = atom.element.parent.selview;
            if (selView.disabled) 
            {
                selView.disabled = false;
                atom.element.parent.txtview.disabled = false;
                
                selView.options.length -= 1;
                atom.element.parent.setSelectedIndex(17);
            }
            
            if(isSupportPirEditFlag)
            {
	            atom = ct.getAtom("pir");
	            selView = atom.element.parent.selview;
	            if (selView.disabled) 
	            {
	                selView.disabled = false;
	                atom.element.parent.txtview.disabled = false;
	                
	                selView.options.length -= 1;
	                atom.element.parent.setSelectedIndex(17);
	            }
            }
            else
            {
                atom = ct.getAtom("pir");
                selView = atom.element.parent.selview;
                if (!selView.disabled) 
                {
                    selView.disabled = true;
                    atom.element.parent.txtview.disabled = true;
                    
                    addOptionToSelect(selView, new Option("-", "-"));
                    atom.element.parent.setSelectedIndex(18);
                }
            }
            
            atom = ct.getAtom("inboard");
            fillBoard("inboard");
            changeBoard("inboard", "outboard", "inport", "outport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("inport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("positiveinlabel");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("negativeoutlabel");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outboard");
            fillBoard("outboard");
            changeBoard("outboard", "inboard", "outport", "inport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("positiveoutlabel");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("negativeinlabel");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("positivenexthopaddr");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("negativenexthopaddr");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("srcnode");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("snknode");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("exp");
            if (!atom.element.disabled) 
            {
                atom.addOption("-", 0);
                atom.element.options.selectedIndex = atom.element.options.length - 1;
                atom.element.disabled = true;
            }
            

            atom = ct.getAtom("lspmode");
            atom.element.options.length = 0;
            atom.addOption("-", 0);
            atom.element.options.selectedIndex = atom.element.options.length - 1;
            atom.element.disabled = true;
            break;
            
        case NODE_TYPE_EGRESS:

        		atom = ct.getAtom("bandwidth");
                selView = atom.element.parent.selview;
                if (selView.disabled) 
                {
                    selView.disabled = false;
                    atom.element.parent.txtview.disabled = false;
                    
                    selView.options.length -= 1;
                    atom.element.parent.setSelectedIndex(17);
                }
        	
                if(isSupportPirEditFlag)
                {
    	            atom = ct.getAtom("pir");
    	            selView = atom.element.parent.selview;
    	            if (selView.disabled) 
    	            {
    	                selView.disabled = false;
    	                atom.element.parent.txtview.disabled = false;
    	                
    	                selView.options.length -= 1;
    	                atom.element.parent.setSelectedIndex(17);
    	            }
                }
                else
                {
                    atom = ct.getAtom("pir");
                    selView = atom.element.parent.selview;
                    if (!selView.disabled) 
                    {
                        selView.disabled = true;
                        atom.element.parent.txtview.disabled = true;
                        
                        addOptionToSelect(selView, new Option("-", "-"));
                        atom.element.parent.setSelectedIndex(18);
                    }
                }
            
            atom = ct.getAtom("inboard");
            fillBoard("inboard");
            changeBoard("inboard", "outboard", "inport", "outport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("inport");
            atom.element.disabled = false;
            
            atom = ct.getAtom("positiveinlabel");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("negativeoutlabel");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("outboard");
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("outport");
            atom.element.options.length = 0;
            atom.element.disabled = true;
            
            atom = ct.getAtom("positiveoutlabel");
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("negativeinlabel");
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("positivenexthopaddr");
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("negativenexthopaddr");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("srcnode");
            atom.setValue("");
            atom.element.disabled = false;
            
            atom = ct.getAtom("snknode");
            atom.setValue("-");
            atom.element.disabled = true;
            
            atom = ct.getAtom("exp");
            if (atom.element.disabled) 
            {
            	atom.element.disabled = false;
            	atom.element.options.length = 0;
                atom.addOption(RESOURCE["exp0"], 0);
   			    atom.addOption(RESOURCE["exp1"], 1);
                atom.addOption(RESOURCE["exp2"], 2);
                atom.addOption(RESOURCE["exp3"], 3);
                atom.addOption(RESOURCE["exp4"], 4);
                atom.addOption(RESOURCE["exp5"], 5);
                atom.addOption(RESOURCE["exp6"], 6);
                atom.addOption(RESOURCE["exp7"], 7);
                atom.addOption(RESOURCE["exp255"], 255);
                atom.element.options.selectedIndex = 8;
            }
            
            atom = ct.getAtom("lspmode");
            atom.element.options.length = 0;
            
            if(isAfterRTN900R5C01())
            {
                atom.addOption(RESOURCE["lspmode_2"], 2);
                atom.element.disabled = false;
            } else {			    
   	        
   		atom.addOption("-", 0);
                atom.element.disabled = true;
            }
            atom.element.options.selectedIndex = atom.element.options.length - 1;
            break;
        default:
            break;
    }
}

function changeBoard(b1, b2, p1, p2)
{
    var atom = ct.getAtom(b1);
    var index = atom.element.options.selectedIndex;
    if (index < 0) 
    {
        return;
    }
    var option = atom.element.options[index];
    var slotId = option.value;
    var board = option.text;
    
    var bdName = null;
    atom = ct.getAtom(p1);
    atom.element.options.length = 0;
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        bdName = portObj.boardName;
        if (parseInt(portObj.slotId) != INVALID_SLOT) 
        {
            bdName = portObj.slotId + "-" + bdName;
        }
        if (board == bdName) 
        {
            atom.addOption(portObj.portName, portObj.portId);
        }
    }
}

function fillBoard(board)
{
    var atom = ct.getAtom(board);
    atom.element.options.length = 0;
    
    var portObj = null;
    var bdName = null;
    var tmpArr = new Array();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        bdName = portObj.boardName;
        if (parseInt(portObj.slotId) != INVALID_SLOT) 
        {
            bdName = portObj.slotId + "-" + bdName;
        }
        
        if (!tmpArr.contains(bdName)) 
        {
            tmpArr[tmpArr.length] = bdName;
            atom.addOption(bdName, portObj.slotId);
        }
    }
}

function validate()
{
    var atom = ct.getAtom("tunnelid");
    var v = atom.getValue().trim();
    if (v == "") 
    {
        alert(RESOURCE["inputtunnelid"]);
        return false;
    }
    atom = ct.getAtom("positiveinlabel");
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputinlabel"]);
        return false;
    }
    atom = ct.getAtom("negativeinlabel");
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputinlabel"]);
        return false;
    }
    atom = ct.getAtom("negativeoutlabel");
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputoutlabel"]);
        return false;
    }
    atom = ct.getAtom("positiveoutlabel");
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputoutlabel"]);
        return false;
    }
    
    atom = ct.getAtom("positivenexthopaddr");
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputhopaddr"]);
            return false;
        }
    }
    
    atom = ct.getAtom("negativenexthopaddr");
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputhopaddr"]);
            return false;
        }
    }
    
    atom = ct.getAtom("srcnode");
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsrcnode"]);
            return false;
        }
    }
    
    atom = ct.getAtom("snknode");
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsnknode"]);
            return false;
        }
    }
    
    return true;
}

function createTunnelXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("auto", 1));
    rowparams.appendChild(createTagElement("autoassign", 2));
    rowparams.appendChild(createTagElement("tunnelindex", 0));
    rowparams.appendChild(createTagElement("tunnelid", ct.getAtom("tunnelid").getValue()));
    var tunnelName = ct.getAtom("tunnelname").getValue().trim();
    if (tunnelName != "") 
    {
        rowparams.appendChild(createTagElement("name", tunnelName));
    }
    rowparams.appendChild(createTagElement("direction", ct.getAtom("direction").getValue()));
	var tunneltype = parseInt(ct.getAtom("tunneltype").getValue());
	rowparams.appendChild(createTagElement("tunneltype", tunneltype));
    if(0 == tunneltype)
	{
		rowparams.appendChild(createTagElement("cos", 255));//   e-lsp,    (0xFF)
	}
	else if(1 == tunneltype)
	{
		rowparams.appendChild(createTagElement("cos", ct.getAtom("cos").getValue()));//   e-lsp,1 be,2 af1,3 af2,4 af3,5 af4,6 ef,7 cs6,8 cs7
	}
    var nodeType = parseInt(ct.getAtom("nodetype").getValue());
    rowparams.appendChild(createTagElement("nodetype", nodeType));
    
    var slotId = -1;
    var atom = null;
    var bandwidth = ct.getAtom("bandwidth").getValue();
    var pir = ct.getAtom("pir").getValue();
    var srcNode = ct.getAtom("srcnode").getValue();
    var snkNode = ct.getAtom("snknode").getValue();
    var iOptions = ct.getAtom("inboard").element.options;
    var oOptions = ct.getAtom("outboard").element.options;
    switch (nodeType)
    {
        case NODE_TYPE_INGRESS:
            rowparams.appendChild(createTagElement("bw", bandwidth));
            rowparams.appendChild(createTagElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            if(!isSupportPirEditFlag)
            {
				rowparams.appendChild(createTagElement("pirbandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            }
            else
            {
            	rowparams.appendChild(createTagElement("pirbandwidth", isNaN(pir) ? 0 : pir));
            }
            rowparams.appendChild(createTagElement("insubslotid", 0));
            slotId = parseInt(oOptions[oOptions.selectedIndex].value);
            if (INVALID_SLOT != slotId) 
            {
                rowparams.appendChild(createTagElement("outboardname", oOptions[oOptions.selectedIndex].text));
            }
            rowparams.appendChild(createTagElement("outslotid", slotId));
            atom = ct.getAtom("outport");
            rowparams.appendChild(createTagElement("outportname", atom.element.options[atom.element.options.selectedIndex].text));
            rowparams.appendChild(createTagElement("outport", atom.getValue()));
            rowparams.appendChild(createTagElement("outlabel", ct.getAtom("positiveoutlabel").getValue())); //     
            rowparams.appendChild(createTagElement("rinlabel", ct.getAtom("negativeinlabel").getValue())); //     
            var positivenexthopaddr = ct.getAtom("positivenexthopaddr").getValue();//       
            rowparams.appendChild(createTagElement("nexthopaddr", parseInt("0x" + convertIpaddrToHexcode(positivenexthopaddr))));
            rowparams.appendChild(createTagElement("sinknode", snkNode));
            rowparams.appendChild(createTagElement("snknode", parseInt("0x" + convertIpaddrToHexcode(snkNode))));
            rowparams.appendChild(createTagElement("exp", ct.getAtom("exp").getValue()));
            break;
        case NODE_TYPE_TRANSIT:
            rowparams.appendChild(createTagElement("bw", bandwidth));
            rowparams.appendChild(createTagElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            if(!isSupportPirEditFlag)
            {
				rowparams.appendChild(createTagElement("pirbandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            }
            else
            {
            	rowparams.appendChild(createTagElement("pirbandwidth", isNaN(pir) ? 0 : pir));
            }
            slotId = parseInt(iOptions[iOptions.selectedIndex].value);
            if (INVALID_SLOT != slotId) 
            {
                rowparams.appendChild(createTagElement("inboardname", iOptions[iOptions.selectedIndex].text));
            }
            rowparams.appendChild(createTagElement("inslotid", slotId));
            atom = ct.getAtom("inport");
            rowparams.appendChild(createTagElement("inportname", atom.element.options[atom.element.options.selectedIndex].text));
            rowparams.appendChild(createTagElement("inport", atom.getValue()));
            rowparams.appendChild(createTagElement("inlabel", ct.getAtom("positiveinlabel").getValue())); //     
            rowparams.appendChild(createTagElement("routlabel", ct.getAtom("negativeoutlabel").getValue())); //     
            rowparams.appendChild(createTagElement("outlabel", ct.getAtom("positiveoutlabel").getValue())); //     
            rowparams.appendChild(createTagElement("rinlabel", ct.getAtom("negativeinlabel").getValue())); //     
            slotId = parseInt(oOptions[oOptions.selectedIndex].value);
            if (INVALID_SLOT != slotId) 
            {
                rowparams.appendChild(createTagElement("outboardname", oOptions[oOptions.selectedIndex].text));
            }
            rowparams.appendChild(createTagElement("outslotid", slotId));
            atom = ct.getAtom("outport");
            rowparams.appendChild(createTagElement("outportname", atom.element.options[atom.element.options.selectedIndex].text));
            rowparams.appendChild(createTagElement("outport", atom.getValue()));
            var positivenexthopaddr = ct.getAtom("positivenexthopaddr").getValue();  //       
            var negativenexthopaddr = ct.getAtom("negativenexthopaddr").getValue();  //       
            rowparams.appendChild(createTagElement("nexthopaddr", parseInt("0x" + convertIpaddrToHexcode(positivenexthopaddr))));
            rowparams.appendChild(createTagElement("rnexthopaddr", parseInt("0x" + convertIpaddrToHexcode(negativenexthopaddr))));
            
            rowparams.appendChild(createTagElement("srcnode", parseInt("0x" + convertIpaddrToHexcode(srcNode))));
            rowparams.appendChild(createTagElement("sinknode", snkNode));
            rowparams.appendChild(createTagElement("snknode", parseInt("0x" + convertIpaddrToHexcode(snkNode))));
            break;
        case NODE_TYPE_EGRESS:

        		rowparams.appendChild(createTagElement("bw", bandwidth));
                rowparams.appendChild(createTagElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
                if(!isSupportPirEditFlag)
                {
    				rowparams.appendChild(createTagElement("pirbandwidth", isNaN(bandwidth) ? 0 : bandwidth));
                }
                else
                {
                	rowparams.appendChild(createTagElement("pirbandwidth", isNaN(pir) ? 0 : pir));
                }
        	
            slotId = parseInt(iOptions[iOptions.selectedIndex].value);
            if (INVALID_SLOT != slotId) 
            {
                rowparams.appendChild(createTagElement("inboardname", iOptions[iOptions.selectedIndex].text));
            }
            rowparams.appendChild(createTagElement("inslotid", slotId));
            atom = ct.getAtom("inport");
            rowparams.appendChild(createTagElement("inportname", atom.element.options[atom.element.options.selectedIndex].text));
            rowparams.appendChild(createTagElement("inport", atom.getValue()));
            rowparams.appendChild(createTagElement("inlabel", ct.getAtom("positiveinlabel").getValue())); //     
            rowparams.appendChild(createTagElement("routlabel", ct.getAtom("negativeoutlabel").getValue())); //     
            rowparams.appendChild(createTagElement("outsubslotid", 0));
            var negativenexthopaddr = ct.getAtom("negativenexthopaddr").getValue();  //       
            rowparams.appendChild(createTagElement("rnexthopaddr", parseInt("0x" + convertIpaddrToHexcode(negativenexthopaddr))));
            rowparams.appendChild(createTagElement("srcnode", parseInt("0x" + convertIpaddrToHexcode(srcNode))));
            rowparams.appendChild(createTagElement("exp", ct.getAtom("exp").getValue()));
            break;
        default:
            break;
    }
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doCreate(param)
{
    if (!validate()) 
    {
        return;
    }
    var xml = createTunnelXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_ADD_P2PTUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createCallBack, param, "inputdata=" + xml);
}

function createCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        win.doQuery();
        if (param && data.getSErrorCode() == 0) 
        {
            xcloseDialog();
        }
        else 
        {
            refreshData();
        }
    }
}

function refreshData()
{
    ct.getAtom("tunnelid").setValue("");
}

function validateNode(obj)
{
    var stCall = false;
    var nodeType = "";
    if (arguments.length > 1) 
    {
        stCall = arguments[1];
        nodeType = arguments[2];
    }
    
    var oedit = obj;
    oedit.maxLength = maxbyte;
    oedit.style.imeMode = "disabled"; //     
    oedit.onpaste = function()
    {
        return false;
    }
    
    oedit.ondrop = function()
    {
        return false;
    }
    
    oedit.onkeypress = function()
    {
        var event = EventUtil.getEvent();
        var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
        if (code == 8) 
        {
            return true;
        }
        
        var objIp = oedit;
        var existstring = objIp.value;
        var curInput = String.fromCharCode(code);
        if (event.keyCode == 13) 
        {
            objIp.onblur();
        }
        if (((code < 48 || code > 57) && code != splitcharcode) ||
        (code == splitcharcode && existstring.charCodeAt(existstring.length - 1) == splitcharcode) ||
        (code == splitcharcode && existstring.length == 0)) 
        {
            return false;
        }
        
        var tagPosition = digitalTag_getPos(objIp);
        
        var str1 = existstring.substring(0, tagPosition);
        var str2 = existstring.substring(tagPosition, existstring.length);
        existstring = str1 + curInput + str2;
        
        var aryIp = existstring.split(splitchar);
        
        if (aryIp.length > 4) 
        {
            return false;
        }
        
        /* a.b.c.d              .  */
        var dot1 = existstring.indexOf(splitchar);
        var dot2 = existstring.indexOf(splitchar, dot1 + 1);
        var dot3 = existstring.indexOf(splitchar, dot2 + 1);
        var dot4 = existstring.indexOf(splitchar, dot3 + 1);
        
        if (dot1 < 0) 
        {
            if (existstring.length == 3) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > 3 && (selectionLen(ojbIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot2 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length == dot1 + 4) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > dot1 + 4 && (selectionLen(objIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot3 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot2 && existstring.substring(dot1 + 1, dot2).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length == dot2 + 4) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > dot2 + 4 && (selectionLen(objIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot4 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot2 && existstring.substring(dot1 + 1, dot2).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot3 && existstring.substring(dot2 + 1, dot3).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length > maxbyte) 
            {
                if ((selectionLen(objIp) == 0)) 
                {
                    return;
                }
            }
            else if (existstring.length == dot3 + 5) 
            {
                tagPosition = digitalTag_getPos(objIp);
                if (tagPosition > dot3 && (selectionLen(objIp) == 0)) 
                {
                    return;
                }
            }
        }
    }
    
    /**
     *   IP                  255       255
     */
    oedit.onkeyup = function()
    {
        var event = EventUtil.getEvent();
        var objIp = event.srcElement;
        var aryIp = objIp.value.split(splitchar);
        var errFlg = false;
        var i = 0;
        for (i = 0; i < aryIp.length; ++i) 
        {
            if (aryIp[i] != "") 
            {
                aryIp[i] = parseInt(aryIp[i], 10);
            }
            if (aryIp[i] > maxvalue) 
            {
                aryIp[i] = maxvalue;
                errFlg = true;
            }
        }
        if (errFlg) 
        {
            objIp.value = aryIp[0];
            for (i = 1; i < aryIp.length; ++i) 
            {
                objIp.value += (splitchar + aryIp[i]);
            }
        }
    }
    
    oedit.onblur = function()
    {
        var event = EventUtil.getEvent();
        
        var objIp = event.srcElement;
        if (objIp.value == "") 
        {
            alert(RESOURCE["format"]);
            objIp.value = "0.0.0.0";
            if (stCall) 
            {
                cellonblur(objIp);
            }
            return;
        }
        
        objIp.value = formFullAddr(objIp.value);
        var aryIp = objIp.value.split(splitchar);
        var errFlg = false;
        var i = 0;
        for (i = 0; i < aryIp.length; ++i) 
        {
            if (aryIp[i] > maxvalue) 
            {
                aryIp[i] = maxvalue
                errFlg = true;
            }
        }
        if (errFlg) 
        {
            objIp.value = aryIp[0];
            for (i = 1; i < aryIp.length; ++i) 
            {
                objIp.value += (splitchar + aryIp[i]);
            }
        }
        
        if (stCall) 
        {
            cellonblur(objIp);
        }
    }
}

function isAfterRTN900R5C01()
{
    if(win.winobj.neType == "114")
    {
        return true;
    }
    
    var verArr = win.neversion.split('.');

    if(verArr[2] >= '05' && verArr[3] >= '20')
    {
        return true;
    } else {
        return false;
    }
}
