var neInfoTable;
var tunnelInfoTable;
var parentWin = getParentWindow();
var parentCt = parentWin.ct;
var nodeType = parseInt(parentCt.getAtom("nodetype", 0).getValue());
var isreverse = false;
if (parentWin.document.getElementById("isreverse"))
{
	isreverse = parentWin.document.getElementById("isreverse").checked;
}
var lastFlag = false;
var nextFlag = false;

var INVALID_SLOT = 0;

var exp = new Array();
exp[0] = "exp0";
exp[1] = "exp1";
exp[2] = "exp2";
exp[3] = "exp3";
exp[4] = "exp4";
exp[5] = "exp5";
exp[6] = "exp6";
exp[7] = "exp7";
exp[255] = "exp255";

/**
 *         
 *
 * @param   
 * @return   
 */
function init()
{
    $("pneInfoTitle").appendChild(document.createTextNode(RESOURCE["nelist"]));
    $("tunnelInfoTitle").appendChild(document.createTextNode(RESOURCE["tunnelInfo"]));
    
    
    initTable();
    initButton();
    
    queryPeerNE();
    
}

function initButton()
{
    $("applyBtn").value = RESOURCE["copytolocal"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
    $("applyBtn").disabled = true;
}


/**
 *              
 *
 * @param   
 * @return   
 */
function initTable()
{
    neInfoTable = new SortTable();
    
    neInfoTable.setImage("../../../../../images/");
    
    neInfoTable.setSingleChoiceFlg(true);
    
    neInfoTable.setOnRowSelectHandler(rowSelectHandler);
    
    if (nodeType == NODE_TYPE_INGRESS || nodeType == NODE_TYPE_EGRESS) 
    {
        window.tableconf[0].colArray[7].width = 0;
    }
    
    createTableHead(neInfoTable, window.tableconf[0]);
    
    neInfoTable.setBodyWidth(window.tableconf[0].width, window.tableconf[0].percent, 0);
    neInfoTable.setBodyHeight(120);
    
    adjustTableLayout(neInfoTable, window.tableconf[0], 0);
    $("neInfoDiv").appendChild(neInfoTable.getTable());
    
    tunnelInfoTable = new SortTable();
    
    tunnelInfoTable.setImage("../../../../../images/");
    
    tunnelInfoTable.setOnRowSelectHandler(tunnelRowSelectHandler);
    tunnelInfoTable.setBodyHeight(230);
    createTableHead(tunnelInfoTable, window.tableconf[1]);
    
    $("tunnelInfoDiv").appendChild(tunnelInfoTable.getTable());
    
}


function queryPeerNE()
{
    var xml = createPeerXML();
    var urlreq = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_FIBERSEARCH_TUNNEL + "&nmUser=" + parentWin.nmUser + "&neid=" + parentWin.neid;
    loadXMLdoc(urlreq, "POST", false, showNeList, null, "inputdata=" + xml);

}


function showNeList(doc)
{
    clearTable();
    var dinterface = EncapsulateData(doc);
    if (dinterface.getSErrorCode() != 0) 
    {
        var errArr = [];
        errArr[0] = "nename";
        openErrPage("../../../../../page/", dinterface.getError(), errArr)
    }
    
    for (var i = 0, len = dinterface.getDataRowLength(); i < len; i++) 
    {
        if (null != dinterface.getDataRowParam(i, "srcLsrId")) 
        {
            var srcLsrId = dinterface.getDataRowParam(i, "srcLsrId");
            dinterface.rows[i]["srcLsrId"].value = convertNumToIpaddr(srcLsrId);
        }
        
        if (null != dinterface.getDataRowParam(i, "desLsrID")) 
        {
            var desLsrID = dinterface.getDataRowParam(i, "desLsrID");
            dinterface.rows[i]["desLsrID"].value = convertNumToIpaddr(desLsrID);
        }
    }
    
    createTableBody(neInfoTable, window.tableconf[0], dinterface, RESOURCE);
    
    
    
}

function doLastOrNext(obj)
{
    $("applyBtn").disabled = false;
    
}


function clearTable()
{
    for (var i = 0; i < tunnelInfoTable.getDataRowLength(); ++i) 
    {
        tunnelInfoTable.deleteRow(i);
    }
    tunnelInfoTable.adjustDataRows();
    
    for (var i = 0; i < neInfoTable.getDataRowLength(); ++i) 
    {
        neInfoTable.deleteRow(i);
    }
    neInfoTable.adjustDataRows();
    
    
}

function createPeerXML()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", parentWin.neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 *
 * @param rows:      
 * @return   
 */
function rowSelectHandler(rows)
{
    if (neInfoTable.getCellStoreValue(rows[0], "communicateStatus", "communicateStatus") == 0 ||
    neInfoTable.getCellStoreValue(rows[0], "logStatus", "logStatus") == 0) {
        tunnelInfoTable.clearTableData();
        return;
    }
   var queryXml = createQueryTunnelXml(neInfoTable.getCellStoreValue(rows[0], "desNeID", "desNeID"));
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_QUERY_P2PTUNNEL + "&nmUser=" + parentWin.nmUser;
   loadXMLdoc(url, "POST", false, queryTunnelCallBack, null, "inputdata=" + queryXml);
}

function tunnelRowSelectHandler(rows)
{
    if (nodeType == 1 || nodeType == 3) 
    {
        $("applyBtn").disabled = false;
    }
    else 
    	{
        var neIndex = neInfoTable.getSelectedRows()[0];
        var lastOrNext = neInfoTable.getCellCurrentValue(neIndex, "lastOrNext", "lastOrNext");
        if (lastOrNext != null && lastOrNext != "") 
        {
            $("applyBtn").disabled = false;
        }
        
    }
    
    if (rows.length != 2 && isreverse) 
    {
        $("applyBtn").disabled = true;
    }
    
    if (rows.length != 1 && !isreverse) 
    {
        $("applyBtn").disabled = true;
    }
    
    if (rows.length == 2) 
    {
        var tunnelIndexs = tunnelInfoTable.getSelectedRows();
        var tunnelInSlot0 = tunnelInfoTable.getCellStoreValue(tunnelIndexs[0], "inport", "inslotid");
        var tunnelInPort0 = tunnelInfoTable.getCellStoreValue(tunnelIndexs[0], "inport", "inportname").split("(")[0];
        var tunnelOutSlot0 = tunnelInfoTable.getCellStoreValue(tunnelIndexs[0], "outport", "outslotid");
        var tunnelOutPort0 = tunnelInfoTable.getCellStoreValue(tunnelIndexs[0], "outport", "outportname").split("(")[0];
        var tunnelInSlot1 = tunnelInfoTable.getCellStoreValue(tunnelIndexs[1], "inport", "inslotid");
        var tunnelInPort1 = tunnelInfoTable.getCellStoreValue(tunnelIndexs[1], "inport", "inportname").split("(")[0];
        var tunnelOutSlot1 = tunnelInfoTable.getCellStoreValue(tunnelIndexs[1], "outport", "outslotid");
        var tunnelOutPort1 = tunnelInfoTable.getCellStoreValue(tunnelIndexs[1], "outport", "outportname").split("(")[0];
        
        var isInEqualOut = (tunnelInSlot0 != tunnelOutSlot1) || (tunnelInPort0 != tunnelInPort1) || (tunnelOutSlot0 != tunnelInSlot1) || (tunnelOutPort0 != tunnelInPort1);
        
        
        if ( isInEqualOut&&
        tunnelInSlot0 != INVALID_SLOT &&
        tunnelOutSlot1 != INVALID_SLOT &&
        tunnelOutSlot0 != INVALID_SLOT &&
        tunnelInPort1 != INVALID_SLOT) 
        {
            $("applyBtn").disabled = true;
        }
    }
}

function createQueryTunnelXml(desNeID)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", desNeID));
    rowparams.appendChild(createTagElement("tunnelindex", 0));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}



function queryTunnelCallBack(doc)
{
    var data = EncapsulateData(doc);
    tunnelInfoTable.clearTableData();
    $("applyBtn").disabled = true;
    
    for (var i = data.getDataRowLength() - 1; i >= 0; i--) 
    {
        var sIndex = neInfoTable.getSelectedRows()[0];
        var args = neInfoTable.getCellCurrentValue(sIndex, "DES_NE_PORT", "DES_NE_PORT").split("-");
        var oppositeSlot = args[0];
        var oppositePort = args[2];
        
        var outslotid = data.getDataRowParam(i, "outslotid");
        var outport = data.getDataRowParam(i, "outport");
        var inslotid = data.getDataRowParam(i, "inslotid");
        var inport = data.getDataRowParam(i, "inport");
        
        if ((oppositeSlot != outslotid || oppositePort != outport) && (oppositeSlot != inslotid || oppositePort != inport)) 
        {
            data.removeDataRowAt(i);
            continue;
        }
        
        if (nodeType == 1 && (oppositeSlot != inslotid || oppositePort != inport) && !isreverse) 
        {
            data.removeDataRowAt(i);
            continue;
        }
        
        if (nodeType == 3 && (oppositeSlot != outslotid || oppositePort != outport) && !isreverse) 
        {
            data.removeDataRowAt(i);
            continue;
        }
    }
    
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1)
     {
        createTableBody(tunnelInfoTable, window.tableconf[1], data, RESOURCE);
        var ce = tunnelInfoTable.getHeadCell("tunnelid").element;
        tunnelInfoTable.sortRows(ce, 1);
    }
    
    for (var i = 0, iLength = tunnelInfoTable.getDataRowLength(); i < iLength; i++) 
    {
        var nType = parseInt(tunnelInfoTable.getCellCurrentValue(i, "nodetype", "nodetype"));
        switch (nType) 
        {
            case NODE_TYPE_EGRESS:
                cell = tunnelInfoTable.getCell(i, "outport");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = tunnelInfoTable.getCell(i, "outlabel");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = tunnelInfoTable.getCell(i, "snknode");
                cell.element.showElement.element.innerHTML = "-";
                
                break;
                
            case NODE_TYPE_INGRESS:
                cell = tunnelInfoTable.getCell(i, "inport");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = tunnelInfoTable.getCell(i, "inlabel");
                cell.element.showElement.element.innerHTML = "-";
                
                cell = tunnelInfoTable.getCell(i, "srcnode");
                cell.element.showElement.element.innerHTML = "-";
                break;
            
            default:
                break;
        }
        
    }
    
    
}

function doApply()
{

    var tunnelIndexs = tunnelInfoTable.getSelectedRows();
    for (var i = 0; i < tunnelIndexs.length; i++) {
    
        var tunnelIndex = tunnelIndexs[i];
        var neIndex = neInfoTable.getSelectedRows()[0];
        var args = neInfoTable.getCellCurrentValue(neIndex, "SRC_NE_PORT", "SRC_NE_PORT").split("-");
        var localSlot = args[0];
        var localPort = args[2];
        args = neInfoTable.getCellCurrentValue(neIndex, "DES_NE_PORT", "DES_NE_PORT").split("-");
        var oppositeSlot = args[0];
        var oppositePort = args[2];
        var tunnelInSlot = tunnelInfoTable.getCellStoreValue(tunnelIndex, "inport", "inslotid");
        var tunnelInPort = tunnelInfoTable.getCellStoreValue(tunnelIndex, "inport", "inportname").split("(")[0];
        var tunnelOutSlot = tunnelInfoTable.getCellStoreValue(tunnelIndex, "outport", "outslotid");
        var tunnelOutPort = tunnelInfoTable.getCellStoreValue(tunnelIndex, "outport", "outportname").split("(")[0];
        var tunnelID = tunnelInfoTable.getCellStoreValue(tunnelIndex, "tunnelid", "tunnelid");
        var tunnelName = tunnelInfoTable.getCellStoreValue(tunnelIndex, "name", "name");
        var bandwidth = tunnelInfoTable.getCellStoreValue(tunnelIndex, "bandwidth", "bandwidth");
        
        var isPositive = false;//       
        
        if (nodeType == NODE_TYPE_INGRESS && oppositeSlot == tunnelInSlot && oppositePort == tunnelInPort) 
        {
            isPositive = true;
        }
        
        if (nodeType == NODE_TYPE_EGRESS && oppositeSlot == tunnelOutSlot && oppositePort == tunnelOutPort) 
        {
            isPositive = true;
        }
        
        
        if (nodeType == NODE_TYPE_TRANSIT && oppositeSlot == tunnelOutSlot && oppositePort == tunnelOutPort &&
        neInfoTable.getCellCurrentValue(neIndex, "lastOrNext", "lastOrNext") == 0) 
        {
            isPositive = true;
        }
        
        if (nodeType == NODE_TYPE_TRANSIT && oppositeSlot == tunnelInSlot && oppositePort == tunnelInPort &&
        neInfoTable.getCellCurrentValue(neIndex, "lastOrNext", "lastOrNext") == 1) 
        {
            isPositive = true;
        }
        
        switch (nodeType) 
        {
            case NODE_TYPE_INGRESS:
            {
                if (isreverse) 
                {
                    if (!isPositive) 
                    {
                        parentCt.setAttrValue("tunnelid", 1, tunnelID);
                        parentCt.setAttrValue("tunnelname", 1, tunnelName);
                        parentCt.getAtom("inlabel", 1).setValue(tunnelInfoTable.getCellStoreValue(tunnelIndex, "outlabel", "outlabel"));
                        setBandwidth(0,bandwidth);
                    }
                    else 
                    {
                        parentCt.setAttrValue("tunnelid", 0, tunnelID);
                        parentCt.setAttrValue("tunnelname", 0, tunnelName);
                        parentCt.getAtom("outboard", 0).setValue(localSlot);
                        parentCt.getAtom("outport", 0).setValue(localPort);
                        parentCt.getAtom("outlabel", 0).setValue(tunnelInfoTable.getCellStoreValue(tunnelIndex, "inlabel", "inlabel"));
                        parentCt.getAtom("nexthopaddr", 0).setValue(neInfoTable.getCellShow(neIndex, "ATTR_ETHOVERPTN_MAC_IPADDRESS", "ATTR_ETHOVERPTN_MAC_IPADDRESS").getValue());
                        var snknode = tunnelInfoTable.getCellShow(tunnelIndex, "snknode", "snknode").getValue();
                        if(snknode!="-"&&snknode!=null)
                    		{
                    				parentCt.getAtom("snknode", 0).setValue(snknode);
                    		}
                    		else
                    		{
                    				parentCt.getAtom("snknode", 0).setValue(neInfoTable.getCellCurrentValue(neIndex, "desLsrID", "desLsrID"));
                    		}
                        parentWin.changeSnkNode();
                    }
                    parentWin.changeBoard("outboard", "inboard", "outport", "inport");
                }
                else 
                {
                    parentCt.setAttrValue("tunnelid", 0, tunnelID);
                    parentCt.setAttrValue("tunnelname", 0, tunnelName);
                    setBandwidth(0,bandwidth);
                    parentCt.getAtom("outboard", 0).setValue(localSlot);
                    parentCt.getAtom("outport", 0).setValue(localPort);
                    parentCt.getAtom("outlabel", 0).setValue(tunnelInfoTable.getCellStoreValue(tunnelIndex, "inlabel", "inlabel"));
                    parentCt.getAtom("nexthopaddr", 0).setValue(neInfoTable.getCellShow(neIndex, "ATTR_ETHOVERPTN_MAC_IPADDRESS", "ATTR_ETHOVERPTN_MAC_IPADDRESS").getValue());
                    var snknode = tunnelInfoTable.getCellShow(tunnelIndex, "snknode", "snknode").getValue();
                    if(snknode!="-"&&snknode!=null)
                    {
                    		parentCt.getAtom("snknode", 0).setValue(snknode);
                    }
                    else
                    {
                    	parentCt.getAtom("snknode", 0).setValue(neInfoTable.getCellCurrentValue(neIndex, "desLsrID", "desLsrID"));
                    }
                }
                
                break;
            }
            
            case NODE_TYPE_EGRESS:
            {
                if (isreverse) 
                {
                    if (!isPositive) 
                    {
                        parentCt.setAttrValue("tunnelid", 1, tunnelID);
                        parentCt.setAttrValue("tunnelname", 1, tunnelName);
                        parentCt.getAtom("outlabel", 1).setValue(tunnelInfoTable.getCellStoreValue(tunnelIndex, "inlabel", "inlabel"));
                        parentCt.getAtom("nexthopaddr", 1).setValue(neInfoTable.getCellShow(neIndex, "ATTR_ETHOVERPTN_MAC_IPADDRESS", "ATTR_ETHOVERPTN_MAC_IPADDRESS").getValue());
                    }
                    else 
                    	{
                        parentCt.setAttrValue("tunnelid", 0, tunnelID);
                        parentCt.setAttrValue("tunnelname", 0, tunnelName);
                        parentCt.getAtom("inboard", 0).setValue(localSlot);
                        parentCt.getAtom("inport", 0).setValue(localPort);
                        parentCt.getAtom("inlabel", 0).setValue(tunnelInfoTable.getCellStoreValue(tunnelIndex, "outlabel", "outlabel"));
                       	setBandwidth(1,bandwidth);
                      var srcnode = tunnelInfoTable.getCellShow(tunnelIndex, "srcnode", "srcnode").getValue();
                    if(srcnode!=null &&srcnode!="-")
                    {
                    	parentCt.getAtom("srcnode", 0).setValue(srcnode);
                    }
                    else
                    {
                    	parentCt.getAtom("srcnode", 0).setValue(neInfoTable.getCellCurrentValue(neIndex, "srcLsrId", "srcLsrId"));
                    }
                        parentWin.changeSrcNode();
                    }
                    parentWin.changeBoard("inboard", "outboard", "inport", "outport");
                }
                else 
                	{
                    parentCt.setAttrValue("tunnelid", 0, tunnelID);
                    parentCt.setAttrValue("tunnelname", 0, tunnelName);
                    parentCt.getAtom("inboard", 0).setValue(localSlot);
                    parentCt.getAtom("inport", 0).setValue(localPort);
                    parentCt.getAtom("inlabel", 0).setValue(tunnelInfoTable.getCellStoreValue(tunnelIndex, "outlabel", "outlabel"));
                    var srcnode = tunnelInfoTable.getCellShow(tunnelIndex, "srcnode", "srcnode").getValue();
                    if(srcnode!=null &&srcnode!="-")
                    {
                    	parentCt.getAtom("srcnode", 0).setValue(srcnode);
                    }
                    else
                    {
                    	parentCt.getAtom("srcnode", 0).setValue(neInfoTable.getCellCurrentValue(neIndex, "srcLsrId", "srcLsrId"));
                    }
                }
                
                
                break;
            }
            
            case NODE_TYPE_TRANSIT:
            {
                var lastOrNext = neInfoTable.getCellCurrentValue(neIndex, "lastOrNext", "lastOrNext");
                if (lastOrNext == 0) //               
                {
                    if (isreverse) 
                    {
                        if (!isPositive) 
                        {
                            parentCt.setAttrValue("tunnelid", 1, tunnelID);
                            parentCt.setAttrValue("tunnelname", 1, tunnelName);
                            parentCt.getAtom("outlabel", 1).setValue(tunnelInfoTable.getCellStoreValue(tunnelIndex, "inlabel", "inlabel"));
                            parentCt.getAtom("nexthopaddr", 1).setValue(neInfoTable.getCellShow(neIndex, "ATTR_ETHOVERPTN_MAC_IPADDRESS", "ATTR_ETHOVERPTN_MAC_IPADDRESS").getValue());
                        }
                        else 
                        	{
                            parentCt.setAttrValue("tunnelid", 0, tunnelID);
                            parentCt.setAttrValue("tunnelname", 0, tunnelName);
                            parentCt.getAtom("inboard", 0).setValue(localSlot);
                            parentCt.getAtom("inport", 0).setValue(localPort);
                            parentCt.getAtom("inlabel", 0).setValue(tunnelInfoTable.getCellStoreValue(tunnelIndex, "outlabel", "outlabel"));
                            parentCt.getAtom("snknode", 0).setValue(tunnelInfoTable.getCellShow(tunnelIndex, "snknode", "snknode").getValue());
                            setBandwidth(0,bandwidth);
                            parentWin.changeBoard("inboard", "outboard", "inport", "outport");
                            parentWin.changeSnkNode();
                        }
                    }
                    else 
                    	{
                    
                        parentCt.setAttrValue("tunnelid", 0, tunnelID);
                        parentCt.setAttrValue("tunnelname", 0, tunnelName);
                        parentCt.getAtom("inboard", 0).setValue(localSlot);
                        parentCt.getAtom("inport", 0).setValue(localPort);
                        parentCt.getAtom("inlabel", 0).setValue(tunnelInfoTable.getCellStoreValue(tunnelIndex, "outlabel", "outlabel"));
                        parentCt.getAtom("snknode", 0).setValue(tunnelInfoTable.getCellShow(tunnelIndex, "snknode", "snknode").getValue());
                        setBandwidth(0,bandwidth);
                        
                    }
                    lastFlag = true;
                }
                else 
                    if (lastOrNext == 1)//               
                    {
                    
                        if (isreverse) 
                        {
                            if (!isPositive) 
                            {
                                parentCt.getAtom("inlabel", 1).setValue(tunnelInfoTable.getCellStoreValue(tunnelIndex, "outlabel", "outlabel"));
                                setBandwidth(1,bandwidth);
                            }
                            else 
                            	{
                                parentCt.getAtom("outboard", 0).setValue(localSlot);
                                parentCt.getAtom("outport", 0).setValue(localPort);
                                parentCt.getAtom("outlabel", 0).setValue(tunnelInfoTable.getCellStoreValue(tunnelIndex, "inlabel", "inlabel"));
                                parentCt.getAtom("nexthopaddr", 0).setValue(neInfoTable.getCellShow(neIndex, "ATTR_ETHOVERPTN_MAC_IPADDRESS", "ATTR_ETHOVERPTN_MAC_IPADDRESS").getValue());
                                parentCt.getAtom("srcnode", 0).setValue(tunnelInfoTable.getCellShow(tunnelIndex, "srcnode", "srcnode").getValue());
                                parentWin.changeSrcNode();
                            }
                        }
                        else 
                        	{
                        
                            parentCt.getAtom("outboard", 0).setValue(localSlot);
                            parentCt.getAtom("outport", 0).setValue(localPort);
                            parentCt.getAtom("outlabel", 0).setValue(tunnelInfoTable.getCellStoreValue(tunnelIndex, "inlabel", "inlabel"));
                            parentCt.getAtom("nexthopaddr", 0).setValue(neInfoTable.getCellShow(neIndex, "ATTR_ETHOVERPTN_MAC_IPADDRESS", "ATTR_ETHOVERPTN_MAC_IPADDRESS").getValue());
                            parentCt.getAtom("srcnode", 0).setValue(tunnelInfoTable.getCellShow(tunnelIndex, "srcnode", "srcnode").getValue());
                        }
                        nextFlag = true;
                    }
                break;
            }
            
            default:
                break;
        }
        
        
    }
    
    if (nodeType == NODE_TYPE_INGRESS || nodeType == NODE_TYPE_EGRESS) 
    {
        xcloseDialog();
    }
    
    if (nodeType == NODE_TYPE_TRANSIT && nextFlag && lastFlag) 
    {
        xcloseDialog();
    }
    
}


function setBandwidth(col,bandwidth)
{
	 if(bandwidth!=0 && bandwidth!=null && bandwidth!="-"&& bandwidth!="")
   {
         parentCt.setAttrValue("bandwidth", col, bandwidth);
         parentCt.getAtom("bandwidth", col).element.parent.txtview.value = bandwidth;
    }
}





