var st = null;
var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;

var nodeType = [];//    
nodeType[1] = "ingress";
nodeType[2] = "transit";
nodeType[3] = "egress";

var tunnelDirection = [];
tunnelDirection[1] = "pwDirection_1";
tunnelDirection[0] = "pwDirection_2";

/**
 *      
 */
function init()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("tbdiv"), 50) + "px");
    st.setSingleChoiceFlg(true);
    
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    
    doQuery();
}


/**
 *        xml
 */
function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("tunnelindex", "0"));//       
    var seletedRows = win.st.getSelectedRows();
    var nodeType = win.st.getCellStoreValue(seletedRows[0], "nodetype", "nodetype");
    rowparams.appendChild(createTagElement("nodetype", nodeType));//         
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     
 */
function doQuery()
{
    $("okbtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_GET_AVALIABLETUNNEL4OAMREVTUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, queryCallBack, null, "inputdata=" + xml);
}

/**
 *        
 * @param {Object} doc
 */
function queryCallBack(doc)
{
    $("okbtn").disabled = false;
    
    var data = EncapsulateData(doc);
    
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        for(var i = data.getDataRowLength() -1 ; i>=0; i--)
        {
        	 var nodetype = data.rows[i]["nodetype"].value;
        	 var direction = data.rows[i]["direction"].value;
        	 var tunnelIndex = data.rows[i]["tunnelindex"].value;
        	 var index = win.st.getSelectedRows()[0];
        	 var rTunnelIndex = win.st.getCellStoreValue(index, "rTunnelIndex", "rTunnelIndex");
        	 if(nodetype == win.st.getCellCurrentValue(index, "nodetype", "nodeType") || direction == 1
        	 	|| rTunnelIndex == tunnelIndex)
        	 {
        	 	   data.removeDataRowAt(i);
        	 }
        }
        
        if (data.getDataRowLength() <= 0)
        {
        	alert(RESOURCE["noresource"]);
        }
        
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
    }
}

/**
 *       
 */
function doOk()
{
    var selectedRows = st.getSelectedRows();
    var revTunnelStr = "";
    var revTunnelIndex = "";
    if (selectedRows.length > 0) 
    {
        revTunnelIndex = st.getCellStoreValue(selectedRows[0], "tunnelindex", "tunnelindex");
        var tunnId = st.getCellStoreValue(selectedRows[0], "tunnelid", "tunnelid");
        var srcNode = st.getCellStoreValue(selectedRows[0], "srcnode", "srcnode");
        var snkNode = st.getCellStoreValue(selectedRows[0], "snknode", "snknode");
        revTunnelStr = tunnId + "(" + RESOURCE["srcnode"] + ":" + convertIP(srcNode) + "," + RESOURCE["snknode"] + ":" + convertIP(snkNode) + ")";
    }
    
    var winSeletedRows = win.st.getSelectedRows();
    var revTunnelCell = win.st.getCell(winSeletedRows[0], "reversetunnel", revTunnelIndex);
    win.st.getCellShow(winSeletedRows[0], "reversetunnel").element.innerHTML = revTunnelStr;
    win.st.setCellValue(revTunnelCell, "reversetunnel", revTunnelIndex);
    revTunnelCell.element.modify = true;
    revTunnelCell.element.style.background = "#d0f946";
    win.st.element.datarows[winSeletedRows[0]].element.modify = true;
    win.applybtn.disabled = false;
    xcloseDialog();
}

/**
 *       
 */
function doClose()
{
    xcloseDialog();
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

window.onresize = function()
{
    st.setBodyHeight(getComponetHeight($("tbdiv"), 50) + "px");
};
