var st = null;
var btnRightArr = new Object();
var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;
var netype = winobj.neType;
var STARTOFGLS_MIN = 0;//                
var STARTOFGLS_MAX = 1048064;
var STARTOFGLS_MAX_NA = 1015808;
var STARTOFGLS_STEP = 512;
var STARTOFGLS_STEP_NA = 2048;
var never = winobj.neversion.split('.');

/**
 *      
 */
function init()
{
    initTable();
    initButton();
    initRight();//    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    doQuery();
}

/**
 *      
 */
function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
    
    $("tbdiv").oncontextmenu = popupMenuHandler;
}

/**
 *     
 */
function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

/**
 *       
 */
function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TE_CMD_MPLSTUNNEL_GET_BSCFG);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TE_CMD_MPLSTUNNEL_SET_BSCFG);
    
    getRightInfo(winobj, btnRightArr);
}

/**
 *               
 * @param {Object} param
 */
function cellEditHandler(param)
{
    if (param.colid == "startOfGls" || param.colid == "glsSize" && param.stage == TABLE_CONSTANT.AFTEREDIT) 
    {
        var rowIndex = param.rowindex;
        var startOfGlsValue = st.getCellStoreValue(rowIndex, "startOfGls", "startOfGls");
        var glsSizeValue = st.getCellStoreValue(rowIndex, "glsSize", "glsSize");//        
        var startOfMlsValue = Number(startOfGlsValue) + Number(glsSizeValue);
        var startOfMlsCell = st.getCell(rowIndex, "startOfMls", startOfMlsValue);
        st.setCellValue(startOfMlsCell, "startOfMls", startOfMlsValue);
        st.getCellShow(rowIndex, "startOfMls").element.innerHTML = startOfMlsValue;
    }
    
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}

/**
 *        xml
 */
function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    rowparams.appendChild(thirdlevel);
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *     
 */
function doQuery()
{
    if ($("querybtn").disabled) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_GET_BSCFG + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

/**
 *        
 * @param {Object} doc
 */
function queryCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
    var data = EncapsulateData(doc);
    processData(data);
    
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addCellListener();
    }
}

/**
 *              
 * @param data        
 * @return  
 */
function processData(data)
{
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        if (null != data.getDataRowParam(i, "lsrId")) 
        {
            var lsrIdValue = data.getDataRowParam(i, "lsrId");
            data.rows[i]["lsrId"].value = convertNumToIpaddr(lsrIdValue);
        }
    }
}

/**
 *          
 */
function addCellListener()
{
    var ofglsRange = SpecialAttrMgr.getNEAttrListValue(neid, "TE_FUNC_CFG_PTN_MPLSTUNNEL_BSCFG", "MPLS_ATTR_OFGLS_START_RANGE");
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        validateIp(st.getCellEdit(i, "lsrId").element, true);
        if (ofglsRange != null && ofglsRange.length == 3) 
        {
        	textCheckWithStepLen(st.getCellEdit(i, "startOfGls").element, ofglsRange[0], ofglsRange[1], ofglsRange[2]);
        }
        else 
        {
            if (isRTN900NEtype(netype) && (never[2] + never[3]) >= '0310') 
            {
                textCheckWithStepLen(st.getCellEdit(i, "startOfGls").element, STARTOFGLS_MIN, STARTOFGLS_MAX_NA, STARTOFGLS_STEP_NA);
            }
            else 
            {
                textCheckWithStepLen(st.getCellEdit(i, "startOfGls").element, STARTOFGLS_MIN, STARTOFGLS_MAX, STARTOFGLS_STEP);
            }
        }
    }
}

/**
 *        xml  
 */
function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var isTips = false;//           
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        if (st.getCellModify(i, "lsrId")) 
        {
            isTips = true;
            var lsrIdValue = st.getCellStoreValue(i, "lsrId", "lsrId");
			row.appendChild(createTagElement("lsrIdValue", lsrIdValue));
            row.appendChild(createTagElement("lsrId", convertIpaddrToHexcode(lsrIdValue)));
        }
        if (st.getCellModify(i, "startOfGls") || st.getCellModify(i, "glsSize")) 
        {
            var startOfGlsValue = st.getCellStoreValue(i, "startOfGls", "startOfGls");
            var glsSizeValue = st.getCellStoreValue(i, "glsSize", "glsSize");
            var startOfMlsValue = st.getCellStoreValue(i, "startOfMls", "startOfMls");
            
            row.appendChild(createTagElement("startOfGls", startOfGlsValue));
            row.appendChild(createTagElement("glsSize", glsSizeValue));
            row.appendChild(createTagElement("startOfMls", startOfMlsValue));
            row.appendChild(createTagElement("mlsSize", 0xFFFFFFFF));
        }
        
        bussiness.appendChild(row);
    }
    if (isTips) 
    {
        if (!confirm(RESOURCE["modifyLsrId"]))//    
        {
            return null;
        }
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApply()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createApplyXML();
    if (xml == null) 
    {
        return;
    }
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_SET_BSCFG + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyCallBack, null, "inputdata=" + xml);
}

/**
 *       
 * @param {Object} doc
 */
function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};
