var st = null;
var countObj = null;

var btnRightArr = new Object();
var borrowedPorts = null;

var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;

function init()
{
    initTable();
    initButton();
    
    var countArea = document.createElement("div");
    $("countdiv").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
    initRight();
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
    
    $("tbdiv").oncontextmenu = popupMenuHandler;
}

function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_PTN_MLPPP_QUERY);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_PTN_MLPPP_MODIFY_ATTRIB);
    
    getRightInfo(winobj, btnRightArr);
}

function tabSelectHandler()
{
    if (btnRightArr.applybtn.right) 
    {
        getPortRes();
    }
    
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

function rowSelectHandler()
{
    countObj.setSelectedCount(st.getSelectedRowCount());
}

function cellEditHandler(param)
{
    if (param.colid == "PTNIF_PORT_ATTR_IPPARAPORT" && param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
        var rowIndex = param.rowindex;
        var cell = st.getCellEdit(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT");
        cell.element.options.length = 0;
        
        var board = st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML;
        for (var j = 0, n = borrowedPorts.length; j < n; j++) 
        {
            var ipPort = new Array();
            var lastIndex = borrowedPorts[j].lastIndexOf("#");
            ipPort[0] = borrowedPorts[j].substring(0, lastIndex);
            ipPort[1] = borrowedPorts[j].substring(lastIndex + 1, borrowedPorts[j].length);
            
            var port = ipPort[0];
            var arr = port.split("-");
            var bd = arr[0] + "-" + arr[1];
            if (parseInt(ipPort[1]) >= 0x1000 && parseInt(ipPort[1]) <= 0x17FF) 
            {
                bd = "ML-PPP";
                port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
            }
            else if (parseInt(ipPort[1]) >= 0x2800 && parseInt(ipPort[1]) <= 0x2FFF) 
            {
                bd = "Virtual Ethernet";
                port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
            }
            
            if (board == bd) 
            {
                cell.addOption(port, borrowedPorts[j]);
            }
        }
    }
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (st.getModify(i)) 
        {
            $("applybtn").disabled = !btnRightArr.applybtn.right;
            break;
        }
    }
}

function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doQuery()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MLPPP_QUERY + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
    var data = EncapsulateData(doc);
    
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addCellListener();
        
        countObj.setTotalCount(st.getDataRowLength());
        
        var ce = st.getHeadCell("groupno").element;
        st.sortRows(ce, 1);
        
    }
}

function addCellListener()
{
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        var ipSpecify = parseInt(st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_IPPARATYPE", "PTNIF_PORT_ATTR_IPPARATYPE"));
        switch (ipSpecify)
        {
            case IPTYPE_USERSET:
                var cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARABORD");
                st.setCellIsEdit(cell, 0);
                st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML = "-";
                
                cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARAPORT");
                st.setCellIsEdit(cell, 0);
                st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARAPORT").element.innerHTML = "-";
                break;
            case IPTYPE_PORTIP:
                var cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARA");
                st.setCellIsEdit(cell, 0);
                st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARA").element.innerHTML = "-";
                
                cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARAT");
                st.setCellIsEdit(cell, 0);
                st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARAT").element.innerHTML = "-";
                
                cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARABORD");
                st.setCellIsEdit(cell, 1);
                cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARAPORT");
                st.setCellIsEdit(cell, 1);
                var ipPort = st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_IPPARAPORT", "PTNIF_PORT_ATTR_IPPARAPORT");
                var port = ipPort.substring(0, ipPort.lastIndexOf("#"));
                var portId = parseInt(ipPort.substring(ipPort.lastIndexOf("#") + 1, ipPort.length));
                if (portId >= 0x1000 && portId <= 0x17FF) 
                {
                    st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML = "ML-PPP";
                    port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
                }
                else if (portId >= 0x2800 && portId <= 0x2FFF) 
                {
                    st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML = "Virtual Ethernet";
                    port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
                }
                st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARAPORT").element.innerHTML = port;
                
                var boardElem = st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARABORD");
                boardElem.element.options.length = 0;
                var portElem = st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARAPORT");
                portElem.element.options.length = 0;
                var board = st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML;
                var tmp = new Array();
                for (var j = 0, n = borrowedPorts.length; j < n; j++) 
                {
                    var arr = new Array();
                    var lastIndex = borrowedPorts[j].lastIndexOf("#");
                    arr[0] = borrowedPorts[j].substring(0, lastIndex);
                    arr[1] = borrowedPorts[j].substring(lastIndex + 1, borrowedPorts[j].length);
                    
                    port = arr[0];
                    var tmpArr = port.split("-");
                    var bd = tmpArr[0] + "-" + tmpArr[1];
                    if (parseInt(arr[1]) >= 0x1000 && parseInt(arr[1]) <= 0x17FF) 
                    {
                        bd = "ML-PPP";
                        port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
                    }
                    else if (parseInt(arr[1]) >= 0x2800 && parseInt(arr[1]) <= 0x2FFF) 
                    {
                        bd = "Virtual Ethernet";
                        port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
                    }
                    if (!tmp.contains(bd)) 
                    {
                        tmp[tmp.length] = bd;
                        boardElem.addOption(bd, arr[0] + "-" + arr[1]);
                    }
                    if (board == bd) 
                    {
                        portElem.addOption(port, borrowedPorts[j]);
                    }
                }
                break;
            case IPTYPE_NEIP:
            case IPTYPE_UNSET:
                var cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARA");
                st.setCellIsEdit(cell, 0);
                st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARA").element.innerHTML = "-";
                
                cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARAT");
                st.setCellIsEdit(cell, 0);
                st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARAT").element.innerHTML = "-";
                
                cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARABORD");
                st.setCellIsEdit(cell, 0);
                st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML = "-";
                
                cell = st.getCell(i, "PTNIF_PORT_ATTR_IPPARAPORT");
                st.setCellIsEdit(cell, 0);
                st.getCellShow(i, "PTNIF_PORT_ATTR_IPPARAPORT").element.innerHTML = "-";
                break;
            default:
                break;
        }
        
        var cell = st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARATYPE");
        cell.element.onchange = function()
        {
            var rowIndex = this.parentNode.parentNode.rowIndex;
            var ipSpecify = parseInt(this.value);
            switch (ipSpecify)
            {
                case IPTYPE_USERSET:
                    var cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARA");
                    st.setCellIsEdit(cell, 1);
                    st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARA", "0.0.0.0");
                    st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARA").element.innerHTML = "0.0.0.0";
                    
                    cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARAT");
                    st.setCellIsEdit(cell, 1);
                    st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARAT", "255.255.255.252");
                    st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARAT").element.innerHTML = "255.255.255.252";
                    
                    cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARABORD");
                    st.setCellIsEdit(cell, 0);
                    st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARABORD", "65535");
                    st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML = "-";
                    
                    cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT");
                    st.setCellIsEdit(cell, 0);
                    st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARAPORT", "65535-UNKNOWN-65535#65535");
                    st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT").element.innerHTML = "-";
                    break;
                case IPTYPE_PORTIP:
                    var cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARA");
                    st.setCellIsEdit(cell, 0);
                    st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARA", "255.255.255.255");
                    st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARA").element.innerHTML = "-";
                    
                    cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARAT");
                    st.setCellIsEdit(cell, 0);
                    st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARAT", "255.255.255.255");
                    st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARAT").element.innerHTML = "-";
                    
                    cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARABORD");
                    st.setCellIsEdit(cell, 1);
                    
                    cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT");
                    st.setCellIsEdit(cell, 1);
                    
                    if (borrowedPorts.length > 0) 
                    {
                        var ipPort = new Array();
                        var lastIndex = borrowedPorts[0].lastIndexOf("#");
                        ipPort[0] = borrowedPorts[0].substring(0, lastIndex);
                        ipPort[1] = borrowedPorts[0].substring(lastIndex + 1, borrowedPorts[0].length);
                        
                        var port = ipPort[0];
                        var arr = port.split("-");
                        st.setCellValue(st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARABORD"), "PTNIF_PORT_ATTR_IPPARABORD", arr[0] + "-" + arr[1]);
                        st.setCellValue(st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT"), "PTNIF_PORT_ATTR_IPPARAPORT", borrowedPorts[0]);
                        
                        var bd = arr[0] + "-" + arr[1];
                        if (parseInt(ipPort[1]) >= 0x1000 && parseInt(ipPort[1]) <= 0x17FF) 
                        {
                            bd = "ML-PPP";
                            port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
                        }
                        else if (parseInt(ipPort[1]) >= 0x2800 && parseInt(ipPort[1]) <= 0x2FFF) 
                        {
                            bd = "Virtual Ethernet";
                            port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
                        }
                        st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML = bd;
                        st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT").element.innerHTML = port;
                        
                        var boardElem = st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARABORD");
                        if (boardElem.element.options.length == 0) 
						{
							var tmp = new Array();
							for (var i = 0, m = borrowedPorts.length; i < m; i++) 
							{
								var arr = new Array();
								var lastIndex = borrowedPorts[i].lastIndexOf("#");
								arr[0] = borrowedPorts[i].substring(0, lastIndex);
								arr[1] = borrowedPorts[i].substring(lastIndex + 1, borrowedPorts[i].length);
								
								port = arr[0];
								var tmpArr = port.split("-");
								var bd = tmpArr[0] + "-" + tmpArr[1];
								if (parseInt(arr[1]) >= 0x1000 && parseInt(arr[1]) <= 0x17FF) 
								{
									bd = "ML-PPP";
									port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
								}
								else if (parseInt(arr[1]) >= 0x2800 && parseInt(arr[1]) <= 0x2FFF) 
								{
									bd = "Virtual Ethernet";
									port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
								}
								if (!tmp.contains(bd)) 
								{
									tmp[tmp.length] = bd;
									boardElem.addOption(bd, arr[0] + "-" + arr[1]);
								}
							}
						}
                    }
                    else 
                    {
                        st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML = "";
                        st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT").element.innerHTML = "";
                    }
                    break;
                case IPTYPE_NEIP:
                case IPTYPE_UNSET:
                    var cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARA");
                    st.setCellIsEdit(cell, 0);
                    st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARA", "255.255.255.255");
                    st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARA").element.innerHTML = "-";
                    
                    cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARAT");
                    st.setCellIsEdit(cell, 0);
                    st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARAT", "255.255.255.255");
                    st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARAT").element.innerHTML = "-";
                    
                    cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARABORD");
                    st.setCellIsEdit(cell, 0);
                    st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARABORD", "65535");
                    st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARABORD").element.innerHTML = "-";
                    
                    cell = st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT");
                    st.setCellIsEdit(cell, 0);
                    st.setCellValue(cell, "PTNIF_PORT_ATTR_IPPARAPORT", "65535-UNKNOWN-65535#65535");
                    st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT").element.innerHTML = "-";
                    break;
                default:
                    break;
            }
        }
        
        validateIp(st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARA").element, true);
        validateIp(st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARAT").element, true);
        
        cell = st.getCellEdit(i, "PTNIF_PORT_ATTR_IPPARABORD");
        cell.element.onchange = function()
        {
            var rowIndex = this.parentNode.parentNode.rowIndex;
            var cell = st.getCellEdit(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT");
            cell.element.options.length = 0;
            
            var board = this.options[this.options.selectedIndex].text;
            for (var j = 0, n = borrowedPorts.length; j < n; j++) 
            {
                var ipPort = new Array();
                var lastIndex = borrowedPorts[j].lastIndexOf("#");
                ipPort[0] = borrowedPorts[j].substring(0, lastIndex);
                ipPort[1] = borrowedPorts[j].substring(lastIndex + 1, borrowedPorts[j].length);
                
                var port = ipPort[0];
                var arr = port.split("-");
                var bd = arr[0] + "-" + arr[1];
                if (parseInt(ipPort[1]) >= 0x1000 && parseInt(ipPort[1]) <= 0x17FF) 
                {
                    bd = "ML-PPP";
                    port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
                }
                else if (parseInt(ipPort[1]) >= 0x2800 && parseInt(ipPort[1]) <= 0x2FFF) 
                {
                    bd = "Virtual Ethernet";
                    port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
                }
                
                if (board == bd) 
                {
                    if (cell.element.options.length == 0) 
                    {
                        st.setCellValue(st.getCell(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT"), "PTNIF_PORT_ATTR_IPPARAPORT", borrowedPorts[j]);
                        st.getCellShow(rowIndex, "PTNIF_PORT_ATTR_IPPARAPORT").element.innerHTML = port;
                    }
                    break;
                }
            }
        }
    }
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("opertype", 1));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function getPortRes()
{
    var xml = createQueryXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MLPPP_RESOURCE_GET + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, getPortResCallBack, null, "inputdata=" + xml);
}

function getPortResCallBack(doc)
{
    var param = null;
    var options = null;
	borrowedPorts = new Array();
    var data = EncapsulateData(doc);
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        param = data.getDataRowParam(i, "borrowedports");
        if (null != param) 
        {
            options = data.getDataRowOptions(i, "borrowedports");
            for (var j = 0, n = options.length; j < n; j++) 
            {
                borrowedPorts[borrowedPorts.length] = options[j];
            }
        }
    }
}

function createApplyXML()
{
    var isModify = false;
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        row.appendChild(createTagElement("slotid", 0xFFFF));
        row.appendChild(createTagElement("subslotid", 0xFF));
        var groupNo = st.getCellCurrentValue(i, "groupno", "groupno");
        row.appendChild(createTagElement("groupnum", parseInt(groupNo) - 0x1000));
        row.appendChild(createTagElement("port", groupNo));
        
        if (st.getCellModify(i, "PTNIF_PORT_ATTR_IPPARATYPE") || st.getCellModify(i, "PTNIF_PORT_ATTR_IPPARA") || st.getCellModify(i, "PTNIF_PORT_ATTR_IPPARAT") || st.getCellModify(i, "PTNIF_PORT_ATTR_IPPARABORD") || st.getCellModify(i, "PTNIF_PORT_ATTR_IPPARAPORT")) 
        {
            var ipType = st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_IPPARATYPE", "PTNIF_PORT_ATTR_IPPARATYPE");
            row.appendChild(createTagElement("iptype", ipType));
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARATYPE", ipType == IPTYPE_UNSET ? IPTYPE_USERSET : ipType));
            
            var ipAddress = st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_IPPARA", "PTNIF_PORT_ATTR_IPPARA");
            row.appendChild(createTagElement("ipaddress", ipAddress));
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARA", parseInt("0x" + convertIpaddrToHexcode(ipAddress))));
            
            var ipMask = st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_IPPARAT", "PTNIF_PORT_ATTR_IPPARAT");
            row.appendChild(createTagElement("ipmask", ipMask));
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARAT", parseInt("0x" + convertIpaddrToHexcode(ipMask))));
            
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARABORD", st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_IPPARABORD", "PTNIF_PORT_ATTR_IPPARABORD").split("-")[0]));
            
            var v = st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_IPPARAPORT", "PTNIF_PORT_ATTR_IPPARAPORT");
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARAPORT", v.substring(v.lastIndexOf("#") + 1, v.length)));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApply()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createApplyXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MLPPP_MODIFY_ATTRIB + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyCallBack, null, "inputdata=" + xml);
}

function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};
