var st = null;
var Tab = null;
var countObj = null;

var btnRightArr = new Object();
var memberInterface = new Array();

var winobj = getNeProperty(top);
var neid = winobj.neid;
var nmUser = winobj.nmUser;

function init()
{
    initTable();
    initCountObj();
    initButton();
    initTabs();
    
    initRight();
    
    if (btnRightArr.querybtn.right) 
    {
        window.setTimeout(doQuery, 1000);
    }
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getComponetHeight($("tbdiv"), 300) + "px");
    
    $("tbdiv").oncontextmenu = popupMenuHandler;
}

function initCountObj()
{
    var countArea = document.createElement("div");
    $("countdiv").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
}

function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("newbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("resetbtn").value = RESOURCE["resetbutton"];
    $("runstatusbtn").value = RESOURCE["runstatusbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initTabs()
{
    Tab = new Tabs();
    Tab.setClass("tabs_head", "tabs_body", "tabs_ul", "tabs_li", "tabs_frame", "tabs_li_select");
    Tab.addTab(1, RESOURCE["memberinterface"], "memberinterface.html");
    Tab.tabNodes[1].body.style.height = "210px";
    
    Tab.selectTab(1);
    $("tabs").appendChild(Tab.getTabs());
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TECMDCODE_PTN_MLPPP_QUERY);
    btnRightArr.newbtn = new BtnRightObj("newbtn", TECMDCODE_PTN_MLPPP_CREATE);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", TECMDCODE_PTN_MLPPP_DELETE);
    btnRightArr.resetbtn = new BtnRightObj("resetbtn", TECMDCODE_PTN_MLPPP_RESET);
    btnRightArr.runstatusbtn = new BtnRightObj("runstatusbtn", TECMDCODE_PTN_MLPPP_QUERY_STATE);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TECMDCODE_PTN_MLPPP_MODIFY_ATTRIB);
    btnRightArr.configbtn = new BtnRightObj("configbtn", TECMDCODE_PTN_MLPPP_MODIFY_MEMBER);
    
    getRightInfo(winobj, btnRightArr);
}

function tabSelectHandler()
{
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    countObj.setSelectedCount(selectedRowCount);
    
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        $("resetbtn").disabled = !btnRightArr.resetbtn.right;
        $("runstatusbtn").disabled = !btnRightArr.runstatusbtn.right;
        
        Tab.getTabWindow(1).$("configbtn").disabled = !btnRightArr.configbtn.right;
        Tab.getTabWindow(1).$("querystatusbtn").disabled = !btnRightArr.runstatusbtn.right;
    }
    else 
    {
        $("deletebtn").disabled = true;
        $("resetbtn").disabled = true;
        $("runstatusbtn").disabled = true;
        
        Tab.getTabWindow(1).$("configbtn").disabled = true;
        Tab.getTabWindow(1).$("querystatusbtn").disabled = true;
    }
    Tab.getTabWindow(1).refreshTable();
}

function cellEditHandler()
{
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (st.getModify(i)) 
        {
            $("applybtn").disabled = !btnRightArr.applybtn.right;
            break;
        }
    }
}

function doQuery()
{
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("resetbtn").disabled = true;
    $("runstatusbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXml();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MLPPP_QUERY + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
        {
            var groupNo = data.getDataRowParam(i, "groupno");
            var portList = new Array();
            var port = data.getDataRowParam(i, "portlist");
            if (null != port) 
            {
                if ("" != port) 
                {
                    portList[portList.length] = port;
                    var options = data.getDataRowOptions(i, "portlist")
                    if (null != options) 
                    {
                        for (var j = 0, n = options.length; j < n; j++) 
                        {
                            portList[portList.length] = options[j];
                        }
                    }
                }
                var obj = new Object();
                obj.groupNo = groupNo;
                obj.portList = portList;
                memberInterface[groupNo] = obj;
            }
        }
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        addCellListener();
        
        countObj.setTotalCount(st.getDataRowLength());
        
        var ce = st.getHeadCell("groupno").element;
        st.sortRows(ce, 1);
        
    }
}

function addCellListener()
{
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        st.getCellShow(i, "linkstatus").element.innerHTML = "/";
        st.getCellShow(i, "ipaddressrst").element.innerHTML = "/";
        st.getCellShow(i, "ipmaskrst").element.innerHTML = "/";
        
        var groupNo = st.getCellCurrentValue(i, "groupno", "groupno");
        if (memberInterface[groupNo].portList.length <= 0) 
        {
            st.setCellIsEdit(st.getCell(i, "seqnumtype"), 1);
        }
        
        var cell = st.getCellElement(i, "PTNIF_PORT_ATTR_PORTNAME");
        cell.editElement.element.maxLength = 64;
        cell.editElement.element.onkeyup = function()
        {
            calStrSinoLen(this, 64);
        }
        
        cell = st.getCellElement(i, "minlinkcount");
        textCheck(cell.editElement.element, "1", "16");
        
        var delayen = parseInt(st.getCellCurrentValue(i, "delayen", "delayen"));
        if (delayen == 0) 
        {
            st.setCellIsEdit(st.getCell(i, "maxdelay"), 0);
            st.getCellShow(i, "maxdelay").element.innerHTML = "-";
        }
        else 
        {
            st.setCellIsEdit(st.getCell(i, "maxdelay"), 1);
            var maxdelay = parseInt(st.getCellCurrentValue(i, "maxdelay", "maxdelay"));
            st.setCellValue(st.getCell(i, "maxdelay"), "maxdelay", maxdelay / 100);
            st.getCellShow(i, "maxdelay").element.innerHTML = maxdelay / 100;
        }
        cell = st.getCellElement(i, "delayen");
        cell.editElement.element.onchange = function()
        {
            var rowIndex = this.parentNode.parentNode.rowIndex;
            if (parseInt(this.value) == 0) 
            {
                st.setCellIsEdit(st.getCell(rowIndex, "maxdelay"), 0);
                st.getCellShow(rowIndex, "maxdelay").element.innerHTML = "-";
            }
            else 
            {
                st.setCellIsEdit(st.getCell(rowIndex, "maxdelay"), 1);
                st.setCellValue(st.getCell(rowIndex, "maxdelay"), "maxdelay", "500");
                st.getCellShow(rowIndex, "maxdelay").element.innerHTML = "500";
            }
        }
        
        cell = st.getCellElement(i, "maxdelay");
        textCheck(cell.editElement.element, "25", "500");
        
        cell = st.getCellElement(i, "PTNIF_PORT_ATTR_MAXRESBW");
        textCheck(cell.editElement.element, "0", "4294967295");
        
        cell = st.getCellElement(i, "PTNIF_PORT_ATTR_TEMETRIC");
        textCheck(cell.editElement.element, "0", "16777215");
        
        cell = st.getCellElement(i, "PTNIF_PORT_ATTR_ADMINGROUP");
        textCheck(cell.editElement.element, "0", "4294967295");
    }
}

function doCreate()
{
    xshowModalDialog("creatempgroup.html", RESOURCE["creatempgroup"], 580, 680, "../../../../../images/");
}

function createSendXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var indexes = st.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("groupnum", st.getCellShow(indexes[i], "groupno").element.innerHTML));
        rowparams.appendChild(createTagElement("groupno", st.getCellCurrentValue(indexes[i], "groupno", "groupno")));
        
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doDelete()
{
    if (!confirm(RESOURCE["SERVICE_BREAK_WARN"])) 
    {
        return;
    }
    
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    $("resetbtn").disabled = true;
    $("runstatusbtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createSendXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MLPPP_DELETE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}

function deleteCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var indexes = st.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var groupId = data.getBErrParam(i, "groupno");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var groupNo = st.getCellCurrentValue(indexes[j], "groupno", "groupno");
            if (groupId == groupNo) 
            {
                indexes.splice(j, 1);
                break;
            }
        }
    }
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        memberInterface[st.getCellCurrentValue(indexes[k], "groupno", "groupno")] = null;
        st.deleteRow(indexes[k]);
    }
    st.adjustDataRows();
    
    countObj.setTotalCount(st.getDataRowLength());
    if (st.getSelectedRowCount() <= 0 && st.getDataRowLength() > 0) 
    {
        st.setRowSelect(0);
    }
    rowSelectHandler();
}

function doReset()
{
    if (!confirm(RESOURCE["SERVICE_BREAK_WARN"])) 
    {
        return;
    }
    
    var xml = createSendXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MLPPP_RESET + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, resetCallBack, null, "inputdata=" + xml);
}

function resetCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
}

function doRunStatus()
{
    var xml = createSendXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MLPPP_QUERY_STATE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, runStatusCallBack, null, "inputdata=" + xml);
}

function runStatusCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var indexes = st.getSelectedRows();
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        var groupId = data.getDataRowParam(i, "groupno");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var groupNo = st.getCellCurrentValue(indexes[j], "groupno", "groupno");
            if (groupId == groupNo) 
            {
                var v = parseInt(data.getDataRowParam(i, "linkstatus"));
                st.setCellValue(st.getCell(indexes[j], "linkstatus"), "linkstatus", v);
                st.getCellShow(indexes[j], "linkstatus").element.innerHTML = RESOURCE[linkStatus[v]];
                
                var v = data.getDataRowParam(i, "ipaddressrst");
                st.setCellValue(st.getCell(indexes[j], "ipaddressrst"), "ipaddressrst", v);
                st.getCellShow(indexes[j], "ipaddressrst").element.innerHTML = convertNumToIpaddr(v);
                
                var v = data.getDataRowParam(i, "ipmaskrst");
                st.setCellValue(st.getCell(indexes[j], "ipmaskrst"), "ipmaskrst", v);
                st.getCellShow(indexes[j], "ipmaskrst").element.innerHTML = convertNumToIpaddr(v);
                break;
            }
        }
    }
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", neid));
        
        var groupNo = st.getCellCurrentValue(i, "groupno", "groupno");
        row.appendChild(createTagElement("groupnum", groupNo - 0x1000));
        row.appendChild(createTagElement("groupno", groupNo));
        row.appendChild(createTagElement("slotid", 0xFFFF));
        row.appendChild(createTagElement("subslotid", 0xFF));
        row.appendChild(createTagElement("port", groupNo));
        
        if (st.getCellModify(i, "PTNIF_PORT_ATTR_PORTNAME")) 
        {
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_PORTNAME", st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_PORTNAME", "PTNIF_PORT_ATTR_PORTNAME")));
        }
        
        if (st.getCellModify(i, "minlinkcount")) 
        {
            row.appendChild(createTagElement("minlinkcount", st.getCellCurrentValue(i, "minlinkcount", "minlinkcount")));
        }
        
        if (st.getCellModify(i, "delayen") || st.getCellModify(i, "maxdelay")) 
        {
            row.appendChild(createTagElement("delayen", st.getCellCurrentValue(i, "delayen", "delayen")));
            row.appendChild(createTagElement("maxdelay", parseInt(st.getCellCurrentValue(i, "maxdelay", "maxdelay")) * 100));
        }
        
        if (st.getCellModify(i, "PTNIF_PORT_ATTR_MPLSEN")) 
        {
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_MPLSEN", st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_MPLSEN", "PTNIF_PORT_ATTR_MPLSEN")));
        }
        
        if (st.getCellModify(i, "PTNIF_PORT_ATTR_MAXRESBW")) 
        {
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_MAXRESBW", st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_MAXRESBW", "PTNIF_PORT_ATTR_MAXRESBW")));
        }
        
        if (st.getCellModify(i, "PTNIF_PORT_ATTR_TEMETRIC")) 
        {
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_TEMETRIC", st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_TEMETRIC", "PTNIF_PORT_ATTR_TEMETRIC")));
        }
        
        if (st.getCellModify(i, "PTNIF_PORT_ATTR_ADMINGROUP")) 
        {
            row.appendChild(createTagElement("PTNIF_PORT_ATTR_ADMINGROUP", st.getCellCurrentValue(i, "PTNIF_PORT_ATTR_ADMINGROUP", "PTNIF_PORT_ATTR_ADMINGROUP")));
        }
        
        if (st.getCellModify(i, "seqnumtype")) 
        {
            row.appendChild(createTagElement("seqnumtype", st.getCellCurrentValue(i, "seqnumtype", "seqnumtype")));
        }

        if (st.getCellModify(i, "fragsize")) 
        {
            row.appendChild(createTagElement("fragsize", st.getCellCurrentValue(i, "fragsize", "fragsize")));
        }

        if (st.getCellModify(i, "ATTR_ETHOVERPTN_MAC_MAXPKTLEN")) 
        {
            row.appendChild(createTagElement("ATTR_ETHOVERPTN_MAC_MAXPKTLEN", st.getCellCurrentValue(i, "ATTR_ETHOVERPTN_MAC_MAXPKTLEN", "ATTR_ETHOVERPTN_MAC_MAXPKTLEN")));
        }
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApply()
{
    $("applybtn").disabled = true;
    
    var xml = createApplyXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MLPPP_MODIFY_ATTRIB + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyCallBack, null, "inputdata=" + xml);
}

function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}
