var st = null;
var index = -1;
var groupNo = -1;

function init()
{
    initTable();
    initButton();
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight("120px");
    
    $("tbdiv").oncontextmenu = popupMenuHandler;
}

function initButton()
{
    $("configbtn").value = RESOURCE["configbutton"];
    $("querystatusbtn").value = RESOURCE["querystatusbutton"];
}

function createjsDOMenu()
{
    removejsDOMmenu();
    
    var cursorMenu = new jsDOMenu(150);
    cursorMenu.addMenuItem(new menuItem(RESOURCE["querystatusbutton"], "", doQueryStatus, "menu", parent.btnRightArr.runstatusbtn.right));
    cursorMenu.addMenuItem(new menuItem(RESOURCE["deletebutton"], "", doDelete, "", parent.btnRightArr.configbtn.right));
    setPopUpMenu(cursorMenu);
}

function popupMenuHandler()
{
    if (st.getSelectedRowCount() > 0) 
    {
        createjsDOMenu();
        
        rightClickHandler();
    }
}

function refreshTable()
{
    st.clearTableData();
    
    var pst = parent.st;
    if (pst.getSelectedRowCount() > 0) 
    {
        index = pst.getSelectedRows()[0];
        groupNo = pst.getCellCurrentValue(index, "groupno", "groupno");
        
        var mIF = parent.memberInterface[groupNo];
        if (null != mIF) 
        {
            fillInterface(mIF);
        }
    }
}

function fillInterface(obj)
{
    var root = document.createElement("datainterface");
    var firstlevel = document.createElement("bussiness-params");
    
    for (var i = 0, m = obj.portList.length; i < m; i++) 
    {
        var secondlevel = document.createElement("row-params");
        
        var thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "groupno");
        thirdlevel.setAttribute("value", obj.groupNo);
        secondlevel.appendChild(thirdlevel);
        
        var port = new Array();
		port[0] = obj.portList[i].substring(0, obj.portList[i].lastIndexOf("#"));
		port[1] = obj.portList[i].substring(obj.portList[i].lastIndexOf("#") + 1, obj.portList[i].length);
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "interface");
        thirdlevel.setAttribute("value", port[0]);
        secondlevel.appendChild(thirdlevel);
        
        var arr = port[0].split("-");
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "slotid");
        thirdlevel.setAttribute("value", arr[0]);
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "portid");
        thirdlevel.setAttribute("value", port[1]);
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "ppplinkstatus");
        thirdlevel.setAttribute("value", "/");
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = document.createElement("param");
        thirdlevel.setAttribute("name", "delaycheckstatus");
        thirdlevel.setAttribute("value", "/");
        secondlevel.appendChild(thirdlevel);
        
        firstlevel.appendChild(secondlevel);
    }
    root.appendChild(firstlevel);
    
    createTableBody(st, window.tableconf[0], EncapsulateData(root), RESOURCE);
}

function doConfig()
{
    hideMenu();
    xshowModalDialog("configmemberinterface.html", RESOURCE["configmemberinterface"], 600, 400, "../../../../../images/");
}

function createQueryStatusXML(param)
{
    var indexes = st.getSelectedRows();
    if ("button" == param) 
    {
        indexes = new Array();
        for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
        {
            indexes[indexes.length] = i;
        }
    }
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    for (var j = 0, n = indexes.length; j < n; j++) 
    {
        var rowparams = new tagElement("row-params");
        
        rowparams.appendChild(createTagElement("neid", parent.neid));
        rowparams.appendChild(createTagElement("groupnum", parseInt(st.getCellCurrentValue(indexes[j], "groupno", "groupno") - 0x1000)));
        rowparams.appendChild(createTagElement("interface", st.getCellCurrentValue(indexes[j], "interface", "interface")));
        rowparams.appendChild(createTagElement("slotid", st.getCellCurrentValue(indexes[j], "port", "slotid")));
        rowparams.appendChild(createTagElement("port", st.getCellCurrentValue(indexes[j], "port", "portid")));
        
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doQueryStatus(param)
{
    hideMenu();
    if (st.getDataRowLength() > 0) 
    {
        var xml = createQueryStatusXML(param);
        var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MLPPP_QUERY_STATE + "&nmUser=" + parent.nmUser;
        loadXMLdoc(url, "POST", false, queryStatusCallBack, null, "inputdata=" + xml);
    }
}

function queryStatusCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        var slot = data.getDataRowParam(i, "slotid");
        var port = data.getDataRowParam(i, "port");
        for (var j = 0, n = st.getDataRowLength(); j < n; j++) 
        {
            var slotid = st.getCellCurrentValue(j, "port", "slotid");
            var portid = st.getCellCurrentValue(j, "port", "portid");
            if (slotid == slot && portid == port) 
            {
                var v = data.getDataRowParam(i, "ppplinkstatus");
                st.setCellValue(st.getCell(j, "ppplinkstatus"), "ppplinkstatus", v);
                st.getCellShow(j, "ppplinkstatus").element.innerHTML = RESOURCE[linkStatus[v]];
                
                v = data.getDataRowParam(i, "delaycheckstatus");
                st.setCellValue(st.getCell(j, "delaycheckstatus"), "delaycheckstatus", v);
                st.getCellShow(j, "delaycheckstatus").element.innerHTML = RESOURCE[delayCheckStatus[v]];
                break;
            }
        }
    }
}

function createDeleteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", parent.neid));
    rowparams.appendChild(createTagElement("groupnum", groupNo - 0x1000));
    rowparams.appendChild(createTagElement("membercount", st.getDataRowLength() - st.getSelectedRowCount()));
    bussiness.appendChild(rowparams);
    
    var indexes = st.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        rowparams = new tagElement("row-params");
        
        rowparams.appendChild(createTagElement("neid", parent.neid));
        rowparams.appendChild(createTagElement("groupno", groupNo));
        rowparams.appendChild(createTagElement("rmvslotid", st.getCellCurrentValue(indexes[i], "port", "slotid")));
        rowparams.appendChild(createTagElement("rmvport", st.getCellCurrentValue(indexes[i], "port", "portid")));
        
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doDelete()
{
    hideMenu();
    var xml = createDeleteXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MLPPP_MODIFY_MEMBER + "&nmUser=" + parent.nmUser;
    loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}

function deleteCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var indexes = st.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var slotid = data.getBErrParam(i, "rmvslotid");
        var portid = data.getBErrParam(i, "rmvport");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var slot = st.getCellCurrentValue(indexes[j], "port", "slotid");
            var port = st.getCellCurrentValue(indexes[j], "port", "portid");
            if (slotid == slot && portid == port) 
            {
                indexes.splice(j, 1);
                break;
            }
        }
    }
    
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        var groupNo = st.getCellCurrentValue(indexes[k], "groupno", "groupno");
        parent.memberInterface[groupNo].portList.remove(st.getCellCurrentValue(indexes[k], "interface", "interface"));
        st.deleteRow(indexes[k]);
    }
    st.adjustDataRows();
    
    if (st.getDataRowLength() <= 0) 
    {
        parent.st.setCellIsEdit(parent.st.getCell(index, "seqnumtype"), 1);
    }
}
