var ct = null;
var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;

function init()
{
    initInterface();
    initTable();
    getPortRes(0);
    fillAvailablePorts();
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["getvalue"]);
    
    var atom = new Atom("text");
    checkText(atom.element, "0", "2047");
    if( isAboveRTN0510() )
    {
    	checkText(atom.element, "0", "255");
    }
    ct.addAttrRow("groupno", RESOURCE["groupno"], atom);
    
    atom = new Atom("text");
    checkTextData(atom.element, 64);
    ct.addAttrRow("name", RESOURCE["name"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["ipspecify1"], "1");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["ipspecify2"], "2");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["ipspecify3"], "3");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["ipspecify255"], "255");
    atom.element.onchange = changeIPSpecify;
    ct.addAttrRow("ipspecify", RESOURCE["ipspecify"], atom);
    
    atom = new Atom("text");
    validateIp(atom.element);
    atom.setValue("0.0.0.0");
    ct.addAttrRow("ipaddress", RESOURCE["ipaddress"], atom);
    
    atom = new Atom("text");
    validateIp(atom.element);
    atom.setValue("255.255.255.252");
    ct.addAttrRow("ipmask", RESOURCE["ipmask"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.element.disabled = true;
    atom.element.options[atom.element.options.length] = new Option("-", "65535");
    atom.element.onchange = changeBorrowedBoard;
    ct.addAttrRow("borrowedboard", RESOURCE["borrowedboard"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.element.disabled = true;
    atom.element.options[atom.element.options.length] = new Option("-", "65535");
    ct.addAttrRow("borrowedport", RESOURCE["borrowedport"], atom);
    
    atom = new Atom("text");
    atom.setValue("1");
    checkText(atom.element, "1", "16");
    ct.addAttrRow("minlinkcount", RESOURCE["minlinkcount"], atom);
    
    atom = new Atom("select");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["enabled"], "1");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["disabled"], "0");
    atom.element.options.selectedIndex = 1;
    atom.element.onchange = changeDelayEnable;
    ct.addAttrRow("delayen", RESOURCE["delayenable"], atom);
    
    atom = new Atom("text");
    atom.element.disabled = true;
    atom.setValue("-");
    checkText(atom.element, "25", "500");
    ct.addAttrRow("maxdelay", RESOURCE["maxdelay"], atom);
    
    atom = new Atom("select");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["enabled"], "1");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["disabled"], "0");
    atom.element.options.selectedIndex = 1;
    ct.addAttrRow("mplsen", RESOURCE["mplsen"], atom);

    if( isAboveRTN0510() )
    {
        atom = new Atom("text");
        checkText(atom.element, "960", "1900");
        atom.setValue("1620");
    	ct.addAttrRow("mtu", RESOURCE["MTU"], atom);
    	
        atom = new Atom("select");
        atom.element.options[atom.element.options.length] = new Option("64", "64");
        atom.element.options[atom.element.options.length] = new Option("128", "128");
        atom.element.options[atom.element.options.length] = new Option("256", "256");
        atom.element.options[atom.element.options.length] = new Option("512", "512");
        atom.element.options[atom.element.options.length] = new Option(RESOURCE["NOFRAG"], "0");
    	ct.addAttrRow("fragsize", RESOURCE["fragsize"], atom);
    }
    
    atom = new Atom("select");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["huawei"], "0");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["shortserial"], "1");
    atom.element.options[atom.element.options.length] = new Option(RESOURCE["longserial"], "2");
    ct.addAttrRow("seqnumtype", RESOURCE["seqnumtype"], atom);
    
    $("tbdiv").appendChild(ct.getTable());
}

function changeIPSpecify()
{
    var ipAddrAtom = ct.getAtom("ipaddress");
    var ipMaskAtom = ct.getAtom("ipmask");
    var boBdAtom = ct.getAtom("borrowedboard");
    var boPortAtom = ct.getAtom("borrowedport");
    switch (parseInt(ct.getAtom("ipspecify").getValue()))
    {
        case IPTYPE_USERSET:
            ipAddrAtom.setValue("0.0.0.0");
            ipAddrAtom.element.disabled = false;
            ipMaskAtom.setValue("255.255.255.252");
            ipMaskAtom.element.disabled = false;
            
            boBdAtom.element.disabled = true;
            boBdAtom.element.options.length = 0;
            boBdAtom.element.options[boBdAtom.element.options.length] = new Option("-", "65535");
            boPortAtom.element.disabled = true;
            boPortAtom.element.options.length = 0;
            boPortAtom.element.options[boPortAtom.element.options.length] = new Option("-", "65535");
            break;
        case IPTYPE_PORTIP:
            ipAddrAtom.setValue("-");
            ipAddrAtom.element.disabled = true;
            ipMaskAtom.setValue("-");
            ipMaskAtom.element.disabled = true;
            
            fillBorrowedPorts(boBdAtom.element.options)
            boBdAtom.element.disabled = false;
            boPortAtom.element.disabled = false;
            break;
        case IPTYPE_NEIP:
        case IPTYPE_UNSET:
            ipAddrAtom.setValue("-");
            ipAddrAtom.element.disabled = true;
            ipMaskAtom.setValue("-");
            ipMaskAtom.element.disabled = true;
            
            boBdAtom.element.disabled = true;
            boBdAtom.element.options.length = 0;
            boBdAtom.element.options[boBdAtom.element.options.length] = new Option("-", "65535");
            boPortAtom.element.disabled = true;
            boPortAtom.element.options.length = 0;
            boPortAtom.element.options[boPortAtom.element.options.length] = new Option("-", "65535");
            break;
        default:
            break;
    }
}

function changeBorrowedBoard()
{
    var options = ct.getAtom("borrowedport").element.options;
    options.length = 0;
    var bdoptions = ct.getAtom("borrowedboard").element.options;
    var sIndex = bdoptions.selectedIndex;
    if (sIndex < 0) 
    {
        return;
    }
    var slotid = bdoptions[sIndex].text;
    for (var i = 0, m = borrowedPorts.length; i < m; i++) 
    {
		var tmp = new Array();
		var lastIndex = borrowedPorts[i].lastIndexOf("#");
		tmp[0] = borrowedPorts[i].substring(0, lastIndex);
		tmp[1] = borrowedPorts[i].substring(lastIndex + 1, borrowedPorts[i].length);
		
        var portid = parseInt(tmp[1]);
        var bport = tmp[0].split("-");
        var bd = bport[0] + "-" + bport[1];
        var port = tmp[0];
        if (portid >= 0x1000 && portid <= 0x17FF) 
        {
            bd = "ML-PPP";
            port = tmp[0].substring(tmp[0].indexOf("-", tmp[0].indexOf("-") + 1) + 1, tmp[0].length);
        }
		else if (portid >= 0x2800 && portid <= 0x2FFF) 
        {
            bd = "Virtual Ethernet";
            port = tmp[0].substring(tmp[0].indexOf("-", tmp[0].indexOf("-") + 1) + 1, tmp[0].length);
        }
        if (bd == slotid) 
        {
            options[options.length] = new Option(port, tmp[1]);
        }
    }
}

function fillBorrowedPorts(options)
{
    options.length = 0;
    var tmpbd = new Array();
    for (var i = 0, m = borrowedPorts.length; i < m; i++) 
    {
        var tmp = new Array();
		var lastIndex = borrowedPorts[i].lastIndexOf("#");
		tmp[0] = borrowedPorts[i].substring(0, lastIndex);
		tmp[1] = borrowedPorts[i].substring(lastIndex + 1, borrowedPorts[i].length);
		
        var portid = parseInt(tmp[1]);
        var bport = tmp[0].split("-");
        var board = bport[0] + "-" + bport[1];
        if (portid >= 0x1000 && portid <= 0x17FF) 
        {
            board = "ML-PPP";
        }
		else if (portid >= 0x2800 && portid <= 0x2FFF) 
        {
            board = "Virtual Ethernet";
        }
        if (!tmpbd.contains(board)) 
        {
            options[options.length] = new Option(board, bport[0]);
            tmpbd[tmpbd.length] = board;
        }
    }
    tmpbd.clear();
    
    changeBorrowedBoard();
}

function changeDelayEnable()
{
    var atom = ct.getAtom("maxdelay");
    if (parseInt(this.value) == 1) 
    {
        atom.element.disabled = false;
        atom.setValue("500");
    }
    else 
    {
        atom.element.disabled = true;
        atom.setValue("-");
    }
}

function validate()
{
    var msgArr = new Array();
    if (ct.getAtom("groupno").getValue() == "") 
    {
        msgArr[msgArr.length] = RESOURCE["groupno"] + RESOURCE["rangemsg"] + "0~2047";
        isValid = false;
    }
    if (ct.getAtom("name").getValue().trim() == "") 
    {
        msgArr[msgArr.length] = RESOURCE["name"];
    }
    var ip = ct.getAtom("ipaddress").getValue();
    if (ip != "-" && (ip == "" || ip == "0.0.0.0")) 
    {
        msgArr[msgArr.length] = RESOURCE["ipaddress"] + RESOURCE["inputmsg"] + "'0.0.0.0'";
    }
    if (ct.getAtom("ipmask").getValue() == "0.0.0.0") 
    {
        msgArr[msgArr.length] = RESOURCE["ipmask"] + RESOURCE["inputmsg"] + "'0.0.0.0'";
    }
    var borrowedBoard = ct.getAtom("borrowedboard").getValue();
    if (borrowedBoard != "-" && borrowedBoard == "") 
    {
        msgArr[msgArr.length] = RESOURCE["borrowedboard"];
    }
    var borrowedPort = ct.getAtom("borrowedport").getValue();
    if (borrowedPort != "-" && borrowedPort == "") 
    {
        msgArr[msgArr.length] = RESOURCE["borrowedport"];
    }
    
    if (msgArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
    }
    else 
    {
        return true;
    }
}

function createMPGroupXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    var groupNum = parseInt(ct.getAtom("groupno").getValue());
    var groupNo = groupNum + 0x1000;
    rowparams.appendChild(createTagElement("groupnum", groupNum));
    rowparams.appendChild(createTagElement("membercount", st.getDataRowLength()));
    rowparams.appendChild(createTagElement("groupno", groupNo));
    rowparams.appendChild(createTagElement("slotid", 0xFFFF));
    rowparams.appendChild(createTagElement("subslotid", 0xFF));
    rowparams.appendChild(createTagElement("port", groupNo));
    rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_PORTNAME", ct.getAtom("name").getValue()));
    
    if( isAboveRTN0510() )
    {
    	rowparams.appendChild(createTagElement("ATTR_ETHOVERPTN_MAC_MAXPKTLEN", ct.getAtom("mtu").getValue()));
    	rowparams.appendChild(createTagElement("fragsize", ct.getAtom("fragsize").getValue()));
    }
    
    var ipSpecify = parseInt(ct.getAtom("ipspecify").getValue());
    rowparams.appendChild(createTagElement("iptype", ipSpecify));
    
    var ipAddress = "255.255.255.255";
    var ipMask = "255.255.255.255";
    var borrowedBoard = 0xFFFF;
    var borrowedPort = 0xFFFF;
    switch (ipSpecify)
    {
        case IPTYPE_USERSET:
            ipAddress = ct.getAtom("ipaddress").getValue();
            ipMask = ct.getAtom("ipmask").getValue();
            break;
        case IPTYPE_PORTIP:
            borrowedBoard = parseInt(ct.getAtom("borrowedboard").getValue());
            borrowedPort = parseInt(ct.getAtom("borrowedport").getValue());
            break;
        case IPTYPE_UNSET:
            ipSpecify = IPTYPE_USERSET;
            break;
        default:
            break;
    }
    
    rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARATYPE", ipSpecify));
    rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARA", parseInt("0x" + convertIpaddrToHexcode(ipAddress))));
    rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARAT", parseInt("0x" + convertIpaddrToHexcode(ipMask))));
    rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARABORD", borrowedBoard));
    rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_IPPARAPORT", borrowedPort));
    
    rowparams.appendChild(createTagElement("minlinkcount", ct.getAtom("minlinkcount").getValue()));
    
    var maxDelay = 50000; // default value
    var delayEn = parseInt(ct.getAtom("delayen").getValue());
    rowparams.appendChild(createTagElement("delayen", delayEn));
    if (delayEn == 1) 
    {
        maxDelay = parseInt(ct.getAtom("maxdelay").getValue() * 100);
    }
    rowparams.appendChild(createTagElement("maxdelay", maxDelay));
    
    rowparams.appendChild(createTagElement("PTNIF_PORT_ATTR_MPLSEN", ct.getAtom("mplsen").getValue()));
    rowparams.appendChild(createTagElement("seqnumtype", ct.getAtom("seqnumtype").getValue()));
    bussiness.appendChild(rowparams);
    
    for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
    {
        rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("groupnum", groupNo));
        rowparams.appendChild(createTagElement("addslotid", st.getCellCurrentValue(i, "port", "slotid")));
        rowparams.appendChild(createTagElement("addport", st.getCellCurrentValue(i, "port", "portid")));
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doCreate(param)
{
    if (!validate()) 
    {
        return;
    }
    var xml = createMPGroupXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MLPPP_CREATE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createCallBack, param, "inputdata=" + xml);
}

function createCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        win.doQuery();
        if (param && data.getSErrorCode() == 0) 
        {
            xcloseDialog();
        }
        else 
        {
            refreshData();
        }
    }
}

function refreshData()
{
    ct.getAtom("groupno").setValue("");
    ct.getAtom("name").setValue("");
    ct.getAtom("ipspecify").element.options.selectedIndex = 0;
    changeIPSpecify();
    ct.getAtom("minlinkcount").setValue("1");
    ct.getAtom("delayen").element.options.selectedIndex = 1;
    changeDelayEnable();
    ct.getAtom("mplsen").element.options.selectedIndex = 1;
    ct.getAtom("seqnumtype").element.options.selectedIndex = 0;
    
    st.clearTableData();
    
    getPortRes(0);
    fillAvailablePorts();
}

function isAboveRTN0510()
{
	var result = false;
	var urlObj = getNeProperty(getParentWindow().parent);
	var verArray = urlObj.neversion.split(".");
	
	if( urlObj.domain == "rtn" && verArray[2] >= "05" )
	{
		result = true;
	}
	return result;
}
