 
var obj = getNeProperty(self);

var srcdirection = [];
srcdirection["1"] = "INGRESS";
srcdirection["2"] = "EGRESS";

/**	"local",           0
	"remote",          1
    "observe",         2
 */
var mirrorTypeConvert = [];
mirrorTypeConvert["0"] = "local";
mirrorTypeConvert["1"] = "remote";
mirrorTypeConvert["2"] = "observe";

var srcPointTypeConvert = [];
srcPointTypeConvert["0"] = "phyport";
srcPointTypeConvert["1"] = "vunimode";
srcPointTypeConvert["2"] = "vnnimode";

var LOCAL_MIRROR=0;

window.onload = function()
{
    st = new SortTable();
    st.setImage("../../../../../images/");  
    createTableHead(st, window.tableconf[0]);
    
    $("table").appendChild(st.getTable());  
    $("table").oncontextmenu = rightClickEvent;
    
    st.setBodyHeight(getTableHeight($(table),st)+"px");
    
    st.setOnCellEditHandler(cellEditHandler);
    
    st.setOnRowSelectHandler(deleteRow);
    
    $("querybutton").value = RESOURCE["querybutton"];
    $("newbutton").value = RESOURCE["newbutton"];
    $("deletebutton").value = RESOURCE["deletebutton"];
    $("applybutton").value = RESOURCE["applybutton"];
    
    $("deletebutton").disabled = true;
    $("applybutton").disabled = true;

    sendRightInfo();
    
    if(!$("querybutton").disabled)
    {
    	sendQueryInfo();
    }
}

function cellEditHandler(param)
{
	$("applybutton").disabled = !hasRight["applybutton"];
}


function createjsDOMenu()
{	
	removejsDOMmenu();
	var isSelected = false;
	
	for(var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		if(st.getRowSelFlag(i))
		{
			isSelected = true;
			break;
		}
	}
	
	if(!isSelected)
	{
		return;
	}
	
	if(hasRight["deletebutton"] == false)
	{
      	isSelected = false;
  	}
    var cursorMenu = new jsDOMenu(120); //    120
   
    cursorMenu.addMenuItem(new menuItem(RESOURCE["deletebutton"], "",deleteData, "", isSelected));
    
    setPopUpMenu(cursorMenu);
    
    showMenu();
}
/**
 *   
 */
function rightClickEvent()
{
	createjsDOMenu();
}

function createQueryNeXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",obj.neid);
    row.appendChild(param);

    var param = new tagElement("param");
    param.setAttribute("name","srcPortType");
    param.setAttribute("value",LOCAL_MIRROR);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);

    return di.toString();
}

function setData()
{
	for (var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
	   var srcPointType = st.getCellStoreValue(i, "srcPointType", "srcPointType");
	   var taglistvar = st.getCellStoreValue(i, "vlanIDList", "vlanIDList");
	   if (obj.neType == 36)
	   {
		   if (srcPointType == "1" && taglistvar.indexOf(",")>0 || taglistvar.indexOf("-")>0)
		   {
			   alert(RESOURCE["vlanalert"]);
			   return;
		   }
	    }
	}
	$("querybutton").disabled = true;
	$("newbutton").disabled = true;
	$("deletebutton").disabled = true;
	$("applybutton").disabled = true;
  	var xmlstr = createSetXML();    
  	urlreq ="../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MIRRORMGR_MODIFY + "&nmUser="+obj["nmUser"];
  	loadXMLdoc(urlreq, "POST",false,setCallBack,null,"inputdata="+xmlstr);
}

function setCallBack(doc,rowindex)
{
	var data = EncapsulateData(doc);
    
    if(data.getSErrorCode() != 0)
    {
    	$("querybutton").disabled = false;
		$("newbutton").disabled = !hasRight["applybutton"];
		$("deletebutton").disabled = !hasRight["applybutton"];
		$("applybutton").disabled = !hasRight["applybutton"];
	
    	showErrorDialog(data);
    	return;
    }
    
    $("deletebutton").disabled = true;
    
    sendQueryInfo();
}

function createSetXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = null;
  
    for (var i = 0, len = st.getDataRowLength(); i < len; i++)
    {
    	var srcPointType = st.getCellStoreValue(i, "srcPointType", "srcPointType");
    	if (!st.getModify(i) || srcPointType == 0)//  UNI NNI     vlan  
    	{
    		continue;	
    	}


     	var mirrorIndex = st.getCellStoreValue(i, "mirrorServiceIndex", "mirrorServiceIndex");
	    var taglistvar = st.getCellStoreValue(i, "vlanIDList", "vlanIDList");
	    
    	row = new tagElement("row-params");
	    var param = new tagElement("param");
	    param.setAttribute("name", "neid");
	    param.setAttribute("value", obj.neid);
	    row.appendChild(param);
	
	    param = new tagElement("param");
	    param.setAttribute("name", "mirrorServiceIndex");
	    param.setAttribute("value", mirrorIndex);
	    row.appendChild(param);
	    
	    param = new tagElement("param");
	    param.setAttribute("name", "taglist");
	    param.setAttribute("value", taglistvar);
	    row.appendChild(param);
	    
	    bussiness.appendChild(row);
    }
    di.getRoot().appendChild(bussiness);

    return di.toString();
}

function sendQueryInfo()
{
	$("querybutton").disabled = true;
	$("newbutton").disabled = true;
	$("deletebutton").disabled = true;
	$("applybutton").disabled = true;
	
  	var xmlstr = createQueryNeXML();    
  	urlreq ="../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MIRRORMGR_QUERY + "&nmUser="+obj["nmUser"];
  	loadXMLdoc(urlreq, "POST",false,queryCallBack,null,"inputdata="+xmlstr);
}

function queryCallBack(doc)
{
	$("querybutton").disabled = false;
	$("newbutton").disabled = !hasRight["newbutton"];
    var data = EncapsulateData(doc);
    
    if(data.getSErrorCode() == 2)
    {
    	showErrorDialog(data);
    	return;
    }
    
    st.clearTableData();
    
    createTableBody(st, window.tableconf[0], data, RESOURCE);

	for (var i = 0, len = st.getDataRowLength(); i < len; i++)
	{
		var vlanidlist = st.getCellStoreValue(i, "vlanIDList", "vlanIDList");
		var vlancell = st.getCell(i, "vlanIDList")
		if (vlanidlist == "-")
		{
			st.setCellIsEdit(vlancell, "0");
		}
		
		var vlanCellEdit = st.getCellEdit(i, "vlanIDList").element;
		limitVlanInput(vlanCellEdit, "1", "4094");
	}
    
    if(data.getSErrorCode() == 0)
    {
    	return;
    }
    
    showErrorDialog(data);
    
}

function deleteData()
{
	hideMenu();
    if(st.getSelectedRowCount())
    {
    	var rowindex = st.getSelectedRows();
    	if(confirm(RESOURCE["deleteconfirm"]))
    	{
    		var di = new inputxml("datainterface");
	        var bp = new tagElement("bussiness-params");
	        for(i = 0; i < st.getDataRowLength(); i++)
	        {
	            if(st.getRowSelFlag(i))
	            {
	                var row = new tagElement("row-params");                        
	                var param = new tagElement("param");
	                param.setAttribute("name", "neid");
	                param.setAttribute("value", obj["neid"]);
	                row.appendChild(param);
	                
	                param = new tagElement("param");
	                param.setAttribute("name", "mirrorServiceIndex");
	                var mirrorindex = st.getCellStoreValue(i, "mirrorServiceIndex", "mirrorServiceIndex");               
	                
	                param.setAttribute("value", mirrorindex);
	                row.appendChild(param);
	                
	                param = new tagElement("param");
	                param.setAttribute("name", "mirrorport");
	                var mirrorindex = st.getCellStoreValue(i, "srcPointName", "srcPointName");              
 	                param.setAttribute("value", mirrorindex);
	                row.appendChild(param);
	                
	                param = new tagElement("param");
	                param.setAttribute("name", "obsmirrorport");
	                var mirrorindex = st.getCellStoreValue(i, "obsPointName", "obsPointName");              
 	                param.setAttribute("value", mirrorindex);
	                row.appendChild(param);
	                
	                bp.appendChild(row);
	            }
	        }
	        
	        di.getRoot().appendChild(bp);
            $("deletebutton").disabled = !hasRight["deletebutton"];
			
	        var URL = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_MIRRORMGR_DELETE + "&flag=1&timestamp="+new Date().getTime()+"&nmUser="+obj["nmUser"];
	        loadXMLdoc(URL,"POST", true, detelteCallBack, rowindex, "inputdata="+di.toString());
	    }
    }
    else
    {
        alert(RESOURCE["pleaseSelect"]);
    }
}


function detelteCallBack(doc,rowindex)
{
	var data = EncapsulateData(doc);
    
    if(data.getSErrorCode() != 0)
    {
    	showErrorDialog(data);
    	return;
    }
    
    $("deletebutton").disabled = true;
    
    sendQueryInfo();
}

function create()
{
	/**
	 * MSOTN                         
	 */
    xshowModalDialog("creatmirrormain.html?mirrortype="+LOCAL_MIRROR,RESOURCE["portmirrormgr"],560,300,"../../../../../images/")
}

function showErrorDialog(data)
{
	var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr); 
}

/**
 * 
 */
function deleteRow(indexArr)
{
	if(indexArr.length>0 && hasRight["deletebutton"] == true)
	{
	    $("deletebutton").disabled = false;
	}
	else
	{
		$("deletebutton").disabled = true;
	}
}

/**
 *       
 * 
 * @param  
 * @return  
 */ 
function sendRightInfo()
{
	var url = "../../../../../securityServlet?neID="+obj["neid"]+"&nmUser="+obj["nmUser"];
	loadXMLdoc(url,"POST",false,rightHandleBack,null,"inputdata=" + createRightXML());
}

/**
 *           XML
 * 
 * @param  
 * @return  
 */ 
function createRightXML()
{
	var root = new inputxml("datainterface");// Create the root of a xml file
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel=null;;
	var thirdlevel=null;
	
	secondlevel = new tagElement("row-params"); // bean         
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","querybutton");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",TECMDCODE_PTN_MIRRORMGR_QUERY);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	
	
	secondlevel = new tagElement("row-params"); // bean         
	
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","newbutton");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",TECMDCODE_PTN_MIRRORMGR_CREATE);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	
	secondlevel = new tagElement("row-params"); // bean         
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","deletebutton");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",TECMDCODE_PTN_MIRRORMGR_DELETE);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
	
	secondlevel = new tagElement("row-params"); // bean         
	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name","btnID");
	thirdlevel.setAttribute("value","applybutton");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name","sfid");
	thirdlevel.setAttribute("value",TECMDCODE_PTN_MIRRORMGR_MODIFY);
	secondlevel.appendChild(thirdlevel);
	
	firstlevel.appendChild(secondlevel);
		
	root.getRoot().appendChild(firstlevel);
	
	return root.toString();
}

/**
 *           
 * 
 * @param  
 * @return  
 */ 
function rightHandleBack(doc)
{
	var data = EncapsulateData(doc);
  	hasRight = [];    
	for(var i = 0; i < data.getDataRowLength(); i++)  //        
    {
    	var right = data.getDataRowParam(i,"right");
    	var button = data.getDataRowParam(i,"btnID");
    	
    	if (right == "1")
    	{
    		hasRight[button] = true;
    	}
    	else
    	{
    		hasRight[button] = false;
    	}
    	
    	if(0 == right)
    	{
    		$(data.getDataRowParam(i,"btnID")).disabled = true;
    	} 
    	else
    	{
    		$(data.getDataRowParam(i,"btnID")).disabled = false;
    	}        
    }   
}

/**
 *      
 */
window.onresize=function()
{
	st.setBodyHeight(getTableHeight($("table"),st)+"px");
}

/*
 *       
 */
function getPortName(portId)
{
	var VCTRUNK = 32768; // VCTRUNK    ID
	if (portId < VCTRUNK)
	{
		return "PORT" + portId; //   PORT     
	}
	else
	{
		return "VCTRUNK" + (portId - VCTRUNK); //   VCTRUNK     
	}
}
