function limitVlanInput(obj, minValue, maxValue)
{
    var minvalue = minValue;
    var maxvalue = maxValue;
    
    obj.value = "";
    obj.style.imeMode = "disabled";
    obj.onkeypress = function()
    {
        var evt= EventUtil.getEvent();
        return restrictVlan(obj, evt, minvalue, maxvalue);
    };
    obj.onpaste = function()
    {
        var pasteText = window.clipboardData.getData("Text");
        pasteText = obj.value + pasteText;
        return vlanTextCheck(pasteText, minvalue, maxvalue);
        
    };
}

function restrictVlan(field, event, minvalue, maxvalue)
{
    var key, keychar;
    
    key = ((event.keyCode != 0) ? (event.keyCode) : (event.charCode));
    
    keychar = String.fromCharCode(key);
    
    if (event.ctrlKey) 
    {
        if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
        {
            return true;
        }
    }
    if (event.shiftKey) 
    {
        return false;
    }
    if ((key == 8) || (key == 9)) 
    {
        return true;
    }
    
    if ((keychar == '\'') && (key == 39)) 
    {
        return true;
    }
    if ((keychar == '%') && (key == 37)) 
    {
        return true;
    }
    if ((keychar == '&') && (key == 38)) 
    {
        return true;
    }
    if ((keychar == '(') && (key == 40)) 
    {
        return true;
    }
    
    if (keychar == '.' || keychar == '/' || keychar == ';' || keychar == '\'' ||
    keychar == '[' ||
    keychar == ']' ||
    keychar == '\\' ||
    keychar == '=') 
    {
        return false;
    }
    
    if (key > 36 && key < 41) 
    {
        return true;
    }
    
    if ((field.value.length == 0) && ((keychar == ',') || (keychar == '-'))) 
    {
        return false;
    }
    
    if ((field.value.length == 0) && ((keychar >= '0') && (keychar <= '9'))) 
    {
        var tempvalue = 0;
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            tempvalue = key - 48;
        }
        if (tempvalue > maxvalue || tempvalue < minvalue) 
        {
            alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
            return false;
        }
        else 
        {
            return true;
        }
    }
    
    if ((field.value.length != 0) && ((keychar >= '0') && (keychar <= '9') || (keychar == '-') || (keychar == ','))) 
    {
        var tmp = field.value;
        var txtlist = field.value.split(",");
        
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            var pos = digitalTag_getPos(field);
            if (keychar == '0') 
            {
                var val = tmp.substring(0, pos);
                var vArray = val.split(",");
                var value = vArray[vArray.length - 1].split("-");
                if (parseInt(value[value.length - 1]) == 0) 
                {
                    return false;
                }
            }
            var newVal = tmp.substring(0, pos) + keychar + tmp.substring(pos + selectionLen(field));
            var vArr = newVal.split(",");
            for (var i = 0; i < vArr.length; i++) 
            {
                var va = vArr[i].split("-");
                for (var j = 0; j < va.length; j++) 
                {
                    if (parseInt(va[j]) < minvalue || parseInt(va[j]) > maxvalue) 
                    {
                        alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                        return false;
                    }
                }
            }
        }
        if ((keychar == '-') || (keychar == ',')) 
        {
            var currText = txtlist[txtlist.length - 1];
            if (currText == "") 
            {
                return false;
            }
            if ((String.fromCharCode(currText.charCodeAt(currText.length - 1)) == '-') ||
            (String.fromCharCode(currText.charCodeAt(currText.length - 1)) == ',')) 
            {
                return false;
            }
            else 
            {
                if ((currText.indexOf("-") != -1) && (keychar != ',')) 
                {
                    return false;
                }
                else 
                {
                    return true;
                }
            }
        }
        
    }
    else 
    {
        if (event.ctrlKey) 
        {
            if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
            {
                return true;
            }
        }
        else 
        {
            return false;
        }
    }
}



function vlanTextCheck(inputText, limitLow, limitHigh)
{
    for (var i = 0, isize = inputText.length; i < isize; i++) 
    {
        var ch = inputText.charCodeAt(i);
        if (ch < 48 || ch > 57) 
        {
            if ((String.fromCharCode(ch) == "-" || String.fromCharCode(ch) == ",")) 
            {
                continue;
            }
            else 
            {
                return false;
            }
        }
    }
    
    var str = inputText.split(",");
    if (inputText.length == 0) 
    {
        return true;
    }
    
    for (var i = 0; i < str.length; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);
            
            if ((rangeStart > limitHigh) || (rangeEnd > limitHigh) || (rangeStart < limitLow) || (rangeEnd < limitLow)) 
            {
                alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                inputText.value = 1;
                return false;
            }
        }
        else 
        {
            if (parseInt(str[i]) > limitHigh || parseInt(str[i]) < limitLow) 
            {
                alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                inputText.value = 1;
                return false;
            }
        }
    }
    return true;
}
