/**
 * 
 * "phyport",         0, 
	"vuni",            1, 
	"vnni",            2, 
	"flow",            3
	
	"local",           0
	"remote",          1
    "observe",         2
 */
language = SYSTEMCONF.getLanguage();

document.title = RESOURCE["mirrormgr"];

var win = getParentWindow();

var winurlobj = getNeProperty(win.document);

var obj = getNeProperty(self);

var portList = new Array();
var tmpValue = "";

var ct = null;

function initPage() 
{
	getSupportPort();
	createButton();
	createTable();
}

function getSupportPort() 
{
	var xml = createXML();
	var URL = "../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_PTN_PORTMIRROR_GETPORT + "&nmUser="
			+ winurlobj["nmUser"];
	loadXMLdoc(URL, "POST", false, getPortCallBack, null, "inputdata=" + xml);
}

function createXML() 
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");

	var neid = winurlobj["neid"];
	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);

	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);

	return di.toString();
}

function getPortCallBack(doc) 
{
	var data = EncapsulateData(doc);

	for ( var i = 0, len = data.getDataRowLength(); i < len; i++) 
	{
		var portInfo = new Object;
		portInfo.portName = data.getDataRowParam(i, "port");
		portInfo.slotId = data.getDataRowParam(i, "slotId");
		portInfo.portId = data.getDataRowParam(i, "portId");
		portList[i]=portInfo;
	}
}

function createButton() 
{
	$("submitbtn").value = RESOURCE["okbutton"];
	$("cancel").value = RESOURCE["cancelbutton"];
	$("apply").value = RESOURCE["applybutton"];
}

function createTable() 
{
	ct = new CTable();
	ct.addHead(RESOURCE["attribute"], RESOURCE["value"]);
	
	/**
	 * start:mirror_ID mirroID        checkbox   ID      1~0xFFFFFFFF
	 */
	var atom = new Atom("span");
	ct.addAttrRow("mirrorIndex", RESOURCE["mirrorIndex"], atom);
	
	var elem = document.createElement("input");
    elem.type = "text";
    elem.id = "mirrorIndex";
    checkText(elem, "1", "4294967295");
    elem.style.width = "44%";
    elem.disabled = true;
    elem.value = "-";
    atom.element.parentNode.appendChild(elem);
    
    var elem = document.createElement("input");
    elem.type = "checkbox";
    elem.id = "isAuto";
    elem.style.width = "10%";
    elem.onclick = function()
    {
        if ($("isAuto").checked) 
        {
            $("mirrorIndex").disabled = true;
            $("mirrorIndex").value = "-";
        }
        else 
        {
            $("mirrorIndex").disabled = false;
            $("mirrorIndex").value = "";
        }
    };
    atom.element.parentNode.appendChild(elem);    
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["autoassign"];
    elem.style.width = "45%";
    atom.element.parentNode.appendChild(elem);   
	
    /**
	 * mirrorname:                  64                     
	 */
	var atom = new Atom("text");
	checkTextData(atom.element, 64);
	ct.addAttrRow("mirrorname", RESOURCE["mirrorname"], atom);
	
	var atom = new Atom("select");
	if (winurlobj.neType == 36) //1500  vuni vnni     
	{
		atom.addOption("V-UNI", 1);
		atom.addOption("V-NNI", 2);
	}
	else //5x0  vuni          
	{
	   atom.addOption(RESOURCE["phyport"], 0);
	   atom.addOption("V-UNI", 1);
	}
	atom.element.onchange = changeMirrorType;
	ct.addAttrRow("srcmirrortype", RESOURCE["srcmirrortype"], atom);

	var atom = new Atom("select");
	atom.addOption("INGRESS", 1);
	atom.addOption("EGRESS", 2);
	ct.addAttrRow("srcdirection", RESOURCE["direction"], atom);
	if (winurlobj.neType == 36) //osn1500   engress
	{
		ct.setAttrValue("srcdirection",2);
	}
	else //OSN5x0   ingress
	{
		ct.setAttrValue("srcdirection",1);
	}
	
	atom = new Atom("select");
	atom.id = "mirrorport";
	var portList = getPortList();
	for ( var i = 0, len = portList.length; i < len; i++) {
		atom.addOption(portList[i].portName, JSON.stringify(portList[i]));
	}
	ct.addAttrRow("mirrorport", RESOURCE["mirrorport"], atom);
	
	atom = new Atom("span");
	ct.addAttrRow("srcpointspan", RESOURCE["srcpointspan"], atom);
	
	var elem = document.createElement("input");
    elem.type = "text";
    elem.id = "srcpointshowvar";
    elem.style.width = "58%";
    elem.disabled = true;
    elem.value = "";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("span");
    elem.id = "join";
    elem.innerHTML = "-";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "vlanlist";
    elem.style.width = "30%";
    elem.value = "";
    limitVlanInput(elem, "1", "4094");
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "vid";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "serviceid";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "pwIndex";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.id = "getservicebtn";
    elem.style.width = "10%";
    elem.value = "...";
    elem.onclick = function()
    {
        xshowModalDialog("selectservice.html?srcmirrortype="+ct.getAttrValue("srcmirrortype"),RESOURCE["portmirrormgr"],800,500,"../../../../../images/")
    };
    atom.element.parentNode.appendChild(elem);
    
    ct.getAttrRow("srcpointspan").style.display = "none";

	atom = new Atom("select");
	atom.id = "mirroredport";
	for ( var i = 0, len = portList.length; i < len; i++) {
		atom.addOption(portList[i].portName, JSON.stringify(portList[i]));
	}
	ct.addAttrRow("mirroredport", RESOURCE["mirroredport"], atom);

	document.body.insertBefore(ct.getTable(), document.body.firstChild);
	/**
	 *       
	 */
	$("isAuto").checked = true;
	
	if (ct.getAttrValue("srcmirrortype") == "1") //v-uni    
	{
		ct.getAtom("srcdirection").element.disabled = true;
		ct.getAttrRow("mirrorport").style.display = "none";
		ct.getAttrRow("srcpointspan").style.display = "";
		$("vlanlist").style.display = "";
		$("join").style.display = "";
		$("srcpointshowvar").style.width = "58%";
	}
	else if (ct.getAttrValue("srcmirrortype") == "2") //v-nni    
	{
		ct.getAtom("srcdirection").element.disabled = true;
		ct.getAttrRow("mirrorport").style.display = "none";
		ct.getAttrRow("srcpointspan").style.display = "";
		$("vlanlist").style.display = "none";
		$("join").style.display = "none";
		$("srcpointshowvar").style.width = "89%";
	}
}

function changeMirrorType()
{
	if (this.value == "0") //    
	{
		ct.getAtom("srcdirection").element.disabled = false;
		ct.getAttrRow("mirrorport").style.display = "";
		ct.getAttrRow("srcpointspan").style.display = "none";
	}
	if (this.value == "1") //v-uni    
	{
		ct.getAtom("srcdirection").element.disabled = true;
		ct.getAttrRow("mirrorport").style.display = "none";
		ct.getAttrRow("srcpointspan").style.display = "";
		$("vlanlist").style.display = "";
		$("join").style.display = "";
		$("srcpointshowvar").style.width = "58%";
		$("srcpointshowvar").value ="";
		$("vlanlist").value="";

	}
	else if (this.value == "2") //v-nni    
	{
		ct.getAtom("srcdirection").element.disabled = true;
		ct.getAttrRow("mirrorport").style.display = "none";
		ct.getAttrRow("srcpointspan").style.display = "";
		$("vlanlist").style.display = "none";
		$("join").style.display = "none";
		$("srcpointshowvar").style.width = "89%";
		$("srcpointshowvar").value ="";
		$("vlanlist").value="";
	}
}

function getPortList() 
{
	return portList;
}

function createXMLData() 
{
	var neid = winurlobj["neid"];
	var servicename = ct.getAttrValue("mirrorname");
	var mirrorport = JSON.parse(ct.getAttrValue("mirrorport"));
	var mirroredport = JSON.parse(ct.getAttrValue("mirroredport"));
	var direction = ct.getAttrValue("srcdirection");
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = new tagElement("param");

	param.setAttribute("name", "neid");
	param.setAttribute("value", neid);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "isAuto");

	var autoIndexparam = new tagElement("param");
	autoIndexparam.setAttribute("name", "isAutoIndex");
	
	var indexParam=new tagElement("param");
	indexParam.setAttribute("name", "mirrorServiceIndex");
	if($("isAuto").checked)
	{
		param.setAttribute("value", 1);//     ID   1
		autoIndexparam.setAttribute("value", 2);//          2
		indexParam.setAttribute("value", 1);//     ID index    
	}
	else
	{
		param.setAttribute("value", 0);
		autoIndexparam.setAttribute("value", 0);
		indexParam.setAttribute("value", $("mirrorIndex").value);
	}
	row.appendChild(autoIndexparam);
	row.appendChild(indexParam);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "mirrorName");
	param.setAttribute("value", servicename);
	row.appendChild(param);
	
	/**
	 *       NSCMD_ETHN_ADD_MIRROR local      remote      observe     
	 */
	param = new tagElement("param");
	param.setAttribute("name", "mirrorType");
	param.setAttribute("value", obj.mirrortype);
	row.appendChild(param);
	
	var srcpointtype = ct.getAttrValue("srcmirrortype");
	param = new tagElement("param");
	param.setAttribute("name", "srcPointType");
	param.setAttribute("value", srcpointtype);
	row.appendChild(param);
	
	param = new tagElement("param");
	param.setAttribute("name", "srcPointDirection");
	param.setAttribute("value", direction);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "slotID");
	param.setAttribute("value", mirrorport.slotId);
	row.appendChild(param);
	
	var srcparam1var;
	var srcparam2var;
	var srcparam3var;
	if (srcpointtype == "1") //V-UNI
	{
		srcparam1var = $("serviceid").value;
		srcparam2var = $("vid").value;
		srcparam3var = "65535";
	}
	else if (srcpointtype == "2") //V-NNI
	{
		srcparam1var = $("serviceid").value;
		srcparam2var = $("vid").value;
		srcparam3var = $("pwIndex").value;
	}
	else //    
	{
		srcparam1var = mirrorport.slotId;
		srcparam2var = "255";
		srcparam3var = mirrorport.portId;
	}
	param = new tagElement("param");
	param.setAttribute("name", "srcparam1");
	param.setAttribute("value", srcparam1var);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "srcparam2");
	param.setAttribute("value", srcparam2var);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "srcparam3");
	param.setAttribute("value", srcparam3var);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "obsPointSlotID");
	param.setAttribute("value", mirroredport.slotId);
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "obsPointSubSlotID");
	param.setAttribute("value", "255");
	row.appendChild(param);

	param = new tagElement("param");
	param.setAttribute("name", "obsPointPortID");
	param.setAttribute("value", mirroredport.portId);
	row.appendChild(param);
	
	if (srcpointtype == "1")//P+V  
	{
		param = new tagElement("param");
		param.setAttribute("name", "taglist");
		param.setAttribute("value",$("vlanlist").value);
		row.appendChild(param);
	}
	bussiness.appendChild(row);
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

function sendCreateInfo(flag) 
{   
	if (!$("isAuto").checked) 
    {
	  if ($("mirrorIndex").value =="")
	  {
		  alert(RESOURCE["alertmirrorID"]);
		  return;
	  }
    }
	
	var srcpointtype = ct.getAttrValue("srcmirrortype");
	if (srcpointtype == "0")
	{
		var mirrorport = JSON.parse(ct.getAttrValue("mirrorport"));
		var mirroredport = JSON.parse(ct.getAttrValue("mirroredport"));
		if (mirrorport.portName == mirroredport.portName) 
		{
			alert(RESOURCE["cantEqual"]);
			return;
		}
	}
	else if (srcpointtype == "1" || srcpointtype == "2")
	{
		if ($("srcpointshowvar").value == "")
		{
			alert(RESOURCE["srcpointalert"]);
			return;
		}
	}
	if (winurlobj.neType == 36)
	{
		if (srcpointtype == "1" && ($("vlanlist").value.indexOf(",")>0 ||  $("vlanlist").value.indexOf("-")>0))
		{
			alert(RESOURCE["vlanalert"]);
			return;
		}
	}
	$("submitbtn").disabled = true;
	$("cancel").disabled = true;
	$("apply").disabled = true;

	var xml = createXMLData();

	var URL = "../../../../../neExlorerServlet?sfid="
			+ TECMDCODE_PTN_MIRRORMGR_CREATE + "&nmUser="
			+ winurlobj["nmUser"];
	loadXMLdoc(URL, "POST", true, PostCallBackHandler, flag, "inputdata=" + xml);
}

function PostCallBackHandler(doc, flag) 
{
	$("submitbtn").disabled = false;
	$("cancel").disabled = false;
	$("apply").disabled = false;

	var data = EncapsulateData(doc);

	if (data.getSErrorCode() !=0) 
	{
		showErrorDialog(data);
		if (data.getSErrorCode() == OPERATION_PART_SUCCESS)
		{
			win.sendQueryInfo();
		}
		return;
	}
	
	win.sendQueryInfo();

	if (flag) 
	{
		xcloseDialog();
	}
}

function showErrorDialog(data) 
{
	var errArr = [];
	errArr[0] = "nename";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	openErrPage("../../../../../page/", data.getError(), errArr);
}
