var lldpst = null;   //lldp      
var portst = null;   //lldp      
var neighborst = null;   //lldp      

var winobj = getNeProperty(self);  //      
var neid = winobj["neid"];
var btnRightArr = new Object();    //btn  

var workmodeArr = new Object();    //LLDP        
workmodeArr[0] = RESOURCE["disable"];   //lldpmanagement_.xml
workmodeArr[1] = RESOURCE["transmode"];  
workmodeArr[2] = RESOURCE["recvmode"];  
workmodeArr[3] = RESOURCE["recvtransmode"];  

var groupmodeArr = new Object();   //LLDP        
groupmodeArr[1] = RESOURCE["NB"];
groupmodeArr[2] = RESOURCE["NNTB"];
groupmodeArr[3] = RESOURCE["NCB"];

var groupmodeValue = new Object();   //LLDP        
groupmodeValue["Nearest Bridge"] = "1";
groupmodeValue["Nearest Non-TPMR Bridge"] = "2";
groupmodeValue["Nearest Customer Bridge"] = "3";


var UNSURPPORT1 = "-1";
var UNSURPPORT2 = "";
var invalid_char = "-";
var DISABLE = "0";
var NOLOGFLAG = "0";
var SUBSLOTID = "255";
var editableValue = new Array();
editableValue["vlanid"] = "1";
editableValue["vlanpri"] = "0";
editableValue["destaddrgroup"] = groupmodeArr[1];

var Link_ErrorList = [];
var modifyPortflag = false;

var isSupportTTL = SpecialAttrMgr.isNESupport(neid, "TE_FUNC_CFG_LLDP", "PTN_ATTR_SUPPORT_LLDPTTLMULT");

function init()
{
	initButton();
	initTable();
	
	if(btnRightArr.queryBtn.right)
	{
		sendQueryInfo();
	}
}

function initButton()
{
	$("timeTableTitle").appendChild(document.createTextNode(RESOURCE["timeTableTitle"]));
	$("portTableTitle").appendChild(document.createTextNode(RESOURCE["portTableTitle"]));
	$("neighborInfoTitle").appendChild(document.createTextNode(RESOURCE["neighborInfoTitle"]));
	$("queryBtn").value = RESOURCE["querybutton"];
	$("applyBtn").value = RESOURCE["applybutton"];
	$("applyBtn").disabled = true;

	btnRightArr.queryBtn = new BtnRightObj("queryBtn",TECMDCODE_RTN_QUERY_LLDP_NEIGHBORINFO);
    btnRightArr.applyBtn = new BtnRightObj("applyBtn",TECMDCODE_RTN_SET_LLDP_PORTINFO);
    getRightInfo(winobj, btnRightArr);       
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
}

function initTable()
{
	lldpst = new SortTable();
	lldpst.setImage("../../../../../images/"); 
	createTableHead(lldpst, window.tableconf[0]);
	var totalHeight = getComponetHeight($("tableContainer"), 200);

	lldpst.setBodyHeight(totalHeight * 0.2 + "px");
	
	lldpst.setOnCellEditHandler(stCellEditHandler);
	
	$("timeTable").oncontextmenu = popupMenuHandler;	
	$("timeTable").appendChild(lldpst.getTable());     
	
	portst = new SortTable();
	portst.setImage("../../../../../images/");
	createTableHead(portst, window.tableconf[1]);
	portst.setBodyHeight(totalHeight * 0.6 + "px");

	portst.setOnRowSelectHandler(rowSelected);
	portst.setOnCellEditHandler(stCellEditHandler);
	
	$("portTable").oncontextmenu = popupMenuHandler;	
	$("portTable").appendChild(portst.getTable());  
	
	neighborst = new SortTable();
	neighborst.setImage("../../../../../images/");
	createTableHead(neighborst, window.tableconf[2]);
	neighborst.setBodyHeight(totalHeight * 0.2 + "px");
	
	$("neighborTable").oncontextmenu = popupMenuHandler;	
	$("neighborTable").appendChild(neighborst.getTable());   
	
	EventUtil.addEventHandler(window, "resize", adjustTableHeight);
}

/**
 *          
 * @param param
 */
function stCellEditHandler(param)
{
	if(btnRightArr.applyBtn.right)
	{
		$("applyBtn").disabled = false;
	}
}

var selectedRowid = -1;

function rowSelected()
{
    var selectedRows = portst.getSelectedRows();
 	
    if (0 == selectedRows.length)
    {
        return;
    }
    if (selectedRowid == selectedRows[0])
    {
        return;
    }
    neighborst.clearTableData();
    selectedRowid = selectedRows[0];
    var neighborid = portst.getCellShow(selectedRowid,"neighborid").getValue();
    if(neighborid == invalid_char || neighborid == UNSURPPORT2)
    {
    	return;
    }
    
    var slotid = portst.getCellStoreValue(selectedRowid, "port", "slotid");
    var portid = portst.getCellShow(selectedRowid,"portid").getValue();
    senQueryNeigthborInfo(slotid, portid);
}

/**
 *       
 */
function sendQueryInfo()
{
	sendQueryTimeInfo();
	sendQueryPortParaInfo();
}

/**
 *       
 * @return
 */
function sendQueryTimeInfo()
{
	var xml = createQueryTimeXML();
	if(xml == null)
	{
		return;
	}
	
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_QUERY_LLDP_TIMEINFO + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", false, queryTimeInfoCallback, null, "inputdata=" + xml);
}

/**
 *         
 * @return
 */
function sendQueryPortParaInfo()
{
	var xml = createQueryPortParaInfoXML();
	if(xml == null)
	{
		return;
	}
	LoadingProcess.showWaitStatus("../../../../../images");
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_QUERY_LLDP_PORTINFO + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, queryPortParaInfoCallback, null, "inputdata=" + xml);
}

/**
 *       
 * @return
 */
function senQueryNeigthborInfo(slotid, portid)
{
	var xml = createQueryNeigthborInfoXML(slotid, portid);
	if(xml == null)
	{
		return;
	}

	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_QUERY_LLDP_NEIGHBORINFO + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", false, queryNeigthborInfoCallback, null, "inputdata=" + xml);
}

/**
 *       LLDP     XML  
 * @param  
 * @return  
 */
function createQueryTimeXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	
	param = new tagElement("param", "neid", neid);
	row.appendChild(param);
	param = new tagElement("param", "isLogFlag", NOLOGFLAG);
	row.appendChild(param);
	
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *       LLDP       XML  
 * @param  
 * @return  
 */
function createQueryPortParaInfoXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param", "neid", neid);
	row.appendChild(param);
	param = new tagElement("param", "isLogFlag", NOLOGFLAG);
	row.appendChild(param);

    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *       LLDP     XML  
 * @param  
 * @return  
 */
function createQueryNeigthborInfoXML(slotid, portid)
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param", "neid", neid);
	row.appendChild(param);
	
	param = new tagElement("param", "slotid", slotid);
	row.appendChild(param);
	
	param = new tagElement("param", "subslotid", SUBSLOTID);
	row.appendChild(param);
	
	param = new tagElement("param", "portid", portid);
	row.appendChild(param);
	
	param = new tagElement("param", "isLogFlag", NOLOGFLAG);
	row.appendChild(param);

    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *              
 * 
 * @param doc:          
 * @return  
 */
function queryTimeInfoCallback(doc)
{
	var data = EncapsulateData(doc);
	var smallErrorCode = data.getSErrorCode();
    if(null != smallErrorCode && 0 != smallErrorCode)
    {    	
    	Link_ErrorList[Link_ErrorList.length] = data;
    }
    
    lldpst.clearTableData();    
	createTableBody(lldpst, window.tableconf[0], data, RESOURCE);
	
	var min_ttl = 1;
	var max_ttl = 100;
	if (isSupportTTL)
	{
		min_ttl = 4;
	}
	for (var i = 0, len = lldpst.getDataRowLength(); i < len; i++)
	{
		textCheck(lldpst.getCellEdit(i, "ttlmult").element, min_ttl, max_ttl);
	}
}

/**
 *              
 * 
 * @param doc:          
 * @return  
 */
function queryNeigthborInfoCallback(doc)
{	
	var data = EncapsulateData(doc);
	var smallErrorCode = data.getSErrorCode();
    if(null != smallErrorCode && 0 != smallErrorCode)
    {
    	
		showErrorDialog(data);
    }

    neighborst.clearTableData();    
	createTableBody(neighborst, window.tableconf[2], data, RESOURCE);
}

/**
 *              
 * 
 * @param doc:          
 * @return  
 */
function queryPortParaInfoCallback(doc)
{
	LoadingProcess.removeWaitStatus();
	var data = EncapsulateData(doc);
	
	if (0 == data.getError().getGlobleECode()
			|| 1 == data.getError().getGlobleECode()) 
	{
	    portst.clearTableData();
		createTableBody(portst, window.tableconf[1], data, RESOURCE);

		var legth = portst.getDataRowLength();
		if(legth > 0)
		{
			portst.getCellEdit(0, "workmode").element.onchange = handleModeChange;
			portst.setRowSelect(0);//       
			rowSelected();
		}
		
		var modeValue;
		var colary;
		var neigthborValue;

		 for ( var i = 0, len = portst.getDataRowLength(); i < len; i++)
		 {
			 modeValue = portst.getCellStoreValue(i, "workmode", "workmode");
	
			 if(modeValue == DISABLE)
			 {
				 colary = new Array("vlanid", "vlanpri", "destaddrgroup");
				 setCellStatus(i, colary, 0, null);
				 setCellDefault(i, colary, invalid_char);
			 }
			 
			 neigthborValue = portst.getCellShow(i,"neighborid").getValue();
			 if((neigthborValue == UNSURPPORT1) || (neigthborValue == UNSURPPORT2))
			 {
				 colary = new Array("neighborid", "lasttime", "remaintime");
				 setCellStatus(i, colary, 0, null);
				 setCellDefault(i, colary, invalid_char);
			 }			
		}		
	}

	if(Link_ErrorList.length > 0)
	{
		var datatemp = null;
		for(var i = 0,len = Link_ErrorList.length;i < len;i++)
		{
			datatemp = Link_ErrorList[i];
			if(data.getSErrorCode() < datatemp.getSErrorCode())
			{
				data.setSErrorCode(datatemp.getSErrorCode());
				data.setSErrorInfo(datatemp.getSErrorInfo());
			}
			data.getError().rowErrors = data.getError().rowErrors.concat(datatemp.getError().rowErrors);
		}    			    	
    }
	showErrorDialog(data);
    Link_ErrorList = [];
}

/**
 *             
 * @return
 */
function handleModeChange()
{
    var rowindex = this.parentNode.parentNode.rowIndex;
    var colary = new Array("vlanid", "vlanpri", "destaddrgroup", "neighborid", "lasttime", "remaintime");
    
    if (this.value == DISABLE) 
    {
        setCellStatus(rowindex, colary, 0, null);
        setCellDefault(rowindex, colary, invalid_char);
    }
    else 
    {
    	colary = new Array("vlanid", "vlanpri", "destaddrgroup");
        setCellStatus(rowindex, colary, 1, cellondbclick);
        setCellEditableValue(rowindex, colary, invalid_char, editableValue);               
    }
}

/**
 *          
 * @return
 */
function setCellDefault(row, colary, defval)
{
    var cell;
    for (var i = 0, length = colary.length; i < length; i++) 
    {
        cell = portst.getCell(row, colary[i]);
        cell.element.showElement.setValue(defval);        
        portst.setCellValue(cell, colary[i], defval);
    }
}

/**
 *               TX,RX  TXRX  VLAN ID VLAN                                      
 * @return
 */
function setCellEditableValue(row, colary, defval, cosDefault)
{
    var cell;
    var setValue;
    for (var i = 0, length = colary.length; i < length; i++) 
    {
        cell = portst.getCell(row, colary[i]);
        
        if (cosDefault[colary[i]] != null) 
        {
            setValue = cosDefault[colary[i]];
        }
        else 
        {
            setValue = defval;
        }

        portst.setCellModify(row,colary[i],true);
        portst.getCellShow(row,colary[i]).setValue(setValue);
        portst.getCellEdit(row,colary[i]).setValue(setValue);
        portst.setCellValue(cell, colary[i], setValue);
    }
}

/**
 *          1     0     
 * @return
 */
function setCellStatus(row, colAry, isEdit, dbclickFunc)
{
    for (var i = 0, length = colAry.length; i < length; i++) 
    {
    	portst.setCellIsEdit(portst.getCell(row, colAry[i]), isEdit);
    	portst.getCellElement(row, colAry[i]).ondblclick = dbclickFunc;
    }
}
/**
 *       
 */
function sendApplyInfo()
{
	$("queryBtn").disabled = true;
	$("applyBtn").disabled = true;
	
	
	for(var rowindex = 0,rowlen = portst.getDataRowLength();rowindex<rowlen;rowindex++)
	{
    	if(portst.getModify(rowindex))
    	{
    		modifyPortflag = true
    		break;
    	}
	}
	
	sendTimeApplyInfo();
	sendPortApplyInfo();
}

function sendTimeApplyInfo()
{
	var xml = createTimeApplyXML();
	if(xml == null)
	{
		return;
	}

	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_SET_LLDP_TIMEINFO + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", false, applyTimeInfoCallback,null, "inputdata=" + xml);
}

function sendPortApplyInfo()
{
	var xml = createPortInfoApplyXML();
	if(xml == null)
	{
		return;
	}
	LoadingProcess.showWaitStatus("../../../../../images");
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_RTN_SET_LLDP_PORTINFO + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, applyPortCallback,null, "inputdata=" + xml);
}
/**
 *   LLDP       xml,        
 */
function createTimeApplyXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;

	for(var rowindex = 0,rowlen = lldpst.getDataRowLength();rowindex<rowlen;rowindex++)
	{
    	if(!lldpst.getModify(rowindex))
    	{
    		continue;
    	}
    	
		row = new tagElement("row-params");
    	param = new tagElement("param","neid",neid);
    	row.appendChild(param);

		param = new tagElement("param","interval",lldpst.getCellStoreValue(rowindex, "interval", "interval"));
		row.appendChild(param);
		
		param = new tagElement("param","ttlmult",lldpst.getCellStoreValue(rowindex, "ttlmult", "ttlmult"));
		row.appendChild(param);
		
		param = new tagElement("param","resetdelay",lldpst.getCellStoreValue(rowindex, "resetdelay", "resetdelay"));
		row.appendChild(param);
		
		param = new tagElement("param","fastpdunum",lldpst.getCellStoreValue(rowindex, "fastpdunum", "fastpdunum"));
		row.appendChild(param);
		
		bussiness.appendChild(row);
	}
	
	if(0 == bussiness.childNodes.length)
	{
		return null;
	}
	
    root.getRoot().appendChild(bussiness);
	return root.toString();
}
/**
 *          xml      VLAN                     
 */
function createPortInfoApplyXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	var isModifyFlag = false;

	for(var rowindex = 0,rowlen = portst.getDataRowLength();rowindex<rowlen;rowindex++)
	{
    	if(!portst.getModify(rowindex))
    	{
    		continue;
    	}

		row = new tagElement("row-params");
		param = new tagElement("param","neid",neid);
    	row.appendChild(param);
		
		param = new tagElement("param","slotid",portst.getCellStoreValue(rowindex, "port", "slotid"));
		row.appendChild(param);

		param = new tagElement("param","subslotid",SUBSLOTID);
		row.appendChild(param);
		
		param = new tagElement("param","portid",portst.getCellShow(rowindex,"portid").getValue());
		row.appendChild(param);
		
		isbwModifyFlag = portst.getCellModify(rowindex,"workmode");		
		if(isbwModifyFlag)
		{
			param = new tagElement("param","workmode",portst.getCellStoreValue(rowindex, "workmode", "workmode"));
			row.appendChild(param);
		}

		if(portst.getCellModify(rowindex,"vlanid") || portst.getCellModify(rowindex,"vlanpri"))
		{
			param = new tagElement("param","vlanid",portst.getCellStoreValue(rowindex, "vlanid", "vlanid"));
			row.appendChild(param);
			
			param = new tagElement("param","vlanpri",portst.getCellStoreValue(rowindex, "vlanpri", "vlanpri"));
			row.appendChild(param);
		}
		
		isbwModifyFlag = portst.getCellModify(rowindex,"destaddrgroup");
		if(isbwModifyFlag)
		{
			param = new tagElement("param","destaddrgroup",groupmodeValue[portst.getCellShow(rowindex,"destaddrgroup").getValue()]);
			row.appendChild(param);
		}
		bussiness.appendChild(row);
	}
	
	if(0 == bussiness.childNodes.length)
	{
		return null;
	}
	
    root.getRoot().appendChild(bussiness);
	return root.toString();
}
/**
 *   LLDP          
 */
function applyTimeInfoCallback(doc)
{
	var data = EncapsulateData(doc);
	var smallErrorCode = data.getSErrorCode();
	if(modifyPortflag)
	{
		if(null != smallErrorCode && 0 != smallErrorCode)
	    {
	    	Link_ErrorList[Link_ErrorList.length] = data;
	    }
	}else{
		Link_ErrorList = [];
		showErrorDialog(data);
	}
    

    refreshTableState(lldpst,window.tableconf[0],data);
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
    $("applyBtn").disabled = true;
}
/**
 *           
 */
function applyPortCallback(doc)
{
	LoadingProcess.removeWaitStatus();
	var data = EncapsulateData(doc);
	if(Link_ErrorList.length > 0)
	{
		var datatemp = null;
		for(var i = 0,len = Link_ErrorList.length;i < len;i++)
		{
			datatemp = Link_ErrorList[i];
			if(data.getSErrorCode() < datatemp.getSErrorCode())
			{
				data.setSErrorCode(datatemp.getSErrorCode());
				data.setSErrorInfo(datatemp.getSErrorInfo());
			}
			data.getError().rowErrors = data.getError().rowErrors.concat(datatemp.getError().rowErrors);
		}
	}
	
	showErrorDialog(data);
    Link_ErrorList = [];
    refreshTableState(portst,window.tableconf[1],data);
    if(0 == data.getSErrorCode())
    {
        sendQueryInfo();
    }
    modifyPortflag = false;
    $("queryBtn").disabled = !btnRightArr.queryBtn.right;
	$("applyBtn").disabled = true;
}

/**
 *       
 */
function showErrorDialog(/*Object*/data)
{
	var errArr = [];
	errArr[0] = "slotid";
	errArr[1] = "boardname";
	errArr[2] = "portname";
	openErrPage("../../../../../page/", data.getError(), errArr); 
}

function adjustTableHeight()
{
	var totalHeight = getComponetHeight($("tableContainer"), 200);
	lldpst.setBodyHeight(totalHeight * 0.2 + "px");
	portst.setBodyHeight(totalHeight * 0.6 + "px");
	neighborst.setBodyHeight(totalHeight * 0.2 + "px");
}
