var ippingst;
var arpipst;
var arptablest;

var tab;
var winobj = getNeProperty(self);
var neid = winobj["neid"];
var btnRightArr = new Object();

var STATUS_DISABLED = "0";
var enableFlag = [];
enableFlag["0"] = RESOURCE["disabled"];
enableFlag["1"] = RESOURCE["enabled"];

var encapType = [];
encapType[0] =	"Null";
encapType[1] =	"802.1Q";
encapType[2] =	"QinQ";

var IPPING_TEST_MAX_NUM = 16

var SelectedIPPingRowIndex = -1;

var INVALID_IP = "255.255.255.255";
var INVALID_IP_ZERO = "0.0.0.0";

var INVALID_VLANID = "65535";

var tableConfArpIp = null;
var tableConfArpTable = null;

var isSupportCevlan = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_IPPING","TE_ATTR_IPPING_SUPPORT_CEVLAN");
var isSuppArpTbl = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_IPPING","TE_ATTR_IPPING_SUPPORT_ARPTABLE");
var isSuppIpPingTest = SpecialAttrMgr.isNESupport(neid, "TE_FUNC_IPPING", "TE_ATTR_IPPING_SUPPORT_IPPINGTEST");

/**
 *      
 * 
 * @param  
 * @return  
 */
function init()
{
	initTable();
	initButton();
	initTabs();
	
	if(btnRightArr.queryIpBtn.right)
	{
		queryIPPing();
	}
}

function initTabs()
{
	
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["arpiptitle"], $("tab1div"));
    if(isSuppArpTbl)
	{
		tab.addEmbedTab("tab2div", RESOURCE["arpTableTitle"], $("tab2div"));
	}
    
    setSelectedEmbedTab("tab1div");
    $("embedTab").appendChild(tab.getEmbedTabs());
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initButton()
{
	$("queryIpBtn").value = RESOURCE["querybutton"];
	$("applyIpBtn").value = RESOURCE["applybutton"];
	$("addArpBtn").value = RESOURCE["add"];
	$("delArpBtn").value = RESOURCE["deletebutton"];
	$("applyArpBtn").value = RESOURCE["applybutton"];
	
	$("applyIpBtn").disabled = true;
	$("addArpBtn").disabled = true;
	$("delArpBtn").disabled = true;
	$("applyArpBtn").disabled = true;
	
  btnRightArr.queryIpBtn = new BtnRightObj("queryIpBtn",TECMDCODE_QUERY_PTN_IPPING_PARAMS);
  btnRightArr.applyIpBtn = new BtnRightObj("applyIpBtn",TECMDCODE_SET_PTN_IPPING_PARAMS);
  btnRightArr.queryArpBtn = new BtnRightObj("queryArpBtn",TECMDCODE_QUERY_PTN_ARP_IP_ADDRESS);
  btnRightArr.addArpBtn = new BtnRightObj("addArpBtn",TECMDCODE_SET_PTN_ARP_IP_ADDRESS);
  btnRightArr.delArpBtn = new BtnRightObj("delArpBtn",TECMDCODE_SET_PTN_ARP_IP_ADDRESS);
  btnRightArr.applyArpBtn = new BtnRightObj("applyArpBtn",TECMDCODE_SET_PTN_ARP_IP_ADDRESS);
  
  
  if(isSuppIpPingTest)
	{
	  $("startIpPingBtn").value = RESOURCE["startIpPingTest"];
	  $("startIpPingBtn").disabled = false;
	  btnRightArr.startIpPingBtn = new BtnRightObj("startIpPingBtn",TECMDCODE_PTN_GET_ARPTABLE_BYPORT);//todo
	}
  else
  {
	  $("startIpPingBtn").style.display = "none";
  }
  
  if(isSuppArpTbl)
	{
	  $("queryArpTblBtn").value = RESOURCE["querybutton"];
	  $("queryArpTblBtn").disabled = true;
	  btnRightArr.queryArpTblBtn = new BtnRightObj("queryArpTblBtn",TECMDCODE_PTN_GET_ARPTABLE_BYPORT);
	}
  else
    {
	  $("queryArpTblBtn").style.display = "none";
    }
  
  getRightInfo(winobj, btnRightArr);
  $("queryIpBtn").disabled = !btnRightArr.queryIpBtn.right;
}

/**
 *          
 * 
 * @param  
 * @return  
 */
function initTable()
{
	ippingst = new SortTable();
	ippingst.setImage("../../../../../images/");
	createTableHead(ippingst, window.tableconf[0]);
	ippingst.setOnCellEditHandler(ippingCellEditHandler);
	ippingst.setOnRowSelectHandler(ippingRowSelectHandler);
	$("ippingcontainer").appendChild(ippingst.getTable());
	$("ippingcontainer").oncontextmenu=popupMenuHandler;	  

	arpipst = new SortTable();
	arpipst.setImage("../../../../../images/");
	arpipst.setOnCellEditHandler(arpipCellEditHandler);
	arpipst.setOnRowSelectHandler(arpipRowSelectHandler);
	tableConfArpIp = window.tableconf[1];
	createTableHead(arpipst, tableConfArpIp);
	$("arpipcontainer").appendChild(arpipst.getTable());
	$("arpipcontainer").oncontextmenu=popupMenuHandler;	 
	
	var totalHeight = getComponetHeight($("tablecomponent"), 150);

	ippingst.setBodyHeight(200 + "px");
	arpipst.setBodyHeight(totalHeight * 0.6 + "px");
	
	if(isSuppArpTbl)
	{
		arptablest = new SortTable();
		arptablest.setImage("../../../../../images/");

		tableConfArpTable = window.tableconf[2];
		createTableHead(arptablest, tableConfArpTable);
		$("arpTablecontainer").appendChild(arptablest.getTable());
		$("arpTablecontainer").oncontextmenu=popupMenuHandler;
		arptablest.setBodyHeight(totalHeight * 0.6 + "px");
	}
}

/**
 * IPPing         
 * @param param
 */
function ippingCellEditHandler(/*Object*/param)
{
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applyIpBtn").disabled = !btnRightArr.applyIpBtn.right;
	}
}
/**
 * IPPing         ,       
 * @param param
 */
function ippingRowSelectHandler(/*Array*/param)
{
	if(param.length > 0)
	{
		/*
		if (isSuppIpPingTest)
		{
			$("startIpPingBtn").disabled = !btnRightArr.queryIpBtn.right;//todo
		}
		*/
		queryArpIP(param[0]);
		if(isSuppArpTbl)
		{
			queryArpTable();
		}
	}
}
/**
 * ARPIP         
 * @param param
 */
function arpipCellEditHandler(/*Object*/param)
{
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applyArpBtn").disabled = !btnRightArr.applyArpBtn.right;
	}
}
/**
 * ARPIP         ,    
 * @param param
 */
function arpipRowSelectHandler(/*Array*/param)
{
	if(param.length == 0)
	{
		$("delArpBtn").disabled = true;
	}
	else
	{
		$("delArpBtn").disabled = !btnRightArr.delArpBtn.right;
	}
}

/**
 *   IP PING
 * 
 * @param  
 * @return  
 */
function queryIPPing()
{
	$("queryIpBtn").disabled = true;
	$("applyIpBtn").disabled = true;
	$("addArpBtn").disabled = true;
	$("delArpBtn").disabled = true;
	$("applyArpBtn").disabled = true;
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_PTN_IPPING_PARAMS + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, queryIPPingcallback,null, "inputdata="
			+ createQueryIPPingXML());
}

/**
 *       IPPigg XML  
 * 
 * @param  
 * @return  
 */
function createQueryIPPingXML()
{
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;

	param = new tagElement("param");
	param.setAttribute("name", "neid");
	param.setAttribute("value", winobj["neid"]);
	row.appendChild(param);

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *             
 * 
 * @param doc:          
 * @return  
 */
function queryIPPingcallback(doc)
{
	var data = EncapsulateData(doc);
	var lastSelected = [];
	for(var i = 0,len = ippingst.getDataRowLength();i < len;i++)
	{
		if (ippingst.getRowSelFlag(i))
		{
			lastSelected[lastSelected.length] = ippingst.getCellStoreValue(i, "port","slotid") + "-" + ippingst.getCellStoreValue(i, "port","port");
		}
	}
	ippingst.clearTableData();
	createTableBody(ippingst, window.tableconf[0], data, RESOURCE);
	for(var i = 0; i < ippingst.getDataRowLength(); i++)
	{
	  	var storevalue = ippingst.getCellStoreValue(i, "port","slotid") + "-" + ippingst.getCellStoreValue(i, "port","port");
	  	if(isSupportCevlan)
	  	{
	  		refreshVlanByStatus(i);
	  	}
	  	else
	  	{
	  		var status = ippingst.getCellStoreValue(i, "status","status");
		  	if(status == STATUS_DISABLED)
		  	{
		  		refreshStatusDisabled(i);
		  	}
		  	else
		  	{
		  		var vlanid = ippingst.getCellStoreValue(i,"vlanid","vlanid");
		  		if(vlanid == INVALID_VLANID)
		  		{
		  			ippingst.getCellShow(i,"vlanid").setValue("/");
		  		}
				ippingst.setCellIsEdit(ippingst.getCell(i,"ip"),0);
				ippingst.setCellIsEdit(ippingst.getCell(i,"mask"),0);
				ippingst.setCellIsEdit(ippingst.getCell(i,"nextip"),0);
				ippingst.setCellIsEdit(ippingst.getCell(i,"nextmask"),0);
		  	}
	  	}
	  	
	  	if(lastSelected.contains(storevalue))
	  	{
	  		singleClick(ippingst.getRow(i).element, true);
	  	}
	}
	ippingst.getCellEdit(0,"status").element.onchange = statusOnchange;
	validateIpForU2000Style(ippingst.getCellEdit(0,"ip").element,ippingst);
	validateIpForU2000Style(ippingst.getCellEdit(0,"mask").element,ippingst);
	validateIpForU2000Style(ippingst.getCellEdit(0,"nextip").element,ippingst);
	validateIpForU2000Style(ippingst.getCellEdit(0,"nextmask").element,ippingst);
	$("queryIpBtn").disabled = !btnRightArr.queryIpBtn.right;
	
	var selRows = ippingst.getSelectedRows();
	
	if(selRows.length > 0)
	{ 
		SelectedIPPingRowIndex = -1;
		queryArpIP(selRows[0]);
		$("addArpBtn").disabled = !btnRightArr.addArpBtn.right;
		if(isSuppArpTbl)
		{
			queryArpTable();
			$("queryArpTblBtn").disabled = !btnRightArr.queryArpTblBtn.right;
		}
		
		if(isSuppIpPingTest)
		{
			$("startIpPingBtn").disabled = !btnRightArr.queryIpBtn.right;//todo
		}
	}
	else
	{
		var data = new DataInterface();
		arpipst.clearTableData();
		createTableBody(arpipst, window.tableconf[1], data, RESOURCE);
	}
	showErrorDialog(data);
}

/**
 *     VLAN   (u2kv2r1c00    )                
 */
function refreshVlanByStatus(rowIndex)
{
  	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"encapType"),0);
  	var status = ippingst.getCellStoreValue(rowIndex, "status","status");
  	if(status == STATUS_DISABLED || status == undefined)
  	{
  		if(status == undefined)
  		{
  			ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"status"),0);
  			ippingst.getCellShow(rowIndex,"status").setValue("-");
  		}
  		refreshStatusDisabled(rowIndex);
  	}
  	else
  	{
  		var pevlanid = ippingst.getCellStoreValue(rowIndex,"vlanid","vlanid");
  		if(pevlanid == INVALID_VLANID)
  		{
  			ippingst.getCellShow(rowIndex,"vlanid").setValue("/");
  		}
  		var encapType = ippingst.getCellStoreValue(rowIndex,"encapType","encapType");
		var encapTypeEditable = (encapType == "1");
  		ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"cevlanid"),encapTypeEditable?0:1);
  		ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"cevlanpri"),encapTypeEditable?0:1);
  		
  		var cevlanid = ippingst.getCellStoreValue(rowIndex,"cevlanid","cevlanid");
  		if(cevlanid == INVALID_VLANID)
  		{
  			ippingst.getCellShow(rowIndex,"cevlanid").setValue("/");
  		}
		ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"ip"),0);
		ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"mask"),0);
		ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"nextip"),0);
		ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"nextmask"),0);
  	}

}

/**
 *   IPPing        
 * @param rowIndex
 */
function refreshStatusDisabled(/*string*/rowIndex)
{
	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"vlanid"),0);
	ippingst.getCellShow(rowIndex,"vlanid").setValue("-");
	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"vlanpri"),0);
	ippingst.getCellShow(rowIndex,"vlanpri").setValue("-");
	if(isSupportCevlan)
	{
		ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"cevlanid"),0);
		ippingst.getCellShow(rowIndex,"cevlanid").setValue("-");
		ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"cevlanpri"),0);
		ippingst.getCellShow(rowIndex,"cevlanpri").setValue("-");
	}

	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"ip"),0);
	ippingst.getCellShow(rowIndex,"ip").setValue("-");
	ippingst.setCellValue(ippingst.getCell(rowIndex,"ip"),"ip",INVALID_IP);
	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"mask"),0);
	ippingst.getCellShow(rowIndex,"mask").setValue("-");
	ippingst.setCellValue(ippingst.getCell(rowIndex,"mask"),"mask",INVALID_IP);
	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"nextip"),0);
	ippingst.getCellShow(rowIndex,"nextip").setValue("-");
	ippingst.setCellValue(ippingst.getCell(rowIndex,"nextip"),"nextip",INVALID_IP);
	ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"nextmask"),0);
	ippingst.getCellShow(rowIndex,"nextmask").setValue("-");
	ippingst.setCellValue(ippingst.getCell(rowIndex,"nextmask"),"nextmask",INVALID_IP);
}

/**
 *   IPPing       
 * @param rowIndex
 */
function refreshStatusEnabled(/*String*/rowIndex)
{
	if(ippingst.getCellIsEdit(ippingst.getCell(rowIndex,"vlanid")) == "1")
	{
		return;
	}
	else
	{
		ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"vlanid"),1);
		var vlanid = ippingst.getCellStoreValue(rowIndex,"vlanid","vlanid");
		if(vlanid == INVALID_VLANID)
		{
			vlanid = "/";
		}
		ippingst.getCellShow(rowIndex,"vlanid").setValue(vlanid);
		ippingst.setCellModify(rowIndex,"vlanid",true);
		ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"vlanpri"),1);
		ippingst.getCellShow(rowIndex,"vlanpri").setValue(ippingst.getCellStoreValue(rowIndex,"vlanpri","vlanpri"));
		ippingst.setCellModify(rowIndex,"vlanpri",true);
		
		var encapType = ippingst.getCellStoreValue(rowIndex,"encapType","encapType");
		var encapTypeEditable = (encapType == "1");
		if(isSupportCevlan)
		{
			ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"cevlanid"),encapTypeEditable?0:1);
			var cevlanid = ippingst.getCellStoreValue(rowIndex,"cevlanid","cevlanid");
			if(cevlanid == INVALID_VLANID)
			{
				cevlanid = "/";
			}
			ippingst.getCellShow(rowIndex,"cevlanid").setValue(cevlanid);
			ippingst.setCellModify(rowIndex,"cevlanid",!encapTypeEditable);
			ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"cevlanpri"),encapTypeEditable?0:1);
			ippingst.getCellShow(rowIndex,"cevlanpri").setValue(ippingst.getCellStoreValue(rowIndex,"cevlanpri","cevlanpri"));
			ippingst.setCellModify(rowIndex,"cevlanpri",!encapTypeEditable);
		}
		
		var ip = ippingst.getCellStoreValue(rowIndex,"ip","ip");
		ippingst.getCellShow(rowIndex,"ip").setValue(ip);
		if(ip == INVALID_IP)
		{
			ippingst.getCellShow(rowIndex,"ip").setValue(INVALID_IP_ZERO);
			ippingst.setCellValue(ippingst.getCell(rowIndex,"ip"),"ip",INVALID_IP_ZERO);
			ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"ip"),1);
			ippingst.setCellModify(rowIndex,"ip",true);
		}
		var mask = ippingst.getCellStoreValue(rowIndex,"mask","mask");
		ippingst.getCellShow(rowIndex,"mask").setValue(mask);
		if(mask == INVALID_IP)
		{
			ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"mask"),1);
			ippingst.setCellModify(rowIndex,"mask",true);
		}
		var nextip = ippingst.getCellStoreValue(rowIndex,"nextip","nextip");
		ippingst.getCellShow(rowIndex,"nextip").setValue(nextip);
		if(nextip == INVALID_IP)
		{
			ippingst.getCellShow(rowIndex,"nextip").setValue(INVALID_IP_ZERO);
			ippingst.setCellValue(ippingst.getCell(rowIndex,"nextip"),"nextip",INVALID_IP_ZERO);
			ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"nextip"),1);
			ippingst.setCellModify(rowIndex,"nextip",true);
		}
		var nextmask = ippingst.getCellStoreValue(rowIndex,"nextmask","nextmask");
		ippingst.getCellShow(rowIndex,"nextmask").setValue(nextmask);
		if(nextmask == INVALID_IP)
		{
			ippingst.setCellIsEdit(ippingst.getCell(rowIndex,"nextmask"),1);
			ippingst.setCellModify(rowIndex,"nextmask",true);
		}
	}
}

/**
 *            
 */
function statusOnchange()
{
	var statusEdit = this;
	var rowIndex= statusEdit.parentNode.parentNode.rowIndex;
	var status = statusEdit.value;
	$("applyIpBtn").disabled = !btnRightArr.applyIpBtn.right;
	if(status == STATUS_DISABLED)
	{
		refreshStatusDisabled(rowIndex);
	}
	else
	{
		refreshStatusEnabled(rowIndex);
	}
}

/**
 *   IP Ping  
 */
function applyIPPing()
{
	var xml = createApplyIPPingXML();
	if(xml == null)
	{
		return;
	}
	$("queryIpBtn").disabled = true;
	$("applyIpBtn").disabled = true;
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PTN_IPPING_PARAMS + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, applyIPPingcallback,null, "inputdata=" + xml);
}

/**
 *     IPPing   XML
 */
function createApplyIPPingXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	for(var rowindex = 0,rowlen = ippingst.getDataRowLength();rowindex<rowlen;rowindex++)
	{
    	if(!ippingst.getModify(rowindex))
    	{
    		continue;
    	}
    	row = new tagElement("row-params");
    	
    	appendSlotPortParam(row,rowindex);
    	
    	appendVlanParam(row,rowindex);
		
		var bResult = appendIPPingParam(row,rowindex);
		if(bResult == false)
		{
			return null;
		}

		bussiness.appendChild(row);
	}
	if(0 == bussiness.childNodes.length)
	{
		return null;
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *           
 * @param row
 * @param rowindex
 */
function appendSlotPortParam(/*tagElement*/row,/*string*/rowindex)
{
	var param = new tagElement("param","neid",neid);
	row.appendChild(param);
	param = new tagElement("param","slotid",ippingst.getCellStoreValue(rowindex, "port", "slotid"));
	row.appendChild(param);
	param = new tagElement("param","port",ippingst.getCellStoreValue(rowindex, "port", "port"));
	row.appendChild(param);
	param = new tagElement("param","portlog",ippingst.getCellShow(rowindex, "port").getValue());
	row.appendChild(param);
}

/**
 *   VLAN    
 * @param row
 * @param rowindex
 */
function appendVlanParam(/*tagElement*/row,/*string*/rowindex)
{
	var vlanidModify = ippingst.getCellModify(rowindex,"vlanid");
	var vlanpriModify = ippingst.getCellModify(rowindex,"vlanpri");
	if(vlanidModify == true || vlanpriModify == true)
	{
		var vlanid = ippingst.getCellStoreValue(rowindex,"vlanid","vlanid");
		if(vlanid == "/")
		{
			vlanid = INVALID_VLANID;
		}
		var param = new tagElement("param","vlanid",vlanid);
		row.appendChild(param);
		param = new tagElement("param","vlanidlog",ippingst.getCellShow(rowindex,"vlanid").getValue());
		row.appendChild(param);
		param = new tagElement("param","vlanpri",ippingst.getCellStoreValue(rowindex,"vlanpri","vlanpri"));
		row.appendChild(param);
	}
	
	if(isSupportCevlan)
    {
		var cevlanidModify = ippingst.getCellModify(rowindex,"cevlanid");
		var cevlanpriModify = ippingst.getCellModify(rowindex,"cevlanpri");
		if(cevlanidModify == true || cevlanpriModify == true)
		{
			var cevlanid = ippingst.getCellStoreValue(rowindex,"cevlanid","cevlanid");
			if(cevlanid == "/")
			{
				cevlanid = INVALID_VLANID;
			}
			var param = new tagElement("param","cevlanid",cevlanid);
			row.appendChild(param);
			param = new tagElement("param","cevlanidlog",ippingst.getCellShow(rowindex,"cevlanid").getValue());
			row.appendChild(param);
			param = new tagElement("param","cevlanpri",ippingst.getCellStoreValue(rowindex,"cevlanpri","cevlanpri"));
			row.appendChild(param);
		}
	}
}
/**
 *   IP    
 * @param row
 * @param rowindex
 */
function appendIPPingParam(/*tagElement*/row,/*string*/rowindex)
{
	var statusModify = ippingst.getCellModify(rowindex,"status");
	var ipModify = ippingst.getCellModify(rowindex,"ip");
	var maskModify = ippingst.getCellModify(rowindex,"mask");
	var nextipModify = ippingst.getCellModify(rowindex,"nextip");
	var nextmaskModify = ippingst.getCellModify(rowindex,"nextmask");
	if(statusModify == true || ipModify == true || maskModify == true || nextipModify == true || nextmaskModify == true )
	{
		var status = ippingst.getCellStoreValue(rowindex,"status","status");
		var ip = ippingst.getCellStoreValue(rowindex,"ip","ip");
		var mask = ippingst.getCellStoreValue(rowindex,"mask","mask");
		var nextip = ippingst.getCellStoreValue(rowindex,"nextip","nextip");
		var nextmask = ippingst.getCellStoreValue(rowindex,"nextmask","nextmask");
		if(status == STATUS_DISABLED)
		{
			ip = INVALID_IP;
			mask = INVALID_IP;
			nextip = INVALID_IP;
			nextmask = INVALID_IP;
		}
		else
		{
			if(isIPInvalid(ip) || isIPInvalid(mask) || isIPInvalid(nextip) || isIPInvalid(nextmask))
			{
				alert(RESOURCE["IDS_INVALUABLEIP"]);
				return false;
			}
		}
		param = new tagElement("param","status",status);
		row.appendChild(param);
		param = new tagElement("param","ip",ip);
		row.appendChild(param);
		param = new tagElement("param","mask",mask);
		row.appendChild(param);
		param = new tagElement("param","nextip",nextip);
		row.appendChild(param);
		param = new tagElement("param","nextmask",nextmask);
		row.appendChild(param);
	}
	return true;
}

/**
 *   IPPing       
 * @param doc
 */
function applyIPPingcallback(/*XMLDOM*/doc)
{
	var data = EncapsulateData(doc);
	$("queryIpBtn").disabled = !btnRightArr.queryIpBtn.right;
	if(OPERATION_SUCCESS != data.getSErrorCode() )
	{
		$("applyIpBtn").disabled = !btnRightArr.applyIpBtn.right;
		showErrorDialog(data);
	}
	else
	{
		refreshTableState(ippingst,window.tableconf[0],data);
		for(var i = 0; i < ippingst.getDataRowLength(); i++)
	  {
	  	var status = ippingst.getCellStoreValue(i, "status","status");
	  	if(ippingst.getCellModify(i,"status") == true)
	  	{
	  		continue;
	  	}
	  	if(status == STATUS_DISABLED)
	  	{
			refreshStatusDisabled(i);
	  	}
	  	else
	  	{
	  		ippingst.setCellIsEdit(ippingst.getCell(i,"ip"),0);
			ippingst.setCellIsEdit(ippingst.getCell(i,"mask"),0);
			ippingst.setCellIsEdit(ippingst.getCell(i,"nextip"),0);
			ippingst.setCellIsEdit(ippingst.getCell(i,"nextmask"),0);
	  	}
	  }
	}
	
}

/**
 *   ARPIP
 * 
 * @param rowIndex
 * @return  
 */
function queryArpIP(/*string*/rowIndex)
{
	if(!btnRightArr.queryArpBtn.right)
	{
		return;
	}
	if(SelectedIPPingRowIndex == rowIndex)
	{
		return;
	}
	SelectedIPPingRowIndex = rowIndex;
	var xml = createQueryArpIPXML(rowIndex);
	if(xml == null)
	{
		return;
	}
	arpipst.clearTableData();
	$("addArpBtn").disabled = true;
	$("delArpBtn").disabled = true;
	$("applyArpBtn").disabled = true;
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_PTN_ARP_IP_ADDRESS + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, queryArpIPcallback, null, "inputdata="+ xml);
}

/**
 *            XML  
 * 
 * @param  
 * @return  
 */
function createQueryArpIPXML(/*string*/rowIndex)
{
	if(rowIndex < 0 || rowIndex > (ippingst.getDataRowLength() - 1))
	{
		return null;
	}
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param","neid",neid);
	row.appendChild(param);
	
	param = new tagElement("param","slotid",ippingst.getCellStoreValue(rowIndex, "port", "slotid"));
	row.appendChild(param);
	
	param = new tagElement("param","port",ippingst.getCellStoreValue(rowIndex, "port", "port"));
	row.appendChild(param);
	
	param = new tagElement("param","portlog",ippingst.getCellShow(rowIndex, "port").getValue());
	row.appendChild(param);

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

/**
 *   ARPIP       
 * @param doc
 */
function queryArpIPcallback(/*XMLDOM*/doc)
{
	var data = EncapsulateData(doc);
	$("addArpBtn").disabled = !btnRightArr.addArpBtn.right;
	
	arpipst.clearTableData();
	createTableBody(arpipst, window.tableconf[1], data, RESOURCE);
	validateIpForU2000Style(arpipst.getCellEdit(0,"ip").element,arpipst);
}


/**
 *       
 *               
 */
function showErrorDialog(/*Object*/data)
{
	if(data.getError() == null)
	{
		return;
	}
	var errArr = [];
	errArr[0] = "subrackname";
	errArr[1] = "slotid";
	errArr[2] = "boardname";
	errArr[3] = "portname";
	openErrPage("../../../../../page/", data.getError(), errArr); 
}

/**
 *     ARPIP  
 */
function addArpIP()
{
	if (arpipst.element.isAppendEmptyTr)
	{
		var tBody = arpipst.bodyPack.firstChild.lastChild;
		tBody.removeChild(tBody.firstChild);
		arpipst.element.isAppendEmptyTr = false;
	}
	var row = arpipst.createRow();
	var indexCell = arpipst.createCell(arpipst.getHeadCell("index").element.offsetWidth);
	var atom = arpipst.createAtom("span");
 	atom.setValue(getMaxIndexID() + 1);
	arpipst.addCellShow(indexCell, atom);
	
	var ipCell = arpipst.createCell(arpipst.getHeadCell("ip").element.offsetWidth);
	atom = arpipst.createAtom("span");
	atom.setValue(INVALID_IP_ZERO);
	arpipst.addCellShow(ipCell, atom);

	var editatom = arpipst.createAtom("text");
	arpipst.addCellEdit(ipCell, editatom);
	
	arpipst.addCell(row, "index", indexCell);
	arpipst.addCell(row, "ip", ipCell);
	arpipst.setCellIsEdit(ipCell, "1");
	arpipst.addRow(row);
	arpipst.adjustLayout(window.tableconf[1]);
	$("applyArpBtn").disabled = !btnRightArr.applyArpBtn.right;
}

/**
 *       ID
 */
function getMaxIndexID()
{
	var maxIndex = 0;
	for(var i = 0,len = arpipst.getDataRowLength();i < len;i++)
	{
		var index = parseInt(arpipst.getCellShow(i,"index").getValue());
		if(maxIndex < index)
		{
			maxIndex = index;
		}
	}
	return maxIndex;
}

/**
 *   ARP   IP  
 */
function delArpIP()
{
	if (!confirm(RESOURCE["alertinfo"]))
	{
		return;
	}
	var selectRows = arpipst.getSelectedRows();
	for(var i = selectRows.length-1;i>=0;i--)
	{
		var rowindex = selectRows[i];
		arpipst.deleteRow(rowindex);
	}
	arpipst.adjustDataRows();
	for(var i = 0,len = arpipst.getDataRowLength();i < len;i++)
	{
		arpipst.getCellShow(i,"index").setValue(i+1);
	}
	$("applyArpBtn").disabled = !btnRightArr.applyArpBtn.right;
}

/**
 *   Arp IP  ,    
 */
function applyArpIP()
{
	var xml = createApplyArpIPXML();
	if(xml == null)
	{
		return;
	}
	$("addArpBtn").disabled = true;
	$("delArpBtn").disabled = true;
	$("applyArpBtn").disabled = true;
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PTN_ARP_IP_ADDRESS + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, applyArpIPcallback, null, "inputdata="+ xml);
}

/**
 *     ARPIP XML
 */
function createApplyArpIPXML()
{
	var di = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = null;
	var param = null;
	for(var rowindex = 0,rowlen = arpipst.getDataRowLength();rowindex<rowlen;rowindex++)
	{
  		var ip = arpipst.getCellShow(rowindex, "ip").getValue();
  		if(isIPInvalid(ip))
  		{
  			arpipst.setCellModify(rowindex,"ip",true);
  			alert(RESOURCE["IDS_INVALUABLEIP"]);
  			return null;
  		}
    	row = new tagElement("row-params");
    	param = new tagElement("param","neid",neid);
		row.appendChild(param);
		param = new tagElement("param","slotid",ippingst.getCellStoreValue(SelectedIPPingRowIndex, "port", "slotid"));
		row.appendChild(param);
		param = new tagElement("param","port",ippingst.getCellStoreValue(SelectedIPPingRowIndex, "port", "port"));
		row.appendChild(param);
		param = new tagElement("param","portlog",ippingst.getCellShow(SelectedIPPingRowIndex, "port").getValue());
		row.appendChild(param);
		param = new tagElement("param","index",arpipst.getCellShow(rowindex, "index").getValue());
		row.appendChild(param);
		param = new tagElement("param","ip",ip);
		row.appendChild(param);
		bussiness.appendChild(row);
	}
	if(0 == bussiness.childNodes.length)
	{
		if(SelectedIPPingRowIndex != -1)
		{
			row = new tagElement("row-params");
			param = new tagElement("param","neid",neid);
			row.appendChild(param);
			param = new tagElement("param","slotid",ippingst.getCellStoreValue(SelectedIPPingRowIndex, "port", "slotid"));
			row.appendChild(param);
			param = new tagElement("param","port",ippingst.getCellStoreValue(SelectedIPPingRowIndex, "port", "port"));
			row.appendChild(param);
			param = new tagElement("param","portlog",ippingst.getCellShow(SelectedIPPingRowIndex, "port").getValue());
			row.appendChild(param);
			param = new tagElement("param","index","0");
			row.appendChild(param);
			param = new tagElement("param","ip","");
			row.appendChild(param);
			bussiness.appendChild(row);
		}
		else
		{
			return null;
		}
	}
	di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 *   Arp IP      
 * @param doc
 */
function applyArpIPcallback(/*XMLDOM*/doc)
{
	var data = EncapsulateData(doc);
	refreshTableState(arpipst,window.tableconf[1],data);
	$("addArpBtn").disabled = !btnRightArr.addArpBtn.right;
	if(arpipst.getSelectedRows().length > 0)
	{
		$("delArpBtn").disabled = !btnRightArr.delArpBtn.right;
	}
	if(OPERATION_SUCCESS != data.getSErrorCode() )
	{
		$("applyArpBtn").disabled = !btnRightArr.applyArpBtn.right;
	}
	showErrorDialog(data);
}

/**
 *    ARP  
 * 
 * @param  
 * @return  
 */
function queryArpTable()
{
	if(!btnRightArr.queryArpTblBtn.right)
	{
		return;
	}
	
	var rowIndex = SelectedIPPingRowIndex;
	var xml = createQueryArpTableXML(rowIndex);
	if(xml == null)
	{
		return;
	}
	arptablest.clearTableData();
	$("queryArpTblBtn").disabled = true;
	var url = "../../../../../neExlorerServlet?sfid=" + TECMDCODE_PTN_GET_ARPTABLE_BYPORT + "&nmUser=" + winobj["nmUser"];
	loadXMLdoc(url, "POST", true, queryArpTablecallback,null, "inputdata="
	+ xml);
}

/**
 *             
 * 
 * @param doc:          
 * @return  
 */
function queryArpTablecallback(doc)
{
	var data = EncapsulateData(doc);
	arptablest.clearTableData();
	createTableBody(arptablest, window.tableconf[2], data, RESOURCE);
	$("queryArpTblBtn").disabled = !btnRightArr.queryArpTblBtn.right;
	
	showErrorDialog(data);
}

/**
 *            XML  
 * 
 * @param  
 * @return  
 */
function createQueryArpTableXML(/*string*/rowIndex)
{
	if(rowIndex < 0 || rowIndex > (ippingst.getDataRowLength() - 1))
	{
		return null;
	}
	var root = new inputxml("datainterface");
	var bussiness = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	var param = null;
	param = new tagElement("param","neid",neid);
	row.appendChild(param);
	
	param = new tagElement("param","slotid",ippingst.getCellStoreValue(rowIndex, "port", "slotid"));
	row.appendChild(param);
	
	param = new tagElement("param","port",ippingst.getCellStoreValue(rowIndex, "port", "port"));
	row.appendChild(param);
	
	param = new tagElement("param","portlog",ippingst.getCellShow(rowIndex, "port").getValue());
	row.appendChild(param);

	bussiness.appendChild(row);
	root.getRoot().appendChild(bussiness);
	return root.toString();
}

window.onresize = function()
{
	arpipst.setBodyHeight(getComponetHeight($("tablecomponent"), 150)  * 0.6+ "px");
	arpipst.setBodyWidth(tableConfArpTable.width, tableConfArpTable.percent, 0);
	if(isSuppArpTbl)
	{
		arptablest.setBodyHeight(getComponetHeight($("tablecomponent"), 150) * 0.6 + "px");
		arptablest.setBodyWidth(tableConfArpIp.width, tableConfArpIp.percent, 0);
	}
	
}

function embedTabSelectHandler(id)
{
	arpipst.setBodyHeight(getComponetHeight($("tablecomponent"), 150) * 0.6 + "px");
	arpipst.setBodyWidth(tableConfArpIp.width, tableConfArpIp.percent, 0);
	if(isSuppArpTbl)
	{
		arptablest.setBodyHeight(getComponetHeight($("tablecomponent"), 150) * 0.6 + "px");
		arptablest.setBodyWidth(tableConfArpTable.width, tableConfArpTable.percent, 0);
	}
}

/**
 *   IP      ,    true,    false
 * @param ip IP  
 */
function isIPInvalid(/*string*/ip)
{
	return (ip == "" || ip == INVALID_IP_ZERO || ip == INVALID_IP);
}

/**
 *   IP Ping    
 */
function showIPPingTestDialog()
{
	xshowModelessDialog("startipping.html", RESOURCE["startIpPingTest"], 800, 800, "../../../../images/", false);//   
	
}

function xshowModelessDialog(url, title, width, height, imgpath, resizableFlg,scrollFlg,top,useParent)
{
	var resizable = resizableFlg;
    if(isNull(resizable))
	{
		resizable = "yes";
	}
    if(isNull(scrollFlg))
	{
		scrollFlg = "yes";
	}
   
	if (isIE)
	{
		if(navigator.userAgent.indexOf("MSIE 6") > -1)
		{
			height = height + 50;
		}
		
		window.open (url, "", "height=800, width=730, toolbar=no, menubar=no, scrollbars=yes, resizable=no, location=no, status=no"); 
	}
	else
	{
		document.location="wrui://ippingtest&/nemgr/ip/ptn/page/ipping/startipping.html";
	}		
}

/**
 *        
 */
function getSelectedRowsNum()
{
	var selRows = ippingst.getSelectedRows();
	return selRows.length;
}

/**
 *          
 */
function getCurTestIPPingBoard(rowid)
{
	if (rowid == null)
	{
		rowid =0;
	}
	var curBoard;
	var selRows = ippingst.getSelectedRows();
	if(selRows.length > 0)
	{
		curBoard = ippingst.getCellStoreValue(selRows[rowid], "port", "slotid") + "-" + ippingst.getCellStoreValue(selRows[rowid], "port", "boardname");
	}
	return curBoard;
}

/**
 *        
 */
function getCurTestIPPingBoardSlotID(rowid)
{
	if (rowid == null)
	{
		rowid =0;
	}
	var curBoardSlot;
	var selRows = ippingst.getSelectedRows();
	if(selRows.length > 0)
	{
		curBoardSlot = ippingst.getCellStoreValue(selRows[rowid], "port", "slotid");
	}
	return curBoardSlot;
}

/**
 *          
 */
function getCurTestIPPingPort(rowid)
{
	if (rowid == null)
	{
		rowid =0;
	}
	var curPort;
	var selRows = ippingst.getSelectedRows();
	if(selRows.length > 0)
	{
		curPort = ippingst.getCellStoreValue(selRows[rowid], "port", "portname");
	}
	return curPort;
}

/**
 *        ID
 */
function getCurTestIPPingPortID(rowid)
{
	if (rowid == null)
	{
		rowid =0;
	}
	var curPortID;
	var selRows = ippingst.getSelectedRows();
	if(selRows.length > 0)
	{
		curPortID = ippingst.getCellStoreValue(selRows[rowid], "port", "port");
	}
	return curPortID;
}

/**
 *      IPPING IP  
 */
function getCurTestTargetIP(rowid)
{
	if (rowid == null)
	{
		rowid =0;
	}
    var curIP;
	var selRows = ippingst.getSelectedRows();
	if(selRows.length > 0)
	{
		curIP = ippingst.getCellStoreValue(selRows[rowid], "nextip", "nextip");
	}
	return curIP;
}


function flexibleCompare(str1,str2)
{
    if(typeof(str1) == 'object')
    {
        str1 = str1.toString();
        str2 = str2.toString();
    }
    
    var arr1 = str1.split('-');
    var arr2 = str2.split('-');
    var a,b,result;
    
    for(var i = 0, len = arr1.length; i < len; i++)
    {
    	if (i == 0 && isNaN(parseInt(arr1[i])))
    	{
    		var shelf1 = arr1[i].split('(')[0];
    		var shelf2 = arr2[i].split('(')[0];
    		arr1[i] = shelf1.substring(shelf1.indexOf('f') + 1, shelf1.length);
    		arr2[i] = shelf2.substring(shelf2.indexOf('f') + 1, shelf2.length);
    	}
        if(isNaN(parseInt(arr1[i])))
        {
            a = arr1[i];
            b = arr2[i];
        } 
        else 
        {
            a = parseInt(arr1[i]);
            b = parseInt(arr2[i]);
        }

        result = compare(a, b);
        
        if( result == 0)
        {
            continue;
        } 
		else 
		{
            return result;
        }
    }
    
    return 0;

}

function getTestIPPingSlotId(rowid)
{
	var len = ippingst.getDataRowLength();
	
	if (len > 0)
	{
		var slotid = ippingst.getCellStoreValue(rowid, "port", "slotid");
	}
	
	return slotid;
}

function getTestIPPingBoardName(rowid)
{
	var len = ippingst.getDataRowLength();
	
	if (len > 0)
	{
		var boardname = ippingst.getCellStoreValue(rowid, "port", "boardname");
	}
	
	return boardname;
}

function getTestIPPingPortName(rowid)
{
	var len = ippingst.getDataRowLength();
	
	if (len > 0)
	{
		var portname = ippingst.getCellStoreValue(rowid, "port", "portname");
	}
	
	return portname;
}

function getTestIPPingSubrackname(rowid)
{
	var len = ippingst.getDataRowLength();
	
	if (len > 0)
	{
		var subrackname = ippingst.getCellStoreValue(rowid, "port", "subrackname");
	}
	
	return subrackname;
}

function getTestIPPingPortStatus(rowid)
{
	var len = ippingst.getDataRowLength();
	
	if (len > 0)
	{
		var status = ippingst.getCellStoreValue(rowid, "status", "status");
	}
	
	return status;
}

/**
 *        ID
 */
function getTestIPPingPortID(rowid)
{
	var len = ippingst.getDataRowLength();
	
	if(len > 0)
	{
		var PortID = ippingst.getCellStoreValue(rowid, "port", "port");
	}
	
	return PortID;
}
