function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initCountObj()
{
	
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", TE_CMD_UDPPW_QUERY_BSCFG);
    btnRightArr.applybtn = new BtnRightObj("applybtn", TE_CMD_UDPPW_SET_BSCFG);
    
    getRightInfo(winobj, btnRightArr);
}

function rowSelectHandler()
{

}

function cellEditHandler(param)
{
    if (param.stage == TABLE_CONSTANT.BEFOREEDIT) 
    {
        var rowIndex = param.rowindex;
        var size = parseInt(st.getCellCurrentValue(rowIndex, "udppwportsize", "udppwportsize"));
        textCheckWithStepLen(st.getCellEdit(rowIndex, "udppwportstart").element, "49152", "" + (0xFFFF - size + 1), "1024");
    }
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}

function convertSize(param)
{
    return parseInt(param) / 1024;
}

function doQuery()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createQueryXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_UDPPW_QUERY_BSCFG + "&nmUser=" + winobj.nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        
        var ce = st.getHeadCell("udppwportsize").element;
        st.sortRows(ce, 1);
        
        if (st.getDataRowLength() > 0) 
        {
            st.setRowSelect(0);
        }
    }
}

function createApplyXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, len = st.getDataRowLength(); i < len; i++) 
    {
        if (!st.getModify(i)) 
        {
            continue;
        }
        
        var row = new tagElement("row-params");
        row.appendChild(createTagElement("neid", winobj.neid));
        row.appendChild(createTagElement("udppwportsize", st.getCellCurrentValue(i, "udppwportsize", "udppwportsize")));
		row.appendChild(createTagElement("udppwportrange", st.getCellShow(i, "udppwportsize").element.innerHTML));
        row.appendChild(createTagElement("udppwportstart", st.getCellCurrentValue(i, "udppwportstart", "udppwportstart")));
        
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doApply()
{
    $("querybtn").disabled = true;
    $("applybtn").disabled = true;
    
    var xml = createApplyXML();
    var url = "../../../../../neExlorerServlet?sfid=" + TE_CMD_UDPPW_SET_BSCFG + "&nmUser=" + winobj.nmUser;
    loadXMLdoc(url, "POST", false, applyCallBack, null, "inputdata=" + xml);
}

function applyCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    if (data.getSErrorCode() != 0) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
    }
}

function showErrDialog(data)
{
	var errArr = [];
	errArr[0] = "errObjStr";
	var oError = data.getError();
	if(data.getBErrLength() > 0)
    {
        for(var i = 0, m = data.getBErrLength(); i < m ; i++)
        {
            var tempErrObjStr =  oError.getRowKey(i, "nename");
            if(null != oError.getRowKey(i, "udppwportsize") && "" != oError.getRowKey(i, "udppwportsize"))
            {
                tempErrObjStr += "-" + (parseInt(oError.getRowKey(i, "udppwportsize")) / 1024);
            }
            oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
        }
    }
    openErrPage("../../../../../page/", data.getError(), errArr);
}
