var st = null;

var loopback = new Array();
loopback[0] = "notused";

var btnRightArr = new Object();
var winobj = getNeProperty(self);

function init()
{
    initTable();
    initCountObj();
    initButton();
    initRight();
    
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    
    if (btnRightArr.querybtn.right) 
    {
        doQuery();
    }
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../images/");
    st.setOnRowSelectHandler(rowSelectHandler);
    st.setOnCellEditHandler(cellEditHandler);
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
    
    $("tbdiv").oncontextmenu = popupMenuHandler;
}

function initCountObj()
{
    var countArea = document.createElement("div");
    $("countdiv").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
}

function initButton()
{
    $("querybtn").value = RESOURCE["querybutton"];
    $("newbtn").value = RESOURCE["newbutton"];
    $("deletebtn").value = RESOURCE["deletebutton"];
    $("applybtn").value = RESOURCE["applybutton"];
}

function initRight()
{
    btnRightArr.querybtn = new BtnRightObj("querybtn", queryCmd);
    btnRightArr.newbtn = new BtnRightObj("newbtn", newCmd);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", deleteCmd);
    
    getRightInfo(winobj, btnRightArr);
}

function rowSelectHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    countObj.setSelectedCount(selectedRowCount);
    
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
    else 
    {
        $("deletebtn").disabled = true;
    }
}

function cellEditHandler(param)
{
    $("applybtn").disabled = !btnRightArr.applybtn.right;
}

function createQueryXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", winobj.neid));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doQuery()
{
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    
    var xml = createQueryXML();
    var url = "../../../../../neExlorerServlet?sfid=" + queryCmd + "&nmUser=" + winobj.nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

function queryCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        st.clearTableData();
        createTableBody(st, window.tableconf[0], data, RESOURCE);
        countObj.setTotalCount(st.getDataRowLength());
        
        var v = null;
        for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
        {
            v = st.getCellCurrentValue(i, "vlanid", "vlanid");
            if (null == v || parseInt(v) == 0xFFFF) 
            {
                st.getCellShow(i, "vlanid").element.innerHTML = "-";
            }
            v = st.getCellCurrentValue(i, "apsid", "apsid");
            if (null == v) 
            {
                st.getCellShow(i, "apsid").element.innerHTML = "-";
            }
        }
        
        var ce = st.getHeadCell("tunnelid").element;
        st.sortRows(ce, 1);
        
        if (st.getDataRowLength() > 0) 
        {
            st.setRowSelect(0);
            rowSelectHandler();
        }
    }
}

function createDeleteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowIndexes = st.getSelectedRows();
    for (var i = 0, m = rowIndexes.length; i < m; i++) 
    {
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", winobj.neid));
        rowparams.appendChild(createTagElement("tunnelindex", st.getCellCurrentValue(rowIndexes[i], "tunnelindex", "tunnelindex")));
		rowparams.appendChild(createTagElement("tunnelid", st.getCellCurrentValue(rowIndexes[i], "tunnelid", "tunnelid")));
		rowparams.appendChild(createTagElement("srcboard", st.getCellCurrentValue(rowIndexes[i], "srcboard", "boardname")));		
		rowparams.appendChild(createTagElement("srcport", st.getCellCurrentValue(rowIndexes[i], "srcport", "portname")));		
		rowparams.appendChild(createTagElement("dstipaddress", st.getCellCurrentValue(rowIndexes[i], "dstipaddr", "dstipaddr")));		
		rowparams.appendChild(createTagElement("tunnelvlan", st.getCellShow(rowIndexes[i], "vlanid").element.innerHTML));
        bussiness.appendChild(rowparams);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doDelete()
{
	if (!confirm(RESOURCE["confirminfo"]))
	{
		return;
	}
    $("querybtn").disabled = true;
    $("newbtn").disabled = true;
    $("deletebtn").disabled = true;
    
    var xml = createDeleteXML();
    var url = "../../../../../neExlorerServlet?sfid=" + deleteCmd + "&nmUser=" + winobj.nmUser;
    loadXMLdoc(url, "POST", false, deleteCallBack, null, "inputdata=" + xml);
}

function deleteCallBack(doc)
{
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    $("newbtn").disabled = !btnRightArr.newbtn.right;
    
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "errObjStr";
    
    var oError = data.getError();
    var indexes = st.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var tempErrObjStr = oError.getRowKey(i, "nename");
        var tunnelIndex = oError.getRowKey(i, "tunnelindex");
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var tunnel = st.getCellCurrentValue(indexes[j], "tunnelindex", "tunnelindex");
            if (tunnelIndex == tunnel) 
            {
                tempErrObjStr += "-" + st.getCellCurrentValue(indexes[j], "tunnelid", "tunnelid");
                indexes.splice(j, 1);
                break;
            }
        }
		oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
    }
	
    openErrPage("../../../../../page/", data.getError(), errArr);
	
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        st.deleteRow(indexes[k]);
    }
    st.adjustDataRows();
    
    countObj.setTotalCount(st.getDataRowLength());
    if (st.getSelectedRowCount() <= 0 && st.getDataRowLength() > 0) 
    {
        st.setRowSelect(0);
    }
    rowSelectHandler();
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}
