var ct = null;
var portRes = null;
var win = getParentWindow();
var neid = win.winobj.neid;
var nmUser = win.winobj.nmUser;
var type = getNeProperty(self).type;

function init()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];
    
    initTable();
    
    getPortRes();
}

function initTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["getvalue"]);
    
    var atom = new Atom("text");
    atom.element.style.width = "40%";
    atom.element.disabled = true;
    checkText(atom.element, "1", "256");
    ct.addAttrRow("tunnelid", RESOURCE["tunnelid"], atom);
    
    var checkbox = document.createElement("input");
    checkbox.setAttribute("type", "checkbox");
    checkbox.setAttribute("id", "autoassign");
    checkbox.onclick = checkAutoAssign;
    atom.element.parentNode.appendChild(checkbox);
    
    var span = document.createElement("span");
    span.innerHTML = RESOURCE["autoassign"];
    atom.element.parentNode.appendChild(span);
    
    if (type == "gre") 
    {
        atom = new Atom("select");
        atom.element.disabled = true;
        atom.element.options[atom.element.options.length] = new Option(RESOURCE["notused"], "0");
        ct.addAttrRow("loopback", RESOURCE["loopback"], atom);
    }
    
    atom = new Atom("select");
    atom.element.onchange = changeBoard;
    ct.addAttrRow("srcboard", RESOURCE["srcboard"], atom);
    
    atom = new Atom("select");
    ct.addAttrRow("srcport", RESOURCE["srcport"], atom);
    
    atom = new Atom("text");
    validateIp(atom.element);
    atom.setValue("0.0.0.0");
    ct.addAttrRow("dstipaddr", RESOURCE["dstipaddr"], atom);
    
    $("tbdiv").appendChild(ct.getTable());
    
    checkbox.checked = true;
}

function checkAutoAssign()
{
    var atom = ct.getAtom("tunnelid");
    if (this.checked) 
    {
        atom.setValue("");
        atom.element.disabled = true;
    }
    else 
    {
        atom.setValue("1");
        atom.element.disabled = false;
    }
}

function changeBoard()
{
    var atom = ct.getAtom("srcboard");
    var board = atom.element.options[atom.element.options.selectedIndex].text;
    
    atom = ct.getAtom("srcport");
    atom.element.options.length = 0;
    
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
		var tmp = new Array();
		var lastIndex = portRes[i].lastIndexOf("#");
		tmp[0] = portRes[i].substring(0, lastIndex);
		tmp[1] = portRes[i].substring(lastIndex + 1, portRes[i].length);
				
        var port = tmp[0];
        var arr = port.split("-");
        var bd = arr[0] + "-" + arr[1];
        var portId = parseInt(tmp[1]);
        if (portId >= 0x1000 && portId <= 0x17FF) 
        {
            bd = "ML-PPP";
        }
        else if (portId >= 0x2800 && portId <= 0x2FFF) 
        {
            bd = "Virtual Ethernet";
        }
        port = port.substring(port.indexOf("-", port.indexOf("-") + 1) + 1, port.length);
        
        if (board == bd) 
        {
            atom.addOption(port, portId);
        }
    }
}

function createGetPortResXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function getPortRes()
{
    var xml = createGetPortResXML();
    var url = "../../../../../neExlorerServlet?sfid=" + win.getResCmd + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, getPortResCallBack, null, "inputdata=" + xml);
}

function getPortResCallBack(doc)
{
    portRes = new Array();
    
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0) 
    {
        var options = data.getDataRowOptions(0, "portres");
        if (null != options) 
        {
            var option;
            var tmpArr = new Array();
            var atom = ct.getAtom("srcboard");
            atom.element.options.length = 0;
            for (var i = 0, m = options.length; i < m; i++) 
            {
                option = options[i];
                portRes[portRes.length] = option;
                
				var strArr = new Array();
				var lastIndex = option.lastIndexOf("#");
				strArr[0] = option.substring(0, lastIndex);
				strArr[1] = option.substring(lastIndex + 1, option.length);
				
                var arr = strArr[0].split("-");
                var bd = arr[0] + "-" + arr[1];
                var portId = parseInt(strArr[1]);
                
                if (portId >= 0x1000 && portId <= 0x17FF) 
                {
                    bd = "ML-PPP";
                }
                else if (portId >= 0x2800 && portId <= 0x2FFF) 
                {
                    bd = "Virtual Ethernet";
                }
                
                if (!tmpArr.contains(bd)) 
                {
                    tmpArr[tmpArr.length] = bd;
                    atom.addOption(bd, arr[0]);
                }
            }
            tmpArr.clear();
            
            changeBoard();
        }
    }
}

function createTunnelXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("indexauto", 1));
    rowparams.appendChild(createTagElement("tunnelindex", 0xFFFFFFFF));
    
    var idAuto = 1;
    var tunnelId = 0xFFFF;
    if (!$("autoassign").checked) 
    {
        idAuto = 0;
        tunnelId = ct.getAtom("tunnelid").getValue();
    }
    rowparams.appendChild(createTagElement("idauto", idAuto));
    rowparams.appendChild(createTagElement("tunnelid", tunnelId));
    
    var atom = ct.getAtom("srcboard");
    rowparams.appendChild(createTagElement("slotid", atom.getValue()));
    rowparams.appendChild(createTagElement("srcboard", atom.element.options[atom.element.options.selectedIndex].text));
    
    atom = ct.getAtom("srcport");
    rowparams.appendChild(createTagElement("port", atom.getValue()));
    rowparams.appendChild(createTagElement("srcport", atom.element.options[atom.element.options.selectedIndex].text));
    
    var dstIPAddr = ct.getAtom("dstipaddr").getValue();
    rowparams.appendChild(createTagElement("dstipaddr", parseInt("0x" + convertIpaddrToHexcode(dstIPAddr))));
    rowparams.appendChild(createTagElement("dstipaddress", dstIPAddr));
	rowparams.appendChild(createTagElement("tunnelvlan", "-"));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doCreate(param)
{
    if ("" == ct.getAtom("srcport").getValue()) 
    {
        alert(RESOURCE["srcportinvalid"]);
        return;
    }
    var xml = createTunnelXML();
    var url = "../../../../../neExlorerServlet?sfid=" + win.newCmd + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createCallBack, param, "inputdata=" + xml);
}

function createCallBack(doc, param)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0) 
    {
        win.doQuery();
        if (param) 
        {
            xcloseDialog();
        }
        else 
        {
            refreshData();
        }
    }
}

function refreshData()
{
    ct.getAtom("tunnelid").setValue("");
    ct.getAtom("tunnelid").element.disabled = true;
    $("autoassign").checked = true;
    ct.getAtom("dstipaddr").setValue("0.0.0.0");
}

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../page/", data.getError(), errArr);
}
