var serviceunist = null;
var vunigroupst = null;

var countObj = null;
var btnRightArr = new Object();
var grouptypeConvert = new Array();
grouptypeConvert[1] = "ingress";
grouptypeConvert[2] = "egress";

var obj = getNeProperty(self);
var neid = obj["neid"];
var nmUser = obj["nmUser"];

/**
 *          
 */
window.onload = function() 
{
	initTable();
	initCountObj();
	initInfo();

	if (btnRightArr["querybtn"].right) 
	{
		queryVuniGroup();
	}
}
/**
 *        
 */
function initCountObj()
{
    var countArea = document.createElement("div");
    $("vunigroupinfo").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
}
/**
 *      
 */
function initTable()
{
	vunigroupst = new SortTable();
	vunigroupst.setImage("../../../../../../images/");
	createTableHead(vunigroupst, window.tableconf[0]);
	vunigroupst.setOnRowSelectHandler(rowSelectedHandler);
	vunigroupst.setBodyHeight(getComponetHeight($("container"),400) + "px");
	$("vunigrouptable").appendChild(vunigroupst.getTable());
		
	serviceunist = new SortTable();
	serviceunist.setImage("../../../../../../images/");
	createTableHead(serviceunist, window.tableconf[1]);

	serviceunist.setBodyHeight("200px");
	$("serviceunitable").appendChild(serviceunist.getTable());
}

/**
 *             
 */
function initInfo()
{
	$("querybtn").value = RESOURCE["querybutton"];
	$("createbtn").value = RESOURCE["newbutton"];
	$("deletebtn").value = RESOURCE["deletebutton"];
	$("modifybtn").value = RESOURCE["modifybutton"];
	$("vunigrouptitle").innerHTML = RESOURCE["vunigrouptitle"];
	$("serviceunititle").innerHTML = RESOURCE["serviceunititle"];
	$("queryRealTitle").innerHTML = RESOURCE["queryRealTitle"];
	btnRightArr.querybtn = new BtnRightObj("querybtn",
			TE_CMDCODE_IPPTN_QUERY_VUNIGRP);
	btnRightArr.createbtn = new BtnRightObj("createbtn",
			TE_CMDCODE_IPPTN_ADD_VUNIGRP);
	btnRightArr.deletebtn = new BtnRightObj("deletebtn",
			TE_CMDCODE_IPPTN_DEL_VUNIGRP);
	btnRightArr.modifybtn = new BtnRightObj("modifybtn",
			TE_CMDCODE_IPPTN_MOD_VUNIGRP);

	getRightInfo(obj, btnRightArr);

	$("querybtn").disabled = !btnRightArr["querybtn"].right;
	$("createbtn").disabled = !btnRightArr["createbtn"].right;
	$("deletebtn").disabled = true;
	$("modifybtn").disabled = true;
}

/**
 *     VUNI  XML  
 */
function createQueryVuniGroupXml()
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param","neid",neid);
    row.appendChild(param);
    
    param = new tagElement("param","vunigroupid","0");
    row.appendChild(param);
    
    param = new tagElement("param","queryreal",$("queryRealck").checked);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);

    return root.toString();
}

/**
 *   VUNI 
 */
function queryVuniGroup()
{
	$("querybtn").disabled = true;
	$("createbtn").disabled = true;
	$("deletebtn").disabled = true;
	$("modifybtn").disabled = true;
	$("queryRealck").disabled = true;
	var xmldata = createQueryVuniGroupXml();
	var urlstr = "../../../../../../neExlorerServlet?sfid="
			+ TE_CMDCODE_IPPTN_QUERY_VUNIGRP + "&nmUser=" + nmUser;
	loadXMLdoc(urlstr, "POST", true, callbackQueryVuniGroup, null, "inputdata=" + xmldata);
}

/**
 *   VUNI      
 * @param {Object} doc
 */
function callbackQueryVuniGroup(doc)
{
	$("querybtn").disabled = false;
	$("createbtn").disabled = false;
	$("queryRealck").disabled = false;
	var data = EncapsulateData(doc);
	
	if (data.getSErrorCode() == 0)
	{
		var selectedIDs = [];
		var rows = vunigroupst.getSelectedRows();
		for(var i = 0,len = rows.length;i < len;i++)
		{
			var groupid = vunigroupst.getCellStoreValue(rows[i],"vunigroupid","vunigroupid");
			selectedIDs[groupid] = groupid;
		}
		vunigroupst.clearTableData();
		createTableBody(vunigroupst, window.tableconf[0], data, RESOURCE);
		countObj.setTotalCount(vunigroupst.getDataRowLength());
		
		for(var i = 0,len = vunigroupst.getDataRowLength();i < len;i++)
		{
			var groupid = vunigroupst.getCellStoreValue(i,"vunigroupid","vunigroupid");
			if(groupid in selectedIDs)
			{
				vunigroupst.setRowSelect(i);
			}
			if($("queryRealck").checked)
			{
				var realcir = vunigroupst.getCellStoreValue(i,"hiddenValue","realcir");
				var realpir = vunigroupst.getCellStoreValue(i,"hiddenValue","realpir");
				vunigroupst.getCellShow(i,"cir").setValue(realcir?realcir:"0");
				vunigroupst.getCellShow(i,"pir").setValue(realpir?realpir:"0");
			}
		}

		if (vunigroupst.getDataRowLength() > 0 && vunigroupst.getSelectedRows() <= 0)
		{
			vunigroupst.setRowSelect(0);
		}
		rowSelectedHandler();
	}
	showErrorDialog(data);
}

/**
 *   VUNI       
 */
function createVUniGroup()
{
	var url = "../vunigroup/createvunigroup.html?flag=create";
    xshowModalDialog(url, RESOURCE["createvunigrouptitle"], 580, 500, "../../../../../../images/");
}

/**
 *   VUNI        
 */
function queryVuniGroupInterface()
{
	var xmldata = createQueryInterfaceXML();
	if(xmldata == null)
	{
		return;
	}
	var urlstr = "../../../../../../neExlorerServlet?sfid="
			+ TE_CMDCODE_IPPTN_GET_VUNIGRP_INTERFACE + "&nmUser=" + nmUser;
	loadXMLdoc(urlstr, "POST", true, callbackQueryInterface, null, "inputdata=" + xmldata);
}

/**
 *     VUNI       XML
 */
function createQueryInterfaceXML()
{
	var rows = vunigroupst.getSelectedRows();
	if(rows.length <= 0)
	{
		return null;
	}
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    param = new tagElement("param","neid",neid);
    row.appendChild(param);
    param = new tagElement("param","vunigroupid",vunigroupst.getCellStoreValue(rows[0],"vunigroupid","vunigroupid"));
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);

    return root.toString();
}

/**
 *   VUNI        
 * @param {Object} doc
 */
function callbackQueryInterface(doc)
{
	var data = EncapsulateData(doc);

	if (data.getSErrorCode() == 0)
	{
		serviceunist.clearTableData();
		createTableBody(serviceunist, window.tableconf[1], data, RESOURCE);
		resetNMSPortName(serviceunist);
	}
	showErrorDialog(data);
}

function resetNMSPortName(st)
{
	for(var i = 0,len = st.getDataRowLength();i < len;i++)
	{
		var slotid = st.getCellStoreValue(i,"interface","slotid");
		if(slotid == "65535")
		{
			st.getCellShow(i,"interface").setValue("NMS-1");
		}
	}
}

/**
 * VUNI                      
 */
function rowSelectedHandler()
{
    var selectedRowCount = vunigroupst.getSelectedRowCount();
    countObj.setSelectedCount(selectedRowCount);
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = false;
        $("modifybtn").disabled = false;
        queryVuniGroupInterface();
    }
    else 
    {
        $("deletebtn").disabled = true;
        $("modifybtn").disabled = true;
        serviceunist.clearTableData();
    }
}

/**
 *   VUNI        
 */
function modifyVUniGroup()
{
	var rows = vunigroupst.getSelectedRows();
	if(rows.length <= 0)
	{
		return;
	}
	var url = "../vunigroup/createvunigroup.html?flag=modify";
    xshowModalDialog(url, RESOURCE["modifyvunigrouptitle"], 580, 500, "../../../../../../images/");
}

/**
 *   VUNI 
 */
function delVUniGroup()
{
	var xmldata = createDeleteVUniGroupXML();
	if(xmldata == null)
	{
		return;
	}
	var urlstr = "../../../../../../neExlorerServlet?sfid="
			+ TE_CMDCODE_IPPTN_DEL_VUNIGRP + "&nmUser=" + nmUser;
	loadXMLdoc(urlstr, "POST", true, callbackDeleteVuniGroup, null, "inputdata=" + xmldata);
}

/**
 *     VUNI  XML
 */
function createDeleteVUniGroupXML()
{
	var rows = vunigroupst.getSelectedRows();
	if(rows.length <= 0)
	{
		return null;
	}
	var root = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    for(var i = 0,len = rows.length;i < len;i++)
    {
	    var row = new tagElement("row-params");
	    param = new tagElement("param","neid",neid);
	    row.appendChild(param);
	    param = new tagElement("param","vunigroupid",vunigroupst.getCellStoreValue(rows[i],"vunigroupid","vunigroupid"));
	    row.appendChild(param);
	    bussiness.appendChild(row);
    }
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

/**
 *   VUNI      
 * @param {Object} doc
 */
function callbackDeleteVuniGroup(doc)
{
	var data = EncapsulateData(doc);
	
	if (data.getSErrorCode() == 0)
	{
		var rows = vunigroupst.getSelectedRows();
		for(var i = rows.length - 1;i >= 0;i--)
    	{
    		vunigroupst.deleteRow(rows[i]);
    	}
    	vunigroupst.adjustDataRows();
    	if (vunigroupst.getDataRowLength() > 0)
		{
			vunigroupst.setRowSelect(0);
		}
		rowSelectedHandler();
	}
	showErrorDialog(data);
}

/**
 *               
 * @param {Object} data
 */
function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../../page/", data.getError(), errArr); 
}
