var ct = null;
var availabletable = null;
var selectedtable = null;

var obj = getNeProperty(self);
var parentWin = getDialogParentWindow();
var neid = parentWin["neid"];
var nmUser = parentWin["nmUser"];
var flag = obj.flag;
var portRes = null;

/**
 * 3     
 */
var ETH_TYPE_ELINE = "1";
var ETH_TYPE_ELAN = "2";
var ETH_TYPE_EAGGR = "4";

/**
 *           
 */
if(flag == "modify")
{
	document.title = RESOURCE["modifyvunigrouptitle"];
}
else
{
	document.title = RESOURCE["createvunigrouptitle"];
}
/**
 *        
 */
window.onload = function()
{
	initTable();
	getResource();
}

/**
 *        
 */
function initTable()
{
	ct = new CTable();
	ct.addHead(RESOURCE["ATTRIBUTE_res"], RESOURCE["VALUE_res"]);

	var atom = new Atom("text");
	ct.addAttrRow("vunigroupid", RESOURCE["vunigroupidtitle"], atom);
	checkText(atom.element, 1, 65535);

	atom = new Atom("select");
	atom.addOption(RESOURCE["ingress"],1);
	atom.addOption(RESOURCE["egress"],2);
	ct.addAttrRow("grouptype", RESOURCE["vunigrouptypetitle"], atom);

	atom = new Atom("text");
	atom.element.disabled = true;
	atom.setValue("-");
	ct.addAttrRow("cir", RESOURCE["cirtitle"], atom);
	checkText(atom.element, 128, 100000000);
	atom = new Atom("text");
	atom.element.disabled = true;
	atom.setValue("-");
	ct.addAttrRow("cbs", RESOURCE["cbstitle"], atom);
	checkText(atom.element, 64, 512000);
	atom = new Atom("text");
	ct.addAttrRow("pir", RESOURCE["pirtitle"], atom);
	checkText(atom.element, 128, 100000000);
	atom.element.onchange = priElmOnChange;
	atom = new Atom("text");
	ct.addAttrRow("pbs", RESOURCE["pbstitle"], atom);
	checkText(atom.element, 64, 512000);
	$("attrtable").appendChild(ct.getTable());
	
	availabletable = new SortTable();
	availabletable.isUsedForSelectList = true;
	availabletable.setImage("../../../../../../images/");
	createTableHead(availabletable, window.tableconf[0]);
	availabletable.setOnRowSelectHandler(availableSelectHandler);
	availabletable.setBodyHeight("200px");
	$("availabletable").appendChild(availabletable.getTable());
	
	selectedtable = new SortTable();
	selectedtable.isUsedForSelectList = true;
	selectedtable.setImage("../../../../../../images/");
	createTableHead(selectedtable, window.tableconf[0]);
	selectedtable.setOnRowSelectHandler(selectedSelectHandler);
	selectedtable.setBodyHeight("200px");
	$("selectedtable").appendChild(selectedtable.getTable());

	$("vunigrouptitle").innerHTML = RESOURCE["membertitle"];
	$("availableportlabel").innerHTML = RESOURCE["availabletitle"];
	$("selectedportlabel").innerHTML = RESOURCE["selectedtitle"];
	
	$("confirmbtn").value = RESOURCE["okbutton"];
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	
	$("rightButton").disabled = true;
	$("leftButton").disabled = true;
	
	if(flag == "modify")
	{
		var rowIndex = parentWin.vunigroupst.getSelectedRows()[0];
		ct.setAttrValue("vunigroupid",parentWin.vunigroupst.getCellStoreValue(rowIndex,"vunigroupid","vunigroupid"));
		ct.setAttrValue("grouptype",parentWin.vunigroupst.getCellStoreValue(rowIndex,"grouptype","grouptype"));
		ct.setAttrValue("cir",parentWin.vunigroupst.getCellStoreValue(rowIndex,"cir","cir"));
		ct.setAttrValue("pir",parentWin.vunigroupst.getCellStoreValue(rowIndex,"pir","pir"));
		ct.setAttrValue("pbs",parentWin.vunigroupst.getCellStoreValue(rowIndex,"pbs","pbs"));
		ct.getAtom("vunigroupid").element.disabled = true;
		ct.getAtom("grouptype").element.disabled = true;
	}
}

/**
 * PRI        CIR
 */
function priElmOnChange()
{
	ct.setAttrValue("cir",this.value);
}

/**
 *          
 * @param {Object} rows
 */
function availableSelectHandler(rows)
{
	if(rows.length > 0)
	{
		$("rightButton").disabled = false;
	}
	else
	{
		$("rightButton").disabled = true;
	}
}

/**
 *          
 * @param {Object} rows
 */
function selectedSelectHandler(rows)
{
	if(rows.length > 0)
	{
		$("leftButton").disabled = false;
	}
	else
	{
		$("leftButton").disabled = true;
	}
}

/**
 *         
 */
function getResource()
{
	var xml = createGetResXml();
	var urlstr = "../../../../../../neExlorerServlet?sfid="
			+ TE_CMDCODE_IPPTN_GET_VUNIGRP_RES + "&nmUser=" + nmUser;
	loadXMLdoc(urlstr, "POST", false, callbackGetRes, null, "inputdata=" + xml);
}

/**
 *          XML
 */
function createGetResXml()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = createGetResRow(ETH_TYPE_ELINE);
	firstlevel.appendChild(secondlevel);
	secondlevel = createGetResRow(ETH_TYPE_ELAN);
	firstlevel.appendChild(secondlevel);
	secondlevel = createGetResRow(ETH_TYPE_EAGGR);
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

/**
 *          Row  
 * @param {Object} ethtype
 */
function createGetResRow(ethtype)
{
	var secondlevel = new tagElement("row-params");

	var thirdlevel = new tagElement("param","neid",neid);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","ethType",ethtype);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","serviceIndex","0");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","vuniID","0");
	secondlevel.appendChild(thirdlevel);
	return secondlevel;
}

/**
 *            
 * @param {Object} doc
 */
function callbackGetRes(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0)
	{
		availabletable.clearTableData();
		createTableBody(availabletable, window.tableconf[0], data, RESOURCE);
		parentWin.resetNMSPortName(availabletable);
	}
	
	if(flag == "modify")
	{
		var dinterface = new DataInterface();
		for(var i = 0,len = parentWin.serviceunist.getDataRowLength();i < len;i++)
		{
			dinterface.rows.append(createDataRow(parentWin.serviceunist,i));
			
			var serviceIndex = parentWin.serviceunist.getCellStoreValue(i,"hiddenValue","serviceIndex");
			var vuniID = parentWin.serviceunist.getCellStoreValue(i,"hiddenValue","vuniID");
			removeAvailableTableData(serviceIndex,vuniID);
		}
		createTableBody(selectedtable, window.tableconf[0], dinterface, RESOURCE);
		parentWin.resetNMSPortName(selectedtable);
	}
}


/**
 *         
 * @param {Object} serviceIndex
 * @param {Object} vuniID
 */
function removeAvailableTableData(serviceIndex,vuniID)
{
	for(var i = 0,len = availabletable.getDataRowLength();i < len;i++)
	{
		if((availabletable.getCellStoreValue(i,"hiddenValue","serviceIndex") == serviceIndex)
			|| (availabletable.getCellStoreValue(i,"hiddenValue","vuniID") == vuniID))
		{
			availabletable.deleteRow(i);
		}
	}
	availabletable.adjustDataRows();
}

/**
 *      DataInterface
 * @param {Object} st
 */
function getDataInterface(st)
{
	var selectedrows = st.getSelectedRows();
	var dinterface = new DataInterface();
	for(var i = selectedrows.length - 1; i >= 0; i--)
    {
        dinterface.rows.append(createDataRow(st,selectedrows[i]));  
        st.deleteRow(selectedrows[i]);
    }
    st.adjustDataRows();
    return dinterface;
}

/**
 *        DataRow
 * @param {Object} st
 * @param {Object} rowindex
 */
function createDataRow(st,rowindex)
{
	var obj = new Object();
	ptag = new ParamTag();
    ptag.value = st.getCellStoreValue(rowindex,"serviceID","serviceID");
    obj["serviceID"] = ptag;
    ptag = new ParamTag();
    ptag.value = st.getCellStoreValue(rowindex,"interface","slotid");
    obj["slotid"] = ptag;
    ptag = new ParamTag();
    ptag.value = st.getCellStoreValue(rowindex,"interface","boardname");
    obj["boardname"] = ptag;
    ptag = new ParamTag();
    ptag.value = st.getCellStoreValue(rowindex,"interface","portname");
    obj["portname"] = ptag;
    ptag = new ParamTag();
    ptag.value = st.getCellStoreValue(rowindex,"hiddenValue","vuniID");
    obj["vuniID"] = ptag;
    ptag = new ParamTag();
    ptag.value = st.getCellStoreValue(rowindex,"hiddenValue","portid");
    obj["portid"] = ptag;
    ptag = new ParamTag();
    ptag.value = st.getCellStoreValue(rowindex,"hiddenValue","serviceIndex");
    obj["serviceIndex"] = ptag;
    return obj;
}

/**
 *      
 */
function right()
{
	var dinterface = getDataInterface(availabletable);
    createTableBody(selectedtable, window.tableconf[0], dinterface, RESOURCE);
    parentWin.resetNMSPortName(selectedtable);
    $("rightButton").disabled =true;
}

/**
 *      
 */
function left()
{
	var dinterface = getDataInterface(selectedtable);
    createTableBody(availabletable, window.tableconf[0], dinterface, RESOURCE);
    parentWin.resetNMSPortName(selectedtable);
    $("leftButton").disabled =true;
}

/**
 *       
 */
function confirmVuniGroup()
{
	sendVuniGroup(true);
}

/**
 *       
 */
function applyVuniGroup()
{
	sendVuniGroup(false);
}

/**
 *   VUNI   
 * @param {Object} closeFlag
 */
function sendVuniGroup(closeFlag)
{
	if(ct.getAttrValue("vunigroupid") == ""
		|| ct.getAttrValue("pir") == ""
		|| ct.getAttrValue("pbs") == "")
	{
		alert(RESOURCE["format"]);
		return;
	}	
	var xml = createNewXml();
	var sfid = TE_CMDCODE_IPPTN_ADD_VUNIGRP;
	if(flag != "create")
	{
		sfid = TE_CMDCODE_IPPTN_MOD_VUNIGRP;
	}
	$("confirmbtn").disabled = true;
	$("applybtn").disabled = true;
	var urlstr = "../../../../../../neExlorerServlet?sfid="+ sfid +"&nmUser="+nmUser;
	loadXMLdoc(urlstr, "POST", true, callbackNew, closeFlag, "inputdata="+xml);
}

/**
 *     VUNI XML
 */
function createNewXml()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");

	var thirdlevel = new tagElement("param","neid",neid);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","auto","0");
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","vunigroupid",ct.getAttrValue("vunigroupid"));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","grouptype",ct.getAttrValue("grouptype"));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","uninumber",selectedtable.getDataRowLength());
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","uniinfo",constructUniInfo());
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","cir",convertQosValue(ct.getAttrValue("cir")));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","cbs",convertQosValue(ct.getAttrValue("cbs")));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","pir",convertQosValue(ct.getAttrValue("pir")));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param","pbs",convertQosValue(ct.getAttrValue("pbs")));
	secondlevel.appendChild(thirdlevel);

	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

/**
 *   Qos  -      
 * @param {Object} value
 */
function convertQosValue(value)
{
	if(value == "-")
	{
		return 0xFFFFFFFF;
	}
	return value;
}

/**
 *        UNI    QX        
 */
function constructUniInfo()
{
	var result = "";
	for(var i = 0,len = selectedtable.getDataRowLength();i < len;i++)
	{
		var vuniID = "00000000" + toHex(selectedtable.getCellStoreValue(i,"hiddenValue","vuniID"));
		var serviceIndex = "00000000" + toHex(selectedtable.getCellStoreValue(i,"hiddenValue","serviceIndex"));
		
		result += "00" + serviceIndex.substr(serviceIndex.length - 8) + "00" + vuniID.substr(vuniID.length - 8);
	}
	if(result == "")
	{
		result = "00000000000000000000";
	}
	return result;
}

/**
 *          
 * @param {Object} doc
 * @param {Object} closeFlag
 */
function callbackNew(doc, closeFlag)
{
	var data = EncapsulateData(doc);
	$("confirmbtn").disabled = false;
	$("applybtn").disabled = false;
	showErrorDialog(data);
	
	if (data.getSErrorCode() == 0)
	{
		parentWin.queryVuniGroup();
		if (closeFlag)
		{
			xcloseDialog();
    	}
    	else
    	{
    		if(flag == "create")
			{
    			ct.setAttrValue("vunigroupid","");
    		}
    	}
	}
}

/**
 *            VUNI ID
 * @param {Object} data
 */
function showErrorDialog(data)
{
    var oError = data.getError();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var tempErrObjStr = RESOURCE["vunigroupidtitle"] + ":" + oError.getRowKey(i, "vunigroupid");
        oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
    }
    
    var errArr = [];
    errArr[0] = "errObjStr";
    openErrPage("../../../../../../page/", data.getError(), errArr); 
}
