var st = null;
var qosQinqTable = null;
var tab = null;
var countObj = null;
var btnRightArr = new Object();
var directionConvert = new Array();
directionConvert[1] = "ingress";
directionConvert[2] = "egress";
var enableState = [];//    
enableState[0] = "disabled";//  
enableState[1] = "enabled"//  
var obj = getNeProperty(self);
var neid = obj["neid"];
var nmUser = obj["nmUser"];
var isSupportQinqQos = false;
window.onload = function() 
{
	isSupportQinqQos = SpecialAttrMgr.isNESupport(neid, "TEFUNC_MSTPPLUS_QOS_QINQ_POLICY", "QOS_ATTR_SUPPORT_QINQPOLICY");
	initTable();
	initCountObj();
	initInfo();

	if (btnRightArr["querybtn"].right) 
	{
		getQinQLink();
	}

}

function initTable()
{
	if(isSupportQinqQos)
	{
		$("qosContainer").style.display = "";
		initTabs();
		qosQinqTable = new SortTable();
		qosQinqTable.setImage("../../../../../../images/");
		createTableHead(qosQinqTable, window.tableconf[1]);
		qosQinqTable.setOnRowSelectHandler(rowQosSelectedHandler);
		qosQinqTable.setOnCellEditHandler(cellQosEditHandler);
		qosQinqTable.setBodyHeight("150px");
		$("elineqosqinqtable").appendChild(qosQinqTable.getTable());
	}
	st = new SortTable();
	st.setImage("../../../../../../images/");
	createTableHead(st, window.tableconf[0]);
	st.setOnRowSelectHandler(rowSelectedHandler);

	st.setBodyHeight(getTableHeight($("table"), st) + "px");
	$("table").appendChild(st.getTable());
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tabdiv", "QoS", $("elineqosqinqtable"));
    
    setSelectedEmbedTab("tabdiv");
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function initInfo() {
	$("querybtn").value = RESOURCE["querybutton"];
	$("createbtn").value = RESOURCE["newbutton"];
	$("deletebtn").value = RESOURCE["deletebutton"];
	$("printbtn").value = RESOURCE["printbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	$("querypolicybtn").value = RESOURCE["querypolicybtn"];
	btnRightArr.querybtn = new BtnRightObj("querybtn",
			TE_CMDCODE_PTN_QUERY_QINQLNK);
	btnRightArr.createbtn = new BtnRightObj("createbtn",
			TE_CMDCODE_PTN_ADD_QINQLINK);
	btnRightArr.deletebtn = new BtnRightObj("deletebtn",
			TE_CMDCODE_PTN_DEL_QINQLINK);

	getRightInfo(obj, btnRightArr);

	$("querybtn").disabled = !btnRightArr["querybtn"].right;
	$("createbtn").disabled = !btnRightArr["createbtn"].right;
	$("deletebtn").disabled = true;
	$("applybtn").disabled = true;
}

function queryPolicy()
{
    var policyType = QINQ_POLICY;

    var tmpIndex = qosQinqTable.getSelectedRows()[0];
    var policy = qosQinqTable.getCellStoreValue(tmpIndex, "policy", "policy");
    if (typeof(policy) == "undefined" || null == policy || "" == policy) 
    {
        alert(RESOURCE["selectpolicy"]);
        return;
    }
    var url = "../ethcommon/policyinfo.html?policyType=" + policyType + "&policyId=" + policy.substring(0, policy.indexOf("("));
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 580, 420, "../../../../../../images/");
}

function openDialog_QoS()
{
    var policyType = QINQ_POLICY;
    if (qosQinqTable.getSelectedRowCount() > 1) 
    {
        return;
    }
    
    var url = "../ethcommon/policyselect.html?policyType=" + policyType;
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 480, 300, "../../../../../images/");
}

function initCountObj()
{
    var countArea = document.createElement("div");
    $("info").appendChild(countArea);
    countObj = new TableDataCount();
    countArea.appendChild(countObj.getCountArea());
}

function rowSelectedHandler()
{
    var selectedRowCount = st.getSelectedRowCount();
    countObj.setSelectedCount(selectedRowCount);
    if (selectedRowCount > 0) 
    {
        $("deletebtn").disabled = false;
        $("applybtn").disabled = true;
        if(isSupportQinqQos)
    	{
    	        $("applybtn").disabled = true;
        	queryQinQQos();
    	}
    }
    else 
    {
        $("deletebtn").disabled = true;
        if(isSupportQinqQos)
    	{
        	qosQinqTable.clearTableData();
        	$("applybtn").disabled = true;
        	$("querypolicybtn").disabled = true;
    	}
    }

}

function rowQosSelectedHandler()
{
	if(qosQinqTable.getSelectedRows().length > 0)
	{
		$("querypolicybtn").disabled = false;
	}
	else
	{
		$("querypolicybtn").disabled = true;
	}
}

function cellQosEditHandler(param)
{
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applybtn").disabled = false;
	}
}


function getQinQLink() {
	$("querybtn").disabled = true;

	var xmldata = createGetXml();
	var urlstr = "../../../../../../neExlorerServlet?sfid="
			+ TE_CMDCODE_PTN_QUERY_QINQLNK + "&nmUser=" + nmUser;
	loadXMLdoc(urlstr, "POST", false, callbackGet, null, "inputdata=" + xmldata);
}

function applyQinQQos()
{
	var xmldata = createApplyQinQQosXML();
	if(xmldata != null)
	{
		$("applybtn").disabled = true;
		var urlstr = "../../../../../../neExlorerServlet?sfid="
			+ TE_CMDCODE_PTN_SET_QINQLNK_QOS + "&nmUser=" + nmUser;
		loadXMLdoc(urlstr, "POST", false, callbackApplyQinQQos, null, "inputdata=" + xmldata);
	}
}

function createApplyQinQQosXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, m = qosQinqTable.getDataRowLength(); i < m; i++) 
    {
    	if (!qosQinqTable.getModify(i)) 
        {
            continue;
        }
    	var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("autolinkid", "0"));
        rowparams.appendChild(createTagElement("linkid", qosQinqTable.getCellStoreValue(i, "linkid", "linkid")));
        rowparams.appendChild(createTagElement("direction", qosQinqTable.getCellStoreValue(i, "direction", "direction")));
        if (qosQinqTable.getCellModify(i, "policy")) 
        {
            rowparams.appendChild(createTagElement("autopolicyid", "0"));
            var policy = qosQinqTable.getCellStoreValue(i, "policy", "policy");
			var policyInfo = policy;
            if (typeof(policy) == "undefined" || policy == "") 
            {
                policy = INVALID_LABEL_VALUE_2;
				policyInfo = "";
            }
            else 
            {
                policy = policy.substring(0, policy.indexOf("("));
            }
			rowparams.appendChild(createTagElement("policyinfo", policyInfo));
            rowparams.appendChild(createTagElement("policyid", policy));
        }
        var bandwidthlimit = qosQinqTable.getCellStoreValue(i, "bandwidthlimit", "bandwidthlimit");
        var oldbandwidthlimit = qosQinqTable.getCellStoreValue(i, "oldBandwidthlimit", "oldBandwidthlimit");
        if (oldbandwidthlimit == "1" && bandwidthlimit == "1") //  
        {
            rowparams.appendChild(createTagElement("cir", qosQinqTable.getCellStoreValue(i, "cir", "cir")));
            rowparams.appendChild(createTagElement("cbs", qosQinqTable.getCellStoreValue(i, "cbs", "cbs")));
            rowparams.appendChild(createTagElement("pir", qosQinqTable.getCellStoreValue(i, "pir", "pir")));
            rowparams.appendChild(createTagElement("pbs", qosQinqTable.getCellStoreValue(i, "pbs", "pbs")));
        }
        else  if (oldbandwidthlimit != "1" && bandwidthlimit == "1") //  
        {
            rowparams.appendChild(createTagElement("createdirection", qosQinqTable.getCellStoreValue(i, "direction", "direction")));
            rowparams.appendChild(createTagElement("createcir",convertQosValue(qosQinqTable.getCellShow(i, "cir").element.innerHTML)));
            rowparams.appendChild(createTagElement("createcbs", convertQosValue(qosQinqTable.getCellShow(i, "cbs").element.innerHTML)));
            rowparams.appendChild(createTagElement("createpir",convertQosValue(qosQinqTable.getCellShow(i, "pir").element.innerHTML)));
            rowparams.appendChild(createTagElement("createpbs", convertQosValue(qosQinqTable.getCellShow(i, "pbs").element.innerHTML)));
        }
        else if (oldbandwidthlimit == "1"  && bandwidthlimit != "1") //  
        {
            rowparams.appendChild(createTagElement("deletedirection", qosQinqTable.getCellStoreValue(i, "direction", "direction")));
        }
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}
/**
 *     Qos         -/         
 *              F
 * @param value
 * @return
 */
function convertQosValue(value)
{
	if(value == "-" || value == "/")
	{
		return 4294967295;
	}
	return value;
}

function callbackApplyQinQQos(doc)
{
	var data = EncapsulateData(doc);
	refreshTableState(qosQinqTable, window.tableconf[1], data);
	if (data.getSErrorCode() == 0)
    {
    	for (var i = 0; i < qosQinqTable.getDataRowLength(); i++)
    	{
    		var cell = qosQinqTable.getCell(i, "oldBandwidthlimit");
    		var cellvar = qosQinqTable.getCellStoreValue(i, "bandwidthlimit", "bandwidthlimit");
    		qosQinqTable.setCellValue(cell, "oldBandwidthlimit", cellvar);
    	}
    }
	else
	{
		$("applybtn").disabled = false;
	}
	var oError = data.getError();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var linkId = oError.getRowKey(i, "linkid");
        var tempErrObjStr = "QinQ Link ID-" + linkId;
        oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
    }
    var errArr = [];
    errArr[0] = "errObjStr";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}


function queryQinQQos()
{
	var xmldata = createQueryQinQQosXML();
	if(xmldata != null)
	{
		var urlstr = "../../../../../../neExlorerServlet?sfid="
			+ TE_CMDCODE_PTN_GET_QINQLNK_QOS + "&nmUser=" + nmUser;
		loadXMLdoc(urlstr, "POST", false, callbackQueryQinQQos, null, "inputdata=" + xmldata);
	}
}

function createQueryQinQQosXML()
{
	var selectedRowCount = st.getSelectedRowCount();
	if(selectedRowCount <= 0)
	{
		return null;
	}
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = new tagElement("param","neid",neid);
    row.appendChild(param);
    var linkid = st.getCellStoreValue(st.getSelectedRows()[0],"linkid","linkid");
    param = new tagElement("param","linkid",linkid);
    row.appendChild(param);
    param = new tagElement("param","direction","0");
    row.appendChild(param);
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);

    return root.toString();
}

function callbackQueryQinQQos(doc)
{
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 0) {
		qosQinqTable.clearTableData();
		createTableBody(qosQinqTable, window.tableconf[1], data, RESOURCE);
		for(var i = 0,len = qosQinqTable.getDataRowLength();i < len;i++)
		{
			handleTableQos(i);
		}
	}
}

function handleTableQos(rowindex)
{
	qosQinqTable.getCell(rowindex, "policy").element.ondblclick = openDialog_QoS;
	var bandwithlimit = qosQinqTable.getCellStoreValue(rowindex, "bandwidthlimit",
			"bandwidthlimit");
	var cell = qosQinqTable.getCell(rowindex, "cbs");
	qosQinqTable.setCellIsEdit(cell, 0);
	qosQinqTable.getCellShow(rowindex, "cbs").element.innerHTML = "-";
	cell = qosQinqTable.getCell(rowindex, "pbs");
	qosQinqTable.setCellIsEdit(cell, 0);
	qosQinqTable.getCellShow(rowindex, "pbs").element.innerHTML = "-";
	if (bandwithlimit != "1") {
		var cell = qosQinqTable.getCell(rowindex, "cir");
		qosQinqTable.setCellIsEdit(cell, 0);
		qosQinqTable.getCellShow(rowindex, "cir").element.innerHTML = "-";

		cell = qosQinqTable.getCell(rowindex, "pir");
		qosQinqTable.setCellIsEdit(cell, 0);
		qosQinqTable.getCellShow(rowindex, "pir").element.innerHTML = "-";
	}
	textCheck(qosQinqTable.getCellEdit(rowindex, "cir").element, 64, 1000000);
    textCheck(qosQinqTable.getCellEdit(rowindex, "pir").element, 64, 1000000);
    textCheck(qosQinqTable.getCellEdit(rowindex, "cbs").element, 0, 4294967295);
    textCheck(qosQinqTable.getCellEdit(rowindex, "pbs").element, 0, 4294967295);
    var bandwidthlimitCell = qosQinqTable.getCellEdit(rowindex, "bandwidthlimit");
    bandwidthlimitCell.element.onchange = function ()
    {
    	 var selectIndex = qosQinqTable.getSelectedRows()[0];
    	 if(this.value ==1)
    	 {
    	 	 var cell = qosQinqTable.getCell(selectIndex, "cir");
    	 	qosQinqTable.setCellIsEdit(cell, 1);
    	 	qosQinqTable.getCellShow(selectIndex, "cir").element.innerHTML = "64";
    	 	qosQinqTable.setCellValue(cell, "cir", 64);
         
             cell = qosQinqTable.getCell(selectIndex, "cbs");
             qosQinqTable.setCellIsEdit(cell, 0);
             qosQinqTable.getCellShow(selectIndex, "cbs").element.innerHTML = "-";
             
             cell = qosQinqTable.getCell(selectIndex, "pir");
             qosQinqTable.setCellIsEdit(cell, 1);
             qosQinqTable.getCellShow(selectIndex, "pir").element.innerHTML = "64";
             qosQinqTable.setCellValue(cell, "pir", 64);
             
             cell = qosQinqTable.getCell(selectIndex, "pbs");
             qosQinqTable.setCellIsEdit(cell, 0);
             qosQinqTable.getCellShow(selectIndex, "pbs").element.innerHTML = "-";
             
    	 }
    	 else
    	 {
    	 	 var cell = qosQinqTable.getCell(selectIndex, "cir");
    	 	qosQinqTable.setCellIsEdit(cell, 0);
    	 	qosQinqTable.getCellShow(selectIndex, "cir").element.innerHTML = "-";
         
             cell = qosQinqTable.getCell(selectIndex, "cbs");
             qosQinqTable.setCellIsEdit(cell, 0);
             qosQinqTable.getCellShow(selectIndex, "cbs").element.innerHTML = "-";
             
             cell = qosQinqTable.getCell(selectIndex, "pir");
             qosQinqTable.setCellIsEdit(cell, 0);
             qosQinqTable.getCellShow(selectIndex, "pir").element.innerHTML = "-";
             
             cell = qosQinqTable.getCell(selectIndex, "pbs");
             qosQinqTable.setCellIsEdit(cell, 0);
             qosQinqTable.getCellShow(selectIndex, "pbs").element.innerHTML = "-";
    	 }
    }
}

function createGetXml()
{
	var root = new inputxml("datainterface");
	
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    var param = null;
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "linkid");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    root.getRoot().appendChild(bussiness);

    return root.toString();
}

function callbackGet(doc) {
	$("querybtn").disabled = false;
	var data = EncapsulateData(doc);

	if (data.getSErrorCode() == 0) {
		st.clearTableData();
		createTableBody(st, window.tableconf[0], data, RESOURCE);
		countObj.setTotalCount(st.getDataRowLength());

		if (st.getDataRowLength() > 0) {
			st.setRowSelect(0);
		}
		rowSelectedHandler();
	}

	showErrorDialog(data);
}

function createQinQLink()
{
		var url = "createqinqlink.html?neid="+neid+"&nmUser="+nmUser;		
		var title = RESOURCE["crtqinqlink"];
		xshowModalDialog(url, title, 480, 295, "../../../../../../images/");
}

function delQinQLink()
{
		if (st.getSelectedRowCount() <= 0)
		{
				alert(RESOURCE["nodata"]);
        return;
    }
	
	if (!confirm(RESOURCE["confirminfo"]))
	{
		return;
	}
		
		$("deletebtn").disabled = true;
		
		var xmldata = createDelXml();
		var urlstr = "../../../../../../neExlorerServlet?sfid="+TE_CMDCODE_PTN_DEL_QINQLINK+"&nmUser="+nmUser;
		loadXMLdoc(urlstr, "POST", false, callbackDel, null, "inputdata="+xmldata);
}

function createDelXml()
{
		var root = new inputxml("datainterface");	
    var bussiness = new tagElement("bussiness-params");
    
    for (var i=0,len=st.getSelectedRowCount(); i<len; i++)
    {
    		var linkid = st.getCellStoreValue(st.getSelectedRows()[i], "linkid", "linkid");
    		
		    var row = new tagElement("row-params");
		    var param = new tagElement("param");
		    param.setAttribute("name", "neid");
		    param.setAttribute("value", neid);
		    row.appendChild(param);
		    
		    param = new tagElement("param");
		    param.setAttribute("name", "linkid");
		    param.setAttribute("value", linkid);
		    row.appendChild(param);
		    
		    bussiness.appendChild(row);
	  }
	  
    root.getRoot().appendChild(bussiness);
    return root.toString();
}

function callbackDel(doc)
{
    var data = EncapsulateData(doc);
    
    var oError = data.getError();
    var indexes = st.getSelectedRows();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var linkId = oError.getRowKey(i, "linkid");
        var tempErrObjStr = "QinQ Link ID-" + linkId;
        oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
        
        for (var j = indexes.length - 1; j >= 0; j--) 
        {
            var link = st.getCellCurrentValue(indexes[j], "linkid", "linkid");
            if (linkId == link) 
            {
                indexes.splice(j, 1);
                break;
            }
        }
    }
    
    var errArr = [];
    errArr[0] = "errObjStr";
    openErrPage("../../../../../../page/", data.getError(), errArr);
    
    for (var k = indexes.length - 1; k >= 0; k--) 
    {
        st.deleteRow(indexes[k]);
    }
    st.adjustDataRows();
    
    countObj.setTotalCount(st.getDataRowLength());
    if (st.getSelectedRowCount() <= 0 && st.getDataRowLength() > 0) 
    {
        st.setRowSelect(0);
    }
    rowSelectedHandler();
}

function printQinQLink()
{
		if (st.getDataRowLength() <= 0)
		{
				alert(RESOURCE["nodata"]);
				return;
		}
		
		openPrintPage("../../../../../../page/", RESOURCE["qinqlink"], "st");
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../../page/", data.getError(), errArr); 
}
