var ct = null;

var obj = getNeProperty(self);
var parentWin = getParentWindow();
var neid = obj["neid"];
var nmUser = obj["nmUser"];
var QinQ_Link_ID_MIN = 1;
var QinQ_Link_ID_MAX = 4294967295;
var SVlan_ID_MIN = 1;
var SVlan_ID_MAX = 4094;
var isSupportQinqQos = false;
var portRes = null;
var enableState = [];//    
enableState[0] = "disabled";//  
enableState[1] = "enabled"//  
window.onload = function()
{
	isSupportQinqQos = SpecialAttrMgr.isNESupport(neid,
			"TEFUNC_MSTPPLUS_QOS_QINQ_POLICY", "QOS_ATTR_SUPPORT_QINQPOLICY");
	if(isSupportQinqQos)
	{
		initTabs();
	}
	initTable();
	getResource();
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("basic", RESOURCE["basicattr"], $("table"));
    tab.addEmbedTab("tabdiv", "QoS", $("qosqinqtable"));
    setSelectedEmbedTab("basic");
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function initTable()
{
	ct = new CTable();
	ct.addHead(RESOURCE["ATTRIBUTE_res"], RESOURCE["VALUE_res"]);

	var atom = new Atom("text");
	ct.addAttrRow("linkid", "QinQ Link ID", atom);
	checkText(atom.element, QinQ_Link_ID_MIN, QinQ_Link_ID_MAX);

	atom = new Atom("select");
	ct.addAttrRow("board", RESOURCE["board"], atom);
	atom.element.onchange = getPortRes;

	atom = new Atom("select");
	ct.addAttrRow("port", RESOURCE["port"], atom);

	atom = new Atom("text");
	ct.addAttrRow("svlanid", "S-Vlan ID", atom);
	checkText(atom.element, SVlan_ID_MIN, SVlan_ID_MAX);

	$("table").appendChild(ct.getTable());

	$("confirmbtn").value = RESOURCE["okbutton"];
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	
	if(isSupportQinqQos)
	{
		initQoSTableData(window.tableconf[0],"../../../../../../images/");
	}
}


function getResource()
{
	var xml = createGetResXml();
	var urlstr = "../../../../../../neExlorerServlet?sfid="
			+ TE_CMDCODE_PTN_GET_QINQLINK_RES + "&nmUser=" + nmUser;
	loadXMLdoc(urlstr, "POST", false, callbackGetRes, null, "inputdata=" + xml);
}

function createGetResXml()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	var secondlevel = new tagElement("row-params");

	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);

	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function callbackGetRes(doc)
{
    portRes = new Array();
    var atom = ct.getAtom("board");
    atom.element.options.length = 0;
    
    var data = EncapsulateData(doc);
    var param = data.getDataRowParam(0, "portlist");
    if (null != param) 
    {
        var opt = null;
        var tmpArr = null;
        var option = null;
        var bdList = new Array();
        var options = data.getDataRowOptions(0, "portlist");
        for (var i = 0, m = options.length; i < m; i++) 
        {
            option = options[i];
            portRes[portRes.length] = option;
            
            tmpArr = option.split("-");
            
            if (!bdList.contains(tmpArr[0])) 
            {
                bdList[bdList.length] = tmpArr[0];
                atom.addOption(tmpArr[0] + "-" + tmpArr[1], tmpArr[0]);
            }
        }
    }
    
    getPortRes();
}

function getPortRes()
{
    var atom = ct.getAtom("port");
    atom.element.options.length = 0;
    
    var port = null;
    var tmpArr = null;
    var tmpPort = null;
    var portName = null;
	var lastIndex = -1;
    var slotId = ct.getAtom("board").getValue();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        port = portRes[i];
		lastIndex = port.lastIndexOf("#");
		tmpArr = new Array();
        tmpArr[0] = port.substring(0, lastIndex);
		tmpArr[1] = port.substring(lastIndex + 1, port.length);
        tmpPort = tmpArr[0].split("-");
        if (slotId == tmpPort[0]) 
        {
            portName = tmpArr[0].substring(tmpArr[0].indexOf("-", tmpArr[0].indexOf("-") + 1) + 1, tmpArr[0].length);
            atom.addOption(portName, tmpArr[1]);
        }
    }
}

function createGetPortXml(param)
{
		var root = new inputxml("datainterface");
		var firstlevel = new tagElement("bussiness-params");
		var secondlevel = new tagElement("row-params");

		var thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "neid");
		thirdlevel.setAttribute("value", neid);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "slotid");
		thirdlevel.setAttribute("value", param);
		secondlevel.appendChild(thirdlevel);

		firstlevel.appendChild(secondlevel);
		root.getRoot().appendChild(firstlevel);
		return root.toString();
}

function callbackGetPort(doc)
{
		var data = EncapsulateData(doc);

		for (var i=0; i<data.getDataRowLength(); i++)
		{
				var val = data.getDataRowParam(i, "portid");
				var txt = data.getDataRowParam(i, "portname");
				
				var opt = new Option(txt, val);
				addOptionToSelect(ct.getAtom("port").element, opt);
		}
}

function createQinQLink(param)
{
    var sourceVid = ct.getAttrValue("linkid").trim();
    var sinkVid = ct.getAttrValue("svlanid").trim();
    var board = ct.getAttrValue("board");
    var port = ct.getAttrValue("port");
    if(sourceVid == '')
    {
        alert(RESOURCE["noSourceVid"]);
        return;
    }
    
    if (board == '')
    {
        alert(RESOURCE["nullboardid"]);
        return;
    }
    
    if (port == '')
    {
        alert(RESOURCE["nullportid"]);
        return;
    }
    
    if(sinkVid == '')
    {
        alert(RESOURCE["noSinkVid"]);
        return;
    }
    
		var xml = createNewXml();
		var urlstr = "../../../../../../neExlorerServlet?sfid="+TE_CMDCODE_PTN_ADD_QINQLINK+"&nmUser="+nmUser;
		loadXMLdoc(urlstr, "POST", false, callbackNew, param, "inputdata="+xml);
}

function createNewXml()
{
		var root = new inputxml("datainterface");
		var firstlevel = new tagElement("bussiness-params");
		var secondlevel = new tagElement("row-params");

		var thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "neid");
		thirdlevel.setAttribute("value", neid);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "autolinkid");
		thirdlevel.setAttribute("value", "0");
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "linkid");
		thirdlevel.setAttribute("value", ct.getAttrValue("linkid"));
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "slotid");
		thirdlevel.setAttribute("value", ct.getAttrValue("board"));
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "subslotid");
		thirdlevel.setAttribute("value", "255");
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "portid");
		thirdlevel.setAttribute("value", ct.getAttrValue("port"));
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "svlanid");
		thirdlevel.setAttribute("value", ct.getAttrValue("svlanid"));
		secondlevel.appendChild(thirdlevel);

		firstlevel.appendChild(secondlevel);
		if(isSupportQinqQos)
		{
			appendQosParam(firstlevel,ct.getAttrValue("linkid"));
		}
		root.getRoot().appendChild(firstlevel);
		return root.toString();
}


function callbackNew(doc, param)
{
		var data = EncapsulateData(doc);
		
		showErrorDialog(data);
		
		if (data.getSErrorCode() == 0)
		{
        fillTableData();
				
				if (param == 0)
				{
						xcloseDialog();
        }
    }
}

function fillTableData()
{
    var root = document.createElement("datainterface");
    var firstlevel = document.createElement("bussiness-params");
    var secondlevel = document.createElement("row-params");
    
    thirdlevel = document.createElement("param");
    thirdlevel.setAttribute("name", "linkid");
    thirdlevel.setAttribute("value", ct.getAttrValue("linkid"));
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = document.createElement("param");
    thirdlevel.setAttribute("name", "slotid");
    thirdlevel.setAttribute("value", ct.getAttrValue("board"));
    secondlevel.appendChild(thirdlevel);
    
    var options = ct.getAtom("board").element.options;
    var v = options[options.selectedIndex].text.split("-");
    thirdlevel = document.createElement("param");
    thirdlevel.setAttribute("name", "boardname");
    thirdlevel.setAttribute("value", v[1]);
    secondlevel.appendChild(thirdlevel);
    
    options = ct.getAtom("port").element.options;
    thirdlevel = document.createElement("param");
    thirdlevel.setAttribute("name", "portname");
    thirdlevel.setAttribute("value", options[options.selectedIndex].text);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = document.createElement("param");
    thirdlevel.setAttribute("name", "svlanid");
    thirdlevel.setAttribute("value", ct.getAttrValue("svlanid"));
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    root.appendChild(firstlevel);
    
    var st = parentWin.st;
    createTableBody(st, parentWin.window.tableconf[0], EncapsulateData(root), RESOURCE);
    
    var indexes = st.getSelectedRows();
    for (var i = 0, m = indexes.length; i < m; i++) 
    {
        st.setRowNoneSelect(indexes[i]);
    }
    st.setRowSelect(st.getDataRowLength() - 1);
    parentWin.countObj.setTotalCount(st.getDataRowLength());
    parentWin.rowSelectedHandler();
}
function showErrorDialog(data)
{
    var oError = data.getError();
    for (var i = 0, m = data.getBErrLength(); i < m; i++) 
    {
        var tempErrObjStr = "QinQ Link ID-" + oError.getRowKey(i, "linkid");
        oError.rowErrors[i].errorObj["errObjStr"] = tempErrObjStr;
    }
    
    var errArr = [];
    errArr[0] = "errObjStr";
    openErrPage("../../../../../../page/", data.getError(), errArr); 
}
