var VUNI_INGRESS_POLICY = 2; //     VUNI
var VUNI_EGRESS_POLICY = 3; //     VUNI

function UniResObject(uniid,slotid,boardname,portid,portname,direction,policy,cos,color)
{
	this.uniid = uniid;
	this.slotid = slotid;
	this.portid = portid;
	this.boardname = "";
	if(typeof(boardname) != "undefined" && boardname)
	{
		this.boardname = boardname;
	}
	this.portname = portname;
	this.direction = direction;
	this.policy = "";
	if(typeof(policy) != "undefined")
	{
		this.policy = policy;
	}
	this.cos = "8";
	if(typeof(cos) != "undefined")
	{
		this.cos = cos;
	}
	this.color = "3";
	if(typeof(color) != "undefined")
	{
		this.color = color;
	}
}


function createInitUNIQosRow(resobject)
{
	var rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("vuniId", resobject.uniid));
    rowParams.appendChild(createParamElement("slotid", resobject.slotid));
    rowParams.appendChild(createParamElement("portid", resobject.portid));
    rowParams.appendChild(createParamElement("boardname", resobject.boardname));
    rowParams.appendChild(createParamElement("portname", resobject.portname));
    rowParams.appendChild(createParamElement("direction", resobject.direction));
    rowParams.appendChild(createParamElement("bandwidthlimit", 0));
    rowParams.appendChild(createParamElement("policy", resobject.policy));
    rowParams.appendChild(createParamElement("cos", resobject.cos));
    rowParams.appendChild(createParamElement("color", resobject.color));
    rowParams.appendChild(createParamElement("cir", ""));
    rowParams.appendChild(createParamElement("cbs", ""));
    rowParams.appendChild(createParamElement("pir", ""));
    rowParams.appendChild(createParamElement("pbs", ""));
    return rowParams;
}

function uniTableQosHandler(uniqosTable,isSupportIngress,isSupportEgress,isSupportIngressColor)
{
    for (var j = 0, n = uniqosTable.getDataRowLength(); j < n; j++) 
    {
        var direction = parseInt(uniqosTable.getCellStoreValue(j, "direction", "direction"));
		if(!isSupportIngressColor || direction == EGRESS)
		{
			cell = uniqosTable.getCell(j, "cos");
            uniqosTable.setCellIsEdit(cell, 0);
            uniqosTable.getCellShow(j, "cos").element.innerHTML = "-";
            
            cell = uniqosTable.getCell(j, "color");
            uniqosTable.setCellIsEdit(cell, 0);
            uniqosTable.getCellShow(j, "color").element.innerHTML = "-";
		}
        if (direction == EGRESS) // Egress
        {
			if (isSupportEgress) 
			{
				uniqosTable.getCell(j, "policy").element.ondblclick = function()
				{
					openUniPolicyDialog(VUNI_EGRESS_POLICY, direction);
				}
			}
			else
			{
				uniqosTable.setCellIsEdit(uniqosTable.getCell(j, "policy"),0);
			}
        }
        else
        {
			if (isSupportIngress) 
			{
				uniqosTable.getCell(j, "policy").element.ondblclick = function()
				{
					openUniPolicyDialog(VUNI_INGRESS_POLICY, direction);
				}
			}
			else
			{
				uniqosTable.setCellIsEdit(uniqosTable.getCell(j, "policy"),0);
			}
        }
		var bandwithlimit = uniqosTable.getCellStoreValue(j, "bandwidthlimit",
			"bandwidthlimit");
		var cell = uniqosTable.getCell(j, "cbs");
		uniqosTable.setCellIsEdit(cell, 0);
		uniqosTable.getCellShow(j, "cbs").element.innerHTML = "-";
		cell = uniqosTable.getCell(j, "pbs");
		uniqosTable.setCellIsEdit(cell, 0);
		uniqosTable.getCellShow(j, "pbs").element.innerHTML = "-";
		if (bandwithlimit != "1") {
			var cell = uniqosTable.getCell(j, "cir");
			uniqosTable.setCellIsEdit(cell, 0);
			uniqosTable.getCellShow(j, "cir").element.innerHTML = "-";
	
			cell = uniqosTable.getCell(j, "pir");
			uniqosTable.setCellIsEdit(cell, 0);
			uniqosTable.getCellShow(j, "pir").element.innerHTML = "-";
		}
		textCheckWithStepLen(uniqosTable.getCellEdit(j, "cir").element, 0, 1000000, 64);
	    textCheckWithStepLen(uniqosTable.getCellEdit(j, "pir").element, 0, 1000000, 64);
	    textCheck(uniqosTable.getCellEdit(j, "cbs").element, 0, 4294967295);
	    textCheck(uniqosTable.getCellEdit(j, "pbs").element, 0, 4294967295);
	    var bandwidthlimitCell = uniqosTable.getCellEdit(j, "bandwidthlimit");
	    bandwidthlimitCell.element.onchange = function ()
	    {
	    	 var selectIndex = uniqosTable.getSelectedRows()[0];
	    	 if(this.value ==1)
	    	 {
	    	 	 var cell = uniqosTable.getCell(selectIndex, "cir");
	    	 	uniqosTable.setCellIsEdit(cell, 1);
	    	 	uniqosTable.getCellShow(selectIndex, "cir").element.innerHTML = "64";
	    	 	uniqosTable.setCellValue(cell, "cir", 64);
	         
	             cell = uniqosTable.getCell(selectIndex, "cbs");
	             uniqosTable.setCellIsEdit(cell, 0);
	             uniqosTable.getCellShow(selectIndex, "cbs").element.innerHTML = "-";
	             
	             cell = uniqosTable.getCell(selectIndex, "pir");
	             uniqosTable.setCellIsEdit(cell, 1);
	             uniqosTable.getCellShow(selectIndex, "pir").element.innerHTML = "64";
	             uniqosTable.setCellValue(cell, "pir", 64);
	             
	             cell = uniqosTable.getCell(selectIndex, "pbs");
	             uniqosTable.setCellIsEdit(cell, 0);
	             uniqosTable.getCellShow(selectIndex, "pbs").element.innerHTML = "-";
	             
	    	 }
	    	 else
	    	 {
	    	 	 var cell = uniqosTable.getCell(selectIndex, "cir");
	    	 	uniqosTable.setCellIsEdit(cell, 0);
	    	 	uniqosTable.getCellShow(selectIndex, "cir").element.innerHTML = "-";
	         
	             cell = uniqosTable.getCell(selectIndex, "cbs");
	             uniqosTable.setCellIsEdit(cell, 0);
	             uniqosTable.getCellShow(selectIndex, "cbs").element.innerHTML = "-";
	             
	             cell = uniqosTable.getCell(selectIndex, "pir");
	             uniqosTable.setCellIsEdit(cell, 0);
	             uniqosTable.getCellShow(selectIndex, "pir").element.innerHTML = "-";
	             
	             cell = uniqosTable.getCell(selectIndex, "pbs");
	             uniqosTable.setCellIsEdit(cell, 0);
	             uniqosTable.getCellShow(selectIndex, "pbs").element.innerHTML = "-";
	    	 }
	    }
    }
}

function convertQosValue(value)
{
	if(typeof(value) == "undefined" || value == "-" || value == "/")
	{
		return 4294967295;
	}
	return value;
}
function openUniPolicyDialog(policyType, direction)
{
    var url = "../ethcommon/policyselect.html?policyType=" + policyType + "&direction=" + direction;
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 480, 300, "../../../../../images/");
}
