var st = null;
var srcPort = null;

var OPER_FAIL = 2;
var TIMEOUT = 1090650120;
var MlpppPort = 0x1000;
var SerialPort = 0x1800;
var VIRTUAL_PORT = 0x2800;
var INVALID_SUBSOLTID = "255";

var winobj = getParentWindow();
if (!isIE) 
{
    winobj = winobj.frames[1];
}
var nmUser = winobj.nmUser;
var neid = winobj.neid;

function init()
{
    initTable();
    initButton();	
    
	srcPort = winobj.ct.getAtom("srcport").getValue();
	if (srcPort == null || srcPort == "")
	{
		return;
	}
	
    doQuery();
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../../images/");
    st.setSingleChoiceFlg(true);
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
}

function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

/**
 * do the query
 */
function doQuery()
{
    var xml = createQueryRequest();
    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_ETHERROUTE_FROMNE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, processQueryResponse, null, "inputdata=" + xml);
}

/**
 * create query XML request
 */
function createQueryRequest()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    row.appendChild(createTagElement("neid", neid));
	row.appendChild(createTagElement("routeid", 0));
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 * callback function
 */
function processQueryResponse(doc)
{
    var dinterface = EncapsulateData(doc);
    var eCode = dinterface.getError().getGlobleECode();
    if (OPER_FAIL == eCode || TIMEOUT == eCode) 
    {        
        return;
    }
	
	var arr = srcPort.split("-");
    for (var i = dinterface.getDataRowLength() - 1; i >= 0; i--) 
    {
        var row = dinterface.rows[i];
		if (arr[0] != row["slotid"].value || arr[1] != row["port"].value)
		{
			dinterface.rows.removeAt(i);
			continue;
		}
        
        if (MlpppPort <= row["port"].value && SerialPort > row["port"].value) 
        {
            row["slotid"].value = "";
            row["boardname"].value = "";
        }
        
        if (VIRTUAL_PORT <= row["port"].value) 
        {
            row["slotid"].value = "";
            row["boardname"].value = "";
        }
        
        if (INVALID_SUBSOLTID == row["subslotid"].value) 
        {
            row["subslotid"].value = "";
        }
        row["nextip"].value = convertNumToIpaddr(row["nextip"].value);
        row["dip"].value = convertNumToIpaddr(row["dip"].value);
        row["dmass"].value = convertNumToIpaddr(row["dmass"].value);
    }
    
    st.clearTableData();
    createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
        
    
    if (!st.element.colsArray.selectedId) 
    {
        st.element.colsArray.selectedId = "routeid";
        st.element.colsArray.imgflag = 1;
    }
    var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element;
    st.sortRows(td, st.element.colsArray.imgflag);
}

function doEnter()
{
	var routeid = "";
	var nexthop = "";
	var dstip = "";
	var dstmask = "";
	
	if (st.getSelectedRowCount() > 0)
	{
		var index = st.getSelectedRows()[0];
		routeid = st.getCellStoreValue(index, "routeid", "routeid");
		nexthop = st.getCellStoreValue(index, "nextip", "nextip");
		dstip = st.getCellStoreValue(index, "dip", "dip");
		dstmask = st.getCellStoreValue(index, "dmass", "dmass");
	}
	
	winobj.$("routeid").value = routeid;
	winobj.ct.getAtom("nexthop").setValue(nexthop);
	winobj.ct.getAtom("dstipaddr").setValue(dstip);
	winobj.ct.getAtom("dstipmask").setValue(dstmask);
	xcloseDialog();
}
