var direction = [];
direction[0] = "unidirectional";
direction[1] = "bidirectional";

var st = null;

var win = getParentWindow();
if (!isIE) 
{
    win = win.frames[1];
}
var neid = win.neid;
var nmUser = win.nmUser;

var tunnelType = parseInt(getNeProperty(self).tunnelType);
var nodeType = parseInt(getNeProperty(self).nodeType);
loadXMLdoc("../../../../../../conf/system.xml", "GET", false, EncapsulateSConf);
if (tunnelType == TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL) 
{
    loadXMLdoc("../../../conf/ethservice/ethcommon/selecttunneltable_mpls_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
}
else 
{
    loadXMLdoc("../../../conf/ethservice/ethcommon/selecttunneltable_ipgre_" + SYSTEMCONF.getLanguage() + ".xml", "GET", false, EncapsulateTable, null);
}

function init()
{
    initTable();
    initButton();
    queryTunnelData();
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../../images/");
    st.setSingleChoiceFlg(true);
    createTableHead(st, window.tableconf[0]);
    $("tbdiv").appendChild(st.getTable());
    
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
}

function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("nodetype",nodeType));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function queryTunnelData()
{
    var xml = createQueryXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + tunnelType + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, initTunnelData, null, "inputdata=" + xml);
}

function initTunnelData(doc)
{
    var data = EncapsulateData(doc);
    
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        if(data.getDataRowParam(i, "nodetype")==3 && data.getDataRowParam(i, "direction")==1)
        {	
        	data.rows[i].snknode.value = data.getDataRowParam(i, "srcnode");
        }
    }
    createTableBody(st, window.tableconf[0], data, RESOURCE);
    addCellListener();  //      
}

function addCellListener()
{
    if (tunnelType == TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL) 
    {
        for (var i = 0, m = st.getDataRowLength(); i < m; i++) 
        {
            var bw = parseInt(st.getCellCurrentValue(i, "bandwidth", "bandwidth"));
            if (bw == 0) 
            {
                st.getCellShow(i, "bandwidth").element.innerHTML = RESOURCE["nolimit"];
                st.getCellShow(i, "bandwidthremain").element.innerHTML = RESOURCE["nolimit"];
            }
        }
    }
    
}

function doSelect()
{
    var tunnelIndex = "";
    var tunnel = "";
	var sinkNode = "0.0.0.0";
    if (st.getSelectedRowCount() == 1) 
    {
		var tunnelName = RESOURCE["null"];
        var index = st.getSelectedRows()[0];
        tunnelIndex = st.getCellCurrentValue(index, "tunnelindex", "tunnelindex");
		var tunnelId = st.getCellCurrentValue(index, "tunnelid", "tunnelid");
        if (tunnelType == TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL) 
        {
        	sinkNode = st.getCellShow(index, "snknode").element.innerHTML;
            tunnelName = st.getCellCurrentValue(index, "tunnelname", "name");
			if (null == tunnelName || "" == tunnelName)
			{
				tunnelName = RESOURCE["null"];
			}
        }
        else
        {
        	sinkNode = st.getCellShow(index, "snkip").element.innerHTML;
        }
		tunnel = tunnelId + "(" + tunnelName + ")";
    }
	if (win.$("tunnelindex")) 
	{
		win.$("tunnelindex").value = tunnelIndex;
		win.$("selectedtunnel").value = tunnel;
		if(win.ct.getAtom("oppsitelsrid"))
		{
			win.ct.getAtom("oppsitelsrid").setValue(sinkNode);
		}
		else
		{
			win.pwct.getAtom("oppsitelsrid").setValue(sinkNode);
		}
	}
	else if (win.$("tunnelindex0")) 
	{
		win.$("tunnelindex"+win.buttonIndex).value = tunnelIndex;
		win.$("selectedtunnel"+win.buttonIndex).value = tunnel;
		
		win.pwct.getAtom("oppsitelsrid",win.buttonIndex).setValue(sinkNode);
	}
	else
	{
		var index = win.nnipwst.getSelectedRows()[0];
		var cell = win.nnipwst.getCell(index, "tunnelindex");
		win.nnipwst.setCellValue(cell, "tunnelindex", tunnelIndex);
		
		cell = win.nnipwst.getCell(index, "tunnelid");
		win.nnipwst.setCellValue(cell, "tunnelid", tunnel);
		win.nnipwst.getCellShow(index, "tunnelid").element.innerHTML = tunnel;
		
		cell = win.nnipwst.getCell(index, "tunnelid");
		win.nnipwst.setCellValue(cell, "tunnelid", tunnel);
		win.nnipwst.getCellShow(index, "tunnelid").element.innerHTML = tunnel;
		
		cell = win.nnipwst.getCell(index, "oppositeLsrID");
		win.nnipwst.setCellValue(cell, "oppositeLsrID", convertIPStrToLong(sinkNode));
		win.nnipwst.getCellShow(index, "oppositeLsrID").element.innerHTML = sinkNode;		
	}

	win.$("applybtn").disabled = false;
	
    xcloseDialog();
}

function convertBandwidth(param)
{
    if (parseInt(param) == 0) 
    {
        return RESOURCE["nolimit"];
    }
    return param;
}

window.onresize = function()
{
    st.setBodyHeight(getTableHeight($("tbdiv"), st) + "px");
};
