var QINQ_POLICY = 6; //qinq policy
var INVALID_LABEL_VALUE_2 = 0xFFFFFFFF; //    label 
var qosQinqTable = null;
var CurrentColID = "";

function createParamElement(name, value)
{
    var elem = document.createElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function refreshQinQQosTable(tc,data)
{
	if(qosQinqTable != null)
	{
		refreshTableState(qosQinqTable,tc,data);
	}
}


function convertAttrID(value)
{
	return RESOURCE[value];
}

function initQoSTableData(tc,imgurl)
{
	qosQinqTable = new SortTable();
	qosQinqTable.setImage(imgurl);
	createTableHead(qosQinqTable, tc);
	qosQinqTable.setOnCellEditHandler(cellQosEditHandler);
	qosQinqTable.setBodyHeight("130px");
	$("qosqinqtable").appendChild(qosQinqTable.getTable());
	
	var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    var rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "bandwithlimittitle"));
    rowParams.appendChild(createParamElement("ingress", "0"));
    rowParams.appendChild(createParamElement("egress", "0"));
    bparams.appendChild(rowParams);
    rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "cirtitle"));
    rowParams.appendChild(createParamElement("ingress", "0"));
    rowParams.appendChild(createParamElement("egress", "0"));
    bparams.appendChild(rowParams);
    rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "cbstitle"));
    rowParams.appendChild(createParamElement("ingress", "0"));
    rowParams.appendChild(createParamElement("egress", "0"));
    bparams.appendChild(rowParams);
    rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "pirtitle"));
    rowParams.appendChild(createParamElement("ingress", "0"));
    rowParams.appendChild(createParamElement("egress", "0"));
    bparams.appendChild(rowParams);
    rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "pbstitle"));
    rowParams.appendChild(createParamElement("ingress", "0"));
    rowParams.appendChild(createParamElement("egress", "0"));
    bparams.appendChild(rowParams);
    rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "policytitle"));
    rowParams.appendChild(createParamElement("ingress", ""));
    rowParams.appendChild(createParamElement("egress", ""));
    bparams.appendChild(rowParams);
    di.appendChild(bparams);
    createTableBody(qosQinqTable, tc, EncapsulateData(di), RESOURCE);
    qosQinqTable.getCellShow(0,"ingress").setValue(RESOURCE["disabled"]);
    qosQinqTable.getCellShow(0,"egress").setValue(RESOURCE["disabled"]);
    qosQinqTable.getCell(0, "ingress").element.ondblclick = attrCellondbclick;
	qosQinqTable.getCell(0, "egress").element.ondblclick = attrCellondbclick;
    for(var i = 1;i <= 4;i++)
    {
    	qosQinqTable.setCellIsEdit(qosQinqTable.getCell(i,"ingress"),"0");
    	qosQinqTable.getCellShow(i,"ingress").setValue("-");
    	qosQinqTable.setCellIsEdit(qosQinqTable.getCell(i,"egress"),"0");
        qosQinqTable.getCellShow(i,"egress").setValue("-");
    }
    qosQinqTable.getCell(5, "ingress").element.ondblclick = openQinQDialog_QoS;
	qosQinqTable.getCell(5, "egress").element.ondblclick = openQinQDialog_QoS;
}



function attrCellondbclick()
{
    this.style.backgroundColor = "#d0f946";
    if(isIE)
    {
        this.onselectstart = null;
    }
    else
    {
        this.style.MozUserSelect = "text";
    }
    this.modify = true;  
    this.parentNode.modify = true; 
    this.showElement.element.style.display = "none"; 
    var colid = this.colid;
    var rowindex = this.parentNode.rowIndex
	if(rowindex == 0)
	{
		atom = qosQinqTable.createAtom("select");
		this.editElement.type = "select";
		atom.addOption(RESOURCE["disabled"],0);
		atom.addOption(RESOURCE["enabled"],1);
		atom.element.onblur= cellonblur;
	}
	else
	{
	    atom = qosQinqTable.createAtom("text");
	    this.editElement.type = "text";
	    atom.element.onblur= cellonblur;
	    if(rowindex <= 4)
	    {
	    	textCheck(atom.element, "64", "1000000");
	    }
	}
    if(this.storeValue[colid])
    {
    	atom.setValue(this.storeValue[colid]);
    }
	atom.element.onclick=stopEventPropagation;
    atom.element.onmousedown=atomOnMouseDownHandle;
    atom.element.ondblclick=stopEventPropagation;
    
    this.appendChild(atom.element);
    atom.element.focus();
}

function selectPolicyHandler(policy)
{
	var rowindex = qosQinqTable.getSelectedRows()[0];
	var cell = qosQinqTable.getCell(rowindex, CurrentColID);
	qosQinqTable.setCellValue(cell, CurrentColID, policy);
	qosQinqTable.getCellShow(rowindex, CurrentColID).element.innerHTML = policy;
	qosQinqTable.setCellModify(rowindex, CurrentColID, true);
	handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
}
function openQinQDialog_QoS()
{
	CurrentColID = this.colid;
    var policyType = QINQ_POLICY;
    if (qosQinqTable.getSelectedRowCount() > 1) 
    {
        return;
    }
    
    var url = "../ethcommon/policyselect.html?policyType=" + policyType;
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 480, 300, "../../../../../images/");
}


function appendQosParam(business,linkid)
{
	if(qosQinqTable == null)
	{
		return;
	}
	var iBandLimit = qosQinqTable.getCellStoreValue(0,"ingress","ingress");
	var eBandLimit = qosQinqTable.getCellStoreValue(0,"egress","egress");
	if(iBandLimit == 1)
	{
		var secondlevel = new tagElement("row-params");
		secondlevel.appendChild(new tagElement("param","autolinkid","0"));
		secondlevel.appendChild(new tagElement("param","linkid",linkid));
		secondlevel.appendChild(new tagElement("param","createdirection","1"));
		secondlevel.appendChild(new tagElement("param","createcir",convertQosValue(qosQinqTable.getCellStoreValue(1,"ingress","ingress"))));
		secondlevel.appendChild(new tagElement("param","createcbs",convertQosValue(qosQinqTable.getCellStoreValue(2,"ingress","ingress"))));
		secondlevel.appendChild(new tagElement("param","createpir",convertQosValue(qosQinqTable.getCellStoreValue(3,"ingress","ingress"))));
		secondlevel.appendChild(new tagElement("param","createpbs",convertQosValue(qosQinqTable.getCellStoreValue(4,"ingress","ingress"))));
		business.appendChild(secondlevel);
	}
	if(eBandLimit == 1)
	{
		var secondlevel = new tagElement("row-params");
		secondlevel.appendChild(new tagElement("param","autolinkid","0"));
		secondlevel.appendChild(new tagElement("param","linkid",linkid));
		secondlevel.appendChild(new tagElement("param","createdirection","2"));
		secondlevel.appendChild(new tagElement("param","createcir",convertQosValue(qosQinqTable.getCellStoreValue(1,"egress","egress"))));
		secondlevel.appendChild(new tagElement("param","createcbs",convertQosValue(qosQinqTable.getCellStoreValue(2,"egress","egress"))));
		secondlevel.appendChild(new tagElement("param","createpir",convertQosValue(qosQinqTable.getCellStoreValue(3,"egress","egress"))));
		secondlevel.appendChild(new tagElement("param","createpbs",convertQosValue(qosQinqTable.getCellStoreValue(4,"egress","egress"))));
		business.appendChild(secondlevel);
	}
	var iPolicy = qosQinqTable.getCellStoreValue(5,"ingress","ingress");
	if(typeof(iPolicy) != "undefined" && iPolicy != "")
	{
		var secondlevel = new tagElement("row-params");
		secondlevel.appendChild(new tagElement("param","autolinkid","0"));
		secondlevel.appendChild(new tagElement("param","linkid",linkid));
		secondlevel.appendChild(new tagElement("param","direction","1"));
		secondlevel.appendChild(new tagElement("param","autopolicyid","0"));
		secondlevel.appendChild(new tagElement("param","policyid",getPolicyID(iPolicy)));
		business.appendChild(secondlevel);
	}
	var ePolicy = qosQinqTable.getCellStoreValue(5,"egress","egress");
	if(typeof(ePolicy) != "undefined" && ePolicy != "")
	{
		var secondlevel = new tagElement("row-params");
		secondlevel.appendChild(new tagElement("param","autolinkid","0"));
		secondlevel.appendChild(new tagElement("param","linkid",linkid));
		secondlevel.appendChild(new tagElement("param","direction","2"));
		secondlevel.appendChild(new tagElement("param","autopolicyid","0"));
		secondlevel.appendChild(new tagElement("param","policyid",getPolicyID(ePolicy)));
		business.appendChild(secondlevel);
	}
}

function getPolicyID(policy)
{
    if (typeof(policy) == "undefined" || policy == "") 
    {
        policy = INVALID_LABEL_VALUE_2;
    }
    else 
    {
        policy = policy.substring(0, policy.indexOf("("));
    }
    return policy
}

/**
 *     Qos         -/         
 *              F
 * @param value
 * @return
 */
function convertQosValue(value)
{
	if(value == "-" || value == "/")
	{
		return 4294967295;
	}
	return value;
}


function cellQosEditHandler(param)
{
	var colid = param.colid;
	var rowindex = param.rowindex;
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		if(rowindex == 0)
		{
			var bandlimit = qosQinqTable.getCellStoreValue(rowindex,colid,colid);
			if(bandlimit == "1")
			{
				qosQinqTable.setCellIsEdit(qosQinqTable.getCell(1,colid),"1");
				qosQinqTable.getCell(1, colid).element.ondblclick = attrCellondbclick;
				qosQinqTable.setCellValue(qosQinqTable.getCell(1, colid), colid, 64);
				qosQinqTable.getCellShow(1, colid).element.innerHTML = 64;
				qosQinqTable.setCellIsEdit(qosQinqTable.getCell(3,colid),"1");
				qosQinqTable.getCell(3, colid).element.ondblclick = attrCellondbclick;
				qosQinqTable.setCellValue(qosQinqTable.getCell(3, colid), colid, 64);
				qosQinqTable.getCellShow(3, colid).element.innerHTML = 64;
			}
			else
			{
				qosQinqTable.setCellIsEdit(qosQinqTable.getCell(1,colid),"0");
				qosQinqTable.setCellValue(qosQinqTable.getCell(1, colid), colid, "-");
				qosQinqTable.getCellShow(1, colid).element.innerHTML = "-";
				qosQinqTable.setCellIsEdit(qosQinqTable.getCell(3,colid),"0");
				qosQinqTable.setCellValue(qosQinqTable.getCell(3, colid), colid, "-");
				qosQinqTable.getCellShow(3, colid).element.innerHTML = "-";
			}
		}
	}
}
