var st1 = null;
var st2 = null;
var tab = null;

var policy = [];
policy[1] = "SP";
policy[2] = "WRR";

var win = getDialogParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;

var winobj = getNeProperty(self);
var policyType = winobj.policyType;
var policyId = winobj.policyId;

window.onload = function()
{
    initTable();
    initTabs();
    
    $("okbtn").value = RESOURCE["okbutton"];

    doQueryPolicy();
    
    
}

function initTable()
{
	var totalHeight = getComponetHeight($("tableContainer"), 100);
    st1 = new SortTable();
    st1.setImage("../../../../../../images/");
    createTableHead(st1, window.tableconf[0]);
    $("policytable").appendChild(st1.getTable());
    st1.setBodyHeight(totalHeight * 0.3 + "px");
    
    st2 = new SortTable();
    st2.setImage("../../../../../../images/");
    createTableHead(st2, window.tableconf[1]);
    $("colortable").appendChild(st2.getTable());
    st2.setBodyHeight(totalHeight * 0.7 + "px");
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tabdiv", RESOURCE["cosconfig"], $("tabdiv"));
    
    setSelectedEmbedTab("tabdiv");
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function createQueryXml()
{
    var opDesc = "";
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", policyType);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "queueType");
    param.setAttribute("value", 0);
    row.appendChild(param);
	
	param = new tagElement("param","wredType","2");
	row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "isLogFlag");
    param.setAttribute("value", 0);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}
function doQuery()
{
    st1.clearTableData();

    var xml = createQueryXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_PORT_POLICY_QUEUE_QOSINFO + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

function queryCallBack(doc)
{
    var data = EncapsulateData(doc);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        createTableBody(st2, window.tableconf[1], data, RESOURCE);
    }

	for (var j = 0, n = st2.getDataRowLength(); j < n; j++)
	{
		var bandwidthLimit = st2.getCellStoreValue(j, "bwEnable", "bwEnable");
		
		if (typeof(bandwidthLimit) != "undefined" && "1" != bandwidthLimit)
		{
			st2.getCellShow(j, "cir", "cir").element.innerHTML = "-";
			st2.getCellShow(j, "pir", "pir").element.innerHTML = "-";
			st2.getCellShow(j, "cbs", "cbs").element.innerHTML = "-";
			st2.getCellShow(j, "pbs", "pbs").element.innerHTML = "-";
		}
	}
}

function doQueryPolicy()
{
    var xmldata = createQueryPolicyXml();
    var sfid = TECMDCODE_GET_VUNI_INGRESS_POLICY;
    if(policyType == VUNI_EGRESS_POLICY)
    {
    	sfid = TECMDCODE_GET_VUNI_EGRESS_POLICY;
    }
    else if(policyType == PW_POLICY)
    {
    	sfid = TECMDCODE_GET_PW_POLICY;
    }
    else if(policyType == QINQ_POLICY)
    {
    	sfid = TECMDCODE_GET_QINQ_POLICY;
    }
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + sfid + "&flag=1&nmUser=" + nmUser;
    loadXMLdoc(urlstr, "POST", false, callbackQueryPolicy, null, "inputdata=" + xmldata);
}

function createQueryPolicyXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", policyType);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", policyId);
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQueryPolicy(doc)
{
	doQuery();
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() < 2) 
    {
        st1.clearTableData();
        createTableBody(st1, window.tableconf[0], data, RESOURCE);
    }
}

