var win = getDialogParentWindow(); 

var winurlobj = getNeProperty(self);
var neid = win["neid"];
var nmUser = win["nmUser"];
var outtime = 0;               
var defaultMac = "00-00-00-00-00-00";
var st;
var parst = win.st;

if(parst == null)
{
	parst = win.mepTable;
}

/**
 * DTS2011121000455 
 *   URL  isEaggrOpen      1          MEP     
 */
if (winurlobj && winurlobj.isEaggrOpen != null && winurlobj.isEaggrOpen != undefined && winurlobj.isEaggrOpen == "1")
{
	parst = win.mepTable;
}

var START_LBTEST = "1";
var REFRESH_LBSTATUS = "2";
var STOP_LBTEST = "3";
var intervalID = null;
var btnRightArr = new Object();

function initPage()
{
	initButtonInfo();
	initData();
}

function initButtonInfo()
{
	$("startlbbtn").value = RESOURCE["startlbtestbtn"];
	$("cancelbtn").value = RESOURCE["cancelbtn"];
	$("stoplbbtn").value = RESOURCE["stoplbtestbtn"];
	btnRightArr.startlbbtn = new BtnRightObj("querybtn",TECMDCODE_IPPTN_ETH_OAM_START_LBTEST);
	btnRightArr.stoplbbtn = new BtnRightObj("querybtn",TECMDCODE_IPPTN_ETH_OAM_STOP_LBTEST);
}

function initData()
{
   var selectRows = parst.getSelectedRows();
   var mdName = parst.getCellStoreValue(selectRows[0],"mdname","mdname");
   var maName = parst.getCellStoreValue(selectRows[0],"maname","maname");
   var srcMepId = parst.getCellStoreValue(selectRows[0], "mepid", "mepid");
   document.getElementById("mdname").value = mdName;
   document.getElementById("maname").value = maName;
   document.getElementById("srcpoint").value = srcMepId;//MEPID:1  Defualt   MAC:2 
   document.getElementById("sinkpoint").value = defaultMac;
   document.getElementById("tdpgnum").value = "3"; //1~255 Default 3
   document.getElementById("tspglen").value = "64";//64~0xffff  Default 64
   document.getElementById("tspgpre").value = "7";//0~7 Default 7
   
   validateNum($('srcpoint'), 1, 8191, 4);
   validateMac($('sinkpoint'));
	/**
	 * OP201203210003:       RTN900  LB OAM   Transmiited packet count   
	 *               
	 */
   validateNum($('tdpgnum'), 1, 65535, 5);
   validateNum($('tspglen'), 64, 578, 3);
   validateNum($('tspgpre'), 0, 7, 1);
}

function createStartLBTestXML()
{
	var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel = new tagElement("row-params");	
	var	thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "configKey");
	thirdlevel.setAttribute("value", START_LBTEST);
	secondlevel.appendChild(thirdlevel);

    thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "mdid");
	thirdlevel.setAttribute("value", parst.getCellStoreValue(parst.getSelectedRows()[0], 'mdid', 'mdid'));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "maid");
	thirdlevel.setAttribute("value", parst.getCellStoreValue(parst.getSelectedRows()[0], 'maid', 'maid'));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "mepid");
	thirdlevel.setAttribute("value", $("srcpoint").value);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "sinkmtype");
	thirdlevel.setAttribute("value", LBTEST_TYPE);//MAC/MPID
	secondlevel.appendChild(thirdlevel);
	
	var snkmp = $("sinkpoint").value;
	var snkmpArr = snkmp.split("-");
	var snkmpStr = snkmpArr[0];
	if(snkmpArr.length >=5)
	{
		snkmpStr = snkmpArr[0] + snkmpArr[1] + snkmpArr[2] + snkmpArr[3] + snkmpArr[4] + snkmpArr[5];
	}
	else
	{
		var snkmpStrTmp = "0000" + tenToHex(snkmp);
		snkmpStr = snkmpStrTmp.substr(snkmpStrTmp.length - 4,4) + "FFFFFFFF";
	}
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "addrr");
	thirdlevel.setAttribute("value", snkmpStr);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "framenum");
	thirdlevel.setAttribute("value", $('tdpgnum').value);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "framelen");
	thirdlevel.setAttribute("value", $('tspglen').value);
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "framepri");
	thirdlevel.setAttribute("value", $('tspgpre').value);
	secondlevel.appendChild(thirdlevel);		
		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function startLBTest()
{
	if(LBTEST_TYPE == "2" && !checkUniCastMAC($("sinkpoint").value))
	{
		$("sinkpoint").value = '00-00-00-00-00-00';
		return;
	}
	
	$("startlbbtn").disabled = true;	
	$("stoplbbtn").disabled = !btnRightArr.stoplbbtn.right;
	
	var xml = createStartLBTestXML();
	var url = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IPPTN_ETH_OAM_START_LBTEST+"&nmUser=" + nmUser;
	loadXMLdoc(url, "POST", true, callBackHandler, null, "inputdata=" + xml);
}

function callBackHandler(doc)
{
	var data = EncapsulateData(doc);
    showErrorDialog(data);

    if (0 == data.getSErrorCode())
    {
        intervalID = setInterval(refreshResult, 3000);
    }
    else
    {
    	$("startlbbtn").disabled = !btnRightArr.stoplbbtn.right;
    	$("stoplbbtn").disabled = true;
    }
    
}

function refreshResult()
{	
    var xml = createRereshXML();
    var url = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IPPTN_ETH_OAM_LB_NOTIFY+"&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, refreshBackHandler, null, "inputdata=" + xml);
}

function createRereshXML()
{
    var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel = new tagElement("row-params");	
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);

    thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "configKey");
	thirdlevel.setAttribute("value", REFRESH_LBSTATUS);
	secondlevel.appendChild(thirdlevel);	
		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function refreshBackHandler(doc)
{
 var data = EncapsulateData(doc);
    showErrorDialog(data);

    if (0 == data.getSErrorCode())
    {
        if(data.getDataRowParam(0, 'endFlg') == '1')
        {
            clearInterval(intervalID);
            
            $("startlbbtn").disabled = !btnRightArr.startlbbtn.right;	
	        $("stoplbbtn").disabled = true;
        }
        $('testresult').value = data.getDataRowParam(0, 'content');
    }
}

function stopLBTest()
{
	$("stoplbbtn").disabled = true;
	var xml = createLBStopTestXML();
    var url = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IPPTN_ETH_OAM_STOP_LBTEST+"&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", true, callStopHandler, null, "inputdata=" + xml);
}

function createLBStopTestXML()
{
    var root = new inputxml("datainterface");
	var firstlevel = new tagElement("bussiness-params");
	
	var secondlevel = new tagElement("row-params");	
	var thirdlevel = new tagElement("param");
	thirdlevel.setAttribute("name", "neid");
	thirdlevel.setAttribute("value", neid);
	secondlevel.appendChild(thirdlevel);

        thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "configKey");
	thirdlevel.setAttribute("value", STOP_LBTEST);
	secondlevel.appendChild(thirdlevel);

	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "mdid");
	thirdlevel.setAttribute("value",parst.getCellStoreValue(parst.getSelectedRows()[0], 'mdid', 'mdid'));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "maid");
	thirdlevel.setAttribute("value", parst.getCellStoreValue(parst.getSelectedRows()[0], 'maid', 'maid'));
	secondlevel.appendChild(thirdlevel);
	
	thirdlevel = new tagElement("param");	
	thirdlevel.setAttribute("name", "mepid");
	thirdlevel.setAttribute("value", parst.getCellStoreValue(parst.getSelectedRows()[0], 'mepid', 'mepid'));
	secondlevel.appendChild(thirdlevel);
		
	firstlevel.appendChild(secondlevel);
	root.getRoot().appendChild(firstlevel);
	return root.toString();
}

function showErrorDialog(data)
{
	var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}


function callStopHandler(doc)
{
    var data = EncapsulateData(doc);
    if (0 == data.getSErrorCode())
    {
    	if(intervalID)
    	{
    		clearInterval(intervalID);
    	}
    	$("startlbbtn").disabled = !btnRightArr.startlbbtn.right;
    	$("stoplbbtn").disabled = true;
    }
    else
    {
    	$("stoplbbtn").disabled = false;
    }
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}


/**
 * Check The MAC Address
 */
function checkUniCastMAC(macStr)
{
	var mac = macStr.toUpperCase().split("-");
	firstMac = parseInt(mac[0],16);
	if (firstMac%2 == 1)
	{
		alert(RESOURCE["unicasterralert"]);
		return false;
	}	
	return true;	
}

var LBTEST_TYPE = "2";

function switchSelect(evt)
{
	var ev = evt?evt:window.event;
	var el = ev.target || ev.srcElement;
	LBTEST_TYPE = el.value;
	$("sinkpoint").onkeypress = null;
	$("sinkpoint").onblur = null;
	$("sinkpoint").onkeyup = null;
	if(el.value == "2")
	{
		$("mpmactitlespan").innerText = RESOURCE["snkMPMACTitle"];
		$('sinkpoint').value = "00-00-00-00-00-00";
		
		validateMac($('sinkpoint'));
	}
	else
	{
		$("mpmactitlespan").innerText = RESOURCE["snkmpid"];
		$('sinkpoint').value = "1";
		validateNum($('sinkpoint'), 1, 8191, 4);
	}
}
