var ct = null;
var st = null;
var portRes = null;

var INVALID_SLOT = 0xFFFF;
var NODE_TYPE_INGRESS = 1; //Ingress    
var NODE_TYPE_TRANSIT = 2; //Transit    
var NODE_TYPE_EGRESS = 3; //Egress    
var win = getParentWindow();
if (!isIE) 
{
    win = win.frames[1];
}
var neid = win.neid;
var nmUser = win.nmUser;


function initText()
{
    $("portattr").innerHTML = RESOURCE["portattr"];
    
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function fillPortAttr(option)
{
    var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    var rowParams = document.createElement("row-params");
    
    var arr = option.value.split("-");
    var slotId = arr[0];
    var portId = arr[1];
    var portObj = null;
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        if (portObj.slotId == slotId && portObj.portId == portId) 
        {
            break;
        }
    }
    
    rowParams.appendChild(createParamElement("slotid", slotId));
    rowParams.appendChild(createParamElement("portid", portId));
    rowParams.appendChild(createParamElement("port", option.text));
    rowParams.appendChild(createParamElement("ATTR_ETHOVERPTN_MAC_ENABLE", portObj.portEnable));
	rowParams.appendChild(createParamElement("PTNIF_PORT_ATTR_MODE", portObj.portMode));
    rowParams.appendChild(createParamElement("ATTR_ETHOVERPTN_MAC_ENCAP_TYPE", portObj.encapType));
    rowParams.appendChild(createParamElement("ATTR_ETHOVERPTN_MAC_WORKMODE", portObj.workMode));
    rowParams.appendChild(createParamElement("ATTR_ETHOVERPTN_MAC_TAG", portObj.tag));
    rowParams.appendChild(createParamElement("ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE", portObj.mplsEn));
    rowParams.appendChild(createParamElement("ATTR_ETHOVERPTN_MAC_IPADDRESS", portObj.ip));
    rowParams.appendChild(createParamElement("ATTR_ETHOVERPTN_MAC_IPMARSK", portObj.mask));
    
    bparams.appendChild(rowParams);
    di.appendChild(bparams);
    
    st.clearTableData();
    createTableBody(st, window.tableconf[0], EncapsulateData(di), RESOURCE);
    
    var v = parseInt(st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_ENABLE", "ATTR_ETHOVERPTN_MAC_ENABLE"));
    if (v == -1) 
    {
        st.getCellShow(0, "ATTR_ETHOVERPTN_MAC_ENABLE").element.innerHTML = "-";
        st.setCellIsEdit(st.getCell(0, "ATTR_ETHOVERPTN_MAC_ENABLE"), 0);
    }
	v = parseInt(st.getCellStoreValue(0, "PTNIF_PORT_ATTR_MODE", "PTNIF_PORT_ATTR_MODE"));
    if (v == -1) 
    {
        st.getCellShow(0, "PTNIF_PORT_ATTR_MODE").element.innerHTML = "-";
    }
	else if (v == 3)
	{
		st.setCellIsEdit(st.getCell(0, "PTNIF_PORT_ATTR_MODE"), 0);
	}
	else
	{
	    st.getCellShow(0, "PTNIF_PORT_ATTR_MODE").element.innerHTML = RESOURCE["level3"];
	    st.setCellValue(st.getCell(0,"PTNIF_PORT_ATTR_MODE"), "PTNIF_PORT_ATTR_MODE", 3);
	    st.setCellModify(0, "PTNIF_PORT_ATTR_MODE", true);
	    st.getCell(0,"PTNIF_PORT_ATTR_MODE").element.style.backgroundColor="#d0f946";
	}
    
    v = parseInt(st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE", "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE"));
    if (v == -1) 
    {
        st.getCellShow(0, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE").element.innerHTML = "-";
    }
	else if (v == 1)
	{
		st.setCellIsEdit(st.getCell(0, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE"), 0);
	}
    
    v = parseInt(st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE", "ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE"));
    if (v == 1)
	{
		st.setCellIsEdit(st.getCell(0, "ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE"), 0);
	}
	else
	{
	    st.getCellShow(0, "ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE").element.innerHTML = RESOURCE["enable"];
	    st.setCellValue(st.getCell(0,"ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE"), "ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE", 1);
	    st.setCellModify(0, "ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE", true);
	    st.getCell(0,"ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE").element.style.backgroundColor="#d0f946";
	}
    
    v = parseInt(st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_WORKMODE", "ATTR_ETHOVERPTN_MAC_WORKMODE"));
    if (v == -1) 
    {
        st.getCellShow(0, "ATTR_ETHOVERPTN_MAC_WORKMODE").element.innerHTML = "-";
        st.setCellIsEdit(st.getCell(0, "ATTR_ETHOVERPTN_MAC_WORKMODE"), 0);
    }
    
    v = parseInt(st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_TAG", "ATTR_ETHOVERPTN_MAC_TAG"));
    if (v == -1) 
    {
        st.getCellShow(0, "ATTR_ETHOVERPTN_MAC_TAG").element.innerHTML = "-";
        st.setCellIsEdit(st.getCell(0, "ATTR_ETHOVERPTN_MAC_TAG"), 0);
    }
    
    v = st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_IPADDRESS", "ATTR_ETHOVERPTN_MAC_IPADDRESS");
    if (v == "255.255.255.255") 
    {
        st.getCellShow(0, "ATTR_ETHOVERPTN_MAC_IPADDRESS").element.innerHTML = "";
        st.setCellValue(st.getCell(0, "ATTR_ETHOVERPTN_MAC_IPADDRESS"), "ATTR_ETHOVERPTN_MAC_IPADDRESS", "");
    }
    validateIp(st.getCellEdit(0, "ATTR_ETHOVERPTN_MAC_IPADDRESS").element, true);
    
    v = st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_IPMARSK", "ATTR_ETHOVERPTN_MAC_IPMARSK");
    if (v == "255.255.255.255") 
    {
        st.getCellShow(0, "ATTR_ETHOVERPTN_MAC_IPMARSK").element.innerHTML = "";
        st.setCellValue(st.getCell(0, "ATTR_ETHOVERPTN_MAC_IPMARSK"), "ATTR_ETHOVERPTN_MAC_IPMARSK", "");
    }
    validateIp(st.getCellEdit(0, "ATTR_ETHOVERPTN_MAC_IPMARSK").element, true);
}

function initPortAttrTable()
{
    st = new SortTable();
    st.setImage("../../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    $("portattrtb").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("portattrtb"), 300) + "px");
    $("portattrtb").oncontextmenu = popupMenuHandler;
    
    st.clearTableData();
}

function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
	rowparams.appendChild(createTagElement("isfilter", 0));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function getPortRes()
{
    var xml = createQueryXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_GET_AVAILABLEPORT + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, portResCallBack, null, "inputdata=" + xml);
}

function portResCallBack(doc)
{
    portRes = new Array();
    
    var portObj = null;
    var data = EncapsulateData(doc);
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        portObj = new Object();
        portObj.slotId = data.getDataRowParam(i, "slotid");
        portObj.boardName = data.getDataRowParam(i, "boardname");
        portObj.portId = data.getDataRowParam(i, "portid");
        portObj.portName = data.getDataRowParam(i, "portname");
		portObj.portMode = data.getDataRowParam(i, "portmode");
		portObj.mplsEn = data.getDataRowParam(i, "mplsen");
        portObj.portEnable = data.getDataRowParam(i, "portenable");
        portObj.encapType = data.getDataRowParam(i, "encaptype");
        portObj.workMode = data.getDataRowParam(i, "workmode");
        portObj.tag = data.getDataRowParam(i, "tag");
        portObj.ip = data.getDataRowParam(i, "ip");
        portObj.mask = data.getDataRowParam(i, "mask");
        
        portRes[portRes.length] = portObj;
    }
}

function createSetPortAttrXML()
{
    if (st.getModify(0)) 
    {
        var di = new inputxml("datainterface");
        var bussiness = new tagElement("bussiness-params");
        
        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("slotid", st.getCellStoreValue(0, "slotid", "slotid")));
        rowparams.appendChild(createTagElement("port", st.getCellStoreValue(0, "portid", "portid")));
        if (st.getCellModify(0, "ATTR_ETHOVERPTN_MAC_ENABLE")) 
        {
            rowparams.appendChild(createTagElement("ATTR_ETHOVERPTN_MAC_ENABLE", st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_ENABLE", "ATTR_ETHOVERPTN_MAC_ENABLE")));
        }
        
		if (st.getCellModify(0, "PTNIF_PORT_ATTR_MODE")) 
        {
            rowparams.appendChild(createTagElement("SDHPORT_ATTR_MODE", st.getCellStoreValue(0, "PTNIF_PORT_ATTR_MODE", "PTNIF_PORT_ATTR_MODE")));
        }
        
		if (st.getCellModify(0, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE")) 
        {
            rowparams.appendChild(createTagElement("ATTR_ETHOVERPTN_MAC_ENCAP_TYPE", st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE", "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE")));
        }
        
		if (st.getCellModify(0, "ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE")) 
        {
            rowparams.appendChild(createTagElement("ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE", st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE", "ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE")));
        }
		
        if (st.getCellModify(0, "ATTR_ETHOVERPTN_MAC_WORKMODE")) 
        {
            rowparams.appendChild(createTagElement("ATTR_ETHOVERPTN_MAC_WORKMODE", st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_WORKMODE", "ATTR_ETHOVERPTN_MAC_WORKMODE")));
        }
        
        if (st.getCellModify(0, "ATTR_ETHOVERPTN_MAC_TAG")) 
        {
            rowparams.appendChild(createTagElement("ATTR_ETHOVERPTN_MAC_TAG", st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_TAG", "ATTR_ETHOVERPTN_MAC_TAG")));
        }
        
        if (st.getCellModify(0, "ATTR_ETHOVERPTN_MAC_IPADDRESS") || st.getCellModify(0, "ATTR_ETHOVERPTN_MAC_IPMARSK")) 
        {
            rowparams.appendChild(createTagElement("ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS", 1));
            rowparams.appendChild(createTagElement("ATTR_ETHOVERPTN_MAC_IPADDRESS", parseInt("0x" + convertIpaddrToHexcode(st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_IPADDRESS", "ATTR_ETHOVERPTN_MAC_IPADDRESS")))));
            rowparams.appendChild(createTagElement("ATTR_ETHOVERPTN_MAC_IPMARSK", parseInt("0x" + convertIpaddrToHexcode(st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_IPMARSK", "ATTR_ETHOVERPTN_MAC_IPMARSK")))));
            rowparams.appendChild(createTagElement("ATTR_ETHOVERPTN_MAC_BORROWEDBOARDIPADDR", 0xFFFF));
            rowparams.appendChild(createTagElement("ATTR_ETHOVERPTN_MAC_BORROWEDPORTIPADDR", 0xFFFF));
        }
        
        bussiness.appendChild(rowparams);
        di.getRoot().appendChild(bussiness);
        return di.toString();
    }
    
    return null;
}

function validatePortAttr()
{
	var msgArr = [];
	var portMode = st.getCellStoreValue(0, "PTNIF_PORT_ATTR_MODE", "PTNIF_PORT_ATTR_MODE");
	if (portMode != "3")
	{
		msgArr[msgArr.length] = RESOURCE["portmode"];
	}
	var encapType = st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE", "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE");
	if (encapType != "1")
	{
		msgArr[msgArr.length] = RESOURCE["encaptype"];
	}
	var tunnelEn = st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE", "ATTR_ETHOVERPTN_MAC_TUNNEL_ENABLE");
	if (tunnelEn != "1")
	{
		msgArr[msgArr.length] = RESOURCE["tunnelen"];
	}
	var ip = st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_IPADDRESS", "ATTR_ETHOVERPTN_MAC_IPADDRESS");
	if (ip == null || ip == "")
	{
		msgArr[msgArr.length] = RESOURCE["ipaddr"];
	}
    var mask = st.getCellStoreValue(0, "ATTR_ETHOVERPTN_MAC_IPMARSK", "ATTR_ETHOVERPTN_MAC_IPMARSK");
    if (mask == null || mask == "") 
    {
        msgArr[msgArr.length] = RESOURCE["ipmask"];
    }
	if (msgArr.length > 0)
	{
		var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
	}
	return true;
}

/*
 *              Tunnel
 */
function doCreate()
{
    if (!validate()) 
    {
        return;
    }
    
    var xml = createSetPortAttrXML();
    if (null != xml) 
    {
        var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_PTNETHPORTATTRIB + "&nmUser=" + nmUser;
        loadXMLdoc(url, "POST", false, setPortAttrCallBack, null, "inputdata=" + xml);
    }
    else 
    {
        doCreateTunnel();
    }
}

function setPortAttrCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    refreshTableState(st, window.tableconf[0], data);
    
    if (data.getSErrorCode() == 0) 
    {
        doCreateTunnel();
    }
}
