document.title = RESOURCE["createMA"];
var MIN_MAID = 1;
var MAX_MAID = 4294967040;
var parentWin = getParentWindow(); 
if(!isIE)
{
    parentWin = parentWin.frames[parentWin.frames.length - 2];
}

var tagType_TagTrans = '0';

var tagtype = parentWin.parwin.parobj.st.getCellStoreValue(0, 'tagtype', 'tagtype');

var  resources = [];
function initPage()
{
	ct = new CTable();
	ct.addHead(RESOURCE["PROPERTY"],RESOURCE["VALUE"]);
	
	var atom = new Atom("select");
	atom.element.style.width="100%";
	atom.element.onchange = refreshSelects;
	ct.addAttrRow("node",RESOURCE["node"], atom);
	
	var atom = new Atom("select");
	atom.element.style.width="100%";
	ct.addAttrRow("vlan",RESOURCE["vlan"], atom);
		
    atom = new Atom("text");
	atom.element.style.width="100%";
	ct.addAttrRow("mepID", RESOURCE["mepID"], atom);
	validateNum(atom.element, 1, 8191, 4);
	
	var atom = new Atom("select");
	atom.element.style.width="100%";	
	ct.addAttrRow("direct",RESOURCE["direct"], atom);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["ingress"], 1);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["egress"], 2);
	
        var atom = new Atom("select");
	atom.element.style.width="100%";	
	ct.addAttrRow("ccStatus",RESOURCE["ccStatus"], atom);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["active"], 1);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE["inactive"], 0);
	
	
	
	/**atom = new Atom("select");
	atom.element.style.width = "100%";	
	ct.addAttrRow("aisperiod", RESOURCE["AIS_PERIOD"], atom);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE['second'], 1);
	atom.element.options[atom.element.options.length] = new Option(RESOURCE['minute'], 2);**/
	
	$("tablecomponent").appendChild(ct.getTable());
	
	$("okbutton").value = RESOURCE["okbutton"];          
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	
	queryResource();
}

function queryResource()
{
	if(isDemo)
	{
		loadXMLdoc("querymepport.xml", "POST", false, handleBackQuery, null);
	}
	else
	{
		var xmlstr = createQueryResourceXML();    
        var urlreq ="../../../../../../neExlorerServlet?sfid="+TECMDCODE_IPPTN_ETH_OAM_GET_LOGIC_PORT+""+"&nmUser="+parentWin.obj["nmUser"];     
        loadXMLdoc(urlreq, "POST",false,handleBackQuery,null,"inputdata="+xmlstr);
	}
}

function createQueryResourceXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",parentWin.neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","serviceIndex");
    param.setAttribute("value",parentWin.serviceIndex);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","ethType");
    param.setAttribute("value",parentWin.serviceType);
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name","vuniID");
    param.setAttribute("value","0");
    row.appendChild(param); 
    
    param = new tagElement("param");
    param.setAttribute("name","vnniID");
    param.setAttribute("value","0");
    row.appendChild(param); 
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
	return di.toString();
}


function handleBackQuery(doc)
{
	var data = EncapsulateData(doc);
	for(var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		 var resource = new Object();
		 resource.slotid = data.getDataRowParam(i, "slotid");
		 resource.board = data.getDataRowParam(i, "slotid") + '-' + data.getDataRowParam(i, "boardname");
		 
		 var portResource = new Object();
		 resource.port = portResource;
		 portResource.port = data.getDataRowParam(i, "portid");
		 portResource.logicinftype = data.getDataRowParam(i, "logicinftype");
		 portResource.vid = data.getDataRowParam(i, "vuniid");
		 portResource.portname = data.getDataRowParam(i, "port");
	     portResource.vResource = data.getDataRowParam(i, "vlan").split(',');
	     resources.push(resource);
	}
	initNodeSelect();
}

function initNodeSelect()
{
	var nodeAtom = ct.attrArray['node'];
	nodeAtom.clearOptions();
	var tmpPorts = [];
	for(var i = 0; i < resources.length; i++)
	{
		var portResource = resources[i].port;
		var slotport = resources[i].slotid + "-" + portResource.port;
		if (!tmpPorts.contains(slotport)) 
		{
			tmpPorts[tmpPorts.length] = slotport;
			nodeAtom.addOption(portResource.portname, slotport);
		} 
	}
	if(resources.length >0)
	{
	  	ct.attrArray['node'].element.options[0].selected = true;
	 	
	  	var slotid = resources[0].slotid;
		var portid = resources[0].port.port;
	  	var vlanAtom = ct.attrArray['vlan'];
      	vlanAtom.clearOptions();
      	for (var j = 0, m = resources.length; j < m; j++) 
		{
			var portResource = resources[j].port;
			if (resources[j].slotid == slotid && portResource.port == portid) 
			{
				var prefix = portResource.logicinftype + ":" + portResource.vid + ":";	
				if(tagtype == tagType_TagTrans)
				{
				    vlanAtom.clearOptions();   
            vlanAtom.addOption('-', prefix);
            vlanAtom.element.disabled = true;
				}
				else
				{
				    for (var k = 0, kLen = portResource.vResource.length; k < kLen; k++) 
				    {
				    	  var text = portResource.vResource[k] == "" ? "-" : portResource.vResource[k];
				    	  var value = portResource.vResource[k] == "" ? prefix + "-" : prefix + portResource.vResource[k];
				    	  vlanAtom.addOption(text, value);
				    }
				}
				
			}
		}
      	ct.attrArray['vlan'].element.options[0].selected = true;
      
	}
}

function refreshSelects()
{
	var element = window.event.srcElement;
    var res = getObjFromArr(resources, element.value);
    var vlanAtom = ct.attrArray['vlan']
    vlanAtom.clearOptions();
	for (var i = 0, iLen = res.length; i < iLen; i++) 
	{
		var portResource = res[i];
		var prefix = portResource.logicinftype + ":" + portResource.vid + ":";
		for (var k = 0, kLen = portResource.vResource.length; k < kLen; k++) 
		{
			var text = portResource.vResource[k] == "" ? "-" : portResource.vResource[k];
			var value = portResource.vResource[k] == "" ? prefix + "-" : prefix + portResource.vResource[k];
			vlanAtom.addOption(text, value);
		}
	}
    ct.attrArray['vlan'].element.options[0].selected = true;
}


function getObjFromArr(arr, val)
{
	var objs = [];
	var slotport = val.split("-");
    for(var i = 0, len = arr.length; i < len; i++)
    {
        var obj = arr[i];
        if(obj.slotid == slotport[0] && obj.port.port == slotport[1])
        {
            objs[objs.length] = obj.port;
        }
    }
	return objs;
}
/**
 * 
 */
function createMEP(isApply)
{
	if("" == ct.getAttrValue("mepID"))
	{
		alert(RESOURCE["PLEASE_CHOOSE_MEP_ID"]);
		return;
	}
	
	if("" == ct.getAttrValue("node").trim())
	{
		alert(RESOURCE["PLEASE_SELECT_PORT"]);
		return;
	}
	$("okbutton").disabled = true;
    $("cancelbtn").disabled = true;
	$("applybtn").disabled = true;
	
	var xml = createXml();

	var urlreq ="../../../../../../neExlorerServlet?sfid="+TECMDCODE_IPPTN_ETH_OAM_CREATE_MEP+"&nmUser="+parentWin.obj["nmUser"];
	loadXMLdoc(urlreq, "POST", false, createCallBack, isApply, "inputdata="+xml);
}

/**
 * 
 */
function createXml()
{
	var selectedRows = parentWin.maTable.getSelectedRows();
	
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",parentWin.neid);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name","auto1");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","mdid");
    param.setAttribute("value",parentWin.maTable.getCellStoreValue(selectedRows[0],"mdid","mdid"));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","auto2");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","maid");
    param.setAttribute("value",parentWin.maTable.getCellStoreValue(selectedRows[0],"maid","maid"));
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name","mepid");
    param.setAttribute("value", ct.getAttrValue("mepID").trim());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","direction");
    param.setAttribute("value",ct.getAttrValue("direct").trim());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","ccstatus");
    param.setAttribute("value",ct.getAttrValue("ccStatus").trim());
    row.appendChild(param);
    
    
    param = new tagElement("param");
    param.setAttribute("name","auto3");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","serviceid");
    param.setAttribute("value",parentWin.serviceIndex);
    row.appendChild(param);	
	
    var vlans = ct.getAttrValue("vlan").trim().split(":");
    var portTypeidArray = ct.getAttrValue("node").split(",");
	var logicinftype = portTypeidArray[0];
	var logicinfid = portTypeidArray[1];
    param = new tagElement("param");
    param.setAttribute("name","porttype");
    param.setAttribute("value",vlans[0]);//1:VUNI   2:VNNI
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","niid");
    param.setAttribute("value",vlans[1]);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","vid");

	var vlan = vlans[2];    
    if(vlan == "" || vlan == "-" ||tagtype == tagType_TagTrans)
    {
    	vlan = "65535";
    }
    param.setAttribute("value",vlan);
    row.appendChild(param);
    
    
    
    /**param = new tagElement("param");
    param.setAttribute("name", "aisperiod");
    param.setAttribute("value", ct.getAttrValue("aisperiod").trim());
    row.appendChild(param);**/
        
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 * 
 */
function createCallBack(doc,isApply)
{
	$("okbutton").disabled = false;
    $("cancelbtn").disabled = false;
		$("applybtn").disabled = false;	
    
    var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	
	if(0 == errorCode) 
	{
		parentWin.queryMEP(true);
		
		if(!isApply)
		{
			xcloseDialog();
		}
	}
	else
	{
		for(var i = data.getBErrLength()-1; i >= 0; i--)
		{	
			var errorObj = data.getError().rowErrors[i].errorObj;
			errorObj["mepid"] = "MEP ID:"+ errorObj["mepid"];
		}
		var errArr = [];
		errArr.push("mepid");
    openErrPage("../../../../../../page/", data.getError(), errArr);
	}
}
