var createCmd = TECMDCODE_PTN_GRETUNNEL_CREATE;
var tunnelType = parseInt(getNeProperty(self).tunnelType);
if (tunnelType == TECMDCODE_PTN_IPTUNNEL_QUERY) 
{
    createCmd = TECMDCODE_PTN_IPTUNNEL_CREATE;
}

function init()
{
    initIPGRETable();
    
    initPortAttrTable();
    initText();
    
    getPortRes();
    refreshSrcPortData();
}

function initIPGRETable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["PROPERTY"], RESOURCE["VALUE"]);
    $("tbdiv").appendChild(ct.getTable());
    
    var atom = new Atom("text");
    atom.element.style.width = "40%";
    atom.element.disabled = true;
    checkText(atom.element, "1", "256");
    ct.addAttrRow("tunnelid", "Tunnel ID", atom);
    
    var checkbox = document.createElement("input");
    checkbox.setAttribute("type", "checkbox");
    checkbox.setAttribute("id", "autoassign");
    checkbox.onclick = checkAutoAssign;
    atom.element.parentNode.appendChild(checkbox);
    checkbox.checked = true;
    
    var span = document.createElement("span");
    span.innerHTML = RESOURCE["autoassign"];
    atom.element.parentNode.appendChild(span);
    
    atom = new Atom("select");
    atom.element.onchange = changePort;
    ct.addAttrRow("srcport", RESOURCE["srcport"], atom);
    
    atom = new Atom("span");
    ct.addAttrRow("staticroute", RESOURCE["staticroute"], atom);
    
    var elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "newroute";
    elem.onclick = function()
    {
        $("hadroute").checked = false;
        this.checked = true;
        
        $("routeid").disabled = false;
        $("routeid").value = 1;
        $("bid").disabled = true;
        
        var atom = ct.getAtom("nexthop");
        atom.element.disabled = false;
        atom.setValue("0.0.0.0");
        
        atom = ct.getAtom("dstipaddr");
        atom.element.disabled = false;
        atom.setValue("0.0.0.0");
        
        atom = ct.getAtom("dstipmask");
        atom.element.disabled = false;
        atom.setValue("255.255.255.255");
    }
    elem.style.width = "5%";
    atom.element.parentNode.appendChild(elem);
    elem.checked = true;
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["createbtn"];
    if (SYSTEMCONF.getLanguage() == "zh") 
    {
        elem.style.width = "9%";
    }
    else 
    {
        elem.style.width = "14%";
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "hadroute";
    elem.onclick = function()
    {
        $("newroute").checked = false;
        this.checked = true;
        
        $("routeid").disabled = true;
        $("routeid").value = "";
        $("bid").disabled = false;
        
        var atom = ct.getAtom("nexthop");
        atom.element.disabled = true;
        atom.setValue("");
        
        atom = ct.getAtom("dstipaddr");
        atom.element.disabled = true;
        atom.setValue("");
        
        atom = ct.getAtom("dstipmask");
        atom.element.disabled = true;
        atom.setValue("");
    }
    elem.style.width = "5%";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["usehad"];
    if (SYSTEMCONF.getLanguage() == "zh") 
    {
        elem.style.width = "20%";
    }
    else 
    {
        elem.style.width = "40%";
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "routeid";
    elem.value = 1;
    if (SYSTEMCONF.getLanguage() == "zh") 
    {
        elem.style.width = "49%";
    }
    else 
    {
        elem.style.width = "24%";
    }
    checkText(elem, "1", "65535");
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.id = "bid";
    elem.disabled = true;
    elem.value = "...";
    elem.onclick = doSelectRoute;
    elem.style.width = "11%";
    atom.element.parentNode.appendChild(elem);
    
    atom = new Atom("text");
    validateIp(atom.element);
    ct.addAttrRow("nexthop", RESOURCE["nexthop"], atom);
    
    atom = new Atom("text");
    validateIp(atom.element);
    ct.addAttrRow("dstipaddr", RESOURCE["dstipaddr"], atom);
    
    atom = new Atom("text");
    validateIp(atom.element);
    ct.addAttrRow("dstipmask", RESOURCE["dstipmask"], atom);
}

function checkAutoAssign()
{
    var atom = ct.getAtom("tunnelid");
    if (this.checked) 
    {
        atom.setValue("");
        atom.element.disabled = true;
    }
    else 
    {
        atom.setValue("1");
        atom.element.disabled = false;
    }
}

function changePort()
{
    $("hadroute").checked = false;
    $("newroute").checked = true;
    
    $("routeid").disabled = false;
    
    var atom = ct.getAtom("nexthop");
    atom.element.disabled = false;
    atom.setValue("0.0.0.0");
    
    atom = ct.getAtom("dstipaddr");
    atom.element.disabled = false;
    atom.setValue("0.0.0.0");
    
    atom = ct.getAtom("dstipmask");
    atom.element.disabled = false;
    atom.setValue("255.255.255.255");
    
    var atom = ct.getAtom("srcport");
    var option = atom.element.options[atom.element.options.selectedIndex];
    fillPortAttr(option);
}

function refreshSrcPortData()
{
    var atom = ct.getAtom("srcport");
    atom.clearOptions();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        var portObj = portRes[i];
        var str = portObj.boardName + "-" + portObj.portName;
        if (parseInt(portObj.slotId) != 0xFFFF) 
        {
            str = portObj.slotId + "-" + str;
        }
        atom.addOption(str, portObj.slotId + "-" + portObj.portId);
    }
    
    changePort();
}

function validate()
{
    return validatePortAttr() && validateTunnel();
}

function validateTunnel()
{
    var v = $("routeid").value.trim();
    if (v == "") 
    {
        alert(RESOURCE["inputrouteid"]);
        return false;
    }
    return true;
}

function createStaticRouteXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("routeID", $("routeid").value));
    var srcPort = ct.getAtom("srcport").getValue().split("-");
    rowparams.appendChild(createTagElement("slotid", srcPort[0]));
    rowparams.appendChild(createTagElement("board", srcPort[0]));
    rowparams.appendChild(createTagElement("subslotid", 255));
    rowparams.appendChild(createTagElement("port", srcPort[1]));
    rowparams.appendChild(createTagElement("nextHop", ct.getAtom("nexthop").getValue()));
    rowparams.appendChild(createTagElement("aimNode", ct.getAtom("dstipaddr").getValue()));
    rowparams.appendChild(createTagElement("aimNodeCode", ct.getAtom("dstipmask").getValue()));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createStaticRouteCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0) 
    {
        doCreateIPGRETunnel();
    }
}

function doCreateTunnel()
{
    if ($("newroute").checked) 
    {
        var xml = createStaticRouteXML();
        var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_ADD_ETHERROUTE + "&nmUser=" + nmUser;
        loadXMLdoc(url, "POST", false, createStaticRouteCallBack, null, "inputdata=" + xml);
    }
    else 
    {
        doCreateIPGRETunnel();
    }
}

function doCreateIPGRETunnel()
{
    var xml = createTunnelXML();
    var url = "../../../../../../neExlorerServlet?sfid=" + createCmd + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createTunnelCallBack, null, "inputdata=" + xml);
}

function createTunnelXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("isLogFlag", 0));
    rowparams.appendChild(createTagElement("indexauto", 1));
    rowparams.appendChild(createTagElement("tunnelindex", 0xFFFFFFFF));
    
    var idAuto = 1;
    var tunnelId = 0xFFFF;
    if (!$("autoassign").checked) 
    {
        idAuto = 0;
        tunnelId = ct.getAtom("tunnelid").getValue();
    }
    rowparams.appendChild(createTagElement("idauto", idAuto));
    rowparams.appendChild(createTagElement("tunnelid", tunnelId));
    
    var srcPort = ct.getAtom("srcport").getValue().split("-");
    rowparams.appendChild(createTagElement("slotid", srcPort[0]));
    rowparams.appendChild(createTagElement("port", srcPort[1]));
    
    var dstIPAddr = ct.getAtom("dstipaddr").getValue();
    rowparams.appendChild(createTagElement("dstipaddr", parseInt("0x" + convertIpaddrToHexcode(dstIPAddr))));
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createTunnelCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        refreshData(data.getDataRowParam(0, "tunnelindex"), data.getDataRowParam(0, "tunnelid"));
        xcloseDialog();
    }
}

function refreshData(tunnelIndex, tunnelId)
{
    win.$("selectedtunnel").value = tunnelId + "(" + RESOURCE["null"] + ")";
    win.$("tunnelindex").value = tunnelIndex;
    if (win.ct != null && win.ct.getAtom("oppsitelsrid") != null) 
    {
        win.ct.getAtom("oppsitelsrid").setValue(ct.getAtom("dstipaddr").getValue());
    }
    else 
    {
        win.pwct.getAtom("oppsitelsrid").setValue(ct.getAtom("dstipaddr").getValue())
    }
    win.$("newtunnel").checked = false;
    win.$("hadtunnel").checked = true;
    if (win.$("applybtn") != null) 
    {
        win.$("applybtn").disabled = false;
    }
}

function doSelectRoute()
{
    xshowModalDialog("../ethcommon/staticroute.html", RESOURCE["resourceselected"], 580, 300, "../../../../../../images/");
}
