var st = null;
var win = getParentWindow();
var neid = win.neid;

var winobj = getNeProperty(self);
var pst = win.qosunist;
var cmdid = TECMDCODE_GET_VUNI_INGRESS_POLICY;
if (winobj.policyType == PW_POLICY)
{
	pst = win.qospwst;
	cmdid = TECMDCODE_GET_PW_POLICY;
}

window.onload = function()
{
    initTable();
    initButton();
    queryPolicy();
}

function initTable()
{
    st = new SortTable();
    st.setImage("../../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setBodyHeight(getTableHeight($("policytable"), st) + "px");
    $("policytable").appendChild(st.getTable());
}

function initButton()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function queryPolicy()
{
    var xmldata = createQueryXml();
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + cmdid + "&nmUser=" + win.nmUser;
    loadXMLdoc(urlstr, "POST", false, callbackQuery, null, "inputdata=" + xmldata);
}

function createQueryXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
	
	param = new tagElement("param");
    param.setAttribute("name", "isLogFlag");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "policyType");
    param.setAttribute("value", winobj.policyType);
    row.appendChild(param);
    
    var param = new tagElement("param");
    param.setAttribute("name", "policyId");
    param.setAttribute("value", "0");
    row.appendChild(param);
    
    business.appendChild(row);
    root.getRoot().appendChild(business);
    
    return root.toString();
}

function callbackQuery(doc)
{
    st.clearTableData();
	
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() == 0) 
    {
        createTableBody(st, window.tableconf[0], data, RESOURCE);
    }
}

function selectPolicy()
{
	var policy = "";
	if (st.getSelectedRowCount() > 0) 
	{
		var index = st.getSelectedRows()[0];
		var policyId = st.getCellStoreValue(index, "policyId", "policyId");
		var policyName = st.getCellStoreValue(index, "policyName", "policyName");
		policy = policyId + (policyName ? ("(" + policyName + ")") : "");
	}
	index = pst.getSelectedRows()[0];
	var cell = pst.getCell(index, "policy");
	cell.element.style.background = "#d0f946";
	pst.setCellValue(cell, "policy", policy);
	pst.getCellShow(index, "policy").element.innerHTML = policy;
	pst.setCellModify(index, "policy", 1);
	pst.getRow(index).element.modify = true;
	win.$("applyqosbtn").disabled = !win.btnRightArr.applybtn.right;
    
    xcloseDialog();
}

window.onresize = function()
{
    if (document.body) 
    {
        st.setBodyHeight(getTableHeight($("policytable"), st) + "px");
    }
}
