var qosunist = null;
var qospwst = null;
var qosQinqTable = null;
var parobj = window.parent;
var obj = parobj.obj;
var neid = obj["neid"];
var nmUser = obj["nmUser"];
var btnRightArr = parobj.btnRightArr;

var neType = obj.neType;
var nevr = obj.neversion.split('.');

var serviceIndex;

var isSupportIngressQos = false;
var isSupportEngressQos = false;
var isSupportQinqQos = false;
var isSupportIngressColor = false;
window.onload = function()
{
	isSupportIngressQos = SpecialAttrMgr.isNESupport(neid, "TEFUNC_MSTPPLUS_QOS_VUNIINGRESS_POLICY", "QOS_ATTR_SUPPORT_VUNIINGRESSPOLICY");
	isSupportEngressQos = SpecialAttrMgr.isNESupport(neid, "TEFUNC_MSTPPLUS_QOS_VUNIEGRESS_POLICY", "QOS_ATTR_SUPPORT_VUNIEGRESSPOLICY");
	isSupportQinqQos = SpecialAttrMgr.isNESupport(neid, "TEFUNC_MSTPPLUS_QOS_QINQ_POLICY", "QOS_ATTR_SUPPORT_QINQPOLICY");
	isSupportIngressColor = SpecialAttrMgr.isNESupport(neid, "TEFUNC_MSTPPLUS_QOS_VUNIINGRESS_POLICY", "QOS_ATTR_SUPPORT_VUNIINGRESSCOSCOLOR");
    initTable();
    initButton();
    initText();
    serviceIndex = parobj.serviceIndex;//get seleted seriveID
    if(!isSupportIngressQos && !isSupportEngressQos)
    {
    	$("qosunilabel").style.display = "none";
    	swicthTab("qospwlabel");
    }
    else
    {
    	initPortQosTable();
    }
    if(!isSupportQinqQos)
    {
    	$("qosqinqLabel").style.display = "none";
    }
    else
    {
    	initQinqQosTable();
    }
}

function tabSelectHandler()
{
  	QueryELineQoS();
}

function initTable()
{
    qospwst = new SortTable();
    qospwst.setImage("../../../../../../images/");
    qospwst.setOnRowSelectHandler(rowSelectHandler_QoS);
    qospwst.setOnCellEditHandler(cellEditHandler_QoS);
    qospwst.isUsedForSelectList=true;
    createTableHead(qospwst, window.tableconf[1]);
    $("qospwtbl").appendChild(qospwst.getTable());
    qospwst.setBodyHeight(getComponetHeight($("qospwtbl"), 180) + "px");
    $("qospwtbl").oncontextmenu = popupMenuHandler_QoS;
}

function initPortQosTable()
{
    qosunist = new SortTable();
    qosunist.setImage("../../../../../../images/");
    qosunist.setOnRowSelectHandler(rowSelectHandler_QoS);
    qosunist.setOnCellEditHandler(cellEditHandler_QoS);
    qosunist.isUsedForSelectList=true;
    createTableHead(qosunist, window.tableconf[0]);
    $("qosunitbl").appendChild(qosunist.getTable());
    qosunist.setBodyHeight(getComponetHeight($("qosunitbl"), 180) + "px");
    $("qosunitbl").oncontextmenu = popupMenuHandler_QoS;
}

function initQinqQosTable()
{
	qosQinqTable = new SortTable();
	qosQinqTable.head.setAttribute("id", "htmlTable_STHead_qosqinq");
    qosQinqTable.body.setAttribute("id", "htmlTable_STBody_qosqinq");
    qosQinqTable.isUsedForSelectList=true;
    qosQinqTable.setImage("../../../../../../images/");
    createTableHead(qosQinqTable, window.tableconf[2]);
    qosQinqTable.setBodyHeight(getComponetHeight($("elineqosqinqtable"), 180)+"px");
    qosQinqTable.setOnCellEditHandler(cellEditHandler_QoS);
    qosQinqTable.setOnRowSelectHandler(rowSelectHandler_QoS);
    $("elineqosqinqtable").appendChild(qosQinqTable.getTable());
    $("elineqosqinqtable").oncontextmenu=popupMenuHandler;
}

function clearAllTableData()
{
	if(qospwst)
	{
		qospwst.clearTableData();
	}
	if(qosunist)
	{
		qosunist.clearTableData();
	}
	if(qosQinqTable)
	{
		qosQinqTable.clearTableData();
	}
}

function initButton()
{
    $("queryqosbtn").value = RESOURCE["querybutton"];
    $("querypolicybtn").value = RESOURCE["querypolicybtn"];
    $("applyqosbtn").value = RESOURCE["applybutton"];
}

function initText()
{
    $("qosunilabel").innerHTML = "UNI";
    $("qospwlabel").innerHTML = "PW";
}

function swicthTab(arg)
{
	$("qospwlabel").className = "tabUnselect";
	$("qosunilabel").className = "tabUnselect";
	$("qosqinqLabel").className = "tabUnselect";
    $(arg).className = "tabSelect";
    if (arg == "qosunilabel") 
    {
        tabSelectFlg = "qosuni";
        $("qosunitbl").style.display = "inline";
        $("qospwtbl").style.display = "none";
        $("elineqosqinqtable").style.display = "none";
        QueryELineQoS();
    }
    else if (arg == "qospwlabel") 
    {
        tabSelectFlg = "qospw";
        $("qosunitbl").style.display = "none";
        $("qospwtbl").style.display = "inline";
        $("elineqosqinqtable").style.display = "none";
        QueryELineQoS();
    }
    else if(arg == "qosqinqLabel")
    {
    	tabSelectFlg = "qosqinqLabel";
        $("qosunitbl").style.display = "none";
        $("qospwtbl").style.display = "none";
        $("elineqosqinqtable").style.display = "inline";
        QueryELineQoS();
    }
}

function cellEditHandler_QoS()
{
    $("applyqosbtn").disabled = !btnRightArr.applybtn.right;
}

function rowSelectHandler_QoS()
{
    var tmpst = qospwst;
    if ($("qosunitbl").style.display != "none") 
    {
        tmpst = qosunist;
    }
    else if($("elineqosqinqtable").style.display != "none")
    {
    	tmpst = qosQinqTable;
    }
    
    var selectedRows = tmpst.getSelectedRows();
    if (selectedRows.length > 0) 
    {
        var policyId = parseInt(tmpst.getCellStoreValue(selectedRows[0], "policyId", "policyId"));
        if (policyId != INVALID_LABEL_VALUE_2) 
        {
            $("querypolicybtn").disabled = !btnRightArr.querybtn.right;
            return;
        }
    }
    $("querypolicybtn").disabled = true;
}

/*
 * Add table popupmenu handler
 */
function popupMenuHandler_QoS(evt)
{
    if (!evt) 
    {
        evt = window.event;
    }
    
    var elem = (evt.target) ? evt.target : evt.srcElement;
    
    if (elem != null && elem.blur) 
    {
        elem.blur();
    }
    
    while (elem != null) 
    {
        if (elem.tagName == 'TD') 
        {
            break;
        }
        else 
        {
            elem = elem.parentNode;
        }
    }
    
    if (elem == null || elem.tagName != 'TD' || null == elem.parent ||
    elem.editElement == null) 
    {
        return;
    }
    
    var rowid = elem.parentNode.rowIndex;
    var rows = elem.parent.getSelectedRows();
    var colid = elem.colid;
    if (rows.contains(rowid)) 
    {
        if (null != elem.editElement && elem.isEdit == 1) 
        {
            if (colid == "policy") 
            {
                openDialog_QoS();
                return;
            }
            createTablePopupMenu(elem, evt);
            return;
        }
        
        for (var i = 0; i < rows.length; i++) 
        {
            var tmpElem = elem.parent.getCellElement(rows[i], colid);
            if (null != tmpElem.editElement && tmpElem.isEdit == 1) 
            {
                if (colid == "policy") 
                {
                    openDialog();
                    return;
                }
                createTablePopupMenu(tmpElem, evt);
                return;
            }
        }
        
    }
}

function openDialog_QoS()
{
    var policyType = PW_POLICY;
    var tmpst = qospwst;
    if ($("qosunitbl").style.display != "none") 
    {
        policyType = VUNI_INGRESS_POLICY;
        tmpst = qosunist;
        if (tmpst.getSelectedRowCount() > 0) 
        {
        	if("2" == tmpst.getCellStoreValue(tmpst.getSelectedRows()[0],"direction","direction"))
        	{
        		policyType = VUNI_EGRESS_POLICY;
        	}
        }
    }
    else if ($("elineqosqinqtable").style.display != "none") 
    {
        policyType = QINQ_POLICY;
        tmpst = qosQinqTable;
    }
    
    if (tmpst.getSelectedRowCount() > 1) 
    {
        return;
    }
    
    var url = "../ethcommon/policyselect.html?policyType=" + policyType;
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 480, 300, "../../../../../images/");
}

function doPrint()
{
    openPrintPage("../../../../../../page/", "", "st");
}

function createQueryQoSXml(arg0, arg1, arg2)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("servType", "1"));//(1:e-line 2:e-lan 3:e-tree)
    
    rowparams.appendChild(createTagElement("servIndex", arg0));
    rowparams.appendChild(createTagElement(arg1, "0"));
    rowparams.appendChild(createTagElement("direction", "0"));
    rowparams.appendChild(createTagElement("qostype", arg2));
    rowparams.appendChild(createTagElement("isLogFlag", "0")); //      
    bussiness.appendChild(rowparams);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function QueryELineQoS()
{
	$("queryqosbtn").disabled = true;
    $("querypolicybtn").disabled = true;
    $("applyqosbtn").disabled = true;
    
	var selectedRows = parobj.st.getSelectedRows();
	if (!selectedRows || selectedRows.length <= 0 || "undefined" == neid)
	{
		return;
	}
	var argServiceIndex = getServiceIndex();
	  	
    var xml = null;
    var arg = null;
    if ($("qosunitbl").style.display != "none") 
    {
        arg = LOAD_TYPE_PHY_PORT;
        xml = createQueryQoSXml(argServiceIndex, "vuniId", arg);
    }
    else if($("qospwtbl").style.display != "none")
    {
        arg = LOAD_TYPE_PW;
        xml = createQueryQoSXml(argServiceIndex, "vnniId", arg);
    }
    else
    {
    	arg = LOAD_TYPE_QINQ;
        xml = createQueryQoSXml(argServiceIndex, "vnniId", arg);
    }
    if (null == xml) 
    {
        return;
    }
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_QUERY_QOS_ELINE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryQoSCallBack, arg, "inputdata=" + xml);
}
var queryData;

function queryQoSCallBack(doc, arg)
{
    $("queryqosbtn").disabled = !btnRightArr.querybtn.right;
    var tmpst = qosunist;
    var tmptc = window.tableconf[0];
    if (arg == LOAD_TYPE_PW) 
    {
        tmpst = qospwst;
        tmptc = window.tableconf[1];
    }
    else if(arg == LOAD_TYPE_QINQ)
    {
    	tmpst = qosQinqTable;
    	tmptc = window.tableconf[2];
    }
    tmpst.clearTableData();
    
    var data = EncapsulateData(doc);
    queryData = data;
    showErrorDialog(data);
    
    createTableBody(tmpst, tmptc, data, RESOURCE);
    handleQosData(tmpst);
    if(arg == LOAD_TYPE_PW )
    {
    	handlePWQosData(tmpst);
    }
    else if(arg == LOAD_TYPE_PHY_PORT)
    {
    	handlePortQosData(tmpst);
    }
    else
    {
    	handleQinQQosData(tmpst);
    }
}

function handleQosData(tmpst)
{
	var cbspbsRange = SpecialAttrMgr.getNEAttrListValue(neid, "TE_MSTP_ELINE", "ELINE_ATTR_QOS_CBSPBS_RANGE");
	var cell = null;
    for (var i = 0, m = tmpst.getDataRowLength(); i < m; i++) 
    {
        var bandwidthlimit = parseInt(tmpst.getCellStoreValue(i, "bandwidthlimit", "bandwidthlimit"));
        
        if (bandwidthlimit == 0) 
        {
            cell = tmpst.getCell(i, "cir");
            tmpst.setCellIsEdit(cell, 0);
            cell.element.showElement.element.innerHTML = "-";
            cell = tmpst.getCell(i, "pir");
            tmpst.setCellIsEdit(cell, 0);
            cell.element.showElement.element.innerHTML = "-";
            cell = tmpst.getCell(i, "cbs");
            tmpst.setCellIsEdit(cell, 0);
            cell.element.showElement.element.innerHTML = "-";
            cell = tmpst.getCell(i, "pbs");
            tmpst.setCellIsEdit(cell, 0);
            cell.element.showElement.element.innerHTML = "-";
        }
        if (cbspbsRange != null && cbspbsRange.length == 2) 
        {
        	if(tmpst.getCellEdit(i,"cbs") != null)
        	{
        		textCheck(tmpst.getCellEdit(i, "cbs").element, cbspbsRange[0], cbspbsRange[1]);
        	}
        	if(tmpst.getCellEdit(i,"pbs") != null)
        	{
        		textCheck(tmpst.getCellEdit(i, "pbs").element, cbspbsRange[0], cbspbsRange[1]);
        	}
        }
        else 
        {
        	if(tmpst.getCellEdit(i,"cbs") != null && tmpst.getCellEdit(i,"pbs") != null)
        	{
	            if ((isRTN900NEtype(neType) && (nevr[2] + nevr[3]) >= '0310') ||
	            (isOSN5X0NEtype(neType) && (nevr[2] + nevr[3]) >= '0510')) 
	            {
	                textCheck(tmpst.getCellEdit(i, "cbs").element, "0", "4294967295");
	                textCheck(tmpst.getCellEdit(i, "pbs").element, "0", "4294967295");
	            }
	            else 
	            {
	                textCheck(tmpst.getCellEdit(i, "cbs").element, "0", "512000");
	                textCheck(tmpst.getCellEdit(i, "pbs").element, "0", "512000");
	            }
        	}
        }
        textCheckWithStepLen(tmpst.getCellEdit(i, "cir").element, 0, 1000000, 64);
        textCheckWithStepLen(tmpst.getCellEdit(i, "pir").element, 0, 1000000, 64);
        var bandwidthlimitCell = tmpst.getCellEdit(i, "bandwidthlimit");
        bandwidthlimitCell.element.onchange = function()
        {
            var selectIndex = tmpst.getSelectedRows()[0];
            if (this.value == 1) 
            {
                var cell = tmpst.getCell(selectIndex, "cir");
                tmpst.setCellIsEdit(cell, 1);
                tmpst.getCellShow(selectIndex, "cir").setValue("64");
                tmpst.setCellValue(cell,"cir","64");
                cell = tmpst.getCell(selectIndex, "cbs");
                tmpst.setCellIsEdit(cell, 0);
                tmpst.getCellShow(selectIndex, "cbs").setValue("-");
                tmpst.setCellValue(cell,"cbs","-");
                cell = tmpst.getCell(selectIndex, "pir");
                tmpst.setCellIsEdit(cell, 1);
                tmpst.getCellShow(selectIndex, "pir").setValue("64");
                tmpst.setCellValue(cell,"pir","64");
                cell = tmpst.getCell(selectIndex, "pbs");
                tmpst.setCellIsEdit(cell, 0);
                tmpst.getCellShow(selectIndex, "pbs").setValue("-");
                tmpst.setCellValue(cell,"pbs","-");
            }
            else 
            {
                var cell = tmpst.getCell(selectIndex, "cir");
                tmpst.setCellIsEdit(cell, 0);
                tmpst.getCellShow(selectIndex, "cir").setValue("-");
                tmpst.setCellValue(cell,"cir","-");
                cell = tmpst.getCell(selectIndex, "cbs");
                tmpst.setCellIsEdit(cell, 0);
                tmpst.getCellShow(selectIndex, "cbs").setValue("-");
                tmpst.setCellValue(cell,"cbs","-");
                cell = tmpst.getCell(selectIndex, "pir");
                tmpst.setCellIsEdit(cell, 0);
                tmpst.getCellShow(selectIndex, "pir").setValue("-");
                tmpst.setCellValue(cell,"pir","-");
                cell = tmpst.getCell(selectIndex, "pbs");
                tmpst.setCellIsEdit(cell, 0);
                tmpst.getCellShow(selectIndex, "pbs").setValue("-");
                tmpst.setCellValue(cell,"pbs","-");
            }
        }
    }
}

function handleQinQQosData(tmpst)
{
    var cell = null;
    for (var i = 0, m = tmpst.getDataRowLength(); i < m; i++) 
    {
    	var direction = parseInt(tmpst.getCellStoreValue(i, "direction", "direction"));
    	cell = tmpst.getCell(i, "cbs");
        tmpst.setCellIsEdit(cell, 0);
        cell.element.showElement.element.innerHTML = "-";
        cell = tmpst.getCell(i, "pbs");
        tmpst.setCellIsEdit(cell, 0);
        cell.element.showElement.element.innerHTML = "-";
        cell = tmpst.getCell(i, "policy");
        cell.element.ondblclick = openDialog_QoS;
    }
}

function handlePortQosData(tmpst)
{
    var cell = null;
    for (var i = 0, m = tmpst.getDataRowLength(); i < m; i++) 
    {
    	var direction = parseInt(tmpst.getCellStoreValue(i, "direction", "direction"));
    	cell = tmpst.getCell(i, "cbs");
        tmpst.setCellIsEdit(cell, 0);
        cell.element.showElement.element.innerHTML = "-";
        cell = tmpst.getCell(i, "pbs");
        tmpst.setCellIsEdit(cell, 0);
        cell.element.showElement.element.innerHTML = "-";
        if (!isSupportIngressColor || direction != INGRESS) 
		{
			cell = tmpst.getCell(i, "cos");
			tmpst.setCellIsEdit(cell, 0);
			cell.element.showElement.element.innerHTML = "-";
			
			cell = tmpst.getCell(i, "color");
			tmpst.setCellIsEdit(cell, 0);
			cell.element.showElement.element.innerHTML = "-";
		}
        if (direction != INGRESS) 
        {
			cell = tmpst.getCell(i, "policy");
			if(isSupportEngressQos)
			{
				tmpst.setCellIsEdit(cell, 1);
        		cell.element.ondblclick = openDialog_QoS;
			}
			else
			{
				tmpst.setCellIsEdit(cell, 0);
			}
        }
		else
		{
			cell = tmpst.getCell(i, "policy");
			if(isSupportIngressQos)
			{
				tmpst.setCellIsEdit(cell, 1);
        		cell.element.ondblclick = openDialog_QoS;
			}
			else
			{
				tmpst.setCellIsEdit(cell, 0);
			}
		}
    }
}

function handlePWQosData(tmpst)
{
    var cell = null;
    for (var i = 0, m = tmpst.getDataRowLength(); i < m; i++) 
    {
        var direction = parseInt(tmpst.getCellStoreValue(i, "direction", "direction"));
        var bandwidthlimit = parseInt(tmpst.getCellStoreValue(i, "bandwidthlimit", "bandwidthlimit"));
        cell = tmpst.getCell(i, "exp");
        tmpst.setCellIsEdit(cell, 0);
        cell.element.showElement.element.innerHTML = "-";
        tmpst.setCellIsEdit(tmpst.getCell(i, "lspmode"), 0);
		cell = tmpst.getCell(i, "lspmode");
        cell.element.showElement.element.innerHTML = "-";
        if (direction == INGRESS) 
        {
            cell = tmpst.getCell(i, "policy");
            cell.element.ondblclick = openDialog_QoS;
        }
        else 
        {
            cell = tmpst.getCell(i, "bandwidthlimit");
            tmpst.setCellIsEdit(cell, 0);
            
            cell = tmpst.getCell(i, "cir");
            tmpst.setCellIsEdit(cell, 0);
            cell.element.showElement.element.innerHTML = "-";
            
            cell = tmpst.getCell(i, "cbs");
            tmpst.setCellIsEdit(cell, 0);
            cell.element.showElement.element.innerHTML = "-";
            
            cell = tmpst.getCell(i, "pir");
            tmpst.setCellIsEdit(cell, 0);
            cell.element.showElement.element.innerHTML = "-";
            
            cell = tmpst.getCell(i, "pbs");
            tmpst.setCellIsEdit(cell, 0);
            cell.element.showElement.element.innerHTML = "-";
            cell = tmpst.getCell(i, "policy");
            tmpst.setCellIsEdit(cell, 0);
        }
        var bandwidthlimitCell = tmpst.getCellEdit(i, "bandwidthlimit");
        bandwidthlimitCell.element.onchange = function()
        {
            var selectIndex = tmpst.getSelectedRows()[0];
            if (this.value == 1) 
            {
                var cell = tmpst.getCell(selectIndex, "cir");
                tmpst.setCellIsEdit(cell, 1);
                tmpst.getCellShow(selectIndex, "cir").setValue("64");
                tmpst.setCellValue(cell,"cir","64");
                cell = tmpst.getCell(selectIndex, "cbs");
                tmpst.setCellIsEdit(cell, 1);
                tmpst.getCellShow(selectIndex, "cbs").setValue("");
                tmpst.setCellValue(cell,"cbs","");
                cell = tmpst.getCell(selectIndex, "pir");
                tmpst.setCellIsEdit(cell, 1);
                tmpst.getCellShow(selectIndex, "pir").setValue("64");
                tmpst.setCellValue(cell,"pir","64");
                cell = tmpst.getCell(selectIndex, "pbs");
                tmpst.setCellIsEdit(cell, 1);
                tmpst.getCellShow(selectIndex, "pbs").setValue("");
                tmpst.setCellValue(cell,"pbs","");
            }
            else 
            {
                var cell = tmpst.getCell(selectIndex, "cir");
                tmpst.setCellIsEdit(cell, 0);
                tmpst.getCellShow(selectIndex, "cir").setValue("-");
                tmpst.setCellValue(cell,"cir","-");
                cell = tmpst.getCell(selectIndex, "cbs");
                tmpst.setCellIsEdit(cell, 0);
                tmpst.getCellShow(selectIndex, "cbs").setValue("-");
                tmpst.setCellValue(cell,"cbs","-");
                cell = tmpst.getCell(selectIndex, "pir");
                tmpst.setCellIsEdit(cell, 0);
                tmpst.getCellShow(selectIndex, "pir").setValue("-");
                tmpst.setCellValue(cell,"pir","-");
                cell = tmpst.getCell(selectIndex, "pbs");
                tmpst.setCellIsEdit(cell, 0);
                tmpst.getCellShow(selectIndex, "pbs").setValue("-");
                tmpst.setCellValue(cell,"pbs","-");
            }
        }
    }
}

function QueryELinePolicy()
{
    var tmpst = qospwst;
    var policyType = PW_POLICY;
    if ($("qosunitbl").style.display != "none") 
    {
        tmpst = qosunist;
        policyType = VUNI_INGRESS_POLICY;
        if (tmpst.getSelectedRowCount() > 0) 
        {
        	if("2" == tmpst.getCellStoreValue(tmpst.getSelectedRows()[0],"direction","direction"))
        	{
        		policyType = VUNI_EGRESS_POLICY;
        	}
        }
    }
    else if ($("elineqosqinqtable").style.display != "none") 
    {
        policyType = QINQ_POLICY;
        tmpst = qosQinqTable;
    }
    
    var tmpIndex = tmpst.getSelectedRows()[0];
    var policy = tmpst.getCellStoreValue(tmpIndex, "policy", "policy");
    if (typeof(policy) == "undefined" || null == policy || "" == policy) 
    {
        alert(RESOURCE["selectpolicy"]);
        return;
    }
    var url = "../ethcommon/policyinfo.html?policyType=" + policyType + "&policyId=" + policy.substring(0, policy.indexOf("("));
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 580, 420, "../../../../../../images/");
}

function createApplyQoSXml(stObj, loadType)
{
	if (loadType == LOAD_TYPE_PHY_PORT) 
    {
		return createApplyPortQosXML(stObj,loadType);
    }
	else if(loadType == LOAD_TYPE_PW)
	{
		return createApplyPWQosXML(stObj,loadType);
	}
	else
	{
		return createApplyQinQQosXML(stObj,loadType);
	}
}

function createApplyPWQosXML(arg0)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, m = arg0.getDataRowLength(); i < m; i++) 
    {
        if (!arg0.getModify(i)) 
        {
            continue;
        }

        var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));

        rowparams.appendChild(createTagElement("auto", "0"));
        rowparams.appendChild(createTagElement("pwIndex", arg0.getCellStoreValue(i, "pwIndex", "pwIndex")));
		rowparams.appendChild(createTagElement("pwID", arg0.getCellStoreValue(i, "pwID", "pwID")));
        rowparams.appendChild(createTagElement("direction", arg0.getCellStoreValue(i, "direction", "direction")));
        if (arg0.getCellModify(i, "policy")) 
        {
            rowparams.appendChild(createTagElement("autopolicyid", "0"));
            var policy = arg0.getCellStoreValue(i, "policy", "policy");
			var policyInfo = policy;
            if (typeof(policy) == "undefined" || policy == "") 
            {
                policy = INVALID_LABEL_VALUE_2;
				policyInfo = "";
            }
            else 
            {
                policy = policy.substring(0, policy.indexOf("("));
            }
			rowparams.appendChild(createTagElement("policyinfo", policyInfo));
            rowparams.appendChild(createTagElement("policyid", policy));
        }
        if (arg0.getCellModify(i, "exp")) 
        {
            rowparams.appendChild(createTagElement("exp", arg0.getCellStoreValue(i, "exp", "exp")));
        }
        
        if (arg0.getCellModify(i, "lspmode")) 
        {
            rowparams.appendChild(createTagElement("lspmode", arg0.getCellStoreValue(i, "lspmode", "lspmode")));
        }

        appendQueueParam(rowparams,arg0,i);
        
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function getServiceIndex()
{
	var selectedRows = parobj.st.getSelectedRows();
	var argServiceIndex = parobj.st.getCellStoreValue(selectedRows[0], "serviceIndex", "serviceIndex");
	return argServiceIndex;
}

function createApplyPortQosXML(arg0)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, m = arg0.getDataRowLength(); i < m; i++) 
    {
    	if (!arg0.getModify(i)) 
        {
            continue;
        }
    	var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("autoServiceIndex", "0"));
        rowparams.appendChild(createTagElement("servIndex", getServiceIndex()));
        rowparams.appendChild(createTagElement("serviceIndex", getServiceIndex()));
        rowparams.appendChild(createTagElement("autoVuniId", "0"));
        rowparams.appendChild(createTagElement("vuniid", arg0.getCellStoreValue(i, "vuniId", "vuniId")));
        rowparams.appendChild(createTagElement("direction", arg0.getCellStoreValue(i, "direction", "direction")));
        
        if (arg0.getCellModify(i, "policy")) 
        {
            rowparams.appendChild(createTagElement("autoPolicy", "0"));
            var policy = arg0.getCellStoreValue(i, "policy", "policy");
			var policyInfo = policy;
            if (typeof(policy) == "undefined" || policy == "") 
            {
                policy = INVALID_LABEL_VALUE_2;
				policyInfo = "";
            }
            else 
            {
                policy = policy.substring(0, policy.indexOf("("));
            }
			rowparams.appendChild(createTagElement("policyinfo", policyInfo));
            rowparams.appendChild(createTagElement("policy", policy));
        }
        
        appendQueueParam(rowparams,arg0,i);
        if (arg0.getCellModify(i, "cos") || arg0.getCellModify(i, "color")) 
        {
            rowparams.appendChild(createTagElement("cos", arg0.getCellStoreValue(i, "cos", "cos")));
            rowparams.appendChild(createTagElement("color", arg0.getCellStoreValue(i, "color", "color")));
        }
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createApplyQinQQosXML(arg0)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    for (var i = 0, m = arg0.getDataRowLength(); i < m; i++) 
    {
    	if (!arg0.getModify(i)) 
        {
            continue;
        }
    	var rowparams = new tagElement("row-params");
        rowparams.appendChild(createTagElement("neid", neid));
        rowparams.appendChild(createTagElement("autolinkid", "0"));
        rowparams.appendChild(createTagElement("linkid", arg0.getCellStoreValue(i, "linkid", "linkid")));
        rowparams.appendChild(createTagElement("direction", arg0.getCellStoreValue(i, "direction", "direction")));
        if (arg0.getCellModify(i, "policy")) 
        {
            rowparams.appendChild(createTagElement("autopolicyid", "0"));
            var policy = arg0.getCellStoreValue(i, "policy", "policy");
			var policyInfo = policy;
            if (typeof(policy) == "undefined" || policy == "") 
            {
                policy = INVALID_LABEL_VALUE_2;
				policyInfo = "";
            }
            else 
            {
                policy = policy.substring(0, policy.indexOf("("));
            }
			rowparams.appendChild(createTagElement("policyinfo", policyInfo));
            rowparams.appendChild(createTagElement("policyid", policy));
        }
        appendQueueParam(rowparams,arg0,i);
        bussiness.appendChild(rowparams);
    }
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *                  
 * @param rowparams
 * @param stObj
 * @param rowIndex
 * @return
 */
function appendQueueParam(rowparams,stObj,rowIndex)
{
    if (queryData.getDataRowParam(rowIndex, "bandwidthlimit") ==1  && stObj.getCellStoreValue(rowIndex, "bandwidthlimit", "bandwidthlimit") == 1) //  
    {
		if (stObj.getCellModify(rowIndex, "cir") || stObj.getCellModify(rowIndex, "cbs") 
			|| stObj.getCellModify(rowIndex, "pir") || stObj.getCellModify(rowIndex, "pbs")) 
		{
			rowparams.appendChild(createTagElement("cir", stObj.getCellStoreValue(rowIndex, "cir", "cir")));
			rowparams.appendChild(createTagElement("cbs", stObj.getCellStoreValue(rowIndex, "cbs", "cbs")));
			rowparams.appendChild(createTagElement("pir", stObj.getCellStoreValue(rowIndex, "pir", "pir")));
			rowparams.appendChild(createTagElement("pbs", stObj.getCellStoreValue(rowIndex, "pbs", "pbs")));
		}
    }
    else  if (queryData.getDataRowParam(rowIndex, "bandwidthlimit") ==0 && stObj.getCellStoreValue(rowIndex, "bandwidthlimit", "bandwidthlimit") == 1) //  
    {
        rowparams.appendChild(createTagElement("createdirection", stObj.getCellStoreValue(rowIndex, "direction", "direction")));
        rowparams.appendChild(createTagElement("createcir",convertQosValue(stObj.getCellShow(rowIndex, "cir").element.innerHTML)));
        rowparams.appendChild(createTagElement("createcbs", convertQosValue(stObj.getCellShow(rowIndex, "cbs").element.innerHTML)));
        rowparams.appendChild(createTagElement("createpir",convertQosValue(stObj.getCellShow(rowIndex, "pir").element.innerHTML)));
        rowparams.appendChild(createTagElement("createpbs", convertQosValue(stObj.getCellShow(rowIndex, "pbs").element.innerHTML)));
    }
    else if (queryData.getDataRowParam(rowIndex, "bandwidthlimit") ==1  && stObj.getCellStoreValue(rowIndex, "bandwidthlimit", "bandwidthlimit") == 2) //  
    {
        rowparams.appendChild(createTagElement("deletedirection", stObj.getCellStoreValue(rowIndex, "direction", "direction")));
    }
}

/**
 *     Qos         -/         
 *              F
 * @param value
 * @return
 */
function convertQosValue(value)
{
	if(value == "-" || value == "/")
	{
		return 4294967295;
	}
	return value;
}

function checkCBSDataValid()
{
    var tmpst = qospwst;
    var tmptc = window.tableconf[0];
    for (var rowindex = 0, rowlen = tmpst.getDataRowLength(); rowindex < rowlen; rowindex++) 
    {
    
        
        var cbsValue = tmpst.getCellShow(rowindex, "cbs").element.innerText;
        if (cbsValue == "" || cbsValue == null) 
        {
        
            return false;
        }
    }
    return true;
}

function checkPBSDataValid(){	
	var tmpst = qospwst;
    var tmptc = window.tableconf[0];
    for (var rowindex = 0, rowlen = tmpst.getDataRowLength(); rowindex < rowlen; rowindex++) {

            var pbsValue = tmpst.getCellShow(rowindex, "pbs").element.innerText;
            if (pbsValue==""||pbsValue==null) {
            
                return false;
            }           
    }
    return true;
}

function ApplyELineQoS()
{		   	
	if (!checkCBSDataValid()) {
		alert(RESOURCE["errcbs"]);
        return;
    }
	
	if (!checkPBSDataValid()) {
		alert(RESOURCE["errpbs"]);
        return;
    }
	if (!confirm(RESOURCE["SERVICE_BREAK_WARN"])) 
    {
        return;
    }
    
    $("applyqosbtn").disabled = true;
    
    var tmpst = qospwst;
    var qosType = LOAD_TYPE_PW;
    if ($("qosunitbl").style.display != "none") 
    {
        tmpst = qosunist;
        qosType = LOAD_TYPE_PHY_PORT;
    }
    else if($("elineqosqinqtable").style.display != "none")
    {
    	tmpst = qosQinqTable;
        qosType = LOAD_TYPE_QINQ;
    }

    var xml = createApplyQoSXml(tmpst, qosType);

    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_IPPTN_SET_QOS_ELINE + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, applyQoSCallBack, null, "inputdata=" + xml);
}

function applyQoSCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    var tmpst = qospwst;
    var tmptc = window.tableconf[1];
    if ($("qosunitbl").style.display != "none") 
    {
        tmpst = qosunist;
        tmptc = window.tableconf[0];
    }
    else if($("elineqosqinqtable").style.display != "none")
    {
    	tmpst = qosQinqTable;
    	tmptc = window.tableconf[2];
    }
    
    if (data.getSErrorCode() != 0) 
    {
        $("applyqosbtn").disabled = !btnRightArr.applybtn.right;
    }
    else
    {
		refreshTableState(tmpst, tmptc, data);
    }
}
