var MIN_BANDWIDTH = 128;
var MAX_BANDWIDTH = 4294967295;
var nodetype = parseInt(getNeProperty(self).nodetype);  //nodetype:1   Ingress   3  Engress  
var buttonIndex = parseInt(getNeProperty(self).buttonIndex);  //  buttonIndex 
var tunnelType = parseInt(getNeProperty(self).tunnelType);

var egressSrcnode = "";
var egressSnknode = "";

function init()
{
	getPortRes(); //        
    initMPLSTunnelTable();
    initPortAttrTable();
    initText();
    
    if (nodetype == NODE_TYPE_INGRESS)
    {
    	fillBoard("outboard"); //     
    	changeBoard("outboard", "outport");
    }
    else
    {
    	fillBoard("inboard"); //     
    	changeBoard("inboard", "inport");
    }
}

function initMPLSTunnelTable()
{
    ct = new CTable();
    ct.addHead(RESOURCE["attribute"], RESOURCE["positivevalue"], RESOURCE["negativevalue"]);
    $("tbdiv").appendChild(ct.getTable());
    
    var atom1 = new Atom("text");
    checkText(atom1.element, "1", "65535");

    ct.addAttrRow("tunnelid", RESOURCE["tunnelid"], atom1);
    
    atom1 = new Atom("text");
    checkTextData(atom1.element, 64);
    ct.addAttrRow("tunnelname", RESOURCE["tunnelname"], atom1);
    
    if (nodetype == NODE_TYPE_INGRESS)
    {
    	atom1 = new Atom("select");
        atom1.element.disabled = true;
        atom1.addOption(RESOURCE["ingress"], 1);
        ct.addAttrRow("nodetype", RESOURCE["nodetype"], atom1);
    }
    else
    {
    	atom1 = new Atom("select");
        atom1.element.disabled = true;
        atom1.addOption(RESOURCE["egress"], 3);
        ct.addAttrRow("nodetype", RESOURCE["nodetype"], atom1);
    }
    
    atom1 = new Atom("select");
    atom1.element.disabled = true;
    atom1.addOption(RESOURCE["unidirectional"], 0);
    ct.addAttrRow("direction", RESOURCE["direction"], atom1);
    
    atom1 = new Atom("combobox");
    ct.addAttrRow("bandwidth", RESOURCE["bandwidth"], atom1);
    
    atom1.element.parent.initComboBox(getDataArr(), "dm0", 16, true);
    atom1.element.parent.txtview.onkeypress = keypressHandler;
    atom1.element.parent.txtview.onkeyup = keyupHandler;
    atom1.element.parent.txtview.onblur = onblurHandler;
    atom1.element.parent.txtview.style.imeMode = "disabled";
    atom1.element.parent.txtview.onpaste = function()
    {
        return false;
    }
    /*
    atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
	ct.addAttrRow("pir", RESOURCE["pir"], atom1);
	atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
	ct.addAttrRow("cbs", RESOURCE["cbs"], atom1);
	atom1 = new Atom("text");
    atom1.element.disabled = true;
	atom1.setValue("-");
	ct.addAttrRow("pbs", RESOURCE["pbs"], atom1);
	*/
    if (nodetype == 1)
    {
    	atom1 = new Atom("select"); //   
    	atom1.element.disabled = true;
   	    ct.addAttrRow("inboard", RESOURCE["inboard"], atom1);
   	    atom1 = new Atom("select");  //   
        atom1.element.disabled = true;
        ct.addAttrRow("inport", RESOURCE["inport"], atom1);
   	    atom1 = new Atom("text");  //   
        atom1.element.disabled = true;
        atom1.setValue("-");
        ct.addAttrRow("inlabel", RESOURCE["inlabel"], atom1);
        
        atom1 = new Atom("select");  //   
        ct.addAttrRow("outboard", RESOURCE["outboard"], atom1);
        atom1.element.onchange = function()
        {
        	changeBoard("outboard", "outport");
        };
        atom1 = new Atom("select");  //   
        ct.addAttrRow("outport", RESOURCE["outport"], atom1);
        atom1.element.onchange = function()
        {
        	changePort("outboard", "outport");
        };
        
        atom1 = new Atom("text");  //   
        checkText(atom1.element, "16", "1048575");
        ct.addAttrRow("outlabel", RESOURCE["outlabel"], atom1);
        
        atom1 = new Atom("text");  //     
        validateIp(atom1.element);
        ct.addAttrRow("nexthopaddr", RESOURCE["nexthopaddr"], atom1);
        
        atom1 = new Atom("text"); //   
   	    atom1.element.disabled = true;
        atom1.setValue("-");
        ct.addAttrRow("srcnode", RESOURCE["srcnode"], atom1);
    	atom1 = new Atom("text"); //   
  	    atom1.element.disabled = false;
        validateNode(atom1.element, false, "snknode");
        ct.addAttrRow("snknode", RESOURCE["snknode"], atom1);
		
	    atom1 = new Atom("select");
	    atom1.addOption(RESOURCE["elsp"], 0);
		atom1.addOption(RESOURCE["llsp"], 1);
	    ct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom1);
		
        atom1 = new Atom("select");
  		atom1.addOption(RESOURCE["exp0"], 0);
        atom1.addOption(RESOURCE["exp1"], 1);
        atom1.addOption(RESOURCE["exp2"], 2);
        atom1.addOption(RESOURCE["exp3"], 3);
        atom1.addOption(RESOURCE["exp4"], 4);
        atom1.addOption(RESOURCE["exp5"], 5);
        atom1.addOption(RESOURCE["exp6"], 6);
        atom1.addOption(RESOURCE["exp7"], 7);
        atom1.addOption(RESOURCE["exp255"], 255);
        atom1.element.options.selectedIndex = 8;
        ct.addAttrRow("exp", RESOURCE["exp"], atom1);
    }
    else
    {
    	atom1 = new Atom("select");
    	
   	    ct.addAttrRow("inboard", RESOURCE["inboard"], atom1);
   	    atom1.element.onchange = function()
    	{
    		changeBoard("inboard", "inport");
    	};
   	    atom1 = new Atom("select");  //   
        ct.addAttrRow("inport", RESOURCE["inport"], atom1);
        atom1.element.onchange = function()
    	{
    		changePort("inboard", "inport");
    	};
   	    atom1 = new Atom("text");
        checkText(atom1.element, "16", "1048575");
        ct.addAttrRow("inlabel", RESOURCE["inlabel"], atom1);
       
        atom1 = new Atom("select");  //   
        atom1.element.disabled = true;
        ct.addAttrRow("outboard", RESOURCE["outboard"], atom1);
        atom1 = new Atom("select");  //   
        atom1.element.disabled = true;
        ct.addAttrRow("outport", RESOURCE["outport"], atom1);
        atom1 = new Atom("text");
        atom1.element.disabled = true;
        atom1.setValue("-");
        ct.addAttrRow("outlabel", RESOURCE["outlabel"], atom1);
        atom1 = new Atom("text");  //     
        atom1.element.disabled = true;
        atom1.setValue("-");
        ct.addAttrRow("nexthopaddr", RESOURCE["nexthopaddr"], atom1);
        
        atom1 = new Atom("text");
   	    atom1.element.disabled = false;
        ct.addAttrRow("srcnode", RESOURCE["srcnode"], atom1);
        validateNode(atom1.element, false, "srcnode");
    	atom1 = new Atom("text");
  	    atom1.element.disabled = true;
        atom1.setValue("-");
        
        ct.addAttrRow("snknode", RESOURCE["snknode"], atom1);
		
		atom1 = new Atom("select");
	    atom1.addOption(RESOURCE["elsp"], 0);
		atom1.addOption(RESOURCE["llsp"], 1);
	    ct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom1);
		
        atom1 = new Atom("select");
        atom1.element.disabled = true;
        atom1.addOption(RESOURCE["exp0"], 0);
        atom1.addOption(RESOURCE["exp1"], 1);
        atom1.addOption(RESOURCE["exp2"], 2);
        atom1.addOption(RESOURCE["exp3"], 3);
        atom1.addOption(RESOURCE["exp4"], 4);
        atom1.addOption(RESOURCE["exp5"], 5);
        atom1.addOption(RESOURCE["exp6"], 6);
        atom1.addOption(RESOURCE["exp7"], 7);
        atom1.addOption(RESOURCE["exp255"], 255);
        atom1.addOption("-", 0);
        atom1.element.options.selectedIndex = 9;
        ct.addAttrRow("exp", RESOURCE["exp"], atom1);
    }
}

function fillBoard(board)
{
    var atom = ct.getAtom(board, 0);
    atom.element.options.length = 0;
    
    var portObj = null;
    var bdName = null;
    var tmpArr = new Array();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        bdName = portObj.boardName;
        if (parseInt(portObj.slotId) != INVALID_SLOT) 
        {
            bdName = portObj.slotId + "-" + bdName;
        }
        
        if (!tmpArr.contains(bdName)) 
        {
            tmpArr[tmpArr.length] = bdName;
            atom.addOption(bdName, portObj.slotId);
        }
    }
}
function changeBoard(board, port)
{
    var atom = ct.getAtom(board, 0);
    var boardoption = atom.element.options[atom.element.options.selectedIndex];
    
    var slotId = boardoption.value;
   	var boardName = boardoption.text;
    var bdName = null;
    atom = ct.getAtom(port, 0); //    
    atom.element.options.length = 0; //     
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        portObj = portRes[i];
        bdName = portObj.boardName;
        if (parseInt(portObj.slotId) != INVALID_SLOT) 
        {
            bdName = portObj.slotId + "-" + bdName; //      
        }
        if (boardName == bdName) 
        {
            atom.addOption(portObj.portName, portObj.portId);
        }
    }
    atom.element.options.selectedIndex = 0;
    changePort(board, port);
}

function changePort(board, port)
{
    var atom = ct.getAtom(board, 0); //    
    var boardoption = atom.element.options[atom.element.options.selectedIndex];
    var board = boardoption.text; //    
    var slotId = boardoption.value; 
    
    atom = ct.getAtom(port, 0); //    
    var portoption = atom.element.options[atom.element.options.selectedIndex];
    var portId = portoption.value; //        
    var option = new Option();
    option.text = board + "(" + RESOURCE["port"] + "-" + portId + ")";
    option.value = slotId + "-" + portoption.value;
    fillPortAttr(option); //        
}


function setComboboxStyle(index)
{
    var elem = ct.getAtom("bandwidth", index).element.parent;
    var wdt = elem.view.parentNode.offsetWidth - 2;
    var clip = "rect(1px," + (wdt - 1) + "px,19px," + (wdt - 18) + "px)";
    
    elem.txtview.style.width = wdt;
    elem.selview.style.width = wdt;
    elem.selview.style.clip = clip;
}

function validateTunnel(index)
{
    var atom = ct.getAtom("tunnelid", index);
    var v = atom.getValue().trim();
    if (v == "") 
    {
        alert(RESOURCE["inputtunnelid"]);
        return false;
    }
    atom = ct.getAtom("inlabel", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputinlabel"]);
        return false;
    }
    atom = ct.getAtom("outlabel", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled && v == "") 
    {
        alert(RESOURCE["inputoutlabel"]);
        return false;
    }
    
    atom = ct.getAtom("nexthopaddr", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputhopaddr"]);
            return false;
        }
        else if (v >= "224.0.0.0") 
        {
            alert(RESOURCE["invalidip"]);
            return false;
        }
    }
    
    atom = ct.getAtom("srcnode", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsrcnode"]);
            return false;
        }
        else if (v >= "224.0.0.0") 
        {
            alert(RESOURCE["invalidip"]);
            return false;
        }
    }
    
    atom = ct.getAtom("snknode", index);
    v = atom.getValue().trim();
    if (!atom.element.disabled) 
    {
        if (v == "" || v == "0.0.0.0") 
        {
            alert(RESOURCE["inputsnknode"]);
            return false;
        }
        else if (v >= "224.0.0.0") 
        {
            alert(RESOURCE["invalidip"]);
            return false;
        }
    }
    
    return true;
}

function refreshSnkBoardData()
{
    var atom = ct.getAtom("outboard", 0);
    atom.clearOptions();
    for (var i = 0, m = portRes.length; i < m; i++) 
    {
        var portObj = portRes[i];
        var str = portObj.boardName + "-" + portObj.portName;
        if (parseInt(portObj.slotId) != 0xFFFF) 
        {
            str = portObj.slotId + "-" + str;
        }
        atom.addOption(str, portObj.slotId + "-" + portObj.portId);
    }
    
}

function validate()
{
	if (!validatePortAttr())
	{
		return false;
	}
	if (!validateTunnel(0)) 
    {
        return false;
    }
	return true;
}

function createTunnelXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    bussiness.appendChild(createRowParams(0));
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function createRowParams(index)
{
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("auto", 1));
    rowparams.appendChild(createTagElement("autoassign", 2));
    rowparams.appendChild(createTagElement("tunnelindex", 0));
    rowparams.appendChild(createTagElement("tunnelid", ct.getAtom("tunnelid", index).getValue()));
    var tunnelName = ct.getAtom("tunnelname", index).getValue().trim();
    if (tunnelName != "") 
    {
        rowparams.appendChild(createTagElement("name", tunnelName));
    }
    rowparams.appendChild(createTagElement("direction", ct.getAtom("direction", index).getValue()));
	var tunneltype = parseInt(ct.getAtom("tunneltype", index).getValue());
	rowparams.appendChild(createTagElement("tunneltype", tunneltype));
    if(0 == tunneltype)
	{
		rowparams.appendChild(createTagElement("cos", 255));//   e-lsp,    (0xFF)
	}
	else if(1 == tunneltype)
	{
		rowparams.appendChild(createTagElement("cos", 1));//   e-lsp,1 be,2 af1,3 af2,4 af3,5 af4,6 ef,7 cs6,8 cs7
	}
	
    var nodeType = parseInt(ct.getAtom("nodetype", index).getValue());
    rowparams.appendChild(createTagElement("nodetype", nodeType));
    
    var board = null;
    var atom = null;
    var bandwidth = ct.getAtom("bandwidth", index).getValue();
    switch (nodeType)
    {
        case NODE_TYPE_INGRESS:
            rowparams.appendChild(createTagElement("bw", bandwidth));
            rowparams.appendChild(createTagElement("bandwidth", isNaN(bandwidth) ? 0 : bandwidth));
            rowparams.appendChild(createTagElement("insubslotid", 0));
            var oOptions = ct.getAtom("outboard", index).element.options;
            board = oOptions[oOptions.selectedIndex].value.split("-");
            rowparams.appendChild(createTagElement("outslotid", board[0]));
            rowparams.appendChild(createTagElement("outportname", oOptions[oOptions.selectedIndex].text));
            atom = ct.getAtom("outport", index);
            rowparams.appendChild(createTagElement("outport", atom.getValue()));
            rowparams.appendChild(createTagElement("outlabel", ct.getAtom("outlabel", index).getValue()));
            var nextHopAddr = ct.getAtom("nexthopaddr", index).getValue();
            rowparams.appendChild(createTagElement("nexthopaddress", nextHopAddr));
            rowparams.appendChild(createTagElement("nexthopaddr", parseInt("0x" + convertIpaddrToHexcode(nextHopAddr))));
            var snkNode = ct.getAtom("snknode", index).getValue();
            rowparams.appendChild(createTagElement("sinknode", snkNode));
            rowparams.appendChild(createTagElement("snknode", parseInt("0x" + convertIpaddrToHexcode(snkNode))));
            rowparams.appendChild(createTagElement("exp", ct.getAtom("exp", index).getValue()));
            break;
        case NODE_TYPE_EGRESS:
        	var iOptions = ct.getAtom("inboard", index).element.options;
            board = iOptions[iOptions.selectedIndex].value.split("-");
            rowparams.appendChild(createTagElement("inslotid", board[0]));
            rowparams.appendChild(createTagElement("inportname", iOptions[iOptions.selectedIndex].text));
            atom = ct.getAtom("inport", index);
            rowparams.appendChild(createTagElement("inport", atom.getValue()));
            rowparams.appendChild(createTagElement("inlabel", ct.getAtom("inlabel", index).getValue()));
            rowparams.appendChild(createTagElement("outsubslotid", 0));
            var srcNode = ct.getAtom("srcnode", index).getValue();
            rowparams.appendChild(createTagElement("sourcenode", srcNode));
            rowparams.appendChild(createTagElement("srcnode", parseInt("0x" + convertIpaddrToHexcode(srcNode))));
            break;
        default:
            break;
    }
    return rowparams;
}

function doCreateTunnel()
{
    var xml = createTunnelXML();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_ADD_P2PTUNNEL + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, createTunnelCallBack, null, "inputdata=" + xml);
}

function doQueryLSRID()
{
    var xml = createQueryXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMD_MPLSTUNNEL_GET_BSCFG + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

/**
 *        xml
 */
function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    rowparams.appendChild(thirdlevel);
    
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}
function queryCallBack(doc)
{
    var data = EncapsulateData(doc);
    egressSnknode = data.getDataRowParam(0, "lsrId");
}

function createTunnelCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {  	
        tunnelIndex = data.getDataRowParam(0, "tunnelindex");
        if (nodetype == NODE_TYPE_EGRESS)  //   Egress       egressid
       	{
       		doQueryLSRID();
       		egressSrcnode = convertIPStrToLong(ct.getAtom("srcnode", 0).getValue());
       	}
       	refreshData(tunnelIndex, ct.getAtom("tunnelid", 0).getValue());
        xcloseDialog();
    }
}

function refreshData(tunnelIndex, tunnelId)
{
    var tunnel = "";
    var sinkNode = "0.0.0.0";
    var tunnelName = ct.getAtom("tunnelname", 0).getValue();
	if (null == tunnelName || "" == tunnelName) 
	{
	     tunnelName = RESOURCE["null"];
	}
	tunnel = tunnelId + "(" + tunnelName + ")";
	if (nodetype == NODE_TYPE_INGRESS)
	{		    	
	   	 sinkNode = ct.getAtom("snknode", 0).getValue();	    	   
	}
	if (buttonIndex == 0 || buttonIndex == 1) //0,1   Ingress       ID   
	{
		win.$("tunnelindex" + buttonIndex).value = tunnelIndex;
		win.$("selectedtunnel" + buttonIndex).value = tunnel;
		win.pwct.getAtom("oppsitelsrid", buttonIndex).setValue(sinkNode);
	}
	else
	{
		win.$("tunnelindex" + buttonIndex).value = tunnelId; //Egress  tunnelId
		win.$("ingressid" + buttonIndex).value = egressSrcnode;
		win.$("egressid" + buttonIndex).value = egressSnknode;
		win.$("selectedtunnel" + buttonIndex).value = tunnel;
	}
}

function TunnelTable()
{
    this.element = document.createElement("table");
    this.element.appendChild(document.createElement("thead"));
    this.element.appendChild(document.createElement("tbody"));
    this.element.firstChild.appendChild(document.createElement("tr"));
    
    this.attrName = new Object();
    this.attrArray = new Object();
    this.element.className = "attrTable";
    this.addHead = function(head1, head2, head3)
    {
        var th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head1));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head2));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head3));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
    }
    
    this.addAttrRow = function(attrid, attrname, atom1, atom2, text)
    {
        tr = document.createElement("tr");
        td = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(attrname));
        td.appendChild(span);
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom1.element);
        if (text != null) 
        {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom2.element);
        if (text != null) 
        {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        this.element.childNodes[1].appendChild(tr);
        var atomArr = new Object();
        atomArr[0] = atom1;
        atomArr[1] = atom2;
        this.attrArray[attrid] = atomArr;
        this.attrName[attrid] = attrname;
    }
    
    this.getAttrName = function(attrid)
    {
        return this.attrName[attrid];
    }
    
    this.getAttrValue = function(attrid, index)
    {
        return this.attrArray[attrid][index].getValue();
    }
    
    this.setAttrValue = function(attrid, index, value)
    {
        if (this.attrArray[attrid][index]) 
        {
            this.attrArray[attrid][index].setValue(value);
        }
    }
    
    this.getAtom = function(attrid, index)
    {
        if (this.attrArray[attrid][index]) 
        {
            return this.attrArray[attrid][index];
        }
        
    }
    this.getTable = function()
    {
        return this.element;
    }
}

function validateNode(obj)
{
    var stCall = false;
    var nodeType = "";
    if (arguments.length > 1) 
    {
        stCall = arguments[1];
        nodeType = arguments[2];
    }
    
    var oedit = obj;
    oedit.maxLength = maxbyte;
    oedit.style.imeMode = "disabled"; //     
    oedit.onpaste = function()
    {
        return false;
    }
    
    oedit.ondrop = function()
    {
        return false;
    }
    
    oedit.onkeypress = function()
    {
        var event = EventUtil.getEvent();
        var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
        if (code == 8) 
        {
            return true;
        }
        
        var objIp = oedit;
        var existstring = objIp.value;
        var curInput = String.fromCharCode(code);
        if (event.keyCode == 13) 
        {
            objIp.onblur();
        }
        if (((code < 48 || code > 57) && code != splitcharcode) ||
        (code == splitcharcode && existstring.charCodeAt(existstring.length - 1) == splitcharcode) ||
        (code == splitcharcode && existstring.length == 0)) 
        {
            return false;
        }
        
        var tagPosition = digitalTag_getPos(objIp);
        
        var str1 = existstring.substring(0, tagPosition);
        var str2 = existstring.substring(tagPosition, existstring.length);
        existstring = str1 + curInput + str2;
        
        var aryIp = existstring.split(splitchar);
        
        if (aryIp.length > 4) 
        {
            return false;
        }
        
        /* a.b.c.d              .  */
        var dot1 = existstring.indexOf(splitchar);
        var dot2 = existstring.indexOf(splitchar, dot1 + 1);
        var dot3 = existstring.indexOf(splitchar, dot2 + 1);
        var dot4 = existstring.indexOf(splitchar, dot3 + 1);
        
        if (dot1 < 0) 
        {
            if (existstring.length == 3) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > 3 && (selectionLen(ojbIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot2 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length == dot1 + 4) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > dot1 + 4 && (selectionLen(objIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot3 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot2 && existstring.substring(dot1 + 1, dot2).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length == dot2 + 4) 
            {
                objIp.value = existstring + splitchar;
                return false;
            }
            else if (existstring.length > dot2 + 4 && (selectionLen(objIp) == 0)) 
            {
                return false;
            }
        }
        else if (dot4 < 0) 
        {
            tagPosition = digitalTag_getPos(objIp);
            if (tagPosition < dot1 && existstring.substring(0, dot1).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot2 && existstring.substring(dot1 + 1, dot2).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            else if (tagPosition < dot3 && existstring.substring(dot2 + 1, dot3).length > 3 &&
            (selectionLen(objIp) == 0)) 
            {
                return false;
            }
            
            if (existstring.length > maxbyte) 
            {
                if ((selectionLen(objIp) == 0)) 
                {
                    return;
                }
            }
            else if (existstring.length == dot3 + 5) 
            {
                tagPosition = digitalTag_getPos(objIp);
                if (tagPosition > dot3 && (selectionLen(objIp) == 0)) 
                {
                    return;
                }
            }
        }
    }
    
    /**
     *   IP                  255       255
     */
    oedit.onkeyup = function()
    {
        var event = EventUtil.getEvent();
        var objIp = event.srcElement;
        var aryIp = objIp.value.split(splitchar);
        var errFlg = false;
        var i = 0;
        for (i = 0; i < aryIp.length; ++i) 
        {
            if (aryIp[i] != "") 
            {
                aryIp[i] = parseInt(aryIp[i], 10);
            }
            if (aryIp[i] > maxvalue) 
            {
                aryIp[i] = maxvalue;
                errFlg = true;
            }
        }
        if (errFlg) 
        {
            objIp.value = aryIp[0];
            for (i = 1; i < aryIp.length; ++i) 
            {
                objIp.value += (splitchar + aryIp[i]);
            }
        }
    }
    
    oedit.onblur = function()
    {
        var event = EventUtil.getEvent();
        
        var objIp = event.srcElement;
        if (objIp.value == "") 
        {
            alert(RESOURCE["format"]);
            objIp.value = "0.0.0.0";
            if (stCall) 
            {
                cellonblur(objIp);
            }
            ct.getAtom(nodeType, 1).setValue(objIp.value);
            return;
        }
        
        objIp.value = formFullAddr(objIp.value);
        var aryIp = objIp.value.split(splitchar);
        var errFlg = false;
        var i = 0;
        for (i = 0; i < aryIp.length; ++i) 
        {
            if (aryIp[i] > maxvalue) 
            {
                aryIp[i] = maxvalue
                errFlg = true;
            }
        }
        if (errFlg) 
        {
            objIp.value = aryIp[0];
            for (i = 1; i < aryIp.length; ++i) 
            {
                objIp.value += (splitchar + aryIp[i]);
            }
        }
        
        if (stCall) 
        {
            cellonblur(objIp);
        }
        ct.getAtom(nodeType, 1).setValue(objIp.value);
    }
}

function getDataArr()
{
    var opsary = new Array();
    opsary[0] = new Option("1Mbit/s", 1000);
    opsary[1] = new Option("2Mbit/s", 2000);
    opsary[2] = new Option("3Mbit/s", 3000);
    opsary[3] = new Option("4Mbit/s", 4000);
    opsary[4] = new Option("5Mbit/s", 5000);
    opsary[5] = new Option("6Mbit/s", 6000);
    opsary[6] = new Option("7Mbit/s", 7000);
    opsary[7] = new Option("8Mbit/s", 8000);
    opsary[8] = new Option("9Mbit/s", 9000);
    opsary[9] = new Option("10Mbit/s", 10000);
    opsary[10] = new Option("20Mbit/s", 20000);
    opsary[11] = new Option("30Mbit/s", 30000);
    opsary[12] = new Option("40Mbit/s", 40000);
    opsary[13] = new Option("50Mbit/s", 50000);
    opsary[14] = new Option("100Mbit/s", 100000);
    opsary[15] = new Option("1000Mbit/s", 1000000);
    opsary[16] = new Option(RESOURCE["nolimit"], RESOURCE["nolimit"]);
    return opsary;
}

function onblurHandler(event)
{
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value == "") 
    {
        numobj.value = MIN_BANDWIDTH;
        return;
    }
    else if ((isNaN(numobj.value) && numobj.value != RESOURCE["nolimit"]) || numobj.value < MIN_BANDWIDTH) 
    {
        alert(RESOURCE["wrong"]);
        numobj.value = MIN_BANDWIDTH;
        return;
    }
}

function keyupHandler(event)
{
    if (!event) 
    {
        event = window.event;
    }
    var numobj = event.target ? event.target : event.srcElement;
    if (numobj.value > MAX_BANDWIDTH) 
    {
        alert(RESOURCE["wrong"]);
        numobj.value = MAX_BANDWIDTH;
        return;
    }
}

function keypressHandler(event)
{
    var key, keychar;
    if (!event) 
    {
        event = window.event;
        key = window.event.keyCode;
    }
    var numobj = event.target ? event.target : event.srcElement;
    
    var code = (event.keyCode != 0 ? event.keyCode : event.charCode);
    
    if (event.keyCode == 13) 
    {
        if (numobj.value == "") 
        {
            alert(RESOURCE["wrong"]);
            return false;
        }
        event.srcElement.blur();
        return true;
    }
    
    if (code == 8 || code == 46 || code == 37 || code == 39) 
    {
        return true;
    }
    
    if (code < 48 || code > 57) 
    {
        return false;
    }
    window.status = "code:" + code + "; value:" + numobj.value;
    var position = digitalTag_getPos(numobj);
    if (position == 0 && numobj.value.length > 0 && (code == 48 || code == 96)) 
    {
        return false;
    }
    
    if (numobj.value == '0' && position > 0) 
    {
        return false;
    }
    
    keychar = String.fromCharCode(key);
    if (numobj.value + keychar > MAX_BANDWIDTH) 
    {
        alert(RESOURCE["wrong"]);
        numobj.value = MAX_BANDWIDTH;
        return false;
    }
}

