var qinqct = null;
var QinQ_Link_ID_MIN = 1;
var QinQ_Link_ID_MAX = 4294967295;
var qosQinqTable = null;
var SVlan_ID_MIN = 1;
var SVlan_ID_MAX = 4094;
var isSupportQinqQos = false;
var portQinqRes = new Array();
var qinqtab = null;
function initQinq()
{
	isSupportQinqQos = SpecialAttrMgr.isNESupport(neid,
			"TEFUNC_MSTPPLUS_QOS_QINQ_POLICY", "QOS_ATTR_SUPPORT_QINQPOLICY");
	if($("newQinqrd").checked)
	{
		$("selectQinqbtn").disabled = true;
	}else
	{
		$("selectQinqbtn").disabled = false;
	}
	
	if(qinqct == null)
	{
		initQinqTable();
	}
	getQinqResource();
}

function initQinqTable()
{
		qinqct = new CTable();		
		qinqct.addHead(RESOURCE["property"],RESOURCE["value"]);
		
		var atom = new Atom("text");
		qinqct.addAttrRow("qinqlinkid", "QinQ Link ID", atom);
		checkText(atom.element, QinQ_Link_ID_MIN, QinQ_Link_ID_MAX);
		atom.element.onchange = function()
		{
			$("applyqinqbtn").disabled = false;
		}

		atom = new Atom("select");
		qinqct.addAttrRow("qinqboard", RESOURCE["boardspan"]+RESOURCE["port"], atom);
		atom.element.onchange = function()
		{
			$("applyqinqbtn").disabled = false;
		}
		
		atom = new Atom("text");
		qinqct.addAttrRow("qinqsvlanid", "S-Vlan ID", atom);
		checkText(atom.element, SVlan_ID_MIN, SVlan_ID_MAX);
		atom.element.onchange = function()
		{
			$("applyqinqbtn").disabled = false;
		}
		
		$("qinqtb").appendChild(qinqct.getTable());
		if(isSupportQinqQos)
		{
			$("embedqinqtab").style.display = "";
			$("qinqbasictab").appendChild(document.createTextNode(RESOURCE["basicattr"]));
			$("qinqqostab").appendChild(document.createTextNode("QoS"));
			$("qinqbasictab").onclick = function()
			{
				var tabId = this.id;
				setSelectedQinQEmbedTab(tabId);
			}
			$("qinqqostab").onclick = function()
			{
				var tabId = this.id;
				setSelectedQinQEmbedTab(tabId);
			}
			initQoSTableData(window.tableconf[1],"../../../../../../images/");
		}
}

function setSelectedQinQEmbedTab(tabId)
{
	if(tabId == "qinqbasictab")
	{
		$("qosqinqtable").style.display = "none";
		$("qinqtb").style.display = "";
		$("qinqbasictab").className = "tabs_head_select";
		$("qinqqostab").className = "tabs_head";
	}
	else
	{
		$("qinqtb").style.display = "none";
		$("qosqinqtable").style.display = "";
		$("qinqqostab").className = "tabs_head_select";
		$("qinqbasictab").className = "tabs_head";
	}
	
}


function refreshSelect()
{
	if($("newQinqrd").checked)
	{
		$("selectQinqbtn").disabled = true;
		$("applyqinqbtn").disabled = false;
		qinqct.getAtom("qinqlinkid").element.disabled = false;
		qinqct.getAtom("qinqboard").element.disabled = false;
		qinqct.getAtom("qinqsvlanid").element.disabled = false;
	}
	else if($("existQinqrd").checked)
	{
		$("selectQinqbtn").disabled = false;
		$("applyqinqbtn").disabled = true;
		qinqct.getAtom("qinqlinkid").element.disabled = true;
		qinqct.getAtom("qinqboard").element.disabled = true;
		qinqct.getAtom("qinqsvlanid").element.disabled = true;
	}
	$("existQinqtext").value = "";
}

function handleNniSelect()
{
	xshowModalDialog("../eline_u2kv1r3c00/qinqselect.html?flag="+ELINE_SINK, RESOURCE["qinqlinkselect"], 600, 350, "../../../../../../images/");	
}

function getQinqResource()
{
	if(isDemo)
	{
    	loadXMLdoc("portselect_test.xml", "POST", false, handleBackgetPorts, null);
    }
    else
    {
       var xmlstr = createGetQinqPortsXML();
       var urlreq ="../../../../../../neExlorerServlet?sfid="+TE_CMDCODE_PTN_GET_QINQLINK_RES+""+"&nmUser="+ nmUser;
       loadXMLdoc(urlreq, "POST",true,handleQinqBackgetPorts,null,"inputdata="+xmlstr);
    }
}

/**
 * create get ports xml
 */
function createGetQinqPortsXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 * handle get ports result
 */
function handleQinqBackgetPorts(doc)
{	  
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "errObj";
    openErrPage("../../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
        initBoardPortData(data);
        if(portQinqRes.length > 0)
        {
        	createBoardSelect(neid);
        	$("applyqinqbtn").disabled = false;
        }
    }
}

/**
 * init board select
 */
function initBoardPortData(data)
{
    portQinqRes.clear();
    if(data.getDataRowLength() == 0)
    {
    	return;
    }
    var param = data.getDataRowParam(0, "portlist");
    if (null != param) 
    {
        var option = null;
        var options = data.getDataRowOptions(0, "portlist");
        for (var i = 0, m = options.length; i < m; i++) 
        {
            option = options[i];
            portQinqRes[portQinqRes.length] = option;
        }
    }
}
/**
 * create board tree
 */
function createBoardSelect(neid)
{
	var resAtom = qinqct.getAtom("qinqboard").element;
	resAtom.options.length = 0;
	for (var i = 0, len = portQinqRes.length; i < len; i++)
	{
		var tmpArr = portQinqRes[i].split("#");
        var temString = tmpArr[0];
        var slotString = temString.split("-")[0];
        var opt = slotString + "-" + tmpArr[1];
	    resAtom.options[resAtom.options.length]	=	new	Option(temString, opt);
	}
}

function createQinQLink()
{
	var msgQinqArr = new Array()
    var qinqlinkid = qinqct.getAtom("qinqlinkid").getValue();
	if (qinqlinkid != "-" && qinqlinkid == "") 
	{
		msgQinqArr[msgQinqArr.length] = "QinQ Link ID" + RESOURCE["rangemsg"] + "1~4294967295";
	}
	var qinqport = qinqct.getAtom("qinqboard").getValue();
	if (qinqport != "-" && qinqport == "") 
	{
		msgQinqArr[msgQinqArr.length] = RESOURCE["boardspan"]+RESOURCE["port"];
	}
	var qinqvlanid = qinqct.getAtom("qinqsvlanid").getValue();
	if (qinqvlanid != "-" && qinqvlanid == "") 
	{
		msgQinqArr[msgQinqArr.length] = "S-Vlan ID" + RESOURCE["rangemsg"] + "1~4094";
	}
    
    if (msgQinqArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgQinqArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgQinqArr[i];
        }
        alert(msg);
        return ;
    }

	var xml = createNewXml();
	var urlstr = "../../../../../../neExlorerServlet?sfid="+TE_CMDCODE_PTN_ADD_QINQLINK+"&nmUser="+nmUser;
	loadXMLdoc(urlstr, "POST", false, callbackNew,null,"inputdata="+xml);
}

function createNewXml()
{
		var root = new inputxml("datainterface");
		var firstlevel = new tagElement("bussiness-params");
		var secondlevel = new tagElement("row-params");

		var thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "neid");
		thirdlevel.setAttribute("value", neid);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "autolinkid");
		thirdlevel.setAttribute("value", "0");
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "linkid");
		thirdlevel.setAttribute("value", qinqct.getAttrValue("qinqlinkid"));
		secondlevel.appendChild(thirdlevel);
		
		var qinqbdpt = qinqct.getAttrValue("qinqboard").split("-");;
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "slotid");
		thirdlevel.setAttribute("value", qinqbdpt[0]);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "subslotid");
		thirdlevel.setAttribute("value", "255");
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "portid");
		thirdlevel.setAttribute("value", qinqbdpt[1]);
		secondlevel.appendChild(thirdlevel);
		
		thirdlevel = new tagElement("param");
		thirdlevel.setAttribute("name", "svlanid");
		thirdlevel.setAttribute("value", qinqct.getAttrValue("qinqsvlanid"));
		secondlevel.appendChild(thirdlevel);

		firstlevel.appendChild(secondlevel);
		if(isSupportQinqQos)
		{
			appendQosParam(firstlevel,qinqct.getAttrValue("qinqlinkid"));
		}
		root.getRoot().appendChild(firstlevel);
		return root.toString();
}

function callbackNew(doc)
{
		var data = EncapsulateData(doc);
		
		showErrorDialog(data);
		
		if (data.getSErrorCode() == 0)
		{
			$("applyqinqbtn").disabled = true;
			refreshQinQQosTable(window.tableconf[1],data);
    	}
}


function limitVlanInput(obj, minValue, maxValue)
{
    var minvalue = minValue;
    var maxvalue = maxValue;
    
    obj.value = "";
    obj.style.imeMode = "disabled";
    obj.onkeypress = function()
    {
        var evt = window.event;
        return restrictVlan(obj, evt, minvalue, maxvalue);
    };
    obj.onpaste = function()
    {
        var pasteText = window.clipboardData.getData("Text");
        pasteText = obj.value + pasteText;
        return vlanTextCheck(pasteText, minvalue, maxvalue);
        
    };
}

function restrictVlan(field, event, minvalue, maxvalue)
{
    var key, keychar;
    
    key = ((event.keyCode != 0) ? (event.keyCode) : (event.charCode));
    
    keychar = String.fromCharCode(key);
    
    if (event.ctrlKey) 
    {
        if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
        {
            return true;
        }
    }
    if (event.shiftKey) 
    {
        return false;
    }
    if ((key == 8) || (key == 9)) 
    {
        return true;
    }
    
    if ((keychar == '\'') && (key == 39)) 
    {
        return true;
    }
    if ((keychar == '%') && (key == 37)) 
    {
        return true;
    }
    if ((keychar == '&') && (key == 38)) 
    {
        return true;
    }
    if ((keychar == '(') && (key == 40)) 
    {
        return true;
    }
    
    if (keychar == '.' || keychar == '/' || keychar == ';' || keychar == '\'' ||
    keychar == '[' ||
    keychar == ']' ||
    keychar == '\\' ||
    keychar == '=') 
    {
        return false;
    }
    
    if (key > 36 && key < 41) 
    {
        return true;
    }
    
    if ((field.value.length == 0) && ((keychar == ',') || (keychar == '-'))) 
    {
        return false;
    }
    
    if ((field.value.length == 0) && ((keychar >= '0') && (keychar <= '9'))) 
    {
        var tempvalue = 0;
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            tempvalue = key - 48;
        }
        if (tempvalue > maxvalue || tempvalue < minvalue) 
        {
            alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
            return false;
        }
        else 
        {
            return true;
        }
    }
    
    if ((field.value.length != 0) && ((keychar >= '0') && (keychar <= '9') || (keychar == '-') || (keychar == ','))) 
    {
        var tmp = field.value;
        var txtlist = field.value.split(",");
        
        if ((keychar >= '0') && (keychar <= '9')) 
        {
            var pos = digitalTag_getPos(field);
            if (keychar == '0') 
            {
                var val = tmp.substring(0, pos);
                var vArray = val.split(",");
                var value = vArray[vArray.length - 1].split("-");
                if (parseInt(value[value.length - 1]) == 0) 
                {
                    return false;
                }
            }
            var newVal = tmp.substring(0, pos) + keychar + tmp.substring(pos + selectionLen(field));
            var vArr = newVal.split(",");
            for (var i = 0; i < vArr.length; i++) 
            {
                var va = vArr[i].split("-");
                for (var j = 0; j < va.length; j++) 
                {
                    if (parseInt(va[j]) < minvalue || parseInt(va[j]) > maxvalue) 
                    {
                        alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                        return false;
                    }
                }
            }
        }
        if ((keychar == '-') || (keychar == ',')) 
        {
            var currText = txtlist[txtlist.length - 1];
            if (currText == "") 
            {
                return false;
            }
            if ((String.fromCharCode(currText.charCodeAt(currText.length - 1)) == '-') ||
            (String.fromCharCode(currText.charCodeAt(currText.length - 1)) == ',')) 
            {
                return false;
            }
            else 
            {
                if ((currText.indexOf("-") != -1) && (keychar != ',')) 
                {
                    return false;
                }
                else 
                {
                    return true;
                }
            }
        }
        
    }
    else 
    {
        if (event.ctrlKey) 
        {
            if (keychar == 'X' || keychar == 'C' || keychar == 'A' || keychar == 'V') 
            {
                return true;
            }
        }
        else 
        {
            return false;
        }
    }
}



function vlanTextCheck(inputText, limitLow, limitHigh)
{
    for (var i = 0, isize = inputText.length; i < isize; i++) 
    {
        var ch = inputText.charCodeAt(i);
        if (ch < 48 || ch > 57) 
        {
            if ((String.fromCharCode(ch) == "-" || String.fromCharCode(ch) == ",")) 
            {
                continue;
            }
            else 
            {
                return false;
            }
        }
    }
    
    var str = inputText.split(",");
    if (inputText.length == 0) 
    {
        return true;
    }
    
    for (var i = 0; i < str.length; i++) 
    {
        var b = str[i].indexOf("-") != -1;
        if (b) 
        {
            var range = str[i].split("-");
            var rangeStart = parseInt(range[0]);
            var rangeEnd = parseInt(range[1]);
            
            if ((rangeStart > limitHigh) || (rangeEnd > limitHigh) || (rangeStart < limitLow) || (rangeEnd < limitLow)) 
            {
                alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                inputText.value = 1;
                return false;
            }
        }
        else 
        {
            if (parseInt(str[i]) > limitHigh || parseInt(str[i]) < limitLow) 
            {
                alert(RESOURCE["wrong1"] + minvalue + RESOURCE["wrong2"] + maxvalue + RESOURCE["wrong3"]);
                inputText.value = 1;
                return false;
            }
        }
    }
    return true;
}




