var act = null;
var qospwst = null;
var tab = null;

var win = getParentWindow();

var neversion = win.win.neversion;

function init()
{
    initAdvancedTable();
    initPWQoSTableData();
    initUI();
    initTabs();
    
}

function initAdvancedTable()
{
	var pwtype = win.PWType;
    act = new CTable();
    act.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption(RESOURCE["usedfirst"], 2);
    atom.addOption(RESOURCE["nouse"], 1);
	atom.element.options.selectedIndex = 2 - win.controlWord;
    act.addAttrRow("controlword", RESOURCE["controlword"], atom);
    
    atom = new Atom("select");
    atom.addOption("None", "0");
    atom.addOption("CW", "1");
    
    if (compare(neversion, "5.76.01.40") > 0 && compare(neversion, "5.76.01.99") < 0)
    {
        atom.addOption("Alert Label", "2");
    }
    atom.element.options.selectedIndex = win.controlchanneltype;
    act.addAttrRow("controlchanneltype", RESOURCE["controlchanneltype"], atom);
    
    atom = new Atom("select");
    atom.addOption("None", "0");
    atom.addOption("Ping", "1");
    atom.element.options.selectedIndex = win.vccv;
    act.addAttrRow("vccvmode", RESOURCE["vccvmode"], atom);
    
    atom = new Atom("text");
    if(5 == pwtype)
    {
        atom.setValue("-");
    	atom.element.disabled = true;
    }
    else
    {
    	atom.setValue(win.requestVLAN != "-" ? win.requestVLAN : 1);
    }

    
    checkText(atom.element, "1", "4094");
    act.addAttrRow("requestvlan", RESOURCE["requestvlan"], atom);
    
    atom = new Atom("text");
    
    if(5 == pwtype)
    {
        atom.setValue("-");
    	atom.element.disabled = true;
    }
    else
    {
    	atom.setValue(win.tpID != "-" ? win.tpID : 34984);
    }
    
    checkText(atom.element, "1", "65535");
    act.addAttrRow("tpid", "TPID", atom);
    
    $("advance").appendChild(act.getTable());
    
    qospwst = new SortTable();
    qospwst.setImage("../../../../../../images/");
    createTableHead(qospwst, window.tableconf[0]);
    $("stbdiv").appendChild(qospwst.getTable());
    qospwst.setBodyHeight(getComponetHeight($("stbdiv"), 250) + "px");
}


function initPWQoSTableData()
{
    var pwId = 0;
    var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    var tmpPwId = win.pwct.getAtom("pwid").getValue();
	var pwtype = win.PWType;
    if("" != tmpPwId) 
    {
        pwId = tmpPwId;
        var qos = win.qosNni[parseInt(pwId)];
        
        var rowParams = document.createElement("row-params");
        rowParams.appendChild(createParamElement("pwIndex", 0));
        rowParams.appendChild(createParamElement("pwID", tmpPwId));
		rowParams.appendChild(createParamElement("pwType", pwtype));
        rowParams.appendChild(createParamElement("direction", 1));
        rowParams.appendChild(createParamElement("bandwidthlimit", 0));
        rowParams.appendChild(createParamElement("policy", ""));
        rowParams.appendChild(createParamElement("cir", 0));
        rowParams.appendChild(createParamElement("cbs", 0));
        rowParams.appendChild(createParamElement("pir", 0));
        rowParams.appendChild(createParamElement("pbs", 0));
        rowParams.appendChild(createParamElement("exp", (qos != null && qos.exp != null) ? qos.exp : 255));
        rowParams.appendChild(createParamElement("lspmode", ""));
        bparams.appendChild(rowParams);
        
        rowParams = document.createElement("row-params");
        rowParams.appendChild(createParamElement("pwIndex", 0));
        rowParams.appendChild(createParamElement("pwID", tmpPwId));
		rowParams.appendChild(createParamElement("pwType", pwtype));
        rowParams.appendChild(createParamElement("direction", 2));
        rowParams.appendChild(createParamElement("bandwidthlimit", 0));
        rowParams.appendChild(createParamElement("policy", ""));
        rowParams.appendChild(createParamElement("cir", 0));
        rowParams.appendChild(createParamElement("cbs", 0));
        rowParams.appendChild(createParamElement("pir", 0));
        rowParams.appendChild(createParamElement("pbs", 0));
        rowParams.appendChild(createParamElement("exp", ""));
        rowParams.appendChild(createParamElement("lspmode", (qos != null && qos.lspmode != null) ? qos.lspmode : 1));
        bparams.appendChild(rowParams);
    }
    
    di.appendChild(bparams);
    createTableBody(qospwst, window.tableconf[0], EncapsulateData(di), RESOURCE);
    
    for (var j = 0, n = qospwst.getDataRowLength(); j < n; j++) 
    {
        var direction = parseInt(qospwst.getCellStoreValue(j, "direction", "direction"));
        if (direction == INGRESS) // Ingress
        {
            var cell = qospwst.getCell(j, "lspmode");
            qospwst.setCellIsEdit(cell, 0);
            qospwst.getCellShow(j, "lspmode").element.innerHTML = "-";
        }
        else 
        {
            cell = qospwst.getCell(j, "exp");
            qospwst.setCellIsEdit(cell, 0);
            qospwst.getCellShow(j, "exp").element.innerHTML = "-";
        }
    }
}

function initUI()
{
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["advancedattr"], $("tab1div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function doCreateAdvance()
{
	win.controlWord = act.getAtom("controlword").getValue();
	win.controlchanneltype = act.getAtom("controlchanneltype").getValue();
	win.vccv = act.getAtom("vccvmode").getValue();
	win.requestVLAN = act.getAtom("requestvlan").getValue();
	win.tpID = act.getAtom("tpid").getValue();
	
	for (var k = 0, n = qospwst.getDataRowLength(); k < n; k++) 
    {
        if (qospwst.getModify(k)) 
        {
            var pwID = parseInt(qospwst.getCellStoreValue(k, "pwID", "pwID"));
            if (win.qosNni[pwID] == null) 
            {
                win.qosNni[pwID] = new Object();
            }
            if (qospwst.getCellModify(k, "exp")) 
            {
                win.qosNni[pwID].exp = qospwst.getCellStoreValue(k, "exp", "exp");
            }
            if (qospwst.getCellModify(k, "lspmode")) 
            {
                win.qosNni[pwID].lspmode = qospwst.getCellStoreValue(k, "lspmode", "lspmode");
            }
        }
    }
	xcloseDialog();
}
