var st1 = null;
var st2 = null;
var tab = null;
var colorArr = null;

var aclStatus = new Array();
aclStatus[0] = "ID_NULL";
aclStatus[1] = "ID_PERMEIT";
aclStatus[2] = "ID_DENY";
aclStatus[255] = "ID_NULL";

var colorMode = new Array();
colorMode[255] = "none";
colorMode[1] = "color-bind";
colorMode[2] = "color-aware";

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;

var winobj = getNeProperty(self);
var policyType = winobj.policyType;
var policyId = winobj.policyId;

window.onload = function()
{
    initTable();
    initTabs();
    
    $("okbtn").value = RESOURCE["okbutton"];
    
    doQuery();
}

function initPage()
{
    $("okbtn").value = RESOURCE["okbutton"];
}

function initTable()
{
    st1 = new SortTable();
    st1.setImage("../../../../../../images/");
    createTableHead(st1, window.tableconf[0]);
    st1.setOnRowSelectHandler(rowSelectHandler);
    $("policytable").appendChild(st1.getTable());
    st1.setBodyHeight(getComponetHeight($("policytable"), 400) + "px");
    
    st2 = new SortTable();
    st2.setImage("../../../../../../images/");
    createTableHead(st2, window.tableconf[1]);
    $("colortable").appendChild(st2.getTable());
    st2.setBodyHeight(getComponetHeight($("colortable"), 400) + "px");
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tabdiv", RESOURCE["classificationcfg"], $("tabdiv"));
    
    setSelectedEmbedTab("tabdiv");
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function rowSelectHandler()
{
    var index = st1.getSelectedRows()[0];
    var classifierId = st1.getCellStoreValue(index, "classifierId", "classifierId");
    for (var i = 0, m = colorArr.length; i < m; i++) 
    {
        var obj = colorArr[i];
        if (obj.classifierId == classifierId) 
        {
            st2.clearTableData();
            
            var di = document.createElement("datainterface");
            var bparams = document.createElement("bussiness-params");
            
            var rowParams = document.createElement("row-params");
            rowParams.appendChild(createParamElement("packetColor", 1));
            rowParams.appendChild(createParamElement("handleMode", obj.redHandleMethod));
            rowParams.appendChild(createParamElement("relabeledCos", obj.redRemarkCos));
            rowParams.appendChild(createParamElement("relabeledColor", obj.redRemarkColor));
            bparams.appendChild(rowParams);
            
            rowParams = document.createElement("row-params");
            rowParams.appendChild(createParamElement("packetColor", 2));
            rowParams.appendChild(createParamElement("handleMode", obj.yellowHandleMethod));
            rowParams.appendChild(createParamElement("relabeledCos", obj.yellowRemarkCos));
            rowParams.appendChild(createParamElement("relabeledColor", obj.yellowRemarkColor));
            bparams.appendChild(rowParams);
            
            rowParams = document.createElement("row-params");
            rowParams.appendChild(createParamElement("packetColor", 3));
            rowParams.appendChild(createParamElement("handleMode", obj.greenHandleMethod));
            rowParams.appendChild(createParamElement("relabeledCos", obj.greenRemarkCos));
            rowParams.appendChild(createParamElement("relabeledColor", obj.greenRemarkColor));
            bparams.appendChild(rowParams);
            
            di.appendChild(bparams);
            
            createTableBody(st2, window.tableconf[1], EncapsulateData(di), RESOURCE);
            break;
        }
    }
	
	for (var j = 0, n = st2.getDataRowLength(); j < n; j++)
	{
		var handleMode = st2.getCellStoreValue(j, "handleMode", "handleMode");
		if (typeof(handleMode) == "undefined" || "" == handleMode)
		{
			st2.getCellShow(j, "handleMode", "handleMode").element.innerHTML = "-";
		}
		var relabeledCos = st2.getCellStoreValue(j, "relabeledCos", "relabeledCos");
		if (typeof(relabeledCos) == "undefined" || "" == relabeledCos)
		{
			st2.getCellShow(j, "relabeledCos", "relabeledCos").element.innerHTML = "-";
		}
		var relabeledColor = st2.getCellStoreValue(j, "relabeledColor", "relabeledColor");
		if (typeof(relabeledColor) == "undefined" || "" == relabeledColor)
		{
			st2.getCellShow(j, "relabeledColor", "relabeledColor").element.innerHTML = "-";
		}
	}
}

function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    rowparams.appendChild(createTagElement("policyType", policyType));
    rowparams.appendChild(createTagElement("policyId", policyId));
    rowparams.appendChild(createTagElement("classifierId", "0"));
    bussiness.appendChild(rowparams);
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function doQuery()
{
    st1.clearTableData();
			
    var xml = createQueryXml();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_CMDCODE_PTN_QUERY_SPEC_POLICY + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, queryCallBack, null, "inputdata=" + xml);
}

function queryCallBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    
    if (data.getSErrorCode() == 0 || data.getSErrorCode() == 1) 
    {
        colorArr = new Array();
        for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
        {
            var obj = new Object();
            obj.classifierId = data.getDataRowParam(i, "classifierId");
            obj.greenHandleMethod = data.getDataRowParam(i, "handleMethod_green");
            obj.greenRemarkCos = data.getDataRowParam(i, "remarkCos_green");
            obj.greenRemarkColor = data.getDataRowParam(i, "remarkColor_green");
            obj.yellowHandleMethod = data.getDataRowParam(i, "handleMethod_yellow");
            obj.yellowRemarkCos = data.getDataRowParam(i, "remarkCos_yellow");
            obj.yellowRemarkColor = data.getDataRowParam(i, "remarkColor_yellow");
            obj.redHandleMethod = data.getDataRowParam(i, "handleMethod_red");
            obj.redRemarkCos = data.getDataRowParam(i, "remarkCos_red");
            obj.redRemarkColor = data.getDataRowParam(i, "remarkColor_red");
            
            colorArr[colorArr.length] = obj;
        }
        createTableBody(st1, window.tableconf[0], data, RESOURCE);
    }

	for (var j = 0, n = st1.getDataRowLength(); j < n; j++)
	{
		var bandwidthLimit = st1.getCellStoreValue(j, "bandwidthlimit", "bandwidthlimit");

		if (typeof(bandwidthLimit) == "undefined" || "" == bandwidthLimit)
		{
			st1.getCellShow(j, "bandwidthlimit", "bandwidthlimit").element.innerHTML = "-";
			st1.getCellShow(j, "cir", "cir").element.innerHTML = "-";
			st1.getCellShow(j, "pir", "pir").element.innerHTML = "-";
			st1.getCellShow(j, "cbs", "cbs").element.innerHTML = "-";
			st1.getCellShow(j, "pbs", "pbs").element.innerHTML = "-";
			st1.getCellShow(j, "colorMode", "colorMode").element.innerHTML = "-";
		}
	}
    
    if (st1.getDataRowLength() > 0) 
    {
        st1.setRowSelect(0);
    }
    rowSelectHandler();
}
