tab_id_elineuniattri = "elineuniattri";
tab_id_elinenniattri = "elinenniattri";
tab_id_elineqosattri = "elineqosattri";
tab_id_elineporattri = "elineporattri";
tab_id_protectiongroup = "protectiongroupTab";

var UNI_NNI = 1;
var UNI_UNI = 2;
var NNI_NNI = 3;
var N_TRANSBPDU = 0;
var TRANSBPDU = 1;
var USER = 1;
var SERVICE = 2;

var LOAD_TYPE_PW = 1; // PW
var LOAD_TYPE_TUNNEL = 2; // TUNNEL
var LOAD_TYPE_PHY_PORT = 3; // PHY PORT
var LOAD_TYPE_QINQ = 4; // QINQ
var DISABLED = 0; //    
var ENABLED = 1; //   
var INGRESS = 1;
var EGRESS = 2;
var VUNI_INGRESS_POLICY = 2; //     VUNI
var PW_POLICY = 4; //     PW
var LOAD_TYPE_PW = 1; // PW
var LOAD_TYPE_PHY_PORT = 3; // PHY PORT
var INVALID_IP = 0; //   IP  
var INVALID_VALUE = "-"; //       
var INVALID_LABEL_VALUE_1 = 0; //    label 
var INVALID_LABEL_VALUE_2 = 0xFFFFFFFF; //    label 
var DISABLED = 0; //    
var ENABLED = 1; //   
var INGRESS = 1;
var EGRESS = 2;
var VUNI_INGRESS_POLICY = 2; //     VUNI
var PW_POLICY = 4; //     PW

var ELINE_SOURCE = "1";
var ELINE_SINK = "2";

var NO_PROTECT =0;
var PW_APS =1;
var PROTECT_PAIRS =2;

var role = [];
role[1] = "sink";
role[2] = "source";

var pwSignalType = []; // PW    
pwSignalType[1] = "pwSignalType_1";
pwSignalType[2] = "pwSignalType_2";

var pwType = []; // PW  
pwType[4] = "pwType_4"; //   Tag  
pwType[5] = "pwType_5"; //   

var pwDirection = []; //   
pwDirection[0] = "pwDirection_0";
pwDirection[1] = "pwDirection_1";
pwDirection[2] = "pwDirection_2";

var pwEncapsType = [];//PW    
pwEncapsType[1] = "pwEncapsType_1";//MPLS
pwEncapsType[2] = "pwEncapsType_2";//UDP

var enableState = [];//    
enableState[0] = "disabled";//  
enableState[1] = "enabled"//  

var workingStat = [];
workingStat[0] = "workingStat_0";//UP
workingStat[1] = "workingStat_1";//     
workingStat[2] = "workingStat_2";
workingStat[4] = "workingStat_4";
workingStat[6] = "workingStat_6";
workingStat[8] = "workingStat_8";
workingStat[10] = "workingStat_10";
workingStat[12] = "workingStat_12";
workingStat[14] = "workingStat_14";
workingStat[16] = "workingStat_16";
workingStat[18] = "workingStat_18";
workingStat[20] = "workingStat_20";
workingStat[22] = "workingStat_22";
workingStat[24] = "workingStat_24";
workingStat[26] = "workingStat_26";
workingStat[28] = "workingStat_28";
workingStat[30] = "workingStat_30";
workingStat[32] = "workingStat_32";
workingStat[64] = "workingStat_64";

var tunnelType = [];
tunnelType["NSCMD_CFG_MPLS_GET_TUNNEL"] = "MPLS";
tunnelType["NSCMD_CFG_IP_TNL_GET_TUNNEL"] = "IP";
tunnelType["NSCMD_CFG_GRE_TNL_GET_TUNNEL"] = "GRE";

var controlWord = [];//   
controlWord[1] = "controlWord_1";//   
controlWord[2] = "controlWord_2";//    
controlWord[3] = "controlWord_3";//    

var ctrlChanType = [];//      
ctrlChanType[0] = "ctrlChanType_0";//None
ctrlChanType[1] = "ctrlChanType_1";//CW
ctrlChanType[2] = "ctrlChanType_2";//Alert
ctrlChanType[3] = "ctrlChanType_3";//TTL 1

var vccv = [];//VCCV    
vccv[0] = "vccv_0";//None
vccv[1] = "vccv_1";//Ping
vccv[2] = "vccv_2";//BFD

var requestVLAN = [];//  VLAN
requestVLAN[0] = "disabled";//  
requestVLAN[1] = "enabled";//  

var exp = [];
exp[0] = "0";
exp[1] = "1";
exp[2] = "2";
exp[3] = "3";
exp[4] = "4";
exp[5] = "5";
exp[6] = "6";
exp[7] = "7";
exp[255] = "None";
exp[-1] = "-";

var lspMode = [];
lspMode[1] = "Uniform";
lspMode[2] = "Pipe";

var tagFlag = [];
tagFlag[0] = "Access";
tagFlag[1] = "Tag Aware";
tagFlag[2] = "Hybrid";
tagFlag[3] = "No Tag Aware";

var encapType = [];
encapType[0] =	"Null";
encapType[1] =	"802.1Q";
encapType[2] =	"QINQ";

var handleMode = [];
handleMode[1] = "Pass";
handleMode[2] = "Discard";
handleMode[3] = "Remark";

function createTagElement(name, value)
{
    var elem = new tagElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function createParamElement(name, value)
{
    var elem = document.createElement("param");
    elem.setAttribute("name", name);
    elem.setAttribute("value", value);
    return elem;
}

function createQueryXml()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var rowparams = new tagElement("row-params");
    
    rowparams.appendChild(createTagElement("neid", neid));
    bussiness.appendChild(rowparams);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function showErrorDialog(data)
{
    var errArr = [];
    errArr[0] = "nename";
    openErrPage("../../../../../../page/", data.getError(), errArr);
}

/**
 *   IP  
 * @param {Object} param
 */
function convertIP(param)
{
    if (param == INVALID_IP) 
    {
        return INVALID_VALUE;
    }
    
    return convertNumToIpaddr(param);
}

/**
 *               0 0xFFFFFFFF      - 
 * @param {Object} param
 */
function convertLabel(param)
{
    if (param == INVALID_LABEL_VALUE_1 || param == INVALID_LABEL_VALUE_2) 
    {
        return INVALID_VALUE;
    }
    return param;
}

function convertUNI(param)
{
	return "UNI ID:" + param;
}

function convertPrototype(arg)
{
    var tagIds = "";
    if (typeof(arg) != "undefined" && arg != "") 
    {
        var tmpArr = arg.split(",");
        for (var i = 0, m = tmpArr.length; i < m; i++) 
        {
            if (tmpArr[i].indexOf("-") < 0) 
            {
                tagIds += convertHex(tmpArr[i]);
            }
            else 
            {
                var arr = tmpArr[i].split("-");
                for (var j = parseInt(arr[0]); j <= parseInt(arr[1]); j++) 
                {
                    tagIds += convertHex(j);
                }
            }
        }
    }
    return tagIds;
}

function convertHex(arg)
{
    var v = tenToHex(parseInt(arg));
    for (var i = v.length; i < 8; i++) 
    {
        v = "0" + v;
    }
    return v;
}

function checkIntegrality()
{
    var count = 0;
    for (var i = 0, m = sst.getDataRowLength(); i < m; i++) 
    {
        var role = sst.getCellStoreValue(i, "role", "role");
        if (typeof(role) == "undefined" || role == "") 
        {
            alert(RESOURCE["positiontip"]);
            return false;
        }
        else if (parseInt(role) == 1) 
        {
            count++;
            if (count > 1) 
            {
                alert(RESOURCE["numtip"]);
                return false;
            }
        }
    }
    return true;
}
var forwardPriority = new Array();
forwardPriority[1] = "CS7";
forwardPriority[2] = "CS6";
forwardPriority[3] = "EF";
forwardPriority[4] = "AF4";
forwardPriority[5] = "AF3";
forwardPriority[6] = "AF2";
forwardPriority[7] = "AF1";
forwardPriority[8] = "BE";
forwardPriority[255] = "None";

var relabelColor = new Array();
relabelColor[1] = "red";
relabelColor[2] = "yellow";
relabelColor[3] = "green";
relabelColor[255] = "none";

var invalid_char = "";
var service_name_max_len = 64;

/**
 * sort table's row color
 */
var color_select = "#6f99a5";  //dark green
var color_desel = "#ffffff";   //white
var color_nonedit = "#E8E8E8"; //grey
var color_edited = "#d0f946";  //green

var invalid_char ="-";

/**
 * service type
 */
var type_eline_service = 1;  //eline
var type_elan_service = 2;   //elan
var type_etree_service = 3;  //etree not support now
var type_eaggr_service = 4;  //pw policy

var tab_id_port = "port";             //port configuration
var tab_id_qos = "qos";               //qos configuration
var tab_id_statmac = "staticmac";     //static mac address
var tab_id_selflearn = "selflearn";   //self learning mac address
var tab_id_macpara = "maclearnpara";  //mac address learning parameters
var tab_id_split = "splitgroup";      //split horizon group
var tab_id_oam = "oammanagement";     //oam management
var tab_id_unknowframe = "unknowframe"; //unknowframe porcessing
var tab_id_dismac = "disablemac";       //disablemac 

var tab_id_resport = "port";
var tab_id_resqinq = "qinq";
var tab_id_elineRes = "elineRes"; 
var tab_id_elinePara = "elinePara";            
var tab_id_elineQos = "elineQos";     
var tab_id_elineOam = "elineOam";    
var tag_id_elineFwdTable = "elineFwdTable"; 
tab_id_eaggrRes = "eaggrRes";
tab_id_eaggrQos = "eaggrQos";
tab_id_eaggrOam = "eaggrOam";

var isDemo = false;
var error_time_out = 131080;

var usableBoardArr = new Array(); //usable board list

var SERVICETYPE_UNI_NNI = "1";
var SERVICETYPE_UNI_UNI = "2"
var SERVICETYPE_NNI_NNI = "3";


var color_select = "#6f99a5";  //dark green
var color_desel = "#ffffff";   //white
var color_nonedit = "#E8E8E8"; //grey
var color_edited = "#d0f946";  //green

var ELINE_SOURCE = "1";
var ELINE_SINK = "2";

var TYPE_UNI_PORT = "1";
var TYPE_NNI_PORT = "2";

var CURRENT_NNI_TYPE_PORT = "1";
var CURRENT_NNI_TYPE_QINQ = "2";

var SELECTED_NNI_TYPE_PORT = "1";
var SELECTED_NNI_TYPE_QINQ = "2";

var ELINE_INDEX_TEMP_ID1 = "1";
var ELINE_ID_TEMP_ID1 = "2";

var VUNI_TEMP_ID1 = "5";
var VUNI_TEMP_ID2 = "6";
var VNNI_TEMP_ID1 = "7";

var SERVICEID_INDEX = 0;
var SERVICE_NAME_INDEX = 1;
var DIRECTION_INDEX = 2;
var SOURCE_INDEX = 3;
var SOURCE_VLAN_INDEX = 4;
var SOURCE_PORT_INDEX = 5;
var SOURCE_SVLANID_INDEX = 6;
var SINK_INDEX = 7;
var SINK_VLAN_INDEX = 8;
var SINK_PORT_INDEX = 9;
var SINK_SVLANID_INDEX = 10;

/**
 * convert info
 */
var enableStatus = new Array();
enableStatus[0] = "ID_ENABLE";
enableStatus[1] = "ID_DISABLE";

var portEnableStatus = new Array();
portEnableStatus[0] = "ID_DISABLE";
portEnableStatus[1] = "ID_ENABLE";

var directionConvert = new Array();
directionConvert[1] = "ingress";
directionConvert[2] = "egress";

var srcVlanConvert = new Array();
    srcVlanConvert[0] = "1";
    srcVlanConvert[1] = "2";
    
var bpduConvert = new Array();
bpduConvert[0] = "nottransparent";
bpduConvert[1] = "transparentbpdu";

var tagroleConvert = new Array();
tagroleConvert[1] = "User";
tagroleConvert[2] = "Service";

var portTypeConvert = new Array();
portTypeConvert[1] = "VUNIInterface";
portTypeConvert[2] = "VNNIInterface";

var maCCPeriodConvert = new Array();
maCCPeriodConvert[1] = "macc333ms";
maCCPeriodConvert[2] = "macc10ms";
maCCPeriodConvert[3] = "macc100ms";
maCCPeriodConvert[4] = "macc1s";
maCCPeriodConvert[5] = "macc10s";
maCCPeriodConvert[6] = "macc1m";
maCCPeriodConvert[7] = "macc10m";	

var workModeConvert = new Array();
workModeConvert[0] = "autonegotiation";
workModeConvert[1] = "HalfDuplex10M";
workModeConvert[2] = "FullDuplex10M";
workModeConvert[3] = "HalfDuplex100M";
workModeConvert[4] = "FullDuplex100M";
workModeConvert[5] = "HalfDuplex1000M";
workModeConvert[6] = "FullDuplex1000M";
workModeConvert[7] = "FullDuplexLAN10G";
workModeConvert[8] = "FullDuplexWAN10G";
    
var encapConvert = new Array();
encapConvert[0] = "encpTypeNULL";
encapConvert[1] = "encpType8021Q";
encapConvert[2] = "encpTypeQINQ";

var tagConvert = new Array();
tagConvert[0] = "access";
tagConvert[1] = "tagaware";
tagConvert[2] = "hybrid";

var ccStatusConvert = new Array();
ccStatusConvert[0] = "stopstr";
ccStatusConvert[1] = "startstr";

var ltresult = new Array();
ltresult[0] = "success";
ltresult[1] = "failed";

function fillSortTable(st, tc, rows, defVal)
{
    for (var i=0; i<rows; i++)
    {
    	constructRow(st, tc, defVal[i]);
    }
    
    adjustTableLayout(st, tc, rows);
}

function setTabsHeight(tab, tabodyheight)
{
    for(var key in tab.tabNodes)
    {
        tab.tabNodes[key].body.style.height = tabodyheight;
    }
}

function mozillaSort(st, key)
{
    if(!st.element.colsArray.selectedId)
    {
  	   st.element.colsArray.selectedId = key;
  	   st.element.colsArray.imgflag = 1;
    }
    var td = st.element.headRow.element.cols[st.element.colsArray.selectedId].element; 
    st.sortRows(td,st.element.colsArray.imgflag);
}

String.prototype.trim = function()
{
     return this.replace(/(^\s*)|(\s*$)/g, "");
}

function TEUsableBoard()
{    
		this.slotid = null;
		this.boardType = null;
		this.boardName = null;
		this.subslotid = null;
		this.subBoardName = null;
		this.portid = null;
		this.portidArr = null
		this.portName = null;
		this.portNameArr = null;
}


function QinqQosCTable()
{
	this.element = document.createElement("table");
	this.element.cellSpacing = 1;
	this.element.appendChild(document.createElement("thead"));
	this.element.appendChild(document.createElement("tbody"));
	this.element.firstChild.appendChild(document.createElement("tr"));
	
	this.attrArray = new Object();
	this.element.className = "attrTable";
	this.addHead = function(head1,head2,head3)
	{
		var th = document.createElement("td");
		th.style.width = '30%';
		
		var span = document.createElement("span")
		span.appendChild(document.createTextNode(head1));
		th.appendChild(span);
		this.element.firstChild.firstChild.appendChild(th);
		th = document.createElement("td");
		th.style.width = '30%';
		span = document.createElement("span")
		span.appendChild(document.createTextNode(head2));
		th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        
        th = document.createElement("td");
        th.style.width = '30%';
		span = document.createElement("span")
		span.appendChild(document.createTextNode(head3));
		th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
	}

	this.addAttrRow = function(attrid,attrname,atom1,atom2)
	{
		var tr = document.createElement("tr");
		var td = document.createElement("td");
		td.style.width = '30%';
		var span = document.createElement("span");
		span.appendChild(document.createTextNode(attrname));
		td.appendChild(span);
		tr.appendChild(td);
		td = document.createElement("td");
		td.style.width = '30%';
		td.appendChild(atom1.element);
		tr.appendChild(td);
		
		td = document.createElement("td");
		td.style.width = '30%';
		td.appendChild(atom2.element);
		tr.appendChild(td);
		
		var atomList = new Array();
		atomList.push(atom1);
		atomList.push(atom2);	
		this.element.childNodes[1].appendChild(tr);
		this.attrArray[attrid] = atomList;
	}
	
	this.getAttrValue = function(attrid)
	{
		var valueList = new Array();		
		var value1 = this.attrArray[attrid][0].getValue();
		var value2 = this.attrArray[attrid][1].getValue();
		valueList.push(value1);
		valueList.push(value2);
		return valueList;
	}
	
	this.setAttrValue = function(attrid, value1,value2)
	{
		if(this.attrArray[attrid])
		{
			var valueList = new Array();
			valueList.push(value1);
			valueList.push(value2);
			this.attrArray[attrid][0].setValue(value1);
			this.attrArray[attrid][1].setValue(value2);
		}
	}
	
	this.getAtom=function(attrid)
    {
          var atomList = new Array();
          if(this.attrArray[attrid][0] && this.attrArray[attrid][1])
          {
		     atomList.push(this.attrArray[attrid][0]);
		     atomList.push(this.attrArray[attrid][1]);
		     return atomList
		  }
    }
	
	this.getTable = function()
	{
		return this.element;
	}
}

function QinqParam(linkid,port,svlanid)
{
	this.qinqlinkid = linkid;
	this.port = port;
	this.svlanid = svlanid;
	this.ingressQos = null;
	this.egressQos = null;
	this.setQinqLinkID = function(id)
	{
		this.qinqlinkid = id;
	}
	
	this.setPort = function(port)
	{
		this.port = port;
	}
	this.setSvlanID = function(vlanid)
	{
		this.svlanid = vlanid;
	}
	this.setIngressQos= function(ingressQos)
	{
		this.ingressQos = ingressQos;
	}
	this.setEgressQos = function(egressQos)
	{
		this.egressQos = egressQos;
	}
}

function IngressQos(isenable,cir,cbs,pir,pbs,policy)
{
	this.bandwidthEnable = isenable;
	this.cir= cir;;
	this.cbs= cbs;;
	this.pir= pir;;
	this.pbs= pbs;;
	this.policy= policy;;
}

function EgressQos(isenable,cir,cbs,pir,pbs,policy)
{
	this.bandwidthEnable = isenable;
	this.cir= cir;;
	this.cbs= cbs;;
	this.pir= pir;;
	this.pbs= pbs;;
	this.policy= policy;;
}

function constructRow(st, tc, defaultVal)
{
	if(st.element.isAppendEmptyTr)
	{
		 var tBody = st.bodyPack.firstChild.lastChild;
		 tBody.removeChild(tBody.firstChild);
		 st.element.isAppendEmptyTr = false;
	}
	var row = st.createRow();
	var colnum = tc.colArray.length;
	var val;
		
	if (st.editdom == null)
	{
	  	st.editdom = new Array();
	}
	for (var j=0; j<colnum; j++)
	{
		var colid = tc.getColId(j);
		var coledit = tc.getIsEdit(j);
		cell = st.createCell(tc.getColWidth(j));
		atom = st.createAtom("span");
		var conv = tc.getColKeyArray(j)[0].getConvert();
		if (conv)
		{
			val = convertMsg(RESOURCE, eval(conv), defaultVal[j]);
			st.setCellValue(cell, colid, defaultVal[j]);
		}
		else
		{
			val = defaultVal[j];
			st.setCellValue(cell, colid, val);
		}
		atom.setValue(val);
		st.setCellIsEdit(cell, coledit);
		st.addCellShow(cell, atom);
		st.addCell(row, colid, cell);
		
		if (coledit == 1)
		{
			var editType = tc.getColEditType(j);
			atom = st.createAtom(editType);
			if (editType == "select")
			{
				var ops = tc.getColEditOptions(j);
				if(ops.length > 0)
				{
					for(var k=0; k<ops.length; k++)
					{
						atom.addOption(ops[k].getName(), ops[k].getValue());
					}
				}
			}
			atom.element.onclick = stopEventPropagation;
			atom.element.ondblclick = stopEventPropagation;
			st.editdom[colid] = atom;
			var ce = cell.element;
		if(ce.isEdit ==1)
		{
			ce.style.backgroundColor = "#ffffff";
			cell.element.editElement = atom;
			st.addCell(row, colid, cell);
		}
		var cellwidth = tc.getColWidth(j);
		if(cellwidth == "0" || cellwidth == "0px" || cellwidth == "0%")
		{
			cell.element.style.display = "none";
		}
	}
	}
	st.addRow(row);
	return row.element.rowIndex;
		
}

function MDStruct()
{
	this.mdName
	this.mdLevel
}

MDStruct.prototype.setMdName = function(name)
{
	this.mdName = name;
}

MDStruct.prototype.setMdLevel = function(level)
{
	this.mdLevel = level;
}

function CreateTableData()
{
	this.serviceId;
	this.serviceName;
	
	this.source;
	this.sourceVlan;
	this.sourcePort;
	this.sourceSVlanID;
	
	this.sink;
	this.sinkVlan;
	this.sinkPort;
	this.sinkSvlanID;
	
	this.isSourcePort;
	this.isSinkPort;
}

function PortDataStruct(portName,slotid,subslotid,portid)
{
	this.portName = portName;
	this.slotid = slotid;
	this.subslotid = subslotid;
	this.portid = portid;
}

function PortAttriData(portName,slotid,subslotid,portid,portEnable,portWorkMode,portEncapType,tag)
{
	this.portName = portName ;
	this.slotid = slotid ;
	this.subslotid = subslotid;
	this.portid = portid;
	this.portEnable =portEnable;
	this.portWorkMode =portWorkMode;
	this.portEncapType =portEncapType;
	this.tag = tag;
}

function PortData(slotid,subslotid,portid,tagNum,tag)
{
	this.slotid = slotid;
	this.subslotid = subslotid;
	this.portid = portid;
	this.tagNum = tagNum;
	this.tag = tag;
}


function CreateElineServiceDataStruct()
{
   this.tableData = new CreateTableData();
   this.portAttriData = new Array();
   this.QosAttriData = new Array();
}

function editElementRemove(st, row, colid)
{
		var cell = st.getCell(row,colid);
		cell.element.modify = false;
		st.setCellIsEdit(cell,0);
		
		if (!st.getRowSelFlag(row))
		{
				cell.element.style.backgroundColor = "#E8E8E8";
		}
}

function editElementAdd(st, row, colid, type, opts, val)
{
		var cell = st.getCell(row, colid);
		var atom = st.createAtom(type);
		if (type == "select")
		{
				for (var i=0; i<opts.length; i++)
				{
						atom.addOptionObj(opts[i]);
				}
				
				st.setCellValue(cell, colid, opts[val].value);
				cell.element.showElement.setValue(opts[val].text);
		}
		else
		{
				st.setCellValue(cell, colid, "");
				cell.element.showElement.setValue("");
		}
		
		if(cell.element.childNodes.length > 1)
		{
				cell.element.removeChild(cell.element.childNodes[1]);
		}
		
		cell.element.isEdit = 1
		cell.element.childNodes[0].style.color = "#000000";
		cell.element.modify = false;
		cell.element.editElement = atom;
		
		atom.element.onclick = stopEventPropagation;
		atom.element.ondblclick = stopEventPropagation;
		atom.element.style.display = "none";
		
		cell.element.appendChild(atom.element);
		cell.element.style.cursor	=	"pointer";
		cell.element.style.cursor	=	"hand";
		cell.element.ondblclick = ptnCellondbclick;
		
		atom.element.onblur = ptnCellonblur;
}


function ptnCellondbclick()
{
		mozillaComboboxDiv = 0;	

    this.style.backgroundColor = "#d0f946";
    this.modify = true;
    this.parentNode.modify = true;
		this.showElement.element.style.display = "none";
		this.editElement.element.style.display = "";
		
	  handleCellEdit(this,TABLE_CONSTANT.BEFOREEDIT);

		if(this.editElement.type ==	"text")
		{
	    if(this.showElement.getValue() == " ")
		  {
		  	this.editElement.setValue("");
		  }else
		  {
	    	this.editElement.setValue(this.showElement.getValue());
	    }
		    
		    this.appendChild(this.editElement.element);
		    this.editElement.element.select();
		    this.editElement.element.focus();
		}
		else if(this.editElement.type	== "select")
		{
				for(i	=	0; i < this.editElement.element.options.length;	i++)
				{
						if(this.editElement.element.options[i].text	== this.showElement.getValue())
						{
						    this.editElement.element.options[i].selected = true;
						    this.editElement.element.focus();
						}
				}
		}
		else if (this.editElement.type == "combobox")
		{		
			  window.curEditCell = this.editElement.element;
			  
			  var comboObj = this.editElement.element.parent;
			  var eleTd = this.editElement.element.parentNode;
				var eleTable = eleTd.offsetParent;			
				
				var wdt = eleTd.offsetWidth-2;
				var clip = "rect(1px,"+ (wdt-1) + "px,19," + (wdt-18) + "px)";
				
				comboObj.txtview.style.width = wdt;
				comboObj.selview.style.width = wdt;
				comboObj.selview.style.clip = clip;
				
			  if (isIE)
			  {   
					  comboObj.txtview.style.top = getPosY(eleTd) - getPosY(eleTable)+1;
						comboObj.selview.style.top = getPosY(eleTd) - getPosY(eleTable)+1;
				}
				else
				{
						comboObj.txtview.style.position = "fixed";
						
						var theadHeight = eleTable.offsetParent.offsetParent.firstChild.offsetHeight;
		
					  comboObj.txtview.style.top = getPosY(eleTd) - getPosY(eleTable) + theadHeight + 4;
						comboObj.selview.style.top = getPosY(eleTd) - getPosY(eleTable) + theadHeight + 4;
				}
				
				var showVal = this.showElement.getValue();
				var len = comboObj.selview.options.length;
				
				for (var k=0; k<len; k++)
				{
						if (comboObj.selview.options[k].value == showVal
						  || comboObj.selview.options[k].text == showVal)
						{
								comboObj.setSelectedIndex(k);
								comboObj.txtview.focus();
								break;
						}
				}
				
				comboObj.txtview.focus();
		}
}

/*
Onblur handler for editElement of cell 
*/
function ptnCellonblur()
{	
		var hc = this.parentNode.parent.getHeadCell(this.parentNode.colid);
	  
		if(this.parentNode.editElement.type	== "select")
		{
				if(this.selectedIndex	>	-1)
	      {        	
						if("span" == this.parentNode.showElement.type)
						{
						  	this.parentNode.showElement.setValue(this.options[this.selectedIndex].text);	
						}
						else
						{
						  	this.parentNode.showElement.setValue(this.options[this.selectedIndex].value);	
						}
						
						this.parentNode.parent.setTdCellValue(this.parentNode,hc.element.keys[0], this.options[this.selectedIndex].value);
	      }
		}
		else if (this.parentNode.editElement.type == "combobox")
		{
				if (!isIE && mozillaComboboxDiv == 0)
				{
						mozillaComboboxDiv++;
						return;
				}
				
				window.curEditCell = null;
				if ("span" == this.parentNode.showElement.type)
				{
				  	this.parentNode.showElement.setValue(this.parentNode.editElement.element.parent.txtview.value);
				}
				else
				{
				  	this.parentNode.showElement.setValue(this.parentNode.editElement.element.parent.value);
				}
				
				this.parentNode.parent.setTdCellValue(this.parentNode,hc.element.keys[0], this.parentNode.editElement.element.parent.value);
		}
		else
		{
			  this.style.position="static";
		    this.style.border="1px solid #999999";
		    this.style.width=this.parentNode.offsetWidth;   
		    this.parentNode.showElement.element.style.display=""; 
				var rows= this.parentNode.parent.getSelectedRows();
				for(var j=0; j<rows.length; j++)
	      {
	          var cell=  this.parentNode.parent.getCell(rows[j],this.parentNode.colid);	
	          if(null == cell.element.editElement || cell.element.isEdit == 0)
	          {
	          		continue;
	          }	  	
	          cell.element.showElement.setValue(this.value);
	          
	          cell.element.modify = true;
	          cell.element.parentNode.modify = true;
	          cell.element.style.backgroundColor="#d0f946";
	          cell.element.parent.setTdCellValue(cell.element, this.parentNode.colid, this.value);          
	          cell.element.showElement.element.style.display	=	"";
	          handleCellEdit(cell.element,TABLE_CONSTANT.AFTEREDIT); 
	      }
		}
	
		this.style.display = "none";
	  this.parentNode.showElement.element.style.display	=	"";
	  
	  handleCellEdit(this.parentNode,TABLE_CONSTANT.AFTEREDIT);
}

function checkInputData(obj,maxlen)
{
    obj.onkeyup = function()
    {
        return calStrSinoLen(this, maxlen);        
    }
}


function OAMMa(mdIndex,mdName,maIndex,maName,mdLevel,maCCPeriod)
{
	this.mdIndex = mdIndex;
	this.mdName = mdName;
	this.maIndex = maIndex;
	this.maName = maName;
	this.mdLevel = mdLevel;
	this.maCCPeriod = maCCPeriod;
}

function OAMMd(mdIndex,mdName,mdLevel)
{
	this.mdIndex = mdIndex;
	this.mdName = mdName;
	this.mdLevel = mdLevel;
}

function createTagElement(name, value)
{
	var elem = new tagElement("param");
	elem.setAttribute("name", name);
	elem.setAttribute("value", value);
	return elem;
}

/**
 * Get Block Data
 */
function getBlockDataIndex(data,block)
{
	var rowIndex = new Array();
	var flag = 0;
	var eligable = false;
	if(data.getDataRowLength() == 0)
	{
		return rowIndex;
	}
	
	for(var i=0;i<data.getDataRowLength();i++)
	{
		if (eligable)
		{
			if(data.getDataRowParam(i,"block")!= null)
			{
				break;
			}
		}
		else
		{
			if(data.getDataRowParam(i,"block")!="" &&data.getDataRowParam(i,"block")== block)
			{
				eligable = true;
			}
		}
		
		if (eligable)
    	{
    			rowIndex.push(i);
    	}
	}
	
	
	return rowIndex;
}

function validataTagList(tagListString)
{
	if(tagListString == 0)
	{
		return 1;
	}
	var str = tagListString.split(",");
	if (str && str!="")
	{
		var pattern1=new RegExp("^\\d+$","i");
        var pattern2=new RegExp("^\\d+-\\d+$","i");
        for(var i=0; i<str.length; i++)
        {
        	var b=str[i].indexOf("-")!=-1;
        	if(b)
        	{
        		if(!pattern2.test(str[i]))
        		{
        			alert(RESOURCE["inputwrong"]);
        			return -1;
        		}
        	}
        	else
        	{
        			if(!pattern1.test(str[i]))
        			{
        				alert(RESOURCE["inputwrong"]);
        				return -1;
        			}
        	}
        }
        
         for(var i=0; i<str.length; i++)
         {
         	var b=str[i].indexOf("-")!=-1;
         	if(b)
         	{
         		var range=str[i].split("-");
         		var rangeStart=parseInt(range[0]);
         		var rangeEnd=parseInt(range[1]);
         		if (rangeEnd <rangeStart)
         		{
         			alert(RESOURCE["startEnd"]);
         			return -1;
         		}
         	}
         }
	}
	return 1;
}

function getTagListData(str)
{
	var returnValue = new Array(); 
	if(str == 0)
	{
		returnValue[0] = 0;
    	returnValue[1] = "";
    	return returnValue;
	}
	var tempString = str.trim();
	var returnString ="";
    var stringNumber = 0;
    var stringLength = tempString.length;
    if(stringLength == 0)
    {
    	returnValue[0] = 0;
    	returnValue[1] = "";
    	return returnValue;
    }
    
    var str = tempString.split(",");
    for(var i = 0; i < str.length; i++)
    {
    	var b = str[i].indexOf("-")!=-1;
    	if(b)
    	{
    		var range=str[i].split("-");
    		var rangeStart=parseInt(range[0]);
    		var rangeEnd=parseInt(range[1]);
    		if(!(isNaN(rangeStart) || isNaN(rangeEnd)))
    		{
    			var start = parseInt(rangeStart);
                var end = parseInt(rangeEnd);
                if(start > end)
                {
                	var temp = start;
                	start = end;
                	end = temp;
                }
                for(var s1=start;s1<=end;s1++)
                {
                	if(returnString=="")
    			    {
    				  returnString = s1.toString();
    			    }
    			    else
    			    {
                	  returnString = returnString+","+s1.toString();
    			    }
                	stringNumber++;
                }
    		}
    	}
    	else
    	{
    		if(!isNaN(parseInt(str[i])))
    		{
    			stringNumber++;
    			if(returnString=="")
    			{
    				returnString = str[i];
    			}
    			else
    			{
    			    returnString = returnString+","+str[i];
    			}
    		}
    	}
    }
    returnValue[0] = stringNumber;
    returnValue[1] =  returnString;
    return returnValue;
}

function isValidateInput(obj)
{         
   var str;
    if(obj.value != null)
    {
      str=obj.value.split(",");
    }
    else
    {
      str = obj.split(",");
    }
    if ("" != str)
    {    	     
        var pattern1=new RegExp("^\\d+$","i");
        var pattern2=new RegExp("^\\d+-\\d+$","i");
        
        for(var i=0; i<str.length; i++)
        {        
            var b=str[i].indexOf("-")!=-1;
            if(b)
            {
                if( !pattern2.test(str[i]))
                {    
                	  alert(RESOURCE["inputFormat"]);
                	  obj.value = "1";
                	  break;
                }
            }
            else
            {
                if(!pattern1.test(str[i]))
                {
                	  alert(RESOURCE["inputFormat"]);
                	  obj.value = "1";
                	  break;
                }
             }
        }
        
        for(var i=0; i<str.length; i++)
        {
            var b=str[i].indexOf("-")!=-1;
            if(b)
            {
            	  var range=str[i].split("-");
                var rangeStart=parseInt(range[0]);
                var rangeEnd=parseInt(range[1]);
                
                if (rangeEnd <rangeStart)
                {
                	  alert(RESOURCE["startEnd"]);
                	  obj.value = "1";
                	  break;
                }
            }
        }
    }
}


function checkData(obj,event,min,max)
{ 
    var code = event.keyCode!=0?event.keyCode:event.charCode;
    var codeValue = String.fromCharCode(code);	 
    var index = digitalTag_getPos(obj);   
    var lastValue2 = obj.value;
    var thisValue2 = obj.value.substring(0,index) + codeValue + obj.value.substring(index);	
    var rep2 = /-/gi;
    var value2 = thisValue2.replace(rep2,",");
    var values2 = value2.split(",");
    
    var bol2 = chkCVlan(obj,event,min,max);    	
    if(bol2)
    {
          var length = 0;
          var str = thisValue2.split(",");
          for(var i = 0; i < str.length; i++)
          {
               var b = str[i].indexOf("-")!=-1;
               if(b)
               {
                  var range=str[i].split("-");
                  var rangeStart=parseInt(range[0]);
                  var rangeEnd=parseInt(range[1]);
                  if(!(isNaN(rangeStart) || isNaN(rangeEnd)))
                  {
                  length = length+(rangeEnd - rangeStart)+1;
                  }
               }
               else
               {
                   if(!isNaN(parseInt(str[i])))
                   {
                   length = length+1;
                   }
               }
          }
        
          if(length > 4094)
          {
          bol2 = false;
          }
          else
          {
          lastValue2 = thisValue2;
          }
    }
    return bol2;
}

function chkCVlan(obj,event,min,max)
{
	var code=(event.keyCode!=0?event.keyCode:event.charCode);
	var ch = String.fromCharCode(code);
   if(code == 8 || code == 37 || code == 39)
    {
    	return true; 
    }
   
    if(!restrict(obj, event, "0123456789,-"))
    {
        return false;
    }
    
     
    var value=obj.value;
    pos=digitalTag_getPos(obj);                

    var valueArr = value.substring(0,pos).split(",");
    valueArr = valueArr[valueArr.length - 1].split("-");
    if(valueArr[valueArr.length - 1]=='0' && pos>0 && ch != ',' && ch != '-')
    {
        return false;
    }
    
    var newVal = value.substring(0,pos) + ch + value.substring(pos+selectionLen(obj));  
        
    if(!isCVlan(newVal,min,max))
    {
        return false;
    }
    return true;
}

function isCVlan(newVal,min,max)
{         
    var text= newVal;
    
    if(!text || "" == text)
    {
        return true;
    }
    
    var str = text.split(",");
    
    for(var i = 0; i < str.length; i++)
    {
        var b = str[i].indexOf("-")!=-1;
        if(b)
        {
            var range=str[i].split("-");
            var rangeStart=parseInt(range[0]);
            var rangeEnd=parseInt(range[1]);

            if((rangeStart > max) || (rangeEnd > max)
                ||(rangeStart < min) ||(rangeEnd < min))
            {
       	        alert(RESOURCE["wrong1"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong3"]);
                return false;
            }
        }
        else
        {
           if(parseInt(str[i])>max || parseInt(str[i])<min)
           {
           	    alert(RESOURCE["wrong1"] + min + RESOURCE["wrong2"] + max + RESOURCE["wrong3"]);
                return false;
           }
        }
    }
    return true;        
}
function convertInvalidChar(param)
{
    if (null == param || "" == param) 
    {
        return INVALID_VALUE;
    }
    return param;
}


function validataTagList(tagListString)
{
    if (tagListString == 0) 
    {
        return 1;
    }
    var str = tagListString.split(",");
    if (str && str != "") 
    {
        var pattern1 = new RegExp("^\\d+$", "i");
        var pattern2 = new RegExp("^\\d+-\\d+$", "i");
        for (var i = 0; i < str.length; i++) 
        {
            var b = str[i].indexOf("-") != -1;
            if (b) 
            {
                if (!pattern2.test(str[i])) 
                {
                    alert(RESOURCE["inputwrong"]);
                    return -1;
                }
            }
            else 
            {
                if (!pattern1.test(str[i])) 
                {
                    alert(RESOURCE["inputwrong"]);
                    return -1;
                }
            }
        }
        
        for (var i = 0; i < str.length; i++) 
        {
            var b = str[i].indexOf("-") != -1;
            if (b) 
            {
                var range = str[i].split("-");
                var rangeStart = parseInt(range[0]);
                var rangeEnd = parseInt(range[1]);
                if (rangeEnd < rangeStart) 
                {
                    alert(RESOURCE["startEnd"]);
                    return -1;
                }
            }
        }
    }
    return 1;
}

