var ct = null;
var st = null;
var pwct = null;
var tab = null;
var portRes = null;
var pwAdvanceAttr = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var existQinqtext = null;

var qosUni = [];
var qosNni = [];

var OPRSUCC = "0";
var usableSrcBoardArr = new Array(); //usable board list
var usableSnkBoardArr = new Array(); //usable board list

var IPTYPE_USERSET = 1;
var IPTYPE_UNSET = 0xFF;
var enableFlag = [];
enableFlag[0] = RESOURCE["ID_DISABLE"];
enableFlag[1] = RESOURCE["ID_ENABLE"];

var ethportmode = [];
ethportmode[1] =	RESOURCE["level1"];
ethportmode[2] =	RESOURCE["level2"];
ethportmode[3] =	RESOURCE["level3"];
ethportmode[4] =	RESOURCE["level4"];

var encapType = [];
encapType[0] =	"Null";
encapType[1] =	"802.1Q";
encapType[2] =	"QINQ";

var MAX_TAG_NUM = 512;

var workMode = [];
workMode[0] = RESOURCE["autonegotiation"];
workMode[1] = RESOURCE["HalfDuplex10M"];
workMode[2] = RESOURCE["FullDuplex10M"];
workMode[3] = RESOURCE["HalfDuplex100M"];
workMode[4] = RESOURCE["FullDuplex100M"];
workMode[5] = RESOURCE["HalfDuplex1000M"];
workMode[6] = RESOURCE["FullDuplex1000M"];
workMode[7] = RESOURCE["FullDuplexLAN10G"];
workMode[8] = RESOURCE["FullDuplexWAN10G"];
workMode[255] = RESOURCE["negotiating"];
var tagFlag = [];
tagFlag[0] = "Access";
tagFlag[1] = "Tag Aware";
tagFlag[2] = "Hybrid";
tagFlag[3] = "No Tag Aware";

var specify = [];
specify[1] =	RESOURCE["manually"];
specify[255] =	RESOURCE["unspescify"];

var isPortAttrModify=false;
function init()
{
    initTable();
    initTabs();
    initUI();
    getPortRes();
}

function initUI()
{
	$("configqosbtn").value = RESOURCE["configqos"];
	
	
	$("advattrbtn").value = RESOURCE["advancedattr"];
    $("applyqinqbtn").value = RESOURCE["applyqinqbtn"];
    
    
    $("newQinq").innerHTML = RESOURCE["newbtn"];
    $("existQinq").innerHTML = RESOURCE["useexist"];
	if (SYSTEMCONF.getLanguage() == "zh") 
    {
        $("existQinqtd").style.width = "10%";
    }
    $("selectQinqbtn").style.width = "8%";
    $("selectQinqbtn").style.height =  "5%";
    existQinqtext = $("existQinqtext");
	$("newQinqrd").checked = true;
	
	
    $("okbtn").value = RESOURCE["okbutton"];
    $("cancelbtn").value = RESOURCE["cancelbutton"];
    $("applybtn").value = RESOURCE["applybutton"];

}

function initTable()
{
	iniUpCTable();

	initPortTable();
	
    initPWCTable();
}

function initUpDirection()
{
	var atom = new Atom("select");
  atom.addOption("UNI-UNI", UNI_UNI);
  atom.addOption("UNI-NNI", UNI_NNI);
  atom.element.options.selectedIndex = 0;
  atom.element.onchange = changeDirection;
  ct.addAttrRow("direction", RESOURCE["srvcdirection"], atom);
}

function initUpBearerType()
{
	var atom = new Atom("select");
  atom.addOption(RESOURCE["RESPW_VALUE"], LOAD_TYPE_PW);
  atom.addOption(RESOURCE["RESPORT_VALUE"], LOAD_TYPE_PHY_PORT);
  atom.addOption(RESOURCE["RESQINQ_VALUE"], LOAD_TYPE_QINQ);
  atom.element.options.selectedIndex = 0;
  atom.element.onchange = changeBeartype;

  ct.addAttrRow("bearertype", RESOURCE["bearertype"], atom);
  setAtomVisible(atom,false);
}

function iniUpCTable()
{
	ct = new CTable();
    ct.addHead(RESOURCE["property"], RESOURCE["value"]);
    ct.addAttrRow = addMutilAttrRow;
    var atomBox = new Atom("checkbox");
    atomBox.element.id = "isAuto";
 
    atomBox.element.onclick = function()
    {  
     	if ( this.checked )
     	{
     		$("serviceid").disabled = true;
     		$("serviceid").value = "";
        }
     	else
    	{
    		$("serviceid").disabled = false;
    		$("serviceid").value = "";
     	}
    }
    var atom = new Atom("text");
    atom.element.id = "serviceid";
    atom.element.disabled = true;
    atom.element.value = "";
    checkText(atom.element, "1", "4294967294");
    
    
    var atomSpan = new Atom("span");
    atomSpan.element.appendChild(document.createTextNode(RESOURCE["auto"]));
    ct.addAttrRow("serviceid", RESOURCE["serviceid"], atom,atomBox,atomSpan);

    
    atom = new Atom("text");
    atom.element.maxLength = 64;
    ct.addAttrRow("serviceName", RESOURCE["serviceName"], atom);
    
    initUpDirection();
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["nottransparent"], N_TRANSBPDU);
    atom.addOption(RESOURCE["transparentbpdu"], TRANSBPDU);
    atom.element.options.selectedIndex = 0;
    atom.element.onchange = changeBpdu;
    ct.addAttrRow("bpdu", RESOURCE["bpdu"], atom);
    
    atom = new Atom("text");
    atom.element.value = "-";
    checkText(atom.element, "46", "9000");
    atom.element.disabled = true;
    ct.addAttrRow("mtu", "MTU(byte)", atom);
    
    atom = new Atom("select");
    atom.addOption(RESOURCE["user"], USER);
    atom.addOption(RESOURCE["service"], SERVICE);
    atom.element.options.selectedIndex = 0;
    atom.element.disabled = true;
    ct.addAttrRow("servicetagrole", RESOURCE["servicetagrole"], atom);
    
    atom = new Atom("select");
    atom.element.onchange = function()
    {
        boardPortChanged();
    }
    ct.addAttrRow("srcport", RESOURCE["srcport"], atom);
    
    atom = new Atom("text");
    atom.element.style.width = "100%";
    ct.addAttrRow("srcvlan", RESOURCE["srcvlan"], atom);
    limitVlanInput(atom.element, "1", "4094");
    atom = new Atom("text");
    atom.element.style.width = "100%";
    atom.element.value = "-";
    atom.element.disabled = true;
    ct.addAttrRow("prilist", RESOURCE["prilist"], atom);
    setAtomVisible(atom,false);
    
    initUpBearerType();

    
    atom = new Atom("select");
    atom.element.onchange = function()
    {
        boardPortChanged();
    }
    ct.addAttrRow("sinkport", RESOURCE["sinkport"], atom);
    
    atom = new Atom("text");
    atom.element.style.width = "100%";
    ct.addAttrRow("sinkvlan", RESOURCE["sinkvlan"], atom);
    limitVlanInput(atom.element, "1", "4094");
    
     var atom = new Atom("select");
     atom.addOption(RESOURCE["NO_PROTECT"], NO_PROTECT);
     atom.addOption(RESOURCE["PW_APS"], PW_APS);
     atom.addOption(RESOURCE["PROTECT_PAIRS"], PROTECT_PAIRS);
     atom.element.options.selectedIndex = 0;
     atom.element.onchange = changeBeartype;
     ct.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
     setAtomVisible(ct.getAtom("protecttype"),false);
     atom.element.onchange = function()
    {
        changeProtecttype();
    }
    $("tbdiv").appendChild(ct.getTable());
    $("isAuto").checked = true;
}

function setAtomVisible(atom,isvisible)
{
	atom.element.parentNode.parentNode.style.display = (isvisible?"":"none");
}

function cellEditHandler(param)
{
	isPortAttrModify=true;
}
/*
 *        
 */
function initPortTable()
{
    st = new SortTable();
	st.setImage("../../../../../../images/");
    createTableHead(st, window.tableconf[0]);
    st.setOnCellEditHandler(cellEditHandler);
    $("portattrtb").appendChild(st.getTable());
    st.setBodyHeight(getComponetHeight($("portattrtb"), 100) + "px");
    $("portattrtb").oncontextmenu = popupMenuHandler;	
}
function changeBeartype()
{
	var typevalue = parseInt(this.value);
	setAtomVisible(ct.getAtom("sinkport"),(LOAD_TYPE_PHY_PORT == typevalue?true:false));
	tabHeadList["tab3div"].disabled = (LOAD_TYPE_PW == ct.getAtom("bearertype").element.value?false:true);
    switch (typevalue)
    {
        case LOAD_TYPE_PW:

            tabHeadList["tab2div"].style.display = "none"; 
			tabHeadList["tab3div"].style.display = ""; 
			setSelectedEmbedTab("tab3div");
            break;
        case LOAD_TYPE_QINQ:
        	tabHeadList["tab2div"].style.display = ""; 
            tabHeadList["tab3div"].style.display = "none"; 
            setSelectedEmbedTab("tab2div");
            break;
        case LOAD_TYPE_PHY_PORT:
        	tabHeadList["tab2div"].style.display = "none"; 
            tabHeadList["tab3div"].style.display = "";
            setSelectedEmbedTab("tab1div");
            break;
        default:
            break;
    }
    boardPortChanged();
}

function changeBpdu()
{
	var bpduvalue = parseInt(this.value);
	switch (bpduvalue)
    {
    	case N_TRANSBPDU:
			ct.getAtom("srcvlan").element.disabled = false;
			ct.getAtom("sinkvlan").element.disabled = false;
			ct.getAtom("srcvlan").element.value = "";
			ct.getAtom("sinkvlan").element.value = "";
			break;
		case TRANSBPDU:
			ct.getAtom("srcvlan").element.disabled = true;
			ct.getAtom("sinkvlan").element.disabled = true;
			ct.getAtom("srcvlan").element.value = "-";
			ct.getAtom("sinkvlan").element.value = "-";
			break;
		default:
			break;	
	}
}
function changeDirection()
{
	var dirvalue = parseInt(this.value);
	ct.getAtom("bearertype").element.selectedIndex = 0;
	
	tabHeadList["tab3div"].disabled = ((UNI_NNI == dirvalue)&&(LOAD_TYPE_PW == ct.getAtom("bearertype").element.value)?false:true);
	
    switch (dirvalue)
    {
        case UNI_NNI:
            setAtomVisible(ct.getAtom("sinkport"),false);
            setAtomVisible(ct.getAtom("sinkvlan"),false);
            setAtomVisible(ct.getAtom("prilist"),true);
            setAtomVisible(ct.getAtom("bearertype"),true);
						ct.getAtom("servicetagrole").element.disabled = false;
            break;
        case UNI_UNI:
            setAtomVisible(ct.getAtom("sinkport"),true);
            setAtomVisible(ct.getAtom("sinkvlan"),true);
            setAtomVisible(ct.getAtom("prilist"),false);
            setAtomVisible(ct.getAtom("bearertype"),false);
            ct.getAtom("servicetagrole").element.selectedIndex = 0;
            ct.getAtom("servicetagrole").element.disabled = true;
            tabHeadList["tab2div"].style.display = "none"; 
						tabHeadList["tab3div"].style.display = ""; 
            break;
        default:
            break;
    }
    setSelectedEmbedTab("tab1div");
    embedTabSelectHandler(tab.getSelectEmbedTab());
    boardPortChanged();
}

function embedTabSelectHandler(id)
{
    if (id == "tab1div") 
    {
    	/**if(!$("applyportbtn").disabled)
    	{
    		boardPortChanged();
    	}**/
    }
    else if (id == "tab2div") 
    {
        initQinq();
    }
    else if (id == "tab3div") 
    {
    }
}
function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["elineporattri"], $("tab1div"));
	tab.addEmbedTab("tab2div", RESOURCE["RESQINQ_VALUE"], $("tab2div"));
    tab.addEmbedTab("tab3div", RESOURCE["RESPW_VALUE"], $("tab3div"));
    tab.addEmbedTab("tab4div", RESOURCE["PW_PROTECT_GROUP"], $("tab4div"));
    tab.addEmbedTab("tab5div", RESOURCE["PW_PROTECT_GROUP"], $("tab5div"));
	
    setSelectedEmbedTab("tab1div");
    tabHeadList["tab2div"].style.display = "none"; 
    tabHeadList["tab3div"].disabled = true;
    tabHeadList["tab4div"].style.display = "none";
	tabHeadList["tab5div"].style.display = "none";
    $("embedtab").appendChild(tab.getEmbedTabs());
}


/**
 *    PW 
 * @return
 */
function initPWCTable()
{
	pwct = new CTable();
    pwct.addHead(RESOURCE["property"], RESOURCE["value"]);
    pwct.addAttrRow = addMutilAttrRow;
    var atom = new Atom("text");
    checkText(atom.element, "1", "4294967295");
    pwct.addAttrRow("pwid", RESOURCE["pwid"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["static"], "1");
    atom.addOption(RESOURCE["dynamic"], "2");
    atom.element.onchange = changePWSignalType
    pwct.addAttrRow("pwsignaltype", RESOURCE["pwsignaltype"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["ethernet"], "5");
    atom.addOption(RESOURCE["ethernettag"], "4");
    atom.element.onchange = changePWType
    pwct.addAttrRow("pwtype", RESOURCE["pwtype"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["bidirectional"], "1");
    pwct.addAttrRow("direction", RESOURCE["Direction"], atom); 
 
    atom = new Atom("select");
    atom.addOption("MPLS", 1);
    atom.addOption("UDP", 2);
    atom.element.onchange = changeEncapType;
    pwct.addAttrRow("pwencaptype", RESOURCE["pwencaptype"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "16", "1048575");
    pwct.addAttrRow("pwinlabel", RESOURCE["pwinlabel"], atom);
    
    atom = new Atom("text");
    checkText(atom.element, "16", "1048575");
    pwct.addAttrRow("pwoutlabel", RESOURCE["pwoutlabel"], atom);
    
    atom = new Atom("select");
    atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    atom.addOption("GRE", TECMDCODE_PTN_GRETUNNEL_QUERY);
    atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);

	pwct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom);
	
    atom = new Atom("span");
    pwct.addAttrRow("tunnel", "Tunnel", atom);

    var elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "newtunnel";
    elem.onclick = function()
    {
        $("hadtunnel").checked = false;
        this.checked = true;
    }
    atom.element.parentNode.appendChild(elem);
    elem.checked = true;
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["newbtn"];
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "hadtunnel";
    elem.onclick = function()
    {
        $("newtunnel").checked = false;
        this.checked = true;
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["useexist"];
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "selectedtunnel";
    elem.disabled = true;
    if (SYSTEMCONF.getLanguage() == "zh") 
    {
        elem.style.width = "58%";
    }
    else 
    {
        elem.style.width = "30%";
    }
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "tunnelindex";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.onclick = doSelectTunnel;
    atom.element.parentNode.appendChild(elem);
    
    atom = new Atom("text");
    validateIp(atom.element);
    pwct.addAttrRow("oppsitelsrid", RESOURCE["oppsitelsrid"], atom);
    
    $("pwtb").appendChild(pwct.getTable());
    
    $("newtunnel").onclick();
}

/**
 * 
 * @param attrid
 * @param attrname
 * @param atom
 * @param atom1         
 * @param atom2         
 * @return
 */
function addMutilAttrRow(attrid, attrname, atom,atom1,atom2)
{
	atom.element.id=attrid;
    tr = document.createElement("tr");
    td = document.createElement("td");
    span = document.createElement("span");
    span.appendChild(document.createTextNode(attrname));
    td.appendChild(span);
    tr.appendChild(td);
    if(atom1)
    {
        thsecondtd = this.element.childNodes[0].childNodes[0].childNodes[1];
        thsecondtd.colSpan = 2;
        td = document.createElement("td");
        td.style.width = "30%";
        td.appendChild(atom.element);
        tr.appendChild(td);
        td = document.createElement("td");
        td.style.width = "20%";
        td.appendChild(atom1.element);
        if(atom2)
        {
        	td.appendChild(atom2.element);
        	
        }
        tr.appendChild(td);     
    }
    else
    {
        td = document.createElement("td");
        td.style.width = "50%";
        td.appendChild(atom.element);
        td.colSpan = 2;
        tr.appendChild(td);
    }
    this.element.childNodes[1].appendChild(tr);
    this.attrArray[attrid] = atom;
    this.attrName[attrid] = attrname;
}




function setElementisEdit(isEdit)
{
    var atom = tct.getAtom("bandwidth", 0);
    atom.element.parent.selview.disabled = isEdit;
    atom.element.parent.txtview.disabled = isEdit;
    
    atom = tct.getAtom("outlabel", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("outlabel", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("nexthopaddr", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("snknode", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("exp", 0);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("inlabel", 1);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("tunnelid", 0);
    atom.element.disabled = isEdit;
    atom = tct.getAtom("tunnelid", 1);
    atom.element.disabled = isEdit;
    
    atom = tct.getAtom("tunnelname", 0);
    atom.element.disabled = isEdit;
    atom = tct.getAtom("tunnelname", 1);
    atom.element.disabled = isEdit;
	
	atom = ipct.getAtom("staticroute");
	atom.element.disabled = isEdit;
	
	atom = ipct.getAtom("nexthop");
	atom.element.disabled = isEdit;
	
	atom = ipct.getAtom("dstipaddr");
	atom.element.disabled = isEdit;
	
	atom = ipct.getAtom("dstipmask");
	atom.element.disabled = isEdit;
	
	atom = ipct.getAtom("tunnelid");
	atom.element.disabled = isEdit;

}

function changePWSignalType()
{
	var signaltype = parseInt(this.value);
	var pwencaptype = pwct.getAtom("pwencaptype").element;
	var pwinlabel = pwct.getAtom("pwinlabel").element;
	var pwoutlabel = pwct.getAtom("pwoutlabel").element;
	if(1 == signaltype)
	{
		pwencaptype.disabled = false;
		pwinlabel.value = "";
		pwinlabel.disabled = false;
		pwoutlabel.value = "";
		pwoutlabel.disabled = false;
	}
	else if(2 == signaltype)
	{
		pwencaptype.selectedIndex = 0;
		pwencaptype.disabled = true;
		pwinlabel.value = "-";
		pwinlabel.disabled = true;
		pwoutlabel.value = "-";
		pwoutlabel.disabled = true;
	}
	changeRelatedParam(pwencaptype.value);
}

function changeRelatedParam(paramvalue)
{
    var atom = pwct.getAtom("tunneltype");
    atom.clearOptions();

    if (paramvalue == 1) 
    {    
        atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
        atom.addOption("GRE", TECMDCODE_PTN_GRETUNNEL_QUERY);
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
		atom = pwct.getAtom("pwinlabel");
		checkText(atom.element, "16", "1048575");
		atom = pwct.getAtom("pwoutlabel");
		checkText(atom.element, "16", "1048575");
    }
    else 
    {
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
		atom = pwct.getAtom("pwinlabel");
		checkText(atom.element, "49153", "50176");
		atom = pwct.getAtom("pwoutlabel");
		checkText(atom.element, "49153", "50176");
    }
}

function changeEncapType()
{
    var atom = pwct.getAtom("tunneltype");
    atom.clearOptions();
    if (this.value == 1) 
    {    
        atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
        atom.addOption("GRE", TECMDCODE_PTN_GRETUNNEL_QUERY);
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
		atom = pwct.getAtom("pwinlabel");
		atom.setValue("");
		checkText(atom.element, "16", "1048575");
		atom = pwct.getAtom("pwoutlabel");
		atom.setValue("");
		checkText(atom.element, "16", "1048575");
    }
    else 
    {
        atom.addOption("IP", TECMDCODE_PTN_IPTUNNEL_QUERY);
		atom = pwct.getAtom("pwinlabel");
		atom.setValue("");
		checkText(atom.element, "49153", "50176");
		atom = pwct.getAtom("pwoutlabel");
		atom.setValue("");
		checkText(atom.element, "49153", "50176");
    }
}

function getPortRes()
{
    var xml = createGetPortsXML();
    var url = "../../../../../../neExlorerServlet?sfid=" + TE_Q_CMD_IPPTN_GET_L2VPN_RES + "&nmUser=" + nmUser;
    loadXMLdoc(url, "POST", false, portResCallBack, null, "inputdata=" + xml);
}


/**
 * create get ports xml
 */
function createGetPortsXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","ethType");
    param.setAttribute("value","1");//(1:e-line 2:e-lan 3:e-tree)
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","availableType");
    param.setAttribute("value","portResType");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}


function portResCallBack(doc)
{
    portRes = new Array();
    
    var portObj = null;
    var data = EncapsulateData(doc);
    for (var i = 0, m = data.getDataRowLength(); i < m; i++) 
    {
        portObj = new Object();
        portObj.slotId = data.getDataRowParam(i, "slotid");
        portObj.boardName = data.getDataRowParam(i, "boardname");
        portObj.portId = data.getDataRowParam(i, "portid");
        portObj.portName = data.getDataRowParam(i, "portname");
        
        portRes[portRes.length] = portObj;
    }
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
        initSrcBoardPortData(data);
        initSnkBoardPortData(data);
        createSrcBoardSelect(neid)
        createSnkBoardSelect(neid)
        boardPortChanged();
    }
    embedTabSelectHandler(tab.getSelectEmbedTab());
}

/**
 * init board select
 */
function initSrcBoardPortData(data)
{
    usableSrcBoardArr.clear();
    var indexArray = getBlockDataIndex(data,"NSCMD_SERVICE_GET_ETHVUNI_EX");
    for(var i=0,len = indexArray.length;i<len;i++)
    {
    	var usableBd = new TEUsableBoard();
    	usableBd.slotid = data.getDataRowParam(indexArray[i] ,"slotid" );
		usableBd.boardType = data.getDataRowParam(indexArray[i] , "boardType");
		usableBd.boardName = data.getDataRowParam(indexArray[i] , "boardName");
		usableBd.subslotid = data.getDataRowParam(indexArray[i] , "subslotid");
		usableBd.subBoardName = data.getDataRowParam(indexArray[i] , "subBoardName");
		usableBd.portidArr = data.getDataRowOptions(indexArray[i] , "portid");
		usableBd.portNameArr = data.getDataRowOptions(indexArray[i] , "portname");
		if(usableBd.portNameArr)
		{
			usableSrcBoardArr.push(usableBd);
		}
    }
}

function initSnkBoardPortData(data)
{
    usableSnkBoardArr.clear();
    var indexArray = getBlockDataIndex(data, "NSCMD_SERVICE_GET_ETHVUNI_EX");
    for(var i=0,len = indexArray.length;i<len;i++)
    {
    	var usableBd = new TEUsableBoard();
    	usableBd.slotid = data.getDataRowParam(indexArray[i] ,"slotid" );
		usableBd.boardType = data.getDataRowParam(indexArray[i] , "boardType");
		usableBd.boardName = data.getDataRowParam(indexArray[i] , "boardName");
		usableBd.subslotid = data.getDataRowParam(indexArray[i] , "subslotid");
		usableBd.subBoardName = data.getDataRowParam(indexArray[i] , "subBoardName");
		usableBd.portidArr = data.getDataRowOptions(indexArray[i] , "portid");
		usableBd.portNameArr = data.getDataRowOptions(indexArray[i] , "portname");
		if(usableBd.portNameArr)
		{
			usableSnkBoardArr.push(usableBd); 
		}
    }
}
/**
 * create board tree
 */
function createSrcBoardSelect(neid)
{
	var atom = ct.getAtom("srcport");
    atom.clearOptions();
    var temString = "";
	for (var i = 0, len = usableSrcBoardArr.length; i < len; i++)
	{
		for(var j = 0, jlen = usableSrcBoardArr[i].portNameArr.length; j < jlen; j++)
		{
			temString = usableSrcBoardArr[i].slotid + "-" + usableSrcBoardArr[i].boardName + "-" + usableSrcBoardArr[i].portNameArr[j];
	    	atom.addOption(temString, usableSrcBoardArr[i].slotid + "-" + usableSrcBoardArr[i].portidArr[j]);
		}
	}
}

/*
 *     f00177546
 *      2010-01-20
 *         UIN_UNI ELINE              UNI   
 *   UNI_NNI         UNI       PW QLINK      
 *   NNI_NNI              PW QLINK       
 *                  UNI               
 */

function createSnkBoardSelect(neid)
{
	var atom = ct.getAtom("sinkport");
    atom.clearOptions();
    var temString = "";
    /*
	for (var i = 0, len = usableSnkBoardArr.length; i < len; i++)
	{
		for(var j = 0, jlen = usableSnkBoardArr[i].portNameArr.length; j < jlen; j++)
		{
			temString = usableSnkBoardArr[i].slotid + "-" + usableSnkBoardArr[i].boardName + "-" + usableSnkBoardArr[i].portNameArr[j];
	    	atom.addOption(temString, usableSnkBoardArr[i].slotid + "-" + usableSnkBoardArr[i].portidArr[j]);
		}
	}
	*/
    for (var i = 0, len = usableSrcBoardArr.length; i < len; i++)
	{
		for(var j = 0, jlen = usableSrcBoardArr[i].portNameArr.length; j < jlen; j++)
		{
			temString = usableSrcBoardArr[i].slotid + "-" + usableSrcBoardArr[i].boardName + "-" + usableSrcBoardArr[i].portNameArr[j];
	    	atom.addOption(temString, usableSrcBoardArr[i].slotid + "-" + usableSrcBoardArr[i].portidArr[j]);
		}
	}
}

function boardPortChanged()
{
	var direction = ct.getAtom("direction").getValue();
	var xmlData = createGetPortAttriXml(direction);
  	var urlstr = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_GET_ETHPORTATTRIB+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+nmUser;
  	loadXMLdoc(urlstr, "POST", false, callbackGetPortAttri, null, "inputdata="+xmlData);
}

function createGetPortAttriXml(direction)
{
	var srcSlotid = null;
	var srcPortid = null;
	var snkSlotid = null;
	var snkPortid = null;
	
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
	
	var srcAtom = ct.getAtom("srcport").element;
	if(srcAtom.options.length > 0)
	{
		var srcboardport = srcAtom.value.split("-");
		srcSlotid = srcboardport[0];
		srcPortid = srcboardport[1];
		
		param = new tagElement("param");    
	    param.setAttribute("name","slotid");
	    param.setAttribute("value",srcSlotid);
	    row.appendChild(param);
	    
	    param = new tagElement("param");    
	    param.setAttribute("name","port");
	    param.setAttribute("value",srcPortid);
	    row.appendChild(param);
	}
	bussiness.appendChild(row);
	var snkAtom = ct.getAtom("sinkport").element;
	var beartype = ct.getAtom("bearertype").getValue();
	if(((UNI_UNI == direction) || (UNI_NNI == direction && LOAD_TYPE_PHY_PORT == beartype)) && snkAtom.options.length > 0 )
	{
		var snkboardport = snkAtom.value.split("-");
		snkSlotid = snkboardport[0];
		snkPortid = snkboardport[1];
    
	    row = new tagElement("row-params");
	    var param = new tagElement("param");    
	    param.setAttribute("name","neid");
	    param.setAttribute("value",neid);
	    row.appendChild(param);
	    
	    param = new tagElement("param");    
	    param.setAttribute("name","slotid");
	    param.setAttribute("value",snkSlotid);
	    row.appendChild(param);
	    
	    param = new tagElement("param");    
	    param.setAttribute("name","port");
	    param.setAttribute("value",snkPortid);
	    row.appendChild(param);
	    
	    bussiness.appendChild(row);
	}

    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function callbackGetPortAttri(doc)
{
	isPortAttrModify=false;
	st.clearTableData();
	var data = EncapsulateData(doc);
	
	if(0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{
		processData(data);
		
		createTableBody(st, window.tableconf[0], data, RESOURCE);

		addCellEvent();
	}


}


/**
 *              
 * @param data        
 * @return  
 */
function processData(data)
{
	var portNameColid = "PTNIF_PORT_ATTR_PORTNAME";
	for(var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		
        
    if(null != data.getDataRowParam(i, "ATTR_ETHOVERPTN_MAC_TAG"))
    {
    	if(null != data.getDataRowParam(i, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE"))
    	{
				var encapType = data.getDataRowParam(i, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE");//     
				if(encapType == 0)//null  
				{
					data.rows[i]["ATTR_ETHOVERPTN_MAC_TAG"] = "-";
				}     		
    	}
			 	
    }
	}
}


function addCellEvent()
{
	var cell = null;
	for(var i = 0,len = st.getDataRowLength();i<len;i++)
	{

		cell = st.getCell(i,"SDHPORT_ATTR_MODE");
		if(null != cell)
		{
			var encaptype = "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE";	
			var modevalue = st.getCellStoreValue(i,"SDHPORT_ATTR_MODE","SDHPORT_ATTR_MODE");
			if(3 == modevalue)
			{
				if(st.getCell(i,encaptype))
				{
					st.setCellIsEdit(st.getCell(i,encaptype),0);
					st.getCell(i,encaptype).element.ondblclick = null;
				}
			}
			tagCellEvent(cell);
		}	
		
		/**
		 *       TRANSV1R5-1148 
		 *     f00177546
		 *              UNI   ,        Tag      
		 * @param rowindex
		 * @param value
		 * @return
		 */
		cell = st.getCell(i,"ATTR_ETHOVERPTN_MAC_ENCAP_TYPE");
		if(null != cell)
		{			
			encapTypeCellEvent(cell);
		}	
		
		cell = st.getCell(i,"ATTR_ETHOVERPTN_MAC_WORKMODE");
		if (null != cell && cell.element.isEdit == 1)
		{
			var cellEdit = st.getCellEdit(i,"ATTR_ETHOVERPTN_MAC_WORKMODE");
			if (null != cellEdit)
			{
					cellEdit.clearOptions();
					cellEdit.addOption(RESOURCE["autonegotiation"], "0");
					cellEdit.addOption(RESOURCE["HalfDuplex10M"], "1");
					cellEdit.addOption(RESOURCE["FullDuplex10M"], "2");
					cellEdit.addOption(RESOURCE["HalfDuplex100M"], "3");
					cellEdit.addOption(RESOURCE["FullDuplex100M"], "4");
					cellEdit.addOption(RESOURCE["HalfDuplex1000M"], "5");
					cellEdit.addOption(RESOURCE["FullDuplex1000M"], "6");
					cellEdit.addOption(RESOURCE["FullDuplexLAN10G"], "7");
					cellEdit.addOption(RESOURCE["FullDuplexWAN10G"], "8");
			}
		}
	
		cell = st.getCell(i,"ATTR_ETHOVERPTN_MAC_QINQ_TYPE");	
		 if(null != cell)
		 {
		 	var encapType = st.getCellStoreValue(i,"ATTR_ETHOVERPTN_MAC_ENCAP_TYPE","ATTR_ETHOVERPTN_MAC_ENCAP_TYPE");
		 	var tagcell = st.getCell(i,"ATTR_ETHOVERPTN_MAC_TAG");	
		 	
		 	if(2 != encapType)
		 	{
		 		st.setCellIsEdit(cell,0);
				cell.element.ondblclick = null;
		 	}
		 	else
		 	{
				st.setCellIsEdit(tagcell,0);
				tagcell.element.ondblclick = null;
		 		qinqCellEvent(cell);
		 	}
		 }	
		var modevalue = st.getCellStoreValue(i,"SDHPORT_ATTR_MODE","SDHPORT_ATTR_MODE");
		if(3 != modevalue)
		{
			if(st.getCell(i,"ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS"))
			{
				st.setCellIsEdit(st.getCell(i,"ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS"),0);
				st.getCellShow(i, "ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS").element.innerHTML = "-";
				st.getCell(i,"ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS").element.ondblclick = null;
			}
		}
	
		 cell = st.getCell(i,"ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS");	
		 if(null!= cell)
		 {
		 	var ipSpecify = st.getCellCurrentValue(i, "ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS", "ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS");
		 	if (IPTYPE_UNSET == ipSpecify) 
            {
	            var cell = st.getCell(i, "ATTR_ETHOVERPTN_MAC_IPADDRESS");
	            st.setCellIsEdit(cell, 0);
	            st.getCellShow(i, "ATTR_ETHOVERPTN_MAC_IPADDRESS").element.innerHTML = "-";
	            
	            cell = st.getCell(i, "ATTR_ETHOVERPTN_MAC_IPMARSK");
	            st.setCellIsEdit(cell, 0);
	            st.getCellShow(i, "ATTR_ETHOVERPTN_MAC_IPMARSK").element.innerHTML = "-";
            }
		 }
		 
        cell = st.getCellEdit(i, "ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS");
		if(null != cell)
		{
			cell.element.onchange = changeIpSpecify;
	        
	        validateIp(st.getCellEdit(i, "ATTR_ETHOVERPTN_MAC_IPADDRESS").element, true);
	        validateIp(st.getCellEdit(i, "ATTR_ETHOVERPTN_MAC_IPMARSK").element, true);
		}
        
	}		
}

/**
 *       TRANSV1R5-1148 
 *     f00177546
 *              UNI   ,        Tag      
 * @param rowindex
 * @param value
 * @return
 */

function encapTypeCellEvent(cell)
{
	var atom = cell.element.editElement;
	atom.element["onchange"] = function()
	{
		encapTypeCellEditHandler(this);
	}
} 


function encapTypeCellEditHandler(atom)
{
	var rowindex = atom.parentNode.parentNode.rowIndex;
	var value = atom.value;
	 
	var encapType = st.getCellStoreValue(rowindex,"ATTR_ETHOVERPTN_MAC_ENCAP_TYPE","ATTR_ETHOVERPTN_MAC_ENCAP_TYPE");
	if(typeof(value) != "undefined" && value != null)
	{
		encapType = value;
	}
	
	var tagidCell = st.getCell(rowindex,"ATTR_ETHOVERPTN_MAC_TAG");	
	if(encapType == "1")//802.1Q
		{
			if(tagidCell.element.isEdit != "1")
			{
				st.setCellIsEdit(tagidCell,"1");
				st.setCellValue(tagidCell,"1");
				st.getCellShow(rowindex,"ATTR_ETHOVERPTN_MAC_TAG").setValue("Tag Aware");			
			
			}
		}
		else if(encapType == "0")//none
		{
			if(tagidCell.element.isEdit != "0")
			{
				st.setCellIsEdit(tagidCell,"0");
			}
			st.setCellValue(tagidCell,"-");
			st.getCellShow(rowindex,"ATTR_ETHOVERPTN_MAC_TAG").setValue("-");		
		
		}
		else
		{
			if(tagidCell.element.isEdit != "0")
			{
				st.setCellIsEdit(tagidCell,"0");
			}
			st.setCellValue(tagidCell,"1");
			st.getCellShow(rowindex,"ATTR_ETHOVERPTN_MAC_TAG").setValue("Tag Aware");			
		
		}
}


function changeIpSpecify()
{				
	var rowIndex = this.parentNode.parentNode.rowIndex;
	var ipSpecify = parseInt(this.value);
	if (IPTYPE_UNSET == ipSpecify) 
	{
	    cell = st.getCell(rowIndex, "ATTR_ETHOVERPTN_MAC_IPADDRESS");
	    st.setCellIsEdit(cell, 0);
		st.setCellValue(cell, "ATTR_ETHOVERPTN_MAC_IPADDRESS", "255.255.255.255");
	    st.getCellShow(rowIndex, "ATTR_ETHOVERPTN_MAC_IPADDRESS").element.innerHTML = "-";
	    
	    cell = st.getCell(rowIndex, "ATTR_ETHOVERPTN_MAC_IPMARSK");
	    st.setCellIsEdit(cell, 0);
		st.setCellValue(cell, "ATTR_ETHOVERPTN_MAC_IPMARSK", "255.255.255.255");
	    st.getCellShow(rowIndex, "ATTR_ETHOVERPTN_MAC_IPMARSK").element.innerHTML = "-";
	}
	else 
	{
	    cell = st.getCell(rowIndex, "ATTR_ETHOVERPTN_MAC_IPADDRESS");
	    st.setCellIsEdit(cell, 1);
		st.setCellValue(cell, "ATTR_ETHOVERPTN_MAC_IPADDRESS", "0.0.0.0");
	    st.getCellShow(rowIndex, "ATTR_ETHOVERPTN_MAC_IPADDRESS").element.innerHTML = "0.0.0.0";
	    
	    cell = st.getCell(rowIndex, "ATTR_ETHOVERPTN_MAC_IPMARSK");
	    st.setCellIsEdit(cell, 1);
		st.setCellValue(cell, "ATTR_ETHOVERPTN_MAC_IPMARSK", "255.255.255.252");
	    st.getCellShow(rowIndex, "ATTR_ETHOVERPTN_MAC_IPMARSK").element.innerHTML = "255.255.255.252";
	}
}

/**
 * TAG       
 * @param cell    
 * @return  
 */
function tagCellEvent(cell)
{
	var atom = cell.element.editElement;
	atom.element["onchange"] = function()
	{
		tabCellEditHandler(this);
	}
}

/**
 *             
 * @param  
 * @return  
 */
function tabCellEditHandler(atom)
{
	var rowindex = atom.parentNode.parentNode.rowIndex;
	var colid = atom.parentNode.colid;
	var value = atom.value;

  	var encaptype = "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE";	
  	var ipspecify = "ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS";
  	var ipmac = "ATTR_ETHOVERPTN_MAC_IPADDRESS";
  	var ipmask = "ATTR_ETHOVERPTN_MAC_IPMARSK";
	if("SDHPORT_ATTR_MODE" == colid)
	{
		if(value == 3)
		{
				st.setCellValue(st.getCell(rowindex,encaptype),encaptype,1);
				st.setAtomValue(st.getCell(rowindex,encaptype).element.showElement,"802.1Q");
				

				st.getCell(rowindex,encaptype).element.style.backgroundColor = "";
				
				st.setCellIsEdit(st.getCell(rowindex,encaptype),0);
				st.getCell(rowindex,encaptype).element.ondblclick = null;
				st.setCellValue(st.getCell(rowindex,ipspecify),ipspecify,255);
				st.setAtomValue(st.getCell(rowindex,ipspecify).element.showElement,RESOURCE["unspescify"]);
				

				st.getCell(rowindex,ipspecify).element.style.backgroundColor = "";
				
				st.setCellIsEdit(st.getCell(rowindex,ipspecify),1);
				st.getCell(rowindex,ipspecify).element.ondblclick = cellondbclick;
				
			}
			else //        
			{
				st.setCellIsEdit(st.getCell(rowindex,encaptype),1);
				st.getCell(rowindex,encaptype).element.ondblclick = cellondbclick;
				
				st.setCellIsEdit(st.getCell(rowindex,ipspecify),0);
				st.setCellValue(st.getCell(rowindex,ipspecify),ipspecify,IPTYPE_UNSET);
				st.setAtomValue(st.getCell(rowindex,ipspecify).element.showElement,"-");
				st.getCell(rowindex,ipspecify).element.ondblclick = null;	
				
				cell = st.getCell(rowindex, ipmac);
	            st.setCellIsEdit(cell, 0);
				st.setCellValue(cell, ipmac, "255.255.255.255");
	            st.getCellShow(rowindex, ipmac).element.innerHTML = "-";
	                
	            cell = st.getCell(rowindex, ipmask);
	            st.setCellIsEdit(cell, 0);
				st.setCellValue(cell, ipmask, "255.255.255.255");
	            st.getCellShow(rowindex, ipmask).element.innerHTML = "-";
			}
	}
	
}

function convertPortName(port, portName)
{
    if (!portName || portName == "") 
    {
        portName = RESOURCE["port"] + "-" + port;
    }
    return port + "(" + portName + ")";
}

function doApplyPortAttr()
{
	if(isPortAttrModify)
	{
        var xmlData = createSetPortAttriXml();
        var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_ETHPORTATTRIB + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + nmUser;
        loadXMLdoc(urlstr, "POST", false, callbackSetPortAttri, null, "inputdata=" + xmlData);
		return !isPortAttrModify;
		
	}
	return true;
}

/**
 *          XML  
 * @param neid:  ID slotid:  ID tc:        
 * @return String:       XML  
 */
function createSetPortAttriXml()
{

  var root = new inputxml("datainterface");
  var business = new tagElement("bussiness-params");
  var row;
  var param;
  
  var length = st.getDataRowLength(); 
  for(var i=0;i<length;i++)
  {
  	if(!st.getModify(i))
    {
    	continue;
    }
  	row = new tagElement("row-params");
  	
  	param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
      
  	param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", st.getCellStoreValue(i,"slotid","slotid"));
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "port");
    param.setAttribute("value", st.getCellStoreValue(i,"port","port"));
    row.appendChild(param);
    
    if(st.getCellModify(i,"ATTR_ETHOVERPTN_MAC_ENABLE"))
    {
    	param = new tagElement("param");
	    param.setAttribute("name", "ATTR_ETHOVERPTN_MAC_ENABLE");
	    param.setAttribute("value", st.getCellStoreValue(i,"ATTR_ETHOVERPTN_MAC_ENABLE","ATTR_ETHOVERPTN_MAC_ENABLE"));
	    row.appendChild(param);
    }
    if(st.getCellModify(i,"SDHPORT_ATTR_MODE"))
    {
    	param = new tagElement("param");
	    param.setAttribute("name", "SDHPORT_ATTR_MODE");
	    param.setAttribute("value", st.getCellStoreValue(i,"SDHPORT_ATTR_MODE","SDHPORT_ATTR_MODE"));
	    row.appendChild(param);
    }
    if(st.getCellModify(i,"ATTR_ETHOVERPTN_MAC_ENCAP_TYPE"))
    {
    	param = new tagElement("param");
	    param.setAttribute("name", "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE");
	    param.setAttribute("value", st.getCellStoreValue(i,"ATTR_ETHOVERPTN_MAC_ENCAP_TYPE","ATTR_ETHOVERPTN_MAC_ENCAP_TYPE"));
	    row.appendChild(param);
    }
    if(st.getCellModify(i,"ATTR_ETHOVERPTN_MAC_WORKMODE"))
    {
    	param = new tagElement("param");
	    param.setAttribute("name", "ATTR_ETHOVERPTN_MAC_WORKMODE");
	    param.setAttribute("value", st.getCellStoreValue(i,"ATTR_ETHOVERPTN_MAC_WORKMODE","ATTR_ETHOVERPTN_MAC_WORKMODE"));
	    row.appendChild(param);
    }
    if(st.getCellModify(i,"ATTR_ETHOVERPTN_MAC_TAG"))
    {
    	param = new tagElement("param");
	    param.setAttribute("name", "ATTR_ETHOVERPTN_MAC_TAG");
	    param.setAttribute("value", st.getCellStoreValue(i,"ATTR_ETHOVERPTN_MAC_TAG","ATTR_ETHOVERPTN_MAC_TAG"));
	    row.appendChild(param);
    }
    
    if(st.getCellModify(i,"ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS")
       || st.getCellModify(i,"ATTR_ETHOVERPTN_MAC_IPADDRESS")
       || st.getCellModify(i,"ATTR_ETHOVERPTN_MAC_IPMARSK")
       || st.getCellModify(i,"ATTR_ETHOVERPTN_MAC_BORROWEDBOARDIPADDR")
       || st.getCellModify(i,"ATTR_ETHOVERPTN_MAC_BORROWEDPORTIPADDR")
    )
    {
		var ipType = parseInt(st.getCellCurrentValue(i, "ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS", "ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS"));
    	param = new tagElement("param");
	    param.setAttribute("name", "ATTR_ETHOVERPTN_MAC_SPECIFYIPADDRESS");
	    param.setAttribute("value",ipType == IPTYPE_UNSET ? IPTYPE_USERSET : ipType);
    	row.appendChild(param);
    	
    	var ip = st.getCellCurrentValue(i, "ATTR_ETHOVERPTN_MAC_IPADDRESS", "ATTR_ETHOVERPTN_MAC_IPADDRESS");
    	var ipvalue = parseInt("0x" + convertIpaddrToHexcode(ip));
    	param = new tagElement("param");
	    param.setAttribute("name", "ATTR_ETHOVERPTN_MAC_IPADDRESS");
	    param.setAttribute("value",ipvalue);
    	row.appendChild(param);
    	
    	var ipmask = st.getCellCurrentValue(i, "ATTR_ETHOVERPTN_MAC_IPMARSK", "ATTR_ETHOVERPTN_MAC_IPMARSK");
    	var ipmaskvalue = parseInt("0x" + convertIpaddrToHexcode(ipmask));
    	param = new tagElement("param");
	    param.setAttribute("name", "ATTR_ETHOVERPTN_MAC_IPMARSK");
	    param.setAttribute("value",ipmaskvalue);
    	row.appendChild(param);
    	
    	var ipborrowedbd = st.getCellCurrentValue(i, "ATTR_ETHOVERPTN_MAC_BORROWEDBOARDIPADDR", "ATTR_ETHOVERPTN_MAC_BORROWEDBOARDIPADDR");
    	param = new tagElement("param");
	    param.setAttribute("name", "ATTR_ETHOVERPTN_MAC_BORROWEDBOARDIPADDR");
	    param.setAttribute("value",ipborrowedbd);
    	row.appendChild(param);
    				
    	var ipborrowedpt = parseInt(st.getCellCurrentValue(i, "ATTR_ETHOVERPTN_MAC_BORROWEDPORTIPADDR", "ATTR_ETHOVERPTN_MAC_BORROWEDPORTIPADDR"));
    	param = new tagElement("param");
	    param.setAttribute("name", "ATTR_ETHOVERPTN_MAC_BORROWEDPORTIPADDR");
	    param.setAttribute("value",ipborrowedpt);
    	row.appendChild(param);			
    }

    business.appendChild(row);
  }
  root.getRoot().appendChild(business);
  return root.toString();
}


function callbackSetPortAttri(doc)
{
	var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	
	showErrorDialog(data);
	if(0 == errorCode) 
	{
		refreshTableState(st,window.tableconf[0],data);
		isPortAttrModify=false;
	}
	else
	{
        isPortAttrModify=true;
	}
}

/**
 *     f00177546
 *      2010-01-20
 *      *   UNI_NNI               Vlan    512          250 Vlan ELINE
 *      U2000     U2000   Vlan    512     "        " 
 *                       512                        
 */
function validateVlans(vlans)
{
	var tagList = getTagListData(vlans);
	return (tagList[0] > MAX_TAG_NUM) ? false : true;
}


function createEline(isclose)
{
	/*
	var direction = ct.getAtom("direction").getValue();
	if(direction == UNI_UNI)
	{
		if(!validateVlans($("srcvlan").value) || !validateVlans($("sinkvlan").value))
		{
			alert(RESOURCE["vlanOutOfRange"]);
			return;
		}
	}
	if(direction == UNI_NNI)
	{
		if(!validateVlans($("srcvlan").value))
		{
			alert(RESOURCE["vlanOutOfRange"]);
			return;
		}
	}
	*/
	
    if (doApplyPortAttr()) 
    {
	if((isclose == true && $("applybtn").disabled == true))
	{
		window.close();
		return;
	}
	var xmlData = createElineXml();
	if(xmlData == null)
	{
		return;
	}
	var urlstr = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IP_EVPL_CREATE+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+nmUser;
	loadXMLdoc(urlstr, "POST", false, callbackCreateEline, isclose, "inputdata="+xmlData);
    }
    
}

function createElineXml()
{
  if(!validateParams())
  {
	 return null;
  }
  var root = new inputxml("datainterface");
  var business = new tagElement("bussiness-params");
  var row,param;
  createEthXML(business); 
  createVuniVnniXML(business);
  root.getRoot().appendChild(business);
 
  return root.toString();
}

function callbackCreateEline(doc,param)
{
	var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	if(0 == errorCode) 
	{
        $("applybtn").disabled = true;
		win.queryELine();
		if(param==true)
		{
			window.close();
		}		
	}
	else
	{
		showErrorDialog(data);
	}
}

function createEthXML(business)
{
	var fstRow = new tagElement("row-params");
    
  param = new tagElement("param");    
  param.setAttribute("name", "neid");
  param.setAttribute("value", neid);
  fstRow.appendChild(param);
  
  
  param = new tagElement("param");
  param.setAttribute("name", "serviceIndex");
  param.setAttribute("value", "1");
  fstRow.appendChild(param);
  
  if (!$("isAuto").checked)
  {
  	  fstRow.appendChild(createTagElement("serviceID", $("serviceid").value));
  }
  else
  {
  	  fstRow.appendChild(createTagElement("isAuto", "1"));
  }
  
  var serviceName = ct.getAtom("serviceName").element.value; 
  param = new tagElement("param");
  param.setAttribute("name", "serviceName");
  param.setAttribute("value", serviceName);
  fstRow.appendChild(param);
  
  var direction = ct.getAtom("direction").element.value; 
  param = new tagElement("param");
  param.setAttribute("name", "direct");
  param.setAttribute("value", direction);//ELine
  fstRow.appendChild(param);  

    var servicetagrole = ct.getAtom("servicetagrole").element.value;
    param = new tagElement("param");
    param.setAttribute("name", "servicetagrole");
    param.setAttribute("value", servicetagrole);//ELine
    fstRow.appendChild(param);
  var bpdu = ct.getAtom("bpdu").element.value; 
  param = new tagElement("param");
  param.setAttribute("name", "bpdu");
  param.setAttribute("value", bpdu);//ELine
  fstRow.appendChild(param);
  
  var mtu = ct.getAtom("mtu").element.value; 
  param = new tagElement("param");
  param.setAttribute("name", "mtu");
  param.setAttribute("value", mtu);//ELine
  fstRow.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "ethType");
  param.setAttribute("value", "1");//ELine
  fstRow.appendChild(param);
  
  business.appendChild(fstRow);
}


function createVuniVnniXML(business)
{
	var sevdirection = ct.getAtom("direction").element.value;
	var beartype = ct.getAttrValue("bearertype");
	if(sevdirection == SERVICETYPE_UNI_NNI)
  {
  	var portData = getPortAttriByDirect(ELINE_SOURCE);
  	var row = constructUniRow(portData.slotid,portData.subslotid,portData.portid,portData.tagNum,portData.tag);
  	business.appendChild(row);
  	
  	if(LOAD_TYPE_PW == beartype)
  	{
  		row = constructPwRow("1",0xffffffff,0xffffffff,0);
  		business.appendChild(row);
  	}
  	else if(LOAD_TYPE_PHY_PORT == beartype)//NNI IS PORT
  	{
  		portData = getPortAttriByDirect(ELINE_SINK);
  		row = constructNniRow("3",portData.slotid,portData.subslotid,portData.portid);
  		business.appendChild(row);
  	}
  	else//NNI IS QINQ
  	{  
  		var qinqLinkid;
  		if($("existQinqrd").checked)
	    {
	  		var qinqArray = existQinqtext.value.split("-");
	  		qinqLinkid =  qinqArray[qinqArray.length-1];  		
  		}
  		else
		{
			qinqLinkid =  qinqct.getAttrValue("qinqlinkid");
		}

  		row = constructNniRow("4",0xffffffff,0xffffffff,qinqLinkid);
  		business.appendChild(row);
  	}
  }
  else if(sevdirection == SERVICETYPE_UNI_UNI)
  {
  	var portData = getPortAttriByDirect(ELINE_SOURCE);
  	var row = constructUniRow(portData.slotid,portData.subslotid,portData.portid,portData.tagNum,portData.tag);
  	business.appendChild(row);
  	portData = getPortAttriByDirect(ELINE_SINK);
  	var row = constructUniRow(portData.slotid,portData.subslotid,portData.portid,portData.tagNum,portData.tag);
  	business.appendChild(row);
  }
  else if(sevdirection == SERVICETYPE_NNI_NNI)
  {
  	createNNINNIXML(business);
  }
}

function createNNINNIXML(business)
{
	
}


function getPortAttriByDirect(direct)
{   
	var portData;
	var portAtom;
	if(ELINE_SOURCE == direct)
	{
		portAtom = ct.getAtom("srcport").element;
	}
	else
	{
		portAtom = ct.getAtom("sinkport").element;
	}
	
	if(portAtom.options.length > 0)
	{
		var boardport = portAtom.value.split("-");
		var slotid = boardport[0];
		var subslotid = 255;
		var portid = boardport[1];
		
		var vlan;
		var vlanNum;
		if(direct == ELINE_SOURCE)
		{
			vlan = ct.getAtom("srcvlan").element.value;
		}
		else
		{
			vlan = ct.getAtom("sinkvlan").element.value;
		}
		if(vlan == "")
		{
			vlanNum = 0;
		}
		else
		{
			vlanNum = vlan.split(",").length;
		}
		portData = new PortData(slotid,subslotid,portid,vlanNum,vlan);
			
	}else
	{
		return null;
	}
	
	return portData;
}


function constructUniRow(slotid,subslotid,portid,tagNum,tagList)
{
	var row = new tagElement("row-params");
    
  var param = new tagElement("param");
  param = new tagElement("param");
  param.setAttribute("name", "portType");
  param.setAttribute("value", "uni");
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "slotid");
  param.setAttribute("value", slotid);
  row.appendChild(param);
      
  param = new tagElement("param");
  param.setAttribute("name", "subslotid");
  param.setAttribute("value", subslotid);
  row.appendChild(param);
      
  param = new tagElement("param");
  param.setAttribute("name", "portid");
  param.setAttribute("value", portid);
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "vuniID");
  param.setAttribute("value", ""+slotid+portid);
  row.appendChild(param);

  var tagIDDataArr = tagList;
  if("-" == tagList)
  {
	tagIDDataArr = "" ;
  }
  
  /*
  param = new tagElement("param");
  param.setAttribute("name", "tagNum");
  param.setAttribute("value", tagIDDataArr[0]);
  row.appendChild(param);
  */
  param = new tagElement("param");
  param.setAttribute("name", "tagid");
  param.setAttribute("value", tagIDDataArr);
  row.appendChild(param);
  for (var s = 0, t = qosUni.length; s < t; s++) 
  {
     	if (qosUni[s] != null) 
        {
            var qos = qosUni[s];
            if(slotid != qos.slotid || portid != qos.portid)
            {
            	continue;
            }
            row.appendChild(createTagElement("qosUniID", ""+slotid+portid));
            row.appendChild(createTagElement("direction", qos.direction));
            if (qos.policy != null) 
            {
                var policyId = INVALID_LABEL_VALUE_2;
                if (qos.policy != "") 
                {
                    policyId = qos.policy.substring(0, qos.policy.indexOf("("));
                }
                row.appendChild(createTagElement("policy", policyId));
            }
            if (qos.cos != null || qos.color != null) 
            {
                row.appendChild(createTagElement("cos", qos.cos));
                row.appendChild(createTagElement("color", qos.color));
            }
        }
    }
  
  return row;
}


function constructNniRow(carrierType,carrierID1,carrierID2,carrierID3)
{
	var row = new tagElement("row-params");
    
  var param = new tagElement("param");
  param = new tagElement("param");
  param.setAttribute("name", "portType");
  param.setAttribute("value", "nni");
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "carrierType");
  param.setAttribute("value", carrierType);
  row.appendChild(param);
      
  param = new tagElement("param");
  param.setAttribute("name", "carrierID1");
  param.setAttribute("value", carrierID1);
  row.appendChild(param);
      
  param = new tagElement("param");
  param.setAttribute("name", "carrierID2");
  param.setAttribute("value", carrierID2);
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "carrierID3");
  param.setAttribute("value", carrierID3);
  row.appendChild(param);    
  return row;
}

function validateParams()
{
	return validate();
}

function validate()
{

    var msgArr = new Array();
    
    var serviceId = $("serviceid").value;

    if (!$("isAuto").checked)
    {
    	if (typeof(serviceId) == "undefined" || serviceId == "") 
    	{
    		msgArr[msgArr.length] = RESOURCE["serviceid"] + RESOURCE["rangemsg"] + "1~4294967294";
    	}
    }
   
    var sevdirection = ct.getAtom("direction").getValue();
	var beartype = ct.getAttrValue("bearertype");
	if(sevdirection == SERVICETYPE_UNI_NNI)
  	{
  	/**
  		var bpdu = ct.getAtom("bpdu").getValue();
		var srcVlan = ct.getAtom("srcvlan").getValue();
		if(N_TRANSBPDU == bpdu && srcVlan != "-" && srcVlan == "")
		{	
			var srcvlanRange = "1~4094";
			msgArr[msgArr.length] = RESOURCE["srcvlan"] + RESOURCE["rangemsg"] + srcvlanRange;
		}
		*/
	  	if(LOAD_TYPE_PW == beartype)
	  	{
	  		
	  		var pwid = pwct.getAtom("pwid").getValue();
			if (typeof(pwid) == "undefined" || pwid == "") 
		    {
		        msgArr[msgArr.length] = RESOURCE["pwid"] + RESOURCE["rangemsg"] + "1~4294967295";
		    }

		    var labelRange = "16~1048575";
		    var pwEncapType = parseInt(pwct.getAtom("pwencaptype").getValue());
		    if (pwEncapType == 2) // UDP
		    {
		        labelRange = "49153~50176";
		    }
		    var v = pwct.getAtom("pwinlabel").getValue();
		    if (v != "-" && v == "") 
		    {
		        msgArr[msgArr.length] = RESOURCE["pwinlabel"] + RESOURCE["rangemsg"] + labelRange;
		    }
		    v = pwct.getAtom("pwoutlabel").getValue();
		    if (v != "-" && v == "") 
		    {
		        msgArr[msgArr.length] = RESOURCE["pwoutlabel"] + RESOURCE["rangemsg"] + labelRange;
		    }
		    if ($("selectedtunnel").value == "") 
		    {
                msgArr[msgArr.length] = RESOURCE["inputtunnel"];
		    }

		    v = pwct.getAtom("oppsitelsrid").getValue();
		    var arr = v.split(".");
		    var fIp = parseInt(arr[0]);
		    var tIp = parseInt(arr[3]);
		    if (isNaN(fIp) || isNaN(tIp) || fIp == 0 || fIp == 127 || (fIp >= 224 && fIp <= 255) || tIp == 0 || tIp == 255) 
		    {
		        msgArr[msgArr.length] = RESOURCE["oppsitelsrid"] + RESOURCE["inputmsg"] + "0.*.*.*,127.*.*.*,*.*.*.0,*.*.*.255,224.0.0.0~255.255.255.255";
		    }
	  	}
	  	else if(LOAD_TYPE_PHY_PORT == beartype)//NNI IS PORT
	  	{
	  		var nnisinkport = ct.getAtom("sinkport").getValue();
			if (nnisinkport != "-" && nnisinkport == "") 
			{
			    msgArr[msgArr.length] = RESOURCE["sinkport"];
			}
	  	}
	  	else//NNI IS QINQ
	  	{  
			if($("newQinqrd").checked)
			{
				var qinqlinkid = qinqct.getAtom("qinqlinkid").getValue();
				if (qinqlinkid != "-" && qinqlinkid == "") 
			    {
			        msgArr[msgArr.length] = "QinQ Link ID" + RESOURCE["rangemsg"] + "1~4294967295";
			    }
				var qinqport = qinqct.getAtom("qinqboard").getValue();
				if (qinqport != "-" && qinqport == "") 
			    {
			        msgArr[msgArr.length] = RESOURCE["boardspan"]+RESOURCE["port"];
			    }
				var qinqvlanid = qinqct.getAtom("qinqsvlanid").getValue();
				if (qinqvlanid != "-" && qinqvlanid == "") 
			    {
			        msgArr[msgArr.length] = "S-Vlan ID" + RESOURCE["rangemsg"] + "1~4094";
			    }
			}else
			{
				var existqinqid = $("existQinqtext").value;
				
				if (existqinqid != "-" && existqinqid == "") 
			    {
			        msgArr[msgArr.length] = RESOURCE["qinqradiospan"];
			    }
			}
	  	}
  	}
  	else if(sevdirection == SERVICETYPE_UNI_UNI)
	{
	/*
		var bpdu = ct.getAtom("bpdu").getValue();
		var srcVlan = ct.getAtom("srcvlan").getValue();
		if(N_TRANSBPDU == bpdu && srcVlan != "-" && srcVlan == "")
		{	
			var srcvlanRange = "1~4094";
			msgArr[msgArr.length] = RESOURCE["srcvlan"] + RESOURCE["rangemsg"] + srcvlanRange;
		}
		var srcport = ct.getAtom("srcport").getValue();
		if (srcport != "-" && srcport == "") 
		{
			msgArr[msgArr.length] = RESOURCE["srcport"];
		}
		var sinkVlan = ct.getAtom("sinkvlan").getValue();
		if(N_TRANSBPDU == bpdu && sinkVlan != "-" && sinkVlan == "")
		{	
			var sinkvlanRange = "1~4094";
			msgArr[msgArr.length] = RESOURCE["sinkvlan"] + RESOURCE["rangemsg"] + sinkvlanRange;
		}
		*/
	}
    
    if (msgArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
    }
    return true;
}

function configureQos()
{
	xshowModalDialog("../eline_u2kv1r2c01/cfgqos.html", RESOURCE["cfgqosbtn"], 650, 300, "../../../../../../images/");

}

function  changeProtecttype()
{
}
