var qosunist = null;
var qospwst = null;

var qosunitc = null;

var tab = null;

var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;

function init()
{
    initTable();
    initUI();
    initTabs();
    
    initUNIQoSTableData();
}

function initTable()
{
    qosunist = new SortTable();
    qosunitc = window.tableconf[0];
    qosunist.setImage("../../../../../../images/");
    createTableHead(qosunist, qosunitc);
    $("qosporttbl").appendChild(qosunist.getTable());
    qosunist.setBodyHeight(getComponetHeight($("qosporttbl"), 220) + "px");
    /*
    qospwst = new SortTable();
    qospwst.setImage("../../../../../../images/");
    createTableHead(qospwst, window.tableconf[1]);
    $("qospwtbl").appendChild(qospwst.getTable());
    qospwst.setBodyHeight(getComponetHeight($("qospwtbl"), 220) + "px");
    */
}

function initUI()
{
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", "UNI", $("tab1div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedtab").appendChild(tab.getEmbedTabs());
}

function embedTabSelectHandler(id)
{
    if (id == "tab2div") 
    {
        adjustTableLayout(qospwst, window.tableconf[1]);
    }
}


function getUniPortRes(res)
{
	var resInfo = new Object(); 
	var atomSrc = win.ct.getAtom(res).element;
	if(atomSrc.options.length == 0)
	{
		return null;
	}
    var index = atomSrc.selectedIndex;
    var slotPortValue = atomSrc.options[index].value;
    var slotPortText = atomSrc.options[index].text;
    resInfo.slotid = slotPortValue.split("-")[0];
    resInfo.portid = slotPortValue.split("-")[1];
	resInfo.portname = slotPortText;
	return resInfo;
}


function initUNIQoSTableData()
{
    var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    var rowParams = document.createElement("row-params");
    
	var portinfo = getUniPortRes("srcport");
	if(null != portinfo)
	{
		var vuniId = ""+portinfo.slotid+portinfo.portid;
		var qos = win.qosUni[vuniId];
	    rowParams.appendChild(createParamElement("vuniId", vuniId));
	    rowParams.appendChild(createParamElement("slotid", portinfo.slotid));
	    rowParams.appendChild(createParamElement("portid", portinfo.portid));
	    rowParams.appendChild(createParamElement("portname", portinfo.portname));
	    rowParams.appendChild(createParamElement("direction", 1));
	    rowParams.appendChild(createParamElement("bandwidthlimit", 0));
	    rowParams.appendChild(createParamElement("policy", (qos != null && qos.policy != null) ? qos.policy : ""));
	    rowParams.appendChild(createParamElement("cos", (qos != null && qos.cos != null) ? qos.cos : 8));
	    rowParams.appendChild(createParamElement("color", (qos != null && qos.color != null) ? qos.color : 3));
	    rowParams.appendChild(createParamElement("cir", 0));
	    rowParams.appendChild(createParamElement("cbs", 0));
	    rowParams.appendChild(createParamElement("pir", 0));
	    rowParams.appendChild(createParamElement("pbs", 0));
	    bparams.appendChild(rowParams);
	
	    rowParams = document.createElement("row-params");
	    rowParams.appendChild(createParamElement("vuniId", vuniId));
	    rowParams.appendChild(createParamElement("slotid", portinfo.slotid));
	    rowParams.appendChild(createParamElement("portid", portinfo.portid));
	    rowParams.appendChild(createParamElement("portname", portinfo.portname));
	    rowParams.appendChild(createParamElement("direction", 2));
	    rowParams.appendChild(createParamElement("bandwidthlimit", 0));
	    rowParams.appendChild(createParamElement("policy", ""));
	    rowParams.appendChild(createParamElement("cos", ""));
	    rowParams.appendChild(createParamElement("color", ""));
	    rowParams.appendChild(createParamElement("cir", 0));
	    rowParams.appendChild(createParamElement("cbs", 0));
	    rowParams.appendChild(createParamElement("pir", 0));
	    rowParams.appendChild(createParamElement("pbs", 0));
	    bparams.appendChild(rowParams);
	}
	
	var portinfo = getUniPortRes("sinkport");
	var srcdir = win.ct.getAtom("direction").getValue();
	if(null != portinfo && UNI_UNI == srcdir)
	{
		var vuniId = ""+portinfo.slotid+portinfo.portid;
		var qos = win.qosUni[vuniId];
		rowParams = document.createElement("row-params");
	    rowParams.appendChild(createParamElement("vuniId", vuniId));
	    rowParams.appendChild(createParamElement("slotid", portinfo.slotid));
	    rowParams.appendChild(createParamElement("portid", portinfo.portid));
	    rowParams.appendChild(createParamElement("portname", portinfo.portname));
	    rowParams.appendChild(createParamElement("direction", 1));
	    rowParams.appendChild(createParamElement("bandwidthlimit", 0));
	    rowParams.appendChild(createParamElement("policy", (qos != null && qos.policy != null) ? qos.policy : ""));
	    rowParams.appendChild(createParamElement("cos", (qos != null && qos.cos != null) ? qos.cos : 8));
	    rowParams.appendChild(createParamElement("color", (qos != null && qos.color != null) ? qos.color : 3));
	    rowParams.appendChild(createParamElement("cir", 0));
	    rowParams.appendChild(createParamElement("cbs", 0));
	    rowParams.appendChild(createParamElement("pir", 0));
	    rowParams.appendChild(createParamElement("pbs", 0));
	    bparams.appendChild(rowParams);
	
	    rowParams = document.createElement("row-params");
	    rowParams.appendChild(createParamElement("vuniId", vuniId));
	    rowParams.appendChild(createParamElement("slotid", portinfo.slotid));
	    rowParams.appendChild(createParamElement("portid", portinfo.portid));
	    rowParams.appendChild(createParamElement("portname", portinfo.portname));
	    rowParams.appendChild(createParamElement("direction", 2));
	    rowParams.appendChild(createParamElement("bandwidthlimit", 0));
	    rowParams.appendChild(createParamElement("policy", ""));
	    rowParams.appendChild(createParamElement("cos", ""));
	    rowParams.appendChild(createParamElement("color", ""));
	    rowParams.appendChild(createParamElement("cir", 0));
	    rowParams.appendChild(createParamElement("cbs", 0));
	    rowParams.appendChild(createParamElement("pir", 0));
	    rowParams.appendChild(createParamElement("pbs", 0));
	    bparams.appendChild(rowParams);
	}
	
    di.appendChild(bparams);
    createTableBody(qosunist, qosunitc, EncapsulateData(di), RESOURCE);
    
    for (var j = 0, n = qosunist.getDataRowLength(); j < n; j++) 
    {
        var direction = parseInt(qosunist.getCellStoreValue(j, "direction", "direction"));
        if (direction == EGRESS) // Egress
        {
            var cell = qosunist.getCell(j, "policy");
            qosunist.setCellIsEdit(cell, 0);
            qosunist.getCellShow(j, "policy").element.innerHTML = "-";
            
            cell = qosunist.getCell(j, "cos");
            qosunist.setCellIsEdit(cell, 0);
            qosunist.getCellShow(j, "cos").element.innerHTML = "-";
            
            cell = qosunist.getCell(j, "color");
            qosunist.setCellIsEdit(cell, 0);
            qosunist.getCellShow(j, "color").element.innerHTML = "-";
        }
        else 
        {
            qosunist.getCell(j, "policy").element.ondblclick = function()
            {
                openPolicyDialog(VUNI_INGRESS_POLICY, direction);
            }
        }
    }
}


function convertUNI(param)
{
    return RESOURCE[role[param.split("-")[1]]];
}

function doConfig()
{
    for (var i = 0, m = qosunist.getDataRowLength(); i < m; i++) 
    {
        if (qosunist.getModify(i)) 
        {
			var vuniId = qosunist.getCellStoreValue(i, "vuniId", "vuniId");
        	var slotid = qosunist.getCellStoreValue(i, "slotid", "slotid");
        	var portid = qosunist.getCellStoreValue(i, "portid", "portid");
            if (win.qosUni[vuniId] == null) 
            {
                win.qosUni[vuniId] = new Object();
                win.qosUni[vuniId].slotid = slotid;
                win.qosUni[vuniId].portid = portid;
            }
            
            win.qosUni[vuniId].direction = qosunist.getCellStoreValue(i, "direction", "direction");
            if (qosunist.getCellModify(i, "policy")) 
            {
                win.qosUni[vuniId].policy = qosunist.getCellStoreValue(i, "policy", "policy");
            }
            if (qosunist.getCellModify(i, "cos") || qosunist.getCellModify(i, "color")) 
            {
                win.qosUni[vuniId].cos = qosunist.getCellStoreValue(i, "cos", "cos");
                win.qosUni[vuniId].color = qosunist.getCellStoreValue(i, "color", "color");
            }
        }
    }
    xcloseDialog();
}

function openPolicyDialog(policyType, direction)
{
    var tmpst = qospwst;
    if (policyType == VUNI_INGRESS_POLICY) 
    {
        tmpst = qosunist;
    }
    
    if (tmpst.getSelectedRowCount() > 1) 
    {
        return;
    }
    
    var url = "policyselect.html?policyType=" + policyType + "&direction=" + direction;
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 480, 300, "../../../../../images/");
}









