
var portst;

var ELINE_SOURCE = "1";
var ELINE_SINK = "2";


var portFOIFETH = 1;
var portFOGE1 = 2;
var portFOGE2 = 3;
var portFOGE3 = 4;
var portFoShowName = new Object();
portFoShowName[portFOIFETH] = "IF(ETH)";//"IF(ETH)";
portFoShowName[portFOGE1] = "GE1";//"GE1";
portFoShowName[portFOGE2] = "GE2";//"GE2";
portFoShowName[portFOGE3] = "GE3";

var portFoName = new Object();
portFoName[portFOIFETH] = "IF(ETH)";//"IF(ETH)";
portFoName[portFOGE1] = "GE1";//"GE1";
portFoName[portFOGE2] = "GE2";//"GE2";
portFoName[portFOGE3] = "GE3";
var ENCAPTYPE_NULL = 0;
var ENCAPTYPE_8021Q = 1;
var ENCAPTYPE_QINQ = 2;
var encapType = [];
encapType[ENCAPTYPE_NULL] = "Null";
encapType[ENCAPTYPE_8021Q] = "802.1Q";
encapType[ENCAPTYPE_QINQ] = "QINQ";

var enableFlag = [];
enableFlag[0] = RESOURCE["disabled"];
enableFlag[1] = RESOURCE["enabled"];
function convertPortName(val)
{
    return "1-SHXA2-" + val;
}

var workMode = [];
workMode["-1"] = "-";//DTS2012041604111,                          
workMode[0] = RESOURCE["autonegotiation"];
workMode[1] = RESOURCE["HalfDuplex10M"];
workMode[2] = RESOURCE["FullDuplex10M"];
workMode[3] = RESOURCE["HalfDuplex100M"];
workMode[4] = RESOURCE["FullDuplex100M"];
workMode[5] = RESOURCE["HalfDuplex1000M"];
workMode[6] = RESOURCE["FullDuplex1000M"];
workMode[7] = RESOURCE["FullDuplexLAN10G"];
workMode[8] = RESOURCE["FullDuplexWAN10G"];
workMode[255] = RESOURCE["negotiating"];

var TAGFLAG_ACCESS = 0;
var TAGFLAG_TAGAWARE = 1;
var TAGFLAG_HYBRID = 2;
var TAGFLAG_NOTAGAWARE = 3;
var tagFlag = [];
tagFlag[0] = "Access";
tagFlag[1] = "Tag Aware";
tagFlag[2] = "Hybrid";
tagFlag[3] = "No Tag Aware";

var MIN_VLANID = 1;
var INVALID_VLANID = 65535;
var isPortAttrModify = false;

var INVALID_VLANPRI = 255;
var INVALID_TAG = 255;
var MIN_VLANPRI = 0;

var usableQinqLink = [];

var usableBoardArr = [];

/**
 *          
 */
function initPortAttrTable()
{
    portst = new SortTable();
    portst.head.setAttribute("id", "htmlTable_STHead_portattr");
    portst.body.setAttribute("id", "htmlTable_STBody_portattr");
    portst.setImage("../../../../../../images/");
    portst.isUsedForSelectList = true;
    createTableHead(portst, window.tableconf[1]);
    portst.setBodyHeight("60px");
    portst.setOnCellEditHandler(portCellEditHandler);
    $("porttablecontainer").appendChild(portst.getTable());
}

/**
 *                           
 * @param param            
 */
function portCellEditHandler(param)
{
    var rowindex = param.rowindex;
    if (param.stage == TABLE_CONSTANT.AFTEREDIT) 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
        if (param.colid == "encapType") 
        {
            encapeTypeEditHandler(rowindex);
        }
        if (param.colid == "tag") 
        {
        }
        if (param.colid == "tagID") 
        {
            for (var i = 0, len = portst.getDataRowLength(); i < len; i++) 
            {
                portst.setCellModify(i, "tagID", true);
            }
        }
    }
}

/**
 *            ,              
 * @param rowindex
 */
function encapeTypeEditHandler(/*string*/rowindex)
{
    var encaptype = portst.getCellStoreValue(rowindex, "encapType", "encapType");
    if (encaptype == ENCAPTYPE_NULL) 
    {
        portst.getCellShow(rowindex, "tag").setValue("-");
    }
    if (encaptype == ENCAPTYPE_NULL || encaptype == ENCAPTYPE_QINQ) 
    {
        portst.setCellIsEdit(portst.getCell(rowindex, "tag"), 0);
        portst.setCellIsEdit(portst.getCell(rowindex, "vlanID"), 0);
        portst.setCellIsEdit(portst.getCell(rowindex, "vlanPri"), 0);
        portst.getCellShow(rowindex, "vlanID").setValue("-");
        portst.getCellShow(rowindex, "vlanPri").setValue("-");
    }
    else 
    {
        portst.setCellIsEdit(portst.getCell(rowindex, "tag"), 1);
        portst.setCellIsEdit(portst.getCell(rowindex, "vlanID"), 1);
        portst.setCellIsEdit(portst.getCell(rowindex, "vlanPri"), 1);
    }
    if (encaptype == ENCAPTYPE_8021Q || encaptype == ENCAPTYPE_QINQ) 
    {
        var tag = portst.getCellStoreValue(rowindex, "tag", "tag");
        var vlanid = portst.getCellStoreValue(rowindex, "vlanID", "vlanID");
        var vlanpri = portst.getCellStoreValue(rowindex, "vlanPri", "vlanPri");
        if (typeof(tag) == "undefined" || tag == INVALID_TAG || typeof(tagFlag[tag]) == "undefined") 
        {
            tag = TAGFLAG_HYBRID;
            portst.setCellValue(portst.getCell(rowindex, "tag"), "tag", tag);
        }
        portst.getCellShow(rowindex, "tag").setValue(tagFlag[tag]);
    }
    if (encaptype == ENCAPTYPE_8021Q) 
    {
        if (typeof(vlanid) == "undefined" || vlanid == INVALID_VLANID || vlanid == "-1") 
        {
            vlanid = MIN_VLANID
            portst.setCellValue(portst.getCell(rowindex, "vlanID"), "vlanID", vlanid);
        }
        portst.getCellShow(rowindex, "vlanID").setValue(vlanid);
        
        if (typeof(vlanpri) == "undefined" || vlanpri == INVALID_VLANPRI || vlanpri == "-1") 
        {
            vlanpri = MIN_VLANPRI
            portst.setCellValue(portst.getCell(rowindex, "vlanPri"), "vlanPri", vlanpri);
        }
        portst.getCellShow(rowindex, "vlanPri").setValue(vlanpri);
    }
    if (TRANSBPDU == $("slProtocol").value || TRANSLACP == $("slProtocol").value) 
    {
        portst.setCellIsEdit(portst.getCell(rowindex, "tagID"), 0);
        portst.getCellShow(rowindex, "tagID").setValue("");
    }
    else if (N_TRANSBPDU == $("slProtocol").value) 
    {
        portst.setCellIsEdit(portst.getCell(rowindex, "tagID"), 1);
    }		
    if (encaptype == ENCAPTYPE_NULL) 
    { 
        portst.getCellShow(rowindex, "tagID").setValue("");
        portst.setCellIsEdit(portst.getCell(rowindex, "tagID"), 0);
    }
}

/**
 * TAG       ,             
 * @param rowindex
 */
function tagEditHandler(/*string*/rowindex)
{
    var tag = portst.getCellStoreValue(rowindex, "tag", "tag");
    if (tag == TAGFLAG_TAGAWARE) 
    {
        portst.setCellIsEdit(portst.getCell(rowindex, "vlanID"), 0);
        portst.setCellIsEdit(portst.getCell(rowindex, "vlanPri"), 0);
        portst.getCellShow(rowindex, "vlanID").setValue("-");
        portst.getCellShow(rowindex, "vlanPri").setValue("-");
    }
    else 
    {
        portst.setCellIsEdit(portst.getCell(rowindex, "vlanID"), 1);
        portst.setCellIsEdit(portst.getCell(rowindex, "vlanPri"), 1);
        var vlanid = portst.getCellStoreValue(rowindex, "vlanID", "vlanID");
        var vlanpri = portst.getCellStoreValue(rowindex, "vlanPri", "vlanPri");
        if (typeof(vlanid) == "undefined" || vlanid == INVALID_VLANID) 
        {
            vlanid = MIN_VLANID
            portst.setCellValue(portst.getCell(rowindex, "vlanID"), "vlanID", vlanid);
        }
        portst.getCellShow(rowindex, "vlanID").setValue(vlanid);
        
        if (typeof(vlanpri) == "undefined" || vlanpri == INVALID_VLANPRI) 
        {
            vlanpri = MIN_VLANPRI
            portst.setCellValue(portst.getCell(rowindex, "vlanPri"), "vlanPri", vlanpri);
        }
        portst.getCellShow(rowindex, "vlanPri").setValue(vlanpri);
    }
}

/**
 *          XML
 * @param direction
 */
function createGetPortAttriXml(/*string*/direction,/*boolean*/ bFromNE)
{
    var srcSlotid = null;
    var srcPortid = null;
    var snkSlotid = null;
    var snkPortid = null;
    
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param", "neid", neid);
    row.appendChild(param);
    
    param = new tagElement("param", "bFromNE", bFromNE);
    row.appendChild(param);
    
    var portObject = getPortObjectChecked();
    if (portObject != null) 
    {
        if ($("txtSource") != null || $("txtSource") != "undefined") 
        {
            $("txtSource").value = portFoShowName[portObject.getAttribute("srcport")];
        }
        if ($("txtSink") != null || $("txtSink") != "undefined") 
        {
            $("txtSink").value = portFoShowName[portObject.getAttribute("snkport")];
        }
        
        param = new tagElement("param", "slotid", portObject.getAttribute("srcslot"));
        row.appendChild(param);
        
        param = new tagElement("param", "port", portObject.getAttribute("srcport"));
        row.appendChild(param);
    }
    bussiness.appendChild(row);
    if (UNI_UNI == direction && portObject != null) 
    {
        row = new tagElement("row-params");
        var param = new tagElement("param", "neid", neid);
        row.appendChild(param);
        param = new tagElement("param", "bFromNE", bFromNE);
        row.appendChild(param);
        param = new tagElement("param", "slotid", portObject.getAttribute("snkslot"));
        row.appendChild(param);
        param = new tagElement("param", "port", portObject.getAttribute("snkport"));
        row.appendChild(param);
        bussiness.appendChild(row);
    }
    
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *       ,             
 */
function queryPortAttribute(/*boolean*/bFromNE)
{
    $("queryportbtn").disabled = true;
    var direction = $("slDirection").value;
    var xmlData = createGetPortAttriXml(direction, bFromNE);
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_ETHPORTATTRIB + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + nmuser;
    loadXMLdoc(urlstr, "POST", true, callbackGetPortAttri, null, "inputdata=" + xmlData);
}

/**
 *            ,      ,
 *                             ,
 *            ,         
 * @param doc
 */
function callbackGetPortAttri(/*XMLDOM*/doc)
{
    $("queryportbtn").disabled = !btnRightArr.queryportbtn.right;
    portst.clearTableData();
    var data = EncapsulateData(doc);
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode()) 
    {
        processData(data);
        
        createTableBody(portst, window.tableconf[1], data, RESOURCE);
        
        addPortCellEvent();
    }
    else 
    {
        $("applybtn").disabled = true;
    }
}

/**
 *              
 * @param data        
 * @return  
 */
function processData(data)
{
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        renamePortAttribute(data, i, "port", "portid");
        renamePortAttribute(data, i, "ATTR_ETHOVERPTN_MAC_ENABLE", "portEnable");
        renamePortAttribute(data, i, "ATTR_ETHOVERPTN_MAC_WORKMODE", "workMode");
        renamePortAttribute(data, i, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE", "encapType");
        renamePortAttribute(data, i, "ATTR_ETHOVERPTN_MAC_TAG", "tag");
        
        if (null != data.getDataRowParam(i, "tag")) 
        {
            if (null != data.getDataRowParam(i, "encapType")) 
            {
                var encapType = data.getDataRowParam(i, "encapType");//     
                if (encapType == 0)//null  
                {
                    data.rows[i]["tag"] = "-";
                }
            }
        }
    }
}

/**
 *         
 * @param data
 * @param rowindex
 * @param srcname
 * @param snkname
 */
function renamePortAttribute(/*DateInterface*/data,/*string*/ rowindex,/*string*/ srcname,/*string*/ snkname)
{
    if (null != data.getDataRowParam(rowindex, srcname)) 
    {
        data.rows[rowindex][snkname] = data.rows[rowindex][srcname];
    }
}

/**
 *        
 * @param data
 * @param rowindex
 */
function renamePortName(/* DateInterface */data,/* string */ rowindex)
{
    var name = "";
    var slotid = data.getDataRowParam(rowindex, "slotid");
    var boardname = data.getDataRowParam(rowindex, "boardname");
    var portid = data.getDataRowParam(rowindex, "portid");
    var portname = data.getDataRowParam(rowindex, "portname");
    if (slotid && boardname && portid) 
    {
        if (1 == portid) 
        {
            name = /*"IF(ETH)[" + */ slotid + "-" + boardname +
            "-" +
            portname/* + "]"*/;
        }
        else 
        {
            name = /*"GE" + (portid - 1) + "[" + */ slotid + "-" + boardname +
            "-" +
            portname/* + "]"*/;
        }
        portFoName[portid] = name;
    }
}


/**
 *                      
 */
function addPortCellEvent()
{

    var cell = null;
    var tempValue = null;
    
    for (var i = 0, len = portst.getDataRowLength(); i < len; i++) 
    {
        
        refreshPortCellEditOrNot(i, "portEnable");
        refreshPortCellEditOrNot(i, "workMode");
        tempValue = portst.getCellStoreValue(i, "encapType", "encapType");
        if (tempValue == ENCAPTYPE_NULL || tempValue == ENCAPTYPE_QINQ) 
        {
            portst.setCellIsEdit(portst.getCell(i, "tag"), 0);
            portst.setCellIsEdit(portst.getCell(i, "vlanID"), 0);
            portst.setCellIsEdit(portst.getCell(i, "vlanPri"), 0);
            portst.getCellShow(i, "vlanID").setValue("-");
            portst.getCellShow(i, "vlanPri").setValue("-");
            if (tempValue == ENCAPTYPE_NULL) 
            {
                portst.getCellShow(i, "tag").setValue("-");
            }
        }
        /**
         *      DTS2012062200506
         *     q00119080
         *        Default VLANID -1        "/"
         */
        var defaultVlanID = portst.getCellStoreValue(i, "vlanID", "vlanID");
        if (defaultVlanID == -1) 
        {
            portst.getCellShow(i, "vlanID").setValue("/");
            
        }
        /**
         *      DTS2012051402278
         *       BPDU LACP VALN    
         */
        if (TRANSBPDU == $("slProtocol").value || TRANSLACP == $("slProtocol").value) 
        {
            portst.setCellIsEdit(portst.getCell(i, "tagID"), 0);
            portst.getCellShow(i, "tagID").setValue("");
            portst.setCellValue(portst.getCell(i, "tagID"), "");
        }
        else if (N_TRANSBPDU == $("slProtocol").value) 
        {
            portst.setCellIsEdit(portst.getCell(i, "tagID"), 1);
        }
        if (tempValue == ENCAPTYPE_NULL ) 
        {	
            portst.getCellShow(i, "tagID").setValue("");
            portst.setCellIsEdit(portst.getCell(i, "tagID"), 0);
        }
    }
}

/**
 *            
 *       DOM  ,        ,             
 */
function getPortObjectChecked()
{
    var checks = $("portselectcontainer").getElementsByTagName("input");
    var checkObject = null;
    for (var i = 0, len = checks.length; i < len; i++) 
    {
        if (checks[i] && checks[i].name == PORTTYPECHECKPROF && checks[i].checked) 
        {
            checkObject = checks[i];
            break;
        }
    }
    return checkObject
}

/**
 *                    
 *    undefined
 * @param rowindex
 * @param colid
 */
function refreshPortCellEditOrNot(/*string*/rowindex,/*string*/ colid)
{
    var tempValue = portst.getCellStoreValue(rowindex, colid, colid);
    if (typeof(tempValue) == "undefined" || ("workMode" == colid && "-1" == tempValue)) 
    {
        portst.setCellIsEdit(portst.getCell(rowindex, colid), 0);
        portst.getCellShow(rowindex, colid).setValue("-");
    }
}


/**
 * create get ports xml
 */
function createGetPortsXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ethType");
    param.setAttribute("value", "1");//(1:e-line 2:e-lan 3:e-tree)
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "availableType");
    param.setAttribute("value", "portResType");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *          ,  UCD        
 */
function getPortRes(brefresh)
{
    var xml = createGetPortsXML();
    var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_IPPTN_GET_FO_SERVICERES + "&nmUser=" + nmuser;
    loadXMLdoc(url, "POST", false, portResCallBack, brefresh, "inputdata=" + xml);
}

/**
 *           
 * @param doc
 */
function portResCallBack(/*XMLDOM*/doc, param)
{
    var data = EncapsulateData(doc);
    if (OPERATION_SUCCESS == data.getError().getGlobleECode()) 
    {
        var portlist = initBoardPortData(data);
        if (param == true) 
        {
            refreshBoardSelect(portlist);
        }
        else 
        {
            createBoardSelect(portlist);
        }
    }
}


/**
 * init board select
 */
function initBoardPortData(/*Object*/data)
{
    var portlist=[];
    usableBoardArr = [];
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        var usableBd = new TEUsableBoard();
        usableBd.slotid = data.getDataRowParam(i, "slotid");
        usableBd.boardType = data.getDataRowParam(i, "boardType");
        usableBd.boardName = data.getDataRowParam(i, "boardName");
        usableBd.portid = data.getDataRowParam(i, "portid");
        usableBd.portname = data.getDataRowParam(i, "portname");
        usableBd.portstatus = data.getDataRowParam(i, "portstatus");

        if(1==data.getDataRowParam(i, "portisexist"))//                
	{
            usableBoardArr.push(usableBd);
	}
        portlist.push(usableBd);
    }
    return portlist;
}

/**
 *          
 */
function refreshBoardSelect(/*Array*/portlist)
{
    var port = null;
    var backcolor = "";
    
    var elems = $("portselectcontainer").getElementsByTagName("input");
    for (var i = 0, len = elems.length; i < len; i++) 
    {
        if (elems[i] && elems[i].name == PORTTYPECHECKPROF) 
        {
            var srcport = elems[i].getAttribute("srcport");
            var snkport = elems[i].getAttribute("snkport");
            var srcportObj = getPortObject(portlist, srcport);
            var snkportObj = getPortObject(portlist, snkport);
            var tr = elems[i].parentNode.parentNode;
            if (tr.childNodes.length >= 4 && srcportObj && snkportObj) 
            {
                var srcportElm = tr.childNodes(1).childNodes(0);
                backcolor = "";
                if (srcportObj.portstatus == "0") 
                {
                    backcolor = "red";
                }
                srcportElm.style.backgroundColor = backcolor;
                var snkportElm = tr.childNodes(3).childNodes(0);
                backcolor = "";
                if (snkportObj.portstatus == "0") 
                {
                    backcolor = "red";
                }
                snkportElm.style.backgroundColor = backcolor;
                var hrElm = tr.childNodes(2).childNodes(0);
                if (srcportObj.portstatus == "0" || snkportObj.portstatus == "0") 
                {
                    hrElm.style.borderStyle = "dashed";
                }
                else 
                {
                    hrElm.style.borderStyle = "";
                }
            }
        }
    }
    
}

function getPortObject(portlist, portid)
{
    var port = null;
    for (var i = 0, len = portlist.length; i < len; i++) 
    {
        port = portlist[i];
        if (port.portid == portid) 
        {
            return port;
        }
    }
    return null;
}

/**
 * create board tree
 *      3        
 */
function createBoardSelect(/*Array*/portlist)
{
    var slotid = "1";
    var tbody = document.createElement("tbody");
    var tr = createPortTypeTR(portlist[portFOGE1 - 1], portlist[portFOIFETH - 1]);
    tbody.appendChild(tr);
    tr = createPortTypeTR(portlist[portFOGE2 - 1], portlist[portFOIFETH - 1]);
    tbody.appendChild(tr);
    tr = createPortTypeTR(portlist[portFOGE1 - 1], portlist[portFOGE2 - 1]);
    tbody.appendChild(tr);
    
    tr = createPortTypeTR(portlist[portFOIFETH - 1], portlist[portFOGE1 - 1]);
    tr.style.display = "none";
    tbody.appendChild(tr);
    tr = createPortTypeTR(portlist[portFOIFETH - 1], portlist[portFOGE2 - 1]);
    tr.style.display = "none";
    tbody.appendChild(tr);
    tr = createPortTypeTR(portlist[portFOGE2 - 1], portlist[portFOGE1 - 1]);
    tr.style.display = "none";
    tbody.appendChild(tr);
    $("portselectcontainer").appendChild(tbody);
    
}

/**
 *             
 */
function createPortTypeTR(srcPort, snkPort)
{
    var tr = document.createElement("tr");
    tr.className = "porttypetr";
    tr.style.verticalAlign = "top";
    var td = document.createElement("td");
    var check = null;
    if (document.uniqueID) 
    {
        check = document.createElement("<input name='" + PORTTYPECHECKPROF + "' type='radio' />");
    }
    else 
    {
        check = document.createElement("input");
        check.setAttribute("type", "radio");
        check.name = PORTTYPECHECKPROF;
    }
    
    check.setAttribute("id", PORTTYPECHECKPROF + "-" + srcPort.portid + "-" + snkPort.portid);
    
    check.setAttribute("srcslot", srcPort.slotid);
    check.setAttribute("srcport", srcPort.portid);
    check.setAttribute("snkslot", snkPort.slotid);
    check.setAttribute("snkport", snkPort.portid);
    check.onclick = function()
    {
        queryPortAttribute(false);
    }
    td.appendChild(check);
    tr.appendChild(td);
    td = document.createElement("td");
    td.style.textAlign = "right";
    var portdiv = document.createElement("div");
    portdiv.setAttribute("portstatus", srcPort.portstatus);
    portdiv.className = "portsquare";
    if (srcPort.portstatus == "0") 
    {
        portdiv.style.backgroundColor = "red";
    }
    td.appendChild(portdiv);
    var portspan = document.createElement("span");
    portspan.style.whiteSpace = "nowrap";
    portspan.innerHTML = portFoShowName[srcPort.portid];
    td.appendChild(portspan);
    tr.appendChild(td);
    td = document.createElement("td");
    var hr = document.createElement("hr");
    hr.setAttribute("port", srcPort.portid + "-" + snkPort.portid);
    if (isIE) 
    {
        hr.className = "portlineie";
    }
    else 
    {
        hr.className = "portline";
    }
    if (srcPort.portstatus == "0" || snkPort.portstatus == "0") 
    {
        hr.style.borderStyle = "dashed";
    }
    hr.size = "1";
    td.appendChild(hr);
    tr.appendChild(td);
    td = document.createElement("td");
    td.style.textAlign = "left";
    var portdiv = document.createElement("div");
    portdiv.setAttribute("portstatus", snkPort.portstatus);
    portdiv.className = "portsquare";
    if (snkPort.portstatus == "0") 
    {
        portdiv.style.backgroundColor = "red";
    }
    td.appendChild(portdiv);
    var portspan = document.createElement("span");
    portspan.style.whiteSpace = "nowrap";
    portspan.innerHTML = portFoShowName[snkPort.portid];
    td.appendChild(portspan);
    tr.appendChild(td);
    return tr;
}

/**
 *          XML  ,       
 *             
 */
function createSetPortAttriXml()
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row;
    var param;
    
    var length = portst.getDataRowLength();
    for (var i = 0; i < length; i++) 
    {
        if (!portst.getModify(i)) 
        {
            continue;
        }
        var tagID = portst.getCellStoreValue(i, "tagID", "tagID");
        if (!tagID) 
        {
            tagID = "";
        }
        var isValide = validataTagList(tagID);
        if (isValide == -1) 
        {
            return -1;
        }
        row = new tagElement("row-params");
        
        appendSlotPortParam(row, i);
        
        var bService = appendServiceModifyParam(row, i, tagID);
        
        var bOther = appendOtherParam(row, i);
        if (bService || bOther) 
        {
            business.appendChild(row);
        }
    }
    if (0 == business.childNodes.length) 
    {
        return null;
    }
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 *           
 * @param row
 */
function appendSlotPortParam(/*tagElement*/row,/*string*/ i)
{
    param = new tagElement("param", "neid", neid);
    row.appendChild(param);
    param = new tagElement("param", "slotid", portst.getCellStoreValue(i, "slotid", "slotid"));
    row.appendChild(param);
    param = new tagElement("param", "subslotid", "255");
    row.appendChild(param);
    param = new tagElement("param", "portid", portst.getCellStoreValue(i, "portid", "portid"));
    row.appendChild(param);
    param = new tagElement("param", "port", portst.getCellStoreValue(i, "portid", "portid"));
    row.appendChild(param);
    return true;
}

/**
 *              
 * @param row
 */
function appendServiceModifyParam(/*tagElement*/row,/*string*/ i,/*string*/ tagID)
{
    var selectedRows = st.getSelectedRows();
    if (selectedRows.length > 0 && portst.getCellModify(i, "tagID")) 
    {
        param = new tagElement("param", "serviceIndex", st.getCellStoreValue(selectedRows[0], "serviceIndex", "serviceIndex"));
        row.appendChild(param);
        
        param = new tagElement("param", "serviceID", st.getCellStoreValue(selectedRows[0], "serviceID", "serviceID"));
        row.appendChild(param);
        
        param = new tagElement("param", "serviceName", st.getCellStoreValue(selectedRows[0], "serviceName", "serviceName"));
        row.appendChild(param);
        
        param = new tagElement("param", "bpdu", st.getCellStoreValue(selectedRows[0], "bpdu", "bpdu"));
        row.appendChild(param);
        if (portst.getCellStoreValue(i, "vuniID", "vuniID")) 
        {
            param = new tagElement("param", "vuniID", portst.getCellStoreValue(i, "vuniID", "vuniID"));
            row.appendChild(param);
        }
        param = new tagElement("param", "tagNum", "0");
        row.appendChild(param);
        
        param = new tagElement("param", "tagID", tagID);
        row.appendChild(param);
        return true;
    }
    return false;
}

/**
 *                
 * @param row
 */
function appendOtherParam(/*tagElement*/row,/*string*/ i)
{
    var bResult = false;
    if (portst.getCellModify(i, "portEnable")) 
    {
        param = new tagElement("param", "portEnable", portst.getCellStoreValue(i, "portEnable", "portEnable"));
        row.appendChild(param);
        bResult = true;
    }
    if (portst.getCellModify(i, "workMode")) 
    {
        param = new tagElement("param", "workMode", portst.getCellStoreValue(i, "workMode", "workMode"));
        row.appendChild(param);
        bResult = true;
    }
    if (portst.getCellModify(i, "encapType")) 
    {
        param = new tagElement("param", "encapType", portst.getCellStoreValue(i, "encapType", "encapType"));
        row.appendChild(param);
        bResult = true;
    }
    if (portst.getCellModify(i, "encapType") || portst.getCellModify(i, "tag") || portst.getCellModify(i, "vlanID")) 
    {
		if (portst.getCellShow(i, "tag").getValue() != "-") 
		{
			param = new tagElement("param", "tag", portst.getCellStoreValue(i, "tag", "tag"));
			row.appendChild(param);
		}
        if (portst.getCellShow(i, "vlanID").getValue() != "-") 
        {
            var vlanId = portst.getCellStoreValue(i, "vlanID", "vlanID");
            param = new tagElement("param", "vlanID", vlanId);
            row.appendChild(param);
            
            param = new tagElement("param", "vlanPri", portst.getCellStoreValue(i, "vlanPri", "vlanPri"));
            row.appendChild(param);
        }
        bResult = true;
    }
    return bResult;
}

/**
 *       ,          
 */
function doApplyPortAttr()
{

    var xmlData = createSetPortAttriXml();
    if (xmlData == -1) 
    {
        $("querybtn").disabled = !btnRightArr.querybtn.right;
        $("applybtn").disabled = !btnRightArr.applybtn.right;
        if (st.getSelectedRows().length > 0) 
        {
            $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        }
        return false;
    }
    
    $("querybtn").disabled = true;
    $("deletebtn").disabled = true;
    $("applybtn").disabled = true;
    if (xmlData == null) 
    {
        $("querybtn").disabled = !btnRightArr.querybtn.right;
        if (st.getSelectedRows().length > 0) 
        {
            $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        }
        else 
        {
            createEline();
        }
        return true;
    }
    LoadingProcess.showFixWaitStatus("doApplyPortAttr");
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_ETHPORTATTRIB + "&flag=1&nmUser=" + nmuser;
    loadXMLdoc(urlstr, "POST", true, callbackSetPortAttri, null, "inputdata=" + xmlData);
    return !isPortAttrModify;
}

/**
 *            
 */
function callbackSetPortAttri(doc)
{
    var data = EncapsulateData(doc);
    LoadingProcess.removeFixWaitStatus("doApplyPortAttr");
    var errorCode = data.getSErrorCode();
    isPortAttrModify = false;
    $("querybtn").disabled = !btnRightArr.querybtn.right;
    if (st.getSelectedRows().length > 0) 
    {
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
    }
    showErrorDialog(data);
    if (OPERATION_SUCCESS == errorCode) 
    {
        refreshTableState(portst, window.tableconf[1], data);
        if (st.getSelectedRows().length == 0) 
        {
            createEline();
        }
        else 
        {
            if (SYSTEMCONF.getStatus() == 1) 
            {
                queryELine();
            }
        }
    }
    else 
    {
        $("applybtn").disabled = !btnRightArr.applybtn.right;
        isPortAttrModify = true;
    }
}

/**
 *          XML  
 * @param selectIndex
 */
function createQueryResParaXml(/*string*/selectIndex)
{
    var root = new inputxml("datainterface");
    var business = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "block");
    param.setAttribute("value", "queryRes");
    row.appendChild(param);
    param = new tagElement("param", "neid", neid);
    row.appendChild(param);
    param = new tagElement("param", "ethType", "1");//(1:e-line 2:e-lan 3:e-tree)
    row.appendChild(param);
    param = new tagElement("param", "linkid", "0");
    row.appendChild(param);
    business.appendChild(row);
    
    row = new tagElement("row-params");
    param = new tagElement("param", "block", "NSCMD_SERVICE_GET_ETHVUNI_EX");
    row.appendChild(param);
    param = new tagElement("param", "ethType", "1");//(1:e-line 2:e-lan 3:e-tree)
    row.appendChild(param);
    param = new tagElement("param", "serviceIndex", st.getCellStoreValue(selectIndex, "serviceIndex", "serviceIndex"));
    row.appendChild(param);
    param = new tagElement("param", "vuniID", "0");
    row.appendChild(param);
    business.appendChild(row);
    
    row = new tagElement("row-params");
    param = new tagElement("param", "block", "NSCMD_SERVICE_GET_EVNNI_EX");
    row.appendChild(param);
    param = new tagElement("param", "ethType", "1");//(1:e-line 2:e-lan 3:e-tree)
    row.appendChild(param);
    param = new tagElement("param", "serviceIndex", st.getCellStoreValue(selectIndex, "serviceIndex", "serviceIndex"));
    row.appendChild(param);
    param = new tagElement("param", "vnniID", "0");
    row.appendChild(param);
    business.appendChild(row);
    
    root.getRoot().appendChild(business);
    return root.toString();
}

/**
 *             
 *                              
 * @param selectIndex
 */
function queryElineResPara(/*string*/selectIndex,/*boolean*/ bFromNE)
{
    if (SYSTEMCONF.getStatus() == 1) 
    {
        queryElineResParaInter(selectIndex, bFromNE);
    }
    else 
    {
        queryElineResParaSelf(selectIndex);
    }
}


function createQueryElineResParaInterXml(/*string*/selectIndex,/*boolean*/ bFromNE)
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param", "neid", neid);
    row.appendChild(param);
    param = new tagElement("param", "slotid", st.getCellStoreValue(selectIndex, "source", "sourceslot"));
    row.appendChild(param);
    param = new tagElement("param", "port", st.getCellStoreValue(selectIndex, "source", "sourceport"));
    row.appendChild(param);
    param = new tagElement("param", "bFromNE", bFromNE);
    row.appendChild(param);
    bussiness.appendChild(row);
    
	if(st.getCellStoreValue(selectIndex, "direction", "direction") == UNI_UNI)
	{
	    row = new tagElement("row-params");
	    var param = new tagElement("param", "neid", neid);
	    row.appendChild(param);
	    param = new tagElement("param", "slotid", st.getCellStoreValue(selectIndex, "sink", "sinkslot"));
	    row.appendChild(param);
	    param = new tagElement("param", "port", st.getCellStoreValue(selectIndex, "sink", "sinkport"));
	    row.appendChild(param);
	    param = new tagElement("param", "bFromNE", bFromNE);
	    row.appendChild(param);
	    bussiness.appendChild(row);		
	}


    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function queryElineResParaInter(/*string*/selectIndex,/*boolean*/ bFromNE)
{
    $("queryportbtn").disabled = true;
    var xmlData = createQueryElineResParaInterXml(selectIndex, bFromNE);
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_ETHPORTATTRIB + "&flag=1&nmUser=" + nmuser;
    loadXMLdoc(urlstr, "POST", true, callbackQueryElineResParaInter, selectIndex, "inputdata=" + xmlData);
}

function callbackQueryElineResParaInter(/*XMLDOM*/doc, selectIndex)
{
    $("queryportbtn").disabled = !btnRightArr.queryportbtn.right;
    portst.clearTableData();
    var data = EncapsulateData(doc);
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode()) 
    {
        createTableBody(portst, window.tableconf[1], data, RESOURCE);
        var sourceSlotid = st.getCellStoreValue(selectIndex, "source", "sourceslot");
        var sourcePortid = st.getCellStoreValue(selectIndex, "source", "sourceport");
        var sourceVlan = st.getCellStoreValue(selectIndex, "source", "sourcevlan");
        sourceVlan = (typeof(sourceVlan) == "undefined" || !sourceVlan) ? "" : sourceVlan;
        var sourceVuniid = st.getCellStoreValue(selectIndex, "source", "sourcevuniid");
		var direction = st.getCellStoreValue(selectIndex, "direction", "direction");
		if (direction == UNI_UNI) 
		{
			var sinkSlotid = st.getCellStoreValue(selectIndex, "sink", "sinkslot");
			var sinkPortid = st.getCellStoreValue(selectIndex, "sink", "sinkport");
			var sinkVlan = st.getCellStoreValue(selectIndex, "sink", "sinkvlan");
			sinkVlan = (typeof(sinkVlan) == "undefined" || !sinkVlan) ? "" : sinkVlan;
			var sinkVuniid = st.getCellStoreValue(selectIndex, "sink", "sinkvuniid");
		}
        addPortCellEvent();
        for (var i = 0, len = portst.getDataRowLength(); i < len; i++) 
        {
            var slotid = portst.getCellStoreValue(i, "slotid", "slotid");
            var portid = portst.getCellStoreValue(i, "portid", "portid");
            if (sourceSlotid == slotid && sourcePortid == portid) 
            {
                portst.setCellValue(portst.getCell(i, "tagID"), "tagID", sourceVlan);
                portst.setCellValue(portst.getCell(i, "hiddenTagID"), "tagID", sourceVlan);
                portst.getCellShow(i, "tagID").setValue(sourceVlan);
                portst.getCellShow(i, "hiddenTagID").setValue(sourceVlan);
                portst.setCellValue(portst.getCell(i, "vuniID"), "vuniID", sourceVuniid);
            }
            else 
            {
				if(direction == UNI_UNI)
				{
	                portst.setCellValue(portst.getCell(i, "tagID"), "tagID", sinkVlan);
	                portst.setCellValue(portst.getCell(i, "hiddenTagID"), "tagID", sinkVlan);
	                portst.getCellShow(i, "tagID").setValue(sinkVlan);
	                portst.getCellShow(i, "hiddenTagID").setValue(sinkVlan);
	                portst.setCellValue(portst.getCell(i, "vuniID"), "vuniID", sinkVuniid);					
				}
            }
        }
    }
    else 
    {
        showErrorDialog(data);
    }
}

function queryElineResParaSelf(/*string*/selectIndex)
{
    $("queryportbtn").disabled = true;
    var xmldata = createQueryResParaXml(selectIndex);
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETHSRV_GET_ELAN_V_UNI + "&timestamp=" + new Date().getTime() + "&nmUser=" + obj["nmUser"];
    loadXMLdoc(urlstr, "POST", true, callbackQueryResPara, null, "inputdata=" + xmldata);
}


/**
 *           ,               
 * @param doc
 */
function callbackQueryResPara(/*XMLDOM*/doc)
{
    $("queryportbtn").disabled = !btnRightArr.queryportbtn.right;
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() < 2) 
    {
        portst.clearTableData();
        createTableBody(portst, window.tableconf[1], data, RESOURCE);
        addPortCellEvent();
    }
    else 
    {
        showErrorDialog(data);
    }
}
