/**
 *           eline-fo     
 * 1 TEUsableBoard           
 * 2 TEUsableQinQLink    QinQ     
 */
/**
 *   UNI-NNI      
 */
var NOTCONFIG = -1;
var CREATE_QINQ = -2;

var QINQ_TYPE = 2;
var PORT_TYPE = 1;

/**
 *          
 */
function TEUsableBoard()
{
    this.slotid = null;
    this.boardType = null;
    this.boardName = null;
    this.portid = null;
    this.portname = null;
    this.portstatus = null;
    this.type = PORT_TYPE;
}

function createTEUsableBoard(/**TEUsableBoard*/tempobj)
{
    var portObject = new TEUsableBoard();
    portObject.slotid = tempobj.slotid;
    portObject.boardType = tempobj.boardType;
    portObject.boardName = tempobj.boardName;
    portObject.portid = tempobj.portid;
    portObject.portname = tempobj.portname;
    portObject.portstatus = tempobj.portstatus;
    portObject.type = tempobj.type;
    return portObject;
}

TEUsableBoard.prototype.toString = function()
{
    return portFoName[this.portid] + "[" + this.slotid + "-" + this.boardName + "-" + this.portname + "]";
}


/**
 *      QinQ Link  :
 * linkid
 * slotid
 * boardname
 * portid
 * portname
 * svlanid
 */
function TEUsableQinQLink()
{
    this.linkid = null;
    this.slotid = null;
    this.boardName = null;
    this.portid = null;
    this.portname = null;
    this.svlanid = null;
    this.type = QINQ_TYPE;
}

/**
 *   JSON                     
 *           
 * @param {String} jsonStr
 */
function creatTEUsableQinQLink(/**String*/jsonStr)
{
    var qinqObject = new TEUsableQinQLink();
    var qinqObj = JSON.parse(jsonStr);
    qinqObject.linkid = qinqObj.linkid;
    qinqObject.slotid = qinqObj.slotid;
    qinqObject.boardName = qinqObj.boardName;
    qinqObject.portid = qinqObj.portid;
    qinqObject.portname = qinqObj.portname;
    qinqObject.svlanid = qinqObj.svlanid;
    qinqObject.type = qinqObj.type;
    return qinqObject;
}

function creatTEUsableQinQLinkByObj(/**String*/linkData)
{
    var qinqObject = new TEUsableQinQLink();
     qinqObject.linkid = linkData.linkid;
    qinqObject.slotid = linkData.slotid;
    qinqObject.boardName = linkData.boardName;
    qinqObject.portid = linkData.portid;
    qinqObject.portname = linkData.portname;
    qinqObject.svlanid = linkData.svlanid;
    qinqObject.type = linkData.type;
    return qinqObject;
}
TEUsableQinQLink.prototype.toString = function()
{
    if (this.linkid == NOTCONFIG || this.linkid == CREATE_QINQ) 
    {
        return RESOURCE["notDefine"];
    }
    return "QinQ Link-" + this.linkid;
}
TEUsableQinQLink.prototype.getTip = function()
{	
    if (!(this.linkid == NOTCONFIG || this.linkid == CREATE_QINQ)) 
    {
        return RESOURCE["port"] + ":" + portFoName[this.portid] + "[" + this.slotid + "-" + this.boardName + "-" + this.portid + "(" + this.portname + ")]\r\nS-Vlan ID:"+this.svlanid;
    }
	else
	{
		return RESOURCE["notDefine"];
	}
}

function getCreateQinQObj()
{
    var usableLink = new TEUsableQinQLink();
    usableLink.linkid = CREATE_QINQ;
    usableLink.slotid = CREATE_QINQ;
    usableLink.boardName = CREATE_QINQ;
    usableLink.portid = CREATE_QINQ;
    usableLink.portname = CREATE_QINQ;
    usableLink.svlanid = CREATE_QINQ;
    return usableLink;
}

function getNotConfigQinQObj()
{
    var usableLink = new TEUsableQinQLink();
    usableLink.linkid = NOTCONFIG;
    usableLink.slotid = NOTCONFIG;
    usableLink.boardName = NOTCONFIG;
    usableLink.portid = NOTCONFIG;
    usableLink.portname = NOTCONFIG;
    usableLink.svlanid = NOTCONFIG;
    return usableLink;
}
