var winurlobj = getParentWindow();
var neid = winurlobj.neid;
var obj = winurlobj.obj;
var usableBoardArr = new Array(); //usable board list
var currentdir = winurlobj.currentDirection;//1:uni-nni  2:uni-uni  3:nni-nni
var OPRSUCC = "0";
var portAttriTable;
var portList = new Array();
window.onload = function()
{	   
	  initPortSelectView();
	  initPortAttributeTable();
	  initButtonText();
}

function initPortSelectView()
{
	getPorts();
}

function initPortAttributeTable()
{
	portAttriTable= new SortTable();
    portAttriTable.setImage("../../../../../../images/");
    createTableHead(portAttriTable, window.tableconf[0]);
    portAttriTable.setBodyHeight("60px");
    portAttriTable.setOnCellEditHandler(cellEditHandler);
    $("portAttriTable").appendChild(portAttriTable.getTable());
    $("portAttriTable").oncontextmenu=popupMenuHandler;
}

function cellEditHandler()
{
  
}

function showPortAttri()
{
	var selectindex = $("port").selectedIndex;
	var portText = $("port").options[selectindex].text;
	var portValue = getPortStructFromList(portText);
	var valenable = 1;
	var valmode = 0;
	if (portText.indexOf("IF") >= 0 || portText.indexOf("EFP8") >= 0)
	{
		valenable = "-";
		valmode = "-";
	}
	
	defaultVal = new Array("2",2,portText,portValue.slotid,portValue.subslotid,portValue.portid,valenable,valmode,2,1);
	portAttriTable.clearTableData();
	createTableRow(portAttriTable, window.tableconf[0], defaultVal,RESOURCE);
	if (portText.indexOf("IF") >= 0 || portText.indexOf("EFP8") >= 0)
	{
		portAttriTable.setCellIsEdit(portAttriTable.getCell(0,"workMode"),0);
	}
	portAttriTable.setCellIsEdit(portAttriTable.getCell(0,"encapsulationtype"),0);
	portAttriTable.setCellIsEdit(portAttriTable.getCell(0,"tagid"),0);
	portAttriTable.setCellIsEdit(portAttriTable.getCell(0,"vlanID"),0);
}

function selectPort()
{
	  if ($("port").options.length <= 0 || $("port").selectedIndex == -1)
	  {
	  	  alert(RESOURCE["selectePort"]);
	  	  return;
	  }
	  var selectindex = $("port").selectedIndex;
	  var portText = $("port").options[selectindex].text;
	  var portValue = getPortStructFromList(portText);
      winurlobj.editSourcePortCell.value = portText;
      if(portAttriTable.getDataRowLength()!=0)
      {
        var slotid = portAttriTable.getCellStoreValue(0,"slotid","slotid");
        var subslotid = portAttriTable.getCellStoreValue(0,"subslotid","subslotid");
        var portid = portAttriTable.getCellStoreValue(0,"portid","portid");
        var portenable = portAttriTable.getCellStoreValue(0,"portEnable","portEnable");
        var workmode = portAttriTable.getCellStoreValue(0,"workMode","workMode");
        var encapsulationtype = portAttriTable.getCellStoreValue(0,"encapsulationtype","encapsulationtype");
        var tagid = portAttriTable.getCellStoreValue(0,"tagid","tagid");
        var portAttriData = new PortAttriData(portText,slotid,subslotid,portid,portenable,workmode,encapsulationtype,tagid);
        winurlobj.portdata = portAttriData;
      }
      xcloseDialog();
}

function initButtonText()
{
	  $("okbtn").value = RESOURCE["okbtn"];
	  $("cancelbtn").value = RESOURCE["cancelbtn"];	
	  $("boardspan").innerHTML = RESOURCE["boardspan"];
	  $("avaliableportspan").innerHTML = RESOURCE["avaliableportspan"];
}

/**
 * get ports from server
 */
function getPorts()
{
	if(isDemo)
	{
    	loadXMLdoc("portselect_test.xml", "POST", false, handleBackgetPorts, null);
    }
    else
    {
       var xmlstr = createGetPortsXML();
       var urlreq ="../../../../../../neExlorerServlet?sfid="+TE_QUERY_AVAILABLE_PORT_RESOURCE_EX+""+"&nmUser="+winurlobj["nmUser"];
       loadXMLdoc(urlreq, "POST",true,handleBackgetPorts,null,"inputdata="+xmlstr);
    }
}

/**
 * create get ports xml
 */
function createGetPortsXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 * handle get ports result
 */
function handleBackgetPorts(doc)
{	  
    var data = EncapsulateData(doc);
    var errArr = [];
    errArr[0] = "errObj";
    openErrPage("../../../../../../page/", data.getError(), errArr);
    
    if (OPRSUCC == data.getError().getGlobleECode()) 
    {
        initBoardPortData(data);
        createBoardSelect(neid)
    }
}
/**
 * init board select
 */
function initBoardPortData(data)
{
    usableBoardArr.clear();
	for(var i = 0, len = data.getDataRowLength(); i < len; i ++)
	{
		   var usableBd = new TEUsableBoard();
		   usableBd.slotid = data.getDataRowParam(i ,"slotid" );
		   usableBd.boardName = data.getDataRowParam(i , "boardName");
		   usableBd.subslotid = data.getDataRowParam(i , "subslotid");
		   usableBd.subBoardName = data.getDataRowParam(i , "subBoardName");
		   usableBd.portidArr = data.getDataRowOptions(i , "portid");
		   usableBd.portNameArr = data.getDataRowOptions(i , "portname");
		   usableBoardArr.push(usableBd); 
	}
}
/**
 * create board tree
 */
function createBoardSelect(neid)
{
	$("boardSelectBox").length = 0;
	for (var i = 0, len = usableBoardArr.length; i < len; i++)
	{
		var temString = usableBoardArr[i].slotid + "-" + usableBoardArr[i].boardName;
	    $("boardSelectBox").options[$("boardSelectBox").options.length]	=	new	Option(temString, i);
	}
	if($("boardSelectBox").length > 0)
	{
		boardChanged($("boardSelectBox"));
    }
}

function boardChanged(selectCombox)
{
	var key = selectCombox.value;
	var board = usableBoardArr[key];
	var oOption;
	$("port").options.length = 0;
	portList.clear();
	if(null != board.portNameArr)
	{
		 for(var i = 0, len = board.portNameArr.length; i < len; i++)
		 {
		 	oOption = document.createElement("OPTION"); 
    	    oOption.text = board.slotid + "-" + board.boardName + "-" ;
    	    if ("0" != board.subslotid && "255" != board.subslotid)
	        {
	          	  oOption.text += board.subslotid + "-" + board.subBoardName + "-";
	        }
	        oOption.text += board.portNameArr[i];
	        var portValue = new PortDataStruct(oOption.text,board.slotid,board.subslotid,board.portidArr[i]);
		    portList.push(portValue);
		    oOption.value = board.portidArr[i]; 
		    $("port").options.add(oOption);
		 }
	}
	if(portAttriTable)
	{
	  portAttriTable.clearTableData();
	}
}

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    for(var i = 0, len = di.getBErrLength(); i < len; i++)
	  {
				errorObj = di.getError().rowErrors[i].errorObj;
		    errorObj["operationObj"] = errorObj["qinqLinkId"];
		}
    errArr[0] = "operationObj";
    openErrPage("../../../../../../../../../../page/", di.getError(), errArr);
}

function getPortStructFromList(portname)
{
	for(var i=0;i<portList.length;i++)
	{
		if(portname == portList[i].portName)
		{
			return portList[i];
		}
	}
}
