var parentWin = getParentWindow(); 
if(!isIE)
{
    for(var i = 0; i < parentWin.frames.length; i++)
    {
        if("elineFwdTable" == parentWin.frames[i].name)
        {
            parentWin = parentWin.frames[i];
            break;
        }
    }
}
var ct;
var neid = parentWin.neid;
var obj = parentWin.obj;
var  resources = [];//      

function initPage()
{
	ct = new CTable();
	ct.addHead(RESOURCE["property"],RESOURCE["value"]);
	
	var atom = new Atom("select");//     
	atom.element.options.add(new Option(RESOURCE["VUNIInterface"],1));
	atom.element.onchange = refreshSrcSelects;
	ct.addAttrRow("srclogicinftype",RESOURCE["srclogicinftype"], atom);
	
	var atom = new Atom("select");//   
	ct.addAttrRow("srcport",RESOURCE["srcport"], atom);
	
	var atom = new Atom("text");// VLAN ID
	ct.addAttrRow("srcvlan",RESOURCE["srcvlan"], atom);
	validateNum(atom.element,1,4094,4,1);
	
	var atom = new Atom("select");//     
	atom.element.options.add(new Option(RESOURCE["VUNIInterface"],1));
	atom.element.onchange = refreshSinkSelects;
	ct.addAttrRow("sinklogicinftype",RESOURCE["sinklogicinftype"], atom);
	
	var atom = new Atom("select");//   
	ct.addAttrRow("sinkport",RESOURCE["sinkport"], atom);
	validateNum(atom.element,1,4094,4,1);
	
	var atom = new Atom("text");// VLAN ID
	ct.addAttrRow("sinkvlan",RESOURCE["sinkvlan"], atom);
	validateNum(atom.element,1,4094,4,1);
	
	$("tablecomponent").appendChild(ct.getTable());
	
	$("okbutton").value = RESOURCE["okbutton"];          
	$("cancelbtn").value = RESOURCE["cancelbutton"];
	$("applybtn").value = RESOURCE["applybutton"];
	
    var attriArray = new Array(
    		"srcport",
			"srcvlan",
			"sinkport",
			"sinkvlan"
		);

    for( var i = 0; i < attriArray.length; i++ )
    {
    	ct.attrArray[attriArray[i]].element.onchange = function()
    	{
    		$("applybtn").disabled = false;
    	}
    }

	
	if(SYSTEMCONF.getStatus() == 1)
	{
		resources = parentWin.resources;
		initNodeSelect();
	}
	else
	{
		queryVuniVnni();
	}
}
/**
 *   VLAN      VUNI VNNI
 */
function queryVuniVnni()
{
	    var rowcount = parentWin.parobj.st.getSelectedRowCount();
	    if(rowcount <= 0)
	    {
	    	return;
	    }
	    var xmldata = createQueryXml();
		var urlstr = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IPPTN_ETH_OAM_GET_LOGIC_PORT+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+obj["nmUser"];
        loadXMLdoc(urlstr, "POST", false, callbackQuery, null, "inputdata="+xmldata);
}

/**
 *   VUNI VNNI  XML
 */
function createQueryXml()
{
	 var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",parentWin.neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","serviceIndex");
    var selRows = parentWin.parobj.st.getSelectedRows();
    param.setAttribute("value",parentWin.parobj.st.getCellStoreValue(selRows[0],"serviceIndex","serviceIndex"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","ethType");
    param.setAttribute("value","1");
    row.appendChild(param);    
    
    param = new tagElement("param");
    param.setAttribute("name","vuniID");
    param.setAttribute("value","0");
    row.appendChild(param); 
    
    param = new tagElement("param");
    param.setAttribute("name","vnniID");
    param.setAttribute("value","0");
    row.appendChild(param); 
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
	return di.toString();
}

function callbackQuery(doc)
{
	var data = EncapsulateData(doc);
	if (data.getSErrorCode() == 0)
	{
		for(var i = 0, len = data.getDataRowLength(); i < len; i++)
		{
			var resource = new Object();//      
			resource.slotid = data.getDataRowParam(i, "slotid");
		    resource.boardportname = data.getDataRowParam(i, "port");
		    resource.logicinftype = data.getDataRowParam(i, "logicinftype");
		    resource.logicinfid = data.getDataRowParam(i, "vuniid");
		    resource.vlans = data.getDataRowParam(i, "vlan").split(',');
		    resources.push(resource);
		}
	}
	initNodeSelect();
}

/**
 *        
 */
function initNodeSelect()
{
	var initalSrcPortType = "1";//            VUNI
	var initalsinkPortType = "1";//            VUNI
	
	var srcPortAtom = ct.attrArray['srcport'];
	var sinkPortAtom = ct.attrArray['sinkport'];
	srcPortAtom.clearOptions();
    sinkPortAtom.clearOptions();
    
	for(var i=0;i<resources.length;i++)
	{
		var resource = resources[i];
		srcPortAtom.addOption(resource.boardportname, resource.logicinfid);
		sinkPortAtom.addOption(resource.boardportname, resource.logicinfid);
	}
	
	if(resources.length >0)
	{
		var resource = resources[0];
		if(resource.logicinftype == "2")
		{
			initalSrcPortType = "2";
			initalsinkPortType = "2";
		}
	}
	
	if(initalSrcPortType == "1")
	{
		ct.attrArray['srclogicinftype'].element.options[0].selected = true;
	}
	else
	{
		ct.attrArray['srclogicinftype'].element.options[1].selected = true;
	}
	
	if(initalsinkPortType == "1")
	{
		ct.attrArray['sinklogicinftype'].element.options[0].selected = true;
	}
	else
	{
		ct.attrArray['sinklogicinftype'].element.options[1].selected = true;
	}
	if(srcPortAtom.element.options.length > 0)
	{
		srcPortAtom.element.options[0].selected = true;
	}
	
	if(sinkPortAtom.element.options.length > 0)
	{
		sinkPortAtom.element.options[0].selected = true;
	}
}


function refreshSrcSelects()
{
	var element = window.event.srcElement;
	if(!element)
	{
		return;
	}
    var resourceArray = getObjFromArr(resources, element.value);
    var portAtom = ct.attrArray['srcport'];
    portAtom.clearOptions();
    
    for(var i=0,size=resourceArray.length;i<size;i++)
    {
    	portAtom.addOption(resourceArray[i].boardportname, resourceArray[i].logicinfid);
    }
    if(resourceArray.length > 0)
    {
      portAtom.element.options[0].selected = true;
    }
    
	$("applybtn").disabled = false;
}

function refreshSinkSelects()
{
	var element = window.event.srcElement;
	if(!element)
	{
		return;
	}
    var resourceArray = getObjFromArr(resources, element.value);
    var portAtom = ct.attrArray['sinkport'];
    portAtom.clearOptions();
    
    for(var i=0,size=resourceArray.length;i<size;i++)
    {
    	portAtom.addOption(resourceArray[i].boardportname, resourceArray[i].logicinfid);
    }
    if(resourceArray.length > 0)
    {
        portAtom.element.options[0].selected = true;
    }
    
    $("applybtn").disabled = false;
}

/**
 *             
 */
function getObjFromArr(arr, typeid)
{
	var resourceArray = [];
	for(var i=0,size=resources.length;i<size;i++)
	{
		var resource = resources[i];
		if(resource.logicinftype == typeid)
		{
			resourceArray.push(resource);
		}
	}
	return resourceArray;
}

/**
 * 
 */
function create(isApply)
{
	if("" == ct.getAttrValue("srcvlan"))
	{
		alert(RESOURCE["inputsrcvlanid"]);
		return;
	}
	
	if("" == ct.getAttrValue("sinkvlan").trim())
	{
		alert(RESOURCE["inputsinkvlanid"]);
		return;
	}

	if( $("applybtn").disabled == true )
	{
		xcloseDialog();
		return;
	}
	
	$("okbutton").disabled = true;
    $("cancelbtn").disabled = true;
	$("applybtn").disabled = true;
	
	var xml = createXml();
	
	var urlreq ="../../../../../../neExlorerServlet?sfid="+TE_CMDCODE_IPPTN_ADD_VLANFWD_ENTRY+"&nmUser="+obj["nmUser"];
	loadXMLdoc(urlreq, "POST", false, createCallBack, isApply, "inputdata="+xml);
}

function createXml()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","autoServiceIndex");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    var selRows = parentWin.parobj.st.getSelectedRows();
    param = new tagElement("param","serviceIndex",parentWin.parobj.st.getCellStoreValue(selRows[0],"serviceIndex","serviceIndex"));
    row.appendChild(param);
    
    param = new tagElement("param","serviceID",parentWin.parobj.st.getCellStoreValue(selRows[0],"serviceID","serviceID"));
    row.appendChild(param);
    
    var activestate = parentWin.parobj.st.getCellStoreValue(selRows[0], "activestate", "activestate");
	if(activestate != null && activestate != "" && activestate != "-1")
	{
		param = new tagElement("param","activestate",activestate);    
		row.appendChild(param);
	}
    
    param = new tagElement("param");
    param.setAttribute("name","autoVlanFwdID");
    param.setAttribute("value","1");
    row.appendChild(param);
    param = new tagElement("param");
    param.setAttribute("name","vlanFwdID");
    param.setAttribute("value","0");
    row.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name","autoInLogicInfID");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","inLogicInfID");
    param.setAttribute("value",ct.getAttrValue('srcport').trim());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","inLogicInfType");
    param.setAttribute("value",ct.getAttrValue('srclogicinftype').trim());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","inVlanID");
    param.setAttribute("value",ct.getAttrValue("srcvlan").trim());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","autoOutLogicInfID");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","outLogicInfID");
    param.setAttribute("value",ct.getAttrValue("sinkport").trim());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","outLogicInfType");
    param.setAttribute("value",ct.getAttrValue("sinklogicinftype").trim());
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name","outVlanID");
    param.setAttribute("value",ct.getAttrValue("sinkvlan").trim());
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
	return di.toString();
}

/**
 * 
 */
function createCallBack(doc,isApply)
{
	$("okbutton").disabled = false;
    $("cancelbtn").disabled = false;
	$("applybtn").disabled = false;	
    
    var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	
	if(0 == errorCode) 
	{   
		parentWin.querySwitchTable();
		
		if(!isApply) 
		{
			xcloseDialog();
		}
		
        $("applybtn").disabled = true;
	}
	else
	{
		for(var i = data.getBErrLength()-1; i >= 0; i--)
		{	
			var errorObj = data.getError().rowErrors[i].errorObj;
			
			errorObj["vlanswitchtable"] =RESOURCE["switchtable"];
			if(errorObj["autoVlanFwdID"] && errorObj["autoVlanFwdID"] != "" && errorObj["autoVlanFwdID"] != "0")
			{
				errorObj["vlanswitchtable"] += "ID:"+ errorObj["autoVlanFwdID"];
			}
		}
		var errArr = [];
		errArr.push("vlanswitchtable");
		openErrPage("../../../../../../page/", data.getError(), errArr);
		
        $("applybtn").disabled = false;
	}
}
