 var parentWin = getParentWindow();
var elineAttrTable;
var portAttriTable,qosAttriTable,vlanSwitchTable;
var currentDirection = SERVICETYPE_UNI_NNI;//SERVICETYPE_UNI_NNI,SERVICETYPE_UNI_UNI,SERVICETYPE_NNI_NNI
var configPortList;
var obj = parentWin.obj;
var neid = obj["neid"];
var nmuser = obj["nmUser"];
var btnRightArr;
var count = 0;

var currentNniType = CURRENT_NNI_TYPE_PORT;
    
var createTableData = new CreateTableData();

var bIsValidateVlanID = true;


SOURCE_INDEX = 4;
SOURCE_VLAN_INDEX = 5;
SOURCE_PORT_INDEX = 6;
SOURCE_SVLANID_INDEX = 7;
SINK_INDEX = 8;
SINK_VLAN_INDEX = 9;
SINK_PORT_INDEX = 10;
SINK_SVLANID_INDEX = 11;

function init()
{
	initAttrTable(); 
	initParasTable();
	initUniUniTable();
	initButtonInfo();
	initTabs();
	/*var guide = new Guides("test",RESOURCE["prebtn"],RESOURCE["nextbtn"],RESOURCE["finishbtn"] ,RESOURCE["cancelbtn"]);
	guide.abortfunc = abortFunc;
	guide.add(RESOURCE["firststep"],"firststep",nextFunc);
	guide.add(RESOURCE["secondtstep"],"secondstep",finishFunc);
	guide.showGuide(0);*/
}

function initTabs()
{
	tab = new EmbedTabs();
  tab.addEmbedTab("firststep", RESOURCE["firststep"], $("firststep"));
  tab.addEmbedTab("secondstep", RESOURCE["secondtstep"], $("secondstep"));
  
  setSelectedEmbedTab("firststep");
  $("embedtab").appendChild(tab.getEmbedTabs());
}

function initButtonInfo()
{
	$("vlanswitchcfg").innerText = RESOURCE["vlanswitchcfg"];
	$("qosconfig").innerText = RESOURCE["qosconfig"];
	$("newbtn").value = RESOURCE["newbtn"];
	$("deletebtn").value = RESOURCE["deletebtn"];
	
	$("okbtn").value = RESOURCE["okbtn"];
	$("cancelbtn").value = RESOURCE["cancelbtn"];
	
	$("deletebtn").disabled = true;
	$("newbtn").disabled = true;
}

function abortFunc()
{
	window.close();
}
		
function nextFunc()
{
	var serviceID = elineAttrTable.getAttrValue("serviceId");
	var serviceName = elineAttrTable.getAttrValue("serviceName");
	var direction = elineAttrTable.getAttrValue("direction");
	var source = elineAttrTable.getAttrValue("source");
	var sourceVlan = elineAttrTable.getAttrValue("sourceVlan");
	var sourcePort = elineAttrTable.getAttrValue("sourcePort");
	var sourceSVlanID = elineAttrTable.getAttrValue("sourceSVlanID");
	var sink = elineAttrTable.getAttrValue("sink");
	var sinkVlan = elineAttrTable.getAttrValue("sinkVlan");
	var sinkPort = elineAttrTable.getAttrValue("sinkPort");
	var sinkSvlanID = elineAttrTable.getAttrValue("sinkSVlanID");

  if(serviceID == "")
  {
  	alert(RESOURCE["inputserviceid"]);
  	return;
  }
	if(currentDirection == SERVICETYPE_UNI_NNI)
	{
		if(elineAttrTable.getAttrValue("source")=="" || elineAttrTable.getAttrValue("sink")=="")
		{
			alert(RESOURCE["inputport"]);
			return;
		}

		for(var i=0;i<portAttriTable.getDataRowLength();i++)
		{
 	    var logicInfType = portAttriTable.getCellStoreValue(i,"uninnitype","uninnitype");
 	    var encapType = portAttriTable.getCellStoreValue(i,"encapsulationtype","encapsulationtype");
 	    var tagid = portAttriTable.getCellStoreValue(i,"tagid","tagid");
 	    if(logicInfType == TYPE_UNI_PORT)
 	    {
        if(encapType != 0 && encapType != 1)
        {
        	alert(RESOURCE["encaptypenullor802Q"]);
        	return;
        }
 	    }
 	    else
 	    {
 	    	if(encapType != 2)
 	    	{
 	    		alert(RESOURCE["encaptypeqinq"]);
 	    		return;
 	    	}
 	    }
		}
	}
  else if(currentDirection == SERVICETYPE_UNI_UNI)
  {
		var len = portAttriTable.getDataRowLength();
		if(len != 2)
		{
			alert(RESOURCE["inputport"]);
			return;
		}
		var encaptype1 = portAttriTable.getCellStoreValue(0,"encapsulationtype","encapsulationtype");
		var tagid1 = portAttriTable.getCellStoreValue(0,"tagid","tagid");
		var encaptype2 = portAttriTable.getCellStoreValue(1,"encapsulationtype","encapsulationtype");
		var tagid2 = portAttriTable.getCellStoreValue(1,"tagid","tagid");
		if(encaptype1 != encaptype2)
		{
			alert(RESOURCE["encaptypeconsistent"]);
			return;
		}
  }
	else if(currentDirection == SERVICETYPE_NNI_NNI)
	{
	  if(elineAttrTable.getAttrValue("source")=="" 
	      || elineAttrTable.getAttrValue("sourcePort")==""
	      || elineAttrTable.getAttrValue("sourceSVlanID")==""
	      || elineAttrTable.getAttrValue("sink")==""
	      || elineAttrTable.getAttrValue("sinkPort")==""
	      || elineAttrTable.getAttrValue("sinkSVlanID")=="")
		{
			alert(RESOURCE["inputport"]);
			return;
		}
	}
	return true;
}

function createEline()
{
	if (!nextFunc())
	{
		setSelectedEmbedTab("firststep");
		return;
	}
	
	var xmlData = createElineXml();
	if(xmlData == null)
	{
		return;
	}
	var urlstr = "../../../../../../neExlorerServlet?commStr="+getNeProperty(top)["commStr"]+"&lan="+SYSTEMCONF.getLanguage()+"&sfid="+TECMDCODE_IPPTN_ADD_ELINE+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+obj["nmUser"];
	loadXMLdoc(urlstr, "POST", false, callbackCreateEline, null, "inputdata="+xmlData);
}

function createElineXml()
{

	if(!validateParams())
	{
		return null;
	}
	var root = new inputxml("datainterface");
  var business = new tagElement("bussiness-params");
  var row,param;
  createEthXML(business); 
  bIsValidateVlanID = true;
  createVuniVnniXML(business);
  if(!bIsValidateVlanID)
  {
  	return null;
  }
  createVlanSwitchXml(business);
  createPortAttributeXml(business);
  root.getRoot().appendChild(business);
  return root.toString();
}

function validateParams()
{
	var element = document.getElementById("vlanswitchcfgid");
	if(!element.checked)
	{
		return true;
	}
	var length =  vlanSwitchTable.getDataRowLength();
	for(var i=0;i<length;i++)
	{
		var srcVlan = vlanSwitchTable.getCellStoreValue(i,"srcVlanID","srcVlanID");
		var sinkVlan = vlanSwitchTable.getCellStoreValue(i,"sinkVlanID","sinkVlanID");
		if(srcVlan == "" || sinkVlan == "")
		{
			alert(RESOURCE['vlanidempty']);
			return false;
		}
	}
	return true;
}

function createVlanSwitchXml(business)
{
	var row = new tagElement("row-params");
	var rowindx = 0;  
	var length =  vlanSwitchTable.getDataRowLength();
	var element = document.getElementById("vlanswitchcfgid");
	if(!element.checked)
	{
		length =0;
	}
  for(var i=0;i<length;i++)
  {
  	var row = new tagElement("row-params");
  	if(rowindx == 0)
    {       
    	var cmdcode = "NSCMD_SERVICE_ADD_ETHSERVVLANFDB";
	    param = new tagElement("param");
	    param.setAttribute("name", "block");
	    param.setAttribute("value", cmdcode); 
	    row.appendChild(param);
    }
    rowindx++;
  	var param = new tagElement("param");
  	param.setAttribute("name", "inLogicInfID");
    param.setAttribute("value", vlanSwitchTable.getCellStoreValue(i,"srcPort","srcPort"));
    row.appendChild(param);
    
    param = new tagElement("param");
  	param.setAttribute("name", "srcVlanID");
    param.setAttribute("value", vlanSwitchTable.getCellStoreValue(i,"srcVlanID","srcVlanID"));
    row.appendChild(param);
    
    param = new tagElement("param");
  	param.setAttribute("name", "outLogicInfID");
    param.setAttribute("value", vlanSwitchTable.getCellStoreValue(i,"sinkPort","sinkPort"));
    row.appendChild(param);
    
    param = new tagElement("param");
		param.setAttribute("name", "sinkVlanID");
    param.setAttribute("value", vlanSwitchTable.getCellStoreValue(i,"sinkVlanID","sinkVlanID"));
    row.appendChild(param);
		business.appendChild(row);
  }
}

function createEthXML(business)
{
	var fstRow = new tagElement("row-params");
    
  param = new tagElement("param");    
  param.setAttribute("name", "neid");
  param.setAttribute("value", neid);
  fstRow.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "isAuto");
  param.setAttribute("value", "1");
  fstRow.appendChild(param);
  
  
  param = new tagElement("param");
  param.setAttribute("name", "serviceIndex");
  param.setAttribute("value", "1");
  fstRow.appendChild(param);
  
  var serviceID = elineAttrTable.getAttrValue("serviceId"); 
  param = new tagElement("param");
  param.setAttribute("name", "serviceID");
  param.setAttribute("value", serviceID);
  fstRow.appendChild(param);
  
  var serviceName = elineAttrTable.getAttrValue("serviceName"); 
  param = new tagElement("param");
  param.setAttribute("name", "serviceName");
  param.setAttribute("value", serviceName);
  fstRow.appendChild(param);
  
  var bpdu = elineAttrTable.getAttrValue("bpdu"); 
  param = new tagElement("param");
  param.setAttribute("name", "bpdu");
  param.setAttribute("value", bpdu);
  fstRow.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "serviceType");
  param.setAttribute("value", "1");//ELine
  fstRow.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "direct");
  param.setAttribute("value", currentDirection);//ELine
  fstRow.appendChild(param);
  business.appendChild(fstRow);
}

function createPortAttributeXml(business)
{
  var row = new tagElement("row-params"); ;
  var param;
  var rowindx = 0;  
  var cmdcode ;
  var length = portAttriTable.getDataRowLength(); 
  for(var i=0;i<length;i++)
  {
  	row = new tagElement("row-params");
  	if(rowindx == 0)
  	{
  		cmdcode = "TECMDCODE_SET_ETHPORTATTRIB";
  		param = new tagElement("param");
	    param.setAttribute("name", "block");
	    param.setAttribute("value", cmdcode); 
	    row.appendChild(param);
  	}
    rowindx++;
		param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"slotid","slotid"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "subslotid");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"subslotid","subslotid"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portid");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"portid","portid"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portEnable");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"portEnable","portEnable"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "workMode");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"workMode","workMode"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "encapType");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"encapsulationtype","encapsulationtype"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "tag");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"tagid","tagid"));
    row.appendChild(param);
	
	var vlanId = portAttriTable.getCellStoreValue(i,"vlanID","vlanID");
	if (vlanId != "-")
	{
		param = new tagElement("param");
    	param.setAttribute("name", "vlanID");
    	param.setAttribute("value", vlanId);
    	row.appendChild(param);
		
		param = new tagElement("param");
    	param.setAttribute("name", "vlanPri");
    	param.setAttribute("value", portAttriTable.getCellStoreValue(i,"vlanPri","vlanPri"));
    	row.appendChild(param);
	}
    business.appendChild(row);
  }
}

function createVuniVnniXML(business)
{
	if(currentDirection == SERVICETYPE_UNI_NNI)
  {
  	var portData = getPortAttriByDirect(ELINE_SOURCE);
  	var row = constructUniRow(portData.slotid,portData.subslotid,portData.portid,portData.tagNum,portData.tag);
  	business.appendChild(row);
  	if(createTableData.isSinkPort == true)//NNI IS PORT
  	{
  		portData = getPortAttriByDirect(ELINE_SINK);
  		row = constructNniRow("3",portData.slotid,portData.subslotid,portData.portid);
  		business.appendChild(row);
  	}
  	else//NNI IS QINQ
  	{  
  		var qinqArray = elineAttrTable.getAttrValue("sink").split("-");
  		var qinqLinkid =  qinqArray[qinqArray.length-1];
  		row = constructNniRow("4",0xffffffff,0xffffffff,qinqLinkid);
  		business.appendChild(row);
  	}
  }
    
  if(currentDirection == SERVICETYPE_NNI_NNI)
  {
  	var qinqArray = elineAttrTable.getAttrValue("source").split("-");
  	var srcQinqLinkid =  qinqArray[qinqArray.length-1];
  	row = constructNniRow("4",0xffffffff,0xffffffff,srcQinqLinkid);
  	business.appendChild(row);
  	
  	var qinqArray = elineAttrTable.getAttrValue("sink").split("-");
  	var sinQinqLinkid =  qinqArray[qinqArray.length-1];
  	row = constructNniRow("4",0xffffffff,0xffffffff,sinQinqLinkid);
  	business.appendChild(row);
  }
    
  if(currentDirection == SERVICETYPE_UNI_UNI)
  {
  	var portData = getPortAttriByDirect(ELINE_SOURCE);
  	var row = constructUniRow(portData.slotid,portData.subslotid,portData.portid,portData.tagNum,portData.tag);
  	business.appendChild(row);
  	portData = getPortAttriByDirect(ELINE_SINK);
  	var row = constructUniRow(portData.slotid,portData.subslotid,portData.portid,portData.tagNum,portData.tag);
  	business.appendChild(row);
  }
}

function callbackCreateEline(doc)
{
	var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	if(0 == errorCode) 
	{
		parentWin.queryELine();
		window.close();
	}
	else
	{
		showErrorDialog(data);
		return;
	}
}

function constructUniRow(slotid,subslotid,portid,tagNum,tagList)
{
	var row = new tagElement("row-params");
    
  var param = new tagElement("param");
  param = new tagElement("param");
  param.setAttribute("name", "portType");
  param.setAttribute("value", "uni");
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "slotid");
  param.setAttribute("value", slotid);
  row.appendChild(param);
      
  param = new tagElement("param");
  param.setAttribute("name", "subslotid");
  param.setAttribute("value", subslotid);
  row.appendChild(param);
      
  param = new tagElement("param");
  param.setAttribute("name", "portid");
  param.setAttribute("value", portid);
  row.appendChild(param);
  
  var tagIDDataArr = tagList;
  if("-" == tagList) 
  {
      tagIDDataArr = "";
  }
/*	
  if(tagList != "-")
  {
  	var isValide = validataTagList(tagList);
  	if(isValide == -1)
  	{
			bIsValidateVlanID = false;
			return null;
  	}
  	tagIDDataArr = getTagListData(tagList);
	}
	else
	{
		tagIDDataArr = [0,""];
	}
  param = new tagElement("param");
  param.setAttribute("name", "tagNum");
  param.setAttribute("value", tagIDDataArr[0]);
  row.appendChild(param);
*/
  param = new tagElement("param");
  param.setAttribute("name", "tagid");
  param.setAttribute("value", tagIDDataArr);
  row.appendChild(param);
  
  return row;
}

function constructNniRow(carrierType,carrier1,carrier2,carrier3)
{
	var row = new tagElement("row-params");
    
  var param = new tagElement("param");
  param = new tagElement("param");
  param.setAttribute("name", "portType");
  param.setAttribute("value", "nni");
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "carrierType");
  param.setAttribute("value", carrierType);
  row.appendChild(param);
      
  param = new tagElement("param");
  param.setAttribute("name", "carrier1");
  param.setAttribute("value", carrier1);
  row.appendChild(param);
      
  param = new tagElement("param");
  param.setAttribute("name", "carrier2");
  param.setAttribute("value", carrier2);
  row.appendChild(param);
  
  param = new tagElement("param");
  param.setAttribute("name", "carrier3");
  param.setAttribute("value", carrier3);
  row.appendChild(param);    
  return row;
}

function getPortAttriByDirect(direct)
{   
	var portData;
	var len = portAttriTable.getDataRowLength();
	if(len == 0)
	{
		return null;
	}
	for(var i=0;i<len;i++)
	{
		if(portAttriTable.getCellStoreValue(i,"id","id") == direct)
		{
			var slotid = portAttriTable.getCellStoreValue(i,"slotid","slotid");
			var subslotid =  portAttriTable.getCellStoreValue(i,"subslotid","subslotid");
			var portid = portAttriTable.getCellStoreValue(i,"portid","portid");
			var vlan;
			var vlanNum;
			if(direct == ELINE_SOURCE)
			{
				vlan = elineAttrTable.getAttrValue("sourceVlan");
			}
			else
			{
				vlan = elineAttrTable.getAttrValue("sinkVlan");
			}
			if(vlan == "")
			{
				vlanNum = 0;
			}
			else
			{
			   vlanNum = vlan.split(",").length;
			}
			portData = new PortData(slotid,subslotid,portid,vlanNum,vlan);
			break;
		}
	}
	return portData;
}
		
function finishFunc()
{   
	createEline();
}

function setPortAttribute()
{
	var xmlData = createSetPortAttriXml();
  var urlstr = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_SET_ETHPORTATTRIB+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+obj["nmUser"];
  loadXMLdoc(urlstr, "POST", false, callbackSetPortAttri, null, "inputdata="+xmlData);
}

function createSetPortAttriXml()
{
	var root = new inputxml("datainterface");
  var business = new tagElement("bussiness-params");
  var row;
  var param;
  
  var length = portAttriTable.getDataRowLength(); 
  for(var i=0;i<length;i++)
  {
  	row = new tagElement("row-params");
  	
  	param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
      
  	param = new tagElement("param");
    param.setAttribute("name", "slotid");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"slotid","slotid"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "subslotid");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"subslotid","subslotid"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portid");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"portid","portid"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "portEnable");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"portEnable","portEnable"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "workMode");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"workMode","workMode"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "encapType");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"encapsulationtype","encapsulationtype"));
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "tag");
    param.setAttribute("value", portAttriTable.getCellStoreValue(i,"tagid","tagid"));
    row.appendChild(param);
	
	var vlanId = portAttriTable.getCellStoreValue(i,"vlanID","vlanID");
	if (vlanId != "-")
	{
		param = new tagElement("param");
    	param.setAttribute("name", "vlanID");
    	param.setAttribute("value", vlanId);
    	row.appendChild(param);
		
		param = new tagElement("param");
    	param.setAttribute("name", "vlanPri");
    	param.setAttribute("value", portAttriTable.getCellStoreValue(i,"vlanPri","vlanPri"));
    	row.appendChild(param);
	}
    business.appendChild(row);
  }
  root.getRoot().appendChild(business);
  return root.toString();
}

function callbackSetPortAttri(doc)
{
	var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	if(0 == errorCode) 
	{
		createEline();
	}
	else
	{
		showErrorDialog(data);
		return;
	}
}

function initAttrTable()
{
    elineAttrTable = new CTable();
    elineAttrTable.addHead(RESOURCE["property"],RESOURCE["value"]);
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_serviceIdElineCreate");
    elineAttrTable.addAttrRow("serviceId", RESOURCE["serviceid"], atom);
    checkText(elineAttrTable.getAtom("serviceId").element, "1", "4294967294");
    elineAttrTable.setAttrValue("serviceId", "1");
    
    checkboxElem = document.createElement("input");
    checkboxElem.setAttribute("type","checkbox");
    checkboxElem.className = "checkboxInput";
    checkboxElem.onclick = handleCheckbox;
    checkboxElem.disabled="disabled";
    elineAttrTable.getAtom("serviceId").element.style.width = "50%";
    elineAttrTable.getAtom("serviceId").element.parentNode.appendChild(checkboxElem);
    checkboxElem.style.display = "none";
    
    var span = document.createElement("span");
    span.setAttribute("id","autospan");
    span.innerText=RESOURCE["auto"];
    elineAttrTable.getAtom("serviceId").element.parentNode.appendChild(span);
    span.style.display = "none";
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_serviceNameElineCreate");
    elineAttrTable.addAttrRow("serviceName", RESOURCE["serviceName"], atom);
    
    atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_servicedirection");
    elineAttrTable.addAttrRow("direction", RESOURCE["Direction"], atom);
    atom.element.options.add(new Option(RESOURCE["uniuni"], "2"));
    atom.element.options.add(new Option(RESOURCE["uninni"], "1")); 
    atom.element.options.add(new Option(RESOURCE["nninni"], "3"));
    atom.element["onchange"] = function()
		{
			changeDirection(this);
		}

		atom = new Atom("select");
    atom.element.setAttribute("id", "htmlSelect_bpdu");
    elineAttrTable.addAttrRow("bpdu", RESOURCE["bpdu"], atom);
    atom.element.options.add(new Option(RESOURCE["nottransparent"], "0"));
    atom.element.options.add(new Option(RESOURCE["transparentbpdu"], "1"));
    atom.element["onchange"] = function()
		{
			changeBPDU(this);
		}
    
    atom = new Atom("text");            
    atom.element.setAttribute("id", "htmlText_uni");
    elineAttrTable.addAttrRow("source", RESOURCE["source"], atom);
    var btnElem = document.createElement("button");
    btnElem.setAttribute("id", "htmlButton_uniselectbutton");
    btnElem.style.width = "35%";
    btnElem.style.height =  "3%";
    btnElem.className = "autowidthbutton";
    btnElem.value = RESOURCE["sourceSelect"];
    btnElem.onclick = handleUniSelect;
    elineAttrTable.getAtom("source").element.value ="";
    elineAttrTable.getAtom("source").element.disabled = true;
    elineAttrTable.getAtom("source").element.style.width = "65%";
    elineAttrTable.getAtom("source").element.parentNode.appendChild(btnElem);
        
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_SourceVlanID");
    elineAttrTable.addAttrRow("sourceVlan", RESOURCE["sourceVlan"], atom);
    atom.element["onkeypress"] = function()
    {
    	return checkData(this,event,1,4094);
    }
    atom.element["onblur"] = function()
    {
    	return isValidateInput(this);
    }          
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_SourcePort");
    elineAttrTable.addAttrRow("sourcePort", RESOURCE["sourcePort"], atom);
    atom.element.disabled = true;
    
    atom = new Atom("text");            
    atom.element.setAttribute("id", "htmlText_sourceSvlanID");
    elineAttrTable.addAttrRow("sourceSVlanID", RESOURCE["sourceSVlanID"], atom);
    atom.element.disabled = true;
    
    atom = new Atom("text");            
    atom.element.setAttribute("id", "htmlText_nni");
    elineAttrTable.addAttrRow("sink", RESOURCE["sink"], atom);
    var btnElem = document.createElement("button");
    btnElem.setAttribute("id", "htmlButton_nniselectbutton");
    btnElem.style.width = "35%";
    btnElem.style.height =  "3%";
    btnElem.className = "autowidthbutton";
    btnElem.value = RESOURCE["sinkSelect"];
    btnElem.onclick = handleNniSelect;
    elineAttrTable.getAtom("sink").element.value ="";
    elineAttrTable.getAtom("sink").element.disabled = true;
    elineAttrTable.getAtom("sink").element.style.width = "65%";
    elineAttrTable.getAtom("sink").element.parentNode.appendChild(btnElem);
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_sinkVlanID");
    elineAttrTable.addAttrRow("sinkVlan", RESOURCE["sinkVlan"], atom);
    atom.element["onkeypress"] = function()
    {
    	return checkData(this,event,1,4094);
    }
    atom.element["onblur"] = function()
    {
    	return isValidateInput(this);
    }  
    
    atom = new Atom("text");            
    atom.element.setAttribute("id", "htmlText_qinqlinkport");
    elineAttrTable.addAttrRow("sinkPort", RESOURCE["sinkPort"], atom);
    atom.element.disabled = true;
    
    atom = new Atom("text");
    atom.element.setAttribute("id", "htmlText_sinkSvlanID");
    elineAttrTable.addAttrRow("sinkSVlanID", RESOURCE["sinkSvlanID"], atom);
    atom.element.disabled = true;
    
    $("elinecontainer").appendChild(elineAttrTable.getTable());

}
function changeBPDU(obj)
{
	initBPDUVLAN();
}

function initParasTable()
{
    portAttriTable= new SortTable();
    portAttriTable.head.setAttribute("id", "htmlTable_STHead_portattrElanCreate");
    portAttriTable.body.setAttribute("id", "htmlTable_STBody_portattrElanCreate");
    portAttriTable.setImage("../../../../../../images/");
    portAttriTable.isUsedForSelectList = true;
    createTableHead(portAttriTable, window.tableconf[0]);
    portAttriTable.setBodyHeight("190px");
    portAttriTable.setOnCellEditHandler(cellEditHandler);
    $("portattrtable").appendChild(portAttriTable.getTable());
    $("portattrtable").oncontextmenu=popupMenuHandler;
    
    vlanSwitchTable = new SortTable();
    vlanSwitchTable.head.setAttribute("id", "htmlTable_STHead_splitElanCreate");
    vlanSwitchTable.body.setAttribute("id", "htmlTable_STBody_splitElanCreate");
    vlanSwitchTable.setImage("../../../../../../images/");
    vlanSwitchTable.isUsedForSelectList = true;
    createTableHead(vlanSwitchTable, window.tableconf[1]);
    vlanSwitchTable.setBodyHeight("120px");
    vlanSwitchTable.setOnRowSelectHandler(rowSelectHandler);
    $("vlanswitchtable").appendChild(vlanSwitchTable.getTable());
    $("vlanswitchtable").disabled = true;
    
    qosAttriTable = new SortTable();
    qosAttriTable.head.setAttribute("id", "htmlTable_STHead_qosElanCreate");
    qosAttriTable.body.setAttribute("id", "htmlTable_STBody_qosElanCreate");
    qosAttriTable.setImage("../../../../../../images/");
    qosAttriTable.isUsedForSelectList = true;
    createTableHead(qosAttriTable, window.tableconf[2]);
    qosAttriTable.setBodyHeight("120px");
    $("qostable").appendChild(qosAttriTable.getTable());
    $("qostable").disabled = true;
}

function initBPDUVLAN()
{
	if(elineAttrTable.getAttrValue("bpdu") == "1")
 	{
 		elineAttrTable.getAtom("sourceVlan").element.disabled = true;
 		elineAttrTable.getAtom("sourceVlan").element.value = "-";
 		elineAttrTable.getAtom("sinkVlan").element.disabled = true;
 		elineAttrTable.getAtom("sinkVlan").element.value = "-";
 	}
 	else
 	{
 		elineAttrTable.getAtom("sourceVlan").element.disabled = false;
 		if(elineAttrTable.getAttrValue("sourceVlan") == "-")
 		{
 			elineAttrTable.getAtom("sourceVlan").element.value = "";
 		}
 		elineAttrTable.getAtom("sinkVlan").element.disabled = false;
 		if(elineAttrTable.getAttrValue("sinkVlan") == "-")
 		{
 			elineAttrTable.getAtom("sinkVlan").element.value = "";
 		}
 	}
}

function initUniNniTable()
{
  var tbodynode = elineAttrTable.getTable().childNodes[1];
  var rowNum = tbodynode.childNodes.length;
 	for(var i=4;i<rowNum;i++)
 	{
 		tbodynode.childNodes[i].style.display = "none";
 	}
 	tbodynode.childNodes[SOURCE_INDEX].style.display = "inline";
 	tbodynode.childNodes[SOURCE_VLAN_INDEX].style.display = "inline";
 	tbodynode.childNodes[SINK_INDEX].style.display = "inline";
 	tbodynode.childNodes[SINK_PORT_INDEX].style.display = "inline";
 	tbodynode.childNodes[SINK_SVLANID_INDEX].style.display = "inline";
 	currentDirection = SERVICETYPE_UNI_NNI;
}

function initUniUniTable()
{
	var tbodynode = elineAttrTable.getTable().childNodes[1];
	var rowNum = tbodynode.childNodes.length;
 	for(var i=4;i<rowNum;i++)
 	{
 		tbodynode.childNodes[i].style.display = "none";
 	}
 	tbodynode.childNodes[SOURCE_INDEX].style.display = "inline";
 	tbodynode.childNodes[SOURCE_VLAN_INDEX].style.display = "inline";
 	tbodynode.childNodes[SINK_INDEX].style.display = "inline";
 	tbodynode.childNodes[SINK_VLAN_INDEX].style.display = "inline";
 	
 	currentDirection = SERVICETYPE_UNI_UNI;
}

function initNniNniTable()
{
	var tbodynode = elineAttrTable.getTable().childNodes[1];
	var rowNum = tbodynode.childNodes.length;
 	for(var i=4;i<rowNum;i++)
 	{
 		tbodynode.childNodes[i].style.display = "none";
 	}
 	tbodynode.childNodes[SOURCE_INDEX].style.display = "inline";
 	tbodynode.childNodes[SOURCE_PORT_INDEX].style.display = "inline";
 	tbodynode.childNodes[SOURCE_SVLANID_INDEX].style.display = "inline";
 	tbodynode.childNodes[SINK_INDEX].style.display = "inline";
 	tbodynode.childNodes[SINK_PORT_INDEX].style.display = "inline";
 	tbodynode.childNodes[SINK_SVLANID_INDEX].style.display = "inline";
 	currentDirection = SERVICETYPE_NNI_NNI;
}

function handleCheckbox()
{
	var serviceid  = elineAttrTable.getAtom("serviceId").element;
  if (checkboxElem.checked)
  {       
    serviceid.disabled = true;
    serviceid.value = "";
  }
  else
  {
    serviceid.disabled = false;
    serviceid.value = "1";
  }
}

function cellEditHandler(param)
{
	var editRow = param.rowindex;
	var colid = param.colid;
	if(colid == "encapsulationtype")
	{
		var encapType = portAttriTable.getCellStoreValue(editRow,"encapsulationtype","encapsulationtype");
		var logicInfType = portAttriTable.getCellStoreValue(editRow,"uninnitype","uninnitype");
		var tagidCell = portAttriTable.getCell(editRow,"tagid");
		var vlanIDCell = portAttriTable.getCell(editRow,"vlanID");
		var colary = new Array("tagid");
		if(encapType == "1")//802.1Q
		{
			if(tagidCell.element.isEdit != "1" && currentDirection != SERVICETYPE_UNI_NNI)
			{
				setCellStatus(portAttriTable,editRow, colary, 1, "#ffffff", cellondbclick);
				portAttriTable.setCellValue(tagidCell,"tagid","1");
				portAttriTable.getCellShow(editRow,"tagid").setValue("Tag Aware");
				if (vlanIDCell.element.isEdit != "1") 
				{
					portAttriTable.setCellIsEdit(vlanIDCell, 1);
					portAttriTable.setCellValue(vlanIDCell, "vlanID", "1");
					portAttriTable.getCellShow(editRow, "vlanID").setValue("1");
					textCheck(vlanIDCell.element.editElement.element, "1", "4094");
				}
			}
		}
		else if(encapType == "0")//none
		{
			if(tagidCell.element.isEdit != "0")
			{
				setCellStatus(portAttriTable,editRow, colary, 0, "#E8E8E8", null);
			}
			portAttriTable.setCellValue(tagidCell,"tagid","-");
			portAttriTable.getCellShow(editRow,"tagid").setValue("-");
			
			portAttriTable.setCellIsEdit(vlanIDCell, 0);
			portAttriTable.setCellValue(vlanIDCell,"vlanID","-");
			portAttriTable.getCellShow(editRow,"vlanID").setValue("-");
		}
		else
		{
			if(tagidCell.element.isEdit != "0")
			{
				setCellStatus(portAttriTable,editRow, colary, 0, "#E8E8E8", null);
			}
			portAttriTable.setCellValue(tagidCell,"tagid","1");
			portAttriTable.getCellShow(editRow,"tagid").setValue("Tag Aware");
			
			portAttriTable.setCellIsEdit(vlanIDCell, 0);
			portAttriTable.setCellValue(vlanIDCell,"vlanID","-");
			portAttriTable.getCellShow(editRow,"vlanID").setValue("-");
		}
	}
	/*
	if (colid == "tagid") 
	{
		var tagId = portAttriTable.getCellStoreValue(editRow,"tagid","tagid");
		var vlanIDCell = portAttriTable.getCell(editRow,"vlanID");
		if(tagId == "0" || tagId == "2")//Access or Hybrid
		{
			if (vlanIDCell.element.isEdit != "1") 
			{
				portAttriTable.setCellIsEdit(vlanIDCell, 1);
				portAttriTable.setCellValue(vlanIDCell, "vlanID", "1");
				portAttriTable.getCellShow(editRow, "vlanID").setValue("1");
				textCheck(vlanIDCell.element.editElement.element, "1", "4094");
			}
		}
		else//Tag Aware
		{
			portAttriTable.setCellIsEdit(vlanIDCell, 0);
			portAttriTable.setCellValue(vlanIDCell, "vlanID", "-");
			portAttriTable.getCellShow(editRow,"vlanID").setValue("-");
		}
	}*/
}

/**
 * Service Type Select handler
 */
function changeDirection(selectDirection)
{	
	 var selectvalue = selectDirection.value;
	 if(selectvalue == SERVICETYPE_UNI_NNI && selectvalue != currentDirection)
	 {
     initUniNniTable();
     clearCreateTableData();
     refreshCreateTable();
	 }
	 if(selectvalue == SERVICETYPE_UNI_UNI && selectvalue != currentDirection)
	 {
     initUniUniTable();
     clearCreateTableData();
     refreshCreateTable();
	 }
	 if(selectvalue == SERVICETYPE_NNI_NNI && selectvalue != currentDirection)
	 {
     initNniNniTable();
     clearCreateTableData();
     refreshCreateTable();
	 }
	 initBPDUVLAN();
}

function handleNniSelect()
{
	if(currentDirection == SERVICETYPE_UNI_NNI)
	{
		xshowModalDialog("portqinqselect.html?flag="+ELINE_SINK, RESOURCE["portselect"], 550, 410, "../../../../../../images/");	
	}
	else if(currentDirection == SERVICETYPE_UNI_UNI)
	{
		xshowModalDialog("portselect.html?flag="+ELINE_SINK, RESOURCE["portselect"], 280, 360, "../../../../../../images/");	
	}
	else if(currentDirection == SERVICETYPE_NNI_NNI)
	{
		xshowModalDialog("qinqselect.html?flag="+ELINE_SINK, RESOURCE["portselect"], 600, 350, "../../../../../../images/");	
	}		
}

function handleUniSelect()
{
	if(currentDirection == SERVICETYPE_UNI_NNI || currentDirection == SERVICETYPE_UNI_UNI)
	{
		xshowModalDialog("portselect.html?flag="+ELINE_SOURCE, RESOURCE["portselect"], 280, 360, "../../../../../../images/");	
	}
	else if(currentDirection == SERVICETYPE_NNI_NNI)
	{
		xshowModalDialog("qinqselect.html?flag="+ELINE_SOURCE, RESOURCE["portselect"], 600, 352, "../../../../../../images/");	
	}	
}

/**
 * create Vlan Switch Table
 */
function createVlanSwitch()
{
	var defaultArray;
	tc = window.tableconf[1];
	if(currentDirection == SERVICETYPE_UNI_UNI )
	{
    defaultArray = new Array(createTableData.source,"",createTableData.sink,"");
    var rowindex =createTableRow(vlanSwitchTable, tc, defaultArray,RESOURCE);	
    /*var opts = new Array();
    var sourceVlan = elineAttrTable.getAttrValue("sourceVlan");
    var tagIDDataArr = getTagListData(sourceVlan);
    var array = tagIDDataArr[1].split(",");
    for(var i=0;i<array.length;i++)
    {
    	opts[i] = new Option(array[i],array[i]);
    }
    
    editElementAdd(vlanSwitchTable, rowAddIndex, "srcVlanID", "select", opts, 0);
    */
    var rowAddIndex = vlanSwitchTable.getDataRowLength()-1;
    var opts = new Array();
    opts[0] = new Option(createTableData.source,1);
    opts[1] = new Option(createTableData.sink,2);
    editElementAdd(vlanSwitchTable, rowAddIndex, "srcPort", "select", opts, 0);
    editElementAdd(vlanSwitchTable, rowAddIndex, "sinkPort", "select", opts, 1);
        
		var atom = vlanSwitchTable.getCellEdit(rowindex,"srcVlanID");
    checkDataCellEvent(atom.element,1,4094,4,1);

    atom = vlanSwitchTable.getCellEdit(rowindex,"sinkVlanID");
		checkDataCellEvent(atom.element,1,4094,4,1);
	}	
}

function rowSelectHandler(params)
{
	for(var i = 0,m = vlanSwitchTable.getDataRowLength();i < m;i++)
	{
		var row = vlanSwitchTable.getRow(i);
		var color = "#ffffff";
		if(row.element.selectFlag)
		{
			color = "#6f99a5";
		}
		for(var k=0,lens=row.element.children.length;k<lens;k++)
		{
			row.element.children[k].style.backgroundColor = color;
		}
	}
	if(vlanSwitchTable.getSelectedRows().length > 0)
	{
		$("deletebtn").disabled = false;
	}
}

function deleteVlanSwitch()
{
	var selRows = vlanSwitchTable.getSelectedRows();
	
	for(var i=0;i<selRows.length;i++)
	{
		vlanSwitchTable.deleteRow(selRows[i])
	}
	vlanSwitchTable.adjustDataRows();
	if (vlanSwitchTable.getDataRowLength() <= 0)
	{
		$("deletebtn").disabled = true;
	}
}

function selectVlanSwitchCheckBox()
{
	var element = document.getElementById("vlanswitchcfgid");
	if(element.checked && (currentDirection == SERVICETYPE_UNI_UNI))
	{
		var len = portAttriTable.getDataRowLength();
		if(len != 2)
		{
			alert(RESOURCE["inputport"]);
			$("vlanswitchcfgid").checked = false;
			return;
		}
		$("vlanswitchtable").disabled = false
		$("newbtn").disabled = false;
		if(vlanSwitchTable.getSelectedRows().length > 0)
		{
			$("deletebtn").disabled = false;
		}
	}
	else
	{
		$("vlanswitchtable").disabled = true;
		$("deletebtn").disabled = true;
		$("newbtn").disabled = true;
	}
}

function selectQoscfgCheckBox()
{
	var element = document.getElementById("vlanswitchcfgid");
	if(element.checked)
	{
		$("qosAttriTable").disabled = false
		showQosTableData();
	}
	else
	{
		$("qosAttriTable").disabled = true;
	}
}

function showQosTableData()
{
	var defaultArray;
	tc = window.tableconf[2];
	qosAttriTable.clearTableData();
	
	if(urrentDirection == SERVICETYPE_UNI_NNI)
	{
		defaultArray = new Array(createTableData.source,VUNI_TEMP_ID1,"1","2","","8","3","","","","");
		constructRow(qosAttriTable, tc, defaultArray);
		defaultArray = new Array(createTableData.source,VUNI_TEMP_ID1,"2","2","","","","","","");
		constructRow(qosAttriTable, tc, defaultArray);
	}
	
	if(currentDirection == SERVICETYPE_UNI_UNI)
	{
		defaultArray = new Array(createTableData.source,VUNI_TEMP_ID1,"1","2","","8","3","","","","");
		constructRow(qosAttriTable, tc, defaultArray);
		defaultArray = new Array(createTableData.source,VUNI_TEMP_ID1,"2","2","","","","","","");
		constructRow(qosAttriTable, tc, defaultArray);
		
		defaultArray = new Array(createTableData.sink,VUNI_TEMP_ID2,"1","2","","8","3","","","","");
		constructRow(qosAttriTable, tc, defaultArray);
		defaultArray = new Array(createTableData.sink,VUNI_TEMP_ID2,"2","2","","","","","","");
		constructRow(qosAttriTable, tc, defaultArray);
	}
	var len = qosAttriTable.getDataRowLength();
	var colary = new Array();
	for(var i=0;i<len;i++)
	{
		qosAttriTable.getCellEdit(i, "bandwidthlimit").element.onchange = handleBandLimitChange0;
		qosAttriTable.getCellEdit(i, "policy").element.onmousedown = handlePolicySelect;
		qosAttriTable.getCellEdit(i, "policy").element.onkeydown = function()
		{
			return false;
		}						
		qosAttriTable.getCellEdit(i, "policy").element.onkeypress = function()
		{
			return false;
		}
		if(qosAttriTable.getCellStoreValue(i,"getCellStoreValue","getCellStoreValue") == "1")//ingress
		{
		  colary = new Array("cir","pir","cbs","pbs");
		}
		else
		{
			colary = new Array("cir","pir","cbs","pbs","forwardpir","relabelcolor");
		}
		setCellStatus(st, i, colary, 0, "#E8E8E8", null);
	}
}

function handleBandLimitChange0()
{
	var colary = new Array("cir","pir");
	var rowindex = obj.parentNode.parentNode.rowIndex;
	if(this.value == "2")
	{
		setCellStatus(qosAttriTable, rowindex, colary, 0, color_nonedit, null);				
		setCellDefault(qosAttriTable, rowindex, colary, invalid_char);
	}
	else
	{
		setCellStatus(qosAttriTable, rowindex, colary, 1, color_desel, cellondbclick);
		setCellDefault(qosAttriTable, rowindex, colary, "64");
	}
}

var policyDialog = null;
function handlePolicySelect()
{
	if (0 == count)
  {
  	count = 1;
  }
  else
  {
  	return;
  }
  
  if (wfqDialog)
	{
		return;
	}
	editPolicyRow = this.parentNode.parentNode.rowIndex;
	editPolicyCell = qosAttriTable.getCell(editPolicyRow, "wfqPolicy");
	policyDialog = xshowModalDialog("policyselect.html", RESOURCE["policy"], 700, 450, "../../../../../../images/");
	count = 0;
}

/**
 * refresh table data by CreateTableData
 */
function refreshCreateTable()
{
	elineAttrTable.getAtom("source").element.value=(createTableData.source!=null)?createTableData.source:"";
  elineAttrTable.getAtom("sourcePort").element.value=(createTableData.sourcePort!=null)?createTableData.sourcePort:"";
  elineAttrTable.getAtom("sourceSVlanID").element.value=(createTableData.sourceSVlanID!=null)?createTableData.sourceSVlanID:"";
  elineAttrTable.getAtom("sink").element.value=(createTableData.sink!=null)?createTableData.sink:"";
  elineAttrTable.getAtom("sinkPort").element.value=(createTableData.sinkPort!=null)?createTableData.sinkPort:"";
  elineAttrTable.getAtom("sinkSVlanID").element.value=(createTableData.sinkSVlanID!=null)?createTableData.sinkSVlanID:"";
}

/**
 * refresh portAttri table by createTableData
 * id(1:src   2:sink)
 * type(1:uni port 2:nni port)
 */
function refreshPortAttriTable(id,type,port)
{
	var length = portAttriTable.getDataRowLength();
	for(var i=0;i<length;i++)
	{
		var existid = portAttriTable.getCellStoreValue(i,"id","id");
		if(id == existid)
		{
			portAttriTable.deleteRow(i);
			break;
		}
	}
	portAttriTable.adjustDataRows();
	
	var defaultVal;
	
	/*
	 *     EFP8         
	 */
	var valenable = 1;
	var valmode = 0;
	if (port.portName.indexOf("IF") >= 0 || port.portName.indexOf("EFP8") >= 0 )
	{
		valenable = "-";
		valmode = "-";
	}
	
	if(type == TYPE_UNI_PORT)
	{
		defaultVal = new Array(id,type,port.portName,port.slotid,port.subslotid,port.portid,valenable,valmode,1,1,"-",0);
	}
	else if(type == TYPE_NNI_PORT)
	{
		defaultVal = new Array(id,type,port.portName,port.slotid,port.subslotid,port.portid,valenable,valmode,2,1,"-",0);
	}
	createTableRow(portAttriTable, window.tableconf[0], defaultVal,RESOURCE);
	setPortAttriTableDefault(portAttriTable,type);
	adjustTableEnable();
}

function adjustTableEnable()
{
	for (var i=0,len=portAttriTable.getDataRowLength();i<len;i++)
	{
		if (portAttriTable.getCellStoreValue(i,"workMode","workMode") == "-")
		{
			portAttriTable.setCellIsEdit(portAttriTable.getCell(i, "workMode"),"0");
		}
	}
}

function deletePortAttriRowById(id)
{
	var length = portAttriTable.getDataRowLength();
	for(var i=0;i<length;i++)
	{
		var existid = portAttriTable.getCellStoreValue(i,"id","id");
		if(id == existid)
		{
			portAttriTable.deleteRow(i);
			break;
		}
	}
	portAttriTable.adjustDataRows();
}

/**
 * nniType:1 port    2:qinq
 */
function refreshNniQinqTableStruct(nniType)
{
	if(nniType == SELECTED_NNI_TYPE_PORT)//select port
  {
  	if(currentNniType == CURRENT_NNI_TYPE_PORT)
  	{
  		return;
  	}
  	else
  	{
  		var showIndexlist = new Array(SOURCE_INDEX,SOURCE_VLAN_INDEX,SINK_INDEX,SINK_VLAN_INDEX);
  		showTableRelatedRows(showIndexlist);
  		currentNniType = CURRENT_NNI_TYPE_PORT;  		
  	}
  }
    
  if(nniType == SELECTED_NNI_TYPE_QINQ)
  {
  	if(currentNniType == CURRENT_NNI_TYPE_QINQ)
  	{
  		return;
  	}
  	else
  	{
  		var showIndexlist = new Array(SOURCE_INDEX,SOURCE_VLAN_INDEX,SINK_INDEX,SINK_PORT_INDEX,SINK_SVLANID_INDEX);
  		showTableRelatedRows(showIndexlist);
  		currentNniType = CURRENT_NNI_TYPE_QINQ;
  	}
  }		
}

function showTableRelatedRows(showIndexList)
{
	var len = showIndexList.length;
	if(len == 0)
	{
		return;
	}
	var tbodynode = elineAttrTable.getTable().childNodes[1];
	var rowNum = tbodynode.childNodes.length;
 	for(var i=4;i<rowNum;i++)
 	{
 		tbodynode.childNodes[i].style.display = "none";
 	}
 	for(var i=0;i<len;i++)
 	{
 	  if(tbodynode.childNodes[i])	
		{
			tbodynode.childNodes[showIndexList[i]].style.display = "inline";
		}
 	}
}

function setCellStatus(st,row, colAry, isEdit, color, dbclickFunc)
{
	for (var i=0; i<colAry.length; i++)
	{
		st.setCellIsEdit(st.getCellElement(row, colAry[i]),isEdit);
	}
}

function setPortAttriTableDefault(st,logicInfType)
{
    if(st.getDataRowLength()==0)
    {
			return;
    }
    var rowindex = st.getDataRowLength()-1;
		var uninnitype = st.getCellStoreValue(rowindex,"uninnitype","uninnitype");
		var encapsulationtype = st.getCellStoreValue(rowindex,"encapsulationtype","encapsulationtype");
		var encapCell = st.getCell(rowindex,"encapsulationtype");
		var tagidCell = st.getCell(rowindex,"tagid");
		var vlanCell = st.getCell(rowindex,"vlanID");
		if(currentDirection == SERVICETYPE_UNI_NNI)//UNI-NNI
		{
			if(logicInfType == TYPE_UNI_PORT)
			{
				st.setCellValue(encapCell,"encapsulationtype",1);//802.1Q
				st.setCellValue(tagidCell,"tagid",1);//tagAward
				st.setCellIsEdit(encapCell,1);
				st.setCellIsEdit(tagidCell,1);//NNI        tagAward  
				st.setCellIsEdit(vlanCell, 1);
				st.setCellValue(vlanCell,"vlanID",1);
				st.getCellShow(rowindex,"vlanID").setValue("1");
				textCheck(vlanCell.element.editElement.element, "1", "4094");
			}
			else if(logicInfType == TYPE_NNI_PORT)
			{
				st.setCellValue(encapCell,"encapsulationtype",2);//QINQ
				st.setCellIsEdit(encapCell,0);
				st.setCellValue(tagidCell,"tagid","-");
				st.setCellIsEdit(tagidCell,0);
			}
		}
		else if(currentDirection == SERVICETYPE_UNI_UNI)//UNI-UNI
		{
			if(logicInfType == TYPE_UNI_PORT)
			{
				st.setCellValue(encapCell,"encapsulationtype",1);//802.1\Q
				st.setCellValue(tagidCell,"tagid",1);//tagAward
				st.setCellIsEdit(tagidCell,1);
				st.setCellIsEdit(vlanCell, 1);
				st.setCellValue(vlanCell,"vlanID",1);
				st.getCellShow(rowindex,"vlanID").setValue("1");
				textCheck(vlanCell.element.editElement.element, "1", "4094");
			}
		}
		else if(currentDirection == SERVICETYPE_NNI_NNI)//NNI-NNI
		{
			st.element.style.disable = true;
		}
}

function showErrorDialog(di)
{
  var errArr = [];
  var errorObj = null;
  var operObj;
  var serviceID = elineAttrTable.getAttrValue("serviceId");
	var serviceName = elineAttrTable.getAttrValue("serviceName");
	operObj =  RESOURCE["serviceid"]+":"+serviceID+" "+RESOURCE["serviceName"]+":"+serviceName;
  for(var i = 0, len = di.getBErrLength(); i < len; i++)
  {
		errorObj = di.getError().rowErrors[i].errorObj;
		errorObj["operationObj"] = operObj;
  }
  errArr[0] = "operationObj";
  openErrPage("../../../../../../page/", di.getError(), errArr);
}

function clearCreateTableData()
{
    createTableData.source = "";
    createTableData.sourcePort = "";
    createTableData.sourceSVlanID = "";
    createTableData.sourceVlan ="";
    createTableData.sink ="";
    createTableData.sinkPort ="";
    createTableData.sinkSVlanID ="";
    createTableData.sinkVlan ="";
    portAttriTable.clearTableData();
}
