var ispbuni = parobj.ispbuni;
var macsflntypeValue = parobj.macsflntypeValue;
var IVL = "2";
var SVL = "1";
var NETYPE_950A = "114";
var NETYPE_905 = "95";
var isSupportVPLS = SpecialAttrMgr.isNESupport(neid,"TE_FUNC_MSTP_CFG_ETHER_ELAN","ELAN_ATTR_SUPPORT_VPLS");
var netype = parobj.netype;
var existVuniID;

if(!macsflntypeValue)
{
	macsflntypeValue = parobj.parobj.macsflntypeValue;;
}
/*************************
 * init right select table
 **************************/
function initCT()
{
	if (tagtype == tagType_CAwared) 
    {
    	if(!isSupportPbunni() && !isSupportVPLS)
    	{
    		if(macsflntypeValue == IVL)
        	{
        		window.tableconf[0].colArray[4].width = "50%";//portname
                window.tableconf[0].colArray[5].width = 0;//porttype
                window.tableconf[0].colArray[6].width = "50%";//vlan(tagID)
                window.tableconf[0].colArray[7].width = 0;//svlan
                window.tableconf[0].colArray[8].width = 0;
        	}else{
        		window.tableconf[0].colArray[4].width = "40%";//portname
                window.tableconf[0].colArray[5].width = 0;//porttype
                window.tableconf[0].colArray[6].width = "30%";//vlan(tagID)
                window.tableconf[0].colArray[7].width = 0;//svlan
                window.tableconf[0].colArray[8].width = "30%";
        	}
    	}else{
    		window.tableconf[0].colArray[4].width = "40%";//portname
            window.tableconf[0].colArray[5].width = 0;//porttype
            window.tableconf[0].colArray[6].width = "30%";//vlan(tagID)
            window.tableconf[0].colArray[7].width = 0;//svlan
            window.tableconf[0].colArray[8].width = "30%";
    	}
  
        ct.deleteHeadRow();
        createTableHead(ct, window.tableconf[0]);
        ct.getHeadCell("tagID").setValue("VLAN(1,3-5)");
    }
    else if (tagtype == tagType_SAwared) 
    {
    	if(!isSupportPbunni() && !isSupportVPLS)
    	{
    		intAwaredTable();
    	}else{
    		intAwaredTableFor950A();
    	}    
    	ct.clearTableData();
        ct.deleteHeadRow();
        createTableHead(ct, window.tableconf[0]);
    }
    else //tag-transparent
     {
        window.tableconf[0].colArray[4].width = "100%";
        window.tableconf[0].colArray[5].width = 0;
        window.tableconf[0].colArray[6].width = 0;
        window.tableconf[0].colArray[7].width = 0;
        ct.clearTableData();
        ct.deleteHeadRow();
        createTableHead(ct, window.tableconf[0]);
    }
    
    initCTData();
}

function isSupportPbunni()
{
	return((NETYPE_950A == netype) || (NETYPE_905 == netype));
}

/**
 * RTN950A        TAG               
 * @return
 */
function intAwaredTableFor950A()
{
	var cellEdit = window.tableconf[0].colArray[5].cell.editElement;
    cellEdit.options.length = 0;
    var opobj;
	if(macsflntypeValue == IVL)
	{
		if(ispbuni)
		{
			if (paporttype == "uni")
			{
	    		window.tableconf[0].colArray[4].width = "25%";
	            window.tableconf[0].colArray[5].width = "25%";
	            window.tableconf[0].colArray[6].width = "25%";
	            window.tableconf[0].colArray[7].width = "25%";
	            window.tableconf[0].colArray[8].width = 0;
	            
	            opobj = new OPTag();
	            opobj.name = "UNI(Port+C-VLAN+S-VLAN)";
	            opobj.value = "4";
	            opobj.convert = "porttype";
	            cellEdit.options[cellEdit.options.length] = opobj;
	    	
			}else{
	    		window.tableconf[0].colArray[4].width = "40%";
	            window.tableconf[0].colArray[5].width = "30%";
	            window.tableconf[0].colArray[6].width = 0;
	            window.tableconf[0].colArray[7].width = "30%";
	            window.tableconf[0].colArray[8].width = 0;
	            
	            opobj = new OPTag();
	            opobj.name = "NNI";
	            opobj.value = "5";
	            opobj.convert = "porttype";
	            cellEdit.options[cellEdit.options.length] = opobj;	    	
			}			
		}else{
			
			if (paporttype == "uni")
			{
				window.tableconf[0].colArray[4].width = "40%";
	            window.tableconf[0].colArray[5].width = "30%";
	            window.tableconf[0].colArray[6].width = "30%";
	            window.tableconf[0].colArray[7].width = 0;
	            window.tableconf[0].colArray[8].width = 0;
	            
	            opobj = new OPTag();
	            opobj.name = "UNI";
	            opobj.value = "1";
	            opobj.convert = "porttype";
	            cellEdit.options[cellEdit.options.length] = opobj;	
			}else{
				window.tableconf[0].colArray[4].width = "40%";
	            window.tableconf[0].colArray[5].width = "30%";
	            window.tableconf[0].colArray[6].width = 0;
	            window.tableconf[0].colArray[7].width = "30%";
	            window.tableconf[0].colArray[8].width = 0;
	            
	            opobj = new OPTag();
	            opobj.name = "NNI";
	            opobj.value = "2";
	            opobj.convert = "porttype";
	            cellEdit.options[cellEdit.options.length] = opobj;	
			}
		}
	}else{
		window.tableconf[0].colArray[4].width = "25%";
        window.tableconf[0].colArray[5].width = "25%";
        window.tableconf[0].colArray[6].width = 0;
        window.tableconf[0].colArray[7].width = "25%";
        window.tableconf[0].colArray[8].width = "25%";
        
        opobj = new OPTag();
        opobj.name = "UNI(Port+S-VLAN)";
        opobj.value = "3";
        opobj.convert = "porttype";
        cellEdit.options[cellEdit.options.length] = opobj;	
	}		
}

/**
 *   RTN900        TAG               
 * @return
 */
function intAwaredTable()
{
    var cellEdit = window.tableconf[0].colArray[5].cell.editElement;
    cellEdit.options.length = 0;
    var opobj;
	if (paporttype == "uni") 
	{
	    	if(macsflntypeValue == IVL)
	    	{
	    		window.tableconf[0].colArray[4].width = "25%";
	            window.tableconf[0].colArray[5].width = "25%";
	            window.tableconf[0].colArray[6].width = "25%";
	            window.tableconf[0].colArray[7].width = "25%";
	            window.tableconf[0].colArray[8].width = 0;
	            
	             opobj = new OPTag();
		         opobj.name = "UNI(Port+C-VLAN+S-VLAN)";
		         opobj.value = "4";
		         opobj.convert = "porttype";
		         cellEdit.options[cellEdit.options.length] = opobj; 
	    }else{
	    		window.tableconf[0].colArray[4].width = "25%";
	            window.tableconf[0].colArray[5].width = "25%";
                window.tableconf[0].colArray[6].width = 0;
	            window.tableconf[0].colArray[7].width = "25%";
	            window.tableconf[0].colArray[8].width = "25%";
	            
	             opobj = new OPTag();
		         opobj.name = "UNI(Port+S-VLAN)";
		         opobj.value = "3";
		         opobj.convert = "porttype";
		         cellEdit.options[cellEdit.options.length] = opobj; 
	    	}

	        ct.deleteHeadRow();
	        createTableHead(ct, window.tableconf[0]);
	        ct.getHeadCell("tagID").setValue("C-VLAN(1,3-5)");
	        ct.getHeadCell("svlan").setValue("S-VLAN");
	}
    else 
     {
        window.tableconf[0].colArray[4].width = "40%";
        window.tableconf[0].colArray[5].width = "30%";
        window.tableconf[0].colArray[6].width = 0;
        window.tableconf[0].colArray[7].width = "30%";
        if(macsflntypeValue == IVL)
    	{
        	opobj = new OPTag();
            opobj.name = "NNI";
            opobj.value = "5";
            opobj.convert = "porttype";
            cellEdit.options[cellEdit.options.length] = opobj;
    	}else{
    		opobj = new OPTag();
            opobj.name = "NNI";
            opobj.value = "2";
            opobj.convert = "porttype";
            cellEdit.options[cellEdit.options.length] = opobj;
    	}
 
        ct.deleteHeadRow();
        createTableHead(ct, window.tableconf[0]);
        ct.getHeadCell("tagID").setValue("C-VLAN");
        ct.getHeadCell("svlan").setValue("S-VLAN");
    }
}	
	
/*******************************
 * init right select table data
 *                      
 *                      
 ********************************/
function initCTData()
{
    var tempst = parobj.confporttab;//parent window table
    if (!creatflag)//true:parent window is management. false:parent window is create window
    {
        tempst = parobj.portTab;
    }
    g_slotList = [];
    var selectedRows = tempst.getDataRowLength();
    
    for (var i = 0, len = selectedRows; i < len; i++) 
    {
        var vuniid = tempst.getCellStoreValue(i, "vuniID", "vuniID");
        var slotid = tempst.getCellStoreValue(i, "slotid", "slotid");
        var boardName = tempst.getCellStoreValue(i, "boardName", "boardName");
        var portid = tempst.getCellStoreValue(i, "portid", "portid");
        var portname = tempst.getCellStoreValue(i, "portname", "portname");
        var porttypevalue = tempst.getCellStoreValue(i, "porttype", "porttype");
        var cvlan = tempst.getCellStoreValue(i, "tagID", "tagID");
        var svlan = tempst.getCellStoreValue(i, "svlan", "svlan");
        var vlanfilter = tempst.getCellStoreValue(i, "vlanfilter", "vlanfilter");
        
        var obj = new Object();
        var ptag = new ParamTag();
        ptag.value = vuniid;
        obj["vuniID"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = slotid;
        obj["slotid"] = ptag;
        
        if(g_slotList.indexOf(slotid) == -1)
        {
        	g_slotList[g_slotList.length] = slotid;
        }
        
        ptag = new ParamTag();
        ptag.value = boardName;
        obj["boardName"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portid;
        obj["portid"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portname;
        obj["portname"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = porttypevalue;
        obj["porttype"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = cvlan;
        obj["tagID"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = svlan;
        obj["svlan"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = vlanfilter;
        obj["vlanfilter"] = ptag;
        
        if(((paporttype=="uni")&& ((porttypevalue == portType_Uni)||(porttypevalue == portType_Pbuni)||(porttypevalue == portType_Pbsuni)))
		||((paporttype=="nni")&& ((porttypevalue == portType_Nni)||(porttypevalue == portType_Pbnni))))
		{
        	iniSelectedPortData.rows.push(obj);
		}
    }
    
    if(g_slotList.length > 0)
    {
    	for(var i = 0,len = g_slotList.length;i < len;i++)
    	{
    		g_slotid = g_slotList[i];
    		getPortNeAttr();
    	}
    }
    
    ct.clearTableData();

    createTableBody(ct, window.tableconf[0], iniSelectedPortData, RESOURCE);
	for( var i = 0; i < ct.getDataRowLength(); i++ )
    {
    	var tSlotID = ct.getCellStoreValue(i, "slotid", "slotid");
    	if( tSlotID == "65535" )
    	{
    		var portNameShow = ct.getCellShow(i, "portname");
    		portNameShow.setValue("NMS-1");
    	}
    }
    addCellEvent();
}

function checkVLANValue(value)
{
	return (typeof(value) != "undefined" && value != "" && value != "-");
}

function addCellEvent()
{
    var cell = null;
    var vlanFilterCell = null;
    var cvlanCell = null;
    var svlanCell = null;
    var rowindex;
    for (var i = 0, len = ct.getDataRowLength(); i < len; i++) 
    {
        cell = ct.getCell(i, "porttype");
        cvlanCell = ct.getCell(i, "tagID");
		var vlanFilterCell = ct.getCell(i, "vlanfilter");
		if(vlanFilterCell != null)
		{
			var tagIDValue = ct.getCellStoreValue(i,"tagID","tagID");
			var svlanValue = ct.getCellStoreValue(i,"svlan","svlan");

			if((checkVLANValue(tagIDValue))
			|| (checkVLANValue(svlanValue)))
			{
				ct.setCellIsEdit(ct.getCell(i, "vlanfilter"), 0);
			}
			var vlanfilterValue = ct.getCellStoreValue(i,"vlanfilter","vlanfilter");
			if(checkVLANValue(vlanfilterValue))
			{
				ct.setCellIsEdit(ct.getCell(i, "tagID"), 0);
				ct.setCellIsEdit(ct.getCell(i, "svlan"), 0);
			}
		}
		
        cvlanCell.element.editElement.element["onkeypress"] = function()
        {
            return checkData(this, event, 1, 4094);
        } 

        cvlanCell.element.editElement.element["onchange"] = function()
        {
        	var rowindex = this.parentNode.parentNode.rowIndex;
        	var vlanFilterCell = ct.getCell(rowindex, "vlanfilter");
			if (vlanFilterCell != null) 
			{
				if (this.value != "") 
				{
					vlanFilterCell.element.showElement.setValue("-");
					vlanFilterCell.element.editElement.setValue("-");
					ct.setCellValue(vlanFilterCell, "vlanfilter", "-");
					ct.setCellIsEdit(vlanFilterCell, 0);
				}
				else 
				{
					vlanFilterCell.element.showElement.setValue("");
					vlanFilterCell.element.editElement.setValue("");
					ct.setCellValue(vlanFilterCell, "vlanfilter", "");
					ct.setCellIsEdit(vlanFilterCell, 1);
				}
			}
        }
        
        svlanCell = ct.getCell(i, "svlan");
        if (paporttype == "nni" || macsflntypeValue == macsflntype_SVL &&  tagtype == tagType_SAwared) 
        {
        	svlanCell.element.editElement.element["onkeypress"] = function()
            {
                return checkData(this, event, 1, 4094);
            }
        }
        else 
        {
			/**
			     DTS2011011005005              RTN900V1R3C00  Weblct     
			*/
            textCheckWithNull(svlanCell.element.editElement.element, MIN_VLANID, MAX_VLANID);
        }
        svlanCell.element.editElement.element["onchange"] = function()
        {
        	var rowindex = this.parentNode.parentNode.rowIndex;
        	var vlanFilterCell = ct.getCell(rowindex, "vlanfilter");
			if (vlanFilterCell != null) 
			{
				if (this.value != "") 
				{
					vlanFilterCell.element.showElement.setValue("-");
					vlanFilterCell.element.editElement.setValue("-");
					ct.setCellValue(vlanFilterCell, "vlanfilter", "-");
					ct.setCellIsEdit(vlanFilterCell, 0);
				}
				else 
				{
					vlanFilterCell.element.showElement.setValue("");
					vlanFilterCell.element.editElement.setValue("");
					ct.setCellValue(vlanFilterCell, "vlanfilter", "");
					ct.setCellIsEdit(vlanFilterCell, 1);
				}
			}
        }
        
        vlanFilterCell = ct.getCell(i, "vlanfilter");
        vlanFilterCell.element.editElement.element["onkeypress"] = function()
        {
            return checkData(this, event, 1, 4094);
        } 

        vlanFilterCell.element.editElement.element["onchange"] = function()
        {
        	var rowindex = this.parentNode.parentNode.rowIndex;
        	var svlanCell = ct.getCell(rowindex, "svlan");
			var cvlanCell = ct.getCell(rowindex, "tagID");
			if (this.value != "") 
			{
				svlanCell.element.showElement.setValue("-");
				svlanCell.element.editElement.setValue("-");
				ct.setCellValue(svlanCell, "svlan", "-");
				ct.setCellIsEdit(svlanCell, 0);
				if(!(macsflntypeValue == macsflntype_SVL &&  tagtype == tagType_SAwared))
				{
					cvlanCell.element.showElement.setValue("-");
		        	cvlanCell.element.editElement.setValue("-");
		        	ct.setCellValue(cvlanCell, "tagID", "-");
					ct.setCellIsEdit(cvlanCell, 0);
				}
			}
			else
			{
				svlanCell.element.showElement.setValue("");
				svlanCell.element.editElement.setValue("");
				ct.setCellValue(svlanCell, "svlan", "");
				ct.setCellIsEdit(svlanCell, 1);
				if(!(macsflntypeValue == macsflntype_SVL &&  tagtype == tagType_SAwared))
				{
					cvlanCell.element.showElement.setValue("");
		        	cvlanCell.element.editElement.setValue("");
		        	ct.setCellValue(cvlanCell, "tagID", "");
					ct.setCellIsEdit(cvlanCell, 1);
				}
			}
        }
    }
}

/*************************
 * do add port to right
 **************************/
function processAddPorts(selectedrow)
{
    var selectedrows = selectedrow;
    var dinterface = new DataInterface();
    var ptag, obj;
    for (var i = 0; i < selectedrows.length; i++) 
    {
        obj = new Object();
        var vuniid = st.getCellStoreValue(selectedrows[i], "vuniID", "vuniID");
        ptag = new ParamTag();
        ptag.value = vuniid;
        obj["vuniID"] = ptag;
        
        var slotid = st.getCellStoreValue(selectedrows[i], "slotid", "slotid");
        ptag = new ParamTag();
        ptag.value = slotid;
        obj["slotid"] = ptag;
        
        var boardname = st.getCellStoreValue(selectedrows[i], "boardName", "boardName");
        ptag = new ParamTag();
        ptag.value = boardname;
        obj["boardName"] = ptag;
        
        var portid = st.getCellStoreValue(selectedrows[i], "portid", "portid");
        ptag = new ParamTag();
        ptag.value = portid;
        obj["portid"] = ptag;
        
        var portname = st.getCellStoreValue(selectedrows[i], "portname", "portname");
        ptag = new ParamTag();
        ptag.value = portname;
        obj["portname"] = ptag;
       
        var porttypevalue = st.getCellStoreValue(selectedrows[i], "porttype", "porttype");
      
        if((tagtype == tagType_CAwared) || (tagtype == tagType_TagTrans))
        {
        	porttypevalue = portType_Uni;
        }else{
        	if(macsflntypeValue == IVL)
        	{
        		if((!isSupportPbunni() && !isSupportVPLS) || ((isSupportPbunni() || isSupportVPLS) && ispbuni))
            	{
            		if(paporttype == "uni")
                	{
            			porttypevalue = portType_Pbsuni;
                	}else{
                		porttypevalue = portType_Pbnni;
                	}           		
            	}else{
            		if(paporttype == "uni")
                	{
            			porttypevalue = portType_Uni;
                			            		
                	}else{
                		porttypevalue = portType_Nni;
                	}   
            	}	     	
        	}else{
        		porttypevalue = portType_Pbuni;
        	}	
        }

        ptag = new ParamTag();
        ptag.value = porttypevalue;
        obj["porttype"] = ptag;
        
        var cvlan = st.getCellStoreValue(selectedrows[i], "tagID", "tagID");
        if (tagtype != tagType_CAwared) 
        {
            if (porttypevalue != 4 && cvlan) 
            {
                cvlan = "-";
            }
        }
        ptag = new ParamTag();
        ptag.value = cvlan;
        obj["tagID"] = ptag;
        
        var svlan = st.getCellStoreValue(selectedrows[i], "svlan", "svlan");
        ptag = new ParamTag();
        ptag.value = svlan;
        obj["svlan"] = ptag;
        
        var vlanfilter = st.getCellStoreValue(selectedrows[i], "vlanfilter", "vlanfilter");
        ptag = new ParamTag();
        ptag.value = vlanfilter;
        obj["vlanfilter"] = ptag;

            st.deleteRow(selectedrows[i]);
        dinterface.rows.append(obj);
    }

    createTableBody(ct, window.tableconf[0], dinterface, RESOURCE);
    for( var i = 0; i < ct.getDataRowLength(); i++ )
    {
    	var tSlotID = ct.getCellStoreValue(i, "slotid", "slotid");
    	if( tSlotID == "65535" )
    	{
    		var portNameShow = ct.getCellShow(i, "portname");
    		portNameShow.setValue("NMS-1");
    	}
    }
    ct.adjustDataRows();

    addCellEvent();
    st.adjustDataRows();
    
    {
        $("cfgPortAddBtn").disabled = true;
    }
}

/*************************
 * do del port from right
 **************************/
function processDelPorts(selectedrow)
{
    var selectedrows = selectedrow;
    var dinterface = new DataInterface();
    var ptag, obj;
    var sameRows = 0;
    var selectedId = document.getElementById("boardList").selectedIndex;
    var poolSlotId = document.getElementById("boardList").options[selectedId].value;
    var rBoardName = document.getElementById("boardList").options[selectedId].text;
    for (var i = selectedrows.length - 1; i >= 0; i--) 
    {
        obj = new Object();
        ptag = new ParamTag();
        var vuniid = ct.getCellStoreValue(selectedrows[i], "vuniID", "vuniID");
        ptag.value = vuniid;
        obj["vuniID"] = ptag;
        
        ptag = new ParamTag();
        var slotid = ct.getCellStoreValue(selectedrows[i], "slotid", "slotid");
        ptag.value = slotid;
        obj["slotid"] = ptag;
        
        ptag = new ParamTag();
        var boardname = ct.getCellStoreValue(selectedrows[i], "boardName", "boardName");
        ptag.value = boardname;
        obj["boardName"] = ptag;
        
        ptag = new ParamTag();
        var portid = ct.getCellStoreValue(selectedrows[i], "portid", "portid");
        ptag.value = portid;
        obj["portid"] = ptag;
        
        ptag = new ParamTag();
        var portname = ct.getCellStoreValue(selectedrows[i], "portname", "portname");
        ptag.value = portname;
        obj["portname"] = ptag;
        
        ptag = new ParamTag();
        var porttypevalue = ct.getCellStoreValue(selectedrows[i], "porttype", "porttype");
        ptag.value = porttypevalue;
        obj["porttype"] = ptag;
        
        ptag = new ParamTag();
        var cvlan = ct.getCellStoreValue(selectedrows[i], "tagID", "tagID");
        ptag.value = cvlan;
        obj["tagID"] = ptag;
        
        ptag = new ParamTag();
        var svlan = ct.getCellStoreValue(selectedrows[i], "svlan", "svlan");
        ptag.value = svlan;
        obj["svlan"] = ptag;
        
        ptag = new ParamTag();
        var vlanfilter = ct.getCellStoreValue(selectedrows[i], "vlanfilter", "vlanfilter");
        ptag.value = vlanfilter;
        obj["vlanfilter"] = ptag;
        ct.deleteRow(selectedrows[i]);
        
        if ((slotid + "-" + boardname) == rBoardName && !isContained(st, slotid, boardname, portname)) 
        {
            dinterface.rows[sameRows] = obj;
            sameRows++;
        }
    }
    
        createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
        for( var i = 0; i < st.getDataRowLength(); i++ )
        {
        	var tSlotID = st.getCellStoreValue(i, "slotid", "slotid");
        	if( tSlotID == "65535" )
            {
        		var portNameShow = st.getCellShow(i, "portname");
        		portNameShow.setValue("NMS-1");
            }        	
        }
        st.sortRows(st.getHeadCell("portid").element, 1);
    
    ct.adjustDataRows();
    
    $("cfgPortDelBtn").disabled = true;
}

/**
 *                S-S           
 * @return
 */
function isChangeMode()
{
	if (tagtype == tagType_SAwared) 
    {
    	if(isSupportPbunni() || isSupportVPLS)
    	{
    		if(macsflntypeValue == SVL)
        	{
    			for (var i = 0; i < ct.getDataRowLength(); i++) 
    		    {
    		        var portObject = new Object()
    		        portObject.slotid = ct.getCellStoreValue(i, "slotid", "slotid");
    		        portObject.portid = ct.getCellStoreValue(i, "portid", "portid");
    		        portObject.svlan = ct.getCellStoreValue(i, "svlan", "svlan");
    		        portObject.vlanfilter = ct.getCellStoreValue(i, "vlanfilter", "vlanfilter");
    		        row = findObjectFromPortArray(iniSelectedPortData, portObject);
    		        if(row != null)
    		        {
    		        	if(((row.svlan.value == "-" && row.vlanfilter.value != "-")
    		        			&& (portObject.svlan != "-" && portObject.vlanfilter == "-"))
    		        		||((row.svlan.value != "-" && row.vlanfilter.value == "-")
    		        				&& (portObject.svlan == "-" && portObject.vlanfilter != "-")))
    		        	{
    		        		return true;
    		        	}
    		        }
    		    }
        	}
    	}
    }
	return false;
}

/***************************
 * do create uni/nni port
 ****************************/
function doCreate()
{
	if(isChangeMode())
	{
		alert(RESOURCE["switcherrortitle"]);
		return;
	}

	var refreshPortAttr = true;
    serviceIndex = parobj.serviceIndex;
    serviceTag = parobj.serviceTag;
	if(parobj.splitTab)
	{
		var splitLen = parobj.splitTab.getDataRowLength();
		if(changePort && (splitLen != 0))
		{
			var confirmed = confirm(RESOURCE["changSplitPorts"]);
	        if (!confirmed) 
	        {
	            xcloseDialog();
	            refreshPortAttr = false; //                   
	        }
			else
			{
				parobj.refreshSplit();
			}
		}
	}

	if(!isCompleteInfo())
	{
		 alert(RESOURCE["inputsvlan"]);
		return;
	}
	
    if (creatflag) 
    {
    	if(confirm(RESOURCE["applypoort"]))
    	{
    		bIsValidateVlanID = true;
            var root = new inputxml("datainterface");
            var bussinessNode = new tagElement("bussiness-params");
            createServiceTag(bussinessNode);
            createDelVuniXML(bussinessNode);
	    
            if (isSupportPbunni() || isSupportVPLS) 
            {    
            	if(ispbuni)
            	{
            		createAddPBVUniXML(bussinessNode);
            		createAddVuniXML(bussinessNode);
                    createSawarePortRole(bussinessNode,"1");
            	}else{
            		createAddVuniXML(bussinessNode);
                    if((serviceTag == tagType_SAwared) && (IVL == macsflntypeValue))
            		{
            		    createSawarePortRole(bussinessNode,"2");
            		}
            	}        
            }else{
            	if((serviceTag == tagType_SAwared) && (IVL == macsflntypeValue))
            	{
            		createAddPBVUniXML(bussinessNode);
            		createAddVuniXML(bussinessNode);
            	}else{
            		createAddVuniXML(bussinessNode);
            	}	
            } 

            createModifyVuniXML(bussinessNode);
            createSetVlanFilterXML(bussinessNode);
            if (!bIsValidateVlanID) 
            {
                return;
            }
            root.getRoot().appendChild(bussinessNode);
            var xml = root.toString();
            if (null == xml) 
            {
                return;
            }
			
            var URL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETHSRV_MOD_ELAN_V_UNI + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + parobj.parobj.obj["nmUser"];
            loadXMLdoc(URL, "POST", false, doCreateBack, null, "inputdata=" + xml);
    	}        
    }
    else if (refreshPortAttr)
    {
		/**
		 * modify by q00119080
		 *                        
		 */ 	
        var paporttab = parobj.portTab;
        var datalength = ct.getDataRowLength();
        var dinterface = new DataInterface();
        var ptag, obj;
        var sameRows = 0;

        for (var i = 0; i < datalength; i++) 
        {
            ptag = new ParamTag();
            obj = new Object();
            var slotid = ct.getCellStoreValue(i, "slotid", "slotid");
            ptag.value = slotid;
            obj["slotid"] = ptag;
            
            ptag = new ParamTag();
            var boardname = ct.getCellStoreValue(i, "boardName", "boardName");
            ptag.value = boardname;
            obj["boardName"] = ptag;
            
            ptag = new ParamTag();
            ptag.value = "255";
            obj["subslotid"] = ptag;
            
            var porttypevalue = ct.getCellStoreValue(i, "porttype", "porttype");
            var logportid = (porttypevalue == portType_Pbnni ? vnniID++ : vuniID++);
            ptag = new ParamTag();
            ptag.value = logportid;
            obj["vuniID"] = ptag;
            
            ptag = new ParamTag();
            var portid = ct.getCellStoreValue(i, "portid", "portid");
            ptag.value = portid;
            obj["portid"] = ptag;
            
            ptag = new ParamTag();
            var portname = ct.getCellStoreValue(i, "portname", "portname");
            ptag.value = portname;
            obj["portname"] = ptag;
            
            ptag = new ParamTag();
            ptag.value = porttypevalue;
            if (tagtype != tagType_SAwared && paporttype == "uni") 
            {
                ptag.value == "1";
            }
            obj["porttype"] = ptag;

            ptag = new ParamTag();
            var cvlan = ct.getCellStoreValue(i, "tagID", "tagID");
            if((cvlan == null) || (cvlan == undefined) || (cvlan == ""))
            {
            	cvlan = "-";
            }
            ptag.value = cvlan;
            obj["tagID"] = ptag;
            
            ptag = new ParamTag();
            var svlan = ct.getCellStoreValue(i, "svlan", "svlan");
            if((svlan == null) || (svlan == undefined))
            {
            	svlan = "-";
            }
            ptag.value = svlan;
            obj["svlan"] = ptag;
            
            ptag = new ParamTag();
            var vlanfilter = ct.getCellStoreValue(i, "vlanfilter", "vlanfilter");
            if((vlanfilter == null) || (vlanfilter == undefined))
            {
            	vlanfilter = "-";
            }
            ptag.value = vlanfilter;
            obj["vlanfilter"] = ptag;
            
            var portAttributeArray = getPortAttribute(slotid, portid);
            if (tagtype == tagType_CAwared) 
            {
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[6] != null && portAttributeArray[6] != "undefined") 
                {
                    ptag.value = portAttributeArray[6];
                }
                else 
                {
                    ptag.value = "-";
                }
                obj["portEnable"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[0] != null && portAttributeArray[0] != "undefined") 
                {
                    ptag.value = portAttributeArray[0];
                }
                else 
                {
                    ptag.value = "0";
                }
                obj["workMode"] = ptag;
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[1] != null && portAttributeArray[1] != "undefined") 
                {
                    ptag.value = portAttributeArray[1];
                }
                else 
                {
                    ptag.value = "1";
                }
                obj["encapType"] = ptag;
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[2] != null && portAttributeArray[2] != "undefined") 
                {
                    ptag.value = portAttributeArray[2];
                }
                else 
                {
                    ptag.value = "1";
                }
                obj["tag"] = ptag;
                ptag = new ParamTag();
				if(portAttributeArray!=null && portAttributeArray[3] != null && portAttributeArray[3] != "undefined")
				{
					ptag.value = portAttributeArray[3];
				}
				else
				{
					ptag.value = "1";
				}
                obj["vlanID"] = ptag;
                ptag = new ParamTag();
				if(portAttributeArray!=null && portAttributeArray[4] != null && portAttributeArray[4] != "undefined")
				{
					ptag.value = portAttributeArray[4];
				}
				else
				{
					ptag.value = "0";
				}
                obj["vlanPri"] = ptag;
                
                ptag = new ParamTag();
				if(portAttributeArray!=null && portAttributeArray[4] != null && portAttributeArray[4] != "undefined")
				{
					ptag.value = portAttributeArray[4];
				}
				else
				{
					ptag.value = "0";
				}
                obj["vlanPri"] = ptag;
                
                ptag = new ParamTag();
                if(ispbuni)
                {                	
                	ptag.value = "1";
                }else{
                	ptag.value = "0";
                }
                obj["portRole"] = ptag;
            }
            else if (tagtype == tagType_SAwared) 
            {
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[6] != null && portAttributeArray[6] != "undefined") 
                {
                    ptag.value = portAttributeArray[6];
                }
                else 
                {
                    ptag.value = "-";
                }
                obj["portEnable"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[0] != null && portAttributeArray[0] != "undefined") 
                {
                    ptag.value = portAttributeArray[0];
                }
                else 
                {
                    ptag.value = "0";
                }
                obj["workMode"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[1] != null && portAttributeArray[1] != "undefined") 
                {
                    ptag.value = portAttributeArray[1];
                }
                else if (paporttype == "uni") 
                {
                    ptag.value = "1";
                }
                else 
                {
                    ptag.value = "2";
                }
                obj["encapType"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[2] != null && portAttributeArray[2] != "undefined") 
                {
                    ptag.value = portAttributeArray[2];
                }
                else 
                {
                    ptag.value = "1";
                }
                obj["tag"] = ptag;
                ptag = new ParamTag();
				if(portAttributeArray!=null && portAttributeArray[3] != null && portAttributeArray[3] != "undefined")
				{
					ptag.value = portAttributeArray[3];
				}
				else
				{
					ptag.value = "1";
				}
                obj["vlanID"] = ptag;
                ptag = new ParamTag();
				if(portAttributeArray!=null && portAttributeArray[4] != null && portAttributeArray[4] != "undefined")
				{
					ptag.value = portAttributeArray[4];
				}
				else
				{
					ptag.value = "0";
				}
                obj["vlanPri"] = ptag;

                ptag = new ParamTag();
                if(ispbuni)
                {                	
                	ptag.value = "1";
                }else{
                	ptag.value = "0";
                }
                obj["portRole"] = ptag;
            }
            else 
            {
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[6] != null && portAttributeArray[6] != "undefined") 
                {
                    ptag.value = portAttributeArray[6];
                }
                else 
                {
                    ptag.value = "-";
                }
                obj["portEnable"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[0] != null && portAttributeArray[0] != "undefined") 
                {
                    ptag.value = portAttributeArray[0];
                }
                else 
                {
                    ptag.value = "0";
                }
                obj["workMode"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[1] != null && portAttributeArray[1] != "undefined") 
                {
                    ptag.value = portAttributeArray[1];
                }
                else 
                {
                    ptag.value = "0";
                }
                obj["encapType"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[2] != null && portAttributeArray[2] != "undefined") 
                {
                    ptag.value = portAttributeArray[2];
                }
                else 
                {
                    ptag.value = "1";
                }
                obj["tag"] = ptag;
                ptag = new ParamTag();
				if(portAttributeArray!=null && portAttributeArray[3] != null && portAttributeArray[3] != "undefined")
				{
					ptag.value = portAttributeArray[3];
				}
				else
				{
					ptag.value = "1";
				}
                obj["vlanID"] = ptag;
                ptag = new ParamTag();
				if(portAttributeArray!=null && portAttributeArray[4] != null && portAttributeArray[4] != "undefined")
				{
					ptag.value = portAttributeArray[4];
				}
				else
				{
					ptag.value = "0";
				}
                obj["vlanPri"] = ptag;

                ptag = new ParamTag();
                if(ispbuni)
                {                	
                	ptag.value = "1";
                }else{
                	ptag.value = "0";
                }
                obj["portRole"] = ptag;
            }
            dinterface.rows.append(obj);
        }
      
        parobj.createTableFunc(dinterface);
        xcloseDialog();
        parobj.initportparas();  
    }
}

/**
 *     VLAN     
 * @param {Object} table
 * @param {Object} portData
 */
function getSetVlanFilterInfo(table, portData)
{
    var addPortArr = new Array();
    for (var i = 0; i < table.getDataRowLength(); i++) 
    {
        var portObject = new Object()
        portObject.slotid = table.getCellStoreValue(i, "slotid", "slotid");
        portObject.portid = table.getCellStoreValue(i, "portid", "portid");
        portObject.tagID = table.getCellStoreValue(i, "tagID", "tagID");
        portObject.svlan = table.getCellStoreValue(i, "svlan", "svlan");
        portObject.porttype = table.getCellStoreValue(i, "porttype", "porttype");
        portObject.boardName = table.getCellStoreValue(i, "boardName", "boardName");
        portObject.vuniID = table.getCellStoreValue(i, "vuniID", "vuniID");
        portObject.index = i;
        var vlanfilter = table.getCellStoreValue(i, "vlanfilter", "vlanfilter");
        portObject.vlanfilter = vlanfilter;

        var oldvlanfilter = null;
        var didatalength = portData.getDataRowLength();
        for (var j = 0; j < didatalength; j++) 
        {
        	var row = portData.getDataRow(j);
        	
        	if((row["slotid"].value == portObject.slotid) && (row["portid"].value == portObject.portid))
            {
        		oldvlanfilter = row["vlanfilter"].value;
            }
        }

        if((null != vlanfilter) && (undefined != vlanfilter)  && ("-" != vlanfilter))
        {
        	if(oldvlanfilter != vlanfilter)
        	{
        		addPortArr.push(portObject);
        	}
        } 
		
    }
	return addPortArr;
}
/**
 *  S+I    UNI    SVLAN            .
 *                   
 * @return
 */
function isCompleteInfo()
{
	if((serviceTag == tagType_SAwared) && (macsflntypeValue == IVL) && (paporttype == "uni"))
	{
		var svlan;
		for(var i = 0, size = ct.getDataRowLength(); i < size; i++)
		{
			if((!isSupportPbunni() && !isSupportVPLS) || ((isSupportPbunni() || isSupportVPLS) && ispbuni))
			{
				svlan = ct.getCellStoreValue(i, "svlan", "svlan");
				if((svlan == null) || (svlan == undefined)|| (svlan == ""))
				{
					return false;
				}
			}			
		}
	}
	
	return true;
}


function createAddVuniXML(bussinessNode)
{
    var rowParams = new tagElement("row-params");
    var cmdcode;
    var rowindx = 0;
	/**
	 * 
	 *        
	 */
    var addPortArray = getAddPortInfo(ct, iniSelectedPortData);
    for (var i = 0, len = addPortArray.length; i < len; i++) 
    {
        var porttypevalue = addPortArray[i].porttype;
        if (serviceTag == tagType_SAwared) 
        {
        	if(macsflntypeValue != macsflntype_SVL)
        	{
            	if(isSupportPbunni() || isSupportVPLS)
            	{
            		if(ispbuni)
            		{
            			if ((porttypevalue != portType_Pbnni) && (porttypevalue != portType_Pbuni)) 
                        {
                            continue;
                        }
            		}else{
            			if (porttypevalue != portType_Uni) 
                        {
                            continue;
                        }
            		}
            	}else{
            		if((porttypevalue != portType_Pbnni) && (porttypevalue != portType_Pbuni)) 
                    {
                        continue;
                    }
            	}
        	}
        }
        else 
        {
            if (porttypevalue != portType_Uni) 
            {
                continue;
            }
        }
        
        rowParams = new tagElement("row-params");
        var param = null;
        if (rowindx == 0) 
        {
            cmdcode = "NSCMD_SERVICE_ADD_ETHVUNI_EX";
            param = new tagElement("param");
            param.setAttribute("name", "block");
            param.setAttribute("value", cmdcode);
            rowParams.appendChild(param);
        }
        rowindx++;
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "autoServiceIndex");
        param.setAttribute("value", "0");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceIndex");
        param.setAttribute("value", serviceIndex);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "autoVuniID");
        param.setAttribute("value", "1");
        rowParams.appendChild(param);
        
        existVuniID = porttypevalue == portType_Pbnni ? vnniID++ : vuniID++;
        param = new tagElement("param");
        param.setAttribute("name", "vuniID");
        param.setAttribute("value", existVuniID);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "role");
        param.setAttribute("value", "1");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", addPortArray[i].slotid);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        param.setAttribute("value", "255");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portid");
        param.setAttribute("value", addPortArray[i].portid);
        rowParams.appendChild(param);
        
        var tagNum, tagID;
        if (serviceTag == tagType_SAwared) 
        {
        	if((isSupportPbunni() || isSupportVPLS) && !ispbuni)
        	{
        		if(addPortArray[i].tagID != null && addPortArray[i].tagID != undefined)
        		{
        			tagID = addPortArray[i].tagID;
        		}else{
        			tagID = addPortArray[i].svlan;
        		}        		
        	}else{
        		tagID = addPortArray[i].svlan;
        	}   
        }
        else 
        {
            tagID = addPortArray[i].tagID;
        }
        
        param = new tagElement("param");
        param.setAttribute("name", "svlan");
        param.setAttribute("value", addPortArray[i].svlan);
        rowParams.appendChild(param);
		
        if (tagID == undefined || tagID == "undefined") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else if (tagID == "-") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else 
        {
            tagNum = tagID.split(",").length;
        }
        
        var isValide = validataTagList(tagID);
        if (isValide == -1) 
        {
            bIsValidateVlanID = false;
            return;
        }
        
        var tagIDDataArr = getTagListData(tagID);
        param = new tagElement("param");
        param.setAttribute("name", "tagNum");
        param.setAttribute("value", tagIDDataArr[0]);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "tagID");
        param.setAttribute("value", tagIDDataArr[1]);
        rowParams.appendChild(param);

        var portAttrs = getPortAttribute(addPortArray[i].slotid, addPortArray[i].portid);
        if(portAttrs != null)
        {
	        var portEnable, workMode;
	        
	        portEnable = portAttrs[6];
	        if(portEnable == null || portEnable == undefined)
	        {
	            portEnable = "1";
	        }
	        
	        workMode = portAttrs[0];
	        if(workMode == null || workMode == undefined)
	        {
	            workMode = "0";
	        }
	
	        
	
	        param = new tagElement("param");
	        param.setAttribute("name", "portEnable");
	        param.setAttribute("value", portEnable);
	        rowParams.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "workMode");
	        param.setAttribute("value", workMode);
	        rowParams.appendChild(param);
        }
        
        var encapType, tag;
        tag = "1";
        if (tagtype == tagType_CAwared) 
        {
            encapType = "1";
        }
        else if (tagtype == tagType_SAwared) 
        {
            encapType = "2";
        }
        else 
        {
            encapType = "0";
        }
        param = new tagElement("param");
        param.setAttribute("name", "encapType");
        param.setAttribute("value", encapType);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "tag");
        param.setAttribute("value", tag);
        rowParams.appendChild(param);
        bussinessNode.appendChild(rowParams);
    }
}

function createAddPBVUniXML(bussinessNode)
{
    var rowParams = new tagElement("row-params");
    var cmdcode;
    var rowindx = 0;
	/**
	 * 
	 *        
	 */
    var addPortArray = getAddPortInfo(ct, iniSelectedPortData);
    for (var i = 0, len = addPortArray.length; i < len; i++) 
    {
    	var boardName = addPortArray[i].boardName;
        var porttypevalue = addPortArray[i].porttype;
        if ( porttypevalue != portType_Pbsuni) 
        {
            continue;
        }
        rowParams = new tagElement("row-params");
        var param = null;
        if (rowindx == 0) 
        {
            cmdcode = "NSCMD_CFG_SERVICE_ADD_ETHPBVUNI_EX";
            param = new tagElement("param");
            param.setAttribute("name", "block");
            param.setAttribute("value", cmdcode);
            rowParams.appendChild(param);
        }
        rowindx++;
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "autoServiceIndex");
        param.setAttribute("value", "0");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceIndex");
        param.setAttribute("value", serviceIndex);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "autoVuniID");
        param.setAttribute("value", "1");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "vuniID");
        param.setAttribute("value", porttypevalue == portType_Pbnni ? vnniID++ : vuniID++);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "role");
        param.setAttribute("value", "1");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", addPortArray[i].slotid);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        param.setAttribute("value", "255");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portid");
        param.setAttribute("value", addPortArray[i].portid);
        rowParams.appendChild(param);
        
        var svlan = addPortArray[i].svlan;
        param = new tagElement("param");
        param.setAttribute("name", "svlan");
        param.setAttribute("value", svlan == undefined ? 0 : svlan);
        rowParams.appendChild(param);
        
        var tagNum = 0
        var tagID = addPortArray[i].tagID;
        if (tagID != undefined) 
        {
            tagNum = addPortArray[i].tagID.split(",").length;
        }
        
        if (tagID == undefined || tagID == "undefined") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else if (tagID == "-") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else 
        {
            tagNum = tagID.split(",").length;
        }
        
        var isValide = validataTagList(tagID);
        if (isValide == -1) 
        {
            bIsValidateVlanID = false;
            return;
        }
        var tagIDDataArr = getTagListData(tagID);
        param = new tagElement("param");
        param.setAttribute("name", "tagNum");
        param.setAttribute("value", tagIDDataArr[0]);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "tagID");
        param.setAttribute("value", tagIDDataArr[1]);
        rowParams.appendChild(param);
        
        var portAttrs = getPortAttribute(addPortArray[i].slotid, addPortArray[i].portid);
        if(portAttrs != null)
        {
            var portEnable, workMode;
            
            portEnable = portAttrs[6];
	    if(portEnable == null || portEnable == undefined)
	    {
	        portEnable = "1";
	    }
	    
	    workMode = portAttrs[0];
	    if(workMode == null || workMode == undefined)
	    {
	        workMode = "0";
	    }
	
        if (!isSupportWorkModeBoard(boardName)) 
        {
        	portEnable = "-";
        	workMode = "-";
        }
        
	
	    param = new tagElement("param");
            param.setAttribute("name", "portEnable");
            param.setAttribute("value", portEnable);
            rowParams.appendChild(param);
	    
	    param = new tagElement("param");
            param.setAttribute("name", "workMode");
            param.setAttribute("value", workMode);
            rowParams.appendChild(param);
        }
        
        var encapType, tag;
        tag = "1";
        
        if (tagtype == tagType_CAwared) 
        {
            encapType = "1";
        }
        else 
        {
            encapType = "0";
        }
        
        if (tagtype != tagType_SAwared) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "encapType");
            param.setAttribute("value", encapType);
            rowParams.appendChild(param);
        }
        
        param = new tagElement("param");
        param.setAttribute("name", "tag");
        param.setAttribute("value", tag);
        rowParams.appendChild(param);
        
        bussinessNode.appendChild(rowParams);
    }
}

/**
 *            xml
 * @param bussinessNode
 * @return
 */
function createSawarePortRole(bussinessNode, role)
{
    var rowParams = new tagElement("row-params");
    var cmdcode;
    var rowindx = 0;
    /**
	 * 
	 *        
	 */
    var addPortArray = getAddPortInfo(ct, iniSelectedPortData);
    for (var i = 0, len = addPortArray.length; i < len; i++) 
    {
        var porttypevalue = addPortArray[i].porttype;
        if ((porttypevalue != portType_Pbsuni) && (porttypevalue != portType_Uni)) 
        {
            continue;
        }

        rowParams = new tagElement("row-params");
        var param = null;
        if (rowindx == 0) 
        {
            cmdcode = "NSCMD_SERVICE_SET_SAWAREPORT_ROLE";
            param = new tagElement("param");
            param.setAttribute("name", "block");
            param.setAttribute("value", cmdcode);
            rowParams.appendChild(param);
        }
        rowindx++;
  
        param = new tagElement("param");
        param.setAttribute("name", "autoServiceIndex");
        param.setAttribute("value", "0");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceIndex");
        param.setAttribute("value", serviceIndex);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "sawareporttype");
        param.setAttribute("value", role);
        rowParams.appendChild(param);
       
        bussinessNode.appendChild(rowParams);
    }
}

/**
 *     VLAN      XML
 * @param bussinessNode
 * @return
 */
function createSetVlanFilterXML(bussinessNode)
{
    var rowParams = new tagElement("row-params");
    var cmdcode;
    var rowindx = 0;
	/**
	 * 
	 *        
	 */
    var modifyPortArray = getSetVlanFilterInfo(ct, iniSelectedPortData);
    var index;
    for (var i = 0, len = modifyPortArray.length; i < len; i++) 
    {        
        rowParams = new tagElement("row-params");
        var param = null;

        if (rowindx == 0) 
        {
        	cmdcode = "NSCMD_SERVICE_SET_VLANFILTER";
            param = new tagElement("param");
            param.setAttribute("name", "block");
            param.setAttribute("value", cmdcode);
            rowParams.appendChild(param);
        }
        rowindx++;
        index = modifyPortArray[i].index;
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", ct.getCellStoreValue(index, "slotid", "slotid"));
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portid");
        param.setAttribute("value", ct.getCellStoreValue(index, "portid", "portid"));
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceIndex");
        param.setAttribute("value", serviceIndex);
        rowParams.appendChild(param);

        var vuniID = modifyPortArray[i].vuniID;
        var flag= "modify";
        if((null == vuniID) || (undefined == vuniID))
        {
        	vuniID  = existVuniID;
        	flag= "create";
        }
        param = new tagElement("param");
        param.setAttribute("name", "vuniID");
        param.setAttribute("value", vuniID);
        rowParams.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name", "flag");
        param.setAttribute("value", flag);
        rowParams.appendChild(param);
        
        var vlanNum;

        var vlanfilter = ct.getCellStoreValue(index, "vlanfilter", "vlanfilter");
        		
        if ((vlanfilter == undefined) || (vlanfilter == "undefined")) 
        {
        	vlanNum = 0;
            vlanfilter = 0;
        }
        else if (vlanfilter == "-") 
        {
        	vlanNum = 0;
            vlanfilter = 0;
        }
        else 
        {
        	vlanNum = vlanfilter.split(",").length;
        }
        
        var isValide = validataTagList(vlanfilter);
        if (isValide == -1) 
        {
            bIsValidateVlanID = false;
            return;
        }
        
        var vlanIDDataArr = getTagListData(vlanfilter);
        param = new tagElement("param");
        param.setAttribute("name", "vlanNum");
        param.setAttribute("value", vlanIDDataArr[0]);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "vlanID");
        param.setAttribute("value", vlanIDDataArr[1]);
        rowParams.appendChild(param);
        
        bussinessNode.appendChild(rowParams);
    }
}

/**
 *            
 * @param {Object} table
 * @param {Object} portData
 */
function getModifyPortInfo(table, portData)
{
    var modifyPortArr = new Array();
    for (var i = 0; i < table.getDataRowLength(); i++) 
    {
        var portObject = new Object()
        portObject.slotid = table.getCellStoreValue(i, "slotid", "slotid");
        portObject.portid = table.getCellStoreValue(i, "portid", "portid");
        portObject.tagID = table.getCellStoreValue(i, "tagID", "tagID");
        portObject.svlan = table.getCellStoreValue(i, "svlan", "svlan");
        portObject.porttype = table.getCellStoreValue(i, "porttype", "porttype");
        portObject.vuniID = table.getCellStoreValue(i, "vuniID", "vuniID");
        portObject.vlanfilter = table.getCellStoreValue(i, "vlanfilter", "vlanfilter");
        var row = findModifyObjectFromPortArray(portData, portObject);
        if (row != null) 
        {
            modifyPortArr.push(portObject);
        }
		
    }
    
    return modifyPortArr;
}

/**
 *                          
 * @param {Object} portArray
 * @param {Object} portObject
 */
function findModifyObjectFromPortArray(portArray, portObject)
{
    var didatalength = portArray.getDataRowLength();
    for (var i = 0; i < didatalength; i++) 
    {
        var row = portArray.getDataRow(i);
        if(row["slotid"].value == portObject.slotid && row["portid"].value == portObject.portid && 
             (row["tagID"].value != portObject.tagID && row["svlan"].value == portObject.svlan &&  
                (portObject.porttype == portType_Pbsuni || portObject.porttype == portType_Pbuni)
                || row["tagID"].value != portObject.tagID && portObject.porttype != portType_Pbsuni && portObject.porttype != portType_Pbuni && portObject.porttype != portType_Pbnni
                || row["svlan"].value != portObject.svlan && portObject.porttype == portType_Pbnni)) 
        {
            return row;
        }else if((row["slotid"].value == portObject.slotid) && (row["portid"].value == portObject.portid) && (row["vlanfilter"].value != portObject.vlanfilter))
        {
        	return row;
        } else if(row["slotid"].value == portObject.slotid && row["portid"].value == portObject.portid && macsflntypeValue == macsflntype_SVL &&  tagtype == tagType_SAwared
                  && row["tagID"].value == portObject.tagID && row["svlan"].value != portObject.svlan )
        {
        	return row;
        } 
    }
    return null;
}


function createModifyVuniXML(bussinessNode)
{
    var rowParams = new tagElement("row-params");
    var cmdcode;
    var rowindx = 0;
	/**
	 * 
	 *        
	 */
    var modifyPortArray = getModifyPortInfo(ct, iniSelectedPortData);
    for (var i = 0, len = modifyPortArray.length; i < len; i++) 
    {        
        rowParams = new tagElement("row-params");
        var param = null;
        if (rowindx == 0) 
        {
            cmdcode = "NSCMD_SERVICE_SET_ETHVUNITAG";
            param = new tagElement("param");
            param.setAttribute("name", "block");
            param.setAttribute("value", cmdcode);
            rowParams.appendChild(param);
        }
        rowindx++;
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceIndex");
        param.setAttribute("value", serviceIndex);
        rowParams.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name", "vuniID");
        param.setAttribute("value", modifyPortArray[i].vuniID);
        rowParams.appendChild(param);

        
        var tagNum, tagID;
        if (serviceTag == tagType_SAwared && (modifyPortArray[i].porttype == portType_Pbnni || modifyPortArray[i].porttype == portType_Pbuni && macsflntypeValue == macsflntype_SVL)) 
        {
            tagID = modifyPortArray[i].svlan;
        }
        else 
        {
            tagID = modifyPortArray[i].tagID;
        }
        
        param = new tagElement("param");
        param.setAttribute("name", "svlan");
        param.setAttribute("value", modifyPortArray[i].svlan);
        rowParams.appendChild(param);
		
        if (tagID == undefined || tagID == "undefined") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else if (tagID == "-") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else 
        {
            tagNum = tagID.split(",").length;
        }
        
        var isValide = validataTagList(tagID);
        if (isValide == -1) 
        {
            bIsValidateVlanID = false;
            return;
        }
        
        var tagIDDataArr = getTagListData(tagID);
        param = new tagElement("param");
        param.setAttribute("name", "tagNum");
        param.setAttribute("value", tagIDDataArr[0]);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "tagID");
        param.setAttribute("value", tagIDDataArr[1]);
        rowParams.appendChild(param);
        
       /** param = new tagElement("param");
        param.setAttribute("name", "tag");
        param.setAttribute("value", tag);
        rowParams.appendChild(param);**/
        
        bussinessNode.appendChild(rowParams);
    }
}

/**
 *                      
 * @param {Object} portObject
 * @param {Object} table
 */
function findObjectFromTable(portObject, table)
{
    var slotid = portObject["slotid"].value;
    var portid = portObject["portid"].value;
    var tagID = portObject["tagID"].value;
    var svlan = portObject["svlan"].value;
    var vuniID = portObject["vuniID"].value;
    
    for (var i = 0; i < table.getDataRowLength(); i++) 
    {
        var curPortType = table.getCellStoreValue(i, "porttype", "porttype");
        if (
        (table.getCellStoreValue(i, "slotid", "slotid") == slotid &&
        table.getCellStoreValue(i, "portid", "portid") == portid && tagType_SAwared == serviceTag &&
         (
         table.getCellStoreValue(i, "svlan", "svlan") == svlan && (curPortType == portType_Pbsuni
         || curPortType == portType_Pbuni) || curPortType == portType_Pbnni
         )
        )
        || (table.getCellStoreValue(i, "slotid", "slotid") == slotid &&
        table.getCellStoreValue(i, "portid", "portid") == portid && tagType_SAwared != serviceTag)) 
        {
            return i;
        }
        else if(table.getCellStoreValue(i, "slotid", "slotid") == slotid && table.getCellStoreValue(i, "portid", "portid") == portid  
        			&& macsflntypeValue == macsflntype_SVL &&  tagtype == tagType_SAwared 
        			&& table.getCellStoreValue(i, "tagID", "tagID") == portObject.tagID.value && table.getCellStoreValue(i, "svlan", "svlan") != portObject.svlan.value)
        {
            return i;
        }
    }
    return null;
}

/**
 *            
 * @param {Object} table
 * @param {Object} portData
 */
function getAddPortInfo(table, portData)
{
    var addPortArr = new Array();
    for (var i = 0; i < table.getDataRowLength(); i++) 
    {
        var portObject = new Object()
        portObject.slotid = table.getCellStoreValue(i, "slotid", "slotid");
        portObject.portid = table.getCellStoreValue(i, "portid", "portid");
        portObject.tagID = table.getCellStoreValue(i, "tagID", "tagID");
        portObject.svlan = table.getCellStoreValue(i, "svlan", "svlan");
        portObject.porttype = table.getCellStoreValue(i, "porttype", "porttype");
        portObject.boardName = table.getCellStoreValue(i, "boardName", "boardName");
        
        var row;
        if(serviceTag != tagType_SAwared  || (macsflntypeValue == macsflntype_SVL &&  tagtype == tagType_SAwared))
        {
            row = findObjectFromPortArray(portData, portObject);
        } else {
            row = findPbObjectFromPortArray(portData, portObject);
        }
        
        
        if (row == null) 
        {
            addPortArr.push(portObject);
        }
		
    }
	return addPortArr;
}
