var win = getParentWindow();
var neid = win.neid;
var nmUser = win.nmUser;
var serviceTag = win.nmUser;
var pwProtectType = win.pwProtectType;
var serviceID = win.serviceID;
var NO_PROTECT = "0";
var PW_APS = "1";
var SLAVE_PROTECT_PAIR = "2";
var pwProtectCT = null;
var pairPwProtectCT = null;
var pwOAMCT = null;
var qospwst = null;
var workState = [];
workState[1] = "workState_1";
workState[2] = "workState_2";
var NETYPE_950A = "114";
var qosUni = [];
var qosNni = [];
var atom1;
var vnniID = 1;
var IVL = "2";
var SVL = "1";
function init()
{
	intNeVersion();
    initGeneralTable();
    initAdvancedTable();
    initPWProtectTable();	
	initPairPWProtectTable();
	initPWOAMTable();
    initUI();
    initTabs();

    if(win.createProtect)
    {
    	initWorkPW();
    }
    initPWQosTable();
}

function initPWQosTable()
{
	if(pwProtectType == NO_PROTECT)
	{
		window.tableconf[0].colArray[3].width = "0";
		window.tableconf[0].colArray[4].width = "0";
	}
	initQoSTableData(window.tableconf[0],"../../../../../../images/");
}

function intNeVersion()
{
	if(getNeProperty(self) != null)
	{
		neversion = getNeProperty(self).neversion;
	}
	else if((win.isCreatePw != null) && win.isCreatePw)
	{
		neversion = win.parobj.obj.neversion;
	}else
	{
		neversion = win.win.winobj.neversion;
	}
}

function initWorkPW()
{
	for(var i = 0, size = win.nniData.rows.length; i < size; i++)
	{
		if(win.nniData.rows[i].block.value == "NSCMD_SERVICE_GET_EVNNI_EX")
		{
			$("newtunnel0").disabled = true;;
			$("newtunnel2").disabled = true;
			$("tunnelBtn0").style.display = "none";
			$("tunnelBtn2").style.display = "none";
			$("hadtunnel0").click();
			$("hadtunnel2").click();
			pwct.getAtom("pwid",0).setValue(win.nniData.rows[i].pwID.value);
			pwct.getAtom("pwinlabel",0).setValue(win.nniData.rows[i].pwIngressLabel.value);
			pwct.getAtom("pwoutlabel",0).setValue(win.nniData.rows[i].pwEgressLabel.value);
			$("selectedtunnel0").value = win.nniData.rows[i].tunnelid.value;
			$("selectedtunnel2").value = win.nniData.rows[i].tunnelid_e.value;
			pwct.getAtom("oppsitelsrid",0).setValue(convertIP(win.nniData.rows[i].oppositeLsrID.value));
			pwct.getAtom("pwtype",0).setValue(win.nniData.rows[i].serviceType.value);
			pwct.getAtom("pwtype",1).setValue(win.nniData.rows[i].serviceType.value);
			pwct.getAtom("pwid",0).element.disabled = true;
			pwct.getAtom("pwinlabel",0).element.disabled = true;
			pwct.getAtom("pwoutlabel",0).element.disabled = true;
			pwct.getAtom("pwsignaltype",0).element.disabled = true;
			pwct.getAtom("pwtype",0).element.disabled = true;
			pwct.getAtom("direction",0).element.disabled = true;
			pwct.getAtom("pwencaptype",0).element.disabled = true;
			pwct.getAtom("tunneltype",0).element.disabled = true;
			pwct.getAtom("oppsitelsrid",0).element.disabled = true;
			pwOAMCT.getAtom("testtype",0).setValue(win.nniData.rows[i].checkMode.value);
			var testprotocoltype0 = win.nniData.rows[i].pagcketType.value;
			pwOAMCT.getAtom("testprotocoltype",0).setValue(testprotocoltype0);
			var testperiod0 = pwOAMCT.getAtom("testperiod",0);
			if (1 == testprotocoltype0) 
		   {
		        testperiod0.addOption("1000","255");
		        testperiod0.element.disabled = true;
		   }
		   else if (2 == testprotocoltype0) 
		   {
		       testperiod0.addOption("3.3","1");
		       testperiod0.addOption("10","2");
		       testperiod0.addOption("20","3");
		       testperiod0.addOption("50","4");
		       testperiod0.addOption("100","5");
		       testperiod0.addOption("200","6");
		       testperiod0.addOption("500","7");      
		       testperiod0.element.disabled = false;  
		   }
			testperiod0.setValue(win.nniData.rows[i].checkPeriod.value);
		}
	}

	
	var testperiod1 = pwOAMCT.getAtom("testperiod",1);
	testperiod1.addOption("1000","255");
    testperiod1.element.disabled = true;
  
	
	pwOAMCT.getAtom("oamstatus",0).element.disabled = true;
	pwOAMCT.getAtom("oamstatus",1).element.disabled = true;
}

function initGeneralTable()
{
    ct = new CTable2();
    ct.addHead(RESOURCE["attribute"], RESOURCE["WORK_PW"], RESOURCE["PROTECT_PW"]);
    $("general").appendChild(ct.getTable());
    
    atom = new Atom("text");
    atom.element.name = "0";
    atom.element.style.width = "100%";
    checkText(atom.element, "1", "4294967295");
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    atom1 = new Atom("text");
    atom1.element.name = "1";
    atom1.element.style.width = "100%";
    checkText(atom.element, "1", "4294967295");
    atom1.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("pwid", RESOURCE["pwid"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.name = "0";
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["static"], "1");
    atom.element.onchange = changeSignalType;
    atom1 = new Atom("select");
    atom1.element.name = "1";
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["static"], "1");
    atom1.element.onchange = changeSignalType;
    ct.addAttrRow("pwsignaltype", RESOURCE["pwsignaltype"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.name = "0";
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["ethernet"], "5");
    atom.addOption(RESOURCE["ethernettag"], "4");
    atom.element.onchange = changePWType;
    atom1 = new Atom("select");
    atom.element.name = "1";
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["ethernet"], "5");
    atom1.addOption(RESOURCE["ethernettag"], "4");
    atom1.element.onchange = changePWType;
    ct.addAttrRow("pwtype", RESOURCE["pwtype"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.name = "0";
    atom.element.style.width = "100%";
    atom.element.disabled = true;
    atom.addOption(RESOURCE["bidirectional"], "1");
    atom1 = new Atom("select");
    atom1.element.name = "1";
    atom1.element.disabled = true;
    atom1.element.style.width = "100%";
    atom1.addOption(RESOURCE["bidirectional"], "1");
    ct.addAttrRow("direction", RESOURCE["direction"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.name = "0";
    atom.element.style.width = "100%";
    atom.addOption("MPLS", 1);
    atom.element.onchange = changeEncapType;
    atom1 = new Atom("select");
    atom.element.name = "1";
    atom1.addOption("MPLS", 1);
    atom1.element.style.width = "100%";
    atom1.element.onchange = changeEncapType;
    ct.addAttrRow("pwencaptype", RESOURCE["pwencaptype"], atom, atom1);
    
    atom = new Atom("text");
    atom.element.name = "0";
    atom.element.style.width = "100%";
    checkText(atom.element, "16", "1048575");
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    atom1 = new Atom("text");
    atom.element.name = "1";
    atom1.element.style.width = "100%";
    checkText(atom1.element, "16", "1048575");
    atom1.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("pwinlabel", RESOURCE["pwinlabel"], atom, atom1);
    
    atom = new Atom("text");
    atom.element.name = "0";
    atom.element.style.width = "100%";
    checkText(atom.element, "16", "1048575");
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    atom1 = new Atom("text");
    atom1.element.name = "1";
    atom1.element.style.width = "100%";
    checkText(atom1.element, "16", "1048575");
    atom1.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("pwoutlabel", RESOURCE["pwoutlabel"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.name = "0";
    atom.element.style.width = "100%";
    atom.element.disabled = true;
    atom.addOption(RESOURCE["manually"], "0");
    atom1 = new Atom("select");
    atom1.element.name = "1";
    atom1.element.disabled = true;
    atom1.addOption(RESOURCE["manually"], "0");
    ct.addAttrRow("tunnelmode", RESOURCE["tunnelmode"], atom, atom1);
    
    atom = new Atom("select");
    atom.element.name = "0";
    atom1.element.style.width = "100%";
    atom.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    atom.element.onchange = changeTunnelType;
    atom1 = new Atom("select");
    atom1.element.name = "1";
    atom1.addOption("MPLS", TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL);
    atom1.element.onchange = changeTunnelType;
    ct.addAttrRow("tunneltype", RESOURCE["tunneltype"], atom, atom1);
    
    atom = new Atom("span");
    atom1 = new Atom("span");
    ct.addAttrRow("tunnel", RESOURCE["ingresst"], atom, atom1);
 
    createTunnelAtom(atom, 0);
    createTunnelAtom(atom1, 1);

    atom = new Atom("text");
    atom.element.name = "0";
    atom.setValue("0.0.0.0");
    validateIp(atom.element);
    atom.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    atom1 = new Atom("text");
    atom1.element.name = "1";
    atom1.setValue("0.0.0.0");
    validateIp(atom1.element);
    atom1.element.onchange = function()
    {
        $("applybtn").disabled = false;
    }
    ct.addAttrRow("oppsitelsrid", RESOURCE["oppsitelsrid"], atom, atom1);

    atom = new Atom("span");
    atom1 = new Atom("span");
    ct.addAttrRow("tunnel_egress", RESOURCE["egresst"], atom, atom1);

    createTunnelAtom(atom, 2);
    createTunnelAtom(atom1, 3);
 
    pwct = ct;
    setDisplay("34%", "none"); 
}

function createTunnelAtom(atom1, atomName)
{
    var elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "newtunnel" + atomName;
    elem.onclick = function()
    {
        $("hadtunnel" + atomName).checked = false;
        buttonIndex = atomName;
        this.checked = true;
    }
    atom1.element.parentNode.appendChild(elem);
    elem.checked = true;
    
    elem = document.createElement("span");
    elem.id="newtunnelSpan"+atomName;
    elem.innerHTML = RESOURCE["newbtn"];
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "radio";
    elem.id = "hadtunnel" + atomName;
    elem.onclick = function()
    {
        $("newtunnel" + atomName).checked = false;
        buttonIndex = atomName;
        this.checked = true;
    }
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["useexist"];
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "text";
    elem.id = "selectedtunnel" + atomName;
    elem.disabled = true;
    elem.style.width = "48%";
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "tunnelindex" + atomName;
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "ingressid" + atomName;
    atom1.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "hidden";
    elem.id = "egressid" + atomName;
    atom1.element.parentNode.appendChild(elem); 
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.value = "...";
    elem.name = atomName;
    elem.id = "tunnelBtn"+atomName;
    elem.onclick = doSelectTunnel;
    atom1.element.parentNode.appendChild(elem);  
}

function setDisplay(width, display)
{
    pwct.element.childNodes[0].childNodes[0].childNodes[0].style.width = width;
    pwct.element.childNodes[0].childNodes[0].childNodes[1].style.width = width;
    pwct.element.childNodes[0].childNodes[0].childNodes[2].style.display = display;
    
    var childNodes = pwct.element.childNodes[1].childNodes;
    for (var i = 0, m = childNodes.length; i < m; i++) 
    {
        childNodes[i].childNodes[0].style.width = width;
        childNodes[i].childNodes[1].style.width = width;
        childNodes[i].childNodes[2].style.display = display;
    }
}

function initTabs()
{
    tab = new EmbedTabs();
    tab.addEmbedTab("tab1div", RESOURCE["generalattr"], $("tab1div"));
    tab.addEmbedTab("tab6div","QoS", $("pwqos"));
    tab.addEmbedTab("tab2div", RESOURCE["advancedattr"], $("tab2div"));
    tab.addEmbedTab("tab3div", RESOURCE["protection"], $("tab3div"));
    tab.addEmbedTab("tab4div", RESOURCE["protection"], $("tab4div"));
    tab.addEmbedTab("tab5div", RESOURCE["pwoam"], $("tab5div"));
    
    setSelectedEmbedTab("tab1div");
    $("embedtab").appendChild(tab.getEmbedTabs());

    if(pwProtectType == NO_PROTECT)
    {
    	tabHeadList["tab3div"].style.display = "none";
    	$("tab3div").style.display = "none";
    	tabHeadList["tab4div"].style.display = "none";
    	$("tab4div").style.display = "none";
    	tabHeadList["tab5div"].style.display = "none";
    	$("tab5div").style.display = "none";
    	setDisplay("50%", "none");
    }else if(pwProtectType == PW_APS)
    {
    	tabHeadList["tab3div"].style.display = "";
    	$("tab3div").style.display = "none"; 
    	tabHeadList["tab4div"].style.display = "none";
    	$("tab4div").style.display = "none";
    	tabHeadList["tab5div"].style.display = "";
    	$("tab5div").style.display = "none";
    	setDisplay("33%", "");
    }else{
    	tabHeadList["tab3div"].style.display = "none";
    	$("tab3div").style.display = "none";
    	tabHeadList["tab4div"].style.display = "";
    	$("tab4div").style.display = "none";
    	tabHeadList["tab5div"].style.display = "none";
    	$("tab5div").style.display = "none";
    	setDisplay("33%", "");
    }
}

function embedTabSelectHandler(id)
{
    if (id == "tab5div") 
    {
       	pwOAMCT.getAtom("sendpwid",0).setValue(ct.getAtom("pwid",0).getValue());

       	pwOAMCT.getAtom("sendpwid",1).setValue(ct.getAtom("pwid",1).getValue());

       	pwOAMCT.getAtom("receivedlsrid",0).setValue(ct.getAtom("oppsitelsrid",0).getValue());

       	pwOAMCT.getAtom("receivedlsrid",1).setValue(ct.getAtom("oppsitelsrid",1).getValue());
    }
}

function initPWProtectTable()
{
    pwProtectCT = new CTable();
    pwProtectCT.element.id = "pwProtectCT";
    pwProtectCT.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption("PW APS", "1");
    atom.element.disabled=true;
	pwProtectCT.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
     
    atom = new Atom("text");
    checkText(atom.element, "1", "32");
    pwProtectCT.addAttrRow("protectid", RESOURCE["PROTECT_ID"], atom);    
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["enabled"], "1");
    atom.addOption(RESOURCE["disabled"], "0");
    pwProtectCT.addAttrRow("isenable", RESOURCE["ISENABLE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption("1:1", "1");
    atom.element.disabled = true;
    pwProtectCT.addAttrRow("protecttype", RESOURCE["PROTECT_MODE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["SWTICH_MODE2"], "1");
    atom.addOption(RESOURCE["SWTICH_MODE1"], "0");
    atom.element.disabled = true;
    pwProtectCT.addAttrRow("swtichmode", RESOURCE["SWTICH_MODE"], atom);
    
    atom = new Atom("select");
    atom.element.style.width = "100%";
    atom.addOption(RESOURCE["RECOVERY_MODE"], "1");
    atom.addOption(RESOURCE["NO_RECOVERY_MODE"], "0");
    atom.element.onchange = function()
    {
    	 var recoverytime = pwProtectCT.getAtom("recoverytime");
    	 if(pwProtectCT.getAtom("recoverymode").getValue() == "1")
    	 {
    	 	   recoverytime.element.disabled = false;
    	 	   recoverytime.element.value = "1";
    	 }else
    	 {
    	 	   recoverytime.element.disabled = true;
    	 	   recoverytime.element.value = "-";
    	 }    	 
    }
    
    pwProtectCT.addAttrRow("recoverymode", RESOURCE["revertive"], atom);
    
    atom = new Atom("text");
    atom.element.value = 1;
    checkText(atom.element, "1", "12");
    pwProtectCT.addAttrRow("recoverytime", RESOURCE["RECOVERY_TIME"], atom);
    
    atom = new Atom("text");
    atom.element.value = 0;
    checkText(atom.element, "0", "100");
    pwProtectCT.addAttrRow("swtichtime", RESOURCE["DELAY_TIME"], atom);
    
    $("pwprotecttb").appendChild(pwProtectCT.getTable());  
}

function initPairPWProtectTable()
{
	pairPwProtectCT = new CTable();
    pairPwProtectCT.element.id = "pairPwProtectCT";
    pairPwProtectCT.addHead(RESOURCE["property"], RESOURCE["value"]);
    
    var atom = new Atom("select");
    atom.addOption(RESOURCE["PROTECT_PAIRS"], "1");
    atom.element.disabled=true;
	pairPwProtectCT.addAttrRow("protecttype", RESOURCE["PROTECT_TYPE"], atom);
    
    atom = new Atom("span");
    pairPwProtectCT.addAttrRow("protectidspan", RESOURCE["PROTECT_ID"], atom);
    
    var elem = document.createElement("input");
    elem.type = "text";
    elem.id = "protectidforpair";
    checkText(elem, "1", "32");
    elem.style.width = "79%";
    atom.element.parentNode.appendChild(elem);
    
    elem = document.createElement("input");
    elem.type = "button";
    elem.id = "protectidBtn";
    elem.value = "...";
    elem.style.width = "20%";
    elem.onclick = function()
	{
		xshowModalDialog("../eline_u2kv1r3c00/selectaps.html", RESOURCE["resourceselected"], 720, 400, "../../../../../../images/");
	};
    atom.element.parentNode.appendChild(elem); 
 
    $("pairpwprotecttb").appendChild(pairPwProtectCT.getTable());

}

function initPWOAMTable()
{
  pwOAMCT = new CTable2();
  pwOAMCT.element.id = "pwct";
  pwOAMCT.addHead(RESOURCE["property"], RESOURCE["WORK_PW"], RESOURCE["PROTECT_PW"]);
  $("pwoamtb").appendChild(pwOAMCT.getTable());
  
  var atom1 = new Atom("select");
  atom1.element.style.width = "100%";
  atom1.addOption(RESOURCE["enabled"], "1");
  var atom2 = new Atom("select");
  atom2.element.style.width = "100%";
  atom2.addOption(RESOURCE["enabled"], "1");
  pwOAMCT.addAttrRow("oamstatus", RESOURCE["OAM_STATUS"], atom1, atom2);
  
  atom1 = new Atom("select");
  atom1.element.style.width = "100%";
  atom1.addOption(RESOURCE["autoadapt"], "1");
  atom1.addOption(RESOURCE["manual"], "2");
  atom2 = new Atom("select");
  atom2.element.style.width = "100%";
  atom2.addOption(RESOURCE["autoadapt"], "1");
  atom2.addOption(RESOURCE["manual"], "2");
  pwOAMCT.addAttrRow("testtype", RESOURCE["TEST_TYPE"], atom1, atom2);
  
  atom1 = new Atom("select");
  atom1.element.style.width = "100%";
  atom1.addOption("CV", "1");
  atom1.addOption("FFD", "2");
  atom1.element.onchange = changeProtocolType;
  atom1.element.name = "0";
  atom2 = new Atom("select");
  atom2.element.style.width = "100%";
  atom2.addOption("CV", "1");
  atom2.addOption("FFD", "2");
  atom2.element.onchange = changeProtocolType;
  atom2.element.name = "1";
  pwOAMCT.addAttrRow("testprotocoltype", RESOURCE["TEST_PROTOCOL_TYPE"], atom1, atom2);
   
  atom1 = new Atom("select");
  atom1.element.style.width = "100%";
  atom1.addOption("1000", "255");
  atom2 = new Atom("select");
  atom2.element.style.width = "100%";
  atom2.addOption("1000", "255");
  atom1.element.disabled = true;
  atom2.element.disabled = true;
  pwOAMCT.addAttrRow("testperiod", RESOURCE["TEST_PROTOCOL_PERIOD"], atom1, atom2);
    
  atom1 = new Atom("text");
  validateIp(atom1.element);
  atom2 = new Atom("text");
  validateIp(atom2.element);
  pwOAMCT.addAttrRow("receivedlsrid", RESOURCE["RECEIVED_LSRID"], atom1, atom2);
  
  atom1 = new Atom("text");
  checkText(atom1.element, "1", "4294967295");
  atom2 = new Atom("text");
  checkText(atom2.element, "1", "4294967295");
  pwOAMCT.addAttrRow("sendpwid", RESOURCE["SEND_PWID"], atom1, atom2);
}

function CTable2()
{
    this.element = document.createElement("table");
    this.element.appendChild(document.createElement("thead"));
    this.element.appendChild(document.createElement("tbody"));
    this.element.firstChild.appendChild(document.createElement("tr"));
    
    this.attrName = new Object();
    this.attrArray = new Object();
    this.element.className = "attrTable1";
    this.addHead = function(head1, head2, head3)
    {
        var th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head1));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head2));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
        th = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(head3));
        th.appendChild(span);
        this.element.firstChild.firstChild.appendChild(th);
    }
    
    this.addAttrRow = function(attrid, attrname, atom1, atom2, text)
    {
        tr = document.createElement("tr");
        td = document.createElement("td");
        span = document.createElement("span");
        span.appendChild(document.createTextNode(attrname));
        td.appendChild(span);
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom1.element);
        if (text != null) {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        
        td = document.createElement("td");
        td.appendChild(atom2.element);
        if (text != null) {
            span = document.createElement("span");
            span.appendChild(document.createTextNode(text));
            td.appendChild(span);
        }
        tr.appendChild(td);
        this.element.childNodes[1].appendChild(tr);
        var atomArr = new Object();
        atomArr[0] = atom1;
        atomArr[1] = atom2;
        this.attrArray[attrid] = atomArr;
        this.attrName[attrid] = attrname;
    }
    
    this.getAttrName = function(attrid){
        return this.attrName[attrid];
    }
    
    this.getAttrValue = function(attrid, index){
        return this.attrArray[attrid][index].getValue();
    }
    
    this.setAttrValue = function(attrid, index, value){
        if (this.attrArray[attrid][index]) {
            this.attrArray[attrid][index].setValue(value);
        }
    }
    
    this.getAtom = function(attrid, index){
        if (this.attrArray[attrid][index]) {
            return this.attrArray[attrid][index];
        }  
    }
    this.getTable = function(){
        return this.element;
    }
}

function changeProtocolType()
{
	var index = this.name;
	var testprotocoltype = parseInt(this.value);
	   
	 var testperiod = pwOAMCT.getAtom("testperiod", index);
	 testperiod.removeAllOptions();
   if (1 == testprotocoltype) 
   {
        testperiod.addOption("1000","255");
        testperiod.element.disabled = true;
   }
   else if (2 == testprotocoltype) 
   {
       testperiod.addOption("3.3","1");
       testperiod.addOption("10","2");
       testperiod.addOption("20","3");
       testperiod.addOption("50","4");
       testperiod.addOption("100","5");
       testperiod.addOption("200","6");
       testperiod.addOption("500","7");
       testperiod.setValue(4);
       testperiod.element.disabled = false;  
   }
}

function doSelectTunnel()
{
  	var buttonIndex =  this.name;
  	tunnelIndex = (buttonIndex > 1) ? buttonIndex - 2 : buttonIndex;
    var tunnelType = ct.getAtom("tunneltype", tunnelIndex).getValue();
    var nodetype = -1;
    if (buttonIndex == 0 || buttonIndex == 1)//buttonInde:0,1  Ingress
    {
    	nodetype = NODE_TYPE_INGRESS;
    }
    else
    {	
    	nodetype = NODE_TYPE_EGRESS;
    }
    if ($("hadtunnel" + buttonIndex).checked) 
    {
        xshowModalDialog("../eline_u2kv1r3c00/selecttunnel.html?tunnelType=" + tunnelType + "&nodetype=" + nodetype + "&buttonIndex=" + buttonIndex, RESOURCE["resourceselected"], 580, 250, "../../../../../../images/");
    }
    else 
    {
        if (tunnelType == TECMDCODE_PTN_CES_GET_AVAILABLE_TUNNEL) 
        {
            xshowModalDialog("../eline_u2kv1r3c00/createmplsnodetypetunnel.html?tunnelType=" + tunnelType + "&nodetype=" + nodetype + "&buttonIndex=" + buttonIndex, RESOURCE["resourceselected"], 580, 620, "../../../../../../images/");
        }
        else 
        {
            xshowModalDialog("../ethcommon/createipgretunnel.html?tunnelType=" + tunnelType, RESOURCE["resourceselected"], 580, 450, "../../../../../../images/");
        }
    }
}

function doCreate(param)
{
	if (param && $("applybtn").disabled)
	{
		xcloseDialog();
		return;
	}
	
    if (!validate()) 
    {
        return;
    }
    appendParentWinPWQos("w");
    appendParentWinPWQos("p");
    if(win.createProtect && (pwProtectType==PW_APS))
	{
		 createAps();
		 return;
	}
	else if(win.createProtect && (pwProtectType==SLAVE_PROTECT_PAIR))
	{
		 createApsPair();
		 return;
	}else if(win.isCreatePw && (pwProtectType==NO_PROTECT))
	{
		 createPW();
		 return;
	}
    
    var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    var rowParams = document.createElement("row-params");
    win.vnniID != null ? win.vnniID++ : "-";
    rowParams.appendChild(createParamElement("vnniId", win.vnniID));
    rowParams.appendChild(createParamElement("vnniId", win.vnniID));
    rowParams.appendChild(createParamElement("role", 1));
    rowParams.appendChild(createParamElement("pwID", ct.getAtom("pwid", 0).getValue()));
    rowParams.appendChild(createParamElement("pwIndex", 0));
    rowParams.appendChild(createParamElement("workState", 1));
    rowParams.appendChild(createParamElement("enableState", 1));
    var pwSignalType = parseInt(ct.getAtom("pwsignaltype", 0).getValue());
    rowParams.appendChild(createParamElement("pwSignalType", pwSignalType));
    rowParams.appendChild(createParamElement("serviceType", ct.getAtom("pwtype", 0).getValue()));
    rowParams.appendChild(createParamElement("direction", ct.getAtom("direction", 0).getValue()));
    rowParams.appendChild(createParamElement("pwEncapsType", ct.getAtom("pwencaptype", 0).getValue()));
    rowParams.appendChild(createParamElement("pwIngressLabel", ct.getAtom("pwinlabel", 0).getValue()));
    rowParams.appendChild(createParamElement("pwEgressLabel", ct.getAtom("pwoutlabel", 0).getValue()));
    rowParams.appendChild(createParamElement("oppositeLsrID", convertIPStrToLong(ct.getAtom("oppsitelsrid", 0).getValue())));
    rowParams.appendChild(createParamElement("tunneltype", tunnelTypes[ct.getAtom("tunneltype", 0).getValue()]));
    rowParams.appendChild(createParamElement("tunnelindex", $("tunnelindex0").value));
    rowParams.appendChild(createParamElement("tunnelid", $("selectedtunnel0").value));
    
    rowParams.appendChild(createParamElement("ingressid", $("ingressid2").value)); 
    rowParams.appendChild(createParamElement("egressid", $("egressid2").value));
    rowParams.appendChild(createParamElement("tunnelid_e", $("tunnelindex2").value));
    
    rowParams.appendChild(createParamElement("controlWord", act.getAtom("controlword").getValue()));
    rowParams.appendChild(createParamElement("ctrlChanType", act.getAtom("controlchanneltype").getValue()));
    rowParams.appendChild(createParamElement("vccv", act.getAtom("vccvmode").getValue()));
    rowParams.appendChild(createParamElement("requestVLAN", act.getAtom("requestvlan").getValue()));
    rowParams.appendChild(createParamElement("tpID", act.getAtom("tpid").getValue()));
    rowParams.appendChild(createParamElement("tunnelpolicy", "-"));
    rowParams.appendChild(createParamElement("localWorkingStat", 0));
    rowParams.appendChild(createParamElement("remoteWorkingStat", 0));
    rowParams.appendChild(createParamElement("compWorkingStat", 0));
    rowParams.appendChild(createParamElement("isApplyed", 0));
    bparams.appendChild(rowParams);
    
    if(pwProtectType != NO_PROTECT)
    {
    	rowParams = document.createElement("row-params");
        rowParams.appendChild(createParamElement("vnniId", win.vnniID));
        rowParams.appendChild(createParamElement("vnniId", win.vnniID));
        rowParams.appendChild(createParamElement("role", 1));
        rowParams.appendChild(createParamElement("pwID", ct.getAtom("pwid", 1).getValue()));
        rowParams.appendChild(createParamElement("pwIndex", 0));
        rowParams.appendChild(createParamElement("workState", 2));
        rowParams.appendChild(createParamElement("enableState", 1));
        var pwSignalType = parseInt(ct.getAtom("pwsignaltype", 1).getValue());
        rowParams.appendChild(createParamElement("pwSignalType", pwSignalType));
        rowParams.appendChild(createParamElement("serviceType", ct.getAtom("pwtype", 1).getValue()));
        rowParams.appendChild(createParamElement("direction", ct.getAtom("direction", 1).getValue()));
        rowParams.appendChild(createParamElement("pwEncapsType", ct.getAtom("pwencaptype", 1).getValue()));
        rowParams.appendChild(createParamElement("pwIngressLabel", ct.getAtom("pwinlabel", 1).getValue()));
        rowParams.appendChild(createParamElement("pwEgressLabel", ct.getAtom("pwoutlabel", 1).getValue()));
        rowParams.appendChild(createParamElement("oppositeLsrID", convertIPStrToLong(ct.getAtom("oppsitelsrid", 1).getValue())));
        rowParams.appendChild(createParamElement("tunneltype", tunnelTypes[ct.getAtom("tunneltype", 1).getValue()]));
        rowParams.appendChild(createParamElement("tunnelindex", $("tunnelindex1").value));
        rowParams.appendChild(createParamElement("tunnelid", $("selectedtunnel1").value));
        
        rowParams.appendChild(createParamElement("ingressid", $("ingressid3").value)); 
        rowParams.appendChild(createParamElement("egressid", $("egressid3").value));
        rowParams.appendChild(createParamElement("tunnelid_e", $("tunnelindex3").value));
        
        rowParams.appendChild(createParamElement("controlWord", act.getAtom("controlword").getValue()));
        rowParams.appendChild(createParamElement("ctrlChanType", act.getAtom("controlchanneltype").getValue()));
        rowParams.appendChild(createParamElement("vccv", act.getAtom("vccvmode").getValue()));
        rowParams.appendChild(createParamElement("requestVLAN", act.getAtom("requestvlan").getValue()));
        rowParams.appendChild(createParamElement("tpID", act.getAtom("tpid").getValue()));
        rowParams.appendChild(createParamElement("tunnelpolicy", "-"));
        rowParams.appendChild(createParamElement("localWorkingStat", 0));
        rowParams.appendChild(createParamElement("remoteWorkingStat", 0));
        rowParams.appendChild(createParamElement("compWorkingStat", 0));
        rowParams.appendChild(createParamElement("isApplyed", 0));
        
        bparams.appendChild(rowParams);
        
    }
    di.appendChild(bparams);
    createTableBody(win.nnipwst, win.nnipwtc, EncapsulateData(di), RESOURCE);
    win.initpwportparas();
    win.qosNni = qosNni;
    if (pwProtectType == PW_APS)
    {
        constructProtectGroupRow();
    }
	else if (pwProtectType == SLAVE_PROTECT_PAIR)
	{
		constructPairProtectGroupRow();				
	}
    
    win.needCreateNum++;
    
    win.addCellListener();
    var index = win.nnipwst.getDataRowLength() - 1;
    if (pwSignalType == 1) 
    {
        win.nnipwst.setCellIsEdit(win.nnipwst.getCell(index, "pwIngressLabel"), 1);
        win.nnipwst.setCellIsEdit(win.nnipwst.getCell(index, "pwEgressLabel"), 1);
    }
    
    if (win.$("applypwbtn")) 
    {
        win.$("applypwbtn").disabled = !win.btnRightArr.applybtn.right;
    }

    if (param) 
    {
        xcloseDialog();
    }
    else 
    {
        $("applybtn").disabled = true;
    }
}

function appendParentWinPWQos(type)
{
	var colid = type + "ingress";
	if(qospwst.getCellModify(0, colid)
			|| qospwst.getCellModify(1, colid))
	{
		var wpwid = ct.getAtom("pwid", 0).getValue();
		if(type == "p")
		{
			wpwid = ct.getAtom("pwid", 1).getValue();
		}
		if (qosNni[wpwid] == null) 
        {
            qosNni[wpwid] = new Object();
        }
		qosNni[wpwid].direction = 1;
		qosNni[wpwid].pwIndex = 0;
		qosNni[wpwid].bandwidthlimit = qospwst.getCellStoreValue(0, colid, colid);
		if(qosNni[wpwid].bandwidthlimit == 1)
        {
        	 qosNni[wpwid].cir = qospwst.getCellShow(2, colid).element.innerHTML;
        	 qosNni[wpwid].cbs = qospwst.getCellShow(3, colid).element.innerHTML;
        	 qosNni[wpwid].pir = qospwst.getCellShow(4, colid).element.innerHTML;
        	 qosNni[wpwid].pbs = qospwst.getCellShow(5, colid).element.innerHTML;
        }
		if (qospwst.getCellModify(1, colid)) 
        {
            qosNni[wpwid].policy = qospwst.getCellStoreValue(1, colid, colid);
        }
		if (qospwst.getCellModify(6, colid)) 
        {
            qosNni[wpwid].exp = qospwst.getCellStoreValue(6, colid, colid);
        }
        if (qospwst.getCellModify(7, colid)) 
        {
            qosNni[wpwid].lspmode = qospwst.getCellStoreValue(7, colid, colid);
        }
	}
}

function checkCBSDataValid()
{
	var wcbsValue = qospwst.getCellShow(3, "wingress").element.innerText;
	var pcbsValue = qospwst.getCellShow(3, "pingress").element.innerText;
	if((wcbsValue==""||wcbsValue==null) || (pcbsValue==""||pcbsValue==null))
	{
		return false;
	}
    return true;
}

function checkPBSDataValid()
{	
	var wpbsValue = qospwst.getCellShow(5, "wingress").element.innerText;
	var ppbsValue = qospwst.getCellShow(5, "pingress").element.innerText;
	if((wpbsValue==""||wpbsValue==null) || (ppbsValue==""||ppbsValue==null))
	{
		return false;
	}
    return true;
}

function validate()
{
    var msgArr = new Array();
    var notEntered = RESOURCE["notentered"];
    if(pwProtectType == NO_PROTECT)
    {
        if (ct.getAtom("pwid", 0).getValue() == "") 
        {
            msgArr[msgArr.length] = "PW ID" + RESOURCE["rangemsg"] + "1~4294967295";
        }
        var labelRange = "16~1048575";
        var pwEncapType = parseInt(ct.getAtom("pwencaptype", 0).getValue());
        if (pwEncapType == 2) // UDP
        {
            labelRange = "49153~50176";
        }
        var v = ct.getAtom("pwinlabel", 0).getValue();
        if (v != "-" && v == "") 
        {
            msgArr[msgArr.length] = RESOURCE["pwinlabel"] + RESOURCE["rangemsg"] + labelRange;
        }
        v = ct.getAtom("pwoutlabel", 0).getValue();
        if (v != "-" && v == "") 
        {
            msgArr[msgArr.length] = RESOURCE["pwoutlabel"] + RESOURCE["rangemsg"] + labelRange;
        }
        if ($("selectedtunnel0").value == "") 
        {
            msgArr[msgArr.length] = "Ingress Tunnel"
        }
        if ($("selectedtunnel2").value == "") 
        {
            msgArr[msgArr.length] = "Egress Tunnel"
        }
        v = ct.getAtom("oppsitelsrid", 0).getValue();
        var arr = v.split(".");
        var fIp = parseInt(arr[0]);
        var tIp = parseInt(arr[3]);
        if (fIp == 0 || fIp == 127 || (fIp >= 224 && fIp <= 255) || tIp == 0 || tIp == 255) 
        {
            msgArr[msgArr.length] = RESOURCE["oppsitelsrid"] + RESOURCE["inputmsg"] + "0.*.*.*,127.*.*.*,*.*.*.0,*.*.*.255,224.0.0.0~255.255.255.255";
        }
        
        if (!checkCBSDataValid())
        {
        	msgArr[msgArr.length] = RESOURCE["cbstitle"];
        }
    	
    	if (!checkPBSDataValid())
    	{
    		msgArr[msgArr.length] = RESOURCE["pbstitle"];
        }
        
        if (msgArr.length > 0) 
        {
            var msg = RESOURCE["errormsg"];
            for (var i = 0, m = msgArr.length; i < m; i++) 
            {
                msg += "\n(" + (i + 1) + ")" + msgArr[i];
            }
            alert(msg);
            return false;
        }
    }else if(pwProtectType == PW_APS)
    {
        if ((ct.getAtom("pwid", 0).getValue() == "") || (ct.getAtom("pwid", 1).getValue() == "")) 
        {
            msgArr[msgArr.length] = "PW ID" + RESOURCE["rangemsg"] + "1~4294967295";
        }
        /************        1       PW             16~1048575*****************/
        var labelRange = "16~1048575";
        var pwEncapType = parseInt(ct.getAtom("pwencaptype", 0).getValue());
        var pwEncapType1 = parseInt(ct.getAtom("pwencaptype", 1).getValue());
        if ((pwEncapType == 2) || (pwEncapType1 == 2)) // UDP
        {
            labelRange = "49153~50176";
        }
        var v = ct.getAtom("pwinlabel", 0).getValue();
        var v1 = ct.getAtom("pwinlabel", 1).getValue();
        if ((v != "-" && v == "") || (v1 != "-" && v1 == "")) 
        {
            msgArr[msgArr.length] = RESOURCE["pwinlabel"] + RESOURCE["rangemsg"] + labelRange;
        }
        /*****************************/
        v = ct.getAtom("pwoutlabel", 0).getValue();
        v1 = ct.getAtom("pwoutlabel", 1).getValue();
        if ((v != "-" && v == "") && (v1 != "-" && v1 == "")) 
        {
            msgArr[msgArr.length] = RESOURCE["pwoutlabel"] + RESOURCE["rangemsg"] + labelRange;
        }
        if (($("selectedtunnel0").value == "") || ($("selectedtunnel0").value == "")) 
        {
            msgArr[msgArr.length] = "Ingress Tunnel"
        }
        if (($("selectedtunnel2").value == "") || ($("selectedtunnel3").value == "")) 
        {
            msgArr[msgArr.length] = "Egress Tunnel"
        }
        
        v = ct.getAtom("oppsitelsrid", 0).getValue();
        v1 = ct.getAtom("oppsitelsrid", 1).getValue();
        var arr = v.split(".");
        var fIp = parseInt(arr[0]);
        var tIp = parseInt(arr[3]);
        var flag1 = fIp == 0 || fIp == 127 || (fIp >= 224 && fIp <= 255) || tIp == 0 || tIp == 255;
        arr = v1.split(".");
        fIp = parseInt(arr[0]);
        tIp = parseInt(arr[3]);
        var flag2 = fIp == 0 || fIp == 127 || (fIp >= 224 && fIp <= 255) || tIp == 0 || tIp == 255;
        if (flag1 || flag2) 
        {
            msgArr[msgArr.length] = RESOURCE["oppsitelsrid"] + RESOURCE["inputmsg"] + "0.*.*.*,127.*.*.*,*.*.*.0,*.*.*.255,224.0.0.0~255.255.255.255";
        }
        
        if(pwProtectCT.getAtom("protectid").getValue() == "")
        {
        	msgArr[msgArr.length] = RESOURCE["protectInfonotcomplete"];
        }
        if (!checkCBSDataValid())
        {
        	msgArr[msgArr.length] = RESOURCE["cbstitle"];
        }
    	
    	if (!checkPBSDataValid())
    	{
    		msgArr[msgArr.length] = RESOURCE["pbstitle"];
        }
        if (msgArr.length > 0) 
        {
            var msg = RESOURCE["errormsg"];
            for (var i = 0, m = msgArr.length; i < m; i++) 
            {
                msg += "\n(" + (i + 1) + ")" + msgArr[i];
            }
            alert(msg);
            return false;
        }    
    }else{

        if ((ct.getAtom("pwid", 0).getValue() == "") || (ct.getAtom("pwid", 1).getValue() == "")) 
        {
            msgArr[msgArr.length] = "PW ID" + RESOURCE["rangemsg"] + "1~4294967295";
        }
        /************        1       PW             16~1048575*****************/
        var labelRange = "16~1048575";
        var pwEncapType = parseInt(ct.getAtom("pwencaptype", 0).getValue());
        var pwEncapType1 = parseInt(ct.getAtom("pwencaptype", 1).getValue());
        if ((pwEncapType == 2) || (pwEncapType1 == 2)) // UDP
        {
            labelRange = "49153~50176";
        }
        var v = ct.getAtom("pwinlabel", 0).getValue();
        var v1 = ct.getAtom("pwinlabel", 1).getValue();
        if ((v != "-" && v == "") || (v1 != "-" && v1 == "")) 
        {
            msgArr[msgArr.length] = RESOURCE["pwinlabel"] + RESOURCE["rangemsg"] + labelRange;
        }
        /*****************************/
        v = ct.getAtom("pwoutlabel", 0).getValue();
        v1 = ct.getAtom("pwoutlabel", 1).getValue();
        if ((v != "-" && v == "") && (v1 != "-" && v1 == "")) 
        {
            msgArr[msgArr.length] = RESOURCE["pwoutlabel"] + RESOURCE["rangemsg"] + labelRange;
        }
        if (($("selectedtunnel0").value == "") || ($("selectedtunnel0").value == "")) 
        {
            msgArr[msgArr.length] = "Ingress Tunnel"
        }
        if (($("selectedtunnel2").value == "") || ($("selectedtunnel3").value == "")) 
        {
            msgArr[msgArr.length] = "Egress Tunnel"
        }
        
        v = ct.getAtom("oppsitelsrid", 0).getValue();
        v1 = ct.getAtom("oppsitelsrid", 1).getValue();
        var arr = v.split(".");
        var fIp = parseInt(arr[0]);
        var tIp = parseInt(arr[3]);
        var flag1 = fIp == 0 || fIp == 127 || (fIp >= 224 && fIp <= 255) || tIp == 0 || tIp == 255;
        arr = v1.split(".");
        fIp = parseInt(arr[0]);
        tIp = parseInt(arr[3]);
        var flag2 = fIp == 0 || fIp == 127 || (fIp >= 224 && fIp <= 255) || tIp == 0 || tIp == 255;
        if (flag1 || flag2) 
        {
            msgArr[msgArr.length] = RESOURCE["oppsitelsrid"] + RESOURCE["inputmsg"] + "0.*.*.*,127.*.*.*,*.*.*.0,*.*.*.255,224.0.0.0~255.255.255.255";
        }
        
        if($("protectidforpair").value == "")
        {
        	msgArr[msgArr.length] = RESOURCE["protectInfonotcomplete"];
        }
        if (!checkCBSDataValid())
        {
        	msgArr[msgArr.length] = RESOURCE["cbstitle"];
        }
    	
    	if (!checkPBSDataValid())
    	{
    		msgArr[msgArr.length] = RESOURCE["pbstitle"];
        }
        if (msgArr.length > 0) 
        {
            var msg = RESOURCE["errormsg"];
            for (var i = 0, m = msgArr.length; i < m; i++) 
            {
                msg += "\n(" + (i + 1) + ")" + msgArr[i];
            }
            alert(msg);
            return false;
        }    
    }

    return true;
}

function constructProtectGroupRow()
{
	win.pwProtectStruct.block = "NSCMD_ETHN_PWAPS_ADD_APSPG";
	win.pwProtectStruct.neid = neid;
	win.pwProtectStruct.autoassign = "0";
	win.pwProtectStruct.apsid =pwProtectCT.getAtom("protectid").getValue();
	win.pwProtectStruct.tunneltype = "1";
	win.pwProtectStruct.protype = pwProtectCT.getAtom("protecttype").getValue();
	win.pwProtectStruct.isenable = pwProtectCT.getAtom("isenable").getValue();
	win.pwProtectStruct.switchmode = pwProtectCT.getAtom("swtichmode").getValue();
	win.pwProtectStruct.rvtmode = pwProtectCT.getAtom("recoverymode").getValue();
    if(pwProtectCT.getAtom("recoverytime").getValue() == "-")
    {
    	win.pwProtectStruct.wtrtime = "1";
    }
    else
    {
    	win.pwProtectStruct.wtrtime = pwProtectCT.getAtom("recoverytime").getValue();
    }
    win.pwProtectStruct.delaytime = pwProtectCT.getAtom("swtichtime").getValue();
    win.pwProtectStruct.groupid = 0xFFFF;
    win.pwProtectStruct.checkMode = pwOAMCT.getAtom("testtype",0).getValue();
    win.pwProtectStruct.protectcheckMode = pwOAMCT.getAtom("testtype",1).getValue();
    win.pwProtectStruct.pagcketType =  pwOAMCT.getAtom("testprotocoltype",0).getValue();
    win.pwProtectStruct.checkPeriod = pwOAMCT.getAtom("testperiod",0).getValue();
    win.pwProtectStruct.protectpagcketType = pwOAMCT.getAtom("testprotocoltype",1).getValue();
    win.pwProtectStruct.protectcheckPeriod = pwOAMCT.getAtom("testperiod",1).getValue();
    if(pwOAMCT.getAtom("receivedlsrid",0).getValue() == null || pwOAMCT.getAtom("receivedlsrid",0).getValue() == "")
    {
    	win.pwProtectStruct.lsrId = convertIPStrToLong(pwct.getAtom("oppsitelsrid",0).getValue());
    }
    else
    {
    	win.pwProtectStruct.lsrId = convertIPStrToLong(pwOAMCT.getAtom("receivedlsrid",0).getValue());
    }
     
  if(pwOAMCT.getAtom("sendpwid",0).getValue() == null || pwOAMCT.getAtom("sendpwid",0).getValue() == "")
  {
	  win.pwProtectStruct.sendpwId = pwct.getAtom("pwid",0).getValue();  
  }
  else
  {
	  win.pwProtectStruct.sendpwId = pwOAMCT.getAtom("sendpwid",0).getValue();  
  }
  if(pwOAMCT.getAtom("receivedlsrid",1).getValue() == null || pwOAMCT.getAtom("receivedlsrid",1).getValue() == "")
  {
	  win.pwProtectStruct.protectlsrId = convertIPStrToLong(pwct.getAtom("oppsitelsrid",1).getValue());
  }
  else
  {
	  win.pwProtectStruct.protectlsrId = convertIPStrToLong(pwOAMCT.getAtom("receivedlsrid",1).getValue());
  }
  if(pwOAMCT.getAtom("sendpwid",1).getValue() == null || pwOAMCT.getAtom("sendpwid",1).getValue() == "")
  {
	  win.pwProtectStruct.protectsendpwId = pwct.getAtom("pwid",1).getValue();
  }
  else
  {
	  win.pwProtectStruct.protectsendpwId = pwOAMCT.getAtom("sendpwid",1).getValue();
  }
}

function constructPairProtectGroupRow()
{
	win.pwPairProtectStruct.block = "NSCMD_ETHN_PWAPS_ADD_APSPAIR";
	win.pwPairProtectStruct.neid = neid;
	win.pwPairProtectStruct.autoassign = "0";
	win.pwPairProtectStruct.apsid = $("protectidforpair").value;
	win.pwPairProtectStruct.protype = pwProtectType;
}

function createAps()
{
	var xmlData = createApsXml();
	if(xmlData == null)
	{
		return;
	}
	var urlstr = "../../../../../../neExlorerServlet?sfid="+TE_F_CMD_MSTPPLUS_PW_ADD_APS+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+nmUser;
	loadXMLdoc(urlstr, "POST", false, callbackCreateAps, true, "inputdata="+xmlData);
}

function callbackCreateAps(doc,param)
{
	var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	if(0 == errorCode) 
	{
		if(win.tabSelectFlg == "pwAPS")
  	   {
  	      win.doQueryPWAPS();
  	   }else if(tabSelectFlg == "pwapsPairs")
  	   {
  	      win.doQueryPWAPSPairs();
  	   }
  	      window.close();
	}
	else
	{
		showErrorDialog(data);
	}	
}

function createApsXml()
{
  if(!validateAPS())
  {
	 return null;
  }
  
  var root = new inputxml("datainterface");
  var business = new tagElement("bussiness-params");
  var row,param;
  
  var fstRow = constructPwRow("1", 0xffffffff, 0xffffffff, 0, 1);
  fstRow.appendChild(createTagElement("neid", neid));
  fstRow.appendChild(createTagElement("autoassign", 0));
  fstRow.appendChild(createTagElement("pwSignalType", pwct.getAtom("pwsignaltype",1).getValue()));
  fstRow.appendChild(createTagElement("pwType", pwct.getAtom("pwtype",1).getValue()));
  fstRow.appendChild(createTagElement("pwID", pwct.getAtom("pwid",1).getValue()));
  fstRow.appendChild(createTagElement("direction", pwct.getAtom("direction",1).getValue()));
  fstRow.appendChild(createTagElement("pwIngressLabel", pwct.getAtom("pwinlabel",1).getValue()));
  fstRow.appendChild(createTagElement("pwEgressLabel", pwct.getAtom("pwoutlabel",1).getValue()));
  fstRow.appendChild(createTagElement("oppositeLsrID", pwct.getAtom("oppsitelsrid",1).getValue()));
  fstRow.appendChild(createTagElement("pwEncapsType", pwct.getAtom("pwencaptype",1).getValue()));
  var tunnelIndexHex = tenToHex($("tunnelindex1").value);
  for (var i = tunnelIndexHex.length; i < 8; i++) 
  {
      tunnelIndexHex = "0" + tunnelIndexHex;
  }
  fstRow.appendChild(createTagElement("tunnelIndexes", tunnelIndexHex));
  fstRow.appendChild(createTagElement("tunnelid", $("selectedtunnel1").value));
  fstRow.appendChild(createTagElement("ingressid", $("ingressid1").value));
  fstRow.appendChild(createTagElement("egressid", $("egressid1").value));
  fstRow.appendChild(createTagElement("serviceid", serviceID));
  fstRow.appendChild(createTagElement("workPWID", pwct.getAtom("pwid",0).getValue()));
  for(var k = 0, size = win.nniData.rows.length; k < size; k++)
  {
	  if(win.nniData.rows[k].block.value == "NSCMD_SERVICE_GET_EVNNI_EX")
		{
		  if(win.nniData.rows[k].requestVLAN != null && win.nniData.rows[k].requestVLAN.value != null
				  	&& win.nniData.rows[k].requestVLAN.value != "-1"&& win.nniData.rows[k].requestVLAN.value != "-")
			{
			  fstRow.appendChild(createTagElement("requestVLAN", win.nniData.rows[k].requestVLAN.value));
			}
		}
  }
 
  fstRow.appendChild(createTagElement("apsid", pwProtectCT.getAtom("protectid").getValue()));
  fstRow.appendChild(createTagElement("tunneltype", 1));
  fstRow.appendChild(createTagElement("protype", pwProtectCT.getAtom("protecttype").getValue()));
  fstRow.appendChild(createTagElement("isenable", pwProtectCT.getAtom("isenable").getValue()));
  fstRow.appendChild(createTagElement("switchmode", pwProtectCT.getAtom("swtichmode").getValue()));
  fstRow.appendChild(createTagElement("rvtmode", pwProtectCT.getAtom("recoverymode").getValue()));
  if(pwProtectCT.getAtom("recoverytime").getValue() == "-")
  {
     fstRow.appendChild(createTagElement("wtrtime", "1"));
  }
  else
  {
    fstRow.appendChild(createTagElement("wtrtime", pwProtectCT.getAtom("recoverytime").getValue()));
  }
  fstRow.appendChild(createTagElement("delaytime", pwProtectCT.getAtom("swtichtime").getValue()));
  fstRow.appendChild(createTagElement("groupid", 0xFFFF));
  
  fstRow.appendChild(createTagElement("checkMode", pwOAMCT.getAtom("testtype",0).getValue()));
  fstRow.appendChild(createTagElement("protectcheckMode", pwOAMCT.getAtom("testtype",1).getValue()));
  fstRow.appendChild(createTagElement("pagcketType", pwOAMCT.getAtom("testprotocoltype",0).getValue()));
  fstRow.appendChild(createTagElement("checkPeriod", pwOAMCT.getAtom("testperiod",0).getValue()));
  fstRow.appendChild(createTagElement("protectpagcketType", pwOAMCT.getAtom("testprotocoltype",1).getValue()));
  fstRow.appendChild(createTagElement("protectcheckPeriod", pwOAMCT.getAtom("testperiod",1).getValue()));
  
  if(pwOAMCT.getAtom("receivedlsrid",0).getValue() == null || pwOAMCT.getAtom("receivedlsrid",0).getValue() == "")
  {
  	fstRow.appendChild(createTagElement("lsrId", convertIPStrToLong(pwct.getAtom("oppsitelsrid",0).getValue())));
  }
  else
  {
  	fstRow.appendChild(createTagElement("lsrId", convertIPStrToLong(pwOAMCT.getAtom("receivedlsrid",0).getValue())));
  }
  if(pwOAMCT.getAtom("sendpwid",0).getValue() == null || pwOAMCT.getAtom("sendpwid",0).getValue() == "")
  {
  	 fstRow.appendChild(createTagElement("sendpwId", pwct.getAtom("pwid",0).getValue()));
  }
  else
  {
  	 fstRow.appendChild(createTagElement("sendpwId", pwOAMCT.getAtom("sendpwid",0).getValue()));
  }
  if(pwOAMCT.getAtom("receivedlsrid",1).getValue() == null || pwOAMCT.getAtom("receivedlsrid",1).getValue() == "")
  {
  	fstRow.appendChild(createTagElement("protectlsrId", convertIPStrToLong(pwct.getAtom("oppsitelsrid",1).getValue())));
  }
  else
  {
  	fstRow.appendChild(createTagElement("protectlsrId", convertIPStrToLong(pwOAMCT.getAtom("receivedlsrid",1).getValue())));
  }
  if(pwOAMCT.getAtom("sendpwid",1).getValue() == null || pwOAMCT.getAtom("sendpwid",1).getValue() == "")
  {
  	 fstRow.appendChild(createTagElement("protectsendpwId", pwct.getAtom("pwid",1).getValue()));
  }
  else
  {
  	 fstRow.appendChild(createTagElement("protectsendpwId", pwOAMCT.getAtom("sendpwid",1).getValue()));
  }
  business.appendChild(fstRow);
  root.getRoot().appendChild(business);
 
  return root.toString();
}

function validateAPS()
{
    var msgArr = new Array();

    if(pwProtectType == PW_APS)
	{
		protectId = pwProtectCT.getAtom("protectid").getValue();
	}
    else if(pwProtectType == PROTECT_PAIRS)
	{
		protectId = $("protectidforpair").value;
	}
	if (typeof(protectId) == "undefined" || protectId == "")
	{
        msgArr[msgArr.length] = RESOURCE["PROTECT_ID"] + RESOURCE["rangemsg"] + "1~32";
    }
    
    if (msgArr.length > 0) 
    {
        var msg = RESOURCE["errormsg"];
        for (var i = 0, m = msgArr.length; i < m; i++) 
        {
            msg += "\n(" + (i + 1) + ")" + msgArr[i];
        }
        alert(msg);
        return false;
    }
    
    return true;  
}

function validateUNINNI(index, msgArr)
{
    var beartype = ct.getAttrValue("bearertype");
    if (LOAD_TYPE_PW == beartype)
    {
        var pwid = pwct.getAttrValue("pwid", index);
        if(pwid == null || pwid == "")
        {
        	  msgArr[msgArr.length] = "PW ID";
        }
        
        var labelRange = "16~1048575";
        var pwEncapType = parseInt(pwct.getAtom("pwencaptype", index).getValue());
        if (pwEncapType == 2) // UDP
        {
            labelRange = "49153~50176";
        }
        var v = pwct.getAtom("pwinlabel", index).getValue();
        if (v != "-" && v == "")
        {
            msgArr[msgArr.length] = RESOURCE["pwinlabel"] + RESOURCE["rangemsg"] + labelRange;
        }
        v = pwct.getAtom("pwoutlabel", index).getValue();
        if (v != "-" && v == "") 
        {
            msgArr[msgArr.length] = RESOURCE["pwoutlabel"] + RESOURCE["rangemsg"] + labelRange;
        }
        if ($("selectedtunnel" + index).value == "") 
        {
            msgArr[msgArr.length] = "Tunnel";
        }
        
        if ($("selectedtunnel" + (index+2)).value == "")
        {
            msgArr[msgArr.length] = "Tunnel";
        }
        
        v = pwct.getAtom("oppsitelsrid", index).getValue();
        var arr = v.split(".");
        var fIp = parseInt(arr[0]);
        var tIp = parseInt(arr[3]);
        if (isNaN(fIp) || isNaN(tIp) || fIp == 0 || fIp == 127 || (fIp >= 224 && fIp <= 255) || tIp == 0 || tIp == 255)
        {
            msgArr[msgArr.length] = RESOURCE["oppsitelsrid"] + RESOURCE["inputmsg"] + "0.*.*.*,127.*.*.*,*.*.*.0,*.*.*.255,224.0.0.0~255.255.255.255";
        }
    }
    else 
        if (LOAD_TYPE_PHY_PORT == beartype)//NNI IS PORT
        {
            var nnisinkport = ct.getAtom("sinkport", index).getValue();
            if (nnisinkport != "-" && nnisinkport == "") {
                msgArr[msgArr.length] = RESOURCE["sinkport"];
            }
        }
        else//NNI IS QINQ
        {
            if ($("newQinqrd").checked) 
            {
                var qinqlinkid = qinqct.getAtom("qinqlinkid", index).getValue();
                if (qinqlinkid != "-" && qinqlinkid == "") 
                {
                    msgArr[msgArr.length] = "QinQ Link ID" + RESOURCE["rangemsg"] + "1~4294967295";
                }
                var qinqport = qinqct.getAtom("qinqboard", index).getValue();
                if (qinqport != "-" && qinqport == "") 
                {
                    msgArr[msgArr.length] = RESOURCE["boardspan"] + RESOURCE["port"];
                }
                var qinqvlanid = qinqct.getAtom("qinqsvlanid", index).getValue();
                if (qinqvlanid != "-" && qinqvlanid == "") {
                    msgArr[msgArr.length] = "S-Vlan ID" + RESOURCE["rangemsg"] + "1~4094";
                }
            }
            else 
            {
                var existqinqid = $("existQinqtext").value;
                
                if (existqinqid != "-" && existqinqid == "") 
                {
                    msgArr[msgArr.length] = RESOURCE["qinqradiospan"];
                } 
            }           

            for(var i=0 ;i < st.getDataRowLength();i++)
            {
              var macTag = st.getCellStoreValue(i,"ATTR_ETHOVERPTN_MAC_TAG","ATTR_ETHOVERPTN_MAC_TAG");
        	  var encapType = st.getCellStoreValue(i,"ATTR_ETHOVERPTN_MAC_ENCAP_TYPE","ATTR_ETHOVERPTN_MAC_ENCAP_TYPE");

              if(encapType == 1 && macTag != 1 && win.netype != '114')
              {
                 msgArr[msgArr.length] = RESOURCE["wrong_porttype"];
                 break;
              }              
            }   
        }   
}

function constructPwRow(carrierType,carrierID1,carrierID2,carrierID3,index)
{
    var rowParams = new tagElement("row-params");
    rowParams.appendChild(createTagElement("carrierType", carrierType));
    rowParams.appendChild(createTagElement("carrierID1", carrierID1));
    rowParams.appendChild(createTagElement("carrierID2", carrierID2));
    rowParams.appendChild(createTagElement("carrierID3", carrierID3));
    
    rowParams.appendChild(createTagElement("pwID", pwct.getAtom("pwid",index).getValue()));//
    rowParams.appendChild(createTagElement("pwIndex", 0));
    rowParams.appendChild(createTagElement("enableState", 1));
    rowParams.appendChild(createTagElement("pwSignalType", pwct.getAtom("pwsignaltype",index).getValue()));//
    rowParams.appendChild(createTagElement("pwType", pwct.getAtom("pwtype",index).getValue()));//
    rowParams.appendChild(createTagElement("direction", pwct.getAtom("direction",index).getValue()));//
   
    /*----------- PW        ------------*/
    rowParams.appendChild(createTagElement("pwEncapsType", pwct.getAtom("pwencaptype",index).getValue()));//
    rowParams.appendChild(createTagElement("pwIngressLabel", pwct.getAtom("pwinlabel",index).getValue()));//
    rowParams.appendChild(createTagElement("pwEgressLabel", pwct.getAtom("pwoutlabel",index).getValue()));//
    
    /*----------- PW        ------------*/
    rowParams.appendChild(createTagElement("oppositeLsrID", convertIPStrToLong(pwct.getAtom("oppsitelsrid",index).getValue())));//
    rowParams.appendChild(createTagElement("tunneltype", tunnelTypes[pwct.getAtom("tunneltype",index).getValue()]));//
    var tunnelIndex = $("tunnelindex"+index).value;
    var tunnelIndexHex = tenToHex(tunnelIndex);
    for (var i = tunnelIndexHex.length; i < 8; i++) 
    {
        tunnelIndexHex = "0" + tunnelIndexHex;
    }
    rowParams.appendChild(createTagElement("tunnelIndexes", tunnelIndexHex));  //tunnelIndexes:PW  Ingress  
    
    var tunnelid = $("tunnelindex" + (index + 2)).value;
    var ingressid = $("ingressid" + (index+2)).value;
    var egressid = $("egressid" + (index+2)).value;
    rowParams.appendChild(createTagElement("ingressid", ingressid)); 
    rowParams.appendChild(createTagElement("egressid", egressid)); 
    
    rowParams.appendChild(createTagElement("tunnelid", tunnelid));  //tunnelid:PW  Egress  
    rowParams.appendChild(createTagElement("controlWord", controlWord));
    rowParams.appendChild(createTagElement("ctrlChanType", controlchanneltype));
    rowParams.appendChild(createTagElement("vccv", vccv));
    if("-" != requestVLAN)
    {
    	rowParams.appendChild(createTagElement("requestVLAN", requestVLAN));
    }
    
    rowParams.appendChild(createTagElement("tunnelpolicy", "-"));
    rowParams.appendChild(createTagElement("localWorkingStat", 0));
    rowParams.appendChild(createTagElement("remoteWorkingStat", 0));
    rowParams.appendChild(createTagElement("compWorkingStat", 0));
	var pwID = pwct.getAtom("pwid",index).getValue();
    if (qosNni[pwID] != null) 
    {
        var qos = qosNni[pwID];
        rowParams.appendChild(createTagElement("auto", "0"));
        rowParams.appendChild(createTagElement("qosPwIndex", "0"));
        rowParams.appendChild(createTagElement("direction", qos.direction));
        if (qos.exp != null) 
        {
            rowParams.appendChild(createTagElement("idirection", INGRESS));
            rowParams.appendChild(createTagElement("exp", qos.exp));
        }
       if (qos.lspmode != null) 
       {
            rowParams.appendChild(createTagElement("edirection", EGRESS));
            rowParams.appendChild(createTagElement("lspmode", qos.lspmode));
       }
       if (qos.policy != null) 
       {
           var policyId = INVALID_LABEL_VALUE_2;
           if (qos.policy != "") 
           {
               policyId = qos.policy.substring(0, qos.policy.indexOf("("));
           }
           rowparams.appendChild(createTagElement("policy", policyId));
       }
       if (qos.bandwidthlimit != null && qos.bandwidthlimit != 2) 
       {
            rowParams.appendChild(createTagElement("bandwidthlimit", qos.bandwidthlimit));
            rowParams.appendChild(createTagElement("cir", qos.cir));
            rowParams.appendChild(createTagElement("cbs", qos.cbs));
            rowParams.appendChild(createTagElement("pir", qos.pir));
            rowParams.appendChild(createTagElement("pbs", qos.pbs));
       }   
     
     }
	return rowParams;
}

function createApsPair()
{
	var xmlData = createApsPairXml();

	if(xmlData == null)
	{
		return;
	}
	var urlstr = "../../../../../../neExlorerServlet?sfid="+TE_F_CMD_MSTPPLUS_PW_ADD_APS+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+nmUser;
	loadXMLdoc(urlstr, "POST", false, callbackCreateAps, true, "inputdata="+xmlData);
}

function createApsPairXml()
{
	if(!validateAPS())
  {
	 return null;
  }
  
  var root = new inputxml("datainterface");
  var business = new tagElement("bussiness-params");
  var row,param;
  
  var fstRow = constructPwRow("1", 0xffffffff, 0xffffffff, 0, 1);
  fstRow.appendChild(createTagElement("neid", neid));
  fstRow.appendChild(createTagElement("autoassign", 0));
  fstRow.appendChild(createTagElement("pwSignalType", pwct.getAtom("pwsignaltype",1).getValue()));
  fstRow.appendChild(createTagElement("pwType", pwct.getAtom("pwtype",1).getValue()));
  fstRow.appendChild(createTagElement("pwID", pwct.getAtom("pwid",1).getValue()));
  fstRow.appendChild(createTagElement("direction", pwct.getAtom("direction",1).getValue()));
  fstRow.appendChild(createTagElement("pwIngressLabel", pwct.getAtom("pwinlabel",1).getValue()));
  fstRow.appendChild(createTagElement("pwEgressLabel", pwct.getAtom("pwoutlabel",1).getValue()));
  fstRow.appendChild(createTagElement("oppositeLsrID", pwct.getAtom("oppsitelsrid",1).getValue()));
  fstRow.appendChild(createTagElement("pwEncapsType", pwct.getAtom("pwencaptype",1).getValue()));
  fstRow.appendChild(createTagElement("tunnelIndexes", $("tunnelindex1").value));
  fstRow.appendChild(createTagElement("tunnelid", $("selectedtunnel1").value));
  fstRow.appendChild(createTagElement("ingressid", $("ingressid1").value));
  fstRow.appendChild(createTagElement("egressid", $("egressid1").value));
  fstRow.appendChild(createTagElement("serviceid", serviceID));
  fstRow.appendChild(createTagElement("workPWID", pwct.getAtom("pwid",0).getValue()));
  
  fstRow.appendChild(createTagElement("apsid", $("protectidforpair").value));
  fstRow.appendChild(createTagElement("tunneltype", 1));
  fstRow.appendChild(createTagElement("protype", 2));
  fstRow.appendChild(createTagElement("isenable", pwProtectCT.getAtom("isenable").getValue()));
  fstRow.appendChild(createTagElement("switchmode", pwProtectCT.getAtom("swtichmode").getValue()));
  fstRow.appendChild(createTagElement("rvtmode", pwProtectCT.getAtom("recoverymode").getValue()));
  if(pwProtectCT.getAtom("recoverytime").getValue() == "-")
  {
     fstRow.appendChild(createTagElement("wtrtime", "1"));
  }
  else
  {
    fstRow.appendChild(createTagElement("wtrtime", pwProtectCT.getAtom("recoverytime").getValue()));
  }
  fstRow.appendChild(createTagElement("delaytime", pwProtectCT.getAtom("swtichtime").getValue()));
  fstRow.appendChild(createTagElement("groupid", 0xFFFF));
  
  business.appendChild(fstRow);
  root.getRoot().appendChild(business);
 
  return root.toString();
}

function createServiceTag(bussinessNode)
{
    var rowParams = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "block");
    param.setAttribute("value", "SERVICE_TAG");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "serviceTag");
    param.setAttribute("value", serviceTag);
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
}

/**
 *   PW
 * @return
 */
function createPW()
{
	if (!confirm(RESOURCE["SERVICE_BREAK_WARN"])) 
    {
        return;
    }
	var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
	createServiceTag(bussinessNode);

	if((win.netype == NETYPE_950A) && (win.parobj.serviceTag == tagType_SAwared) && (win.parobj.macsflntypeValue == SVL))
	{
		createSawarePortRole(bussinessNode,"2");
	}
	createPWXml(bussinessNode);
	root.getRoot().appendChild(bussinessNode);
     var xml = root.toString();
     if (null == xml) 
     {
         return;
     }
	var urlstr = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IPPTN_ETHSRV_MOD_ELAN_V_NNI+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+nmUser;
	loadXMLdoc(urlstr, "POST", false, callbackCreatePW, true, "inputdata="+xml);
}

/**
 *            xml
 * @param bussinessNode
 * @return
 */
function createSawarePortRole(bussinessNode, role)
{
    var rowParams = new tagElement("row-params");
    var cmdcode;
    rowParams = new tagElement("row-params");
    var param = null;
    cmdcode = "NSCMD_SERVICE_SET_SAWAREPORT_ROLE";
    param = new tagElement("param");
    param.setAttribute("name", "block");
    param.setAttribute("value", cmdcode);
    rowParams.appendChild(param);

    param = new tagElement("param");
    param.setAttribute("name", "autoServiceIndex");
    param.setAttribute("value", "0");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "serviceIndex");
    param.setAttribute("value", win.parobj.serviceIndex);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "sawareporttype");
    param.setAttribute("value", role);
    rowParams.appendChild(param);
   
    bussinessNode.appendChild(rowParams);
}

/**
 *     PW   XML
 * @param bussinessNode
 * @return
 */
function createPWXml(bussinessNode)
{
    var rowparams = new tagElement("row-params");
    rowparams.appendChild(createTagElement("block", "NSCMD_SERVICE_ADD_ETHVNNI"));
    rowparams.appendChild(createTagElement("autoServiceIndex", "0"));
    rowparams.appendChild(createTagElement("serviceIndex", win.parobj.serviceIndex));
    rowparams.appendChild(createTagElement("vnniID", vnniID++));
    rowparams.appendChild(createTagElement("autoVnniID", "0"));
    rowparams.appendChild(createTagElement("carrierType", LOAD_TYPE_PW));
    rowparams.appendChild(createTagElement("carrierID1", 0xffffffff));
    rowparams.appendChild(createTagElement("carrierID2", 0xffffffff));
    rowparams.appendChild(createTagElement("carrierID3", 0xffffffff));
    
    rowparams.appendChild(createTagElement("workState", 1));
    rowparams.appendChild(createTagElement("pwSignalType", parseInt(ct.getAtom("pwsignaltype", 0).getValue())));
    rowparams.appendChild(createTagElement("pwType", ct.getAtom("pwtype", 0).getValue()));
    var pwID = ct.getAtom("pwid", 0).getValue();
    rowparams.appendChild(createTagElement("pwID", pwID));
    rowparams.appendChild(createTagElement("direction", ct.getAtom("direction", 0).getValue()));
    rowparams.appendChild(createTagElement("pwIngressLabel", ct.getAtom("pwinlabel", 0).getValue()));
    rowparams.appendChild(createTagElement("pwEgressLabel", ct.getAtom("pwoutlabel", 0).getValue()));
    rowparams.appendChild(createTagElement("oppositeLsrID",  convertIPStrToLong(ct.getAtom("oppsitelsrid", 0).getValue())));
    var tunnelIndexHex = tenToHex($("tunnelindex0").value);
    for (var i = tunnelIndexHex.length; i < 8; i++) 
    {
        tunnelIndexHex = "0" + tunnelIndexHex;
    }
    rowparams.appendChild(createTagElement("tunnelIndexes", tunnelIndexHex));
    rowparams.appendChild(createTagElement("ingressid", $("ingressid2").value)); 
    rowparams.appendChild(createTagElement("egressid", $("egressid2").value));
    rowparams.appendChild(createTagElement("tunnelid", $("selectedtunnel0").value));
    rowparams.appendChild(createTagElement("pwEncapsType", ct.getAtom("pwencaptype", 0).getValue())); 
    rowparams.appendChild(createTagElement("enableState", 1));
    rowparams.appendChild(createTagElement("controlWord", act.getAtom("controlword").getValue()));
    rowparams.appendChild(createTagElement("ctrlChanType", act.getAtom("controlchanneltype").getValue()));
    rowparams.appendChild(createTagElement("vccv", act.getAtom("vccvmode").getValue()));
    
    rowparams.appendChild(createTagElement("role", 1));
    
    var v = act.getAtom("requestvlan").getValue();
    if (v != "" && v != "-") 
    {
        rowParams.appendChild(createTagElement("requestVLAN", v));
    }
    
    v = act.getAtom("tpid").getValue();
    if (v != "" && v != "-") 
    {
        rowParams.appendChild(createTagElement("tpID", v));
    }
    if (qosNni[pwID] != null) 
    {
        var qos = qosNni[pwID];
        rowparams.appendChild(createTagElement("qosPwIndex", "0"));
        rowparams.appendChild(createTagElement("direction", qos.direction));
        rowparams.appendChild(createTagElement("auto", "0"));
        if (qos.exp != null) 
        {
            rowparams.appendChild(createTagElement("idirection", INGRESS));
            rowparams.appendChild(createTagElement("exp", qos.exp));
        }
        if (qos.lspmode != null) 
        {
            rowparams.appendChild(createTagElement("edirection", EGRESS));
            rowparams.appendChild(createTagElement("lspmode", qos.lspmode));
        }
        if (qos.policy != null) 
        {
            var policyId = INVALID_LABEL_VALUE_2;
            if (qos.policy != "") 
            {
                policyId = qos.policy.substring(0, qos.policy.indexOf("("));
            }
            rowparams.appendChild(createTagElement("policy", policyId));
        }
        if(qos.bandwidthlimit != null && qos.bandwidthlimit == 1)
        {
            rowparams.appendChild(createTagElement("cir", qos.cir));
            rowparams.appendChild(createTagElement("cbs", qos.cbs));
            rowparams.appendChild(createTagElement("pir", qos.pir)); 
            rowparams.appendChild(createTagElement("pbs", qos.pbs));     
        }
    }
    bussinessNode.appendChild(rowparams);
}

/**
 *     PW     
 * @param doc
 * @return
 */
function callbackCreatePW(doc)
{
	var data = EncapsulateData(doc);
	var errorCode = data.getSErrorCode();
	if(0 == errorCode) 
	{
		win.query();
  	    window.close();
	}
	else
	{
		showErrorDialog(data);
	}	
}

function initQoSTableData(tc,imgurl)
{
	qospwst = new SortTable();
	qospwst.setImage(imgurl);
	createTableHead(qospwst, tc);
	qospwst.setOnCellEditHandler(cellQosEditHandler);
	qospwst.setBodyHeight("170px");
	$("pwqos").appendChild(qospwst.getTable());
	
	var di = document.createElement("datainterface");
    var bparams = document.createElement("bussiness-params");
    var rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "bandwithlimittitle"));
    rowParams.appendChild(createParamElement("wingress", "0"));
    rowParams.appendChild(createParamElement("wegress", "0"));
    rowParams.appendChild(createParamElement("pingress", "0"));
    rowParams.appendChild(createParamElement("pegress", "0"));
    bparams.appendChild(rowParams);
    rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "policytitle"));
    rowParams.appendChild(createParamElement("wingress", ""));
    rowParams.appendChild(createParamElement("wegress", ""));
    rowParams.appendChild(createParamElement("pingress", ""));
    rowParams.appendChild(createParamElement("pegress", ""));
    bparams.appendChild(rowParams);
    rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "cirtitle"));
    rowParams.appendChild(createParamElement("wingress", "0"));
    rowParams.appendChild(createParamElement("wegress", "0"));
    rowParams.appendChild(createParamElement("pingress", "0"));
    rowParams.appendChild(createParamElement("pegress", "0"));
    bparams.appendChild(rowParams);
    rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "cbstitle"));
    rowParams.appendChild(createParamElement("wingress", "0"));
    rowParams.appendChild(createParamElement("wegress", "0"));
    rowParams.appendChild(createParamElement("pingress", "0"));
    rowParams.appendChild(createParamElement("pegress", "0"));
    bparams.appendChild(rowParams);
    rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "pirtitle"));
    rowParams.appendChild(createParamElement("wingress", "0"));
    rowParams.appendChild(createParamElement("wegress", "0"));
    rowParams.appendChild(createParamElement("pingress", "0"));
    rowParams.appendChild(createParamElement("pegress", "0"));
    bparams.appendChild(rowParams);
    rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "pbstitle"));
    rowParams.appendChild(createParamElement("wingress", "0"));
    rowParams.appendChild(createParamElement("wegress", "0"));
    rowParams.appendChild(createParamElement("pingress", "0"));
    rowParams.appendChild(createParamElement("pegress", "0"));
    bparams.appendChild(rowParams);
    rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "exptitle"));
    rowParams.appendChild(createParamElement("wingress", "-"));
    rowParams.appendChild(createParamElement("wegress", "-"));
    rowParams.appendChild(createParamElement("pingress", "-"));
    rowParams.appendChild(createParamElement("pegress", "-"));
    bparams.appendChild(rowParams);
    rowParams = document.createElement("row-params");
    rowParams.appendChild(createParamElement("attrid", "lspmodetitle"));
    rowParams.appendChild(createParamElement("wingress", "-"));
    rowParams.appendChild(createParamElement("wegress", "-"));
    rowParams.appendChild(createParamElement("pingress", "-"));
    rowParams.appendChild(createParamElement("pegress", "-"));
    bparams.appendChild(rowParams);
    di.appendChild(bparams);
    createTableBody(qospwst, tc, EncapsulateData(di), RESOURCE);
    qospwst.getCellShow(0,"wingress").setValue(RESOURCE["disabled"]);
    qospwst.getCellShow(0,"wegress").setValue(RESOURCE["disabled"]);
    qospwst.getCellShow(0,"pingress").setValue(RESOURCE["disabled"]);
    qospwst.getCellShow(0,"pegress").setValue(RESOURCE["disabled"]);
    qospwst.getCell(0, "wingress").element.ondblclick = attrCellondbclick;
    qospwst.getCell(1, "wingress").element.ondblclick = openQinQDialog_QoS;
    qospwst.getCell(0, "pingress").element.ondblclick = attrCellondbclick;
    qospwst.getCell(1, "pingress").element.ondblclick = openQinQDialog_QoS;
	qospwst.setCellIsEdit(qospwst.getCell(0,"wegress"),"0");
	qospwst.setCellIsEdit(qospwst.getCell(1,"wegress"),"0");
	qospwst.setCellIsEdit(qospwst.getCell(0,"pegress"),"0");
	qospwst.setCellIsEdit(qospwst.getCell(1,"pegress"),"0");
	qospwst.getCellShow(1,"wegress").setValue("-");
	qospwst.getCellShow(1,"pegress").setValue("-");
    for(var i = 2;i <= 7;i++)
    {
    	qospwst.setCellIsEdit(qospwst.getCell(i,"wingress"),"0");
    	qospwst.getCellShow(i,"wingress").setValue("-");
    	qospwst.setCellIsEdit(qospwst.getCell(i,"wegress"),"0");
        qospwst.getCellShow(i,"wegress").setValue("-");
        qospwst.setCellIsEdit(qospwst.getCell(i,"pingress"),"0");
    	qospwst.getCellShow(i,"pingress").setValue("-");
    	qospwst.setCellIsEdit(qospwst.getCell(i,"pegress"),"0");
        qospwst.getCellShow(i,"pegress").setValue("-");
    }
    
}

function cellQosEditHandler(param)
{
	var colid = param.colid;
	var rowindex = param.rowindex;
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		if(rowindex == 0)
		{
			var bandlimit = qospwst.getCellStoreValue(rowindex,colid,colid);
			if(bandlimit == "1")
			{
				for(var i = 2;i <= 5;i++)
				{
					qospwst.setCellIsEdit(qospwst.getCell(i,colid),"1");
					qospwst.getCell(i, colid).element.ondblclick = attrCellondbclick;
					if(i == 2 || i == 4)
					{
						qospwst.setCellValue(qospwst.getCell(i, colid), colid, 64);
						qospwst.getCellShow(i, colid).element.innerHTML = 64;
					}
					else
					{
						qospwst.setCellValue(qospwst.getCell(i, colid), colid, "");
						qospwst.getCellShow(i, colid).element.innerHTML = "";
					}
				}
			}
			else
			{
				for(var i = 2;i <= 5;i++)
				{
					qospwst.setCellIsEdit(qospwst.getCell(i,colid),"0");
					qospwst.setCellValue(qospwst.getCell(i, colid), colid, "-");
					qospwst.getCellShow(i, colid).element.innerHTML = "-";
				}
			}
		}
	}
}

function convertAttrID(value)
{
	return RESOURCE[value];
}

function attrCellondbclick()
{
    this.style.backgroundColor = "#d0f946";
    if(isIE)
    {
        this.onselectstart = null;
    }
    else
    {
        this.style.MozUserSelect = "text";
    }
    this.modify = true;  
    this.parentNode.modify = true; 
    this.showElement.element.style.display = "none"; 
    var colid = this.colid;
    var rowindex = this.parentNode.rowIndex
	if(rowindex == 0)
	{
		atom = qospwst.createAtom("select");
		this.editElement.type = "select";
		atom.addOption(RESOURCE["disabled"],0);
		atom.addOption(RESOURCE["enabled"],1);
		atom.element.onblur= cellonblur;
	}
	else
	{
	    atom = qospwst.createAtom("text");
	    this.editElement.type = "text";
	    atom.element.onblur= cellonblur;
	    if(rowindex == 2 || rowindex == 4)
	    {
	    	textCheck(atom.element, "64", "1000000");
	    }
	    if(rowindex == 3 || rowindex == 5)
	    {
	    	textCheck(atom.element, "0", "4294967295");
	    }
	}
    if(this.storeValue[colid])
    {
    	atom.setValue(this.storeValue[colid]);
    }
	atom.element.onclick=stopEventPropagation;
    atom.element.onmousedown=atomOnMouseDownHandle;
    atom.element.ondblclick=stopEventPropagation;
    
    this.appendChild(atom.element);
    atom.element.focus();
}

function openQinQDialog_QoS()
{
	CurrentColID = this.colid;
    var policyType = PW_POLICY;
    if (qospwst.getSelectedRowCount() > 1) 
    {
        return;
    }
    
    var url = "../ethcommon/policyselect.html?policyType=" + policyType;
    xshowModalDialog(url, RESOURCE["querypolicybtn"], 480, 300, "../../../../../images/");
}

function selectPolicyHandler(policy)
{
	var rowindex = qospwst.getSelectedRows()[0];
	var cell = qospwst.getCell(rowindex, CurrentColID);
	qospwst.setCellValue(cell, CurrentColID, policy);
	qospwst.getCellShow(rowindex, CurrentColID).element.innerHTML = policy;
	qospwst.setCellModify(rowindex, CurrentColID, true);
	handleCellEdit(cell.element, TABLE_CONSTANT.AFTEREDIT);
}
