/**
 *                   DOM  ,        ,             
 */
function getPortObjectChecked()
{

    var selectPortList = [];
    if ($("ge1port") != null && ($("ge1port").checked == true)) 
    {
        selectPortList.push($("ge1port"));
    }
    if ($("ge2port") != null && ($("ge2port").checked == true)) 
    {
        selectPortList.push($("ge2port"));
    }
    if ($("ge3port") != null && ($("ge3port").checked == true)) 
    {
        selectPortList.push($("ge3port"));
    }
    if ($("ifport") != null && ($("ifport").checked == true)) 
    {
        selectPortList.push($("ifport"));
    }
    
    return selectPortList;
}


/**
 *         id,    
 * @param {String} lineId   ID
 * @param {boolean} dotFlag     
 * @param {boolean} biasFlg     
 */
function refreshBiasLineStatusById(/**String*/lineId,/**boolean*/dotFlag,/**boolean*/biasFlg)
{
	if (document.getElementById(lineId) != null || document.getElementById(lineId) != undefined) 
	{
		if(dotFlag)
		{
			drawDotBiasLine(document.getElementById(lineId),biasFlg);	
		}
		else
		{
			drawBiasLine(document.getElementById(lineId),biasFlg);	
		}
	}
}
/**
 *          id,     
 * @param {String} lineId
 * @param {boolean} dotFlag
 */
function refreshHorizonLineStatusById(/**String*/lineId,/**boolean*/dotFlag)
{
	    if (document.getElementById(lineId) != null || document.getElementById(lineId) != undefined) 
    {
        if (dotFlag) 
        {
            document.getElementById(lineId).style.borderStyle = "dashed";
            document.getElementById(lineId).style.display = "";
        }
        else 
        {
            document.getElementById(lineId).style.borderStyle = "";
            document.getElementById(lineId).style.display = "";
        }
    }
}
/**
 *           id      
 * @param {String} lineId
 * @param {boolean} dotFlag
 */
function refreshVerticalLineStatusById(/**String*/lineId,/**boolean*/dotFlag)
{
	if (document.getElementById(lineId) != null || document.getElementById(lineId) != undefined) 
    {
		if (dotFlag) 
        {
            drawDotVerticalLine(document.getElementById(lineId));
            document.getElementById(lineId).style.display = "";
        }
        else 
        {
            drawVerticalLine(document.getElementById(lineId));
            document.getElementById(lineId).style.display = "";
        }
    }
}

/**
 *           
 */
function refreshLineStatusPortSelect()
{
	var leftLineTdivDotFlg=false;
	var leftVerticalLinedivDotFlg=false;
	var rightLineTdivDotFlg=false;
	var rightVerticalLinedivDotFlg=false;
	var centerUpLineLineDotFlg=false;
	var centerDownLineLineDotFlg=false;

	/**
	 *   GE1                 
	 * leftLineTdiv leftVerticalLinediv centerUpLine
	 */
	if( $("ge1port").checked)
	{
		if(usableBoardArr[portFOGE1-1].portstatus == "0")
		{
			leftLineTdivDotFlg = leftLineTdivDotFlg||true;
			leftVerticalLinedivDotFlg = leftVerticalLinedivDotFlg||true;
			centerUpLineLineDotFlg = centerUpLineLineDotFlg||true;
		}
		else
		{
			leftLineTdivDotFlg = leftLineTdivDotFlg||false;
			leftVerticalLinedivDotFlg = leftVerticalLinedivDotFlg||false;
			centerUpLineLineDotFlg = centerUpLineLineDotFlg||false;
		}
		
	}
	/**
	 *   GE2                 
	 * centerUpLine,rightLineTdiv,rightVerticalLinediv
	 */
	if( $("ge2port").checked)
	{
		if(usableBoardArr[portFOGE2-1].portstatus == "0")
		{
			rightLineTdivDotFlg = rightLineTdivDotFlg||true;
			rightVerticalLinedivDotFlg = rightVerticalLinedivDotFlg||true;
			centerUpLineLineDotFlg = centerUpLineLineDotFlg||true;
		}
		else
		{
			rightLineTdivDotFlg = rightLineTdivDotFlg||false;
			rightVerticalLinedivDotFlg = rightVerticalLinedivDotFlg||false;
			centerUpLineLineDotFlg = centerUpLineLineDotFlg||false;
		}
	}
	/**
	 *   GE3                 
	 * centerDownLine,rightLineTdiv,leftVerticalLinediv
	 */
	if( $("ge3port").checked)
	{
		if(usableBoardArr[portFOGE3-1].portstatus == "0")
		{
			rightLineTdivDotFlg = rightLineTdivDotFlg||true;
			leftVerticalLinedivDotFlg = leftVerticalLinedivDotFlg||true;
			centerDownLineLineDotFlg = centerDownLineLineDotFlg||true;
		}
		else
		{
			rightLineTdivDotFlg = rightLineTdivDotFlg||false;
			leftVerticalLinedivDotFlg = leftVerticalLinedivDotFlg||false;
			centerDownLineLineDotFlg = centerDownLineLineDotFlg||false;
		}
	}
	/**
	 *   IF                 
	 * centerDownLine,rightLineTdiv,rightVerticalLinediv
	 */
	if( $("ifport").checked)
	{
		if(usableBoardArr[portFOIFETH-1].portstatus == "0")
		{
			leftLineTdivDotFlg = leftLineTdivDotFlg||true;				
			rightVerticalLinedivDotFlg = rightVerticalLinedivDotFlg||true;
			centerDownLineLineDotFlg = centerDownLineLineDotFlg||true;
		}
		else
		{
			leftLineTdivDotFlg = leftLineTdivDotFlg||false;
			rightVerticalLinedivDotFlg = rightVerticalLinedivDotFlg||false;
			centerDownLineLineDotFlg = centerDownLineLineDotFlg||false;
		}
	}	
	refreshBiasLineStatusById("leftLineTdiv",leftLineTdivDotFlg,true);	
	refreshBiasLineStatusById("rightLineTdiv",rightLineTdivDotFlg,false);
	refreshVerticalLineStatusById("leftVerticalLinediv",leftVerticalLinedivDotFlg);
	refreshVerticalLineStatusById("rightVerticalLinediv",rightVerticalLinedivDotFlg);
	refreshHorizonLineStatusById("centerDownLine",centerDownLineLineDotFlg);
	refreshHorizonLineStatusById("centerUpLine",centerUpLineLineDotFlg);
}
/**
 *        
 */
function refreshSplitLineStatus()
{
	for (var i = 0; i < splitPortList.length; i++) 
    {
        var splitPorts = splitPortList[i].portdata;
		for (var j = 0; j < splitPorts.length; j++) 
		{
			var portid = getCachePortByuniid(splitPorts[j]).portid;
			if (portid == portFOGE1) 
			{
				if (document.getElementById("leftLineTdiv") != null || document.getElementById("leftLineTdiv") != undefined) 
					{
						document.getElementById("leftLineTdiv").style.display = "none";
					}

					if (document.getElementById("centerUpLine") != null || document.getElementById("centerUpLine") != undefined) 
					{
						document.getElementById("centerUpLine").style.display = "none";
					}

					if (document.getElementById("leftVerticalLinediv") != null || document.getElementById("leftVerticalLinediv") != undefined) 
					{
						document.getElementById("leftVerticalLinediv").style.display = "none";
					}
			}

			if(portid == portFOGE2)
			{
					if (document.getElementById("rightLineTdiv") != null || document.getElementById("rightLineTdiv") != undefined) 
					{
						document.getElementById("rightLineTdiv").style.display = "none";
					}
					if (document.getElementById("centerUpLine") != null || document.getElementById("centerUpLine") != undefined) 
					{
						document.getElementById("centerUpLine").style.display = "none";
					}

					if (document.getElementById("rightVerticalLinediv") != null || document.getElementById("rightVerticalLinediv") != undefined) 
					{
						document.getElementById("rightVerticalLinediv").style.display = "none";
					}
			}
			if(portid == portFOGE3)
			{
					if (document.getElementById("rightLineTdiv") != null || document.getElementById("rightLineTdiv") != undefined) 
					{
						document.getElementById("rightLineTdiv").style.display = "none";
					}

					if (document.getElementById("centerDownLine") != null || document.getElementById("centerDownLine") != undefined) 
					{
						document.getElementById("centerDownLine").style.display = "none";
					}
					if (document.getElementById("leftVerticalLinediv") != null || document.getElementById("leftVerticalLinediv") != undefined) 
					{
						document.getElementById("leftVerticalLinediv").style.display = "none";
					}
				}
				if(portid == portFOIFETH)
				{
					if (document.getElementById("leftLineTdiv") != null || document.getElementById("leftLineTdiv") != undefined) 
					{
						document.getElementById("leftLineTdiv").style.display = "none";
					}

					if (document.getElementById("centerDownLine") != null || document.getElementById("centerDownLine") != undefined) 
					{
						document.getElementById("centerDownLine").style.display = "none";
					}

					if (document.getElementById("rightVerticalLinediv") != null || document.getElementById("rightVerticalLinediv") != undefined) 
					{
						document.getElementById("rightVerticalLinediv").style.display = "none";
					}
				}
			}
       
    }
    /**
     *                   
     */
    if (splitPortList.length == 0) 
    {
        setLineDisplay("");
    }
}
/**
 *              
 * @return
 */
function refreshLineBySplit()
{
	/**
	 *        
	 */
    refreshLineStatusPortSelect();

    /**
     *        
     */
    refreshSplitLineStatus();   

	if (!$("ge1port").checked) 
	{
		setComponetDisplay("port-"+portFOGE1+"div","none");
		setComponetDisplay("port-"+portFOGE1+"span","none");
		setComponetDisplay("leftVerticalLinediv","none");
		setComponetDisplay("leftLineTdiv","none");
		setComponetDisplay("centerUpLine","none");	
	} 
	if (!$("ge2port").checked) 
	{
		setComponetDisplay("port-"+portFOGE2+"div","none");
		setComponetDisplay("port-"+portFOGE2+"span","none");
		setComponetDisplay("rightVerticalLinediv","none");
		setComponetDisplay("rightLineTdiv","none");
		setComponetDisplay("centerUpLine","none");	
	}
	if (!$("ge3port").checked) 
	{
		setComponetDisplay("port-"+portFOGE3+"div","none");
		setComponetDisplay("port-"+portFOGE3+"span","none");
		setComponetDisplay("leftVerticalLinediv","none");
		setComponetDisplay("rightLineTdiv","none");
		setComponetDisplay("centerDownLine","none");	
	} 
	if (!$("ifport").checked) 
	{
		setComponetDisplay("port-"+portFOIFETH+"div","none");
		setComponetDisplay("port-"+portFOIFETH+"span","none");
		setComponetDisplay("rightVerticalLinediv","none");
		setComponetDisplay("leftLineTdiv","none");
		setComponetDisplay("centerDownLine","none");	
	} 		 	
}
/**
 * @param {Object} displayFlag
 *  "none" or ""
 */

function setLineDisplay(displayFlag)
{
	    if (document.getElementById("leftLineTdiv") != null || document.getElementById("leftLineTdiv") != undefined) 
        {
            document.getElementById("leftLineTdiv").style.display = displayFlag;
        }
        if (document.getElementById("rightLineTdiv") != null || document.getElementById("rightLineTdiv") != undefined) 
        {
            document.getElementById("rightLineTdiv").style.display = displayFlag;
        }
		if (document.getElementById("centerUpLine") != null || document.getElementById("centerUpLine") != undefined) 
        {
            document.getElementById("centerUpLine").style.display = displayFlag;
        }
		if (document.getElementById("centerDownLine") != null || document.getElementById("centerDownLine") != undefined) 
        {
            document.getElementById("centerDownLine").style.display = displayFlag;
        }
		if (document.getElementById("leftVerticalLinediv") != null || document.getElementById("leftVerticalLinediv") != undefined) 
        {
            document.getElementById("leftVerticalLinediv").style.display = displayFlag;
        }
		if (document.getElementById("rightVerticalLinediv") != null || document.getElementById("rightVerticalLinediv") != undefined) 
        {
            document.getElementById("rightVerticalLinediv").style.display = displayFlag;
        }
}
function repaintPortTR()
{
    var checkBoxPorts = [];
    var portinfo;
    if ($("ifport").checked) 
    {
        portinfo = usableBoardArr[portFOIFETH - 1];
        checkBoxPorts.push(portinfo);
    }
    if ($("ge1port").checked) 
    {
        portinfo = usableBoardArr[portFOGE1 - 1];
        checkBoxPorts.push(portinfo);
    }
    if ($("ge2port").checked) 
    {
        portinfo = usableBoardArr[portFOGE2 - 1];
        checkBoxPorts.push(portinfo);
    }
    if ($("ge3port").checked) 
    {
        portinfo = usableBoardArr[portFOGE3 - 1];
        checkBoxPorts.push(portinfo);
    }
    createBoardSelect(checkBoxPorts);
}

/**
 *       checkbox
 */
function createPortCheckBoxTR(/* Array */portlist)
{
    var portCheckBoxTD = $("portCheckTd");
    elem = document.createElement("span");
    elem.innerHTML = RESOURCE["portDes"];
    portCheckBoxTD.appendChild(elem);
    
    /**
     * 1 portFoShowName[portFOGE1] = "GE1";
     */
    if (portlist.length >= portFOGE1 && portlist[portFOGE1 - 1] != null) 
    {
        var elem = document.createElement("input");
        elem.type = "checkbox";
        elem.id = "ge1port";
        
        elem.setAttribute("slotid", portlist[portFOGE1 - 1].slotid);
        elem.setAttribute("portid", portlist[portFOGE1 - 1].portid);
        
        elem.onclick = function()
        {
            portSelectChange(portlist[portFOGE1 - 1].portid);
            $("applybtn").disabled = !btnRightArr.applybtn.right;
            queryPortAttribute();
            
        }
        
        portCheckBoxTD.appendChild(elem);
        if (portlist[portFOGE1 - 1].isUsed) 
        {
            elem.checked = true;
        }
        elem = document.createElement("span");
        elem.innerHTML = createPortNameWithVLAN(portFoShowName[portFOGE1], portlist[portFOGE1 - 1].tagID);
        portCheckBoxTD.appendChild(elem);
    }
    /**
     * 2 portFoShowName[portFOGE2] = "GE2";
     */
    if (portlist.length >= portFOGE2 && portlist[portFOGE2 - 1] != null) 
    {
        var elem = document.createElement("input");
        elem.type = "checkbox";
        elem.id = "ge2port";
        
        elem.setAttribute("slotid", portlist[portFOGE2 - 1].slotid);
        elem.setAttribute("portid", portlist[portFOGE2 - 1].portid);
        
        elem.onclick = function()
        {
            portSelectChange(portlist[portFOGE2 - 1].portid);
            $("applybtn").disabled = !btnRightArr.applybtn.right;
            queryPortAttribute();
        }
        portCheckBoxTD.appendChild(elem);
        if (portlist[portFOGE2 - 1].isUsed) 
        {
            elem.checked = true;
        }
        elem = document.createElement("span");
        elem.innerHTML = createPortNameWithVLAN(portFoShowName[portFOGE2], portlist[portFOGE2 - 1].tagID);
        portCheckBoxTD.appendChild(elem);
    }
    /**
     * 3 portFoShowName[portFOGE3] = "GE3";
     */
    if (portlist.length >= portFOGE3 && portlist[portFOGE3 - 1] != null) 
    {
        var elem = document.createElement("input");
        elem.type = "checkbox";
        elem.id = "ge3port";
        
        elem.setAttribute("slotid", portlist[portFOGE3 - 1].slotid);
        elem.setAttribute("portid", portlist[portFOGE3 - 1].portid);
        
        elem.onclick = function()
        {
            portSelectChange(portlist[portFOGE3 - 1].portid);
            $("applybtn").disabled = !btnRightArr.applybtn.right;
            queryPortAttribute();
        }
        portCheckBoxTD.appendChild(elem);
        if (portlist[portFOGE3 - 1].isUsed) 
        {
            elem.checked = true;
        }
        elem = document.createElement("span");
        elem.innerHTML = createPortNameWithVLAN(portFoShowName[portFOGE3], portlist[portFOGE3 - 1].tagID);
        portCheckBoxTD.appendChild(elem);
    }
    /**
     * 4 portFoShowName[portFOIFETH] = "IF(ETH)";
     */
    if (portlist.length >= portFOIFETH && portlist[portFOIFETH - 1] != null) 
    {
        var elem = document.createElement("input");
        elem.type = "checkbox";
        elem.id = "ifport";
        
        elem.setAttribute("slotid", portlist[portFOIFETH - 1].slotid);
        elem.setAttribute("portid", portlist[portFOIFETH - 1].portid);
        
        elem.onclick = function()
        {
            portSelectChange(portlist[portFOIFETH - 1].portid);
            $("applybtn").disabled = !btnRightArr.applybtn.right;
            queryPortAttribute();
        }
        portCheckBoxTD.appendChild(elem);
        if (portlist[portFOIFETH - 1].isUsed) 
        {
            elem.checked = true;
        }
        elem = document.createElement("span");
        elem.innerHTML = createPortNameWithVLAN(portFoShowName[portFOIFETH], portlist[portFOIFETH - 1].tagID);
        portCheckBoxTD.appendChild(elem);
    }
}
function setAllLineDisplay(flag)
{
		setComponetDisplay("leftVerticalLinediv",flag);
		setComponetDisplay("leftLineTdiv",flag);
		setComponetDisplay("centerUpLine",flag);
		setComponetDisplay("centerDownLine",flag);
		setComponetDisplay("rightVerticalLinediv",flag);
		setComponetDisplay("rightLineTdiv",flag);			
}
/**
 * 
 * @param {String} portid
 */
function portSelectChange(/**String*/portid)
{
		switch(parseInt(portid))
		{
			case portFOGE1:
			{
				if($("ge1port").checked)
				{				
					setComponetDisplay("port-"+portFOGE1+"div","");
					setComponetDisplay("port-"+portFOGE1+"span","");

					if($("ge3port").checked)
					{
						setComponetDisplay("leftVerticalLinediv","");
						/**
						 *         
						 */						
						if(usableBoardArr[portFOGE1-1].portstatus == "0"||usableBoardArr[portFOGE3-1].portstatus == "0")
						{
							refreshVerticalLineStatusById("leftVerticalLinediv",true);
						}
					}
					if($("ifport").checked)
					{
						setComponetDisplay("leftLineTdiv","");
						/**
						 *         
						 */						
						if(usableBoardArr[portFOGE1-1].portstatus == "0"||usableBoardArr[portFOIFETH-1].portstatus == "0")
						{						
							refreshBiasLineStatusById("leftLineTdiv",true,true);
						}
					}
					if($("ge2port").checked)
					{

						setComponetDisplay("centerUpLine","");
						/**
						 *         
						 */						
						if(usableBoardArr[portFOGE1-1].portstatus == "0"||usableBoardArr[portFOGE2-1].portstatus == "0")
						{						
							refreshHorizonLineStatusById("centerUpLine",true);
						}
					}

				}
				else
				{
					setComponetDisplay("port-"+portFOGE1+"div","none");
					setComponetDisplay("port-"+portFOGE1+"span","none");
					setComponetDisplay("leftVerticalLinediv","none");
					setComponetDisplay("leftLineTdiv","none");
					setComponetDisplay("centerUpLine","none");						
				}
				break;
			}
			case portFOGE2:
			{
				if ($("ge2port").checked) 
				{				
					setComponetDisplay("port-"+portFOGE2+"div","");
					setComponetDisplay("port-"+portFOGE2+"span","");
					if($("ifport").checked)
					{
						setComponetDisplay("rightVerticalLinediv", "");
						/**
						 *         
						 */						
						if(usableBoardArr[portFOGE2-1].portstatus == "0"||usableBoardArr[portFOIFETH-1].portstatus == "0")
						{
							refreshVerticalLineStatusById("rightVerticalLinediv",true);
						}
					}
					if($("ge3port").checked)
					{
						setComponetDisplay("rightLineTdiv", "");
						/**
						 *         
						 */						
						if(usableBoardArr[portFOGE2-1].portstatus == "0"||usableBoardArr[portFOGE3-1].portstatus == "0")
						{
							refreshBiasLineStatusById("rightLineTdiv",true,false);
						}						
					}
					if($("ge1port").checked)
					{
						setComponetDisplay("centerUpLine", "");
						/**
						 *         
						 */						
						if(usableBoardArr[portFOGE2-1].portstatus == "0"||usableBoardArr[portFOGE1-1].portstatus == "0")
						{
							refreshHorizonLineStatusById("centerUpLine",true);
						}						
					}					
				}
				else
				{
					setComponetDisplay("port-"+portFOGE2+"div","none");
					setComponetDisplay("port-"+portFOGE2+"span","none");
					setComponetDisplay("rightVerticalLinediv", "none");
					setComponetDisplay("rightLineTdiv", "none");
					setComponetDisplay("centerUpLine", "none");					
				}
				break;
			}
			case portFOGE3:
			{
				if ($("ge3port").checked) 
				{
					
					setComponetDisplay("port-"+portFOGE3+"div","");
					setComponetDisplay("port-"+portFOGE3+"span","");
					if($("ge1port").checked)
					{
						setComponetDisplay("leftVerticalLinediv", "");
						/**
						 *         
						 */						
						if(usableBoardArr[portFOGE3-1].portstatus == "0"||usableBoardArr[portFOGE1-1].portstatus == "0")
						{
							refreshVerticalLineStatusById("leftVerticalLinediv",true);
						}
					}
					if($("ge2port").checked)
					{
						setComponetDisplay("rightLineTdiv", "");
						/**
						 *         
						 */						
						if(usableBoardArr[portFOGE3-1].portstatus == "0"||usableBoardArr[portFOGE2-1].portstatus == "0")
						{
							refreshBiasLineStatusById("rightLineTdiv",true,false);
						}
					}
					if($("ifport").checked)
					{
						setComponetDisplay("centerDownLine", "");
						/**
						 *         
						 */						
						if(usableBoardArr[portFOGE3-1].portstatus == "0"||usableBoardArr[portFOIFETH-1].portstatus == "0")
						{
							refreshHorizonLineStatusById("centerDownLine",true);
						}						
					}					
					
				}
				else
				{
					setComponetDisplay("port-"+portFOGE3+"div","none");
					setComponetDisplay("port-"+portFOGE3+"span","none");
					setComponetDisplay("leftVerticalLinediv", "none");
					setComponetDisplay("rightLineTdiv", "none");
					setComponetDisplay("centerDownLine", "none");					
				}
				break;
			}
			case portFOIFETH:
			{
				if ($("ifport").checked) 
				{					
					
					setComponetDisplay("port-"+portFOIFETH+"div","");
					setComponetDisplay("port-"+portFOIFETH+"span","");
					var isOnlyOnePortCheck =true;
					if($("ge2port").checked)
					{
						setComponetDisplay("rightVerticalLinediv", "");
						/**
						 *         
						 */						
						if(usableBoardArr[portFOIFETH-1].portstatus == "0"||usableBoardArr[portFOGE2-1].portstatus == "0")
						{	
							refreshVerticalLineStatusById("rightVerticalLinediv",true);
						}
					}
					if($("ge1port").checked)
					{
						setComponetDisplay("leftLineTdiv", "");
						/**
						 *         
						 */						
						if(usableBoardArr[portFOIFETH-1].portstatus == "0"||usableBoardArr[portFOGE1-1].portstatus == "0")
						{	
							refreshBiasLineStatusById("leftLineTdiv",true,true);
						}						
					}
					if($("ge3port").checked)
					{
						setComponetDisplay("centerDownLine", "");
						/**
						 *         
						 */						
						if(usableBoardArr[portFOIFETH-1].portstatus == "0"||usableBoardArr[portFOGE3-1].portstatus == "0")
						{	
							refreshHorizonLineStatusById("centerDownLine",true);
						}						
					}
				
				}
				else
				{
					setComponetDisplay("port-"+portFOIFETH+"div","none");
					setComponetDisplay("port-"+portFOIFETH+"span","none");
					setComponetDisplay("rightVerticalLinediv", "none");
					setComponetDisplay("leftLineTdiv", "none");
					setComponetDisplay("centerDownLine", "none");					
				}
				break;
			}
		}
}

/**
 * 
 * @param {String} comId
 * @param {boolean} displayflg "none" or ""
 */
function setComponetDisplay(/**String*/comId,/**String*/ displayflg)
{
	if (document.getElementById(comId) != null || document.getElementById(comId) != undefined) 
	{
		/**
		 * DTS2013031805133 
		 *         
		 */
		var tmpFlag = 'visible';
		if (displayflg == "none")
		{
			tmpFlag = 'hidden';
		}
		document.getElementById(comId).style.visibility = tmpFlag;
	}	
}
/**
 * create board tree      3        
 */
function createBoardSelect(/* Array */portlist)
{
	var slotid = "1";
	
	var tbody = $("portResTable").childNodes[0];
	
	clearPortResTable();
	/**
	 *              
	 *           
	 *                      
	 */
	var trList = addFourPortTR();
	for(var pos=0,len = trList.length;pos<len;pos++)
	{
		tbody.appendChild(trList[pos]);
	}
	refreshLineBySplit();
}

/**
 *      4      
 *
 * [leftPort-GE1] ------------ [rightPort-GE2]
		 -					          -
		 -	 						  -
		 -	  						  -
		 -	   						  -
		 -	 						  -
		 -	 						  -
		 -	   						  -
		 -	  						  -
		 -							  -
		 -							  -
 * [rightPort-GE2]  ----------  [downPort-IF]
 */
function addFourPortTR()
{
    /**
     *            
     */
    var leftPort = usableBoardArr[portFOGE1 - 1];
    var rightPort = usableBoardArr[portFOGE2 - 1];
    var downRightPort = usableBoardArr[portFOIFETH - 1];
    var downLeftPort = usableBoardArr[portFOGE3 - 1];
    
    var upTR = addPortUpTopTR(leftPort, rightPort, "centerUpLine");
    var downTR = addPortUpTopTR(downLeftPort, downRightPort, "centerDownLine");
    
    var centerTR = document.createElement("tr");
    centerTR.className = "porttypetr";
    centerTR.style.verticalAlign = "middle";
    centerTR.align = "center";
	
	/**
     *     
     */
    var leftVerticalLineTD = document.createElement("td");
    var leftVerticalLinediv = document.createElement("div");
    leftVerticalLinediv.id = "leftVerticalLinediv";
    leftVerticalLinediv.className = "port4linecontainertr";
    leftVerticalLinediv.style.position = "absolute";
    leftVerticalLinediv.style.left = "-30px";
    leftVerticalLineTD.appendChild(leftVerticalLinediv);
    centerTR.appendChild(leftVerticalLineTD);
    /**
     *     
     */
    var rightVerticalLineTD = document.createElement("td");
    var rightVerticalLinediv = document.createElement("div");
    rightVerticalLinediv.id = "rightVerticalLinediv";
    rightVerticalLinediv.className = "port4linecontainertr";
    rightVerticalLinediv.style.position = "absolute";
    rightVerticalLinediv.style.left = "158px";
    rightVerticalLineTD.appendChild(rightVerticalLinediv);
    centerTR.appendChild(rightVerticalLineTD);
	
    /**
     *     
     */
    var leftLineTD = document.createElement("td");
    var leftLineTdiv = document.createElement("div");
    leftLineTdiv.id = "leftLineTdiv";
    leftLineTdiv.className = "port4linecontainertr";
    leftLineTdiv.style.position = "absolute";
    leftLineTdiv.style.left = "105px";
    leftLineTD.appendChild(leftLineTdiv);
    centerTR.appendChild(leftLineTD);
    /**
     *     
     */
    var rightLineTD = document.createElement("td");
    
    var rightLineTdiv = document.createElement("div");
    rightLineTdiv.id = "rightLineTdiv";
    rightLineTdiv.className = "port4linecontainertr";
    rightLineTdiv.style.left = "105px";

    rightLineTD.appendChild(rightLineTdiv);
    centerTR.appendChild(rightLineTD);
    
    var centerDownTR = document.createElement("tr");
    centerDownTR.className = "porttypetr";
    centerDownTR.style.verticalAlign = "middle";
    centerDownTR.align = "center";
    var protTopoTRList=[];
    protTopoTRList.push(upTR);
    protTopoTRList.push(centerTR);
    protTopoTRList.push(downTR);
	return protTopoTRList;
}

/**
 *     checkbox     
 * @param portlist
 * @return
 */
function refreshPortCheckBoxTR(/* Array */portlist)
{

    /**
     * 1 portFoShowName[portFOGE1] = "GE1";
     */
    if (portlist.length >= portFOGE1 && portlist[portFOGE1 - 1] != null) 
    {
        if (portlist[portFOGE1 - 1].isUsed) 
        {
            $("ge1port").checked = true;
        }
        else 
        {
            $("ge1port").checked = false;
        }
    }
    /**
     * 2 portFoShowName[portFOGE2] = "GE2";
     */
    if (portlist.length >= portFOGE2 && portlist[portFOGE2 - 1] != null) 
    {
        if (portlist[portFOGE2 - 1].isUsed) 
        {
            $("ge2port").checked = true;
        }
        else 
        {
            $("ge2port").checked = false;
        }
    }
    /**
     * 3 portFoShowName[portFOGE3] = "GE3";
     */
    if (portlist.length >= portFOGE3 && portlist[portFOGE3 - 1] != null) 
    {
        if (portlist[portFOGE3 - 1].isUsed) 
        {
            $("ge3port").checked = true;
        }
        else 
        {
            $("ge3port").checked = false;
        }
    }
    /**
     * 4 portFoShowName[portFOIFETH] = "IF(ETH)";
     */
    if (portlist.length >= portFOIFETH && portlist[portFOIFETH - 1] != null) 
    {
        if (portlist[portFOIFETH - 1].isUsed) 
        {
            $("ifport").checked = true;
        }
        else 
        {
            $("ifport").checked = false;
        }
    }
}

function selectAllPortCheckBox(flag)
{
    if ($("ge1port") != null) 
    {
        $("ge1port").checked = flag;
    }
    if ($("ge2port") != null) 
    {
        $("ge2port").checked = flag;
    }
    if ($("ge3port") != null) 
    {
        $("ge3port").checked = flag;
    }
    if ($("ifport") != null) 
    {
        $("ifport").checked = flag;
    }
}
function addPortUpTopTR(leftPort,rightPort,lineID)
{
	var tr = document.createElement("tr");
	tr.className = "porttypetr";
	tr.style.verticalAlign = "top";
	
	var td = document.createElement("td");
	td.align = "center";
	var portdiv = document.createElement("div");
	portdiv.id = "port-"+leftPort.portid+"div";
	portdiv.setAttribute("portstatus",leftPort.portstatus);
	portdiv.className = "portsquare";
	if(leftPort.portstatus == "0")
	{
		portdiv.style.backgroundColor = "red";
	}
	td.appendChild(portdiv);
	
	var portspan = document.createElement("span");
	portspan.id = "port-"+leftPort.portid+"span";
	portspan.className = "porttitlespan";
	portspan.innerHTML = convertSpanShow(createPortNameWithVLAN(portFoShowName[leftPort.portid],leftPort.tagID));//portFoShowName[leftPort.portid];
	td.appendChild(portspan);
	td.style.width = "85px";

	tr.appendChild(td);
	
	td = document.createElement("td");
	var hr = document.createElement("hr");
	hr.id = lineID;//"centerLine";
	hr.setAttribute("port",leftPort.portid + "-" + rightPort.portid);
	if(isIE)
	{
		hr.className = "portlineie";
	}
	else
	{
		hr.className = "portline";
	}
	if(leftPort.portstatus == "0" || rightPort.portstatus == "0")
	{
		hr.style.borderStyle="dashed";
	}
	hr.size = "1";
	td.style.width = "100px";
	td.appendChild(hr);
	tr.appendChild(td);
	
	td = document.createElement("td");
	td.align = "center";
	var portdiv = document.createElement("div");
	portdiv.id = "port-"+rightPort.portid+"div";
	portdiv.setAttribute("portstatus",rightPort.portstatus);
	portdiv.className = "portsquare";
	if(rightPort.portstatus == "0")
	{
		portdiv.style.backgroundColor = "red";
	}
	td.appendChild(portdiv);
	var portspan = document.createElement("span");
	portspan.id = "port-"+rightPort.portid+"span";
	portspan.className = "porttitlespan";
	portspan.innerHTML = convertSpanShow(createPortNameWithVLAN(portFoShowName[rightPort.portid],rightPort.tagID));//portFoShowName[rightPort.portid];
	td.appendChild(portspan);
	td.style.width = "85px";
	tr.appendChild(td);
	return tr;
}

function convertSpanShow(strContent)
{
	var strTemp = "";
	if (!isIE) 
	{
		while (strContent.length > 8) 
		{
			strTemp += strContent.substr(0, 8) + " ";
			strContent = strContent.substr(8, strContent.length);
		}
	}
	strTemp += strContent;
	return strTemp;
}
