
var portst;


var portFOIFETH = 1;
var portFOGE1 = 2;
var portFOGE2 = 3;
/**
 * TRANSV1R8C00-4383
 * FO380  4   
 */
var portFOGE3 = 4;
var portFoShowName = new Object();
portFoShowName[portFOIFETH] = "IF(ETH)";//"IF(ETH)";
portFoShowName[portFOGE1] = "GE1";//"GE1";
portFoShowName[portFOGE2] = "GE2";//"GE2";
portFoShowName[portFOGE3] = "GE3";//"GE3"

var portFoName = new Object();
portFoName[portFOIFETH] = "IF(ETH)";//"IF(ETH)";
portFoName[portFOGE1] = "GE1";//"GE1";
portFoName[portFOGE2] = "GE2";//"GE2";
portFoName[portFOGE2] = "GE3";//"GE3";

var ENCAPTYPE_NULL = 0;
var ENCAPTYPE_8021Q = 1;
var ENCAPTYPE_QINQ = 2;
var encapType = [];
encapType[ENCAPTYPE_NULL] =	"Null";
encapType[ENCAPTYPE_8021Q] = "802.1Q";
encapType[ENCAPTYPE_QINQ] =	"QINQ";

var enableFlag = [];
enableFlag[0] = RESOURCE["disabled"];
enableFlag[1] = RESOURCE["enabled"];

var workMode = [];
workMode[0] = RESOURCE["autonegotiation"];
workMode[1] = RESOURCE["HalfDuplex10M"];
workMode[2] = RESOURCE["FullDuplex10M"];
workMode[3] = RESOURCE["HalfDuplex100M"];
workMode[4] = RESOURCE["FullDuplex100M"];
workMode[5] = RESOURCE["HalfDuplex1000M"];
workMode[6] = RESOURCE["FullDuplex1000M"];
workMode[7] = RESOURCE["FullDuplexLAN10G"];
workMode[8] = RESOURCE["FullDuplexWAN10G"];
workMode[255] = RESOURCE["negotiating"];

var TAGFLAG_ACCESS = 0;
var TAGFLAG_TAGAWARE = 1;
var TAGFLAG_HYBRID = 2;
var TAGFLAG_NOTAGAWARE = 3;
var INVALID_TAG = 255;
var tagFlag = [];
tagFlag[0] = "Access";
tagFlag[1] = "Tag Aware";
tagFlag[2] = "Hybrid";
tagFlag[3] = "No Tag Aware";

var MIN_VLANID = 1;
var INVALID_VLANID = 65535;
var isPortAttrModify = false;

var INVALID_VLANPRI = 255
var MIN_VLANPRI = 0;
/**
 * UNI      
 */
var usableBoardArr = [];

var UNI_PORTYPE = 1;
/**
 * vlanid      
 */
var ALERT_VLAN_NUM = 500; 
/**
 *          
 */
function initPortAttrTable()
{
	portst = new SortTable();
    portst.head.setAttribute("id", "htmlTable_STHead_portattr");
    portst.body.setAttribute("id", "htmlTable_STBody_portattr");
    portst.setImage("../../../../../../images/");
    portst.isUsedForSelectList = true;
    createTableHead(portst, window.tableconf[1]);
    portst.setBodyHeight("80px");
    portst.setOnCellEditHandler(portCellEditHandler);
    $("porttablecontainer").appendChild(portst.getTable());
}

/**
 *                           
 * 
 * @param param
 *                       
 */
function portCellEditHandler(param)
{
	var rowindex = param.rowindex;
	if(param.stage == TABLE_CONSTANT.AFTEREDIT)
	{
		$("applybtn").disabled = !btnRightArr.applybtn.right;
		if(param.colid == "encapType")
		{
			encapeTypeEditHandler(rowindex);
		}
		if(param.colid == "tag")
		{
		}
		
	}
}

/**
 *            ,              
 * @param rowindex
 */
function encapeTypeEditHandler(/*string*/rowindex)
{
	var encaptype = portst.getCellStoreValue(rowindex,"encapType","encapType");
	if(encaptype == ENCAPTYPE_NULL)
	{
		portst.getCellShow(rowindex,"tag").setValue("-");
	}
	if(encaptype == ENCAPTYPE_NULL || encaptype == ENCAPTYPE_QINQ)
	{
		portst.setCellIsEdit(portst.getCell(rowindex,"tag"),0);
		portst.setCellIsEdit(portst.getCell(rowindex,"vlanID"),0);
		portst.setCellIsEdit(portst.getCell(rowindex,"vlanPri"),0);
		portst.getCellShow(rowindex,"vlanID").setValue("-");
		portst.getCellShow(rowindex,"vlanPri").setValue("-");
	}
	else
	{
		portst.setCellIsEdit(portst.getCell(rowindex,"tag"),1);
		portst.setCellIsEdit(portst.getCell(rowindex,"vlanID"),1);
		portst.setCellIsEdit(portst.getCell(rowindex,"vlanPri"),1);
	}
	if(encaptype == ENCAPTYPE_8021Q || encaptype == ENCAPTYPE_QINQ)
	{
		var tag = portst.getCellStoreValue(rowindex,"tag","tag");
		var vlanid = portst.getCellStoreValue(rowindex,"vlanID","vlanID");
		var vlanpri = portst.getCellStoreValue(rowindex,"vlanPri","vlanPri");
		if(typeof(tag) == "undefined" || tag == INVALID_TAG)
		{
			tag = TAGFLAG_HYBRID;
			portst.setCellValue(portst.getCell(rowindex,"tag"),"tag",tag);
		}
		portst.getCellShow(rowindex,"tag").setValue(tagFlag[tag]);
	}
	if(encaptype == ENCAPTYPE_8021Q)
	{
		if(typeof(vlanid) == "undefined" || vlanid == INVALID_VLANID || vlanid == "-1")
		{
			vlanid = MIN_VLANID
			portst.setCellValue(portst.getCell(rowindex,"vlanID"),"vlanID",vlanid);
		}
		portst.getCellShow(rowindex,"vlanID").setValue(vlanid);
		
		if(typeof(vlanpri) == "undefined" || vlanpri == INVALID_VLANPRI || vlanpri == "-1")
		{
			vlanpri = MIN_VLANPRI
			portst.setCellValue(portst.getCell(rowindex,"vlanPri"),"vlanPri",vlanpri);
		}
		portst.getCellShow(rowindex,"vlanPri").setValue(vlanpri);
	}
}
/**
 * TAG       ,             
 * 
 * @param rowindex
 */
function tagEditHandler(/* string */rowindex)
{
	var tag = portst.getCellStoreValue(rowindex,"tag","tag");
	if(tag == TAGFLAG_TAGAWARE)
	{
		portst.setCellIsEdit(portst.getCell(rowindex,"vlanID"),0);
		portst.getCellShow(rowindex,"vlanID").setValue("-");
	}
	else
	{
		portst.setCellIsEdit(portst.getCell(rowindex,"vlanID"),1);
		var vlanid = portst.getCellStoreValue(rowindex,"vlanID","vlanID");
		if(typeof(vlanid) == "undefined" || vlanid == INVALID_VLANID)
		{
			vlanid = MIN_VLANID
			portst.setCellValue(portst.getCell(rowindex,"vlanID"),"vlanID",vlanid);
		}
		portst.getCellShow(rowindex,"vlanID").setValue(vlanid);
	}
}
/**
 *          XML
 * 
 * @param direction
 */
function createGetPortAttriXml()
{	
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");  
	var portObject = getPortObjectChecked();
	
	if(portObject != null&&portObject.length != 0)
	{
		for(var i=0;i<portObject.length;i++)
		{
			var row = new tagElement("row-params");    
			var param = new tagElement("param","neid",neid);    
			row.appendChild(param);
			param = new tagElement("param","slotid",portObject[i].getAttribute("slotid"));
		    row.appendChild(param);
		    
		    param = new tagElement("param","port",portObject[i].getAttribute("portid"));
		    row.appendChild(param);
		    bussiness.appendChild(row);
		}
	}
	else
	{
		return null;
	}
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

/**
 *       ,             
 */
function queryPortAttribute()
{
	var rows = st.getSelectedRows();

	var xmlData = createGetPortAttriXml();
	if(xmlData!=null)
	{
		LoadingProcess.showWaitStatus("../../../../../../images");
	  	var urlstr = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_GET_ETHPORTATTRIB+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+nmuser;
	  	loadXMLdoc(urlstr, "POST", true, callbackGetPortAttri, null, "inputdata="+xmlData);
	}
	/**
	 *                    
	 */
	else
	{   	
		portst.clearTableData();
	}
}

/**
 *            ,      ,                             ,            ,         
 * 
 * @param doc
 */
function callbackGetPortAttri(/* XMLDOM */doc)
{
	portst.clearTableData();
	var data = EncapsulateData(doc);
	if(0 == data.getSErrorCode() || 1 == data.getSErrorCode())
	{
		processData(data);
		
		createTableBody(portst, window.tableconf[1], data, RESOURCE);

		addPortCellEvent();
	}
	else
	{
		$("applybtn").disabled = true;
	}
	LoadingProcess.removeWaitStatus();
}

/**
 *              
 * 
 * @param data        
 * @return  
 */
function processData(data)
{
	for(var i = 0, len = data.getDataRowLength(); i < len; i++)
	{
		renamePortAttribute(data,i,"port","portid");
		renamePortAttribute(data,i,"ATTR_ETHOVERPTN_MAC_ENABLE","portEnable");
		renamePortAttribute(data,i,"ATTR_ETHOVERPTN_MAC_WORKMODE","workMode");
		renamePortAttribute(data,i,"ATTR_ETHOVERPTN_MAC_ENCAP_TYPE","encapType");
		renamePortAttribute(data,i,"ATTR_ETHOVERPTN_MAC_TAG","tag");
		renamePortName(data, i);
		if(null != data.getDataRowParam(i, "tag"))
		{
			if(null != data.getDataRowParam(i, "encapType"))
			{
				var encapType = data.getDataRowParam(i, "encapType");//      
				if(encapType == 0)// null  
				{
					data.rows[i]["tag"] = "-";
				}
			}
		}

	}
}
/**
 *                        
 * @param slotid
 * @param portid
 * @return
 */
function getCachePort(slotid,portid)
{
	for(var pos=0,len=usableBoardArr.length;pos<len;pos++)
	{
		if(portid == usableBoardArr[pos].portid&&slotid == usableBoardArr[pos].slotid)
		{
			return usableBoardArr[pos];
		}
	}
	return false;
}

function getCachePortByuniid(vuniID)
{
	for(var pos=0,len=usableBoardArr.length;pos<len;pos++)
	{
		if(vuniID == usableBoardArr[pos].vuniID)
		{
			return usableBoardArr[pos];
		}
	}
	return false;
}
/**
 *         
 * 
 * @param data
 * @param rowindex
 * @param srcname
 * @param snkname
 */
function renamePortAttribute(/* DateInterface */data,/* string */rowindex,/* string */srcname,/* string */snkname)
{
	if(null != data.getDataRowParam(rowindex, srcname))
	{
		data.rows[rowindex][snkname] = data.rows[rowindex][srcname];
	}
}

/**
 *        
 * @param data
 * @param rowindex
 */
function renamePortName(/* DateInterface */data,/* string */rowindex)
{
	var name = "";
	var slotid = data.getDataRowParam(rowindex, "slotid");
	var boardname = data.getDataRowParam(rowindex, "boardname");
	var portid = data.getDataRowParam(rowindex, "portid");
	var portname = data.getDataRowParam(rowindex, "portname");
	if(slotid && boardname && portid)
	{
		if(1 == portid)
		{
			name = /*"IF(ETH)[" + */slotid + "-" + boardname
			+ "-" + portname/* + "]"*/;
		}
		else
		{
			name = /*"GE" + (portid - 1) + "[" + */slotid + "-" + boardname
			+ "-" + portname/* + "]"*/;
		}
		portFoName[portid] = name;
	}	
}

/**
 *                      
 */
function addPortCellEvent()
{
	var cell = null;
	var tempValue = null;
	
	for(var i = 0,len = portst.getDataRowLength();i<len;i++)
	{
        var tmpcell = portst.getCell(i, "tagID");
        tmpcell.element.editElement.element["onkeypress"] = function()
        {
            return checkData(this, event, 1, 4094);
        }
		
		refreshPortCellEditOrNot(i,"portEnable");
		refreshPortCellEditOrNot(i,"workMode");
		tempValue = portst.getCellStoreValue(i,"encapType","encapType");
		if(tempValue == ENCAPTYPE_NULL || tempValue == ENCAPTYPE_QINQ)
		{
			portst.setCellIsEdit(portst.getCell(i,"tag"),0);
			portst.setCellIsEdit(portst.getCell(i,"vlanID"),0);
			if(tempValue == ENCAPTYPE_NULL)
			{
				portst.getCellShow(i,"tag").setValue("-");
				portst.getCellShow(i,"vlanID").setValue("-");
			}
		}
		/**
		 *      DTS2012062200506
		 *     q00119080
		 *        Default VLANID -1        "/" 
		 */
		var defaultVlanID =  portst.getCellStoreValue(i, "vlanID", "vlanID");
		if(defaultVlanID == -1)
		{
			portst.getCellShow(i,"vlanID").setValue("/");

		}
		var slotid = portst.getCellStoreValue(i,"slotid","slotid");
		var portid = portst.getCellStoreValue(i,"portid","portid");
		/**
		 *            tagID        
		 */

		var cachePort = getCachePort(slotid,portid);

		/**
		 *      DTS2012051402278
		 * tag   C-Tag   ,   BPDU LACP   VALN    
		 */
		if($("tagType").value == C_Awared)
		{
			if(TRANSBPDU == $("slProtocol").value || TRANSLACP == $("slProtocol").value)
			{
				portst.setCellIsEdit(portst.getCell(i, "tagID"), 0);
				portst.getCellShow(i,"tagID").setValue("");
				portst.setCellValue(portst.getCell(i,"tagID"), "");
			}
			else
			{
				if(cachePort.isUsed)
				{
					if(cachePort.tagID!=undefined||cachePort.tagID!=null)
					{
						portst.getCellShow(i,"tagID").setValue(cachePort.tagID);
					}
				}
				portst.setCellIsEdit(portst.getCell(i,"tagID"),1);
			}
		}
		else if($("tagType").value == Tag_Transparent)
		{
			portst.setCellIsEdit(portst.getCell(i,"tagID"),0);
			portst.getCellShow(i,"tagID").setValue("");
		}

		if( st.getSelectedRows().length > 0 )
		{
			var selectedRowid = st.getSelectedRows()[0];
			var tagTypeCellValue = st.getCellStoreValue(selectedRowid, "tagtype", "tagtype");
			var protocolTypeValue = st.getCellStoreValue(selectedRowid, "bpdu", "bpdu");
			if(tagTypeCellValue == C_Awared )
			{
				if(N_TRANSBPDU == protocolTypeValue)
				{
					if(cachePort.isUsed)
					{
						if(cachePort.tagID!=undefined||cachePort.tagID!=null)
						{
							portst.getCellShow(i,"tagID").setValue(cachePort.tagID);
						}
					}
					portst.setCellIsEdit(portst.getCell(i,"tagID"),1);
				}
				else
				{
					portst.setCellIsEdit(portst.getCell(i,"tagID"),0);
					portst.getCellShow(i,"tagID").setValue("");
				}				
			}
			else
			{
				portst.setCellIsEdit(portst.getCell(i,"tagID"),0);
				portst.getCellShow(i,"tagID").setValue("");
			}
		}
	}
}
/**
 *   col id="tagID" name="VLAN ID( 1,3-5)"      
 * @param flag
 * @return
 */
function setPortTagIDEnable(flag)
{
	if(!flag)
	{
		for(var i = 0,len = portst.getDataRowLength();i<len;i++)
		{
			portst.getCellShow(i,"tagID").setValue("");
			portst.setCellIsEdit(portst.getCell(i,"tagID"),0);
		}
	}
	else
	{
		for(var i = 0,len = portst.getDataRowLength();i<len;i++)
		{
			portst.setCellIsEdit(portst.getCell(i,"tagID"),1);
		}
	}
}
/**
 *                   DOM  ,        ,             
 */
function getPortObjectChecked()
{

	var selectPortList = [];
	 if($("ge1port")!=null&&($("ge1port").checked==true))
	 {
		 selectPortList.push($("ge1port"));
	 }
	 if($("ge2port")!=null&&($("ge2port").checked==true))
	 {
		 selectPortList.push($("ge2port"));
	 }
	 if($("ifport")!=null&&($("ifport").checked==true))
	 {
		 selectPortList.push($("ifport"));
	 }

	return selectPortList;
}

/**
 *                        undefined
 * 
 * @param rowindex
 * @param colid
 */
function refreshPortCellEditOrNot(/* string */rowindex,/* string */colid)
{
	var tempValue = portst.getCellStoreValue(rowindex, colid,colid);
	if(typeof(tempValue) == "undefined")
	{
		portst.setCellIsEdit(portst.getCell(rowindex,colid),0);
		portst.getCellShow(rowindex,colid).setValue("-");
	}
}


/**
 * create get ports xml
 */
function createGetPortsXML()
{
	var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","ethType");
    param.setAttribute("value","1");// (1:e-line 2:e-lan 3:e-tree)
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","availableType");
    param.setAttribute("value","portResType");
    row.appendChild(param);
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}
/**
 *          ,  UCD        
 */
function getPortRes(brefresh)
{
  var xml = createGetPortsXML();
  var url = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_QUERY_IPPTN_GET_FO_SERVICERES + "&nmUser=" + nmuser;
  loadXMLdoc(url, "POST", brefresh, portResCallBack, brefresh, "inputdata=" + xml);
}

/**
 *           
 * 
 * @param doc
 */
function portResCallBack(/* XMLDOM */doc,param)
{
	var data = EncapsulateData(doc);
	if (OPERATION_SUCCESS == data.getError().getGlobleECode()) 
	{
	    var portlist = initBoardPortData(data);
	    if(param == true)
	    {
			/**
			 *        
			 */
			clearPortResTable();
			/**
			 *          
			 */
			createBoardSelect(portlist);
	    }
	    else
	    {
	    	/**
	    	 *     checkbox TR
	    	 */
	    	createPortCheckBoxTR(portlist);
	    	/**
	    	 *        
	    	 */
	    	createBoardSelect(portlist);
	    }
	}
}

/**
 *          
 */
function TEUsableBoard()
{    
	this.slotid = null;
	this.boardType = null;
	this.boardName = null;
	this.portid = null;
	this.portname = null;
	this.portstatus = null;
}
/**
 * init board select
 */
function initBoardPortData(/* Object */data)
{
	/**
	 *     
	 */
	usableBoardArr = [];
	curselportlist = [];
	for(var i=0,len = data.getDataRowLength();i<len;i++)
	{
		var usableBd = new TEUsableBoard();
		usableBd.slotid = data.getDataRowParam(i ,"slotid" );
		usableBd.boardType = data.getDataRowParam(i , "boardType");
		usableBd.boardName = data.getDataRowParam(i, "boardName");
		usableBd.portid = data.getDataRowParam(i, "portid");
		usableBd.portname = data.getDataRowParam(i, "portname");
		usableBd.portstatus = data.getDataRowParam(i, "portstatus");
		usableBd.isUsed = false;
		usableBoardArr.push(usableBd);
		curselportlist.push(new portAttr(usableBd.vuniID,usableBd.portid,
				createPortNameWithVLAN(portFoShowName[usableBd.portid],usableBd.tagID),UNI_PORTYPE,usableBd.tagID,
        		"",usableBd.boardName,usableBd.slotid));
	}
	return usableBoardArr;
}

function getPortObject(portlist,portid)
{
	var port = null;
	for(var i = 0,len = portlist.length;i < len;i++)
	{
		port = portlist[i];
		if(port.portid == portid)
		{
			return port;
		}
	}
	return null;
}

/**
 * create board tree      3        
 */
function createBoardSelect(/* Array */portlist)
{
	var slotid = "1";
	
	var tbody = $("portResTable").childNodes[0];

	var trList = createPortTypeTR(portlist);	
	for(var pos=0,len = trList.length;pos<len;pos++)
	{
		tbody.appendChild(trList[pos]);
	}
	refreshLineBySplit();
}

/**
 *              
 * @return
 */
function refreshLineBySplit()
{
	if(document.getElementById("leftLineTdiv")!=null||document.getElementById("leftLineTdiv")!=undefined)
	{
		if(usableBoardArr[portFOIFETH-1].portstatus == "0" ||usableBoardArr[portFOGE1-1].portstatus == "0" )
		{
			drawDotBiasLine(document.getElementById("leftLineTdiv"),true);
			document.getElementById("leftLineTdiv").style.display = "";
		}
		else
		{
			drawBiasLine(document.getElementById("leftLineTdiv"),true);
			document.getElementById("leftLineTdiv").style.display = "";
		}
	}

	if(document.getElementById("rightLineTdiv")!=null||document.getElementById("rightLineTdiv")!=undefined)
	{
		if(usableBoardArr[portFOIFETH-1].portstatus == "0" ||usableBoardArr[portFOGE2-1].portstatus == "0" )
		{
			drawDotBiasLine(document.getElementById("rightLineTdiv"),false);
			document.getElementById("rightLineTdiv").style.display = "";
		}
		else
		{
			drawBiasLine(document.getElementById("rightLineTdiv"),false);
			document.getElementById("rightLineTdiv").style.display = "";
		}
	}

	if(document.getElementById("centerLine")!=null||document.getElementById("centerLine")!=undefined)
	{
		if(getPortObjectChecked().length == 2)
		{
			if((usableBoardArr[getPortObjectChecked()[0].getAttribute("portid") - 1].portstatus == "0") || (usableBoardArr[getPortObjectChecked()[1].getAttribute("portid") - 1].portstatus == "0"))
			{
				document.getElementById("centerLine").style.borderStyle="dashed";
				document.getElementById("centerLine").style.display = "";				
			}
			else
			{
				document.getElementById("centerLine").style.borderStyle="";
				document.getElementById("centerLine").style.display = "";
			}
		}
		else
		{
			if(usableBoardArr[portFOGE1-1].portstatus == "0" ||usableBoardArr[portFOGE2-1].portstatus == "0" )
			{
				document.getElementById("centerLine").style.borderStyle="dashed";
				document.getElementById("centerLine").style.display = "";
			}
			else
			{
				document.getElementById("centerLine").style.borderStyle="";
				document.getElementById("centerLine").style.display = "";
			}
		}
	}

	/**
	 *        
	 */
	for(var i=0;i<splitPortList.length;i++)
	{
		var splitPorts=splitPortList[i].portdata;
		
		/**
		 *       2            
		 */
		if(splitPorts.length == 2)
		{
			var splitPort1 = getCachePortByuniid(splitPorts[0]);
			var splitPort2 = getCachePortByuniid(splitPorts[1]);
			var splitPortID1;
			var splitPortID2;
			if(splitPort1!=false&&splitPort2!=false)
			{
				splitPortID1=splitPort1.portid;
				splitPortID2=splitPort2.portid;
			}
			else
			{
				return;
			}

			/**
			 *               3                 
			 */
			if(getUsedPortNum() == 3)
			{
				/**
				 *  var portFOIFETH = 1;
					var portFOGE1 = 2;
					var portFOGE2 = 3;
				 */
				if((splitPortID1 == portFOIFETH && splitPortID2 == portFOGE1)||(splitPortID2 == portFOIFETH && splitPortID1 == portFOGE1))
				{
					if(document.getElementById("leftLineTdiv")!=null || document.getElementById("leftLineTdiv")!= undefined)
					{
						document.getElementById("leftLineTdiv").style.display = "none";
					}
				}
				else if((splitPortID1 == portFOIFETH && splitPortID2 == portFOGE2)||(splitPortID2 == portFOIFETH && splitPortID1 == portFOGE2))
				{
					if(document.getElementById("rightLineTdiv")!=null || document.getElementById("rightLineTdiv")!= undefined)
					{	
						document.getElementById("rightLineTdiv").style.display = "none";
					}
				}
				else
				{
					if(document.getElementById("centerLine")!=null || document.getElementById("centerLine")!= undefined)
					{
						document.getElementById("centerLine").style.display = "none";
					}
				}
			}
				/**
				 *          2          
				 */
			else if(getUsedPortNum() == 2)
			{
					if(document.getElementById("centerLine")!=null || document.getElementById("centerLine")!= undefined)
					{
						document.getElementById("centerLine").style.display = "none";
					}
			}			
		}
		else if(splitPorts.length == 3)
		{
			if(document.getElementById("leftLineTdiv")!=null || document.getElementById("leftLineTdiv")!= undefined)
			{
				document.getElementById("leftLineTdiv").style.display = "none";
			}
			if(document.getElementById("rightLineTdiv")!=null || document.getElementById("rightLineTdiv")!= undefined)
			{			
				document.getElementById("rightLineTdiv").style.display = "none";
			}
			if(document.getElementById("centerLine")!=null || document.getElementById("centerLine")!= undefined)
			{
				document.getElementById("centerLine").style.display = "none";
			}
		}
		/**
		 *              
		 */
		else
		{
			if(document.getElementById("leftLineTdiv")!=null || document.getElementById("leftLineTdiv")!= undefined)
			{
				document.getElementById("leftLineTdiv").style.display = "";
			}
			if(document.getElementById("rightLineTdiv")!=null || document.getElementById("rightLineTdiv")!= undefined)
			{	
				document.getElementById("rightLineTdiv").style.display = "";
			}
			if(document.getElementById("centerLine")!=null || document.getElementById("centerLine")!= undefined)
			{
				document.getElementById("centerLine").style.display = "";
			}
		}
		
	}
	/**
	 *                   
	 */
	if(splitPortList.length == 0)
	{
		if(document.getElementById("leftLineTdiv")!=null || document.getElementById("leftLineTdiv")!= undefined)
		{
			document.getElementById("leftLineTdiv").style.display = "";
		}
		if(document.getElementById("rightLineTdiv")!=null || document.getElementById("rightLineTdiv")!= undefined)
		{	
			document.getElementById("rightLineTdiv").style.display = "";
		}
		if(document.getElementById("centerLine")!=null || document.getElementById("centerLine")!= undefined)
		{
			document.getElementById("centerLine").style.display = "";
		}
	}
	
}
function repaintPortTR()
{
	clearPortResTable();
	var checkBoxPorts = [];
	var portinfo;
	if($("ifport").checked)
	{
		portinfo = usableBoardArr[portFOIFETH-1];
		checkBoxPorts.push(portinfo);
	}
	if($("ge1port").checked)
	{
		portinfo = usableBoardArr[portFOGE1-1];
		checkBoxPorts.push(portinfo);
	}
	if($("ge2port").checked)
	{
		portinfo = usableBoardArr[portFOGE2-1];
		checkBoxPorts.push(portinfo);
	}
	createBoardSelect(checkBoxPorts);
}
/**
 *       checkbox
 */
function createPortCheckBoxTR(/* Array */portlist)
{


	var portCheckBoxTD = $("portCheckTd");
    elem = document.createElement("span");
    elem.innerHTML =  RESOURCE["portDes"];
    portCheckBoxTD.appendChild(elem);
    
    /**
     * 1 portFoShowName[portFOGE1] = "GE1";     
     */
	if(portlist.length >= portFOGE1 && portlist[portFOGE1-1] != null)
	{
	    var elem = document.createElement("input");
	    elem.type = "checkbox";
	    elem.id = "ge1port";
	    
	    elem.setAttribute("slotid",portlist[portFOGE1-1].slotid);
	    elem.setAttribute("portid",portlist[portFOGE1-1].portid);   

	    elem.onclick = function()
		{    
	    	repaintPortTR();
	    	$("applybtn").disabled = !btnRightArr.applybtn.right;
			queryPortAttribute();
			
		}    
	    
	    portCheckBoxTD.appendChild(elem);    
	    if(portlist[portFOGE1-1].isUsed)
	    {
	    	elem.checked = true;
	    }
	    elem = document.createElement("span");
	    elem.innerHTML = createPortNameWithVLAN(portFoShowName[portFOGE1],portlist[portFOGE1-1].tagID);
	    portCheckBoxTD.appendChild(elem); 
	}
    /**
     * 2 portFoShowName[portFOGE2] = "GE2"; 
     */
    if(portlist.length >= portFOGE2 && portlist[portFOGE2-1] != null)
    {
    	var elem = document.createElement("input");
	    elem.type = "checkbox";
	    elem.id = "ge2port";
	    
	    elem.setAttribute("slotid",portlist[portFOGE2-1].slotid);
	    elem.setAttribute("portid",portlist[portFOGE2-1].portid);	    
	    
	    elem.onclick = function()
		{
	    	repaintPortTR();
	    	$("applybtn").disabled = !btnRightArr.applybtn.right;
			queryPortAttribute();
		}    
	    portCheckBoxTD.appendChild(elem);
	    if(portlist[portFOGE2-1].isUsed)
	    {
	    	elem.checked = true;
	    }	    
	    elem = document.createElement("span");
	    elem.innerHTML = createPortNameWithVLAN(portFoShowName[portFOGE2],portlist[portFOGE2-1].tagID);
	    portCheckBoxTD.appendChild(elem);    
    }
    /**
     * 2 portFoShowName[portFOIFETH] = "IF(ETH)"; 
     */
    if(portlist.length >= portFOIFETH && portlist[portFOIFETH-1] != null)
    {
	    var elem = document.createElement("input");
	    elem.type = "checkbox";
	    elem.id = "ifport";
	    
	    elem.setAttribute("slotid",portlist[portFOIFETH-1].slotid);
	    elem.setAttribute("portid",portlist[portFOIFETH-1].portid);	    
	    
	    elem.onclick = function()
		{
	    	repaintPortTR();
	    	$("applybtn").disabled = !btnRightArr.applybtn.right;
			queryPortAttribute();
		}    
	    portCheckBoxTD.appendChild(elem);
	    if(portlist[portFOIFETH-1].isUsed)
	    {
	    	elem.checked = true;
	    }		    
	    elem = document.createElement("span");
	    elem.innerHTML = createPortNameWithVLAN(portFoShowName[portFOIFETH],portlist[portFOIFETH-1].tagID);
	    portCheckBoxTD.appendChild(elem);
    }
}

/**
 *             
 */
function createPortTypeTR(/* Array */portlist)
{
	
	var protTopoTRList = [];
	/**
	 *           
	 */
	if(portlist.length == 0)
	{
		var tr = document.createElement("tr");
		tr.className = "porttypetr";
		tr.style.verticalAlign = "top";	
		protTopoTRList.push(tr)
	}	
	/**
	 *      1      
	 */
	else if(portlist.length == 1)
	{
		var tr = document.createElement("tr");
		tr.className = "porttypetr";
		tr.style.verticalAlign = "middle";
		tr.align = "center";
		
		var td = document.createElement("td");
		var portdiv = document.createElement("div");
		portdiv.id = "port-"+portlist[0].portid+"div";
		portdiv.setAttribute("portstatus",portlist[0].portstatus);
		portdiv.className = "portsquare";
		if(portlist[0].portstatus == "0")
		{
			portdiv.style.backgroundColor = "red";
		}
		td.appendChild(portdiv);
		
		var portspan = document.createElement("span");
		portspan.id = "port-"+portlist[0].portid+"span";
		portspan.innerHTML = createPortNameWithVLAN(portFoShowName[portlist[0].portid],portlist[0].tagID);//portFoShowName[portlist[0].portid];
		td.appendChild(portspan);
		
		var leftLineTD=document.createElement("td");		
		var leftLineTdiv = document.createElement("div");
		leftLineTD.appendChild(leftLineTdiv);
		tr.appendChild(leftLineTD);
		tr.appendChild(td);
		
		var upTR = document.createElement("tr");
		upTR.className = "porttypetr";
		upTR.style.verticalAlign = "middle";
		upTR.align = "center";
		leftLineTD=document.createElement("td");		
		leftLineTdiv = document.createElement("div");
		leftLineTD.appendChild(leftLineTdiv);
		upTR.appendChild(leftLineTD);
		upTR.appendChild(document.createElement("td"));	
		
		protTopoTRList.push(upTR);
		protTopoTRList.push(tr);
	}
	/**
	 *      2      
	 * 
	 * [leftPort] ---------------- [rightPort]
	 */
	else if(portlist.length == 2)
	{
		protTopoTRList.push(addPortUpTopTR(portlist[0],portlist[1],"centerLine"));
	}
	/**
	 *      3      
	 * 
	 * [leftPort-GE1] ------------ [rightPort-GE2] 
				-					 -
	       		 -					-
	       		  -				   -
	       		   -			  -
	       		    -			 -
	       		     -          -
	       		      -        -
	       		       -      -
	       		        -    -
	       		         -  -
	       		          --
	 * 				 [downPort-IF]
	 */
	else if(portlist.length == 3)
	{
		/**
		 *            
		 */
		var leftPort = portlist[portFOGE1-1];
		var rightPort = portlist[portFOGE2-1];
		var downPort = portlist[portFOIFETH-1];
		
		var upTR = addPortUpTopTR(leftPort,rightPort,"centerLine");	
		var centerTR = document.createElement("tr");
		centerTR.className = "porttypetr";
		centerTR.style.verticalAlign = "middle";
		centerTR.align = "center";		
		
		var downTR = document.createElement("tr");
		downTR.className = "porttypetr";
		downTR.style.verticalAlign = "top";
		downTR.align = "center";
		downTR.appendChild(document.createElement("td"));
		var td = document.createElement("td");
		td.align = "center";
		var portdiv = document.createElement("div");
		portdiv.id = "port-"+downPort.portid+"div";
		portdiv.setAttribute("portstatus",downPort.portstatus);

		portdiv.className = "portsquare";
		if(downPort.portstatus == "0")
		{
			portdiv.style.backgroundColor = "red";
		}
		td.appendChild(portdiv);
		
		var portspan = document.createElement("span");

		portspan.innerHTML = createPortNameWithVLAN(portFoShowName[downPort.portid],downPort.tagID);//portFoShowName[downPort.portid];
		td.appendChild(portspan);
		td.className = "portcontainertr";
		td.style.top = "320px";
		downTR.appendChild(td);

		
		/**
		 *     
		 */
		var leftLineTD=document.createElement("td");		
		var leftLineTdiv = document.createElement("div");
		leftLineTdiv.id = "leftLineTdiv";
		leftLineTdiv.className = "portlinecontainertr";
		leftLineTdiv.style.position = "absolute";
		leftLineTdiv.style.left = "45px";

		leftLineTD.appendChild(leftLineTdiv);
		centerTR.appendChild(leftLineTD);		
		/**
		 *     
		 */
		var rightLineTD=document.createElement("td");	
		
		var rightLineTdiv = document.createElement("div");
		rightLineTdiv.id = "rightLineTdiv";
		rightLineTdiv.className = "portlinecontainertr";
		rightLineTdiv.style.left = "125px";

		rightLineTD.appendChild(rightLineTdiv);	
		centerTR.appendChild(rightLineTD);

		protTopoTRList.push(upTR);
		protTopoTRList.push(centerTR);
		protTopoTRList.push(downTR);
		
	}
	else
	{
		alert("Get E-Lan port info error!");
		
	}
	return protTopoTRList;

}
function addPortUpTopTR(leftPort,rightPort,lineID)
{
	var tr = document.createElement("tr");
	tr.className = "porttypetr";
	tr.style.verticalAlign = "top";
	
	var td = document.createElement("td");
	td.align = "center";
	var portdiv = document.createElement("div");
	portdiv.id = "port-"+leftPort.portid+"div";
	portdiv.setAttribute("portstatus",leftPort.portstatus);
	portdiv.className = "portsquare";
	if(leftPort.portstatus == "0")
	{
		portdiv.style.backgroundColor = "red";
	}
	td.appendChild(portdiv);
	
	var portspan = document.createElement("span");
	portspan.id = "port-"+leftPort.portid+"span";
	portspan.innerHTML = createPortNameWithVLAN(portFoShowName[leftPort.portid],leftPort.tagID);//portFoShowName[leftPort.portid];
	td.appendChild(portspan);
	tr.appendChild(td);
	
	td = document.createElement("td");
	var hr = document.createElement("hr");
	hr.id = lineID;//"centerLine";
	hr.setAttribute("port",leftPort.portid + "-" + rightPort.portid);
	if(isIE)
	{
		hr.className = "portlineie";
	}
	else
	{
		hr.className = "portline";
	}
	if(leftPort.portstatus == "0" || rightPort.portstatus == "0")
	{
		hr.style.borderStyle="dashed";
	}
	hr.size = "1";
	td.style.width = 100;
	td.appendChild(hr);
	tr.appendChild(td);
	
	td = document.createElement("td");
	td.align = "center";
	var portdiv = document.createElement("div");
	portdiv.id = "port-"+rightPort.portid+"div";
	portdiv.setAttribute("portstatus",rightPort.portstatus);
	portdiv.className = "portsquare";
	if(rightPort.portstatus == "0")
	{
		portdiv.style.backgroundColor = "red";
	}
	td.appendChild(portdiv);
	var portspan = document.createElement("span");
	portspan.id = "port-"+rightPort.portid+"span";
	portspan.innerHTML = createPortNameWithVLAN(portFoShowName[rightPort.portid],rightPort.tagID);//portFoShowName[rightPort.portid];
	td.appendChild(portspan);

	tr.appendChild(td);
	return tr;
}
/**
 *          XML  ,                    
 */
function createSetPortAttriXml()
{
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");
	var row;
	var param;
	
	var length = portst.getDataRowLength(); 
	for(var i=0;i<length;i++)
	{
		if(!portst.getModify(i))
		{
			continue;
		}
		row = new tagElement("row-params");		
		appendSlotPortParam(row,i);
		var bOther = appendOtherParam(row,i);
		if(bOther)
		{
			business.appendChild(row);
		}
	}
	if(0 == business.childNodes.length)
	{
		return null;
	}
	root.getRoot().appendChild(business);
	return root.toString();
}

/**
 *           
 * 
 * @param row
 */
function appendSlotPortParam(/* tagElement */row,/* string */i)
{
	param = new tagElement("param","neid",neid);
	row.appendChild(param);
	param = new tagElement("param","slotid",portst.getCellStoreValue(i,"slotid","slotid"));
	row.appendChild(param);
	param = new tagElement("param","subslotid","255");
	row.appendChild(param);
	param = new tagElement("param","portid",portst.getCellStoreValue(i,"portid","portid"));
	row.appendChild(param);
	param = new tagElement("param","port",portst.getCellStoreValue(i,"portid","portid"));
	row.appendChild(param);
	return true;
}

/**
 *                
 * 
 * @param row
 */
function appendOtherParam(/* tagElement */row,/* string */i)
{
	var bResult = false;
	if(portst.getCellModify(i,"portEnable"))
	{
		param = new tagElement("param","portEnable",portst.getCellStoreValue(i,"portEnable","portEnable"));
		row.appendChild(param);
		bResult = true;
	}
	if(portst.getCellModify(i,"workMode"))
	{
		param = new tagElement("param","workMode",portst.getCellStoreValue(i,"workMode","workMode"));
		row.appendChild(param);
		bResult = true;
	}
	if(portst.getCellModify(i,"encapType") )
	{
		param = new tagElement("param","encapType",portst.getCellStoreValue(i,"encapType","encapType"));
		row.appendChild(param);
		bResult = true;
	}
	if(portst.getCellModify(i,"tag") || portst.getCellModify(i,"vlanID"))
	{
		param = new tagElement("param","tag",portst.getCellStoreValue(i,"tag","tag"));
		row.appendChild(param);
		
		if (portst.getCellShow(i,"vlanID").getValue() != "-")
		{
			var vlanId = portst.getCellStoreValue(i,"vlanID","vlanID");
			param = new tagElement("param","vlanID",vlanId);
			row.appendChild(param);
			
			param = new tagElement("param","vlanPri",portst.getCellStoreValue(i,"vlanPri","vlanPri"));
			row.appendChild(param);
		}
		bResult = true;
	}
	return bResult;
}

/**
 * 
 *       ,          
 * asyflg:            
 */
function doApplyPortAttr(/**boolean*/asyflg)
{
	var xmlData = createSetPortAttriXml();
	$("querybtn").disabled = true;
	$("deletebtn").disabled = true;
	$("applybtn").disabled = true;
	if(xmlData == null)
	{
		$("querybtn").disabled = false;
		if(st.getSelectedRows().length > 0)
		{
			$("deletebtn").disabled = false;
			return true;
		}
		else
		{
			createElan();
			return false;
		}
		
	}
	LoadingProcess.showWaitStatus("../../../../../../images");
	var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_SET_ETHPORTATTRIB + "&flag=1&nmUser=" + nmuser;
	loadXMLdoc(urlstr, "POST", asyflg, callbackSetPortAttri, null, "inputdata=" + xmlData);
	return !isPortAttrModify;
}
/**
 *        UNI XML
 * @param bussinessNode
 * @return
 */
function createModUniXMLForIntegrate(/*tagElement*/bussinessNode)
{
	var isAlertVlan=false;
	/**
	 *            
	 */
	if(portst.getDataRowLength()==0)
	{
		var rowParams = new tagElement("row-params");
		param = new tagElement("param","neid",neid);
        rowParams.appendChild(param);
        
    	var selectedRows = st.getSelectedRows();
    	var index=st.getCellStoreValue(selectedRows[0], "serviceIndex", "serviceIndex");
        param = new tagElement("param","serviceIndex",index);
        rowParams.appendChild(param);
        
    	index=st.getCellStoreValue(selectedRows[0], "serviceID", "serviceID");
        param = new tagElement("param","serviceID",index);
        rowParams.appendChild(param);
        
        rowParams.appendChild(new tagElement("param","activateState", activateState));
        
        bussinessNode.appendChild(rowParams);
	}	
	for(var i = 0,stlen = portst.getDataRowLength();i<stlen;i++)
	{
		var rowParams = new tagElement("row-params");
		
		var vlan = portst.getCellShow(i,"tagID").getValue();
		var portid = portst.getCellStoreValue(i,"portid","portid");
		var slotid = portst.getCellStoreValue(i,"slotid","slotid");
		
		param = new tagElement("param","neid",neid);
        rowParams.appendChild(param);

    	var selectedRows = st.getSelectedRows();
    	var index=st.getCellStoreValue(selectedRows[0], "serviceIndex", "serviceIndex");
        param = new tagElement("param","serviceIndex",index);
        rowParams.appendChild(param);
        
    	index=st.getCellStoreValue(selectedRows[0], "serviceID", "serviceID");
        param = new tagElement("param","serviceID",index);
        rowParams.appendChild(param);
        
        rowParams.appendChild(new tagElement("param","activateState", activateState));
        
        var cachePort = getCachePort(slotid,portid);
        /**
         *            
         *      TRANSU2000V1R7C00-2640 
         *                          UNI   UNI ID 0
         */
        if(!cachePort||cachePort.vuniID==null||cachePort.vuniID==undefined)
        {
	        param = new tagElement("param","vuniID","0");
	        rowParams.appendChild(param);	        	
        }
        else
        {
	        param = new tagElement("param","vuniID",""+cachePort.vuniID);
	        rowParams.appendChild(param);	 
        }

        
        param = new tagElement("param","autoServiceIndex","0");
        rowParams.appendChild(param);
        
        param = new tagElement("param","autoVuniID","1");
        rowParams.appendChild(param);   
        
        param = new tagElement("param","role","1");
        rowParams.appendChild(param); 
        
        param = new tagElement("param","slotid",slotid);
        rowParams.appendChild(param);
        
        param = new tagElement("param","subslotid","255");
        rowParams.appendChild(param);
        
        param = new tagElement("param","portid",portid);
        rowParams.appendChild(param);        
        
        var tagIDDataArr = getTagListData(vlan);
    	param = new tagElement("param","tagNum",tagIDDataArr[0]);	
    	rowParams.appendChild(param);
    	
    	if(tagIDDataArr[0]>ALERT_VLAN_NUM)
    	{
    		isAlertVlan=true;
    	}
    	param = new tagElement("param","tagID",tagIDDataArr[1]);	
    	rowParams.appendChild(param);
    	
        bussinessNode.appendChild(rowParams);
	}
	if(isAlertVlan)
	{
		return confirm(RESOURCE["userlongtime"]);
	}
	return true;
}
/**
 *           VlanID     ID
 */
function isValidVlanID()
{
	for(var i = 0,stlen = portst.getDataRowLength();i<stlen;i++)
	{	
		var vlan = portst.getCellShow(i,"tagID").getValue();
		if(vlan!=""&&vlan!=null)
		{
		  	var isValide = validataTagList(vlan);
		  	if(isValide == -1)
		  	{
		  		return false;
		  	}
		}
	}
	return true;
}
/**
 *     UNI  
 * @return
 */
function doModElanUNIPortList()
{
	
	if(!isValidVlanID())
	{
		return false;
	}
    var root = new inputxml("datainterface");
    var bussinessNode = new tagElement("bussiness-params");
    var isModFlg = false;
	if(SYSTEMCONF.getStatus() == 1)
	{
		if(!createModUniXMLForIntegrate(bussinessNode))
		{
			$("applybtn").disabled = !btnRightArr.applybtn.right;
			return false;
		}
		isModFlg = true;
		root.getRoot().appendChild(bussinessNode);
	}
	else
	{
	    var delUNIPortList = getDelUNIPort();
		if(delUNIPortList.length != 0)
		{
			createDelUNIPortXML(bussinessNode,delUNIPortList);
			isModFlg = true;
		}	
		
		var addUNIPortList = getAddUNIPort();
		if(addUNIPortList.length != 0)
		{
			if(!createAddVuniXML(bussinessNode,addUNIPortList))
			{
				$("applybtn").disabled = !btnRightArr.applybtn.right;
				return false;
			}
			isModFlg = true;
		}	
		if(isModFlg)
		{
			createServiceTagXML(bussinessNode);
		}
		root.getRoot().appendChild(bussinessNode);
	}
	
	var xml =root.toString();
    if (null == xml||(!isModFlg)) 
    {
        return false;
    }
    
	LoadingProcess.showWaitStatus("../../../../../../images");
	var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETHSRV_MOD_ELAN_V_UNI + "&flag=1&nmUser=" + nmuser;
	loadXMLdoc(urlstr, "POST", true, callbackModUni, null, "inputdata=" + xml);
	return true;
}

function callbackModUni(doc)
{
    var data = EncapsulateData(doc);
    LoadingProcess.removeWaitStatus();
    var errorCode = data.getSErrorCode();
    showErrorDialog(data);
	if(OPERATION_SUCCESS == errorCode) 
	{
		
		doApplyPortAttr(true);

	}


	queryElanResPara(true);
	
}

/**
 * SERVICE_TAG xml
 * @param bussinessNode
 * @return
 */
function createServiceTagXML(/*tagElement*/bussinessNode)
{
    var rowParams = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "block");
    param.setAttribute("value", "SERVICE_TAG");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "serviceTag");
    param.setAttribute("value", $("tagType").value);
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
}
/**
 *     UNI     
 * @param bussinessNode
 * @return
 */
function createDelUNIPortXML(/*tagElement*/bussinessNode,/* Array */delPortList)
{
	var rowParams = new tagElement("row-params");
    var rowindx = 0;
    for (var j = 0; j < delPortList.length; j++) 
    {
        rowParams = new tagElement("row-params");
        var param = null;
        if (rowindx == 0) 
        {
        	param = new tagElement("param","block","NSCMD_SERVICE_DEL_ETHVUNI");
            rowParams.appendChild(param);
        }
        rowindx++;
        
        param = new tagElement("param","neid",neid);
        rowParams.appendChild(param);
        
    	var selectedRows = st.getSelectedRows();
    	var index=st.getCellStoreValue(selectedRows[0], "serviceIndex", "serviceIndex");
        param = new tagElement("param","serviceIndex",index);
        rowParams.appendChild(param);
        
        param = new tagElement("param","vuniID",delPortList[j].vuniID);
        rowParams.appendChild(param);
        bussinessNode.appendChild(rowParams);
    }
}
/**
 *     UNI     
 * @param bussinessNode
 * @return
 */
function createAddVuniXML(/*tagElement*/bussinessNode,/* Array */addPortList)
{
	var rowParams = new tagElement("row-params");
    var rowindx = 0;
    /**
     *  Vlan                  
     */
    var isAlertTag = false;
    for (var j = 0; j < addPortList.length; j++) 
    {
        rowParams = new tagElement("row-params");
        var param = null;
        if (rowindx == 0) 
        {
        	param = new tagElement("param","block","NSCMD_SERVICE_ADD_ETHVUNI_EX");
            rowParams.appendChild(param);
        }
        rowindx++;
        
        param = new tagElement("param","neid",neid);
        rowParams.appendChild(param);

    	var selectedRows = st.getSelectedRows();
    	var index=st.getCellStoreValue(selectedRows[0], "serviceIndex", "serviceIndex");
        param = new tagElement("param","serviceIndex",index);
        rowParams.appendChild(param);
        
        param = new tagElement("param","vuniID",""+addPortList[j].slotid+addPortList[j].portid);
        rowParams.appendChild(param);
        
        param = new tagElement("param","autoServiceIndex","0");
        rowParams.appendChild(param);
        
        param = new tagElement("param","autoVuniID","1");
        rowParams.appendChild(param);   
        
        param = new tagElement("param","role","1");
        rowParams.appendChild(param); 
        
        param = new tagElement("param","slotid",addPortList[j].slotid);
        rowParams.appendChild(param);
        
        param = new tagElement("param","subslotid","255");
        rowParams.appendChild(param);
        
        param = new tagElement("param","portid",addPortList[j].portid);
        rowParams.appendChild(param);        
        
        var tagIDDataArr = getTagListData(addPortList[j].tag);
    	param = new tagElement("param","tagNum",tagIDDataArr[0]);	
    	rowParams.appendChild(param);
    	
    	param = new tagElement("param","tagID",tagIDDataArr[1]);	
    	rowParams.appendChild(param);
    	if(tagIDDataArr[0]>ALERT_VLAN_NUM)
    	{
    		isAlertTag = true;
    	}
        bussinessNode.appendChild(rowParams);
    }
    if(isAlertTag)
    {
    	return confirm(RESOURCE["userlongtime"]);
    }
    return true;
}
/**
 *                       
 * @return
 */
function getAddUNIPort()
{
	   	var portlist = [];
		for(var i = 0,stlen = portst.getDataRowLength();i<stlen;i++)
		{
			portid = portst.getCellStoreValue(i,"portid","portid");
			slotid = portst.getCellStoreValue(i,"slotid","slotid");
			for(var pos=0,len=usableBoardArr.length;pos<len;pos++)
			{
				/**
				 *                                
				 */
				if(portid == usableBoardArr[pos].portid
						&&slotid == usableBoardArr[pos].slotid)
				{	
					var vlan = portst.getCellShow(i,"tagID").getValue();
					/**
					 *                   
					 */
					if(!usableBoardArr[pos].isUsed)
					{
						
						var vlanNum;
						if(vlan == "")
						{
							vlanNum = 0;
						}
						else
						{
							vlanNum = vlan.split(",").length;
						}
						var portData = new PortData(slotid,255,portid,vlanNum,vlan);
	
						portlist.push(portData);
					}
					/**
					 *            VLANID        
					 */
					else if(usableBoardArr[pos].tagID!=null||usableBoardArr[pos].tagID!=undefined)
					{
						if(usableBoardArr[pos].tagID!=vlan)
						{
							var vlanNum;
							if(vlan == "")
							{
								vlanNum = 0;
							}
							else
							{
								vlanNum = vlan.split(",").length;
							}
							var portData = new PortData(slotid,255,portid,vlanNum,vlan);
		
							portlist.push(portData);
						}
					}
				}
			}
		}
		return portlist;
}
/**
 *                       
 * @return
 */
function getDelUNIPort()
{
   	var portlist = [];

	for(var pos=0,len=usableBoardArr.length;pos<len;pos++)
	{
		/**
		 *                               
		 */
		if(usableBoardArr[pos].isUsed)
		{		
			var isPortSTContain = false;
			var vlan = null;
			for(var i = 0,stlen = portst.getDataRowLength();i<stlen;i++)
			{
				var portid = portst.getCellStoreValue(i,"portid","portid");
				var slotid = portst.getCellStoreValue(i,"slotid","slotid");
				if(portid == usableBoardArr[pos].portid
						&&slotid == usableBoardArr[pos].slotid)
				{
					isPortSTContain = true;
					vlan = portst.getCellShow(i,"tagID").getValue();
					break;
				}
			}
			/**
			 *                 
			 */
			if(!isPortSTContain)
			{
				portlist.push(usableBoardArr[pos]);
			}
			/**
			 *                VlanID                 
			 */
			else if((vlan!=null || vlan!=undefined)&&(usableBoardArr[pos].tagID!=null || usableBoardArr[pos].tagID!=undefined))
			{
				if(usableBoardArr[pos].tagID!=vlan)
				{
					portlist.push(usableBoardArr[pos]);
				}
			}
		}
	}

	return portlist;
}
/**
 *            
 */
function callbackSetPortAttri(doc)
{
	var data = EncapsulateData(doc);
	LoadingProcess.removeWaitStatus();
	var errorCode = data.getSErrorCode();
	isPortAttrModify=false;
	$("querybtn").disabled = !btnRightArr.querybtn.right;;
	if(st.getSelectedRows().length > 0)
	{
		$("deletebtn").disabled = false
	}
	showErrorDialog(data);
	if(OPERATION_SUCCESS == errorCode) 
	{
		refreshTableState(portst,window.tableconf[1],data);
		if(st.getSelectedRows().length == 0)
		{
			createElan();
		}

	}
	else
	{
		$("applybtn").disabled = !btnRightArr.applybtn.right;
		$("createbtn").disabled = !btnRightArr.createbtn.right;
        isPortAttrModify=true;
	}
	
	removeWaitStatus("create");
}

/**
 *          XML  
 * 
 * @param serviceindex
 */
function createQueryResParaXml()
{
	/**
	 *                       
	 */
	if(serviceIndex==null||serviceIndex==undefined
			||serviceID==null||serviceID==undefined
			||activateState==null||activateState==undefined)
	{
		return null;
	}
	var root = new inputxml("datainterface");
	var business = new tagElement("bussiness-params");
	var row = new tagElement("row-params");
	
	var param = new tagElement("param");    
	param.setAttribute("name", "block");
	param.setAttribute("value", "queryRes");
	row.appendChild(param);
	param = new tagElement("param","neid",neid);    
	row.appendChild(param);
	param = new tagElement("param","ethType","2");// (1:e-line 2:e-lan
	row.appendChild(param);
	param = new tagElement("param","linkid","0");
	row.appendChild(param);	

    row.appendChild(new tagElement("param","serviceIndex",serviceIndex));

    row.appendChild(new tagElement("param","serviceID",serviceID));
    
    row.appendChild(new tagElement("param","activateState", activateState));
    
    business.appendChild(row);
	
	row = new tagElement("row-params");
	param = new tagElement("param","block","NSCMD_SERVICE_GET_ETHVUNI_EX");
	row.appendChild(param);
	param = new tagElement("param","ethType","2");// (1:e-line 2:e-lan
	row.appendChild(param);
	param = new tagElement("param","serviceIndex",serviceIndex);
	row.appendChild(param);
    row.appendChild(new tagElement("param","serviceID",serviceID));    
   row.appendChild(new tagElement("param","activateState", activateState));
	param = new tagElement("param","vuniID","0");
	row.appendChild(param);
	business.appendChild(row);

	
	root.getRoot().appendChild(business);
	return root.toString();
}

/**
 *       UNI    
 * @param synflg  true       false      
 * @return
 */
function queryElanResPara(/*boolean*/synflg)
{
	LoadingProcess.showWaitStatus("../../../../../../images");
	var xmldata = createQueryResParaXml();
	if(xmldata==null)
	{
		LoadingProcess.removeWaitStatus();
		return;
	}
	var urlstr = "../../../../../../neExlorerServlet?sfid="+TECMDCODE_IPPTN_ETHSRV_GET_ELAN_V_UNI+"&timestamp="+new Date().getTime()+"&nmUser="+obj["nmUser"];
	loadXMLdoc(urlstr, "POST", synflg, callbackQueryResPara, null, "inputdata="+xmldata);
}

/**
 *           ,               
 * 
 * @param doc
 */
function callbackQueryResPara(/* XMLDOM */doc)
{

	var data = EncapsulateData(doc);

	if (data.getSErrorCode() < 2)
	{
		portst.clearTableData();

		var portlist = [];
		curselportlist = [];
		for(var pos=0;pos<usableBoardArr.length;pos++)
		{
			/**
			 *                   false    
			 *      uniid tagid      
			 *         TRANSU2000V1R7C00-2535 
			 * 
			 */
			usableBoardArr[pos].isUsed = false;
			usableBoardArr[pos].vuniID = null;
			usableBoardArr[pos].tagID = "";
			
			var portid=null;
			var slotid=null;
			for(var i = 0, len = data.getDataRowLength(); i < len; i++)
			{
				portid = data.getDataRowParam(i, "portid");
				slotid = data.getDataRowParam(i, "slotid");
				var vuniID = data.getDataRowParam(i, "vuniID");
				/**
				 *           
				 */
				if(portid == usableBoardArr[pos].portid&&slotid == usableBoardArr[pos].slotid)
				{
					usableBoardArr[pos].isUsed = true;
					usableBoardArr[pos].vuniID = vuniID;
					usableBoardArr[pos].tagID = data.getDataRowParam(i, "tagID");
					portlist.push(usableBoardArr[pos]);
					updateCurselportlist(usableBoardArr[pos])
				}
			}
			addPortCellEvent();
		}
		
		/**
		 *            
		 */
		querySplitToCache();
		
		/**
		 *     checkbox
		 */
		refreshPortCheckBoxTR(usableBoardArr);
		/**
		 *        
		 */
		clearPortResTable();
		/**
		 *          
		 */
		createBoardSelect(portlist);
		/**
		 *         
		 */
		queryPortAttribute();
		
		if($("elantab") && $("elantab").style.display != "none")
	        {
	            queryAdvanceData();
	        }
	}
	else
	{
		showErrorDialog(data);
	}
	LoadingProcess.removeWaitStatus();
}

/**
 *                             
 */
function updateCurselportlist(uniport)
{
	curselportlist.push(new portAttr(uniport.vuniID,uniport.portid,
			createPortNameWithVLAN(portFoShowName[uniport.portid],uniport.tagID),UNI_PORTYPE,uniport.tagID,
    		"",uniport.boardName,uniport.slotid));
}
/**
 *                  
 * @return
 */
function getUsedPortNum()
{
	var num = 0;
	for(var pos=0,len=usableBoardArr.length;pos<len;pos++)
	{
		if(usableBoardArr[pos].isUsed)
		{
			num++;
		}
	}
	return num;
}
/**
 *     checkbox     
 * @param portlist
 * @return
 */
function refreshPortCheckBoxTR(/* Array */portlist)
{
	 /**
     * 1 portFoShowName[portFOGE1] = "GE1";     
     */
	if(portlist.length >= portFOGE1 && portlist[portFOGE1-1] != null)
	{  
	    if(portlist[portFOGE1-1].isUsed)
	    {
	    	$("ge1port").checked = true;
	    }
	    else
	    {
	    	$("ge1port").checked = false;
	    }
	}
    /**
     * 2 portFoShowName[portFOGE2] = "GE2"; 
     */
    if(portlist.length >= portFOGE2 && portlist[portFOGE2-1] != null)
    {
	    if(portlist[portFOGE2-1].isUsed)
	    {
	    	$("ge2port").checked = true;
	    }
	    else
	    {
	    	$("ge2port").checked = false;
	    }
    }
    /**
     * 2 portFoShowName[portFOIFETH] = "IF(ETH)"; 
     */
    if(portlist.length >= portFOIFETH && portlist[portFOIFETH-1] != null)
    {
	    if(portlist[portFOIFETH-1].isUsed)
	    {
	    	$("ifport").checked = true;
	    }
	    else
	    {
	    	$("ifport").checked = false;
	    }
    }
}
/**
 *             
 * @return
 */
function clearPortResTable()
{
	var tbody = $("portResTable").childNodes[0];
	for ( var i =tbody.childNodes.length - 1; i >= 0; i--)
	{
		tbody.removeChild(tbody.childNodes[i]);
	}
}
/**
 *               
 * @return
 */
function initialPortTR()
{
	selectAllPortCheckBox(false);
	
	clearPortResTable();
	
	createBoardSelect(usableBoardArr);
}
/***************************
 * portattribute object
 ***************************/
function portAttr(logicportid,portid,portname,porttype,cvlan,svlan,boardname,slotid)
{
   this.logicportid = logicportid;
   this.portid = portid;
   this.portname = portname;
   this.porttype = porttype;
   this.cvlan = cvlan;
   this.svlan = svlan;
   this.boardname = boardname;
   this.slotid = slotid;
}
function selectAllPortCheckBox(flag)
{
	if($("ge1port")!=null)
	{
		$("ge1port").checked = flag;
	}
	if($("ge2port")!=null)
	{
		$("ge2port").checked = flag;
	}
	if($("ifport")!=null)
	{
		$("ifport").checked = flag;
	}
}
