var parobj = getParentWindow();
var neid = parobj.neid;
var serviceIndex;
var curselportlist;
var macTable;
var DEFAULT_VLANID = 1;
var MIN_VLANID = 1;
var MAX_VLANID = 4094;

var tagtype = parobj.tagtype;
var macsflntypeValue = parobj.macsflntypeValue;

var macbox;

/**********************************
 * init the page
************************************/
function init()
{	
	initCacheValue()
	initAttrTable();   	
    initButtonText();
}
/**********************************
 *        
************************************/
function initCacheValue()
{
	
}
/**********************************
 * init attribute table
************************************/
function initAttrTable()
{
	
	macTable = new CTable();
    macTable.addHead(RESOURCE["property"],RESOURCE["value"]);
    
    var atom = new Atom('text');
    atom.element.setAttribute("id", "htmlText_vlanIDaddStatMac");
    
    var atomEle = atom.element; 
    atomEle.disabled = false;
    checkText(atomEle,MIN_VLANID + "",MAX_VLANID + "");
    atomEle.style.imeMode = "disabled"; 	
    macTable.addAttrRow("vlanID", "VLAN ID", atom); 
    atom.element["onchange"] = function()
    {	     
        $("applyBtn").disabled = false;
    }   
    
    if(macsflntypeValue == macsflntype_SVL)
    {
        atomEle.disabled = true;
        atomEle.value = '-';
    }
    
    atom = new Atom("span");

	macbox=new MacBox("macbox");
	atom.element.innerHTML=macbox;
    macTable.addAttrRow("macAdd", RESOURCE["macaddress"], atom); 
    macbox.onChange = function()
	{	     
	      $("applyBtn").disabled = false;
	}   
    
    initPorts();   
    
    $("statmactab").appendChild(macTable.getTable());
}

/**********************************
 * confirm if the input is mac addr
************************************/
function checkMAC(strparam)
{
    var ipAddressArray = strparam.split("-");
    
    if (MACARRAYLEN != ipAddressArray.length)
    {
    	alert(RESOURCE["wrongMAC"]);
		return false;
    }
    
    for(var i = 0, len = ipAddressArray.length; i < len; i++)
    {
    	  if (MACLEN != ipAddressArray[i].length)
    	  {
    	  	 alert(RESOURCE["wrongMAC"]);
	  	     return false;
    	  }
    }
    return true;
}

/**********************************
 * init button info
************************************/
function initButtonText()
{  
    $("okbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];	
    $("applybtn").value = RESOURCE["applybtn"];	
    
    if(macsflntypeValue == macsflntype_SVL)
    {
        $("applybtn").disabled = false;
    }
}

/**********************************
 * init port info
************************************/
function initPorts()
{
	curselportlist = parobj.curselportlist;
  
    var atom = new Atom("select");
    atom.element.setAttribute("id", "htmlText_einterfaceAddrStatMac");   
    macTable.addAttrRow("einterface", RESOURCE["einterface"], atom);
    for(var i=0,len = curselportlist.length;i<len;i++)
    {
    	if(curselportlist[i].logicportid!=null&&curselportlist[i].logicportid!=undefined)
    	{
    		atom.element.options.add(new Option(curselportlist[i].portname,curselportlist[i].logicportid));
    	}
    }
    atom.element["onchange"] = function()
	{	     
	      $("applyBtn").disabled = false;
	}   
}

/**********************************
 * do create static mac address
************************************/      
function doCreate(buttonFlag)
{

		serviceIndex = parobj.parobj.serviceIndex;
		if (serviceIndex == "")
    {
         alert(RESOURCE["selecteService"]);
         return;
    }
   
    if ("" == macTable.getAttrValue("vlanID"))
    {
    	alert(RESOURCE["nullvlan"]);
    	return;
    }
    if ("" == macbox.getValue())
    {
        alert(RESOURCE["inputVlan"]);
        return;
    }
    if("" == macTable.getAttrValue("einterface"))
    {
    	alert(RESOURCE["selectePort"]);
        return;
    }
    
    okFlag = buttonFlag;    
    if ($("applybtn").disabled && okFlag)
    {
        xcloseDialog();
        return;
    }
    
    $("okbtn").disabled = true;
    $("applybtn").disabled = true;
    $("cancelbtn").disabled = true;
    
    var xmlstr = createXML();
    urlreq ="../../../../../../neExlorerServlet?sfid="+TECMDCODE_IPPTN_ETHSRV_SET_ELAN_MAC_CFDB+"&flag=1&timestamp="+new Date().getTime()+"&nmUser="+parobj.parobj.obj["nmUser"];
    loadXMLdoc(urlreq, "POST",true,handleBackCreate,null,"inputdata="+xmlstr);
}  
      
function createXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");    
    param.setAttribute("name","neid");
    param.setAttribute("value",neid);
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","autoServiceIndex");
    param.setAttribute("value","0");
    row.appendChild(param);

    param = new tagElement("param");    
    param.setAttribute("name","serviceIndex");
    param.setAttribute("value",serviceIndex);
    row.appendChild(param);
    
    if(parobj.parobj.serviceID!=null&&parobj.parobj.serviceID!=undefined)
    {
    	param = new tagElement("param");
    	param.setAttribute("name","serviceID");
    	param.setAttribute("value",parobj.parobj.serviceID);
        row.appendChild(param);
    }
    
    
    if(parobj.parobj.activateState!=null&&parobj.parobj.activateState!=undefined)
    {
    	param = new tagElement("param");
    	param.setAttribute("name","activateState");
        param.setAttribute("value",parobj.parobj.activateState);
        row.appendChild(param);
    }
    param = new tagElement("param");    
    param.setAttribute("name","vlanID");
    if(macsflntypeValue == macsflntype_SVL)
    {
        param.setAttribute("value",'65534');
    } else {
        param.setAttribute("value",macTable.getAttrValue("vlanID"));
    }
    row.appendChild(param);

    param = new tagElement("param");    
    param.setAttribute("name","macAddr");
    param.setAttribute("value",macbox.getValue());
    row.appendChild(param);
    
    param = new tagElement("param");    
    param.setAttribute("name","iAutoFlag");
    param.setAttribute("value","0");
    row.appendChild(param);
    
    var uniid = macTable.getAttrValue("einterface");
    param = new tagElement("param");    
    param.setAttribute("name","iportID");
    param.setAttribute("value",uniid);
    row.appendChild(param);

    var porttype;
    var slotID;
    var portID;
    for(var i=0,len=curselportlist.length;i<len;i++)
    {
	    if (uniid == curselportlist[i].logicportid) 
	    {
	        porttype = curselportlist[i].porttype;
	        if(porttype == portType_Pbnni || porttype == portType_Pbuni || porttype == portType_Pbsuni)
	        {
	        	porttype = portType_Uni;
	        }
	        slotID = curselportlist[i].slotid;
	        portID = curselportlist[i].portid;
	        break;
	    }
    }  
    param = new tagElement("param");    
    param.setAttribute("name","eInterfaceType");
    param.setAttribute("value",porttype);
    row.appendChild(param);    
    /**
     * FO             slotid portid
     */
    param = new tagElement("param");    
    param.setAttribute("name","slotid");
    param.setAttribute("value",slotID);
    row.appendChild(param); 
    
    param = new tagElement("param");    
    param.setAttribute("name","portid");
    param.setAttribute("value",portID);
    row.appendChild(param); 
    
    
    bussiness.appendChild(row);   	  
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackCreate(doc)
{
    $("okbtn").disabled=false;
    $("cancelbtn").disabled=false;
	var data = EncapsulateData(doc);    
    showErrorDialog(data);
    if (data.getSErrorCode() < 2) 
    {   
         parobj.queryStatMac();
         if (okFlag)
         {
             xcloseDialog();
         }
    } 
   
} 

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    for(var i = 0, len = di.getBErrLength(); i < len; i++)
      {
    	   errorObj = di.getError().rowErrors[i].errorObj;
    	   errorObj["operationObj"] = RESOURCE["serviceID"]+":"+parobj.parobj.serviceID;
      }
    errArr[0] = "operationObj";
    openErrPage("../../../../../../page/", di.getError(), errArr);
}     
