var parobj = window.parent;
if(parobj.st == null || parobj.st == undefined)
{
	parobj = window.parent.parent;
}
var neid = parobj.neid;
var serviceIndex = parobj.serviceIndex;
var curselportlist = parobj.curselportlist;
var statmactab;
var btnRightArr = new Object();
var createbtnRight = TECMDCODE_CRT_PORT_POLICY;
var deletebtnRight = TECMDCODE_DEL_PORT_POLICY;
var querybtnRight = TECMDCODE_COPY_POLICY;
var tagtype = parobj.serviceTag;
var  macsflntypeValue = parobj.macsflntypeValue;


/**********************************
 * init the page
 ************************************/
function init(){

    serviceIndex = parobj.serviceIndex;

    initTable();
    initButtonInfo();
    handleButtonStatus();
    $("totalrow").innerHTML = RESOURCE["totalrow"];
    $("selrow").innerHTML = RESOURCE["selectedrow"];
    
}

function tabSelectHandler(){
    queryStatMac();
}

/**********************************
 * init table
 ************************************/
function initTable(){
    statmactab = new SortTable();
    statmactab.head.setAttribute("id", "htmlTable_STHead_dismacElanMain");
    statmactab.body.setAttribute("id", "htmlTable_STBody_dismacElanMain");
    statmactab.setImage("../../../../../../images/");
    createTableHead(statmactab, window.tableconf[0]);
    statmactab.setBodyHeight(getComponetHeight($("statmactable"),60) + "px");
    statmactab.setOnRowSelectHandler(rowSelectHandler);
    $("statmactable").appendChild(statmactab.getTable());
    $("statmactable").oncontextmenu = popupMenuHandler;
}
window.onresize = function()
{
	statmactab.setBodyHeight(getComponetHeight($("statmactable"),60) + "px");
}


function rowSelectHandler(){
    selectedRows = statmactab.getSelectedRows();
    if (selectedRows.length <= 0) {
        $("selrownum").innerHTML = 0;
        $("deletebtn").disabled = true;
        return;
    }
    
    $("totalrownum").innerHTML = statmactab.getDataRowLength();
    $("selrownum").innerHTML = selectedRows.length;
    $("deletebtn").disabled = !btnRightArr.deletebtn.right;
}

/**********************************
 * init button info
 ************************************/
function initButtonInfo(){
    $("querybtn").value = RESOURCE["querybtn"];
    $("createbtn").value = RESOURCE["createbtn"];
    $("deletebtn").value = RESOURCE["deletebtn"];
    
    btnRightArr.querybtn = new BtnRightObj("querybtn", querybtnRight);
    btnRightArr.createbtn = new BtnRightObj("createbtn", createbtnRight);
    btnRightArr.deletebtn = new BtnRightObj("deletebtn", deletebtnRight);
    
    getRightInfo(parobj.obj, btnRightArr);
    initrightbtn(btnRightArr);
}

/**********************************
 * button status depends on parobj
 ************************************/
function handleButtonStatus(){
    if (parobj.st.getSelectedRowCount() == 0) {
        $("querybtn").disabled = true;
        $("createbtn").disabled = true;
        $("deletebtn").disabled = true;
    }
    else {
        $("querybtn").disabled = false;
        $("createbtn").disabled = !btnRightArr.createbtn.right;
        $("deletebtn").disabled = !btnRightArr.deletebtn.right;
        
    }
}

/**********************************
 * query static mac address
 ************************************/
function queryStatMac(){
    if (parobj.st.getDataRowLength() <= 0) {
        return;
    }
    
    tagtype = parobj.serviceTag;
    macsflntypeValue = parobj.macsflntypeValue;

    
    if (btnRightArr.querybtn.right == false) {
        return;
    }
    serviceIndex = parobj.serviceIndex;
    if (serviceIndex == undefined || serviceIndex == "") {
        statmactab.clearTableData();
        return;
    }
    $("querybtn").disabled = true;
    $("createbtn").disabled = true;
    $("deletebtn").disabled = true;
    var xml = createQueryXML();
    if (isDemo) {
        loadXMLdoc("statmac.xml", "POST", false, queryHandBack, null);
    }
    else {
        var URL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETHSRV_QUE_ELAN_MAC_CFDB + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + parobj.obj["nmUser"];
        loadXMLdoc(URL, "POST", true, queryHandBack, null, "inputdata=" + xml);
    }
}

function createQueryXML(){
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel = new tagElement("row-params");
    
    var thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "neid");
    thirdlevel.setAttribute("value", neid);
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "slotid");
    thirdlevel.setAttribute("value", "0");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "serviceIndex");
    thirdlevel.setAttribute("value", serviceIndex);
    secondlevel.appendChild(thirdlevel);  
    
    if(parobj.serviceID!=null&&parobj.serviceID!=undefined)
    {
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name","serviceID");
        thirdlevel.setAttribute("value",parobj.serviceID);
        secondlevel.appendChild(thirdlevel);
    }
    
    if(parobj.activateState!=null&&parobj.activateState!=undefined)
    {
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name","activateState");
        thirdlevel.setAttribute("value",parobj.activateState);
        secondlevel.appendChild(thirdlevel);
    }
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "vlanID");
    thirdlevel.setAttribute("value", "0");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "macnum");
    thirdlevel.setAttribute("value", "65535");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "mactype");
    thirdlevel.setAttribute("value", "1");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "queryflag");
    thirdlevel.setAttribute("value", "1");
    secondlevel.appendChild(thirdlevel);
    
    thirdlevel = new tagElement("param");
    thirdlevel.setAttribute("name", "macfilter");
    thirdlevel.setAttribute("value", "macfilter:*-*-*-*-*-*");
    secondlevel.appendChild(thirdlevel);
    
    firstlevel.appendChild(secondlevel);
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

function queryHandBack(doc){
	curselportlist = parobj.curselportlist;
    var queryResult = EncapsulateData(doc);
	statmactab.clearTableData();
    if (queryResult.getSErrorCode() < 2) {
			for(var i = 0 ; i< queryResult.getDataRowLength() ; i++)
			{
				var eInterValue = queryResult.getDataRowParam(i,"eInterface");
				var eSlotId = queryResult.getDataRowParam(i,"eSlotId");
				var eportId = queryResult.getDataRowParam(i,"eportId");
			
				for( var j = 0 ; j < curselportlist.length ; j++ )
				{
					if( eSlotId == curselportlist[j].slotid && eportId == curselportlist[j].portid )
					{
						queryResult.rows[i].eInterface.value = curselportlist[j].portname;
					}
				}
			}
			
        createTableBody(statmactab, window.tableconf[0], queryResult, RESOURCE);
    }
    showErrorDialog(queryResult);
    $("querybtn").disabled = false;
    $("createbtn").disabled = !btnRightArr.createbtn.right;
    $("totalrownum").innerHTML = statmactab.getDataRowLength();
    $("selrownum").innerHTML = 0;
    
    if(macsflntypeValue == macsflntype_SVL)
    {
        var dataRowLength = statmactab.getDataRowLength();
        if (dataRowLength > 0) {
            for (var i = 0; i < dataRowLength; i++) {
                var vlanIDCellShow = statmactab.getCellShow(i, 'vlanID');
                vlanIDCellShow.setValue("-");
            }
        }
    }
}

/*********************************************
 * open the page for create static mac address
 **********************************************/
function createStatMac(){
	
	curselportlist = parobj.curselportlist;
	
    xshowModalDialog("statmaccreate.html",RESOURCE["createstatmac"], 500, 170, "../../../../../../images/");
}

/*********************************************
 * delete static mac address
 **********************************************/
function deleteStatMac(){
    var xml = createDeletXML();
    var URL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETHSRV_DEL_ELAN_MAC_CFDB + "&flag=1" + "&nmUser=" + parobj.obj["nmUser"];
    loadXMLdoc(URL, "POST", true, deleteHandBack, null, "inputdata=" + xml);
}

function createDeletXML(){
    var rows = statmactab.getSelectedRows();
    var root = new inputxml("datainterface");
    var firstlevel = new tagElement("bussiness-params");
    var secondlevel;
    
    for (var i = 0, len = rows.length; i < len; i++) {
        secondlevel = new tagElement("row-params");
        
        var thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "neid");
        thirdlevel.setAttribute("value", neid);
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "serviceIndex");
        thirdlevel.setAttribute("value", serviceIndex);
        secondlevel.appendChild(thirdlevel);
        
	    thirdlevel = new tagElement("param");
	    thirdlevel.setAttribute("name", "logicalInterfaceID");
	    thirdlevel.setAttribute("value", statmactab.getCellStoreValue(rows[i], "logicalInterfaceID", "logicalInterfaceID"));
	    secondlevel.appendChild(thirdlevel);

        if(parobj.serviceID!=null&&parobj.serviceID!=undefined)
        {
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name","serviceID");
            thirdlevel.setAttribute("value",parobj.serviceID);
            secondlevel.appendChild(thirdlevel);
        }
        
        if(parobj.activateState!=null&&parobj.activateState!=undefined)
        {
            thirdlevel = new tagElement("param");
            thirdlevel.setAttribute("name","activateState");
            thirdlevel.setAttribute("value",parobj.activateState);
            secondlevel.appendChild(thirdlevel);
        }
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "vlanID");
        thirdlevel.setAttribute("value", statmactab.getCellStoreValue(rows[i], "vlanID", "vlanID"));
        secondlevel.appendChild(thirdlevel);
        
        thirdlevel = new tagElement("param");
        thirdlevel.setAttribute("name", "macAddr");
        thirdlevel.setAttribute("value", statmactab.getCellStoreValue(rows[i], "macAddr", "macAddr"));
        secondlevel.appendChild(thirdlevel);
        
        firstlevel.appendChild(secondlevel);
    }
    root.getRoot().appendChild(firstlevel);
    return root.toString();
}

function deleteHandBack(doc){
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (data.getSErrorCode() < 2) {
        queryStatMac();
    }
}

function clearTableDataFunc()
{
	if(statmactab != null)
	{
		statmactab.clearTableData();
	} 
}

function showErrorDialog(di){
    var errArr = [];
    var errorObj = null;
    for (var i = 0, len = di.getBErrLength(); i < len; i++) {
        errorObj = di.getError().rowErrors[i].errorObj;
        errorObj["operationObj"] = RESOURCE["serviceID"] + ":" + parobj.serviceID;
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../../page/", di.getError(), errArr);
}
