var parobj = getParentWindow();
var neid = parobj.neid;
var creatflag = parobj.createFlag;
var neidvalue = 2 //neid;
var slotidvalue = 3//obj.slotid;
var boardType = 4//obj.boardType;
var boardlist = new Array();
var st, ct;//st:Left Table ct:Right Table
var usableBoardArr = new Array();
var tagtype = parobj.serviceTag;
var paporttype = parobj.getporttype;
var vuniID = 1000, vnniID = 5000;
var serviceIndex;
var serviceTag;
var bIsValidateVlanID = true;
var changePort = false;
var g_slotid = 0;
var g_portid = 0;
var g_slotList = [];
var iniSelectedPortData = new DataInterface();

var titlename = getNeProperty(self)["title"];
document.title = RESOURCE[titlename];


var existBoardPort = [];


var portAttrArr = [];
/*************************
 * init the page
 **************************/
function init()
{
    existBoardPort = parobj.getExsitBoardPort(paporttype);
    initButtonText();
    initBoardList();
    initTable();
}

/*************************
 * init the Board List
 **************************/
function initBoardList()
{
    $("board").innerHTML = RESOURCE["board"];
    getPorts();
}

/*************************
 * init the select table
 **************************/
function initTable()
{
    document.getElementById("avaliableportlabel").innerText = RESOURCE["availablePort"];
    document.getElementById("selectedportlabel").innerText = RESOURCE["selectedPort"];
    
    st = new SortTable();
    st.head.setAttribute("id", "htmlTable_STHead_portselectElan");
    st.body.setAttribute("id", "htmlTable_STBody_portselectElan");
    st.setImage("../../../../../../../../images/");
    st.setBodyHeight("250px");
    st.isUsedForSelectList = true;
    createTableHead(st, window.tableconf[1]);
    st.setOnRowSelectHandler(selectRightTblRowHandler);
    document.getElementById("resportList").appendChild(st.getTable());
    
    ct = new SortTable();
    ct.head.setAttribute("id", "htmlTable_STHead_createlpt1");
    ct.body.setAttribute("id", "htmlTable_STBody_createlpt1");
    ct.setImage("../../../../../../../../images/");
    ct.setBodyHeight("280px");
    ct.isUsedForSelectList = true;
    createTableHead(ct, window.tableconf[0]);
    ct.setOnRowSelectHandler(selectLeftTblRowHandler);
    document.getElementById("selPortList").appendChild(ct.getTable());
}

/*************************
 * init left select table
 **************************/
function initST()
{
    window.tableconf[1].colArray[4].width = "90%";
    window.tableconf[1].colArray[5].width = 0;
    window.tableconf[1].colArray[6].width = 0;
    window.tableconf[1].colArray[7].width = 0;
    st.deleteHeadRow();
    createTableHead(st, window.tableconf[1]);
}

/*************************
 * init right select table
 **************************/
function initCT()
{
    var cellEdit;
    if (tagtype == tagType_CAwared) 
    {
        window.tableconf[0].colArray[4].width = "50%";//portname
        window.tableconf[0].colArray[5].width = 0;//porttype
        window.tableconf[0].colArray[6].width = "50%";//vlan(tagID)
        window.tableconf[0].colArray[7].width = 0;//svlan
        ct.deleteHeadRow();
        createTableHead(ct, window.tableconf[0]);
        ct.getHeadCell("tagID").setValue("VLAN(1,3-5)");
    }
    else if (tagtype == tagType_SAwared) 
    {
        if (paporttype == "uni") 
        {
            window.tableconf[0].colArray[4].width = "25%";
            window.tableconf[0].colArray[5].width = "25%";
            window.tableconf[0].colArray[6].width = "25%";
            window.tableconf[0].colArray[7].cell.isEdit = "0";
            window.tableconf[0].colArray[7].width = "25%";
            cellEdit = window.tableconf[0].colArray[5].cell.editElement;
            cellEdit.options.length = 0;
            
            var opobj = new OPTag();
            opobj.name = "UNI(Port+S-VLAN)";
            opobj.value = "3";
            opobj.convert = "porttype";
            cellEdit.options[cellEdit.options.length] = opobj;
            
            opobj = new OPTag();
            opobj.name = "UNI(Port+C-VLAN+S-VLAN)";
            opobj.value = "4";
            opobj.convert = "porttype";
            cellEdit.options[cellEdit.options.length] = opobj;
            
            ct.deleteHeadRow();
            createTableHead(ct, window.tableconf[0]);
            ct.getHeadCell("tagID").setValue("C-VLAN(1,3-5)");
            ct.getHeadCell("svlan").setValue("S-VLAN");
        }
        else //nni
         {
            window.tableconf[0].colArray[4].width = "25%";
            window.tableconf[0].colArray[5].width = "25%";
            window.tableconf[0].colArray[6].width = "25%";
            window.tableconf[0].colArray[7].cell.isEdit = "0";
            window.tableconf[0].colArray[7].width = "25%";
            cellEdit = window.tableconf[0].colArray[5].cell.editElement;
            cellEdit.options.length = 0;
            var opobj = new OPTag();
            opobj.name = "NNI";
            opobj.value = "5";
            opobj.convert = "porttype";
            cellEdit.options[cellEdit.options.length] = opobj;
            
            ct.deleteHeadRow();
            createTableHead(ct, window.tableconf[0]);
            ct.getHeadCell("tagID").setValue("C-VLAN");
            ct.getHeadCell("svlan").setValue("S-VLAN");
        }
    }
    else //tag-transparent
     {
        window.tableconf[0].colArray[4].width = "100%";
        window.tableconf[0].colArray[5].width = 0;
        window.tableconf[0].colArray[6].width = 0;
        window.tableconf[0].colArray[7].width = 0;
        ct.clearTableData();
        ct.deleteHeadRow();
        createTableHead(ct, window.tableconf[0]);
    }
    
    initCTData();
}

/*******************************
 * init right select table data
 *                      
 *                      
 ********************************/
function initCTData()
{
    var tempst = parobj.confporttab;//parent window table
    if (!creatflag)//true:parent window is management. false:parent window is create window
    {
        tempst = parobj.portTab;
    }
    g_slotList = [];
    var selectedRows = tempst.getDataRowLength();
    
    for (var i = 0, len = selectedRows; i < len; i++) 
    {
        var vuniid = tempst.getCellStoreValue(i, "vuniID", "vuniID");
        var slotid = tempst.getCellStoreValue(i, "slotid", "slotid");
        var boardName = tempst.getCellStoreValue(i, "boardName", "boardName");
        var portid = tempst.getCellStoreValue(i, "portid", "portid");
        var portname = tempst.getCellStoreValue(i, "portname", "portname");
        var porttype = tempst.getCellStoreValue(i, "porttype", "porttype");
        var cvlan = tempst.getCellStoreValue(i, "tagID", "tagID");
        var svlan = tempst.getCellStoreValue(i, "svlan", "svlan");
        
        var obj = new Object();
        var ptag = new ParamTag();
        ptag.value = vuniid;
        obj["vuniID"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = slotid;
        obj["slotid"] = ptag;
        
        if(g_slotList.indexOf(slotid) == -1)
        {
        	g_slotList[g_slotList.length] = slotid;
        }
        
        ptag = new ParamTag();
        ptag.value = boardName;
        obj["boardName"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portid;
        obj["portid"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = portname;
        obj["portname"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = porttype;
        obj["porttype"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = cvlan;
        obj["tagID"] = ptag;
        
        ptag = new ParamTag();
        ptag.value = svlan;
        obj["svlan"] = ptag;
        if (tagtype == tagType_SAwared) 
        {
            if (paporttype == "uni") 
            {
                if (porttype != portType_Pbnni) 
                {
                    iniSelectedPortData.rows.push(obj);
                }
            }
            else if (paporttype == "nni") //nni
            {
                if (porttype == portType_Pbnni) 
                {
                    iniSelectedPortData.rows.push(obj);
                }
            }
        }
        else 
        {
            iniSelectedPortData.rows.push(obj);
        }
    }
    
    if(g_slotList.length > 0)
    {
    	for(var i = 0,len = g_slotList.length;i < len;i++)
    	{
    		g_slotid = g_slotList[i];
    		getPortNeAttr();
    	}
    }
    
    ct.clearTableData();
    createTableBody(ct, window.tableconf[0], iniSelectedPortData, RESOURCE);
    for( var i = 0; i < ct.getDataRowLength(); i++ )
    {
    	var tSlotID = ct.getCellStoreValue(i, "slotid", "slotid");
    	if( tSlotID == "65535" )
    	{
    		var portNameShow = ct.getCellShow(i, "portname");
    		portNameShow.setValue("NMS-1");
    		
    		var vlanCell = ct.getCell(i, "tagID");
    		ct.setCellIsEdit(vlanCell, false);
    		ct.getCellShow(i, "tagID").setValue("-");
    	}
    }
    initConfigStatus(ct, tagtype, paporttype);
    addCellEvent();
}

function initConfigStatus(ct, tagType, vuninniType)
{
    for (var i = 0; i < ct.getDataRowLength(); i++) 
    {
        if (tagType == tagType_SAwared) 
        {
            var portType = ct.getCellStoreValue(i, "porttype", "porttype");
            var cvlancell = ct.getCell(i, "tagID");
            var svlancell = ct.getCell(i, "svlan");
            if (portType == portType_Pbuni || portType == portType_Nni || portType == portType_Pbnni) 
            {
                cvlancell.element.showElement.setValue("-");
                cvlancell.element.editElement.setValue("0");
                ct.setCellIsEdit(cvlancell, 0);
            }
            else 
            {
                ct.setCellIsEdit(cvlancell, 1);
            }
            ct.setCellIsEdit(svlancell, 1);
        }
    }
}

function addCellEvent()
{
    var cell = null;
    for (var i = 0, len = ct.getDataRowLength(); i < len; i++) 
    {
        cell = ct.getCell(i, "porttype");
        cell.element.editElement.element["onchange"] = function()
        {
            var rowindex = this.parentNode.parentNode.rowIndex;
            var cvlancell = ct.getCell(rowindex, "tagID");
            if (tagtype == tagType_SAwared) 
            {
                if (this.value == portType_Pbuni || this.value == portType_Nni) 
                {
                    ct.setCellValue(cvlancell, "tagID", "0");
                    cvlancell.element.showElement.setValue("-");
                    cvlancell.element.editElement.setValue("0");
                    ct.setCellIsEdit(cvlancell, 0);
                }
                else 
                {
                    cvlancell.element.showElement.setValue("");
                    cvlancell.element.editElement.setValue("");
                    ct.setCellIsEdit(cvlancell, 1);
                }
            }
            else 
            {
                cvlancell.element.showElement.setValue("");
                cvlancell.element.editElement.setValue("");
                ct.setCellIsEdit(cvlancell, 1);
            }
        }
        
        cell = ct.getCell(i, "tagID");
        cell.element.editElement.element["onkeypress"] = function()
        {
            return checkData(this, event, 1, 4094);
        }
        
        cell = ct.getCell(i, "svlan");
        if (paporttype == "nni") 
        {
            cell.element.editElement.element["onkeypress"] = function()
            {
                return checkData(this, event, 1, 4094);
            }
        }
        else 
        {
			/**
			     DTS2011011005005              RTN900V1R3C00  Weblct     
			*/
            textCheckWithNull(cell.element.editElement.element, MIN_VLANID, MAX_VLANID);
        }
        /**
         cell.element.editElement.element["onchange"] = function()
         {
         textCheck(cell.element.editElement.element,MIN_VLANID,MAX_VLANID);
         }  **/
    }
}

function selectRightTblRowHandler(rows)
{
    if (rows.length > 0) 
    {
        $("cfgPortAddBtn").disabled = false;
    }
    else 
    {
        $("cfgPortAddBtn").disabled = true;
    }
}

function selectLeftTblRowHandler(rows)
{
    if (rows.length > 0) 
    {
        $("cfgPortDelBtn").disabled = false;
    }
    else 
    {
        $("cfgPortDelBtn").disabled = true;
    }
}

/*************************
 * init button info
 **************************/
function initButtonText()
{
    $("selectbtn").value = RESOURCE["okbtn"];
    $("cancelbtn").value = RESOURCE["cancelbtn"];
}

/*************************
 * query valible port
 **************************/
function getPorts()
{
    var xmlstr = createGetPortsXML();
    if (isDemo) 
    {
        loadXMLdoc("portselect_test.xml", "POST", false, handleBackgetPorts, null);
    }
    else 
    {
        var urlreq = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETHSRV_GET_ELAN_RES_EX + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + parobj.parobj.obj["nmUser"];
        loadXMLdoc(urlreq, "POST", true, handleBackgetPorts, null, "inputdata=" + xmlstr);
    }
}

function createGetPortsXML()
{
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    var row = new tagElement("row-params");
    
    var param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "ethType");
    param.setAttribute("value", "2");
    row.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "availableType");
    param.setAttribute("value", "portResType");
    row.appendChild(param);
    
    {
	    param = new tagElement("param");
	    param.setAttribute("name", "function_origin");	//           ,  ELAN UNI  .
	    param.setAttribute("value", "elan");
	    row.appendChild(param);
    }
    
    bussiness.appendChild(row);
    di.getRoot().appendChild(bussiness);
    return di.toString();
}

function handleBackgetPorts(doc)
{
    var data = EncapsulateData(doc);
    if (data.getSErrorCode() < 2) 
    {
        initCT();
        initBoardPortData(data);
        createBoardList(neid);
    }
    showErrorDialog(data);
}

/*************************
 * init board list
 **************************/
function createBoardList(neid)
{
	var temBoardList = usableBoardArr;
    var poolBoardSelect = document.getElementById("boardList");
    
    if (temBoardList.length == 0) 
    {
        return;
    }
    
    for (var i = 0; i < temBoardList.length; i++) 
    {
    	if((temBoardList[i].portidArr == null) || (temBoardList[i].portidArr == undefined))
    	{
    		continue;
    	}
        var boardid = temBoardList[i].slotid;
        var boardName = temBoardList[i].boardName;
        boardName = boardid + "-" + boardName;
        if( boardid == "65535" )
        {
        	boardName = "NMS-1";
        }
        var oOption = document.createElement("option");
        oOption.appendChild(document.createTextNode(boardName));
        oOption.setAttribute("value", boardid);
        poolBoardSelect.appendChild(oOption);
    }
    refreshPortList();
}

/*************************
 * refresh port list
 **************************/
function refreshPortList()
{	
    var selectedId = document.getElementById("boardList").selectedIndex;
    var poolSlotId = document.getElementById("boardList").options[selectedId].value;
    var board;
    for (var i = 0; i < usableBoardArr.length; i++) 
    {
        if (usableBoardArr[i].slotid == poolSlotId) 
        {
            board = usableBoardArr[i];
            break;
        }
    }
    
    if (board.portNameArr != null) 
    {
        var dInterface = new DataInterface();
        for (var i = 0, len = board.portNameArr.length; i < len; i++) 
        {
            var value = board.portidArr[i];
            if (isExistBoardPort(board.slotid, value) && tagtype != 2) 
            {
                continue;
            }
            
            var obj = new Object();
            
            g_slotid = board.slotid;
			g_portid = value;
			if(g_slotList.indexOf(g_slotid) == -1)
			{
				g_slotList[g_slotList.length] = g_slotid;
            	getPortNeAttr();
            }

            var ptag = new ParamTag();
            ptag.value = board.slotid;
            obj["slotid"] = ptag;
            
            ptag = new ParamTag();
            ptag.value = board.boardName;
            obj["boardName"] = ptag;
            
            ptag = new ParamTag();
            ptag.value = value;
            obj["portid"] = ptag;
            
            ptag = new ParamTag();
            ptag.value = board.portNameArr[i];
            obj["portname"] = ptag;
            
            dInterface.rows.push(obj);
        }
        st.clearTableData();
        createTableBody(st, window.tableconf[1], dInterface, RESOURCE);
        for( var i = 0; i < st.getDataRowLength(); i++ )
        {
        	var tSlotID = st.getCellStoreValue(i, "slotid", "slotid");
        	if( tSlotID == "65535" )
        	{
        		var tCellShow = st.getCellShow(i, "portname");
        		tCellShow.setValue("NMS-1");
        	}
        }
        st.sortRows(st.getHeadCell("portid").element, 1);
        if (tagtype != 2) 
        {
            getRightDelLeftTable(st, ct);
        }
    }
}

function isExistBoardPort(slotid, portid)
{
    var bResult = false;
    for (var j = 0, m = existBoardPort.length; j < m; j++) 
    {
        if (existBoardPort[j].slotid == slotid &&
        existBoardPort[j].portid == portid) 
        {
            bResult = true;
            break;
        }
    }
    return bResult;
}

function getRightDelLeftTable(leftTable, rightTable)
{
    if (rightTable.getDataRowLength() == 0) 
    {
        return;
    }
    var selectedId = document.getElementById("boardList").selectedIndex;
    var poolSlotId = document.getElementById("boardList").options[selectedId].value;
    var portsName = "";
    var deleteRows = "";
    
    for (var i = 0; i < rightTable.getDataRowLength(); i++) 
    {
        var rightID = rightTable.getCellStoreValue(i, "slotid", "slotid");
        if (poolSlotId != rightID) 
        {
            continue;
        }
        
        portsName = rightTable.getCellStoreValue(i, "portname", "portname");
        for (var k = 0, len = leftTable.getDataRowLength(); k < len; k++) 
        {
            var leftName = leftTable.getCellStoreValue(k, "portname", "portname");
            if (leftName == portsName) 
            {
                if (deleteRows == "") 
                {
                    deleteRows = k + "";
                }
                else 
                {
                    deleteRows = deleteRows + "," + k;
                }
            }
        }
    }
    var delRows = deleteRows.split(",");
    if (delRows != null && delRows != "") 
    {
        for (var i = delRows.length - 1; i >= 0; i--) 
        {
            leftTable.deleteRow(delRows[i]);
        }
        leftTable.adjustDataRows();
    }
}

/*************************
 * init board & port data
 **************************/
function initBoardPortData(data)
{
	var flag = true, datapart;
    for (var i = 0, len = data.getDataRowLength(); i < len; i++) 
    {
        var blockid = data.getDataRowParam(i, "block");
        if (blockid != null) 
        {
            if (blockid == "NSCMD_SERVICE_GET_ETHVUNI_EX") 
            {
                datapart = "uni";
            }
            else 
            {
                datapart = "nni";
            }
        }
        
        if (datapart != "" && datapart != paporttype) 
        {
            flag = false;
        }
        if (datapart != "" && datapart == paporttype) 
        {
            flag = true;
        }
        
        if (flag == true) 
        {
            var boardName = data.getDataRowParam(i, "boardName");
            var slotid = data.getDataRowParam(i, "slotid");
            if (slotid == null) 
            {
                return;
            }
            
            var usableBd = new TEUsableBoard();
            usableBd.slotid = slotid;
            usableBd.boardName = data.getDataRowParam(i, "boardName");
            usableBd.subslotid = data.getDataRowParam(i, "subslotid");
            usableBd.subBoardName = data.getDataRowParam(i, "subBoardName");
            usableBd.portidArr = data.getDataRowOptions(i, "portid");
            usableBd.portNameArr = data.getDataRowOptions(i, "portname");
            usableBoardArr.push(usableBd);
        }
    }
}

/*************************
 * add port to right
 **************************/
function cfgAddPort()
{
    var selectedrows = st.getSelectedRows();
    processAddPorts(selectedrows);
	changePort = true;
}

/*************************
 * del port from right
 **************************/
function cfgDelPort()
{
    var selectedrows = ct.getSelectedRows();
    processDelPorts(selectedrows);
	changePort = true;
}

/*************************
 * do add port to right
 **************************/
function processAddPorts(selectedrow)
{

    var selectedrows = selectedrow;
    var dinterface = new DataInterface();
    var ptag, obj;
    for (var i = 0; i < selectedrows.length; i++) 
    {
        obj = new Object();
        var vuniid = st.getCellStoreValue(selectedrows[i], "vuniID", "vuniID");
        ptag = new ParamTag();
        ptag.value = vuniid;
        obj["vuniID"] = ptag;
        
        var slotid = st.getCellStoreValue(selectedrows[i], "slotid", "slotid");
        ptag = new ParamTag();
        ptag.value = slotid;
        obj["slotid"] = ptag;
        
        var boardname = st.getCellStoreValue(selectedrows[i], "boardName", "boardName");
        ptag = new ParamTag();
        ptag.value = boardname;
        obj["boardName"] = ptag;
        
        var portid = st.getCellStoreValue(selectedrows[i], "portid", "portid");
        ptag = new ParamTag();
        ptag.value = portid;
        obj["portid"] = ptag;
        
        var portname = st.getCellStoreValue(selectedrows[i], "portname", "portname");
        ptag = new ParamTag();
        ptag.value = portname;
        obj["portname"] = ptag;
        
        var porttype = st.getCellStoreValue(selectedrows[i], "porttype", "porttype");
        if (tagtype == tagType_SAwared && paporttype == "uni") 
        {
            if (!porttype) 
            {
                porttype = portType_Pbuni;
            }
        }
        else if (tagtype == tagType_SAwared && paporttype == "nni") 
        {
            porttype = portType_Pbnni;
        }
        else 
        {
            porttype = portType_Uni;
        }
        ptag = new ParamTag();
        ptag.value = porttype;
        obj["porttype"] = ptag;
        
        var cvlan = st.getCellStoreValue(selectedrows[i], "tagID", "tagID");
        if (tagtype != tagType_CAwared) 
        {
            if (porttype != 4 && cvlan) 
            {
                cvlan = "-";
            }
        }
        ptag = new ParamTag();
        ptag.value = cvlan;
        obj["tagID"] = ptag;
        
        var svlan = st.getCellStoreValue(selectedrows[i], "svlan", "svlan");
        ptag = new ParamTag();
        ptag.value = svlan;
        obj["svlan"] = ptag;

				/*AU9D78795   802.1AD            UNI            ?
				*/
        if (tagtype != 2) 
        {
            st.deleteRow(selectedrows[i]);
        }
        dinterface.rows.append(obj);
    }
    
    createTableBody(ct, window.tableconf[0], dinterface, RESOURCE);
    for( var i = 0; i < ct.getDataRowLength(); i++ )
    {
    	var tSlotID = ct.getCellStoreValue(i, "slotid", "slotid");
    	if( tSlotID == "65535" )
    	{
    		var portNameShow = ct.getCellShow(i, "portname");
    		portNameShow.setValue("NMS-1");
    		
    		var vlanCell = ct.getCell(i, "tagID");
    		ct.setCellIsEdit(vlanCell, false);
    		ct.getCellShow(i, "tagID").setValue("-");
    	}
    }
    ct.adjustDataRows();
    initCellStatus(ct, selectedrows.length, tagtype, paporttype);
    addCellEvent();
    st.adjustDataRows();
    
    if (tagtype != 2) 
    {
        $("cfgPortAddBtn").disabled = true;
    }
}


function initCellStatus(ct, selectRowNum, tagType, portType)
{
    if (ct.getDataRowLength() != 0) 
    {
        for (var i = 1; i <= selectRowNum; i++) 
        {
            var len = ct.getDataRowLength();
            var cvlancell = ct.getCell(len - i, "tagID");
            var svlancell = ct.getCell(len - i, "svlan");
            if (tagType == tagType_SAwared) 
            {
                if (portType == "uni") 
                {
                    if (ct.getCellStoreValue(len - i, "vuniID", "vuniID")) 
                    {
                        if (ct.getCellStoreValue(len - i, "porttype", "porttype") == 4) 
                        {
                            ct.setCellIsEdit(cvlancell, 1);
                            ct.setCellIsEdit(svlancell, 1);
                        }
                        else 
                        {
                            cvlancell.element.showElement.setValue("-");
                            cvlancell.element.editElement.setValue("0");
                            ct.setCellIsEdit(cvlancell, 0);
                            ct.setCellIsEdit(svlancell, 1);
                        }
                    }
                    else 
                    {
                        cvlancell.element.showElement.setValue("-");
                        cvlancell.element.editElement.setValue("0");
                        ct.setCellIsEdit(cvlancell, 0);
                        ct.setCellIsEdit(svlancell, 1);
                    }
                }
                else 
                {
                    cvlancell.element.showElement.setValue("-");
                    cvlancell.element.editElement.setValue("0");
                    ct.setCellIsEdit(cvlancell, 0);
                    ct.setCellIsEdit(svlancell, 1);
                }
            }
        }
    }
}

function validateVlanParams(ct, tagType, portType)
{
    for (var i = 0, len = ct.getDataRowLength(); i < len; i++) 
    {
        var porttypecell = ct.getCell(i, "porttype");
        var cvlancell = ct.getCell(i, "tagID");
        var svlancell = ct.getCell(i, "svlan");
        
        if (tagType == tagType_SAwared) 
        {
            if (portType == "uni") 
            {
            
            }
            else if (portType == "nni") 
            {
            
            }
        }
        else 
        {
        
        }
    }
}

/*************************
 * do del port from right
 **************************/
function processDelPorts(selectedrow)
{
    var selectedrows = selectedrow;
    var dinterface = new DataInterface();
    var ptag, obj;
    var sameRows = 0;
    var selectedId = document.getElementById("boardList").selectedIndex;
    var poolSlotId = document.getElementById("boardList").options[selectedId].value;
    var rBoardName = document.getElementById("boardList").options[selectedId].text;
    
    for (var i = selectedrows.length - 1; i >= 0; i--) 
    {
        obj = new Object();
        ptag = new ParamTag();
        var vuniid = ct.getCellStoreValue(selectedrows[i], "vuniID", "vuniID");
        ptag.value = vuniid;
        obj["vuniID"] = ptag;
        
        ptag = new ParamTag();
        var slotid = ct.getCellStoreValue(selectedrows[i], "slotid", "slotid");
        ptag.value = slotid;
        obj["slotid"] = ptag;
        
        ptag = new ParamTag();
        var boardname = ct.getCellStoreValue(selectedrows[i], "boardName", "boardName");
        ptag.value = boardname;
        obj["boardName"] = ptag;
        
        ptag = new ParamTag();
        var portid = ct.getCellStoreValue(selectedrows[i], "portid", "portid");
        ptag.value = portid;
        obj["portid"] = ptag;
        
        ptag = new ParamTag();
        var portname = ct.getCellStoreValue(selectedrows[i], "portname", "portname");
        ptag.value = portname;
        obj["portname"] = ptag;
        
        ptag = new ParamTag();
        var porttype = ct.getCellStoreValue(selectedrows[i], "porttype", "porttype");
        ptag.value = porttype;
        obj["porttype"] = ptag;
        
        ptag = new ParamTag();
        var cvlan = ct.getCellStoreValue(selectedrows[i], "tagID", "tagID");
        ptag.value = cvlan;
        obj["tagID"] = ptag;
        
        ptag = new ParamTag();
        var svlan = ct.getCellStoreValue(selectedrows[i], "svlan", "svlan");
        ptag.value = svlan;
        obj["svlan"] = ptag;
        
        ct.deleteRow(selectedrows[i]);
        
        if ( ( (slotid + "-" + boardname) == rBoardName /*|| (slotid == poolSlotId && slotid == "65535")*/ ) && 
        	!isContained(st, slotid, boardname, portname) ) 
        {
            dinterface.rows[sameRows] = obj;
            sameRows++;
        }
        
    }
    
    if (tagtype != tagType_SAwared) 
    {
        createTableBody(st, window.tableconf[0], dinterface, RESOURCE);
        for( var i = 0; i < st.getDataRowLength(); i++ )
        {
        	var tSlotID = st.getCellStoreValue(i, "slotid", "slotid");
        	if( tSlotID == "65535" )
            {
        		var portNameShow = st.getCellShow(i, "portname");
        		portNameShow.setValue("NMS-1");
        		st.getCellShow(i, "tagID").setValue("-");
            }        	
        }
        st.sortRows(st.getHeadCell("portid").element, 1);
    }
    
    ct.adjustDataRows();
    
    $("cfgPortDelBtn").disabled = true;
}

/**
 *                                  
 */
function isContained(stable, slotid, boardname, portname)
{
    var selSlot = $("boardList").options[$("boardList").selectedIndex].value;
    if (selSlot != slotid) 
    {
        return false;
    }

    for (var i = 0, len = stable.getDataRowLength(); i < len; i++) 
    {
        if (stable.getCellStoreValue(i, "portname", "slotid") == slotid &&
        stable.getCellStoreValue(i, "portname", "boardName") == boardname &&
        stable.getCellStoreValue(i, "portname", "portname") == portname) 
        {
            return true;
        }
        
    }
    return false;
}


/***************************
 * do create uni/nni port
 ****************************/
function doCreate()
{
	var refreshPortAttr = true;
    serviceIndex = parobj.serviceIndex;
    serviceTag = parobj.serviceTag;
	if(parobj.splitTab)
	{
		var splitLen = parobj.splitTab.getDataRowLength();
		if(changePort && (splitLen != 0))
		{
			var confirmed = confirm(RESOURCE["changSplitPorts"]);
	        if (!confirmed) 
	        {
	            xcloseDialog();
	            refreshPortAttr = false; //                   
	        }
			else
			{
				parobj.refreshSplit();
			}
		}
	}

    if (creatflag) 
    {
        bIsValidateVlanID = true;
        var root = new inputxml("datainterface");
        var bussinessNode = new tagElement("bussiness-params");
        createServiceTag(bussinessNode);
        createDelVuniXML(bussinessNode);
        createAddVuniXML(bussinessNode);
        
        if (serviceTag == tagType_SAwared) 
        {
            createAddPBVUniXML(bussinessNode);
        }

        createModifyVuniXML(bussinessNode);
        
        if (!bIsValidateVlanID) 
        {
            return;
        }
        root.getRoot().appendChild(bussinessNode);
        var xml = root.toString();
        if (null == xml) 
        {
            return;
        }
        var URL = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_IPPTN_ETHSRV_MOD_ELAN_V_UNI + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + parobj.parobj.obj["nmUser"];
        loadXMLdoc(URL, "POST", false, doCreateBack, null, "inputdata=" + xml);
    }
    else if (refreshPortAttr)
    {
		/**
		 * modify by q00119080
		 *                        
		 */ 	
        var paporttab = parobj.portTab;
        var datalength = ct.getDataRowLength();
        var dinterface = new DataInterface();
        var ptag, obj;
        var sameRows = 0;
        for (var i = 0; i < datalength; i++) 
        {
            ptag = new ParamTag();
            obj = new Object();
            var slotid = ct.getCellStoreValue(i, "slotid", "slotid");
            ptag.value = slotid;
            obj["slotid"] = ptag;
            
            ptag = new ParamTag();
            var boardname = ct.getCellStoreValue(i, "boardName", "boardName");
            ptag.value = boardname;
            obj["boardName"] = ptag;
            
            ptag = new ParamTag();
            ptag.value = "255";
            obj["subslotid"] = ptag;
            
            var porttype = ct.getCellStoreValue(i, "porttype", "porttype");
            var logportid = (porttype == portType_Pbnni ? vnniID++ : vuniID++);
            ptag = new ParamTag();
            ptag.value = logportid;
            obj["vuniID"] = ptag;
            
            ptag = new ParamTag();
            var portid = ct.getCellStoreValue(i, "portid", "portid");
            ptag.value = portid;
            obj["portid"] = ptag;
            
            ptag = new ParamTag();
            var portname = ct.getCellStoreValue(i, "portname", "portname");
            ptag.value = portname;
            obj["portname"] = ptag;
            
            ptag = new ParamTag();
            ptag.value = porttype;
            if (tagtype != tagType_SAwared && paporttype == "uni") 
            {
                ptag.value == "1";
            }
            obj["porttype"] = ptag;
            
            ptag = new ParamTag();
            var cvlan = ct.getCellStoreValue(i, "tagID", "tagID");
            ptag.value = cvlan;
            obj["tagID"] = ptag;
            
            ptag = new ParamTag();
            var svlan = ct.getCellStoreValue(i, "svlan", "svlan");
            ptag.value = svlan;
            obj["svlan"] = ptag;
            
            var portAttributeArray = getPortAttribute(slotid, portid);
            if (tagtype == tagType_CAwared) 
            {
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[6] != null && portAttributeArray[6] != "undefined") 
                {
                    ptag.value = portAttributeArray[6];
                }
                else 
                {
                    ptag.value = "1";
                }
                obj["portEnable"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null) 
                {
                    ptag.value = portAttributeArray[0];
                }
                else 
                {
                    ptag.value = "0";
                }
                obj["workMode"] = ptag;
                ptag = new ParamTag();
                if (portAttributeArray != null) 
                {
                    ptag.value = portAttributeArray[1];
                }
                else 
                {
                    ptag.value = "1";
                }
                obj["encapType"] = ptag;
                ptag = new ParamTag();
                if (portAttributeArray != null) 
                {
                    ptag.value = portAttributeArray[2];
                }
                else 
                {
                    ptag.value = "1";
                }
                obj["tag"] = ptag;
                ptag = new ParamTag();
				if(portAttributeArray!=null)
				{
					ptag.value = portAttributeArray[3];
				}
				else
				{
					ptag.value = "1";
				}
                obj["vlanID"] = ptag;
                ptag = new ParamTag();
				if(portAttributeArray!=null)
				{
					ptag.value = portAttributeArray[4];
				}
				else
				{
					ptag.value = "0";
				}
                obj["vlanPri"] = ptag;

            }
            else if (tagtype == tagType_SAwared) 
            {
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[6] != null && portAttributeArray[6] != "undefined") 
                {
                    ptag.value = portAttributeArray[6];
                }
                else 
                {
                    ptag.value = "1";
                }
                obj["portEnable"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null) 
                {
                    ptag.value = portAttributeArray[0];
                }
                else 
                {
                    ptag.value = "0";
                }
                obj["workMode"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null) 
                {
                    ptag.value = portAttributeArray[1];
                }
                else if (paporttype == "uni") 
                {
                    ptag.value = "1";
                }
                else 
                {
                    ptag.value = "2";
                }
                obj["encapType"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null) 
                {
                    ptag.value = portAttributeArray[2];
                }
                else 
                {
                    ptag.value = "1";
                }
                obj["tag"] = ptag;
                ptag = new ParamTag();
				if(portAttributeArray!=null)
				{
					ptag.value = portAttributeArray[3];
				}
				else
				{
					ptag.value = "1";
				}
                obj["vlanID"] = ptag;
                ptag = new ParamTag();
				if(portAttributeArray!=null)
				{
					ptag.value = portAttributeArray[4];
				}
				else
				{
					ptag.value = "0";
				}
                obj["vlanPri"] = ptag;

            }
            else 
            {
                ptag = new ParamTag();
                if (portAttributeArray != null && portAttributeArray[6] != null && portAttributeArray[6] != "undefined") 
                {
                    ptag.value = portAttributeArray[6];
                }
                else 
                {
                    ptag.value = "1";
                }
                obj["portEnable"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null) 
                {
                    ptag.value = portAttributeArray[0];
                }
                else 
                {
                    ptag.value = "0";
                }
                obj["workMode"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null) 
                {
                    ptag.value = portAttributeArray[1];
                }
                else 
                {
                    ptag.value = "0";
                }
                obj["encapType"] = ptag;
                
                ptag = new ParamTag();
                if (portAttributeArray != null) 
                {
                    ptag.value = portAttributeArray[2];
                }
                else 
                {
                    ptag.value = "1";
                }
                obj["tag"] = ptag;
                ptag = new ParamTag();
				if(portAttributeArray!=null)
				{
					ptag.value = portAttributeArray[3];
				}
				else
				{
					ptag.value = "1";
				}
                obj["vlanID"] = ptag;
                ptag = new ParamTag();
				if(portAttributeArray!=null)
				{
					ptag.value = portAttributeArray[4];
				}
				else
				{
					ptag.value = "0";
				}
                obj["vlanPri"] = ptag;

            }
            dinterface.rows.append(obj);
        }
        parobj.createTableFunc(dinterface);
        xcloseDialog();
    }
    parobj.initportparas();
    
    
}

function createServiceTag(bussinessNode)
{
    var rowParams = new tagElement("row-params");
    param = new tagElement("param");
    param.setAttribute("name", "block");
    param.setAttribute("value", "SERVICE_TAG");
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "neid");
    param.setAttribute("value", neid);
    rowParams.appendChild(param);
    
    param = new tagElement("param");
    param.setAttribute("name", "serviceTag");
    param.setAttribute("value", serviceTag);
    rowParams.appendChild(param);
    
    bussinessNode.appendChild(rowParams);
}

/***************************
 * do create port xml
 ****************************/
function createDelVuniXML(bussinessNode)
{
    if (parobj.orgPorts == "") 
    {
        return;
    }
    var rowParams = new tagElement("row-params");
    var cmdcode;
    var rowindx = 0;
    var delPortArray = getDelPortInfo(ct, iniSelectedPortData);
    for (var j = 0; j < delPortArray.length; j++) 
    {
        rowParams = new tagElement("row-params");
        var param = null;
        if (rowindx == 0) 
        {
            cmdcode = "NSCMD_SERVICE_DEL_ETHVUNI";
            param = new tagElement("param");
            param.setAttribute("name", "block");
            param.setAttribute("value", cmdcode);
            rowParams.appendChild(param);
        }
        rowindx++;
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceIndex");
        param.setAttribute("value", serviceIndex);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "vuniID");
        param.setAttribute("value", delPortArray[j].vuniID);
        rowParams.appendChild(param);
        bussinessNode.appendChild(rowParams);
    }
}

function createAddVuniXML(bussinessNode)
{
    var rowParams = new tagElement("row-params");
    var cmdcode;
    var rowindx = 0;
	/**
	 * 
	 *        
	 */
    var addPortArray = getAddPortInfo(ct, iniSelectedPortData);
    for (var i = 0, len = addPortArray.length; i < len; i++) 
    {
        var porttype = addPortArray[i].porttype;
        if (serviceTag == tagType_SAwared) 
        {
            if (porttype != portType_Pbnni) 
            {
                continue;
            }
        }
        else 
        {
            if (porttype != portType_Uni) 
            {
                continue;
            }
        }
        
        rowParams = new tagElement("row-params");
        var param = null;
        if (rowindx == 0) 
        {
            cmdcode = "NSCMD_SERVICE_ADD_ETHVUNI_EX";
            param = new tagElement("param");
            param.setAttribute("name", "block");
            param.setAttribute("value", cmdcode);
            rowParams.appendChild(param);
        }
        rowindx++;
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "autoServiceIndex");
        param.setAttribute("value", "0");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceIndex");
        param.setAttribute("value", serviceIndex);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "autoVuniID");
        param.setAttribute("value", "1");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "vuniID");
        param.setAttribute("value", porttype == portType_Pbnni ? vnniID++ : vuniID++);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "role");
        param.setAttribute("value", "1");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", addPortArray[i].slotid);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        param.setAttribute("value", "255");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portid");
        param.setAttribute("value", addPortArray[i].portid);
        rowParams.appendChild(param);
        
        var tagNum, tagID;
        if (serviceTag == tagType_SAwared) 
        {
            tagID = addPortArray[i].svlan;
        }
        else 
        {
            tagID = addPortArray[i].tagID;
        }
        
        param = new tagElement("param");
        param.setAttribute("name", "svlan");
        param.setAttribute("value", addPortArray[i].svlan);
        rowParams.appendChild(param);
		
        if (tagID == undefined || tagID == "undefined") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else if (tagID == "-") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else 
        {
            tagNum = tagID.split(",").length;
        }
        
        var isValide = validataTagList(tagID);
        if (isValide == -1) 
        {
            bIsValidateVlanID = false;
            return;
        }

        var tagIDDataArr = getTagListData(tagID);
        param = new tagElement("param");
        param.setAttribute("name", "tagNum");
        param.setAttribute("value", tagIDDataArr[0]);
        rowParams.appendChild(param);
    	
        param = new tagElement("param");
        param.setAttribute("name", "tagID");
        param.setAttribute("value", tagIDDataArr[1]);
        rowParams.appendChild(param);

        var portAttrs = getPortAttribute(addPortArray[i].slotid, addPortArray[i].portid);
        if(portAttrs != null)
        {
	        var portEnable, workMode;
	        
	        portEnable = portAttrs[6];
	        if(portEnable == null || portEnable == undefined)
	        {
	            portEnable = "1";
	        }
	        
	        workMode = portAttrs[0];
	        if(workMode == null || workMode == undefined)
	        {
	            workMode = "0";
	        }
	
	        
	        if( addPortArray[i].slotid != "65535" )
	        {
	        param = new tagElement("param");
	        param.setAttribute("name", "portEnable");
	        param.setAttribute("value", portEnable);
	        rowParams.appendChild(param);
	        
	        param = new tagElement("param");
	        param.setAttribute("name", "workMode");
	        param.setAttribute("value", workMode);
	        rowParams.appendChild(param);
	        }
        }
        
        var encapType, tag;
        tag = "1";
        if (tagtype == tagType_CAwared) 
        {
            encapType = "1";
        }
        else if (tagtype == tagType_SAwared) 
        {
            encapType = "2";
        }
        else 
        {
            encapType = "0";
        }
        param = new tagElement("param");
        param.setAttribute("name", "encapType");
        param.setAttribute("value", encapType);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "tag");
        param.setAttribute("value", tag);
        rowParams.appendChild(param);
        bussinessNode.appendChild(rowParams);
    }
}

function createAddPBVUniXML(bussinessNode)
{

    var rowParams = new tagElement("row-params");
    var cmdcode;
    var rowindx = 0;
	/**
	 * 
	 *        
	 */
    var addPortArray = getAddPortInfo(ct, iniSelectedPortData);
    for (var i = 0, len = addPortArray.length; i < len; i++) 
    {
    	var boardName = addPortArray[i].boardName;
        var porttype = addPortArray[i].porttype;
        if (!(porttype == portType_Pbuni || porttype == portType_Pbsuni)) 
        {
            continue;
        }
        rowParams = new tagElement("row-params");
        var param = null;
        if (rowindx == 0) 
        {
            cmdcode = "NSCMD_CFG_SERVICE_ADD_ETHPBVUNI_EX";
            param = new tagElement("param");
            param.setAttribute("name", "block");
            param.setAttribute("value", cmdcode);
            rowParams.appendChild(param);
        }
        rowindx++;
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "autoServiceIndex");
        param.setAttribute("value", "0");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceIndex");
        param.setAttribute("value", serviceIndex);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "autoVuniID");
        param.setAttribute("value", "1");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "vuniID");
        param.setAttribute("value", porttype == portType_Pbnni ? vnniID++ : vuniID++);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "role");
        param.setAttribute("value", "1");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", addPortArray[i].slotid);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        param.setAttribute("value", "255");
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "portid");
        param.setAttribute("value", addPortArray[i].portid);
        rowParams.appendChild(param);
        
        var svlan = addPortArray[i].svlan;
        param = new tagElement("param");
        param.setAttribute("name", "svlan");
        param.setAttribute("value", svlan == undefined ? 0 : svlan);
        rowParams.appendChild(param);
        
        var tagNum = 0
        var tagID = addPortArray[i].tagID;
        if (tagID != undefined) 
        {
            tagNum = addPortArray[i].tagID.split(",").length;
        }
        
        if (tagID == undefined || tagID == "undefined") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else if (tagID == "-") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else 
        {
            tagNum = tagID.split(",").length;
        }
        
        var isValide = validataTagList(tagID);
        if (isValide == -1) 
        {
            bIsValidateVlanID = false;
            return;
        }
        var tagIDDataArr = getTagListData(tagID);
        param = new tagElement("param");
        param.setAttribute("name", "tagNum");
        param.setAttribute("value", tagIDDataArr[0]);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "tagID");
        param.setAttribute("value", tagIDDataArr[1]);
        rowParams.appendChild(param);
        
        var portAttrs = getPortAttribute(addPortArray[i].slotid, addPortArray[i].portid);
        if(portAttrs != null)
        {
            var portEnable, workMode;
            
            portEnable = portAttrs[6];
	    if(portEnable == null || portEnable == undefined)
	    {
	        portEnable = "1";
	    }
	    
	    workMode = portAttrs[0];
	    if(workMode == null || workMode == undefined)
	    {
	        workMode = "0";
	    }
	
        if (!isSupportWorkModeBoard(boardName)) 
        {
        	portEnable = "-";
        	workMode = "-";
        }
        
	
	    param = new tagElement("param");
            param.setAttribute("name", "portEnable");
            param.setAttribute("value", portEnable);
            rowParams.appendChild(param);
	    
	    param = new tagElement("param");
            param.setAttribute("name", "workMode");
            param.setAttribute("value", workMode);
            rowParams.appendChild(param);
        }
        
        var encapType, tag;
        tag = "1";
        
        if (tagtype == tagType_CAwared) 
        {
            encapType = "1";
        }
        else 
        {
            encapType = "0";
        }
        
        if (tagtype != tagType_SAwared) 
        {
            param = new tagElement("param");
            param.setAttribute("name", "encapType");
            param.setAttribute("value", encapType);
            rowParams.appendChild(param);
        }
        
        param = new tagElement("param");
        param.setAttribute("name", "tag");
        param.setAttribute("value", tag);
        rowParams.appendChild(param);
        
        bussinessNode.appendChild(rowParams);
    }
}


/**
 * IF and EFP8 and isx2 and isu2 NOT support
 * @param {Object} boardname
 */
function isSupportWorkModeBoard(boardname)
{
    if (boardname.indexOf("IF") >= 0 ||
    boardname.indexOf("EFP8") >= 0 ||
    boardname.indexOf("EMS6") >= 0 ||
    boardname.indexOf("ISX2") >= 0 ||
    boardname.indexOf("ISU2") >= 0 ||
    boardname.indexOf("ISV3") >= 0 ||
    boardname.indexOf("ISU3") >= 0 ) 
    {
        return false
    }
    return true;
}
function getRowIndexFormPortArray(table, portArray)
{
    var slotid = portArray[1];
    var portid = portArray[3];
    for (var i = 0; i < table.getDataRowLength(); i++) 
    {
        if (table.getCellStoreValue(i, "slotid", "slotid") == slotid &&
        table.getCellStoreValue(i, "portid", "portid") == portid) 
        {
            return i;
        }
    }
}

/**
 *                      
 * @param {Object} portObject
 * @param {Object} table
 */
function findObjectFromTable(portObject, table)
{
    var slotid = portObject["slotid"].value;
    var portid = portObject["portid"].value;
    var tagID = portObject["tagID"].value;
    var svlan = portObject["svlan"].value;
    var vuniID = portObject["vuniID"].value;
    
    for (var i = 0; i < table.getDataRowLength(); i++) 
    {
        var curPortType = table.getCellStoreValue(i, "porttype", "porttype");
        if (
        (table.getCellStoreValue(i, "slotid", "slotid") == slotid &&
        table.getCellStoreValue(i, "portid", "portid") == portid && tagType_SAwared == serviceTag &&
         (
         table.getCellStoreValue(i, "svlan", "svlan") == svlan && (curPortType == portType_Pbsuni
         || curPortType == portType_Pbuni) || curPortType == portType_Pbnni
         )
        )
        || (table.getCellStoreValue(i, "slotid", "slotid") == slotid &&
        table.getCellStoreValue(i, "portid", "portid") == portid && tagType_SAwared != serviceTag)) 
        {
            return i;
        } 
    }
    return null;
    
}

/**
 *                      
 * @param {Object} portArray
 * @param {Object} portObject
 */
function findObjectFromPortArray(portArray, portObject)
{
    var didatalength = portArray.getDataRowLength();
    for (var i = 0; i < didatalength; i++) 
    {
        var row = portArray.getDataRow(i);
        if (row["slotid"].value == portObject.slotid &&
        row["portid"].value == portObject.portid) 
        {
            return row;
        }
    }
    return null;
}

/**
 *            
 * @param {Object} table
 * @param {Object} portData
 */
function getAddPortInfo(table, portData)
{
    var addPortArr = new Array();
    for (var i = 0; i < table.getDataRowLength(); i++) 
    {
        var portObject = new Object()
        portObject.slotid = table.getCellStoreValue(i, "slotid", "slotid");
        portObject.portid = table.getCellStoreValue(i, "portid", "portid");
        portObject.tagID = table.getCellStoreValue(i, "tagID", "tagID");
        portObject.svlan = table.getCellStoreValue(i, "svlan", "svlan");
        portObject.porttype = table.getCellStoreValue(i, "porttype", "porttype");
        portObject.boardName = table.getCellStoreValue(i, "boardName", "boardName");
        
        var row;
        if(serviceTag != tagType_SAwared)
        {
            row = findObjectFromPortArray(portData, portObject);
        } else {
            row = findPbObjectFromPortArray(portData, portObject);
        }
        
        
        if (row == null) 
        {
            addPortArr.push(portObject);
        }
		
    }
	return addPortArr;
}

/**
 *            
 * @param {Object} table
 * @param {Object} portData
 */
function getDelPortInfo(table, portData)
{
    var delPortArr = new Array();
    var didatalength = portData.getDataRowLength();
    for (var i = 0; i < didatalength; i++) 
    {
        var row = portData.getDataRow(i);
        var deleteRow = findObjectFromTable(row, table);
        if (deleteRow == null) 
        {
            var portObject = new Object()
            portObject.slotid = row["slotid"].value;
            portObject.portid = row["portid"].value;
            portObject.tagID = row["tagID"].value;
            portObject.svlan = row["svlan"].value;
            portObject.vuniID = row["vuniID"].value;
            delPortArr.push(portObject);
        }
    }
    return delPortArr;
}

/***************************
 * do create uni/nni port
 ****************************/
function doCreateBack(doc)
{
    var data = EncapsulateData(doc);
    showErrorDialog(data);
    if (data.getSErrorCode() == 0) 
    {
        parobj.query();
        xcloseDialog();
    }
}

function showErrorDialog(di)
{
    var errArr = [];
    var errorObj = null;
    for (var i = di.getBErrLength() - 1; i >= 0; i--) 
    {
    	if(di.getError().rowErrors[i].error.code == 38737)
    	{
    		di.getError().rowErrors.removeAt(i);
    	}else{
    		errorObj = di.getError().rowErrors[i].errorObj;
            errorObj["operationObj"] = RESOURCE["serviceID"] + ":" + parobj.parobj.serviceID;
    	} 
    }
    
    if(di.getBErrLength() <= 0)
    {
    	di.getError().s_error.code = 0;
    }
    errArr[0] = "operationObj";
    openErrPage("../../../../../../page/", di.getError(), errArr);
}

/**
 *                            
 */
function getPortNeAttr()
{
    var xmlData = createGetPortAttriXml();
    var urlstr = "../../../../../../neExlorerServlet?sfid=" + TECMDCODE_GET_ETHPORTATTRIB + "&flag=1&timestamp=" + new Date().getTime() + "&nmUser=" + parobj.parobj.obj["nmUser"];
    loadXMLdoc(urlstr, "POST", false, callbackGetPortAttri, null, "inputdata=" + xmlData);
}
function createGetPortAttriXml()
{
       
    var di = new inputxml("datainterface");
    var bussiness = new tagElement("bussiness-params");
    
    var row = new tagElement("row-params");
        var param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        row.appendChild(param);
        param = new tagElement("param");
        param.setAttribute("name", "slotid");
        param.setAttribute("value", g_slotid);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "subslotid");
        param.setAttribute("value", 255);
        row.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "port");
        param.setAttribute("value", 0);
        row.appendChild(param);
        bussiness.appendChild(row);

    di.getRoot().appendChild(bussiness);

    return di.toString();
}

function callbackGetPortAttri(doc)
{
    var data = EncapsulateData(doc);
    if (0 == data.getSErrorCode() || 1 == data.getSErrorCode()) 
    {
        portAttrArr[g_slotid] = data;
    }
}

/**
 *                
 * @param {Object} slotid
 * @param {Object} portid
 */
function getPortAttribute(slotid, portid)
{
	var neAttributeData = portAttrArr[slotid];
    if (typeof(neAttributeData) == "undefined" || neAttributeData == null) 
    {
        return null;
    }
    for (var i = 0, len = neAttributeData.getDataRowLength(); i < len; i++) 
    {
        if (null != neAttributeData.getDataRowParam(i, "slotid") && slotid == neAttributeData.getDataRowParam(i, "slotid") &&
        null != neAttributeData.getDataRowParam(i, "port") &&
        portid == neAttributeData.getDataRowParam(i, "port")) 
        {
            var portArr = new Array();
            portArr[0] = neAttributeData.getDataRowParam(i, "ATTR_ETHOVERPTN_MAC_WORKMODE");
            portArr[1] = neAttributeData.getDataRowParam(i, "ATTR_ETHOVERPTN_MAC_ENCAP_TYPE");
            portArr[2] = neAttributeData.getDataRowParam(i, "ATTR_ETHOVERPTN_MAC_TAG");
			portArr[3]=neAttributeData.getDataRowParam(i, "vlanID");
			portArr[4]=neAttributeData.getDataRowParam(i, "vlanPri");
			
			portArr[5]=neAttributeData.getDataRowParam(i, "SDHPORT_ATTR_MODE");
			
			portArr[6] = neAttributeData.getDataRowParam(i, "ATTR_ETHOVERPTN_MAC_ENABLE");
            return portArr;
        }
    }
    return null;
}


function createModifyVuniXML(bussinessNode)
{
    var rowParams = new tagElement("row-params");
    var cmdcode;
    var rowindx = 0;
	/**
	 * 
	 *        
	 */
    var modifyPortArray = getModifyPortInfo(ct, iniSelectedPortData);
    for (var i = 0, len = modifyPortArray.length; i < len; i++) 
    {        
        rowParams = new tagElement("row-params");
        var param = null;
        if (rowindx == 0) 
        {
            cmdcode = "NSCMD_SERVICE_SET_ETHVUNITAG";
            param = new tagElement("param");
            param.setAttribute("name", "block");
            param.setAttribute("value", cmdcode);
            rowParams.appendChild(param);
        }
        rowindx++;
        
        param = new tagElement("param");
        param.setAttribute("name", "neid");
        param.setAttribute("value", neid);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "serviceIndex");
        param.setAttribute("value", serviceIndex);
        rowParams.appendChild(param);

        param = new tagElement("param");
        param.setAttribute("name", "vuniID");
        param.setAttribute("value", modifyPortArray[i].vuniID);
        rowParams.appendChild(param);

        
        var tagNum, tagID;
        if (serviceTag == tagType_SAwared && modifyPortArray[i].porttype == portType_Pbnni) 
        {
            tagID = modifyPortArray[i].svlan;
        }
        else 
        {
            tagID = modifyPortArray[i].tagID;
        }
        
        param = new tagElement("param");
        param.setAttribute("name", "svlan");
        param.setAttribute("value", modifyPortArray[i].svlan);
        rowParams.appendChild(param);
		
        if (tagID == undefined || tagID == "undefined") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else if (tagID == "-") 
        {
            tagNum = 0;
            tagID = 0;
        }
        else 
        {
            tagNum = tagID.split(",").length;
        }
        
        var isValide = validataTagList(tagID);
        if (isValide == -1) 
        {
            bIsValidateVlanID = false;
            return;
        }
        
        var tagIDDataArr = getTagListData(tagID);
        param = new tagElement("param");
        param.setAttribute("name", "tagNum");
        param.setAttribute("value", tagIDDataArr[0]);
        rowParams.appendChild(param);
        
        param = new tagElement("param");
        param.setAttribute("name", "tagID");
        param.setAttribute("value", tagIDDataArr[1]);
        rowParams.appendChild(param);
        
       /** param = new tagElement("param");
        param.setAttribute("name", "tag");
        param.setAttribute("value", tag);
        rowParams.appendChild(param);**/
        
        bussinessNode.appendChild(rowParams);
    }
}

/**
 *            
 * @param {Object} table
 * @param {Object} portData
 */
function getModifyPortInfo(table, portData)
{
    var modifyPortArr = new Array();
    for (var i = 0; i < table.getDataRowLength(); i++) 
    {
        var portObject = new Object()
        portObject.slotid = table.getCellStoreValue(i, "slotid", "slotid");
        portObject.portid = table.getCellStoreValue(i, "portid", "portid");
        portObject.tagID = table.getCellStoreValue(i, "tagID", "tagID");
        portObject.svlan = table.getCellStoreValue(i, "svlan", "svlan");
        portObject.porttype = table.getCellStoreValue(i, "porttype", "porttype");
        portObject.vuniID = table.getCellStoreValue(i, "vuniID", "vuniID");
        var row = findModifyObjectFromPortArray(portData, portObject);
        if (row != null) 
        {
            modifyPortArr.push(portObject);
        }
		
    }
    
    return modifyPortArr;
}


/**
 *  PB                         
 * @param {Object} portArray
 * @param {Object} portObject
 */
function findPbObjectFromPortArray(portArray, portObject)
{
    var didatalength = portArray.getDataRowLength();
    for (var i = 0; i < didatalength; i++) 
    {
        var row = portArray.getDataRow(i);
        if (row["slotid"].value == portObject.slotid &&
        row["portid"].value == portObject.portid &&
        (row["svlan"].value == portObject.svlan &&  (portObject.porttype == portType_Pbsuni
         || portObject.porttype == portType_Pbuni) || portObject.porttype == portType_Pbnni
        ) 
        )
        {
            return row;
        }
    }
    return null;
}

/**
 *                          
 * @param {Object} portArray
 * @param {Object} portObject
 */
function findModifyObjectFromPortArray(portArray, portObject)
{
    var didatalength = portArray.getDataRowLength();
    for (var i = 0; i < didatalength; i++) 
    {
        var row = portArray.getDataRow(i);
        if(
             row["slotid"].value == portObject.slotid && row["portid"].value == portObject.portid && 
             (
                row["tagID"].value != portObject.tagID && row["svlan"].value == portObject.svlan &&  
                (
                   portObject.porttype == portType_Pbsuni || portObject.porttype == portType_Pbuni
                )
                || row["tagID"].value != portObject.tagID && portObject.porttype != portType_Pbsuni && portObject.porttype != portType_Pbuni && portObject.porttype != portType_Pbnni
                || row["svlan"].value != portObject.svlan && portObject.porttype == portType_Pbnni
             )
          ) 
        {
            return row;
        }
    }
    return null;
}
